/*
 * Decompiled with CFR 0.152.
 */
package com.google.cast;

import android.app.PendingIntent;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v7.media.MediaItemStatus;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import com.google.cast.ApplicationChannel;
import com.google.cast.ApplicationMetadata;
import com.google.cast.ApplicationSession;
import com.google.cast.CastContext;
import com.google.cast.CastDevice;
import com.google.cast.ContentMetadata;
import com.google.cast.Logger;
import com.google.cast.MediaProtocolCommand;
import com.google.cast.MediaProtocolMessageStream;
import com.google.cast.MimeData;
import com.google.cast.R;
import com.google.cast.SessionError;
import com.google.cast.a;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

final class b
extends com.google.cast.a {
    private static final MimeData b = null;
    private static final String[] c = new String[]{"audio/*", "image/*", "video/*"};
    private static final String[] d = new String[]{"android.media.intent.action.PAUSE", "android.media.intent.action.RESUME", "android.media.intent.action.STOP", "android.media.intent.action.SEEK", "android.media.intent.action.GET_STATUS"};
    private static final Set<String> e = new HashSet<String>();
    private static final Logger f;
    private String g = "GoogleCastPlayer";
    private MimeData h = b;
    private int i;
    private boolean j;

    public b(CastContext castContext, String string2, MimeData mimeData, int n2, boolean bl) {
        super(castContext);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.g = string2;
            this.h = mimeData;
        }
        this.i = n2;
        this.j = bl;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addCategory("android.media.intent.category.REMOTE_PLAYBACK");
        intentFilter.addAction("android.media.intent.action.PLAY");
        intentFilter.addDataScheme("http");
        intentFilter.addDataScheme("https");
        for (String string3 : c) {
            com.google.cast.b.a(intentFilter, string3);
        }
        this.a(intentFilter);
        for (String string3 : d) {
            intentFilter = new IntentFilter();
            intentFilter.addCategory("android.media.intent.category.REMOTE_PLAYBACK");
            intentFilter.addAction(string3);
            this.a(intentFilter);
        }
    }

    @Override
    protected a.a a(CastDevice castDevice, String string2) {
        return new a(castDevice, string2);
    }

    private Bundle a(JSONObject jSONObject) {
        Bundle bundle = new Bundle();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            try {
                String string2 = (String)iterator.next();
                Object object = jSONObject.get(string2);
                if (object == JSONObject.NULL) {
                    bundle.putParcelable(string2, null);
                    continue;
                }
                if (object instanceof String) {
                    bundle.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof Boolean) {
                    bundle.putBoolean(string2, ((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof Integer) {
                    bundle.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    bundle.putLong(string2, ((Long)object).longValue());
                    continue;
                }
                if (object instanceof Double) {
                    bundle.putDouble(string2, ((Double)object).doubleValue());
                    continue;
                }
                if (!(object instanceof JSONObject)) continue;
                bundle.putBundle(string2, this.a((JSONObject)object));
            }
            catch (JSONException jSONException) {}
        }
        return bundle;
    }

    private JSONObject a(Bundle bundle, Set<String> set) {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            if (set.contains(string2)) continue;
            Object object = bundle.get(string2);
            try {
                if (object instanceof Bundle) {
                    jSONObject.put(string2, (Object)this.a((Bundle)object, set));
                    continue;
                }
                jSONObject.put(string2, object);
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject;
    }

    static {
        e.add("android.media.intent.extra.ITEM_ID");
        e.add("android.media.intent.extra.ITEM_STATUS");
        e.add("android.media.intent.extra.ITEM_POSITION");
        e.add("android.media.intent.extra.ITEM_METADATA");
        e.add("android.media.intent.extra.ITEM_STATUS_UPDATE_RECEIVER");
        f = new Logger("CastMediaRouteProvider");
    }

    private class b {
        public Intent a;
        public MediaRouter.ControlRequestCallback b;

        public b(Intent intent, MediaRouter.ControlRequestCallback controlRequestCallback) {
            this.a = intent;
            this.b = controlRequestCallback;
        }
    }

    private final class a
    extends a.a
    implements ApplicationSession.Listener,
    MediaProtocolCommand.Listener {
        private ApplicationSession e;
        private MediaProtocolMessageStream f;
        private LinkedList<MediaProtocolCommand> g;
        private Map<String, PendingIntent> h;
        private b i;
        private String j;
        private double k;
        private boolean l;
        private boolean m;
        private Runnable n;
        private long o;
        private boolean p;

        public a(CastDevice castDevice, String string2) {
            super(castDevice, string2);
            this.k = -1.0;
            this.g = new LinkedList();
            this.h = new HashMap<String, PendingIntent>();
            this.n = new Runnable(){

                @Override
                public void run() {
                    a.this.c();
                }
            };
            this.o = 0L;
        }

        public void onSelect() {
            f.d("Selected device", new Object[0]);
            this.c();
        }

        public void onUnselect() {
            f.d("Unselected device", new Object[0]);
            b.this.getHandler().removeCallbacks(this.n);
            if (this.e != null) {
                try {
                    this.e.setStopApplicationWhenEnding(b.this.j);
                    if (this.e.endSession()) {
                        this.a(3);
                    }
                }
                catch (IOException iOException) {
                    f.e(iOException, "Exception while ending session", new Object[0]);
                    this.e = null;
                }
            }
        }

        public void onSetVolume(int volume) {
            f.d("onSetVolume() volume=%d, mRampStream=%s", volume, this.f);
            if (this.f == null) {
                return;
            }
            try {
                double d2 = (double)volume / 20.0;
                this.d();
                this.a(this.f.setVolume(d2), null);
            }
            catch (IllegalStateException illegalStateException) {
                f.d("can't process command; %s", illegalStateException.getMessage());
            }
            catch (IOException iOException) {
                f.d("can't process command; %s", iOException.getMessage());
            }
        }

        public void onUpdateVolume(int delta) {
            f.d("onUpdateVolume() delta=%d, mRampStream=%s", delta, this.f);
            if (this.f == null) {
                return;
            }
            try {
                this.d();
                double d2 = (double)(this.a() + delta) / 20.0;
                this.a(this.f.setVolume(d2), null);
            }
            catch (IllegalStateException illegalStateException) {
                f.d("can't process command; %s", illegalStateException.getMessage());
            }
            catch (IOException iOException) {
                f.d("can't process command; %s", iOException.getMessage());
            }
        }

        private void c() {
            block6: {
                f.d("startSession(); mSession=%s", this.e);
                if (this.e == null || !this.e.isResumable()) {
                    f.d("starting a new session", new Object[0]);
                    this.e = new ApplicationSession(b.this.a, this.a);
                    this.e.setListener(this);
                    this.e.setApplicationOptions(b.this.i);
                    try {
                        this.e.startSession(b.this.g, b.this.h);
                        this.a(1);
                    }
                    catch (IOException iOException) {
                        this.e = null;
                        this.f();
                    }
                } else {
                    f.d("resuming an existing session", new Object[0]);
                    try {
                        this.e.resumeSession();
                        this.a(1);
                    }
                    catch (IOException iOException) {
                        if (this.f()) break block6;
                        this.e();
                        this.e = null;
                    }
                }
            }
        }

        private void d() throws IllegalStateException {
            if (this.g.size() >= 50) {
                throw new IllegalStateException("command backlog is full");
            }
        }

        private void a(String string2) throws IllegalStateException {
            if (this.j != null && !this.j.equals(string2)) {
                throw new IllegalStateException("item ID does not match");
            }
        }

        private void a(MediaProtocolCommand mediaProtocolCommand, MediaRouter.ControlRequestCallback controlRequestCallback) {
            mediaProtocolCommand.setListener(this);
            if (controlRequestCallback != null) {
                mediaProtocolCommand.putUserObject("cb", controlRequestCallback);
            }
            this.g.add(mediaProtocolCommand);
        }

        public boolean onControlRequest(Intent intent, MediaRouter.ControlRequestCallback callback) {
            f.d("Received control request %s", intent);
            if (this.p) {
                f.d("Got a request while reconnecting, so rejecting it", new Object[0]);
                callback.onError(b.this.getContext().getString(R.string.error_no_session), null);
                return false;
            }
            if (intent.hasCategory("android.media.intent.category.REMOTE_PLAYBACK")) {
                b b2 = new b(intent, callback);
                return this.a(b2);
            }
            return false;
        }

        private boolean a(b b2) {
            block32: {
                f.d("processRemotePlaybackRequest(); mSession=%s", this.e);
                if (this.e == null) {
                    this.i = b2;
                    this.c();
                    return true;
                }
                if (this.e.isStarting()) {
                    f.d("session is starting, so saving request for later", new Object[0]);
                    this.i = b2;
                    return true;
                }
                if (this.f == null) {
                    f.d("ramp stream is null, so calling onError", new Object[0]);
                    b2.b.onError(b.this.getContext().getString(R.string.error_no_session), null);
                    return false;
                }
                Intent intent = b2.a;
                MediaRouter.ControlRequestCallback controlRequestCallback = b2.b;
                String string2 = intent.getAction();
                try {
                    if (string2.equals("android.media.intent.action.PLAY") && intent.getData() != null) {
                        boolean bl;
                        long l2;
                        this.d();
                        Uri uri = intent.getData();
                        if (uri == null) {
                            return false;
                        }
                        f.d("Device received play request, uri %s", uri);
                        String string3 = UUID.randomUUID().toString();
                        ContentMetadata contentMetadata = new ContentMetadata();
                        JSONObject jSONObject = b.this.a(intent.getExtras(), e);
                        contentMetadata.setContentInfo(jSONObject);
                        Bundle bundle = intent.getBundleExtra("android.media.intent.extra.ITEM_METADATA");
                        if (bundle != null) {
                            String string4;
                            if (bundle.containsKey("android.media.metadata.TITLE") && (string4 = bundle.getString("android.media.metadata.TITLE")) != null) {
                                contentMetadata.setTitle(string4);
                            }
                            if (bundle.containsKey("android.media.metadata.ARTWORK_URI") && !TextUtils.isEmpty((CharSequence)(string4 = bundle.getString("android.media.metadata.ARTWORK_URI")))) {
                                contentMetadata.setImageUrl(Uri.parse((String)string4));
                            }
                            if (bundle.containsKey("android.media.metadata.ARTIST") && (string4 = bundle.getString("android.media.metadata.ARTIST")) != null) {
                                try {
                                    jSONObject.put("artist", (Object)string4);
                                }
                                catch (JSONException jSONException) {
                                    // empty catch block
                                }
                            }
                            if (bundle.containsKey("android.media.metadata.ALBUM_TITLE") && (string4 = bundle.getString("android.media.metadata.ALBUM_TITLE")) != null) {
                                try {
                                    jSONObject.put("album_title", (Object)string4);
                                }
                                catch (JSONException jSONException) {}
                            }
                        } else {
                            f.d("No content metadata!", new Object[0]);
                        }
                        if ((l2 = intent.getLongExtra("android.media.intent.extra.ITEM_POSITION", 0L)) > 0L) {
                            this.k = this.a(l2);
                            bl = false;
                        } else {
                            this.k = -1.0;
                            bl = true;
                        }
                        PendingIntent pendingIntent = (PendingIntent)intent.getParcelableExtra("android.media.intent.extra.ITEM_STATUS_UPDATE_RECEIVER");
                        f.d("Got a pending intent for status updates: %s", pendingIntent);
                        if (pendingIntent != null) {
                            this.h.put(string3, pendingIntent);
                        }
                        MediaProtocolCommand mediaProtocolCommand = this.f.loadMedia(uri.toString(), contentMetadata, bl);
                        f.d("attaching item ID to command: %s", string3);
                        mediaProtocolCommand.putUserObject("itemid", string3);
                        this.m = true;
                        this.a(mediaProtocolCommand, null);
                        Bundle bundle2 = new Bundle();
                        bundle2.putString("android.media.intent.extra.ITEM_ID", string3);
                        MediaItemStatus mediaItemStatus = new MediaItemStatus.Builder(3).setTimestamp(SystemClock.uptimeMillis()).build();
                        bundle2.putBundle("android.media.intent.extra.ITEM_STATUS", mediaItemStatus.asBundle());
                        controlRequestCallback.onResult(bundle2);
                        break block32;
                    }
                    if (string2.equals("android.media.intent.action.PAUSE")) {
                        this.f.stop();
                        this.l = true;
                        break block32;
                    }
                    if (string2.equals("android.media.intent.action.RESUME")) {
                        this.d();
                        f.d("resume; pending seek position is %f", this.k);
                        if (this.k >= 0.0) {
                            double d2 = this.k;
                            this.k = -1.0;
                            this.a(this.f.playFrom(d2), controlRequestCallback);
                        } else {
                            this.a(this.f.resume(), controlRequestCallback);
                        }
                        break block32;
                    }
                    if (string2.equals("android.media.intent.action.STOP")) {
                        this.f.stop();
                        break block32;
                    }
                    if (string2.equals("android.media.intent.action.SEEK")) {
                        this.d();
                        this.a(intent.getStringExtra("android.media.intent.extra.ITEM_ID"));
                        long l3 = intent.getLongExtra("android.media.intent.extra.ITEM_POSITION", 0L);
                        if (this.f.getPlayerState() != MediaProtocolMessageStream.PlayerState.PLAYING) {
                            f.d("saving pending seek position of %d ms", l3);
                            this.k = this.a(l3);
                        } else {
                            f.d("seeking to %d ms", l3);
                            this.a(this.f.playFrom(this.a(l3)), controlRequestCallback);
                        }
                        break block32;
                    }
                    if (string2.equals("android.media.intent.action.GET_STATUS")) {
                        String string5 = intent.getStringExtra("android.media.intent.extra.ITEM_ID");
                        this.a(string5);
                        if (this.f != null) {
                            Bundle bundle = new Bundle();
                            bundle.putParcelable("android.media.intent.extra.ITEM_STATUS", (Parcelable)this.g());
                            controlRequestCallback.onResult(bundle);
                        } else {
                            controlRequestCallback.onError(b.this.getContext().getString(R.string.error_no_session), null);
                        }
                        break block32;
                    }
                    return false;
                }
                catch (IllegalStateException illegalStateException) {
                    f.d("can't process command; %s", illegalStateException.getMessage());
                    return false;
                }
                catch (IOException iOException) {
                    f.d(iOException, "can't send RAMP command", new Object[0]);
                    controlRequestCallback.onError(b.this.getContext().getString(R.string.error_ramp_command_failed), null);
                    return false;
                }
            }
            return true;
        }

        private double a(long l2) {
            return (double)l2 / 1000.0;
        }

        private long b(double d2) {
            return (long)(d2 * 1000.0);
        }

        @Override
        public void onSessionEnded(SessionError error) {
            f.d("onSessionEnded; error=%s", error);
            if (this.i != null) {
                this.i.b.onError(b.this.getContext().getString(R.string.error_session_ended), null);
                this.i = null;
            }
            if (error != null) {
                this.o = SystemClock.uptimeMillis();
                if (!this.f()) {
                    this.e();
                    this.h.clear();
                    this.e = null;
                }
            } else {
                this.e = null;
                this.j = null;
                this.h.clear();
                this.a(4);
            }
            this.g.clear();
            this.f = null;
            this.k = -1.0;
            this.l = false;
            this.m = false;
        }

        private void e() {
            if (this.j != null) {
                f.d("invalidating item %s", this.j);
                PendingIntent pendingIntent = this.h.get(this.j);
                if (pendingIntent != null) {
                    Intent intent = new Intent();
                    intent.putExtra("android.media.intent.extra.ITEM_ID", this.j);
                    MediaItemStatus mediaItemStatus = new MediaItemStatus.Builder(6).setTimestamp(SystemClock.uptimeMillis()).build();
                    intent.putExtra("android.media.intent.extra.ITEM_STATUS", mediaItemStatus.asBundle());
                    try {
                        f.d("Invoking the PendingIntent with: %s", intent);
                        pendingIntent.send(b.this.getContext(), 0, intent);
                    }
                    catch (PendingIntent.CanceledException canceledException) {
                        f.d(canceledException, "exception while sending PendingIntent", new Object[0]);
                    }
                    this.h.remove(this.j);
                }
                this.j = null;
            }
        }

        private boolean f() {
            long l2 = SystemClock.uptimeMillis();
            if (l2 - this.o < 10000L) {
                f.d("Scheduling a reconnect attempt", new Object[0]);
                this.a(5);
                b.this.getHandler().postDelayed(this.n, 3000L);
                this.p = true;
                return true;
            }
            f.d("Giving up on reconnecting route's session.", new Object[0]);
            this.a(4);
            this.p = false;
            return false;
        }

        @Override
        public void onSessionStarted(ApplicationMetadata appMetadata) {
            f.d("onSessionStarted", new Object[0]);
            this.o = 0L;
            this.p = false;
            this.f = new MediaProtocolMessageStream(){

                @Override
                protected void onStatusUpdated() {
                    f.d("onStatusUpdated; mLoadInProgress=%b, mCurrentItemId=%s", a.this.m, a.this.j);
                    if (a.this.m) {
                        return;
                    }
                    a.this.a(this.getVolume());
                    PendingIntent pendingIntent = null;
                    if (a.this.j != null) {
                        pendingIntent = (PendingIntent)a.this.h.get(a.this.j);
                        f.d("found a PendingIntent for item %s: %s", a.this.j, pendingIntent);
                    }
                    if (pendingIntent != null) {
                        String string2;
                        JSONObject jSONObject;
                        Uri uri;
                        Intent intent = new Intent();
                        intent.putExtra("android.media.intent.extra.ITEM_ID", a.this.j);
                        intent.putExtra("android.media.intent.extra.ITEM_STATUS", a.this.g());
                        Bundle bundle = new Bundle();
                        String string3 = this.getTitle();
                        if (string3 != null) {
                            bundle.putString("android.media.metadata.TITLE", string3);
                        }
                        if ((uri = this.getImageUrl()) != null) {
                            bundle.putString("android.media.metadata.ARTWORK_URI", uri.toString());
                        }
                        if ((jSONObject = this.getContentInfo()) != null && (string2 = jSONObject.optString("artist")) != null) {
                            bundle.putString("android.media.metadata.ARTIST", string2);
                        }
                        intent.putExtra("android.media.intent.extra.ITEM_METADATA", bundle);
                        try {
                            f.d("Invoking the PendingIntent with: %s", intent);
                            pendingIntent.send(b.this.getContext(), 0, intent);
                        }
                        catch (PendingIntent.CanceledException canceledException) {
                            f.d(canceledException, "exception while sending PendingIntent", new Object[0]);
                        }
                    }
                    if (a.this.f.getPlayerState() == MediaProtocolMessageStream.PlayerState.IDLE) {
                        a.this.h.remove(a.this.j);
                        f.d("player state is now IDLE; clearing mCurrentItemId", new Object[0]);
                        a.this.j = null;
                    }
                }

                @Override
                protected void onError(String errorDomain, long errorCode, JSONObject errorInfo) {
                    PendingIntent pendingIntent = null;
                    if (a.this.j != null) {
                        pendingIntent = (PendingIntent)a.this.h.get(a.this.j);
                    }
                    if (pendingIntent != null) {
                        Intent intent;
                        MediaItemStatus.Builder builder = new MediaItemStatus.Builder(7).setTimestamp(SystemClock.uptimeMillis());
                        if (errorInfo != null) {
                            intent = b.this.a(errorInfo);
                            builder.setExtras((Bundle)intent);
                        }
                        intent = new Intent();
                        intent.putExtra("android.media.intent.extra.ITEM_ID", a.this.j);
                        intent.putExtra("android.media.intent.extra.ITEM_STATUS", builder.build().asBundle());
                        try {
                            pendingIntent.send(b.this.getContext(), 0, intent);
                        }
                        catch (PendingIntent.CanceledException canceledException) {
                            f.d(canceledException, "exception while sending PendingIntent", new Object[0]);
                        }
                        a.this.h.remove(a.this.j);
                    }
                }
            };
            ApplicationChannel applicationChannel = this.e.getChannel();
            if (applicationChannel != null) {
                applicationChannel.attachMessageStream(this.f);
            } else {
                f.e("No channel in session!", new Object[0]);
            }
            if (this.i != null) {
                this.a(this.i);
                this.i = null;
            } else {
                f.d("requesting RAMP status", new Object[0]);
                try {
                    this.a(this.f.requestStatus(), null);
                }
                catch (IOException iOException) {
                    f.e(iOException, "Error while requesting RAMP status", new Object[0]);
                }
            }
            this.a(2);
        }

        @Override
        public void onSessionStartFailed(SessionError error) {
            f.d("onSessionStartFailed", new Object[0]);
            if (!this.e.isResumable()) {
                this.e = null;
            }
            this.f = null;
            if (this.i != null) {
                this.i.b.onError(b.this.getContext().getString(R.string.error_start_session_failed), null);
                this.i = null;
            }
            if (this.o == 0L) {
                this.o = SystemClock.uptimeMillis();
            }
            if (!this.f()) {
                this.e();
                this.e = null;
            }
        }

        @Override
        public void onCancelled(MediaProtocolCommand command) {
            this.g.remove(command);
        }

        @Override
        public void onCompleted(MediaProtocolCommand command) {
            this.g.remove(command);
            String string2 = command.getType();
            f.d("onCompleted; RAMP cmd is %s", string2);
            MediaRouter.ControlRequestCallback controlRequestCallback = (MediaRouter.ControlRequestCallback)command.getUserObject("cb");
            if ("LOAD".equals(string2)) {
                this.m = false;
            }
            if (!command.hasError()) {
                f.d("RAMP command %s completed successfully", string2);
                if (this.f.getPlayerState() == MediaProtocolMessageStream.PlayerState.PLAYING) {
                    this.l = false;
                }
                if ("LOAD".equals(string2)) {
                    this.j = (String)command.getUserObject("itemid");
                    f.d("mCurrentItemId is now %s", this.j);
                }
                if (this.k >= 0.0) {
                    double d2 = this.k;
                    this.k = -1.0;
                    try {
                        this.d();
                        this.a(this.f.playFrom(d2), controlRequestCallback);
                    }
                    catch (IllegalStateException illegalStateException) {
                        f.d("Cannot enqueue a pending seek; backlog full", new Object[0]);
                    }
                    catch (IOException iOException) {
                        f.d(iOException, "Cannot enqueue a pending seek", new Object[0]);
                    }
                }
            } else {
                String string3;
                PendingIntent pendingIntent;
                f.d("RAMP command %s failed", string2);
                if (controlRequestCallback != null) {
                    controlRequestCallback.onError(b.this.getContext().getString(R.string.error_ramp_command_failed), null);
                }
                if ("LOAD".equals(string2) && command.hasError() && "ramp".equals(command.getErrorDomain()) && (pendingIntent = this.h.get(string3 = (String)command.getUserObject("itemid"))) != null) {
                    MediaItemStatus.Builder builder = new MediaItemStatus.Builder(7).setTimestamp(SystemClock.uptimeMillis());
                    JSONObject jSONObject = command.getErrorInfo();
                    if (jSONObject != null) {
                        builder.setExtras(b.this.a(jSONObject));
                    }
                    Intent intent = new Intent();
                    intent.putExtra("android.media.intent.extra.ITEM_ID", string3);
                    intent.putExtra("android.media.intent.extra.ITEM_STATUS", builder.build().asBundle());
                    try {
                        pendingIntent.send(b.this.getContext(), 0, intent);
                    }
                    catch (PendingIntent.CanceledException canceledException) {
                        f.d(canceledException, "exception while sending PendingIntent", new Object[0]);
                    }
                }
            }
        }

        private Bundle g() {
            MediaProtocolMessageStream.PlayerState playerState = this.f.getPlayerState();
            int n2 = 0;
            Bundle bundle = new Bundle();
            if (this.l) {
                n2 = 2;
            } else {
                switch (playerState) {
                    case IDLE: {
                        n2 = 4;
                        break;
                    }
                    case STOPPED: {
                        n2 = 2;
                        break;
                    }
                    case PLAYING: {
                        n2 = this.f.isStreamProgressing() ? 1 : 3;
                    }
                }
            }
            long l2 = this.b(this.f.getStreamDuration());
            long l3 = this.b(this.f.getStreamPosition());
            MediaItemStatus mediaItemStatus = new MediaItemStatus.Builder(n2).setContentDuration(l2).setContentPosition(l3).setExtras(bundle).setTimestamp(SystemClock.uptimeMillis()).build();
            return mediaItemStatus.asBundle();
        }
    }
}

