/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v7.mediarouter.R;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;

final class MediaRouterThemeHelper {
    private MediaRouterThemeHelper() {
    }

    public static Context createThemedContext(Context context, boolean forceDark) {
        boolean isLightTheme = MediaRouterThemeHelper.isLightTheme(context);
        if (isLightTheme && forceDark) {
            context = new ContextThemeWrapper(context, R.style.Theme_AppCompat);
            isLightTheme = false;
        }
        return new ContextThemeWrapper(context, isLightTheme ? R.style.Theme_MediaRouter_Light : R.style.Theme_MediaRouter);
    }

    public static int getThemeResource(Context context, int attr2) {
        TypedValue value = new TypedValue();
        return context.getTheme().resolveAttribute(attr2, value, true) ? value.resourceId : 0;
    }

    public static Drawable getThemeDrawable(Context context, int attr2) {
        int res = MediaRouterThemeHelper.getThemeResource(context, attr2);
        return res != 0 ? context.getResources().getDrawable(res) : null;
    }

    private static boolean isLightTheme(Context context) {
        TypedValue value = new TypedValue();
        return context.getTheme().resolveAttribute(R.attr.isLightTheme, value, true) && value.data != 0;
    }
}

