/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.support.v7.media.MediaRouteDiscoveryRequest;
import android.support.v7.media.MediaRouteProviderDescriptor;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;

public abstract class MediaRouteProvider {
    private static final int MSG_DELIVER_DESCRIPTOR_CHANGED = 1;
    private static final int MSG_DELIVER_DISCOVERY_REQUEST_CHANGED = 2;
    private final Context mContext;
    private final ProviderMetadata mMetadata;
    private final ProviderHandler mHandler = new ProviderHandler();
    private Callback mCallback;
    private MediaRouteDiscoveryRequest mDiscoveryRequest;
    private boolean mPendingDiscoveryRequestChange;
    private MediaRouteProviderDescriptor mDescriptor;
    private boolean mPendingDescriptorChange;

    public MediaRouteProvider(Context context) {
        this(context, null);
    }

    MediaRouteProvider(Context context, ProviderMetadata metadata) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.mContext = context;
        this.mMetadata = metadata == null ? new ProviderMetadata(context.getPackageName()) : metadata;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Handler getHandler() {
        return this.mHandler;
    }

    public final ProviderMetadata getMetadata() {
        return this.mMetadata;
    }

    public final void setCallback(Callback callback) {
        MediaRouter.checkCallingThread();
        this.mCallback = callback;
    }

    public final MediaRouteDiscoveryRequest getDiscoveryRequest() {
        return this.mDiscoveryRequest;
    }

    public final void setDiscoveryRequest(MediaRouteDiscoveryRequest request) {
        MediaRouter.checkCallingThread();
        if (this.mDiscoveryRequest == request || this.mDiscoveryRequest != null && this.mDiscoveryRequest.equals(request)) {
            return;
        }
        this.mDiscoveryRequest = request;
        if (!this.mPendingDiscoveryRequestChange) {
            this.mPendingDiscoveryRequestChange = true;
            this.mHandler.sendEmptyMessage(2);
        }
    }

    private void deliverDiscoveryRequestChanged() {
        this.mPendingDiscoveryRequestChange = false;
        this.onDiscoveryRequestChanged(this.mDiscoveryRequest);
    }

    public void onDiscoveryRequestChanged(MediaRouteDiscoveryRequest request) {
    }

    public final MediaRouteProviderDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public final void setDescriptor(MediaRouteProviderDescriptor descriptor) {
        MediaRouter.checkCallingThread();
        if (this.mDescriptor != descriptor) {
            this.mDescriptor = descriptor;
            if (!this.mPendingDescriptorChange) {
                this.mPendingDescriptorChange = true;
                this.mHandler.sendEmptyMessage(1);
            }
        }
    }

    private void deliverDescriptorChanged() {
        this.mPendingDescriptorChange = false;
        if (this.mCallback != null) {
            this.mCallback.onDescriptorChanged(this, this.mDescriptor);
        }
    }

    public RouteController onCreateRouteController(String routeId) {
        return null;
    }

    private final class ProviderHandler
    extends Handler {
        private ProviderHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaRouteProvider.this.deliverDescriptorChanged();
                    break;
                }
                case 2: {
                    MediaRouteProvider.this.deliverDiscoveryRequestChanged();
                }
            }
        }
    }

    public static abstract class Callback {
        public void onDescriptorChanged(MediaRouteProvider provider, MediaRouteProviderDescriptor descriptor) {
        }
    }

    public static abstract class RouteController {
        public void onRelease() {
        }

        public void onSelect() {
        }

        public void onUnselect() {
        }

        public void onSetVolume(int volume) {
        }

        public void onUpdateVolume(int delta) {
        }

        public boolean onControlRequest(Intent intent, MediaRouter.ControlRequestCallback callback) {
            return false;
        }
    }

    public static final class ProviderMetadata {
        private final String mPackageName;

        public ProviderMetadata(String packageName) {
            if (TextUtils.isEmpty((CharSequence)packageName)) {
                throw new IllegalArgumentException("packageName must not be null or empty");
            }
            this.mPackageName = packageName;
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public String toString() {
            return "ProviderMetadata{ packageName=" + this.mPackageName + " }";
        }
    }
}

