/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.v7.media.MediaRouteDiscoveryRequest;
import android.support.v7.media.MediaRouteProvider;
import android.support.v7.media.MediaRouteProviderDescriptor;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.util.Log;
import android.util.SparseArray;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class MediaRouteProviderService
extends Service {
    private static final String TAG = "MediaRouteProviderSrv";
    private static final boolean DEBUG = Log.isLoggable((String)"MediaRouteProviderSrv", (int)3);
    private final ArrayList<ClientRecord> mClients = new ArrayList();
    private final ReceiveHandler mReceiveHandler = new ReceiveHandler(this);
    private final Messenger mReceiveMessenger = new Messenger((Handler)this.mReceiveHandler);
    private final PrivateHandler mPrivateHandler = new PrivateHandler();
    private final ProviderCallback mProviderCallback = new ProviderCallback();
    private MediaRouteProvider mProvider;
    private MediaRouteDiscoveryRequest mCompositeDiscoveryRequest;
    public static final String SERVICE_INTERFACE = "android.media.MediaRouteProviderService";
    static final int CLIENT_MSG_REGISTER = 1;
    static final int CLIENT_MSG_UNREGISTER = 2;
    static final int CLIENT_MSG_CREATE_ROUTE_CONTROLLER = 3;
    static final int CLIENT_MSG_RELEASE_ROUTE_CONTROLLER = 4;
    static final int CLIENT_MSG_SELECT_ROUTE = 5;
    static final int CLIENT_MSG_UNSELECT_ROUTE = 6;
    static final int CLIENT_MSG_SET_ROUTE_VOLUME = 7;
    static final int CLIENT_MSG_UPDATE_ROUTE_VOLUME = 8;
    static final int CLIENT_MSG_ROUTE_CONTROL_REQUEST = 9;
    static final int CLIENT_MSG_SET_DISCOVERY_REQUEST = 10;
    static final String CLIENT_DATA_ROUTE_ID = "routeId";
    static final String CLIENT_DATA_VOLUME = "volume";
    static final int SERVICE_MSG_GENERIC_FAILURE = 0;
    static final int SERVICE_MSG_GENERIC_SUCCESS = 1;
    static final int SERVICE_MSG_REGISTERED = 2;
    static final int SERVICE_MSG_CONTROL_REQUEST_SUCCEEDED = 3;
    static final int SERVICE_MSG_CONTROL_REQUEST_FAILED = 4;
    static final int SERVICE_MSG_DESCRIPTOR_CHANGED = 5;
    static final String SERVICE_DATA_ERROR = "error";
    static final int CLIENT_VERSION_1 = 1;
    static final int CLIENT_VERSION_CURRENT = 1;
    static final int SERVICE_VERSION_1 = 1;
    static final int SERVICE_VERSION_CURRENT = 1;
    private static final int PRIVATE_MSG_CLIENT_DIED = 1;

    public abstract MediaRouteProvider onCreateMediaRouteProvider();

    public MediaRouteProvider getMediaRouteProvider() {
        return this.mProvider;
    }

    public IBinder onBind(Intent intent) {
        if (intent.getAction().equals(SERVICE_INTERFACE)) {
            MediaRouteProvider provider;
            if (this.mProvider == null && (provider = this.onCreateMediaRouteProvider()) != null) {
                String providerPackage = provider.getMetadata().getPackageName();
                if (!providerPackage.equals(this.getPackageName())) {
                    throw new IllegalStateException("onCreateMediaRouteProvider() returned a provider whose package name does not match the package name of the service.  A media route provider service can only export its own media route providers.  Provider package name: " + providerPackage + ".  Service package name: " + this.getPackageName() + ".");
                }
                this.mProvider = provider;
                this.mProvider.setCallback(this.mProviderCallback);
            }
            if (this.mProvider != null) {
                return this.mReceiveMessenger.getBinder();
            }
        }
        return null;
    }

    private boolean onRegisterClient(Messenger messenger, int requestId, int version) {
        ClientRecord client;
        int index;
        if (version >= 1 && (index = this.findClient(messenger)) < 0 && (client = new ClientRecord(messenger, version)).register()) {
            this.mClients.add(client);
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Registered, version=" + version));
            }
            if (requestId != 0) {
                MediaRouteProviderDescriptor descriptor = this.mProvider.getDescriptor();
                MediaRouteProviderService.sendReply(messenger, 2, requestId, 1, descriptor != null ? descriptor.asBundle() : null, null);
            }
            return true;
        }
        return false;
    }

    private boolean onUnregisterClient(Messenger messenger, int requestId) {
        int index = this.findClient(messenger);
        if (index >= 0) {
            ClientRecord client = this.mClients.remove(index);
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Unregistered"));
            }
            client.dispose();
            MediaRouteProviderService.sendGenericSuccess(messenger, requestId);
            return true;
        }
        return false;
    }

    private void onBinderDied(Messenger messenger) {
        int index = this.findClient(messenger);
        if (index >= 0) {
            ClientRecord client = this.mClients.remove(index);
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Binder died"));
            }
            client.dispose();
        }
    }

    private boolean onCreateRouteController(Messenger messenger, int requestId, int controllerId, String routeId) {
        ClientRecord client = this.getClient(messenger);
        if (client != null && client.createRouteController(routeId, controllerId)) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Route controller created" + ", controllerId=" + controllerId + ", routeId=" + routeId));
            }
            MediaRouteProviderService.sendGenericSuccess(messenger, requestId);
            return true;
        }
        return false;
    }

    private boolean onReleaseRouteController(Messenger messenger, int requestId, int controllerId) {
        ClientRecord client = this.getClient(messenger);
        if (client != null && client.releaseRouteController(controllerId)) {
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Route controller released" + ", controllerId=" + controllerId));
            }
            MediaRouteProviderService.sendGenericSuccess(messenger, requestId);
            return true;
        }
        return false;
    }

    private boolean onSelectRoute(Messenger messenger, int requestId, int controllerId) {
        MediaRouteProvider.RouteController controller;
        ClientRecord client = this.getClient(messenger);
        if (client != null && (controller = client.getRouteController(controllerId)) != null) {
            controller.onSelect();
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Route selected" + ", controllerId=" + controllerId));
            }
            MediaRouteProviderService.sendGenericSuccess(messenger, requestId);
            return true;
        }
        return false;
    }

    private boolean onUnselectRoute(Messenger messenger, int requestId, int controllerId) {
        MediaRouteProvider.RouteController controller;
        ClientRecord client = this.getClient(messenger);
        if (client != null && (controller = client.getRouteController(controllerId)) != null) {
            controller.onUnselect();
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Route unselected" + ", controllerId=" + controllerId));
            }
            MediaRouteProviderService.sendGenericSuccess(messenger, requestId);
            return true;
        }
        return false;
    }

    private boolean onSetRouteVolume(Messenger messenger, int requestId, int controllerId, int volume) {
        MediaRouteProvider.RouteController controller;
        ClientRecord client = this.getClient(messenger);
        if (client != null && (controller = client.getRouteController(controllerId)) != null) {
            controller.onSetVolume(volume);
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Route volume changed" + ", controllerId=" + controllerId + ", volume=" + volume));
            }
            MediaRouteProviderService.sendGenericSuccess(messenger, requestId);
            return true;
        }
        return false;
    }

    private boolean onUpdateRouteVolume(Messenger messenger, int requestId, int controllerId, int delta) {
        MediaRouteProvider.RouteController controller;
        ClientRecord client = this.getClient(messenger);
        if (client != null && (controller = client.getRouteController(controllerId)) != null) {
            controller.onUpdateVolume(delta);
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Route volume updated" + ", controllerId=" + controllerId + ", delta=" + delta));
            }
            MediaRouteProviderService.sendGenericSuccess(messenger, requestId);
            return true;
        }
        return false;
    }

    private boolean onRouteControlRequest(final Messenger messenger, final int requestId, final int controllerId, final Intent intent) {
        MediaRouteProvider.RouteController controller;
        final ClientRecord client = this.getClient(messenger);
        if (client != null && (controller = client.getRouteController(controllerId)) != null) {
            MediaRouter.ControlRequestCallback callback = null;
            if (requestId != 0) {
                callback = new MediaRouter.ControlRequestCallback(){

                    public void onResult(Bundle data) {
                        if (DEBUG) {
                            Log.d((String)MediaRouteProviderService.TAG, (String)(client + ": Route control request succeeded" + ", controllerId=" + controllerId + ", intent=" + intent + ", data=" + data));
                        }
                        if (MediaRouteProviderService.this.findClient(messenger) >= 0) {
                            MediaRouteProviderService.sendReply(messenger, 3, requestId, 0, data, null);
                        }
                    }

                    public void onError(String error, Bundle data) {
                        if (DEBUG) {
                            Log.d((String)MediaRouteProviderService.TAG, (String)(client + ": Route control request failed" + ", controllerId=" + controllerId + ", intent=" + intent + ", error=" + error + ", data=" + data));
                        }
                        if (MediaRouteProviderService.this.findClient(messenger) >= 0) {
                            if (error != null) {
                                Bundle bundle = new Bundle();
                                bundle.putString(MediaRouteProviderService.SERVICE_DATA_ERROR, error);
                                MediaRouteProviderService.sendReply(messenger, 4, requestId, 0, data, bundle);
                            } else {
                                MediaRouteProviderService.sendReply(messenger, 4, requestId, 0, data, null);
                            }
                        }
                    }
                };
            }
            if (controller.onControlRequest(intent, callback)) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)(client + ": Route control request delivered" + ", controllerId=" + controllerId + ", intent=" + intent));
                }
                return true;
            }
        }
        return false;
    }

    private boolean onSetDiscoveryRequest(Messenger messenger, int requestId, MediaRouteDiscoveryRequest request) {
        ClientRecord client = this.getClient(messenger);
        if (client != null) {
            boolean actuallyChanged = client.setDiscoveryRequest(request);
            if (DEBUG) {
                Log.d((String)TAG, (String)(client + ": Set discovery request, request=" + request + ", actuallyChanged=" + actuallyChanged + ", compositeDiscoveryRequest=" + this.mCompositeDiscoveryRequest));
            }
            MediaRouteProviderService.sendGenericSuccess(messenger, requestId);
            return true;
        }
        return false;
    }

    private void sendDescriptorChanged(MediaRouteProviderDescriptor descriptor) {
        Bundle descriptorBundle = descriptor != null ? descriptor.asBundle() : null;
        int count = this.mClients.size();
        for (int i = 0; i < count; ++i) {
            ClientRecord client = this.mClients.get(i);
            MediaRouteProviderService.sendReply(client.mMessenger, 5, 0, 0, descriptorBundle, null);
            if (!DEBUG) continue;
            Log.d((String)TAG, (String)(client + ": Sent descriptor change event, descriptor=" + descriptor));
        }
    }

    private boolean updateCompositeDiscoveryRequest() {
        MediaRouteDiscoveryRequest composite = null;
        MediaRouteSelector.Builder selectorBuilder = null;
        boolean activeScan = false;
        int count = this.mClients.size();
        for (int i = 0; i < count; ++i) {
            MediaRouteDiscoveryRequest request = this.mClients.get((int)i).mDiscoveryRequest;
            if (request == null || request.getSelector().isEmpty() && !request.isActiveScan()) continue;
            activeScan |= request.isActiveScan();
            if (composite == null) {
                composite = request;
                continue;
            }
            if (selectorBuilder == null) {
                selectorBuilder = new MediaRouteSelector.Builder(composite.getSelector());
            }
            selectorBuilder.addSelector(request.getSelector());
        }
        if (selectorBuilder != null) {
            composite = new MediaRouteDiscoveryRequest(selectorBuilder.build(), activeScan);
        }
        if (!(this.mCompositeDiscoveryRequest == composite || this.mCompositeDiscoveryRequest != null && this.mCompositeDiscoveryRequest.equals(composite))) {
            this.mCompositeDiscoveryRequest = composite;
            this.mProvider.setDiscoveryRequest(composite);
            return true;
        }
        return false;
    }

    private ClientRecord getClient(Messenger messenger) {
        int index = this.findClient(messenger);
        return index >= 0 ? this.mClients.get(index) : null;
    }

    private int findClient(Messenger messenger) {
        int count = this.mClients.size();
        for (int i = 0; i < count; ++i) {
            ClientRecord client = this.mClients.get(i);
            if (!client.hasMessenger(messenger)) continue;
            return i;
        }
        return -1;
    }

    private static void sendGenericFailure(Messenger messenger, int requestId) {
        if (requestId != 0) {
            MediaRouteProviderService.sendReply(messenger, 0, requestId, 0, null, null);
        }
    }

    private static void sendGenericSuccess(Messenger messenger, int requestId) {
        if (requestId != 0) {
            MediaRouteProviderService.sendReply(messenger, 1, requestId, 0, null, null);
        }
    }

    private static void sendReply(Messenger messenger, int what, int requestId, int arg, Object obj, Bundle data) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = requestId;
        msg.arg2 = arg;
        msg.obj = obj;
        msg.setData(data);
        try {
            messenger.send(msg);
        }
        catch (DeadObjectException ex) {
        }
        catch (RemoteException ex) {
            Log.e((String)TAG, (String)("Could not send message to " + MediaRouteProviderService.getClientId(messenger)), (Throwable)ex);
        }
    }

    private static String getClientId(Messenger messenger) {
        return "Client connection " + messenger.getBinder().toString();
    }

    static boolean isValidRemoteMessenger(Messenger messenger) {
        try {
            return messenger != null && messenger.getBinder() != null;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private static final class ReceiveHandler
    extends Handler {
        private final WeakReference<MediaRouteProviderService> mServiceRef;

        public ReceiveHandler(MediaRouteProviderService service) {
            this.mServiceRef = new WeakReference<MediaRouteProviderService>(service);
        }

        public void handleMessage(Message msg) {
            Messenger messenger = msg.replyTo;
            if (MediaRouteProviderService.isValidRemoteMessenger(messenger)) {
                int what = msg.what;
                int requestId = msg.arg1;
                int arg = msg.arg2;
                Object obj = msg.obj;
                Bundle data = msg.peekData();
                if (!this.processMessage(what, messenger, requestId, arg, obj, data)) {
                    if (DEBUG) {
                        Log.d((String)MediaRouteProviderService.TAG, (String)(MediaRouteProviderService.getClientId(messenger) + ": Message failed, what=" + what + ", requestId=" + requestId + ", arg=" + arg + ", obj=" + obj + ", data=" + data));
                    }
                    MediaRouteProviderService.sendGenericFailure(messenger, requestId);
                }
            } else if (DEBUG) {
                Log.d((String)MediaRouteProviderService.TAG, (String)"Ignoring message without valid reply messenger.");
            }
        }

        private boolean processMessage(int what, Messenger messenger, int requestId, int arg, Object obj, Bundle data) {
            MediaRouteProviderService service = (MediaRouteProviderService)((Object)this.mServiceRef.get());
            if (service != null) {
                switch (what) {
                    case 1: {
                        return service.onRegisterClient(messenger, requestId, arg);
                    }
                    case 2: {
                        return service.onUnregisterClient(messenger, requestId);
                    }
                    case 3: {
                        String routeId = data.getString(MediaRouteProviderService.CLIENT_DATA_ROUTE_ID);
                        if (routeId == null) break;
                        return service.onCreateRouteController(messenger, requestId, arg, routeId);
                    }
                    case 4: {
                        return service.onReleaseRouteController(messenger, requestId, arg);
                    }
                    case 5: {
                        return service.onSelectRoute(messenger, requestId, arg);
                    }
                    case 6: {
                        return service.onUnselectRoute(messenger, requestId, arg);
                    }
                    case 7: {
                        int volume = data.getInt(MediaRouteProviderService.CLIENT_DATA_VOLUME, -1);
                        if (volume < 0) break;
                        return service.onSetRouteVolume(messenger, requestId, arg, volume);
                    }
                    case 8: {
                        int delta = data.getInt(MediaRouteProviderService.CLIENT_DATA_VOLUME, 0);
                        if (delta == 0) break;
                        return service.onUpdateRouteVolume(messenger, requestId, arg, delta);
                    }
                    case 9: {
                        if (!(obj instanceof Intent)) break;
                        return service.onRouteControlRequest(messenger, requestId, arg, (Intent)obj);
                    }
                    case 10: {
                        if (obj != null && !(obj instanceof Bundle)) break;
                        MediaRouteDiscoveryRequest request = MediaRouteDiscoveryRequest.fromBundle((Bundle)obj);
                        return service.onSetDiscoveryRequest(messenger, requestId, request != null && request.isValid() ? request : null);
                    }
                }
            }
            return false;
        }
    }

    private final class ClientRecord
    implements IBinder.DeathRecipient {
        public final Messenger mMessenger;
        public final int mVersion;
        public MediaRouteDiscoveryRequest mDiscoveryRequest;
        private final SparseArray<MediaRouteProvider.RouteController> mControllers = new SparseArray();

        public ClientRecord(Messenger messenger, int version) {
            this.mMessenger = messenger;
            this.mVersion = version;
        }

        public boolean register() {
            try {
                this.mMessenger.getBinder().linkToDeath((IBinder.DeathRecipient)this, 0);
                return true;
            }
            catch (RemoteException ex) {
                this.binderDied();
                return false;
            }
        }

        public void dispose() {
            int count = this.mControllers.size();
            for (int i = 0; i < count; ++i) {
                ((MediaRouteProvider.RouteController)this.mControllers.valueAt(i)).onRelease();
            }
            this.mControllers.clear();
            this.mMessenger.getBinder().unlinkToDeath((IBinder.DeathRecipient)this, 0);
            this.setDiscoveryRequest(null);
        }

        public boolean hasMessenger(Messenger other) {
            return this.mMessenger.getBinder() == other.getBinder();
        }

        public boolean createRouteController(String routeId, int controllerId) {
            MediaRouteProvider.RouteController controller;
            if (this.mControllers.indexOfKey(controllerId) < 0 && (controller = MediaRouteProviderService.this.mProvider.onCreateRouteController(routeId)) != null) {
                this.mControllers.put(controllerId, (Object)controller);
                return true;
            }
            return false;
        }

        public boolean releaseRouteController(int controllerId) {
            MediaRouteProvider.RouteController controller = (MediaRouteProvider.RouteController)this.mControllers.get(controllerId);
            if (controller != null) {
                this.mControllers.remove(controllerId);
                controller.onRelease();
                return true;
            }
            return false;
        }

        public MediaRouteProvider.RouteController getRouteController(int controllerId) {
            return (MediaRouteProvider.RouteController)this.mControllers.get(controllerId);
        }

        public boolean setDiscoveryRequest(MediaRouteDiscoveryRequest request) {
            if (!(this.mDiscoveryRequest == request || this.mDiscoveryRequest != null && this.mDiscoveryRequest.equals(request))) {
                this.mDiscoveryRequest = request;
                return MediaRouteProviderService.this.updateCompositeDiscoveryRequest();
            }
            return false;
        }

        public void binderDied() {
            MediaRouteProviderService.this.mPrivateHandler.obtainMessage(1, this.mMessenger).sendToTarget();
        }

        public String toString() {
            return MediaRouteProviderService.getClientId(this.mMessenger);
        }
    }

    private final class ProviderCallback
    extends MediaRouteProvider.Callback {
        private ProviderCallback() {
        }

        public void onDescriptorChanged(MediaRouteProvider provider, MediaRouteProviderDescriptor descriptor) {
            MediaRouteProviderService.this.sendDescriptorChanged(descriptor);
        }
    }

    private final class PrivateHandler
    extends Handler {
        private PrivateHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaRouteProviderService.this.onBinderDied((Messenger)msg.obj);
                }
            }
        }
    }
}

