/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.support.v7.media.MediaRouter;
import android.support.v7.media.RegisteredMediaRouteProvider;
import java.util.ArrayList;
import java.util.Collections;

final class RegisteredMediaRouteProviderWatcher {
    private final Context mContext;
    private final MediaRouter mRouter;
    private final ArrayList<RegisteredMediaRouteProvider> mProviders = new ArrayList();
    private final PackageManager mPackageManager;

    public RegisteredMediaRouteProviderWatcher(Context context, MediaRouter router) {
        this.mContext = context;
        this.mRouter = router;
        this.mPackageManager = context.getPackageManager();
    }

    public void start() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                RegisteredMediaRouteProviderWatcher.this.scanPackages();
            }
        }, filter);
        this.scanPackages();
    }

    private void scanPackages() {
        int targetIndex = 0;
        Intent intent = new Intent("android.media.MediaRouteProviderService");
        for (ResolveInfo resolveInfo : this.mPackageManager.queryIntentServices(intent, 0)) {
            RegisteredMediaRouteProvider provider;
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (serviceInfo == null) continue;
            int sourceIndex = this.findProvider(serviceInfo.packageName, serviceInfo.name);
            if (sourceIndex < 0) {
                provider = new RegisteredMediaRouteProvider(this.mContext, new ComponentName(serviceInfo.packageName, serviceInfo.name));
                provider.start();
                this.mProviders.add(targetIndex++, provider);
                this.mRouter.addProvider(provider);
                continue;
            }
            if (sourceIndex < targetIndex) continue;
            provider = this.mProviders.get(sourceIndex);
            provider.rebindIfDisconnected();
            Collections.swap(this.mProviders, sourceIndex, targetIndex++);
        }
        if (targetIndex < this.mProviders.size()) {
            for (int i = this.mProviders.size() - 1; i >= targetIndex; --i) {
                RegisteredMediaRouteProvider provider = this.mProviders.get(i);
                this.mRouter.removeProvider(provider);
                this.mProviders.remove(provider);
                provider.stop();
            }
        }
    }

    private int findProvider(String packageName, String className) {
        int count = this.mProviders.size();
        for (int i = 0; i < count; ++i) {
            RegisteredMediaRouteProvider provider = this.mProviders.get(i);
            if (!provider.hasComponentName(packageName, className)) continue;
            return i;
        }
        return -1;
    }
}

