// The copyright in this software is being made available under the BSD License, included below. This software may be subject to other third party and contributor rights, including patent rights, and no such rights are granted under this license.
//
// Copyright (c) 2013, Microsoft Open Technologies, Inc.
//
// All rights reserved.
// Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
//     -             Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
//     -             Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
//     -             Neither the name of the Microsoft Open Technologies, Inc. nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

//This class parses the MPDs using DashParser framework.

describe("Parser Test Suite", function () {
	var baseUrl,
	parser,
	system,
	stub;

	/**
	 * Method to be run before each test method runs
	 */
	beforeEach(function () {
	
        baseUrl = "http://dashdemo.edgesuite.net/envivio/dashpr/clear/";
		// Set up DI.
		system = new dijon.System();
		system.mapValue("system", system);
		system.mapOutlet("system");

		context = new Dash.di.DashContext();
		system.injectInto(context);

		parser = system.getObject("parser");

	});

	/**
	 * Function checks if the method is present
	 */
	it("has method parse", function () {

		var result = (typeof parser.parse);
		expect(result).toEqual('function');
	});

	/**
	 * Method to check if all the properties of MPD file 1 sre parsed correctly
	 */
	it("parse reads mpd file and returns valid objects - MPD Type 1", function () {
		var data = '';

		stub = strMpd["MPD2"];
		parser.parse(stub, baseUrl).then(function (Data) {
			data = Data;

		}, function (Error) {
			data = Error;
		});
		waitsFor(function () {
			if (data != '')
				return true;
		}, "parsed data is null", 50);
		runs(function () {

			expect(data.xmlns).toEqual("urn:mpeg:DASH:schema:MPD:2011");
			expect(data.type).toEqual("static");
			expect(data.minBufferTime).toEqual(1.5);
			expect(data.mediaPresentationDuration).toEqual(600);
			expect(data.profiles).toEqual("urn:mpeg:dash:profile:isoff-main:2011");
			expect(data.ProgramInformation.moreInformationURL).toEqual("http://gpac.sourceforge.net");
			expect(data.ProgramInformation.Title).toEqual("mp4-main-multi-mpd-AV-NBS.mpd generated by GPAC");
			expect(data.ProgramInformation.Copyright).toEqual("TelecomParisTech(c)2012");
			expect(data.Period.start).toEqual(0);
			expect(data.Period.duration).toEqual(600);
			expect(data.Period.AdaptationSet[0].segmentAlignment).toBeTruthy();
			expect(data.Period.AdaptationSet[0].maxWidth).toEqual(1920);
			expect(data.Period.AdaptationSet[0].maxHeight).toEqual(1080);
			expect(data.Period.AdaptationSet[0].maxFrameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].par).toEqual("16:9");
			expect(data.Period.AdaptationSet[0].ContentComponent.id).toEqual(1);
			expect(data.Period.AdaptationSet[0].ContentComponent.contentType).toEqual("video");

			//Representation set1
			expect(data.Period.AdaptationSet[0].Representation[0].id).toEqual("h264bl_low");
			expect(data.Period.AdaptationSet[0].Representation[0].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].Representation[0].codecs).toEqual("avc1.42c00d");
			expect(data.Period.AdaptationSet[0].Representation[0].width).toEqual(320);
			expect(data.Period.AdaptationSet[0].Representation[0].height).toEqual(180);
			expect(data.Period.AdaptationSet[0].Representation[0].frameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].Representation[0].sar).toEqual("1:1");
			expect(data.Period.AdaptationSet[0].Representation[0].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].Representation[0].bandwidth).toEqual(50877);
			expect(data.Period.AdaptationSet[0].Representation[0].SegmentList.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[0].Representation[0].SegmentList.duration).toEqual(10000);
			expect(data.Period.AdaptationSet[0].Representation[0].SegmentList.Initialization.sourceURL).toEqual("mp4-main-multi-h264bl_low-.mp4");
			for (var i = 1; i <= 60; i++) {
				expect(data.Period.AdaptationSet[0].Representation[0].SegmentList.SegmentURL[i - 1].media).toEqual("mp4-main-multi-h264bl_low-" + i + ".m4s");
			}

			//Representation set2
			expect(data.Period.AdaptationSet[0].Representation[1].id).toEqual("h264bl_mid");
			expect(data.Period.AdaptationSet[0].Representation[1].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].Representation[1].codecs).toEqual("avc1.42c01e");
			expect(data.Period.AdaptationSet[0].Representation[1].width).toEqual(640);
			expect(data.Period.AdaptationSet[0].Representation[1].height).toEqual(360);
			expect(data.Period.AdaptationSet[0].Representation[1].frameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].Representation[1].sar).toEqual("1:1");
			expect(data.Period.AdaptationSet[0].Representation[1].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].Representation[1].bandwidth).toEqual(194870);
			expect(data.Period.AdaptationSet[0].Representation[1].SegmentList.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[0].Representation[1].SegmentList.duration).toEqual(10000);
			expect(data.Period.AdaptationSet[0].Representation[1].SegmentList.Initialization.sourceURL).toEqual("mp4-main-multi-h264bl_mid-.mp4");
			for (var i = 1; i <= 60; i++) {
				expect(data.Period.AdaptationSet[0].Representation[1].SegmentList.SegmentURL[i - 1].media).toEqual("mp4-main-multi-h264bl_mid-" + i + ".m4s");
			}

			//Representation set3
			expect(data.Period.AdaptationSet[0].Representation[2].id).toEqual("h264bl_hd");
			expect(data.Period.AdaptationSet[0].Representation[2].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].Representation[2].codecs).toEqual("avc1.42c01f");
			expect(data.Period.AdaptationSet[0].Representation[2].width).toEqual(1280);
			expect(data.Period.AdaptationSet[0].Representation[2].height).toEqual(720);
			expect(data.Period.AdaptationSet[0].Representation[2].frameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].Representation[2].sar).toEqual("1:1");
			expect(data.Period.AdaptationSet[0].Representation[2].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].Representation[2].bandwidth).toEqual(514828);
			expect(data.Period.AdaptationSet[0].Representation[2].SegmentList.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[0].Representation[2].SegmentList.duration).toEqual(10000);
			expect(data.Period.AdaptationSet[0].Representation[2].SegmentList.Initialization.sourceURL).toEqual("mp4-main-multi-h264bl_hd-.mp4");
			for (var i = 1; i <= 60; i++) {
				expect(data.Period.AdaptationSet[0].Representation[2].SegmentList.SegmentURL[i - 1].media).toEqual("mp4-main-multi-h264bl_hd-" + i + ".m4s");
			}

			//Representation set4
			expect(data.Period.AdaptationSet[0].Representation[3].id).toEqual("h264bl_full");
			expect(data.Period.AdaptationSet[0].Representation[3].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].Representation[3].codecs).toEqual("avc1.42c028");
			expect(data.Period.AdaptationSet[0].Representation[3].width).toEqual(1920);
			expect(data.Period.AdaptationSet[0].Representation[3].height).toEqual(1080);
			expect(data.Period.AdaptationSet[0].Representation[3].frameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].Representation[3].sar).toEqual("1:1");
			expect(data.Period.AdaptationSet[0].Representation[3].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].Representation[3].bandwidth).toEqual(770699);
			expect(data.Period.AdaptationSet[0].Representation[3].SegmentList.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[0].Representation[3].SegmentList.duration).toEqual(10000);
			expect(data.Period.AdaptationSet[0].Representation[3].SegmentList.Initialization.sourceURL).toEqual("mp4-main-multi-h264bl_full-.mp4");
			for (var i = 1; i <= 60; i++) {
				expect(data.Period.AdaptationSet[0].Representation[3].SegmentList.SegmentURL[i - 1].media).toEqual("mp4-main-multi-h264bl_full-" + i + ".m4s");
			}

			//AdaptationSet 2
			expect(data.Period.AdaptationSet[1].segmentAlignment).toBeTruthy();
			expect(data.Period.AdaptationSet[1].lang).toEqual("und");
			expect(data.Period.AdaptationSet[1].ContentComponent.id).toEqual(1);
			expect(data.Period.AdaptationSet[1].ContentComponent.contentType).toEqual("audio");
			expect(data.Period.AdaptationSet[1].ContentComponent.lang).toEqual("und");

			//Representation set1
			expect(data.Period.AdaptationSet[1].Representation[0].id).toEqual("aaclc_low");
			expect(data.Period.AdaptationSet[1].Representation[0].mimeType).toEqual("audio/mp4");
			expect(data.Period.AdaptationSet[1].Representation[0].codecs).toEqual("mp4a.40.2");
			expect(data.Period.AdaptationSet[1].Representation[0].audioSamplingRate).toEqual(44100);
			expect(data.Period.AdaptationSet[1].Representation[0].lang).toEqual("und");
			expect(data.Period.AdaptationSet[1].Representation[0].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[1].Representation[0].bandwidth).toEqual(19079);
			expect(data.Period.AdaptationSet[1].Representation[0].AudioChannelConfiguration.schemeIdUri).toEqual("urn:mpeg:dash:23003:3:audio_channel_configuration:2011");
			expect(data.Period.AdaptationSet[1].Representation[0].AudioChannelConfiguration.value).toEqual(1);
			expect(data.Period.AdaptationSet[1].Representation[0].SegmentList.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[1].Representation[0].SegmentList.duration).toEqual(9520);
			expect(data.Period.AdaptationSet[1].Representation[0].SegmentList.Initialization.sourceURL).toEqual("mp4-main-multi-aaclc_low-.mp4");
			for (var i = 1; i <= 64; i++) {
				expect(data.Period.AdaptationSet[1].Representation[0].SegmentList.SegmentURL[i - 1].media).toEqual("mp4-main-multi-aaclc_low-" + i + ".m4s");
			}

			//Representation set1
			expect(data.Period.AdaptationSet[1].Representation[1].id).toEqual("aaclc_high");
			expect(data.Period.AdaptationSet[1].Representation[1].mimeType).toEqual("audio/mp4");
			expect(data.Period.AdaptationSet[1].Representation[1].codecs).toEqual("mp4a.40.2");
			expect(data.Period.AdaptationSet[1].Representation[1].audioSamplingRate).toEqual(44100);
			expect(data.Period.AdaptationSet[1].Representation[1].lang).toEqual("und");
			expect(data.Period.AdaptationSet[1].Representation[1].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[1].Representation[1].bandwidth).toEqual(66378);
			expect(data.Period.AdaptationSet[1].Representation[1].AudioChannelConfiguration.schemeIdUri).toEqual("urn:mpeg:dash:23003:3:audio_channel_configuration:2011");
			expect(data.Period.AdaptationSet[1].Representation[1].AudioChannelConfiguration.value).toEqual(1);
			expect(data.Period.AdaptationSet[1].Representation[1].SegmentList.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[1].Representation[1].SegmentList.duration).toEqual(9520);
			expect(data.Period.AdaptationSet[1].Representation[1].SegmentList.Initialization.sourceURL).toEqual("mp4-main-multi-aaclc_high-.mp4");
			for (var i = 1; i <= 64; i++) {
				expect(data.Period.AdaptationSet[1].Representation[1].SegmentList.SegmentURL[i - 1].media).toEqual("mp4-main-multi-aaclc_high-" + i + ".m4s");
			}

		});

	});

	/**
	 * Method to check if all the properties of MPD file 2 sre parsed correctly
	 */
	it("parse reads mpd file and returns valid objects - MPD Type 2", function () {
		var data = '';

        stub = strMpd["MPD1"];

		parser.parse(stub, baseUrl).then(function (Data) {
			data = Data;

		}, function (Error) {
			data = Error;
		});
		waitsFor(function () {
			if (data != '')
				return true;
		}, "parsed data is null", 50);
		runs(function () {
			expect(data.xmlns).toEqual("urn:mpeg:dash:schema:mpd:2011");
			expect(data.type).toEqual("static");
			expect(data.minBufferTime).toEqual(2);
			expect(data.mediaPresentationDuration).toEqual(234);
			expect(data.profiles).toEqual("urn:mpeg:dash:profile:isoff-live:2011");

			//AdaptationSet set1
			expect(data.Period.AdaptationSet[0].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].segmentAlignment).toBeTruthy();
			expect(data.Period.AdaptationSet[0].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.duration).toEqual(2);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.startNumber).toEqual(1);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.media).toEqual("video_$Number$_$Bandwidth$bps.mp4");
			expect(data.Period.AdaptationSet[0].SegmentTemplate.initialization).toEqual("video_$Bandwidth$bps.mp4");
			expect(data.Period.AdaptationSet[0].Representation[0].id).toEqual("v0");
			expect(data.Period.AdaptationSet[0].Representation[0].codecs).toEqual("avc1.4d401e");
			expect(data.Period.AdaptationSet[0].Representation[0].width).toEqual(720);
			expect(data.Period.AdaptationSet[0].Representation[0].height).toEqual(576);
			expect(data.Period.AdaptationSet[0].Representation[0].bandwidth).toEqual(900000);
			expect(data.Period.AdaptationSet[0].Representation[1].id).toEqual("v1");
			expect(data.Period.AdaptationSet[0].Representation[1].codecs).toEqual("avc1.4d401e");
			expect(data.Period.AdaptationSet[0].Representation[1].width).toEqual(720);
			expect(data.Period.AdaptationSet[0].Representation[1].height).toEqual(576);
			expect(data.Period.AdaptationSet[0].Representation[1].bandwidth).toEqual(500000);

			//AdaptationSet set2
			expect(data.Period.AdaptationSet[1].mimeType).toEqual("audio/mp4");
			expect(data.Period.AdaptationSet[1].codecs).toEqual("mp4a.40.5");
			expect(data.Period.AdaptationSet[1].segmentAlignment).toBeTruthy();
			expect(data.Period.AdaptationSet[1].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.duration).toEqual(2);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.startNumber).toEqual(1);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.media).toEqual("audio_$Number$_$Bandwidth$bps_Input_2.mp4");
			expect(data.Period.AdaptationSet[1].SegmentTemplate.initialization).toEqual("audio_$Bandwidth$bps_Input_2.mp4");
			expect(data.Period.AdaptationSet[1].Representation.id).toEqual("a2");
			expect(data.Period.AdaptationSet[1].Representation.bandwidth).toEqual(56000);
		});
	});

	/**
	 * Method to check if all the properties of MPD file 3 sre parsed correctly
	 */
	it("parse reads mpd file and returns valid objects - MPD Type 3", function () {
		var data = '';

        stub = strMpd["MPD3"];
		parser.parse(stub, baseUrl).then(function (Data) {
			data = Data;

		}, function (Error) {
			data = Error;
		});
		waitsFor(function () {
			if (data != '')
				return true;
		}, "parsed data is null", 50);
		runs(function () {
			expect(data.xmlns).toEqual("urn:mpeg:dash:schema:mpd:2011");
			expect(data.type).toEqual("static");
			expect(data.minBufferTime).toEqual(1.5);
			expect(data.mediaPresentationDuration).toEqual(600);
			expect(data.profiles).toEqual("urn:mpeg:dash:profile:isoff-live:2011");
			expect(data.ProgramInformation.moreInformationURL).toEqual("http://gpac.sourceforge.net");
			expect(data.ProgramInformation.Title).toEqual("mp4-live-mpd-AV-BS.mpd generated by GPAC");
			expect(data.ProgramInformation.Copyright).toEqual("TelecomParisTech(c)2012");
			expect(data.Period.start).toEqual(0);
			expect(data.Period.duration).toEqual(600);

			//AdaptationSet set1
			expect(data.Period.AdaptationSet[0].segmentAlignment).toBeTruthy();
			expect(data.Period.AdaptationSet[0].bitstreamSwitching).toBeTruthy();
			expect(data.Period.AdaptationSet[0].maxWidth).toEqual(1920);
			expect(data.Period.AdaptationSet[0].maxHeight).toEqual(1080);
			expect(data.Period.AdaptationSet[0].maxFrameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].par).toEqual("16:9");
			expect(data.Period.AdaptationSet[0].ContentComponent.id).toEqual(1);
			expect(data.Period.AdaptationSet[0].ContentComponent.contentType).toEqual("video");
			expect(data.Period.AdaptationSet[0].SegmentTemplate.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.duration).toEqual(10000);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.media).toEqual("mp4-live-$RepresentationID$-$Number$.m4s");
			expect(data.Period.AdaptationSet[0].SegmentTemplate.startNumber).toEqual(1);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.initialization).toEqual("mp4-live-mpd-AV-BS_set1_init.mp4");
			expect(data.Period.AdaptationSet[0].Representation[0].id).toEqual("h264bl_low");
			expect(data.Period.AdaptationSet[0].Representation[0].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].Representation[0].codecs).toEqual("avc1.42c00d");
			expect(data.Period.AdaptationSet[0].Representation[0].width).toEqual(320);
			expect(data.Period.AdaptationSet[0].Representation[0].height).toEqual(180);
			expect(data.Period.AdaptationSet[0].Representation[0].frameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].Representation[0].sar).toEqual("1:1");
			expect(data.Period.AdaptationSet[0].Representation[0].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].Representation[0].bandwidth).toEqual(50842);
			expect(data.Period.AdaptationSet[0].Representation[1].id).toEqual("h264bl_mid");
			expect(data.Period.AdaptationSet[0].Representation[1].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].Representation[1].codecs).toEqual("avc1.42c01e");
			expect(data.Period.AdaptationSet[0].Representation[1].width).toEqual(640);
			expect(data.Period.AdaptationSet[0].Representation[1].height).toEqual(360);
			expect(data.Period.AdaptationSet[0].Representation[1].frameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].Representation[1].sar).toEqual("1:1");
			expect(data.Period.AdaptationSet[0].Representation[1].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].Representation[1].bandwidth).toEqual(194834);
			expect(data.Period.AdaptationSet[0].Representation[2].id).toEqual("h264bl_hd");
			expect(data.Period.AdaptationSet[0].Representation[2].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].Representation[2].codecs).toEqual("avc1.42c01f");
			expect(data.Period.AdaptationSet[0].Representation[2].width).toEqual(1280);
			expect(data.Period.AdaptationSet[0].Representation[2].height).toEqual(720);
			expect(data.Period.AdaptationSet[0].Representation[2].frameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].Representation[2].sar).toEqual("1:1");
			expect(data.Period.AdaptationSet[0].Representation[2].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].Representation[2].bandwidth).toEqual(514793);
			expect(data.Period.AdaptationSet[0].Representation[3].id).toEqual("h264bl_full");
			expect(data.Period.AdaptationSet[0].Representation[3].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[0].Representation[3].codecs).toEqual("avc1.42c028");
			expect(data.Period.AdaptationSet[0].Representation[3].width).toEqual(1920);
			expect(data.Period.AdaptationSet[0].Representation[3].height).toEqual(1080);
			expect(data.Period.AdaptationSet[0].Representation[3].frameRate).toEqual(25);
			expect(data.Period.AdaptationSet[0].Representation[3].sar).toEqual("1:1");
			expect(data.Period.AdaptationSet[0].Representation[3].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[0].Representation[3].bandwidth).toEqual(770663);

			//AdaptationSet set2
			expect(data.Period.AdaptationSet[1].segmentAlignment).toBeTrue;
			expect(data.Period.AdaptationSet[1].bitstreamSwitching).toBeTrue;
			expect(data.Period.AdaptationSet[1].lang).toEqual("und");
			expect(data.Period.AdaptationSet[1].AudioChannelConfiguration.schemeIdUri).toEqual("urn:mpeg:dash:23003:3:audio_channel_configuration:2011");
			expect(data.Period.AdaptationSet[1].AudioChannelConfiguration.value).toEqual(1);
			expect(data.Period.AdaptationSet[1].ContentComponent.id).toEqual(1);
			expect(data.Period.AdaptationSet[1].ContentComponent.contentType).toEqual("audio");
			expect(data.Period.AdaptationSet[1].SegmentTemplate.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.duration).toEqual(9520);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.media).toEqual("mp4-live-$RepresentationID$-$Number$.m4s");
			expect(data.Period.AdaptationSet[1].SegmentTemplate.startNumber).toEqual(1);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.initialization).toEqual("mp4-live-mpd-AV-BS_set2_init.mp4");
			expect(data.Period.AdaptationSet[1].Representation[0].id).toEqual("aaclc_low");
			expect(data.Period.AdaptationSet[1].Representation[0].mimeType).toEqual("audio/mp4");
			expect(data.Period.AdaptationSet[1].Representation[0].codecs).toEqual("mp4a.40.2");
			expect(data.Period.AdaptationSet[1].Representation[0].audioSamplingRate).toEqual(44100);
			expect(data.Period.AdaptationSet[1].Representation[0].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[1].Representation[0].bandwidth).toEqual(19042);
			expect(data.Period.AdaptationSet[1].Representation[1].id).toEqual("aaclc_high");
			expect(data.Period.AdaptationSet[1].Representation[1].mimeType).toEqual("audio/mp4");
			expect(data.Period.AdaptationSet[1].Representation[1].codecs).toEqual("mp4a.40.2");
			expect(data.Period.AdaptationSet[1].Representation[1].audioSamplingRate).toEqual(44100);
			expect(data.Period.AdaptationSet[1].Representation[1].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[1].Representation[1].bandwidth).toEqual(66341);
		});
	});

	/**
	 * Method to check if all the properties of MPD file 4 sre parsed correctly
	 */
	it("parse reads mpd file and returns valid objects - MPD Type 4", function () {

		var data = '';

		stub = strMpd["MPD4"];

		parser.parse(stub, baseUrl).then(function (Data) {
			data = Data;

		}, function (Error) {
			data = Error;
		});
		waitsFor(function () {
			if (data != '')
				return true;
		}, "parsed data is null", 50);
		runs(function () {

			expect(data.xmlns).toEqual("urn:mpeg:dash:schema:mpd:2011");
			expect(data.type).toEqual("static");
			expect(data.minBufferTime).toEqual(10);
			expect(data.mediaPresentationDuration).toEqual(102.72800000000001);
			expect(data.maxSegmentDuration).toEqual(5);
			expect(data.profiles).toEqual("urn:mpeg:dash:profile:isoff-live:2011,urn:com:dashif:dash264,urn:hbbtv:dash:profile:isoff-live:2012");
			expect(data.Period).not.toBeNull();
			expect(data.Period.BaseURL).toEqual("http://demo.unified-streaming.com/video/ateam/ateam.ism/dash/");

			//AdaptationSet1
			expect(data.Period.AdaptationSet[0].group).toEqual(1);
			expect(data.Period.AdaptationSet[0].mimeType).toEqual("audio/mp4");
			expect(data.Period.AdaptationSet[0].minBandwidth).toEqual(148000);
			expect(data.Period.AdaptationSet[0].maxBandwidth).toEqual(148000);
			expect(data.Period.AdaptationSet[0].segmentAlignment).toBeTruthy();
			expect(data.Period.AdaptationSet[0].SegmentTemplate.timescale).toEqual(48000);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.initialization).toEqual("ateam-$RepresentationID$.dash");
			expect(data.Period.AdaptationSet[0].SegmentTemplate.media).toEqual("ateam-$RepresentationID$-$Time$.dash");
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline).not.toBeNull();
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[0].t).toEqual(0);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[0].d).toEqual(200704);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[1].d).toEqual(119808);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[2].d).toEqual(102400);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[3].d).toEqual(104448);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[4].d).toEqual(141312);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[5].d).toEqual(114688);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[6].d).toEqual(111616);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[7].d).toEqual(102400);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[8].d).toEqual(116736);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[9].d).toEqual(117760);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[10].d).toEqual(102400);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[11].d).toEqual(101376);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[12].d).toEqual(102400);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[13].d).toEqual(111616);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[14].d).toEqual(116736);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[15].d).toEqual(128000);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[16].d).toEqual(138240);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[17].d).toEqual(174080);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[18].d).toEqual(132096);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[19].d).toEqual(106496);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[20].d).toEqual(105472);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[21].d).toEqual(110592);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[22].d).toEqual(105472);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[23].d).toEqual(106496);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[24].d).toEqual(102400);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[25].d).toEqual(128000);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[26].d).toEqual(107520);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[27].d).toEqual(131072);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[28].d).toEqual(189440);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[29].d).toEqual(116736);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[30].d).toEqual(199680);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[31].d).toEqual(104448);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[32].d).toEqual(102400);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[33].d).toEqual(117760);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[34].d).toEqual(111616);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[35].d).toEqual(124928);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[36].d).toEqual(117760);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[37].d).toEqual(108544);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[38].d).toEqual(199680);
			expect(data.Period.AdaptationSet[0].SegmentTemplate.SegmentTimeline.S[39].d).toEqual(94208);

			//Representation set1
			expect(data.Period.AdaptationSet[0].Representation.id).toEqual("audio=148000");
			expect(data.Period.AdaptationSet[0].Representation.mimeType).toEqual("audio/mp4");
			expect(data.Period.AdaptationSet[0].Representation.codecs).toEqual("mp4a.40.2");
			expect(data.Period.AdaptationSet[0].Representation.bandwidth).toEqual(148000);
			expect(data.Period.AdaptationSet[0].Representation.audioSamplingRate).toEqual(48000);
			expect(data.Period.AdaptationSet[0].Representation.AudioChannelConfiguration.schemeIdUri).toEqual("urn:mpeg:dash:23003:3:audio_channel_configuration:2011");
			expect(data.Period.AdaptationSet[0].Representation.AudioChannelConfiguration.value).toEqual(2);

			//AdaptationSet2
			expect(data.Period.AdaptationSet[1].group).toEqual(2);
			expect(data.Period.AdaptationSet[1].mimeType).toEqual("video/mp4");
			expect(data.Period.AdaptationSet[1].par).toEqual("16:9");
			expect(data.Period.AdaptationSet[1].minBandwidth).toEqual(475000);
			expect(data.Period.AdaptationSet[1].maxBandwidth).toEqual(6589000);
			expect(data.Period.AdaptationSet[1].minWidth).toEqual(176);
			expect(data.Period.AdaptationSet[1].maxWidth).toEqual(1680);
			expect(data.Period.AdaptationSet[1].minHeight).toEqual(99);
			expect(data.Period.AdaptationSet[1].maxHeight).toEqual(944);
			expect(data.Period.AdaptationSet[1].startWithSAP).toEqual(1);
			expect(data.Period.AdaptationSet[1].segmentAlignment).toBeTruthy();

			expect(data.Period.AdaptationSet[1].SegmentTemplate.timescale).toEqual(1000);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.initialization).toEqual("ateam-$RepresentationID$.dash");
			expect(data.Period.AdaptationSet[1].SegmentTemplate.media).toEqual("ateam-$RepresentationID$-$Time$.dash");
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline).not.toBeNull();
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[0].t).toEqual(0);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[0].d).toEqual(4171);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[1].d).toEqual(2503);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[2].d).toEqual(2127);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[3].d).toEqual(2169);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[4].d).toEqual(2961);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[5].d).toEqual(2377);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[6].d).toEqual(2336);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[7].d).toEqual(2127);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[8].d).toEqual(2419);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[9].d).toEqual(2461);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[10].d).toEqual(2127);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[10].r).toEqual(2);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[11].d).toEqual(2336);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[12].d).toEqual(2419);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[13].d).toEqual(2670);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[14].d).toEqual(2877);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[15].d).toEqual(3629);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[16].d).toEqual(2753);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[17].d).toEqual(2210);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[18].d).toEqual(2211);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[19].d).toEqual(2294);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[20].d).toEqual(2210);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[21].d).toEqual(2211);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[22].d).toEqual(2127);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[23].d).toEqual(2669);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[24].d).toEqual(2253);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[25].d).toEqual(2711);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[26].d).toEqual(3962);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[27].d).toEqual(2419);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[28].d).toEqual(4171);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[29].d).toEqual(2169);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[30].d).toEqual(2127);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[31].d).toEqual(2461);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[32].d).toEqual(2335);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[33].d).toEqual(2586);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[34].d).toEqual(2461);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[35].d).toEqual(2252);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[36].d).toEqual(4171);
			expect(data.Period.AdaptationSet[1].SegmentTemplate.SegmentTimeline.S[37].d).toEqual(2002);

			//Representation set2
			expect(data.Period.AdaptationSet[1].Representation[0].id).toEqual("video=475000");
			expect(data.Period.AdaptationSet[1].Representation[0].bandwidth).toEqual(475000);
			expect(data.Period.AdaptationSet[1].Representation[0].codecs).toEqual("avc1.42C00D");
			expect(data.Period.AdaptationSet[1].Representation[0].width).toEqual(176);
			expect(data.Period.AdaptationSet[1].Representation[0].height).toEqual(99);
			expect(data.Period.AdaptationSet[1].Representation[0].frameRate).toEqual("24000/1001");

			//Representation set3
			expect(data.Period.AdaptationSet[1].Representation[1].id).toEqual("video=639000");
			expect(data.Period.AdaptationSet[1].Representation[1].bandwidth).toEqual(639000);
			expect(data.Period.AdaptationSet[1].Representation[1].codecs).toEqual("avc1.42C014");
			expect(data.Period.AdaptationSet[1].Representation[1].width).toEqual(369);
			expect(data.Period.AdaptationSet[1].Representation[1].height).toEqual(208);
			expect(data.Period.AdaptationSet[1].Representation[1].frameRate).toEqual("24000/1001");

			//Representation set4
			expect(data.Period.AdaptationSet[1].Representation[2].id).toEqual("video=2083000");
			expect(data.Period.AdaptationSet[1].Representation[2].bandwidth).toEqual(2083000);
			expect(data.Period.AdaptationSet[1].Representation[2].codecs).toEqual("avc1.42C01E");
			expect(data.Period.AdaptationSet[1].Representation[2].width).toEqual(768);
			expect(data.Period.AdaptationSet[1].Representation[2].height).toEqual(432);
			expect(data.Period.AdaptationSet[1].Representation[2].frameRate).toEqual("24000/1001");

			//Representation set4
			expect(data.Period.AdaptationSet[1].Representation[3].id).toEqual("video=6589000");
			expect(data.Period.AdaptationSet[1].Representation[3].bandwidth).toEqual(6589000);
			expect(data.Period.AdaptationSet[1].Representation[3].codecs).toEqual("avc1.42C028");
			expect(data.Period.AdaptationSet[1].Representation[3].width).toEqual(1680);
			expect(data.Period.AdaptationSet[1].Representation[3].height).toEqual(944);
			expect(data.Period.AdaptationSet[1].Representation[3].frameRate).toEqual("24000/1001");

		});

	});
    
    //Negative testcase
    it("parse reads mpd file and returns valid objects with stub as null", function () {

		var data = '';
		parser.parse(emptyMpdData["MPD1"], baseUrl).then(function (Data) {
			data = Data;

		}, function (Error) {
			data = Error;
		});
		waitsFor(function () {
			if (data != '')
				return true;
		}, "parsed data is null", 50);
		runs(function () {
			expect(data.__cnt).toEqual(8)
		});

	});
		
    
    
   it("parse reads mpd file and returns valid objects with baseurl as null", function () {
		var data = '',
        stub =  strMpd["MPD4"];

		parser.parse(stub, null).then(function (Data) {
			data = Data;
		}, function (Error) {
			data = Error;
		});
		
        waitsFor(function () {
			if (data != '')
				return true;
		}, "parsed data is null", 50);
		runs(function () {
          expect(data.__cnt).toEqual(13);
        });
	});


});