	if(window.location.href.indexOf("runner.html")>0)
	{
		describe("Buffer Extension Suite", function () {
            var bufferExtension,
            context,
            system;
			
			 beforeEach(function () {
                system = new dijon.System();
                system.mapValue("system", system); 
                system.mapOutlet("system");
                context = new Dash.di.DashContext();
                system.injectInto(context);
            }); 
			
			it("Check Buffer Length with positive values greater than 0",function(){	
				debugger;
				var bufferExtensions = MediaPlayer.dependencies.BufferExtensions();	
				runs(function(){
						debugger;
						bufferExtensions.decideBufferLength(10).when(function(bufferLength){					
						expect(isNaN(bufferLength)).not.toBeTruthy();
					});					
				});							
			});
			
			it("Check Buffer Length with negative values lesser than 0",function(){	
				var bufferExtensions = MediaPlayer.dependencies.BufferExtensions();	
				runs(function(){
						bufferExtensions.decideBufferLength(-1).when(function(bufferLength){					
						expect(isNaN(bufferLength)).not.toBeTruthy();
					});					
				});								
			});
			
			it("Check if Buffer Length = 4 with negative values",function(){	
				var bufferExtensions = MediaPlayer.dependencies.BufferExtensions();	
				runs(function(){
						bufferExtensions.decideBufferLength(-1).when(function(bufferLength){					
						expect(bufferLength).toBe(4);
					});					
				});			
			});
			
			it("Check if Buffer Length = 4 with string value",function(){	
				var bufferExtensions = MediaPlayer.dependencies.BufferExtensions();	
				runs(function(){
						bufferExtensions.decideBufferLength("test").when(function(bufferLength){					
						expect(bufferLength).toBe(4);
					});					
				});				
			});
			
		it("Check the top quality Index for audio",function(){
			if(manifestRes.Period.AdaptationSet_asArray[0] != undefined)
			{
				debugger;
				var bufferExtensions = MediaPlayer.dependencies.BufferExtensions();
				bufferExtensions.updateData(manifestRes.Period.AdaptationSet_asArray[0],"audio");
				var result = bufferExtensions.getTopQualityIndex("audio");
				expect(result).toEqual(4);
			}
		});
		
		it("Check the top quality Index for video",function(){
			if(manifestRes.Period.AdaptationSet_asArray[0] != undefined)
			{
				var bufferExtensions = MediaPlayer.dependencies.BufferExtensions();
				bufferExtensions.updateData(manifestRes.Period.AdaptationSet_asArray[0],"video");
				var result = bufferExtensions.getTopQualityIndex("video");
				expect(result).toEqual(4);
			}
		});
		
		
		it("Deciding the Buffer Length with max duration",function(){
			debugger;
			var bufferExtensions,
				minBufferTime = 9,
				duration = 10;
			bufferExtensions = MediaPlayer.dependencies.BufferExtensions();
			bufferExtensions.decideBufferLength(minBufferTime,duration).then(function(result){
				expect(result).toEqual(9);			
			});
		});
		
		it("Deciding the Buffer Length when duration is lesser than minBufferTime",function(){
			debugger;
			var bufferExtensions,
				minBufferTime = 10,
				duration = 9;
			bufferExtensions = MediaPlayer.dependencies.BufferExtensions();
			bufferExtensions.decideBufferLength(minBufferTime,duration).then(function(result){
				expect(result).toEqual(8);			
			});						
		});
		
		it("Deciding the Buffer Length when duration and minBufferTime are lesser than DEFAULT_MIN_BUFFER_TIME",function(){			
			var bufferExtensions,
				minBufferTime = 4,
				duration = 5;
			bufferExtensions = MediaPlayer.dependencies.BufferExtensions();
			bufferExtensions.decideBufferLength(minBufferTime,duration).then(function(result){
				expect(result).toEqual(4);		
			});			
		});
	});
}