// The copyright in this software is being made available under the BSD License, included below. This software may be subject to other third party and contributor rights, including patent rights, and no such rights are granted under this license.
//
// Copyright (c) 2013, Microsoft Open Technologies, Inc.
//
// All rights reserved.
// Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
//     -             Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
//     -             Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
//     -             Neither the name of the Microsoft Open Technologies, Inc. nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

//This file contains valid MPD strings

var strMpd = {

	//http://dash.edgesuite.net/dash264/TestCases/1b/thomson-networks/manifest.mpd
	MPD1 : '<?xml version="1.0"?>\
				<MPD xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"\
				  xmlns="urn:mpeg:dash:schema:mpd:2011"\
				  xsi:schemaLocation="urn:mpeg:dash:schema:mpd:2011 DASH-MPD.xsd"\
				  type="static"\
				  minBufferTime="PT2S"\
				  profiles="urn:mpeg:dash:profile:isoff-live:2011"\
				  mediaPresentationDuration="PT234S">\
				  <Period>\
					<AdaptationSet mimeType="video/mp4" segmentAlignment="true" startWithSAP="1">\
					  <SegmentTemplate duration="2" startNumber="1" media="video_$Number$_$Bandwidth$bps.mp4" initialization="video_$Bandwidth$bps.mp4">\
					  </SegmentTemplate>\
					  <Representation id="v0" codecs="avc1.4d401e" width="720" height="576" bandwidth="900000"/>\
					  <Representation id="v1" codecs="avc1.4d401e" width="720" height="576" bandwidth="500000"/>\
					</AdaptationSet>\
					<AdaptationSet mimeType="audio/mp4" codecs="mp4a.40.5" segmentAlignment="true" startWithSAP="1">\
					  <SegmentTemplate duration="2" startNumber="1" media="audio_$Number$_$Bandwidth$bps_Input_2.mp4" initialization="audio_$Bandwidth$bps_Input_2.mp4">\
					  </SegmentTemplate>\
					  <Representation id="a2" bandwidth="56000"/>\
					</AdaptationSet>\
				  </Period>\
				</MPD>',

	//http://www.digitalprimates.net/dash/streams/gpac/mp4-main-multi-mpd-AV-NBS.mpd
	MPD2 : '<MPD xmlns="urn:mpeg:DASH:schema:MPD:2011" type="static" minBufferTime="PT1.5S" mediaPresentationDuration="PT0H10M0.00S" profiles="urn:mpeg:dash:profile:isoff-main:2011">\
				<ProgramInformation moreInformationURL="http://gpac.sourceforge.net">\
				<Title>mp4-main-multi-mpd-AV-NBS.mpd generated by GPAC</Title>\
				<Copyright>TelecomParisTech(c)2012</Copyright>\
				</ProgramInformation>\
				<Period start="PT0S" duration="PT0H10M0.00S">\
				<AdaptationSet segmentAlignment="true" maxWidth="1920" maxHeight="1080" maxFrameRate="25" par="16:9">\
				<ContentComponent id="1" contentType="video"/>\
				<Representation id="h264bl_low" mimeType="video/mp4" codecs="avc1.42c00d" width="320" height="180" frameRate="25" sar="1:1" startWithSAP="1" bandwidth="50877">\
				<SegmentList timescale="1000" duration="10000">\
				<Initialization sourceURL="mp4-main-multi-h264bl_low-.mp4"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-1.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-2.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-3.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-4.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-5.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-6.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-7.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-8.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-9.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-10.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-11.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-12.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-13.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-14.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-15.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-16.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-17.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-18.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-19.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-20.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-21.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-22.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-23.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-24.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-25.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-26.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-27.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-28.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-29.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-30.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-31.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-32.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-33.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-34.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-35.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-36.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-37.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-38.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-39.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-40.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-41.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-42.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-43.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-44.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-45.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-46.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-47.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-48.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-49.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-50.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-51.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-52.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-53.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-54.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-55.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-56.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-57.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-58.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-59.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_low-60.m4s"/>\
				</SegmentList>\
				</Representation>\
				<Representation id="h264bl_mid" mimeType="video/mp4" codecs="avc1.42c01e" width="640" height="360" frameRate="25" sar="1:1" startWithSAP="1" bandwidth="194870">\
				<SegmentList timescale="1000" duration="10000">\
				<Initialization sourceURL="mp4-main-multi-h264bl_mid-.mp4"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-1.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-2.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-3.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-4.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-5.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-6.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-7.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-8.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-9.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-10.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-11.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-12.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-13.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-14.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-15.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-16.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-17.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-18.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-19.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-20.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-21.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-22.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-23.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-24.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-25.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-26.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-27.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-28.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-29.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-30.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-31.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-32.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-33.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-34.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-35.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-36.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-37.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-38.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-39.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-40.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-41.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-42.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-43.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-44.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-45.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-46.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-47.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-48.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-49.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-50.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-51.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-52.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-53.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-54.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-55.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-56.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-57.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-58.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-59.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_mid-60.m4s"/>\
				</SegmentList>\
				</Representation>\
				<Representation id="h264bl_hd" mimeType="video/mp4" codecs="avc1.42c01f" width="1280" height="720" frameRate="25" sar="1:1" startWithSAP="1" bandwidth="514828">\
				<SegmentList timescale="1000" duration="10000">\
				<Initialization sourceURL="mp4-main-multi-h264bl_hd-.mp4"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-1.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-2.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-3.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-4.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-5.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-6.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-7.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-8.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-9.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-10.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-11.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-12.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-13.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-14.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-15.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-16.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-17.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-18.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-19.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-20.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-21.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-22.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-23.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-24.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-25.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-26.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-27.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-28.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-29.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-30.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-31.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-32.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-33.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-34.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-35.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-36.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-37.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-38.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-39.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-40.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-41.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-42.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-43.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-44.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-45.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-46.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-47.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-48.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-49.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-50.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-51.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-52.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-53.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-54.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-55.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-56.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-57.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-58.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-59.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_hd-60.m4s"/>\
				</SegmentList>\
				</Representation>\
				<Representation id="h264bl_full" mimeType="video/mp4" codecs="avc1.42c028" width="1920" height="1080" frameRate="25" sar="1:1" startWithSAP="1" bandwidth="770699">\
				<SegmentList timescale="1000" duration="10000">\
				<Initialization sourceURL="mp4-main-multi-h264bl_full-.mp4"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-1.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-2.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-3.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-4.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-5.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-6.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-7.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-8.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-9.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-10.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-11.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-12.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-13.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-14.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-15.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-16.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-17.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-18.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-19.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-20.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-21.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-22.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-23.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-24.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-25.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-26.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-27.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-28.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-29.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-30.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-31.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-32.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-33.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-34.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-35.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-36.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-37.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-38.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-39.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-40.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-41.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-42.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-43.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-44.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-45.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-46.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-47.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-48.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-49.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-50.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-51.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-52.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-53.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-54.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-55.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-56.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-57.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-58.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-59.m4s"/>\
				<SegmentURL media="mp4-main-multi-h264bl_full-60.m4s"/>\
				</SegmentList>\
				</Representation>\
				</AdaptationSet>\
				<AdaptationSet segmentAlignment="true" lang="und">\
				<ContentComponent id="1" contentType="audio" lang="und"/>\
				<Representation id="aaclc_low" mimeType="audio/mp4" codecs="mp4a.40.2" audioSamplingRate="44100" lang="und" startWithSAP="1" bandwidth="19079">\
				<AudioChannelConfiguration schemeIdUri="urn:mpeg:dash:23003:3:audio_channel_configuration:2011" value="1"/>\
				<SegmentList timescale="1000" duration="9520">\
				<Initialization sourceURL="mp4-main-multi-aaclc_low-.mp4"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-1.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-2.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-3.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-4.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-5.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-6.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-7.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-8.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-9.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-10.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-11.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-12.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-13.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-14.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-15.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-16.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-17.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-18.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-19.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-20.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-21.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-22.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-23.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-24.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-25.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-26.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-27.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-28.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-29.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-30.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-31.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-32.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-33.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-34.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-35.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-36.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-37.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-38.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-39.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-40.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-41.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-42.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-43.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-44.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-45.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-46.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-47.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-48.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-49.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-50.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-51.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-52.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-53.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-54.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-55.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-56.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-57.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-58.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-59.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-60.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-61.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-62.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-63.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_low-64.m4s"/>\
				</SegmentList>\
				</Representation>\
				<Representation id="aaclc_high" mimeType="audio/mp4" codecs="mp4a.40.2" audioSamplingRate="44100" lang="und" startWithSAP="1" bandwidth="66378">\
				<AudioChannelConfiguration schemeIdUri="urn:mpeg:dash:23003:3:audio_channel_configuration:2011" value="1"/>\
				<SegmentList timescale="1000" duration="9520">\
				<Initialization sourceURL="mp4-main-multi-aaclc_high-.mp4"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-1.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-2.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-3.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-4.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-5.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-6.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-7.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-8.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-9.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-10.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-11.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-12.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-13.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-14.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-15.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-16.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-17.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-18.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-19.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-20.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-21.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-22.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-23.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-24.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-25.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-26.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-27.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-28.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-29.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-30.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-31.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-32.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-33.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-34.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-35.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-36.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-37.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-38.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-39.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-40.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-41.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-42.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-43.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-44.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-45.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-46.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-47.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-48.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-49.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-50.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-51.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-52.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-53.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-54.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-55.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-56.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-57.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-58.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-59.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-60.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-61.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-62.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-63.m4s"/>\
				<SegmentURL media="mp4-main-multi-aaclc_high-64.m4s"/>\
				</SegmentList>\
				</Representation>\
				</AdaptationSet>\
				</Period>\
				</MPD>',

	//http://www.digitalprimates.net/dash/streams/mp4-live-template/mp4-live-mpd-AV-BS.mpd
	MPD3 : '<MPD xmlns="urn:mpeg:dash:schema:mpd:2011" type="static" minBufferTime="PT1.5S" mediaPresentationDuration="PT0H10M0.00S" profiles="urn:mpeg:dash:profile:isoff-live:2011">\
				<ProgramInformation moreInformationURL="http://gpac.sourceforge.net">\
				<Title>mp4-live-mpd-AV-BS.mpd generated by GPAC</Title>\
				<Copyright>TelecomParisTech(c)2012</Copyright>\
				</ProgramInformation>\
				<Period start="PT0S" duration="PT0H10M0.00S">\
				<AdaptationSet segmentAlignment="true" bitstreamSwitching="true" maxWidth="1920" maxHeight="1080" maxFrameRate="25" par="16:9">\
				<ContentComponent id="1" contentType="video"/>\
				<SegmentTemplate timescale="1000" duration="10000" media="mp4-live-$RepresentationID$-$Number$.m4s" startNumber="1" initialization="mp4-live-mpd-AV-BS_set1_init.mp4"/>\
				<Representation id="h264bl_low" mimeType="video/mp4" codecs="avc1.42c00d" width="320" height="180" frameRate="25" sar="1:1" startWithSAP="1" bandwidth="50842"></Representation>\
				<Representation id="h264bl_mid" mimeType="video/mp4" codecs="avc1.42c01e" width="640" height="360" frameRate="25" sar="1:1" startWithSAP="1" bandwidth="194834"></Representation>\
				<Representation id="h264bl_hd" mimeType="video/mp4" codecs="avc1.42c01f" width="1280" height="720" frameRate="25" sar="1:1" startWithSAP="1" bandwidth="514793"></Representation>\
				<Representation id="h264bl_full" mimeType="video/mp4" codecs="avc1.42c028" width="1920" height="1080" frameRate="25" sar="1:1" startWithSAP="1" bandwidth="770663"></Representation>\
				</AdaptationSet>\
				<AdaptationSet segmentAlignment="true" bitstreamSwitching="true" lang="und">\
				<AudioChannelConfiguration schemeIdUri="urn:mpeg:dash:23003:3:audio_channel_configuration:2011" value="1"/>\
				<ContentComponent id="1" contentType="audio"/>\
				<SegmentTemplate timescale="1000" duration="9520" media="mp4-live-$RepresentationID$-$Number$.m4s" startNumber="1" initialization="mp4-live-mpd-AV-BS_set2_init.mp4"/>\
				<Representation id="aaclc_low" mimeType="audio/mp4" codecs="mp4a.40.2" audioSamplingRate="44100" startWithSAP="1" bandwidth="19042"></Representation>\
				<Representation id="aaclc_high" mimeType="audio/mp4" codecs="mp4a.40.2" audioSamplingRate="44100" startWithSAP="1" bandwidth="66341"></Representation>\
				</AdaptationSet>\
				</Period>\
				</MPD>',
	//http://demo.unified-streaming.com/video/ateam/ateam.ism/ateam.mpd
	MPD4 : '<MPD xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns="urn:mpeg:dash:schema:mpd:2011"\
				  xsi:schemaLocation="urn:mpeg:dash:schema:mpd:2011 http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-DASH_schema_files/DASH-MPD.xsd"\
				  type="static"  mediaPresentationDuration="PT1M42.728S" maxSegmentDuration="PT5S" minBufferTime="PT10S" profiles="urn:mpeg:dash:profile:isoff-live:2011,urn:com:dashif:dash264,urn:hbbtv:dash:profile:isoff-live:2012">\
				  <BaseURL>http://demo.unified-streaming.com/video/ateam/ateam.ism/</BaseURL>\
				  <Period>\
					<BaseURL>dash/</BaseURL>\
					<AdaptationSet group="1" mimeType="audio/mp4" minBandwidth="148000" maxBandwidth="148000" segmentAlignment="true">\
					  <SegmentTemplate timescale="48000" initialization="ateam-$RepresentationID$.dash" media="ateam-$RepresentationID$-$Time$.dash">\
						<SegmentTimeline>\
	                     <S t="0" d="200704" />\
						  <S d="119808" />\
	                      <S d="102400" />\
	                      <S d="104448" />\
	                      <S d="141312" />\
	                      <S d="114688" />\
	                      <S d="111616" />\
	                      <S d="102400" />\
	                      <S d="116736" />\
	                      <S d="117760" />\
	                      <S d="102400" />\
	                      <S d="101376" />\
	                      <S d="102400" />\
	                      <S d="111616" />\
	                      <S d="116736" />\
	                      <S d="128000" />\
	                      <S d="138240" />\
	                      <S d="174080" />\
	                      <S d="132096" />\
	                      <S d="106496" />\
	                      <S d="105472" />\
	                      <S d="110592" />\
	                      <S d="105472" />\
	                      <S d="106496" />\
	                      <S d="102400" />\
	                      <S d="128000" />\
	                      <S d="107520" />\
	                      <S d="131072" />\
	                      <S d="189440" />\
	                      <S d="116736" />\
	                      <S d="199680" />\
	                      <S d="104448" />\
	                      <S d="102400" />\
	                      <S d="117760" />\
	                      <S d="111616" />\
	                      <S d="124928" />\
	                      <S d="117760" />\
	                      <S d="108544" />\
	                      <S d="199680" />\
	                      <S d="94208" />\
						</SegmentTimeline>\
					  </SegmentTemplate>\
					  <Representation id="audio=148000" bandwidth="148000" codecs="mp4a.40.2" audioSamplingRate="48000">\
						<AudioChannelConfiguration schemeIdUri="urn:mpeg:dash:23003:3:audio_channel_configuration:2011" value="2">\
						</AudioChannelConfiguration>\
					  </Representation>\
					</AdaptationSet>\
					<AdaptationSet group="2" mimeType="video/mp4"\
					  par="16:9" minBandwidth="475000" maxBandwidth="6589000" minWidth="176" maxWidth="1680" minHeight="99" maxHeight="944" segmentAlignment="true" startWithSAP="1">\
					  <SegmentTemplate timescale="1000" initialization="ateam-$RepresentationID$.dash" media="ateam-$RepresentationID$-$Time$.dash">\
						<SegmentTimeline>\
						  <S t="0"  d="4171" />\
	                      <S d="2503" />\
	                      <S d="2127" />\
	                      <S d="2169" />\
	                      <S d="2961" />\
	                      <S d="2377" />\
	                      <S d="2336" />\
	                      <S d="2127" />\
	                      <S d="2419" />\
	                      <S d="2461" />\
	                      <S d="2127"  r="2" />\
	                      <S d="2336" />\
	                      <S d="2419" />\
	                      <S d="2670" />\
	                      <S d="2877" />\
	                      <S d="3629" />\
	                      <S d="2753" />\
	                      <S d="2210" />\
	                      <S d="2211" />\
	                      <S d="2294" />\
	                      <S d="2210" />\
	                      <S d="2211" />\
	                      <S d="2127" />\
	                      <S d="2669" />\
	                      <S d="2253" />\
	                      <S d="2711" />\
	                      <S d="3962" />\
	                      <S d="2419" />\
	                      <S d="4171" />\
	                      <S d="2169" />\
	                      <S d="2127" />\
	                      <S d="2461" />\
	                      <S d="2335" />\
	                      <S d="2586" />\
	                      <S d="2461" />\
	                      <S d="2252" />\
	                      <S d="4171" />\
	                      <S d="2002" />\
						</SegmentTimeline>\
					  </SegmentTemplate>\
					  <Representation id="video=475000" bandwidth="475000" codecs="avc1.42C00D" width="176" height="99" frameRate="24000/1001"></Representation>\
					  <Representation id="video=639000" bandwidth="639000" codecs="avc1.42C014" width="369" height="208" frameRate="24000/1001"></Representation>\
					  <Representation id="video=2083000" bandwidth="2083000" codecs="avc1.42C01E" width="768" height="432" frameRate="24000/1001"></Representation>\
					  <Representation id="video=6589000" bandwidth="6589000" codecs="avc1.42C028" width="1680" height="944" frameRate="24000/1001"></Representation>\
					</AdaptationSet>\
				  </Period>\
				</MPD>'
};

var emptyMpdData = {
    MPD1 : '<?xml version="1.0"?>\
				<MPD xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"\
				  xmlns="urn:mpeg:dash:schema:mpd:2011"\
				  xsi:schemaLocation="urn:mpeg:dash:schema:mpd:2011 DASH-MPD.xsd"\
				  type="static"\
				  minBufferTime="PT2S"\
				  profiles="urn:mpeg:dash:profile:isoff-live:2011"\
				  mediaPresentationDuration="PT234S">\
				</MPD>',
};
