<?php
	/**
	 * Class: Main Controller
	 * The logic behind the Chyrp install.
	 */
	class MainController {
		/**
		 * Function: index
		 * Grabs the posts for the main page.
		 */
		public function index() {
			global $posts;
			$posts = new Paginator(Post::find(array("placeholders" => true)), Config::current()->posts_per_page);
		}

		/**
		 * Function: archive
		 * Grabs the posts for the Archive page when viewing a year or a month.
		 */
		public function archive() {
			global $posts;
			if (!isset($_GET['month'])) return;

			if (isset($_GET['day']))
				$posts = new Paginator(Post::find(array("placeholders" => true,
				                                        "where" => "`__posts`.`created_at` like :date",
				                                        "params" => array(":date" => $_GET['year']."-".$_GET['month']."-".$_GET['day']."%"))),
				                       Config::current()->posts_per_page);
			else
				$posts = new Paginator(Post::find(array("placeholders" => true,
				                                        "where" => "`__posts`.`created_at` like :date",
				                                        "params" => array(":date" => $_GET['year']."-".$_GET['month']."%"))),
				                       Config::current()->posts_per_page);
		}

		/**
		 * Function: search
		 * Grabs the posts for a search query.
		 */
		public function search() {
			global $posts;
			fallback($_GET['query'], "");
			$posts = new Paginator(Post::find(array("placeholders" => true,
			                                        "where" => "`xml` LIKE :query",
			                                        "params" => array(":query" => '%'.htmlspecialchars(urldecode($_GET['query'])).'%'))),
				                   Config::current()->posts_per_page);
		}

		/**
		 * Function: drafts
		 * Grabs the posts for viewing the Drafts lists. Shows an error if the user lacks permissions.
		 */
		public function drafts() {
			$visitor = Visitor::current();
			if (!$visitor->group()->can("view_own_draft", "view_draft"))
				error(__("Access Denied"), __("You do not have sufficient privileges to view drafts."));

			global $posts;
			$posts = new Paginator(Post::find(array("placeholders" => true,
			                                        "where" => array("`__posts`.`status` = 'draft'", "`__posts`.`user_id` = :current_user"),
			                                        "params" => array(":current_user" => $visitor->id))),
				                   Config::current()->posts_per_page);
		}

		/**
		 * Function: feather
		 * Views posts of a specific feather.
		 */
		public function feather() {
			global $posts;
			$posts = new Paginator(Post::find(array("placeholders" => true,
			                                        "where" => "`feather` = :feather",
			                                        "params" => array(":feather" => depluralize($_GET['feather'])))),
				                   Config::current()->posts_per_page);
		}

		/**
		 * Function: feed
		 * Grabs posts for the feed.
		 */
		public function feed() {
			global $posts;
			$posts = new Paginator(Post::find(array("placeholders" => true)), Config::current()->posts_per_page);
		}

		/**
		 * Function: rss
		 * Redirects to /feed (backwards compatibility).
		 */
		public function rss() {
			header("HTTP/1.1 301 Moved Permanently");
			redirect(Route::current()->url("feed/"));
		}

		/**
		 * Function: view
		 * Views a post.
		 */
		public function view() {
			global $post;

			$config = Config::current();
			$get = array_map("urldecode", $_GET);

			if (!$config->clean_urls)
				return $post = new Post(null, array("where" => "`__posts`.`url` = :url", "params" => array(":url" => $get['url'])));

			if ($post->no_results)
				show_404();
		}

		/**
		 * Function: id
		 * Views a post by its static ID.
		 */
		public function id() {
			global $post;
			$post = new Post($_GET['id']);
		}

		/**
		 * Function: theme_preview
		 * Handles theme previewing.
		 */
		public function theme_preview() {
			$visitor = Visitor::current();

			if (!$visitor->group()->can("change_settings")) {
				$this->index();
				return $route->action = "index";
			}

			if (empty($_GET['theme']))
				error(__("Error"), __("Please specify a theme to preview."));

			$this->index();
			return $route->action = "index";
		}

		/**
		 * Function: toggle_admin
		 * Toggles the Admin control panel (if available).
		 */
		public function toggle_admin() {
			if (!isset($_SESSION['chyrp_hide_admin']))
				$_SESSION['chyrp_hide_admin'] = true;
			else
				unset($_SESSION['chyrp_hide_admin']);

			redirect("/");
		}

		/**
		 * Function: process_registration
		 * Process registration. If registration is disabled or if the user is already logged in, it will error.
		 */
		public function process_registration() {
			$config = Config::current();
			if (!$config->can_register)
				error(__("Registration Disabled"), __("I'm sorry, but this site is not allowing registration."));
			if (logged_in())
				error(__("Error"), __("You're already logged in."));

			if (empty($_POST['login']))
				error(__("Error"), __("Please enter a username for your account."));


			$check_user = User::find(array("where" => "`login` = :login",
			                               "params" => array(":login" => $_POST['login'])));
			if (count($check_user))
				error(__("Error"), __("That username is already in use."));

			if (empty($_POST['password1']) or empty($_POST['password2']))
				error(__("Error"), __("Password cannot be blank."));
			if (empty($_POST['email']))
				error(__("Error"), __("E-mail address cannot be blank."));
			if ($_POST['password1'] != $_POST['password2'])
				error(__("Error"), __("Passwords do not match."));
			if (!eregi("^[[:alnum:]][a-z0-9_.-\+]*@[a-z0-9.-]+\.[a-z]{2,6}$",$_POST['email']))
				error(__("Error"), __("Unsupported e-mail address."));

			Trigger::current()->call('process_registration');

			User::add($_POST['login'], $_POST['password1'], $_POST['email']);

			$_SESSION['chyrp_login'] = $_POST['login'];
			$_SESSION['chyrp_password'] = md5($_POST['password1']);

			$route = Route::current();
			redirect('/');
		}

		/**
		 * Function: process_login
		 * Process logging in. If the username and password are incorrect or if the user is already logged in, it will error.
		 */
		public function process_login() {
			if (!User::authenticate($_POST['login'], md5($_POST['password'])))
				error(__("Error"), __("Login incorrect."));
			if (logged_in())
				error(__("Error"), __("You're already logged in."));

			$_SESSION['chyrp_login'] = $_POST['login'];
			$_SESSION['chyrp_password'] = md5($_POST['password']);

			redirect("/");
		}

		/**
		 * Function: logout
		 * Logs the current user out. If they are not logged in, it will error.
		 */
		public function logout() {
			if (!logged_in())
				error(__("Error"), __("You aren't logged in."));

			session_destroy();

			redirect("/");
		}

		/**
		 * Function: update_self
		 * Updates the current user when the form is submitted. Shows an error if they aren't logged in.
		 */
		public function update_self() {
			if (empty($_POST)) return;
			if (!logged_in())
				error(__("Error"), __("You must be logged in to access this area."));

			$visitor = Visitor::current();

			$password = (!empty($_POST['new_password1']) and $_POST['new_password1'] == $_POST['new_password2']) ?
			            md5($_POST['new_password1']) :
			            $visitor->password ;

			$visitor->update($visitor->login, $password, $_POST['full_name'], $_POST['email'], $_POST['website'], $visitor->group()->id);

			$_SESSION['chyrp_password'] = $password;

			redirect("/");
		}
	}
	$main = new MainController();
