/*
 * jQuery UI @VERSION
 *
 * Copyright (c) 2008 Paul Bakaus (ui.jquery.com)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://docs.jquery.com/UI
 *
 * $Date: 2008-05-04 16:52:15 +0200 (So, 04 Mai 2008) $
 * $Rev: 5419 $
 */
;(function($){$.ui={plugin:{add:function(module,option,set){var proto=$.ui[module].prototype;for(var i in set){proto.plugins[i]=proto.plugins[i]||[];proto.plugins[i].push([option,set[i]]);}},call:function(instance,name,args){var set=instance.plugins[name];if(!set){return;}
for(var i=0;i<set.length;i++){if(instance.options[set[i][0]]){set[i][1].apply(instance.element,args);}}}},cssCache:{},css:function(name){if($.ui.cssCache[name]){return $.ui.cssCache[name];}
var tmp=$('<div class="ui-resizable-gen">').addClass(name).css({position:'absolute',top:'-5000px',left:'-5000px',display:'block'}).appendTo('body');$.ui.cssCache[name]=!!((!(/auto|default/).test(tmp.css('cursor'))||(/^[1-9]/).test(tmp.css('height'))||(/^[1-9]/).test(tmp.css('width'))||!(/none/).test(tmp.css('backgroundImage'))||!(/transparent|rgba\(0, 0, 0, 0\)/).test(tmp.css('backgroundColor'))));try{$('body').get(0).removeChild(tmp.get(0));}catch(e){}
return $.ui.cssCache[name];},disableSelection:function(e){e.unselectable="on";e.onselectstart=function(){return false;};if(e.style){e.style.MozUserSelect="none";}},enableSelection:function(e){e.unselectable="off";e.onselectstart=function(){return true;};if(e.style){e.style.MozUserSelect="";}},hasScroll:function(e,a){var scroll=/top/.test(a||"top")?'scrollTop':'scrollLeft',has=false;if(e[scroll]>0)return true;e[scroll]=1;has=e[scroll]>0?true:false;e[scroll]=0;return has;}};var _remove=$.fn.remove;$.fn.remove=function(){$("*",this).add(this).trigger("remove");return _remove.apply(this,arguments);};function getter(namespace,plugin,method){var methods=$[namespace][plugin].getter||[];methods=(typeof methods=="string"?methods.split(/,?\s+/):methods);return($.inArray(method,methods)!=-1);}
$.widget=function(name,prototype){var namespace=name.split(".")[0];name=name.split(".")[1];$.fn[name]=function(options){var isMethodCall=(typeof options=='string'),args=Array.prototype.slice.call(arguments,1);if(isMethodCall&&getter(namespace,name,options)){var instance=$.data(this[0],name);return(instance?instance[options].apply(instance,args):undefined);}
return this.each(function(){var instance=$.data(this,name);if(isMethodCall&&instance&&$.isFunction(instance[options])){instance[options].apply(instance,args);}else if(!isMethodCall){$.data(this,name,new $[namespace][name](this,options));}});};$[namespace][name]=function(element,options){var self=this;this.widgetName=name;this.widgetBaseClass=namespace+'-'+name;this.options=$.extend({disabled:false},$[namespace][name].defaults,options);this.element=$(element).bind('setData.'+name,function(e,key,value){return self.setData(key,value);}).bind('getData.'+name,function(e,key){return self.getData(key);}).bind('remove',function(){return self.destroy();});this.init();};$[namespace][name].prototype=$.extend({},$.widget.prototype,prototype);};$.widget.prototype={init:function(){},destroy:function(){this.element.removeData(this.widgetName);},getData:function(key){return this.options[key];},setData:function(key,value){this.options[key]=value;if(key=='disabled'){this.element[value?'addClass':'removeClass'](this.widgetBaseClass+'-disabled');}},enable:function(){this.setData('disabled',false);},disable:function(){this.setData('disabled',true);}};$.ui.mouse={mouseInit:function(){var self=this;this.element.bind('mousedown.'+this.widgetName,function(e){return self.mouseDown(e);});if($.browser.msie){this._mouseUnselectable=this.element.attr('unselectable');this.element.attr('unselectable','on');}
this.started=false;},mouseDestroy:function(){this.element.unbind('.'+this.widgetName);($.browser.msie&&this.element.attr('unselectable',this._mouseUnselectable));},mouseDown:function(e){(this._mouseStarted&&this.mouseUp(e));this._mouseDownEvent=e;var self=this,btnIsLeft=(e.which==1),elIsCancel=(typeof this.options.cancel=="string"?$(e.target).is(this.options.cancel):false);if(!btnIsLeft||elIsCancel||!this.mouseCapture(e)){return true;}
this._mouseDelayMet=!this.options.delay;if(!this._mouseDelayMet){this._mouseDelayTimer=setTimeout(function(){self._mouseDelayMet=true;},this.options.delay);}
if(this.mouseDistanceMet(e)&&this.mouseDelayMet(e)){this._mouseStarted=(this.mouseStart(e)!==false);if(!this._mouseStarted){e.preventDefault();return true;}}
this._mouseMoveDelegate=function(e){return self.mouseMove(e);};this._mouseUpDelegate=function(e){return self.mouseUp(e);};$(document).bind('mousemove.'+this.widgetName,this._mouseMoveDelegate).bind('mouseup.'+this.widgetName,this._mouseUpDelegate);return false;},mouseMove:function(e){if($.browser.msie&&!e.button){return this.mouseUp(e);}
if(this._mouseStarted){this.mouseDrag(e);return false;}
if(this.mouseDistanceMet(e)&&this.mouseDelayMet(e)){this._mouseStarted=(this.mouseStart(this._mouseDownEvent,e)!==false);(this._mouseStarted?this.mouseDrag(e):this.mouseUp(e));}
return!this._mouseStarted;},mouseUp:function(e){$(document).unbind('mousemove.'+this.widgetName,this._mouseMoveDelegate).unbind('mouseup.'+this.widgetName,this._mouseUpDelegate);if(this._mouseStarted){this._mouseStarted=false;this.mouseStop(e);}
return false;},mouseDistanceMet:function(e){return(Math.max(Math.abs(this._mouseDownEvent.pageX-e.pageX),Math.abs(this._mouseDownEvent.pageY-e.pageY))>=this.options.distance);},mouseDelayMet:function(e){return this._mouseDelayMet;},mouseStart:function(e){},mouseDrag:function(e){},mouseStop:function(e){},mouseCapture:function(e){return true;}};$.ui.mouse.defaults={cancel:null,distance:1,delay:0};})(jQuery);(function($){$.widget("ui.draggable",$.extend($.ui.mouse,{init:function(){var o=this.options;if(o.helper=='original'&&!(/(relative|absolute|fixed)/).test(this.element.css('position')))
this.element.css('position','relative');this.element.addClass('ui-draggable');(o.disabled&&this.element.addClass('ui-draggable-disabled'));this.mouseInit();},mouseStart:function(e){var o=this.options;if(this.helper||o.disabled||$(e.target).is('.ui-resizable-handle'))return false;var handle=!this.options.handle||!$(this.options.handle,this.element).length?true:false;$(this.options.handle,this.element).find("*").andSelf().each(function(){if(this==e.target)handle=true;});if(!handle)return false;if($.ui.ddmanager)$.ui.ddmanager.current=this;this.helper=$.isFunction(o.helper)?$(o.helper.apply(this.element[0],[e])):(o.helper=='clone'?this.element.clone():this.element);if(!this.helper.parents('body').length)this.helper.appendTo((o.appendTo=='parent'?this.element[0].parentNode:o.appendTo));if(this.helper[0]!=this.element[0]&&!(/(fixed|absolute)/).test(this.helper.css("position")))this.helper.css("position","absolute");this.margins={left:(parseInt(this.element.css("marginLeft"),10)||0),top:(parseInt(this.element.css("marginTop"),10)||0)};this.cssPosition=this.helper.css("position");this.offset=this.element.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};this.offset.click={left:e.pageX-this.offset.left,top:e.pageY-this.offset.top};this.offsetParent=this.helper.offsetParent();var po=this.offsetParent.offset();if(this.offsetParent[0]==document.body&&$.browser.mozilla)po={top:0,left:0};this.offset.parent={top:po.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:po.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)};var p=this.element.position();this.offset.relative=this.cssPosition=="relative"?{top:p.top-(parseInt(this.helper.css("top"),10)||0)+this.offsetParent[0].scrollTop,left:p.left-(parseInt(this.helper.css("left"),10)||0)+this.offsetParent[0].scrollLeft}:{top:0,left:0};this.originalPosition=this.generatePosition(e);this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()};if(o.cursorAt){if(o.cursorAt.left!=undefined)this.offset.click.left=o.cursorAt.left+this.margins.left;if(o.cursorAt.right!=undefined)this.offset.click.left=this.helperProportions.width-o.cursorAt.right+this.margins.left;if(o.cursorAt.top!=undefined)this.offset.click.top=o.cursorAt.top+this.margins.top;if(o.cursorAt.bottom!=undefined)this.offset.click.top=this.helperProportions.height-o.cursorAt.bottom+this.margins.top;}
if(o.containment){if(o.containment=='parent')o.containment=this.helper[0].parentNode;if(o.containment=='document'||o.containment=='window')this.containment=[0-this.offset.relative.left-this.offset.parent.left,0-this.offset.relative.top-this.offset.parent.top,$(o.containment=='document'?document:window).width()-this.offset.relative.left-this.offset.parent.left-this.helperProportions.width-this.margins.left-(parseInt(this.element.css("marginRight"),10)||0),($(o.containment=='document'?document:window).height()||document.body.parentNode.scrollHeight)-this.offset.relative.top-this.offset.parent.top-this.helperProportions.height-this.margins.top-(parseInt(this.element.css("marginBottom"),10)||0)];if(!(/^(document|window|parent)$/).test(o.containment)){var ce=$(o.containment)[0];var co=$(o.containment).offset();this.containment=[co.left+(parseInt($(ce).css("borderLeftWidth"),10)||0)-this.offset.relative.left-this.offset.parent.left,co.top+(parseInt($(ce).css("borderTopWidth"),10)||0)-this.offset.relative.top-this.offset.parent.top,co.left+Math.max(ce.scrollWidth,ce.offsetWidth)-(parseInt($(ce).css("borderLeftWidth"),10)||0)-this.offset.relative.left-this.offset.parent.left-this.helperProportions.width-this.margins.left-(parseInt(this.element.css("marginRight"),10)||0),co.top+Math.max(ce.scrollHeight,ce.offsetHeight)-(parseInt($(ce).css("borderTopWidth"),10)||0)-this.offset.relative.top-this.offset.parent.top-this.helperProportions.height-this.margins.top-(parseInt(this.element.css("marginBottom"),10)||0)];}}
this.propagate("start",e);this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()};if($.ui.ddmanager&&!o.dropBehaviour)$.ui.ddmanager.prepareOffsets(this,e);this.helper.addClass("ui-draggable-dragging");this.mouseDrag(e);return true;},convertPositionTo:function(d,pos){if(!pos)pos=this.position;var mod=d=="absolute"?1:-1;return{top:(pos.top
+this.offset.relative.top*mod
+this.offset.parent.top*mod
-(this.cssPosition=="fixed"||(this.cssPosition=="absolute"&&this.offsetParent[0]==document.body)?0:this.offsetParent[0].scrollTop)*mod
+(this.cssPosition=="fixed"?this.offsetParent[0].scrollTop:0)*mod
+this.margins.top*mod),left:(pos.left
+this.offset.relative.left*mod
+this.offset.parent.left*mod
-(this.cssPosition=="fixed"||(this.cssPosition=="absolute"&&this.offsetParent[0]==document.body)?0:this.offsetParent[0].scrollLeft)*mod
+(this.cssPosition=="fixed"?this.offsetParent[0].scrollLeft:0)*mod
+this.margins.left*mod)};},generatePosition:function(e){var o=this.options;var position={top:(e.pageY
-this.offset.click.top
-this.offset.relative.top
-this.offset.parent.top
+(this.cssPosition=="fixed"||(this.cssPosition=="absolute"&&this.offsetParent[0]==document.body)?0:this.offsetParent[0].scrollTop)
-(this.cssPosition=="fixed"?this.offsetParent[0].scrollTop:0)),left:(e.pageX
-this.offset.click.left
-this.offset.relative.left
-this.offset.parent.left
+(this.cssPosition=="fixed"||(this.cssPosition=="absolute"&&this.offsetParent[0]==document.body)?0:this.offsetParent[0].scrollLeft)
-(this.cssPosition=="fixed"?this.offsetParent[0].scrollLeft:0))};if(!this.originalPosition)return position;if(this.containment){if(position.left<this.containment[0])position.left=this.containment[0];if(position.top<this.containment[1])position.top=this.containment[1];if(position.left>this.containment[2])position.left=this.containment[2];if(position.top>this.containment[3])position.top=this.containment[3];}
if(o.grid){var top=this.originalPosition.top+Math.round((position.top-this.originalPosition.top)/o.grid[1])*o.grid[1];position.top=this.containment?(!(top<this.containment[1]||top>this.containment[3])?top:(!(top<this.containment[1])?top-o.grid[1]:top+o.grid[1])):top;var left=this.originalPosition.left+Math.round((position.left-this.originalPosition.left)/o.grid[0])*o.grid[0];position.left=this.containment?(!(left<this.containment[0]||left>this.containment[2])?left:(!(left<this.containment[0])?left-o.grid[0]:left+o.grid[0])):left;}
return position;},mouseDrag:function(e){this.position=this.generatePosition(e);this.positionAbs=this.convertPositionTo("absolute");this.position=this.propagate("drag",e)||this.position;if(!this.options.axis||this.options.axis!="y")this.helper[0].style.left=this.position.left+'px';if(!this.options.axis||this.options.axis!="x")this.helper[0].style.top=this.position.top+'px';if($.ui.ddmanager)$.ui.ddmanager.drag(this,e);return false;},mouseStop:function(e){if($.ui.ddmanager&&!this.options.dropBehaviour)
$.ui.ddmanager.drop(this,e);if(this.options.revert){var self=this;$(this.helper).animate(this.originalPosition,parseInt(this.options.revert,10)||500,function(){self.propagate("stop",e);self.clear();});}else{this.propagate("stop",e);this.clear();}
return false;},clear:function(){this.helper.removeClass("ui-draggable-dragging");if(this.options.helper!='original'&&!this.cancelHelperRemoval)this.helper.remove();this.helper=null;this.cancelHelperRemoval=false;},plugins:{},uiHash:function(e){return{helper:this.helper,position:this.position,absolutePosition:this.positionAbs,options:this.options};},propagate:function(n,e){$.ui.plugin.call(this,n,[e,this.uiHash()]);return this.element.triggerHandler(n=="drag"?n:"drag"+n,[e,this.uiHash()],this.options[n]);},destroy:function(){if(!this.element.data('draggable'))return;this.element.removeData("draggable").unbind(".draggable").removeClass('ui-draggable');this.mouseDestroy();}}));$.extend($.ui.draggable,{defaults:{appendTo:"parent",axis:false,cancel:":input,button",delay:0,distance:0,helper:"original"}});$.ui.plugin.add("draggable","cursor",{start:function(e,ui){var t=$('body');if(t.css("cursor"))ui.options._cursor=t.css("cursor");t.css("cursor",ui.options.cursor);},stop:function(e,ui){if(ui.options._cursor)$('body').css("cursor",ui.options._cursor);}});$.ui.plugin.add("draggable","zIndex",{start:function(e,ui){var t=$(ui.helper);if(t.css("zIndex"))ui.options._zIndex=t.css("zIndex");t.css('zIndex',ui.options.zIndex);},stop:function(e,ui){if(ui.options._zIndex)$(ui.helper).css('zIndex',ui.options._zIndex);}});$.ui.plugin.add("draggable","opacity",{start:function(e,ui){var t=$(ui.helper);if(t.css("opacity"))ui.options._opacity=t.css("opacity");t.css('opacity',ui.options.opacity);},stop:function(e,ui){if(ui.options._opacity)$(ui.helper).css('opacity',ui.options._opacity);}});$.ui.plugin.add("draggable","iframeFix",{start:function(e,ui){$(ui.options.iframeFix===true?"iframe":ui.options.iframeFix).each(function(){$('<div class="ui-draggable-iframeFix" style="background: #fff;"></div>').css({width:this.offsetWidth+"px",height:this.offsetHeight+"px",position:"absolute",opacity:"0.001",zIndex:1000}).css($(this).offset()).appendTo("body");});},stop:function(e,ui){$("div.DragDropIframeFix").each(function(){this.parentNode.removeChild(this);});}});$.ui.plugin.add("draggable","scroll",{start:function(e,ui){var o=ui.options;var i=$(this).data("draggable");o.scrollSensitivity=o.scrollSensitivity||20;o.scrollSpeed=o.scrollSpeed||20;i.overflowY=function(el){do{if(/auto|scroll/.test(el.css('overflow'))||(/auto|scroll/).test(el.css('overflow-y')))return el;el=el.parent();}while(el[0].parentNode);return $(document);}(this);i.overflowX=function(el){do{if(/auto|scroll/.test(el.css('overflow'))||(/auto|scroll/).test(el.css('overflow-x')))return el;el=el.parent();}while(el[0].parentNode);return $(document);}(this);if(i.overflowY[0]!=document&&i.overflowY[0].tagName!='HTML')i.overflowYOffset=i.overflowY.offset();if(i.overflowX[0]!=document&&i.overflowX[0].tagName!='HTML')i.overflowXOffset=i.overflowX.offset();},drag:function(e,ui){var o=ui.options;var i=$(this).data("draggable");if(i.overflowY[0]!=document&&i.overflowY[0].tagName!='HTML'){if((i.overflowYOffset.top+i.overflowY[0].offsetHeight)-e.pageY<o.scrollSensitivity)
i.overflowY[0].scrollTop=i.overflowY[0].scrollTop+o.scrollSpeed;if(e.pageY-i.overflowYOffset.top<o.scrollSensitivity)
i.overflowY[0].scrollTop=i.overflowY[0].scrollTop-o.scrollSpeed;}else{if(e.pageY-$(document).scrollTop()<o.scrollSensitivity)
$(document).scrollTop($(document).scrollTop()-o.scrollSpeed);if($(window).height()-(e.pageY-$(document).scrollTop())<o.scrollSensitivity)
$(document).scrollTop($(document).scrollTop()+o.scrollSpeed);}
if(i.overflowX[0]!=document&&i.overflowX[0].tagName!='HTML'){if((i.overflowXOffset.left+i.overflowX[0].offsetWidth)-e.pageX<o.scrollSensitivity)
i.overflowX[0].scrollLeft=i.overflowX[0].scrollLeft+o.scrollSpeed;if(e.pageX-i.overflowXOffset.left<o.scrollSensitivity)
i.overflowX[0].scrollLeft=i.overflowX[0].scrollLeft-o.scrollSpeed;}else{if(e.pageX-$(document).scrollLeft()<o.scrollSensitivity)
$(document).scrollLeft($(document).scrollLeft()-o.scrollSpeed);if($(window).width()-(e.pageX-$(document).scrollLeft())<o.scrollSensitivity)
$(document).scrollLeft($(document).scrollLeft()+o.scrollSpeed);}}});$.ui.plugin.add("draggable","snap",{start:function(e,ui){var inst=$(this).data("draggable");inst.snapElements=[];$(ui.options.snap===true?'.ui-draggable':ui.options.snap).each(function(){var $t=$(this);var $o=$t.offset();if(this!=inst.element[0])inst.snapElements.push({item:this,width:$t.outerWidth(),height:$t.outerHeight(),top:$o.top,left:$o.left});});},drag:function(e,ui){var inst=$(this).data("draggable");var d=ui.options.snapTolerance||20;var x1=ui.absolutePosition.left,x2=x1+inst.helperProportions.width,y1=ui.absolutePosition.top,y2=y1+inst.helperProportions.height;for(var i=inst.snapElements.length-1;i>=0;i--){var l=inst.snapElements[i].left,r=l+inst.snapElements[i].width,t=inst.snapElements[i].top,b=t+inst.snapElements[i].height;if(!((l-d<x1&&x1<r+d&&t-d<y1&&y1<b+d)||(l-d<x1&&x1<r+d&&t-d<y2&&y2<b+d)||(l-d<x2&&x2<r+d&&t-d<y1&&y1<b+d)||(l-d<x2&&x2<r+d&&t-d<y2&&y2<b+d)))continue;if(ui.options.snapMode!='inner'){var ts=Math.abs(t-y2)<=20;var bs=Math.abs(b-y1)<=20;var ls=Math.abs(l-x2)<=20;var rs=Math.abs(r-x1)<=20;if(ts)ui.position.top=inst.convertPositionTo("relative",{top:t-inst.helperProportions.height,left:0}).top;if(bs)ui.position.top=inst.convertPositionTo("relative",{top:b,left:0}).top;if(ls)ui.position.left=inst.convertPositionTo("relative",{top:0,left:l-inst.helperProportions.width}).left;if(rs)ui.position.left=inst.convertPositionTo("relative",{top:0,left:r}).left;}
if(ui.options.snapMode!='outer'){var ts=Math.abs(t-y1)<=20;var bs=Math.abs(b-y2)<=20;var ls=Math.abs(l-x1)<=20;var rs=Math.abs(r-x2)<=20;if(ts)ui.position.top=inst.convertPositionTo("relative",{top:t,left:0}).top;if(bs)ui.position.top=inst.convertPositionTo("relative",{top:b-inst.helperProportions.height,left:0}).top;if(ls)ui.position.left=inst.convertPositionTo("relative",{top:0,left:l}).left;if(rs)ui.position.left=inst.convertPositionTo("relative",{top:0,left:r-inst.helperProportions.width}).left;}};}});$.ui.plugin.add("draggable","connectToSortable",{start:function(e,ui){var inst=$(this).data("draggable");inst.sortables=[];$(ui.options.connectToSortable).each(function(){if($.data(this,'sortable')){var sortable=$.data(this,'sortable');inst.sortables.push({instance:sortable,shouldRevert:sortable.options.revert});sortable.refresh();sortable.propagate("activate",e,inst);}});},stop:function(e,ui){var inst=$(this).data("draggable");$.each(inst.sortables,function(){if(this.instance.isOver){this.instance.isOver=0;inst.cancelHelperRemoval=true;this.instance.cancelHelperRemoval=false;if(this.shouldRevert)this.instance.options.revert=true;this.instance.mouseStop(e);this.instance.element.triggerHandler("sortreceive",[e,$.extend(this.instance.ui(),{sender:inst.element})],this.instance.options["receive"]);this.instance.options.helper=this.instance.options._helper;}else{this.instance.propagate("deactivate",e,inst);}});},drag:function(e,ui){var inst=$(this).data("draggable"),self=this;var checkPos=function(o){var l=o.left,r=l+o.width,t=o.top,b=t+o.height;return(l<(this.positionAbs.left+this.offset.click.left)&&(this.positionAbs.left+this.offset.click.left)<r&&t<(this.positionAbs.top+this.offset.click.top)&&(this.positionAbs.top+this.offset.click.top)<b);};$.each(inst.sortables,function(i){if(checkPos.call(inst,this.instance.containerCache)){if(!this.instance.isOver){this.instance.isOver=1;this.instance.currentItem=$(self).clone().appendTo(this.instance.element).data("sortable-item",true);this.instance.options._helper=this.instance.options.helper;this.instance.options.helper=function(){return ui.helper[0];};e.target=this.instance.currentItem[0];this.instance.mouseCapture(e,true,true);this.instance.mouseStart(e,true,true);this.instance.offset.click.top=inst.offset.click.top;this.instance.offset.click.left=inst.offset.click.left;this.instance.offset.parent.left-=inst.offset.parent.left-this.instance.offset.parent.left;this.instance.offset.parent.top-=inst.offset.parent.top-this.instance.offset.parent.top;inst.propagate("toSortable",e);}
if(this.instance.currentItem)this.instance.mouseDrag(e);}else{if(this.instance.isOver){this.instance.isOver=0;this.instance.cancelHelperRemoval=true;this.instance.options.revert=false;this.instance.mouseStop(e,true);this.instance.options.helper=this.instance.options._helper;this.instance.currentItem.remove();this.instance.placeholder.remove();inst.propagate("fromSortable",e);}};});}});$.ui.plugin.add("draggable","stack",{start:function(e,ui){var group=$.makeArray($(ui.options.stack.group)).sort(function(a,b){return(parseInt($(a).css("zIndex"),10)||ui.options.stack.min)-(parseInt($(b).css("zIndex"),10)||ui.options.stack.min);});$(group).each(function(i){this.style.zIndex=ui.options.stack.min+i;});this[0].style.zIndex=ui.options.stack.min+group.length;}});})(jQuery);(function($){$.widget("ui.droppable",{init:function(){this.element.addClass("ui-droppable");this.isover=0;this.isout=1;var o=this.options,accept=o.accept;o=$.extend(o,{accept:o.accept&&o.accept.constructor==Function?o.accept:function(d){return $(d).is(accept);}});this.proportions={width:this.element.outerWidth(),height:this.element.outerHeight()};$.ui.ddmanager.droppables.push(this);},plugins:{},ui:function(c){return{draggable:(c.currentItem||c.element),helper:c.helper,position:c.position,absolutePosition:c.positionAbs,options:this.options,element:this.element};},destroy:function(){var drop=$.ui.ddmanager.droppables;for(var i=0;i<drop.length;i++)
if(drop[i]==this)
drop.splice(i,1);this.element.removeClass("ui-droppable ui-droppable-disabled").removeData("droppable").unbind(".droppable");},over:function(e){var draggable=$.ui.ddmanager.current;if(!draggable||(draggable.currentItem||draggable.element)[0]==this.element[0])return;if(this.options.accept.call(this.element,(draggable.currentItem||draggable.element))){$.ui.plugin.call(this,'over',[e,this.ui(draggable)]);this.element.triggerHandler("dropover",[e,this.ui(draggable)],this.options.over);}},out:function(e){var draggable=$.ui.ddmanager.current;if(!draggable||(draggable.currentItem||draggable.element)[0]==this.element[0])return;if(this.options.accept.call(this.element,(draggable.currentItem||draggable.element))){$.ui.plugin.call(this,'out',[e,this.ui(draggable)]);this.element.triggerHandler("dropout",[e,this.ui(draggable)],this.options.out);}},drop:function(e,custom){var draggable=custom||$.ui.ddmanager.current;if(!draggable||(draggable.currentItem||draggable.element)[0]==this.element[0])return false;var childrenIntersection=false;this.element.find(".ui-droppable").not(".ui-draggable-dragging").each(function(){var inst=$.data(this,'droppable');if(inst.options.greedy&&$.ui.intersect(draggable,$.extend(inst,{offset:inst.element.offset()}),inst.options.tolerance)){childrenIntersection=true;return false;}});if(childrenIntersection)return false;if(this.options.accept.call(this.element,(draggable.currentItem||draggable.element))){$.ui.plugin.call(this,'drop',[e,this.ui(draggable)]);this.element.triggerHandler("drop",[e,this.ui(draggable)],this.options.drop);return true;}
return false;},activate:function(e){var draggable=$.ui.ddmanager.current;$.ui.plugin.call(this,'activate',[e,this.ui(draggable)]);if(draggable)this.element.triggerHandler("dropactivate",[e,this.ui(draggable)],this.options.activate);},deactivate:function(e){var draggable=$.ui.ddmanager.current;$.ui.plugin.call(this,'deactivate',[e,this.ui(draggable)]);if(draggable)this.element.triggerHandler("dropdeactivate",[e,this.ui(draggable)],this.options.deactivate);}});$.extend($.ui.droppable,{defaults:{disabled:false,tolerance:'intersect'}});$.ui.intersect=function(draggable,droppable,toleranceMode){if(!droppable.offset)return false;var x1=(draggable.positionAbs||draggable.position.absolute).left,x2=x1+draggable.helperProportions.width,y1=(draggable.positionAbs||draggable.position.absolute).top,y2=y1+draggable.helperProportions.height;var l=droppable.offset.left,r=l+droppable.proportions.width,t=droppable.offset.top,b=t+droppable.proportions.height;switch(toleranceMode){case'fit':return(l<x1&&x2<r&&t<y1&&y2<b);break;case'intersect':return(l<x1+(draggable.helperProportions.width/2)&&x2-(draggable.helperProportions.width/2)<r&&t<y1+(draggable.helperProportions.height/2)&&y2-(draggable.helperProportions.height/2)<b);break;case'pointer':return(l<((draggable.positionAbs||draggable.position.absolute).left+(draggable.clickOffset||draggable.offset.click).left)&&((draggable.positionAbs||draggable.position.absolute).left+(draggable.clickOffset||draggable.offset.click).left)<r&&t<((draggable.positionAbs||draggable.position.absolute).top+(draggable.clickOffset||draggable.offset.click).top)&&((draggable.positionAbs||draggable.position.absolute).top+(draggable.clickOffset||draggable.offset.click).top)<b);break;case'touch':return((y1>=t&&y1<=b)||(y2>=t&&y2<=b)||(y1<t&&y2>b))&&((x1>=l&&x1<=r)||(x2>=l&&x2<=r)||(x1<l&&x2>r));break;default:return false;break;}};$.ui.ddmanager={current:null,droppables:[],prepareOffsets:function(t,e){var m=$.ui.ddmanager.droppables;var type=e?e.type:null;for(var i=0;i<m.length;i++){if(m[i].options.disabled||(t&&!m[i].options.accept.call(m[i].element,(t.currentItem||t.element))))continue;m[i].visible=m[i].element.is(":visible");if(!m[i].visible)continue;m[i].offset=m[i].element.offset();m[i].proportions={width:m[i].element.outerWidth(),height:m[i].element.outerHeight()};if(type=="dragstart"||type=="sortactivate")m[i].activate.call(m[i],e);}},drop:function(draggable,e){var dropped=false;$.each($.ui.ddmanager.droppables,function(){if(!this.options)return;if(!this.options.disabled&&this.visible&&$.ui.intersect(draggable,this,this.options.tolerance))
dropped=this.drop.call(this,e);if(!this.options.disabled&&this.visible&&this.options.accept.call(this.element,(draggable.currentItem||draggable.element))){this.isout=1;this.isover=0;this.deactivate.call(this,e);}});return dropped;},drag:function(draggable,e){if(draggable.options.refreshPositions)$.ui.ddmanager.prepareOffsets(draggable,e);$.each($.ui.ddmanager.droppables,function(){if(this.disabled||this.greedyChild||!this.visible)return;var intersects=$.ui.intersect(draggable,this,this.options.tolerance);var c=!intersects&&this.isover==1?'isout':(intersects&&this.isover==0?'isover':null);if(!c)return;var parentInstance;if(this.options.greedy){var parent=this.element.parents('.ui-droppable:eq(0)');if(parent.length){parentInstance=$.data(parent[0],'droppable');parentInstance.greedyChild=(c=='isover'?1:0);}}
if(parentInstance&&c=='isover'){parentInstance['isover']=0;parentInstance['isout']=1;parentInstance.out.call(parentInstance,e);}
this[c]=1;this[c=='isout'?'isover':'isout']=0;this[c=="isover"?"over":"out"].call(this,e);if(parentInstance&&c=='isout'){parentInstance['isout']=0;parentInstance['isover']=1;parentInstance.over.call(parentInstance,e);}});}};$.ui.plugin.add("droppable","activeClass",{activate:function(e,ui){$(this).addClass(ui.options.activeClass);},deactivate:function(e,ui){$(this).removeClass(ui.options.activeClass);},drop:function(e,ui){$(this).removeClass(ui.options.activeClass);}});$.ui.plugin.add("droppable","hoverClass",{over:function(e,ui){$(this).addClass(ui.options.hoverClass);},out:function(e,ui){$(this).removeClass(ui.options.hoverClass);},drop:function(e,ui){$(this).removeClass(ui.options.hoverClass);}});})(jQuery);(function($){function contains(a,b){var safari2=$.browser.safari&&$.browser.version<522;if(a.contains&&!safari2){return a.contains(b);}
if(a.compareDocumentPosition)
return!!(a.compareDocumentPosition(b)&16);while(b=b.parentNode)
if(b==a)return true;return false;};$.widget("ui.sortable",$.extend($.ui.mouse,{init:function(){var o=this.options;this.containerCache={};this.element.addClass("ui-sortable");this.refresh();this.floating=this.items.length?(/left|right/).test(this.items[0].item.css('float')):false;if(!(/(relative|absolute|fixed)/).test(this.element.css('position')))this.element.css('position','relative');this.offset=this.element.offset();this.mouseInit();},plugins:{},ui:function(inst){return{helper:(inst||this)["helper"],placeholder:(inst||this)["placeholder"]||$([]),position:(inst||this)["position"],absolutePosition:(inst||this)["positionAbs"],options:this.options,element:this.element,item:(inst||this)["currentItem"],sender:inst?inst.element:null};},propagate:function(n,e,inst,noPropagation){$.ui.plugin.call(this,n,[e,this.ui(inst)]);if(!noPropagation)this.element.triggerHandler(n=="sort"?n:"sort"+n,[e,this.ui(inst)],this.options[n]);},serialize:function(o){var items=($.isFunction(this.options.items)?this.options.items.call(this.element):$(this.options.items,this.element)).not('.ui-sortable-helper');var str=[];o=o||{};items.each(function(){var res=($(this).attr(o.attribute||'id')||'').match(o.expression||(/(.+)[-=_](.+)/));if(res)str.push((o.key||res[1])+'[]='+(o.key?res[1]:res[2]));});return str.join('&');},toArray:function(attr){var items=($.isFunction(this.options.items)?this.options.items.call(this.element):$(this.options.items,this.element)).not('.ui-sortable-helper');var ret=[];items.each(function(){ret.push($(this).attr(attr||'id'));});return ret;},intersectsWith:function(item){var x1=this.positionAbs.left,x2=x1+this.helperProportions.width,y1=this.positionAbs.top,y2=y1+this.helperProportions.height;var l=item.left,r=l+item.width,t=item.top,b=t+item.height;if(this.options.tolerance=="pointer"||(this.options.tolerance=="guess"&&this.helperProportions[this.floating?'width':'height']>item[this.floating?'width':'height'])){return(y1+this.offset.click.top>t&&y1+this.offset.click.top<b&&x1+this.offset.click.left>l&&x1+this.offset.click.left<r);}else{return(l<x1+(this.helperProportions.width/2)&&x2-(this.helperProportions.width/2)<r&&t<y1+(this.helperProportions.height/2)&&y2-(this.helperProportions.height/2)<b);}},intersectsWithEdge:function(item){var x1=this.positionAbs.left,x2=x1+this.helperProportions.width,y1=this.positionAbs.top,y2=y1+this.helperProportions.height;var l=item.left,r=l+item.width,t=item.top,b=t+item.height;if(this.options.tolerance=="pointer"||(this.options.tolerance=="guess"&&this.helperProportions[this.floating?'width':'height']>item[this.floating?'width':'height'])){if(!(y1+this.offset.click.top>t&&y1+this.offset.click.top<b&&x1+this.offset.click.left>l&&x1+this.offset.click.left<r))return false;if(this.floating){if(x1+this.offset.click.left>l&&x1+this.offset.click.left<l+item.width/2)return 2;if(x1+this.offset.click.left>l+item.width/2&&x1+this.offset.click.left<r)return 1;}else{if(y1+this.offset.click.top>t&&y1+this.offset.click.top<t+item.height/2)return 2;if(y1+this.offset.click.top>t+item.height/2&&y1+this.offset.click.top<b)return 1;}}else{if(!(l<x1+(this.helperProportions.width/2)&&x2-(this.helperProportions.width/2)<r&&t<y1+(this.helperProportions.height/2)&&y2-(this.helperProportions.height/2)<b))return false;if(this.floating){if(x2>l&&x1<l)return 2;if(x1<r&&x2>r)return 1;}else{if(y2>t&&y1<t)return 1;if(y1<b&&y2>b)return 2;}}
return false;},refresh:function(){this.refreshItems();this.refreshPositions();},refreshItems:function(){this.items=[];this.containers=[this];var items=this.items;var queries=[$.isFunction(this.options.items)?this.options.items.call(this.element):$(this.options.items,this.element)];if(this.options.connectWith){for(var i=this.options.connectWith.length-1;i>=0;i--){var cur=$(this.options.connectWith[i]);for(var j=cur.length-1;j>=0;j--){var inst=$.data(cur[j],'sortable');if(inst&&!inst.options.disabled){queries.push($.isFunction(inst.options.items)?inst.options.items.call(inst.element):$(inst.options.items,inst.element));this.containers.push(inst);}};};}
for(var i=queries.length-1;i>=0;i--){queries[i].each(function(){$.data(this,'sortable-item',true);items.push({item:$(this),width:0,height:0,left:0,top:0});});};},refreshPositions:function(fast){for(var i=this.items.length-1;i>=0;i--){var t=this.items[i].item;if(!fast)this.items[i].width=(this.options.toleranceElement?$(this.options.toleranceElement,t):t).outerWidth();if(!fast)this.items[i].height=(this.options.toleranceElement?$(this.options.toleranceElement,t):t).outerHeight();var p=(this.options.toleranceElement?$(this.options.toleranceElement,t):t).offset();this.items[i].left=p.left;this.items[i].top=p.top;};for(var i=this.containers.length-1;i>=0;i--){var p=this.containers[i].element.offset();this.containers[i].containerCache.left=p.left;this.containers[i].containerCache.top=p.top;this.containers[i].containerCache.width=this.containers[i].element.outerWidth();this.containers[i].containerCache.height=this.containers[i].element.outerHeight();};},destroy:function(){this.element.removeClass("ui-sortable ui-sortable-disabled").removeData("sortable").unbind(".sortable");this.mouseDestroy();for(var i=this.items.length-1;i>=0;i--)
this.items[i].item.removeData("sortable-item");},createPlaceholder:function(that){var self=that||this,o=self.options;if(o.placeholder.constructor==String){var className=o.placeholder;o.placeholder={element:function(){return $('<div></div>').addClass(className)[0];},update:function(i,p){p.css(i.offset()).css({width:i.outerWidth(),height:i.outerHeight()});}};}
self.placeholder=$(o.placeholder.element.call(self.element,self.currentItem)).appendTo('body').css({position:'absolute'});o.placeholder.update.call(self.element,self.currentItem,self.placeholder);},contactContainers:function(e){for(var i=this.containers.length-1;i>=0;i--){if(this.intersectsWith(this.containers[i].containerCache)){if(!this.containers[i].containerCache.over){if(this.currentContainer!=this.containers[i]){var dist=10000;var itemWithLeastDistance=null;var base=this.positionAbs[this.containers[i].floating?'left':'top'];for(var j=this.items.length-1;j>=0;j--){if(!contains(this.containers[i].element[0],this.items[j].item[0]))continue;var cur=this.items[j][this.containers[i].floating?'left':'top'];if(Math.abs(cur-base)<dist){dist=Math.abs(cur-base);itemWithLeastDistance=this.items[j];}}
if(!itemWithLeastDistance&&!this.options.dropOnEmpty)
continue;if(this.placeholder)this.placeholder.remove();if(this.containers[i].options.placeholder){this.containers[i].createPlaceholder(this);}else{this.placeholder=null;;}
itemWithLeastDistance?this.rearrange(e,itemWithLeastDistance):this.rearrange(e,null,this.containers[i].element);this.propagate("change",e);this.containers[i].propagate("change",e,this);this.currentContainer=this.containers[i];}
this.containers[i].propagate("over",e,this);this.containers[i].containerCache.over=1;}}else{if(this.containers[i].containerCache.over){this.containers[i].propagate("out",e,this);this.containers[i].containerCache.over=0;}}};},mouseCapture:function(e,overrideHandle){if(this.options.disabled||this.options.type=='static')return false;var currentItem=null,nodes=$(e.target).parents().each(function(){if($.data(this,'sortable-item')){currentItem=$(this);return false;}});if($.data(e.target,'sortable-item'))currentItem=$(e.target);if(!currentItem)return false;if(this.options.handle&&!overrideHandle){var validHandle=false;$(this.options.handle,currentItem).find("*").andSelf().each(function(){if(this==e.target)validHandle=true;});if(!validHandle)return false;}
this.currentItem=currentItem;return true;},mouseStart:function(e,overrideHandle,noActivation){var o=this.options;this.currentContainer=this;this.refresh();this.helper=typeof o.helper=='function'?$(o.helper.apply(this.element[0],[e,this.currentItem])):this.currentItem.clone();if(!this.helper.parents('body').length)this.helper.appendTo((o.appendTo!='parent'?o.appendTo:this.currentItem[0].parentNode));this.helper.css({position:'absolute',clear:'both'}).addClass('ui-sortable-helper');this.margins={left:(parseInt(this.currentItem.css("marginLeft"),10)||0),top:(parseInt(this.currentItem.css("marginTop"),10)||0)};this.offset=this.currentItem.offset();this.offset={top:this.offset.top-this.margins.top,left:this.offset.left-this.margins.left};this.offset.click={left:e.pageX-this.offset.left,top:e.pageY-this.offset.top};this.offsetParent=this.helper.offsetParent();var po=this.offsetParent.offset();this.offset.parent={top:po.top+(parseInt(this.offsetParent.css("borderTopWidth"),10)||0),left:po.left+(parseInt(this.offsetParent.css("borderLeftWidth"),10)||0)};this.originalPosition=this.generatePosition(e);this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()};if(o.cursorAt){if(o.cursorAt.left!=undefined)this.offset.click.left=o.cursorAt.left;if(o.cursorAt.right!=undefined)this.offset.click.left=this.helperProportions.width-o.cursorAt.right;if(o.cursorAt.top!=undefined)this.offset.click.top=o.cursorAt.top;if(o.cursorAt.bottom!=undefined)this.offset.click.top=this.helperProportions.height-o.cursorAt.bottom;}
this.domPosition=this.currentItem.prev()[0];if(o.containment){if(o.containment=='parent')o.containment=this.helper[0].parentNode;if(o.containment=='document'||o.containment=='window')this.containment=[0-this.offset.parent.left,0-this.offset.parent.top,$(o.containment=='document'?document:window).width()-this.offset.parent.left-this.helperProportions.width-this.margins.left-(parseInt(this.element.css("marginRight"),10)||0),($(o.containment=='document'?document:window).height()||document.body.parentNode.scrollHeight)-this.offset.parent.top-this.helperProportions.height-this.margins.top-(parseInt(this.element.css("marginBottom"),10)||0)];if(!(/^(document|window|parent)$/).test(o.containment)){var ce=$(o.containment)[0];var co=$(o.containment).offset();this.containment=[co.left+(parseInt($(ce).css("borderLeftWidth"),10)||0)-this.offset.parent.left,co.top+(parseInt($(ce).css("borderTopWidth"),10)||0)-this.offset.parent.top,co.left+Math.max(ce.scrollWidth,ce.offsetWidth)-(parseInt($(ce).css("borderLeftWidth"),10)||0)-this.offset.parent.left-this.helperProportions.width-this.margins.left-(parseInt(this.currentItem.css("marginRight"),10)||0),co.top+Math.max(ce.scrollHeight,ce.offsetHeight)-(parseInt($(ce).css("borderTopWidth"),10)||0)-this.offset.parent.top-this.helperProportions.height-this.margins.top-(parseInt(this.currentItem.css("marginBottom"),10)||0)];}}
if(o.placeholder)this.createPlaceholder();this.propagate("start",e);this.helperProportions={width:this.helper.outerWidth(),height:this.helper.outerHeight()};if(this.options.placeholder!='clone')this.currentItem.css('visibility','hidden');if(!noActivation){for(var i=this.containers.length-1;i>=0;i--){this.containers[i].propagate("activate",e,this);}}
if($.ui.ddmanager)$.ui.ddmanager.current=this;if($.ui.ddmanager&&!o.dropBehaviour)$.ui.ddmanager.prepareOffsets(this,e);this.dragging=true;this.mouseDrag(e);return true;},convertPositionTo:function(d,pos){if(!pos)pos=this.position;var mod=d=="absolute"?1:-1;return{top:(pos.top
+this.offset.parent.top*mod
-(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollTop)*mod
+this.margins.top*mod),left:(pos.left
+this.offset.parent.left*mod
-(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollLeft)*mod
+this.margins.left*mod)};},generatePosition:function(e){var o=this.options;var position={top:(e.pageY
-this.offset.click.top
-this.offset.parent.top
+(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollTop)),left:(e.pageX
-this.offset.click.left
-this.offset.parent.left
+(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollLeft))};if(!this.originalPosition)return position;if(this.containment){if(position.left<this.containment[0])position.left=this.containment[0];if(position.top<this.containment[1])position.top=this.containment[1];if(position.left>this.containment[2])position.left=this.containment[2];if(position.top>this.containment[3])position.top=this.containment[3];}
if(o.grid){var top=this.originalPosition.top+Math.round((position.top-this.originalPosition.top)/o.grid[1])*o.grid[1];position.top=this.containment?(!(top<this.containment[1]||top>this.containment[3])?top:(!(top<this.containment[1])?top-o.grid[1]:top+o.grid[1])):top;var left=this.originalPosition.left+Math.round((position.left-this.originalPosition.left)/o.grid[0])*o.grid[0];position.left=this.containment?(!(left<this.containment[0]||left>this.containment[2])?left:(!(left<this.containment[0])?left-o.grid[0]:left+o.grid[0])):left;}
return position;},mouseDrag:function(e){this.position=this.generatePosition(e);this.positionAbs=this.convertPositionTo("absolute");for(var i=this.items.length-1;i>=0;i--){var intersection=this.intersectsWithEdge(this.items[i]);if(!intersection)continue;if(this.items[i].item[0]!=this.currentItem[0]&&this.currentItem[intersection==1?"next":"prev"]()[0]!=this.items[i].item[0]&&!contains(this.currentItem[0],this.items[i].item[0])&&(this.options.type=='semi-dynamic'?!contains(this.element[0],this.items[i].item[0]):true)){this.direction=intersection==1?"down":"up";this.rearrange(e,this.items[i]);this.propagate("change",e);break;}}
this.contactContainers(e);this.propagate("sort",e);if(!this.options.axis||this.options.axis=="x")this.helper[0].style.left=this.position.left+'px';if(!this.options.axis||this.options.axis=="y")this.helper[0].style.top=this.position.top+'px';if($.ui.ddmanager)$.ui.ddmanager.drag(this,e);return false;},mouseStop:function(e,noPropagation){if($.ui.ddmanager&&!this.options.dropBehaviour)
$.ui.ddmanager.drop(this,e);if(this.options.revert){var self=this;var cur=self.currentItem.offset();if(self.placeholder)self.placeholder.animate({opacity:'hide'},(parseInt(this.options.revert,10)||500)-50);$(this.helper).animate({left:cur.left-this.offset.parent.left-self.margins.left+(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollLeft),top:cur.top-this.offset.parent.top-self.margins.top+(this.offsetParent[0]==document.body?0:this.offsetParent[0].scrollTop)},parseInt(this.options.revert,10)||500,function(){self.propagate("stop",e,null,noPropagation);self.clear(e);});}else{this.propagate("stop",e,null,noPropagation);this.clear(e,noPropagation);}
return false;},clear:function(e,noPropagation){if(this.domPosition!=this.currentItem.prev().not(".ui-sortable-helper")[0])this.propagate("update",e,null,noPropagation);if(!contains(this.element[0],this.currentItem[0])){if(this.domPosition==this.currentItem.prev().not(".ui-sortable-helper")[0])this.propagate("update",e,null,noPropagation);this.propagate("remove",e,null,noPropagation);for(var i=this.containers.length-1;i>=0;i--){if(contains(this.containers[i].element[0],this.currentItem[0])){this.containers[i].propagate("update",e,this,noPropagation);this.containers[i].propagate("receive",e,this,noPropagation);}};};for(var i=this.containers.length-1;i>=0;i--){this.containers[i].propagate("deactivate",e,this,noPropagation);if(this.containers[i].containerCache.over){this.containers[i].propagate("out",e,this);this.containers[i].containerCache.over=0;}}
this.dragging=false;if(this.cancelHelperRemoval)return false;$(this.currentItem).css('visibility','');if(this.placeholder)this.placeholder.remove();this.helper.remove();return true;},rearrange:function(e,i,a){a?a.append(this.currentItem):i.item[this.direction=='down'?'before':'after'](this.currentItem);this.refreshPositions(true);if(this.options.placeholder)this.options.placeholder.update.call(this.element,this.currentItem,this.placeholder);}}));$.extend($.ui.sortable,{getter:"serialize toArray",defaults:{tolerance:"guess",distance:0,delay:0,cancel:":input,button",items:'> *',zIndex:1000,dropOnEmpty:true,appendTo:"parent"}});$.ui.plugin.add("sortable","cursor",{start:function(e,ui){var t=$('body');if(t.css("cursor"))ui.options._cursor=t.css("cursor");t.css("cursor",ui.options.cursor);},stop:function(e,ui){if(ui.options._cursor)$('body').css("cursor",ui.options._cursor);}});$.ui.plugin.add("sortable","zIndex",{start:function(e,ui){var t=ui.helper;if(t.css("zIndex"))ui.options._zIndex=t.css("zIndex");t.css('zIndex',ui.options.zIndex);},stop:function(e,ui){if(ui.options._zIndex)$(ui.helper).css('zIndex',ui.options._zIndex);}});$.ui.plugin.add("sortable","opacity",{start:function(e,ui){var t=ui.helper;if(t.css("opacity"))ui.options._opacity=t.css("opacity");t.css('opacity',ui.options.opacity);},stop:function(e,ui){if(ui.options._opacity)$(ui.helper).css('opacity',ui.options._opacity);}});$.ui.plugin.add("sortable","scroll",{start:function(e,ui){var o=ui.options;var i=$(this).data("sortable");o.scrollSensitivity=o.scrollSensitivity||20;o.scrollSpeed=o.scrollSpeed||20;i.overflowY=function(el){do{if(/auto|scroll/.test(el.css('overflow'))||(/auto|scroll/).test(el.css('overflow-y')))return el;el=el.parent();}while(el[0].parentNode);return $(document);}(i.currentItem);i.overflowX=function(el){do{if(/auto|scroll/.test(el.css('overflow'))||(/auto|scroll/).test(el.css('overflow-x')))return el;el=el.parent();}while(el[0].parentNode);return $(document);}(i.currentItem);if(i.overflowY[0]!=document&&i.overflowY[0].tagName!='HTML')i.overflowYOffset=i.overflowY.offset();if(i.overflowX[0]!=document&&i.overflowX[0].tagName!='HTML')i.overflowXOffset=i.overflowX.offset();},sort:function(e,ui){var o=ui.options;var i=$(this).data("sortable");if(i.overflowY[0]!=document&&i.overflowY[0].tagName!='HTML'){if((i.overflowYOffset.top+i.overflowY[0].offsetHeight)-e.pageY<o.scrollSensitivity)
i.overflowY[0].scrollTop=i.overflowY[0].scrollTop+o.scrollSpeed;if(e.pageY-i.overflowYOffset.top<o.scrollSensitivity)
i.overflowY[0].scrollTop=i.overflowY[0].scrollTop-o.scrollSpeed;}else{if(e.pageY-$(document).scrollTop()<o.scrollSensitivity)
$(document).scrollTop($(document).scrollTop()-o.scrollSpeed);if($(window).height()-(e.pageY-$(document).scrollTop())<o.scrollSensitivity)
$(document).scrollTop($(document).scrollTop()+o.scrollSpeed);}
if(i.overflowX[0]!=document&&i.overflowX[0].tagName!='HTML'){if((i.overflowXOffset.left+i.overflowX[0].offsetWidth)-e.pageX<o.scrollSensitivity)
i.overflowX[0].scrollLeft=i.overflowX[0].scrollLeft+o.scrollSpeed;if(e.pageX-i.overflowXOffset.left<o.scrollSensitivity)
i.overflowX[0].scrollLeft=i.overflowX[0].scrollLeft-o.scrollSpeed;}else{if(e.pageX-$(document).scrollLeft()<o.scrollSensitivity)
$(document).scrollLeft($(document).scrollLeft()-o.scrollSpeed);if($(window).width()-(e.pageX-$(document).scrollLeft())<o.scrollSensitivity)
$(document).scrollLeft($(document).scrollLeft()+o.scrollSpeed);}}});})(jQuery);;(function($){$.effects=$.effects||{};$.extend($.effects,{save:function(el,set){for(var i=0;i<set.length;i++){if(set[i]!==null)$.data(el[0],"ec.storage."+set[i],el[0].style[set[i]]);}},restore:function(el,set){for(var i=0;i<set.length;i++){if(set[i]!==null)el.css(set[i],$.data(el[0],"ec.storage."+set[i]));}},setMode:function(el,mode){if(mode=='toggle')mode=el.is(':hidden')?'show':'hide';return mode;},getBaseline:function(origin,original){var y,x;switch(origin[0]){case'top':y=0;break;case'middle':y=0.5;break;case'bottom':y=1;break;default:y=origin[0]/original.height;};switch(origin[1]){case'left':x=0;break;case'center':x=0.5;break;case'right':x=1;break;default:x=origin[1]/original.width;};return{x:x,y:y};},createWrapper:function(el){if(el.parent().attr('id')=='fxWrapper')
return el;var props={width:el.outerWidth({margin:true}),height:el.outerHeight({margin:true}),'float':el.css('float')};el.wrap('<div id="fxWrapper" style="font-size:100%;background:transparent;border:none;margin:0;padding:0"></div>');var wrapper=el.parent();if(el.css('position')=='static'){wrapper.css({position:'relative'});el.css({position:'relative'});}else{var top=parseInt(el.css('top'),10);if(isNaN(top))top='auto';var left=parseInt(el.css('left'),10);if(isNaN(top))left='auto';wrapper.css({position:el.css('position'),top:top,left:left,zIndex:el.css('z-index')}).show();el.css({position:'relative',top:0,left:0});}
wrapper.css(props);return wrapper;},removeWrapper:function(el){if(el.parent().attr('id')=='fxWrapper')
return el.parent().replaceWith(el);return el;},setTransition:function(el,list,factor,val){val=val||{};$.each(list,function(i,x){unit=el.cssUnit(x);if(unit[0]>0)val[x]=unit[0]*factor+unit[1];});return val;},animateClass:function(value,duration,easing,callback){var cb=(typeof easing=="function"?easing:(callback?callback:null));var ea=(typeof easing=="object"?easing:null);return this.each(function(){var offset={};var that=$(this);var oldStyleAttr=that.attr("style")||'';if(typeof oldStyleAttr=='object')oldStyleAttr=oldStyleAttr["cssText"];if(value.toggle){that.hasClass(value.toggle)?value.remove=value.toggle:value.add=value.toggle;}
var oldStyle=$.extend({},(document.defaultView?document.defaultView.getComputedStyle(this,null):this.currentStyle));if(value.add)that.addClass(value.add);if(value.remove)that.removeClass(value.remove);var newStyle=$.extend({},(document.defaultView?document.defaultView.getComputedStyle(this,null):this.currentStyle));if(value.add)that.removeClass(value.add);if(value.remove)that.addClass(value.remove);for(var n in newStyle){if(typeof newStyle[n]!="function"&&newStyle[n]&&n.indexOf("Moz")==-1&&n.indexOf("length")==-1&&newStyle[n]!=oldStyle[n]&&(n.match(/color/i)||(!n.match(/color/i)&&!isNaN(parseInt(newStyle[n],10))))&&(oldStyle.position!="static"||(oldStyle.position=="static"&&!n.match(/left|top|bottom|right/))))offset[n]=newStyle[n];}
that.animate(offset,duration,ea,function(){if(typeof $(this).attr("style")=='object'){$(this).attr("style")["cssText"]="";$(this).attr("style")["cssText"]=oldStyleAttr;}else $(this).attr("style",oldStyleAttr);if(value.add)$(this).addClass(value.add);if(value.remove)$(this).removeClass(value.remove);if(cb)cb.apply(this,arguments);});});}});$.fn.extend({_show:$.fn.show,_hide:$.fn.hide,__toggle:$.fn.toggle,_addClass:$.fn.addClass,_removeClass:$.fn.removeClass,_toggleClass:$.fn.toggleClass,effect:function(fx,o,speed,callback){return $.effects[fx]?$.effects[fx].call(this,{method:fx,options:o||{},duration:speed,callback:callback}):null;},show:function(){if(!arguments[0]||(arguments[0].constructor==Number||/(slow|normal|fast)/.test(arguments[0])))
return this._show.apply(this,arguments);else{var o=arguments[1]||{};o['mode']='show';return this.effect.apply(this,[arguments[0],o,arguments[2]||o.duration,arguments[3]||o.callback]);}},hide:function(){if(!arguments[0]||(arguments[0].constructor==Number||/(slow|normal|fast)/.test(arguments[0])))
return this._hide.apply(this,arguments);else{var o=arguments[1]||{};o['mode']='hide';return this.effect.apply(this,[arguments[0],o,arguments[2]||o.duration,arguments[3]||o.callback]);}},toggle:function(){if(!arguments[0]||(arguments[0].constructor==Number||/(slow|normal|fast)/.test(arguments[0]))||(arguments[0].constructor==Function))
return this.__toggle.apply(this,arguments);else{var o=arguments[1]||{};o['mode']='toggle';return this.effect.apply(this,[arguments[0],o,arguments[2]||o.duration,arguments[3]||o.callback]);}},addClass:function(classNames,speed,easing,callback){return speed?$.effects.animateClass.apply(this,[{add:classNames},speed,easing,callback]):this._addClass(classNames);},removeClass:function(classNames,speed,easing,callback){return speed?$.effects.animateClass.apply(this,[{remove:classNames},speed,easing,callback]):this._removeClass(classNames);},toggleClass:function(classNames,speed,easing,callback){return speed?$.effects.animateClass.apply(this,[{toggle:classNames},speed,easing,callback]):this._toggleClass(classNames);},morph:function(remove,add,speed,easing,callback){return $.effects.animateClass.apply(this,[{add:add,remove:remove},speed,easing,callback]);},switchClass:function(){return this.morph.apply(this,arguments);},cssUnit:function(key){var style=this.css(key),val=[];$.each(['em','px','%','pt'],function(i,unit){if(style.indexOf(unit)>0)
val=[parseFloat(style),unit];});return val;}});jQuery.each(['backgroundColor','borderBottomColor','borderLeftColor','borderRightColor','borderTopColor','color','outlineColor'],function(i,attr){jQuery.fx.step[attr]=function(fx){if(fx.state==0){fx.start=getColor(fx.elem,attr);fx.end=getRGB(fx.end);}
fx.elem.style[attr]="rgb("+[Math.max(Math.min(parseInt((fx.pos*(fx.end[0]-fx.start[0]))+fx.start[0]),255),0),Math.max(Math.min(parseInt((fx.pos*(fx.end[1]-fx.start[1]))+fx.start[1]),255),0),Math.max(Math.min(parseInt((fx.pos*(fx.end[2]-fx.start[2]))+fx.start[2]),255),0)].join(",")+")";}});function getRGB(color){var result;if(color&&color.constructor==Array&&color.length==3)
return color;if(result=/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(color))
return[parseInt(result[1]),parseInt(result[2]),parseInt(result[3])];if(result=/rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(color))
return[parseFloat(result[1])*2.55,parseFloat(result[2])*2.55,parseFloat(result[3])*2.55];if(result=/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(color))
return[parseInt(result[1],16),parseInt(result[2],16),parseInt(result[3],16)];if(result=/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(color))
return[parseInt(result[1]+result[1],16),parseInt(result[2]+result[2],16),parseInt(result[3]+result[3],16)];if(result=/rgba\(0, 0, 0, 0\)/.exec(color))
return colors['transparent']
return colors[jQuery.trim(color).toLowerCase()];}
function getColor(elem,attr){var color;do{color=jQuery.curCSS(elem,attr);if(color!=''&&color!='transparent'||jQuery.nodeName(elem,"body"))
break;attr="backgroundColor";}while(elem=elem.parentNode);return getRGB(color);};var colors={aqua:[0,255,255],azure:[240,255,255],beige:[245,245,220],black:[0,0,0],blue:[0,0,255],brown:[165,42,42],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgrey:[169,169,169],darkgreen:[0,100,0],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkviolet:[148,0,211],fuchsia:[255,0,255],gold:[255,215,0],green:[0,128,0],indigo:[75,0,130],khaki:[240,230,140],lightblue:[173,216,230],lightcyan:[224,255,255],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightyellow:[255,255,224],lime:[0,255,0],magenta:[255,0,255],maroon:[128,0,0],navy:[0,0,128],olive:[128,128,0],orange:[255,165,0],pink:[255,192,203],purple:[128,0,128],violet:[128,0,128],red:[255,0,0],silver:[192,192,192],white:[255,255,255],yellow:[255,255,0],transparent:[255,255,255]};jQuery.easing['jswing']=jQuery.easing['swing'];jQuery.extend(jQuery.easing,{def:'easeOutQuad',swing:function(x,t,b,c,d){return jQuery.easing[jQuery.easing.def](x,t,b,c,d);},easeInQuad:function(x,t,b,c,d){return c*(t/=d)*t+b;},easeOutQuad:function(x,t,b,c,d){return-c*(t/=d)*(t-2)+b;},easeInOutQuad:function(x,t,b,c,d){if((t/=d/2)<1)return c/2*t*t+b;return-c/2*((--t)*(t-2)-1)+b;},easeInCubic:function(x,t,b,c,d){return c*(t/=d)*t*t+b;},easeOutCubic:function(x,t,b,c,d){return c*((t=t/d-1)*t*t+1)+b;},easeInOutCubic:function(x,t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t+b;return c/2*((t-=2)*t*t+2)+b;},easeInQuart:function(x,t,b,c,d){return c*(t/=d)*t*t*t+b;},easeOutQuart:function(x,t,b,c,d){return-c*((t=t/d-1)*t*t*t-1)+b;},easeInOutQuart:function(x,t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t*t+b;return-c/2*((t-=2)*t*t*t-2)+b;},easeInQuint:function(x,t,b,c,d){return c*(t/=d)*t*t*t*t+b;},easeOutQuint:function(x,t,b,c,d){return c*((t=t/d-1)*t*t*t*t+1)+b;},easeInOutQuint:function(x,t,b,c,d){if((t/=d/2)<1)return c/2*t*t*t*t*t+b;return c/2*((t-=2)*t*t*t*t+2)+b;},easeInSine:function(x,t,b,c,d){return-c*Math.cos(t/d*(Math.PI/2))+c+b;},easeOutSine:function(x,t,b,c,d){return c*Math.sin(t/d*(Math.PI/2))+b;},easeInOutSine:function(x,t,b,c,d){return-c/2*(Math.cos(Math.PI*t/d)-1)+b;},easeInExpo:function(x,t,b,c,d){return(t==0)?b:c*Math.pow(2,10*(t/d-1))+b;},easeOutExpo:function(x,t,b,c,d){return(t==d)?b+c:c*(-Math.pow(2,-10*t/d)+1)+b;},easeInOutExpo:function(x,t,b,c,d){if(t==0)return b;if(t==d)return b+c;if((t/=d/2)<1)return c/2*Math.pow(2,10*(t-1))+b;return c/2*(-Math.pow(2,-10*--t)+2)+b;},easeInCirc:function(x,t,b,c,d){return-c*(Math.sqrt(1-(t/=d)*t)-1)+b;},easeOutCirc:function(x,t,b,c,d){return c*Math.sqrt(1-(t=t/d-1)*t)+b;},easeInOutCirc:function(x,t,b,c,d){if((t/=d/2)<1)return-c/2*(Math.sqrt(1-t*t)-1)+b;return c/2*(Math.sqrt(1-(t-=2)*t)+1)+b;},easeInElastic:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;var s=p/4;}
else var s=p/(2*Math.PI)*Math.asin(c/a);return-(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;},easeOutElastic:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;if(a<Math.abs(c)){a=c;var s=p/4;}
else var s=p/(2*Math.PI)*Math.asin(c/a);return a*Math.pow(2,-10*t)*Math.sin((t*d-s)*(2*Math.PI)/p)+c+b;},easeInOutElastic:function(x,t,b,c,d){var s=1.70158;var p=0;var a=c;if(t==0)return b;if((t/=d/2)==2)return b+c;if(!p)p=d*(.3*1.5);if(a<Math.abs(c)){a=c;var s=p/4;}
else var s=p/(2*Math.PI)*Math.asin(c/a);if(t<1)return-.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;return a*Math.pow(2,-10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p)*.5+c+b;},easeInBack:function(x,t,b,c,d,s){if(s==undefined)s=1.70158;return c*(t/=d)*t*((s+1)*t-s)+b;},easeOutBack:function(x,t,b,c,d,s){if(s==undefined)s=1.70158;return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b;},easeInOutBack:function(x,t,b,c,d,s){if(s==undefined)s=1.70158;if((t/=d/2)<1)return c/2*(t*t*(((s*=(1.525))+1)*t-s))+b;return c/2*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)+b;},easeInBounce:function(x,t,b,c,d){return c-jQuery.easing.easeOutBounce(x,d-t,0,c,d)+b;},easeOutBounce:function(x,t,b,c,d){if((t/=d)<(1/2.75)){return c*(7.5625*t*t)+b;}else if(t<(2/2.75)){return c*(7.5625*(t-=(1.5/2.75))*t+.75)+b;}else if(t<(2.5/2.75)){return c*(7.5625*(t-=(2.25/2.75))*t+.9375)+b;}else{return c*(7.5625*(t-=(2.625/2.75))*t+.984375)+b;}},easeInOutBounce:function(x,t,b,c,d){if(t<d/2)return jQuery.easing.easeInBounce(x,t*2,0,c,d)*.5+b;return jQuery.easing.easeOutBounce(x,t*2-d,0,c,d)*.5+c*.5+b;}});})(jQuery);(function($){$.effects.blind=function(o){return this.queue(function(){var el=$(this),props=['position','top','left'];var mode=$.effects.setMode(el,o.options.mode||'hide');var direction=o.options.direction||'vertical';$.effects.save(el,props);el.show();var wrapper=$.effects.createWrapper(el).css({overflow:'hidden'});var ref=(direction=='vertical')?'height':'width';var distance=(direction=='vertical')?wrapper.height():wrapper.width();if(mode=='show')wrapper.css(ref,0);var animation={};animation[ref]=mode=='show'?distance:0;wrapper.animate(animation,o.duration,o.options.easing,function(){if(mode=='hide')el.hide();$.effects.restore(el,props);$.effects.removeWrapper(el);if(o.callback)o.callback.apply(el[0],arguments);el.dequeue();});});};})(jQuery);;(function($){$.effects.highlight=function(o){return this.queue(function(){var el=$(this),props=['backgroundImage','backgroundColor','opacity'];var mode=$.effects.setMode(el,o.options.mode||'show');var color=o.options.color||"#ffff99";var oldColor=el.css("backgroundColor");$.effects.save(el,props);el.show();el.css({backgroundImage:'none',backgroundColor:color});var animation={backgroundColor:oldColor};if(mode=="hide")animation['opacity']=0;el.animate(animation,{queue:false,duration:o.duration,easing:o.options.easing,complete:function(){if(mode=="hide")el.hide();$.effects.restore(el,props);if(mode=="show"&&jQuery.browser.msie)this.style.removeAttribute('filter');if(o.callback)o.callback.apply(this,arguments);el.dequeue();}});});};})(jQuery);


/*
 * Auto Expanding Text Area (1.2.2)
 * by Chrys Bader (www.chrysbader.com)
 * chrysb@gmail.com
 *
 * Special thanks to:
 * Jake Chapa - jake@hybridstudio.com
 * John Resig - jeresig@gmail.com
 *
 * Copyright (c) 2008 Chrys Bader (www.chrysbader.com)
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 *
 * NOTE: This script requires jQuery to work.  Download jQuery at www.jquery.com
 *
 */

(function(jQuery){var self=null;jQuery.fn.autogrow=function(o)
{return this.each(function(){new jQuery.autogrow(this,o);});};jQuery.autogrow=function(e,o)
{this.options=o||{};this.dummy=null;this.interval=null;this.line_height=this.options.lineHeight||parseInt(jQuery(e).css('line-height'));this.min_height=this.options.minHeight||parseInt(jQuery(e).css('min-height'));this.max_height=this.options.maxHeight||parseInt(jQuery(e).css('max-height'));;this.textarea=jQuery(e);if(this.line_height==NaN)
this.line_height=0;this.init();};jQuery.autogrow.fn=jQuery.autogrow.prototype={autogrow:'1.2.2'};jQuery.autogrow.fn.extend=jQuery.autogrow.extend=jQuery.extend;jQuery.autogrow.fn.extend({init:function(){var self=this;this.textarea.css({overflow:'hidden',display:'block'});this.textarea.bind('focus',function(){self.startExpand()}).bind('blur',function(){self.stopExpand()});this.checkExpand();},startExpand:function(){var self=this;this.interval=window.setInterval(function(){self.checkExpand()},400);},stopExpand:function(){clearInterval(this.interval);},checkExpand:function(){if(this.dummy==null)
{this.dummy=jQuery('<div></div>');this.dummy.css({'font-size':this.textarea.css('font-size'),'font-family':this.textarea.css('font-family'),'width':this.textarea.css('width'),'padding':this.textarea.css('padding'),'line-height':this.line_height+'px','overflow-x':'hidden','position':'absolute','top':0,'left':-9999}).appendTo('body');}
var html=this.textarea.val().replace(/(<|>)/g,'');if($.browser.msie)
{html=html.replace(/\n/g,'<BR>new');}
else
{html=html.replace(/\n/g,'<br>new');}
if(this.dummy.html()!=html)
{this.dummy.html(html);if(this.max_height>0&&(this.dummy.height()+this.line_height>this.max_height))
{this.textarea.css('overflow-y','auto');}
else
{this.textarea.css('overflow-y','hidden');if(this.textarea.height()<this.dummy.height()+this.line_height||(this.dummy.height()<this.textarea.height()))
{this.textarea.animate({height:(this.dummy.height()+this.line_height)+'px'},100);}}}}});})(jQuery);


/**
 * Expands text and textarea elements while new characters are typed to the a miximum width
 *
 * @name Expander
 * @description Expands text and textarea elements while new characters are typed to the a miximum width
 * @param Mixed limit integer if only expands in width, array if expands in width and height
 * @type jQuery
 * @cat Plugins/Interface
 * @author Stefan Petre
 */
jQuery.iExpander={helper:null,limit:null,expand:function()
{text=this.value;if(!text)
return;style={fontFamily:jQuery(this).css('fontFamily')||'',fontSize:jQuery(this).css('fontSize')||'',fontWeight:jQuery(this).css('fontWeight')||'',fontStyle:jQuery(this).css('fontStyle')||'',fontStretch:jQuery(this).css('fontStretch')||'',fontVariant:jQuery(this).css('fontVariant')||'',letterSpacing:jQuery(this).css('letterSpacing')||'',wordSpacing:jQuery(this).css('wordSpacing')||''};jQuery.iExpander.helper.css(style);html=jQuery.iExpander.htmlEntities(text);html=html.replace(new RegExp("\\n","g"),"<br />");jQuery.iExpander.helper.html('pW');spacer=jQuery.iExpander.helper.get(0).offsetWidth;jQuery.iExpander.helper.html(html);width=jQuery.iExpander.helper.get(0).offsetWidth+spacer;if(jQuery.iExpander.limit&&width>jQuery.iExpander.limit[0]){width=jQuery.iExpander.limit[0];}
this.style.width=width+'px';if(this.tagName=='TEXTAREA'){height=jQuery.iExpander.helper.get(0).offsetHeight+spacer;if(jQuery.iExpander.limit&&height>jQuery.iExpander.limit[1]){height=jQuery.iExpander.limit[1];}
this.style.height=height+'px';}},htmlEntities:function(text)
{entities={'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;'};for(i in entities){text=text.replace(new RegExp(i,'g'),entities[i]);}
return text;},build:function(limit)
{if(jQuery.iExpander.helper==null){jQuery('body',document).append('<div id="expanderHelper" style="position: absolute; top: 0; left: 0; visibility: hidden;"></div>');jQuery.iExpander.helper=jQuery('#expanderHelper');}
return this.each(function()
{if(/TEXTAREA|INPUT/.test(this.tagName)){if(this.tagName=='INPUT'){elType=this.getAttribute('type');if(!/text|password/.test(elType)){return;}}
if(limit&&(limit.constructor==Number||(limit.constructor==Array&&limit.length==2))){if(limit.constructor==Number)
limit=[limit,limit];else{limit[0]=parseInt(limit[0])||400;limit[1]=parseInt(limit[1])||400;}
jQuery.iExpander.limit=limit;}
jQuery(this).blur(jQuery.iExpander.expand).keyup(jQuery.iExpander.expand).keypress(jQuery.iExpander.expand);jQuery.iExpander.expand.apply(this);}});}};jQuery.fn.Autoexpand=jQuery.iExpander.build;


/*
 * jQuery ifixpng plugin
 * (previously known as pngfix)
 * Version 2.1  (23/04/2008)
 * @requires jQuery v1.1.3 or above
 *
 * Examples at: http://jquery.khurshid.com
 * Copyright (c) 2007 Kush M.
 * Dual licensed under the MIT and GPL licenses:
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.gnu.org/licenses/gpl.html
 */
(function($){$.ifixpng=function(customPixel){$.ifixpng.pixel=customPixel;};$.ifixpng.getPixel=function(){return $.ifixpng.pixel||'images/pixel.gif';};var hack={ltie7:$.browser.msie&&$.browser.version<7,filter:function(src){return"progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled=true,sizingMethod=crop,src='"+src+"')";}};$.fn.ifixpng=hack.ltie7?function(){return this.each(function(){var $$=$(this);var base=$('base').attr('href');if(base){base=base.replace(/\/[^\/]+$/,'/');}if($$.is('img')||$$.is('input')){if($$.attr('src')){if($$.attr('src').match(/.*\.png([?].*)?$/i)){var source=(base&&$$.attr('src').search(/^(\/|http:)/i))?base+$$.attr('src'):$$.attr('src');$$.css({filter:hack.filter(source),width:$$.width(),height:$$.height()}).attr({src:$.ifixpng.getPixel()}).positionFix();}}}else{var image=$$.css('backgroundImage');if(image.match(/^url\(["']?(.*\.png([?].*)?)["']?\)$/i)){image=RegExp.$1;image=(base&&image.substring(0,1)!='/')?base+image:image;$$.css({backgroundImage:'none',filter:hack.filter(image)}).children().children().positionFix();}}});}:function(){return this;};$.fn.iunfixpng=hack.ltie7?function(){return this.each(function(){var $$=$(this);var src=$$.css('filter');if(src.match(/src=["']?(.*\.png([?].*)?)["']?/i)){src=RegExp.$1;if($$.is('img')||$$.is('input')){$$.attr({src:src}).css({filter:''});}else{$$.css({filter:'',background:'url('+src+')'});}}});}:function(){return this;};$.fn.positionFix=function(){return this.each(function(){var $$=$(this);var position=$$.css('position');if(position!='absolute'&&position!='relative'){$$.css({position:'relative'});}});};})(jQuery);(function($){$.fn.ajaxSubmit=function(options){if(!this.length){log('ajaxSubmit: skipping submit process - no element selected');return this;}if(typeof options=='function')options={success:options};options=$.extend({url:this.attr('action')||window.location.toString(),type:this.attr('method')||'GET'},options||{});var veto={};this.trigger('form-pre-serialize',[this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');return this;}var a=this.formToArray(options.semantic);if(options.data){options.extraData=options.data;for(var n in options.data)a.push({name:n,value:options.data[n]});}if(options.beforeSubmit&&options.beforeSubmit(a,this,options)===false){log('ajaxSubmit: submit aborted via beforeSubmit callback');return this;}this.trigger('form-submit-validate',[a,this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-submit-validate trigger');return this;}var q=$.param(a);if(options.type.toUpperCase()=='GET'){options.url+=(options.url.indexOf('?')>=0?'&':'?')+q;options.data=null;}else
options.data=q;var $form=this,callbacks=[];if(options.resetForm)callbacks.push(function(){$form.resetForm();});if(options.clearForm)callbacks.push(function(){$form.clearForm();});if(!options.dataType&&options.target){var oldSuccess=options.success||function(){};callbacks.push(function(data){$(options.target).html(data).each(oldSuccess,arguments);});}else if(options.success)callbacks.push(options.success);options.success=function(data,status){for(var i=0,max=callbacks.length;i<max;i++)callbacks[i](data,status,$form);};var files=$('input:file',this).fieldValue();var found=false;for(var j=0;j<files.length;j++)if(files[j])found=true;if(options.iframe||found){if($.browser.safari&&options.closeKeepAlive)$.get(options.closeKeepAlive,fileUpload);else
fileUpload();}else
$.ajax(options);this.trigger('form-submit-notify',[this,options]);return this;function fileUpload(){var form=$form[0];var opts=$.extend({},$.ajaxSettings,options);var id='jqFormIO'+(new Date().getTime());var $io=$('<iframe id="'+id+'" name="'+id+'" />');var io=$io[0];if($.browser.msie||$.browser.opera)io.src='javascript:false;document.write("");';$io.css({position:'absolute',top:'-1000px',left:'-1000px'});var xhr={responseText:null,responseXML:null,status:0,statusText:'n/a',getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){}};var g=opts.global;if(g&&!$.active++)$.event.trigger("ajaxStart");if(g)$.event.trigger("ajaxSend",[xhr,opts]);var cbInvoked=0;var timedOut=0;setTimeout(function(){var t=$form.attr('target'),a=$form.attr('action');$form.attr({target:id,encoding:'multipart/form-data',enctype:'multipart/form-data',method:'POST',action:opts.url});if(opts.timeout)setTimeout(function(){timedOut=true;cb();},opts.timeout);var extraInputs=[];try{if(options.extraData)for(var n in options.extraData)extraInputs.push($('<input type="hidden" name="'+n+'" value="'+options.extraData[n]+'" />').appendTo(form)[0]);$io.appendTo('body');io.attachEvent?io.attachEvent('onload',cb):io.addEventListener('load',cb,false);form.submit();}finally{$form.attr('action',a);t?$form.attr('target',t):$form.removeAttr('target');$(extraInputs).remove();}},10);function cb(){if(cbInvoked++)return;io.detachEvent?io.detachEvent('onload',cb):io.removeEventListener('load',cb,false);var operaHack=0;var ok=true;try{if(timedOut)throw'timeout';var data,doc;doc=io.contentWindow?io.contentWindow.document:io.contentDocument?io.contentDocument:io.document;if(doc.body==null&&!operaHack&&$.browser.opera){operaHack=1;cbInvoked--;setTimeout(cb,100);return;}xhr.responseText=doc.body?doc.body.innerHTML:null;xhr.responseXML=doc.XMLDocument?doc.XMLDocument:doc;xhr.getResponseHeader=function(header){var headers={'content-type':opts.dataType};return headers[header];};if(opts.dataType=='json'||opts.dataType=='script'){var ta=doc.getElementsByTagName('textarea')[0];xhr.responseText=ta?ta.value:xhr.responseText;}else if(opts.dataType=='xml'&&!xhr.responseXML&&xhr.responseText!=null){xhr.responseXML=toXml(xhr.responseText);}data=$.httpData(xhr,opts.dataType);}catch(e){ok=false;$.handleError(opts,xhr,'error',e);}if(ok){opts.success(data,'success');if(g)$.event.trigger("ajaxSuccess",[xhr,opts]);}if(g)$.event.trigger("ajaxComplete",[xhr,opts]);if(g&&!--$.active)$.event.trigger("ajaxStop");if(opts.complete)opts.complete(xhr,ok?'success':'error');setTimeout(function(){$io.remove();xhr.responseXML=null;},100);};function toXml(s,doc){if(window.ActiveXObject){doc=new ActiveXObject('Microsoft.XMLDOM');doc.async='false';doc.loadXML(s);}else
doc=(new DOMParser()).parseFromString(s,'text/xml');return(doc&&doc.documentElement&&doc.documentElement.tagName!='parsererror')?doc:null;};};};$.fn.ajaxForm=function(options){return this.ajaxFormUnbind().bind('submit.form-plugin',function(){$(this).ajaxSubmit(options);return false;}).each(function(){$(":submit,input:image",this).bind('click.form-plugin',function(e){var $form=this.form;$form.clk=this;if(this.type=='image'){if(e.offsetX!=undefined){$form.clk_x=e.offsetX;$form.clk_y=e.offsetY;}else if(typeof $.fn.offset=='function'){var offset=$(this).offset();$form.clk_x=e.pageX-offset.left;$form.clk_y=e.pageY-offset.top;}else{$form.clk_x=e.pageX-this.offsetLeft;$form.clk_y=e.pageY-this.offsetTop;}}setTimeout(function(){$form.clk=$form.clk_x=$form.clk_y=null;},10);});});};$.fn.ajaxFormUnbind=function(){this.unbind('submit.form-plugin');return this.each(function(){$(":submit,input:image",this).unbind('click.form-plugin');});};$.fn.formToArray=function(semantic){var a=[];if(this.length==0)return a;var form=this[0];var els=semantic?form.getElementsByTagName('*'):form.elements;if(!els)return a;for(var i=0,max=els.length;i<max;i++){var el=els[i];var n=el.name;if(!n)continue;if(semantic&&form.clk&&el.type=="image"){if(!el.disabled&&form.clk==el)a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});continue;}var v=$.fieldValue(el,true);if(v&&v.constructor==Array){for(var j=0,jmax=v.length;j<jmax;j++)a.push({name:n,value:v[j]});}else if(v!==null&&typeof v!='undefined')a.push({name:n,value:v});}if(!semantic&&form.clk){var inputs=form.getElementsByTagName("input");for(var i=0,max=inputs.length;i<max;i++){var input=inputs[i];var n=input.name;if(n&&!input.disabled&&input.type=="image"&&form.clk==input)a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});}}return a;};$.fn.formSerialize=function(semantic){return $.param(this.formToArray(semantic));};$.fn.fieldSerialize=function(successful){var a=[];this.each(function(){var n=this.name;if(!n)return;var v=$.fieldValue(this,successful);if(v&&v.constructor==Array){for(var i=0,max=v.length;i<max;i++)a.push({name:n,value:v[i]});}else if(v!==null&&typeof v!='undefined')a.push({name:this.name,value:v});});return $.param(a);};$.fn.fieldValue=function(successful){for(var val=[],i=0,max=this.length;i<max;i++){var el=this[i];var v=$.fieldValue(el,successful);if(v===null||typeof v=='undefined'||(v.constructor==Array&&!v.length))continue;v.constructor==Array?$.merge(val,v):val.push(v);}return val;};$.fieldValue=function(el,successful){var n=el.name,t=el.type,tag=el.tagName.toLowerCase();if(typeof successful=='undefined')successful=true;if(successful&&(!n||el.disabled||t=='reset'||t=='button'||(t=='checkbox'||t=='radio')&&!el.checked||(t=='submit'||t=='image')&&el.form&&el.form.clk!=el||tag=='select'&&el.selectedIndex==-1))return null;if(tag=='select'){var index=el.selectedIndex;if(index<0)return null;var a=[],ops=el.options;var one=(t=='select-one');var max=(one?index+1:ops.length);for(var i=(one?index:0);i<max;i++){var op=ops[i];if(op.selected){var v=$.browser.msie&&!(op.attributes['value'].specified)?op.text:op.value;if(one)return v;a.push(v);}}return a;}return el.value;};$.fn.clearForm=function(){return this.each(function(){$('input,select,textarea',this).clearFields();});};$.fn.clearFields=$.fn.clearInputs=function(){return this.each(function(){var t=this.type,tag=this.tagName.toLowerCase();if(t=='text'||t=='password'||tag=='textarea')this.value='';else if(t=='checkbox'||t=='radio')this.checked=false;else if(tag=='select')this.selectedIndex=-1;});};$.fn.resetForm=function(){return this.each(function(){if(typeof this.reset=='function'||(typeof this.reset=='object'&&!this.reset.nodeType))this.reset();});};$.fn.enable=function(b){if(b==undefined)b=true;return this.each(function(){this.disabled=!b});};$.fn.select=function(select){if(select==undefined)select=true;return this.each(function(){var t=this.type;if(t=='checkbox'||t=='radio')this.checked=select;else if(this.tagName.toLowerCase()=='option'){var $sel=$(this).parent('select');if(select&&$sel[0]&&$sel[0].type=='select-one'){$sel.find('option').select(false);}this.selected=select;}});};function log(){if($.fn.ajaxSubmit.debug&&window.console&&window.console.log)window.console.log('[jquery.form] '+Array.prototype.join.call(arguments,''));};})(jQuery);


/*
 * jQuery Form Plugin
 * version: 2.10 (05/08/2008)
 * @requires jQuery v1.2.2 or later
 *
 * Examples and documentation at: http://malsup.com/jquery/form/
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 * Revision: $Id$
 */
(function($){$.fn.ajaxSubmit=function(options){if(!this.length){log('ajaxSubmit: skipping submit process - no element selected');return this;}if(typeof options=='function')options={success:options};options=$.extend({url:this.attr('action')||window.location.toString(),type:this.attr('method')||'GET'},options||{});var veto={};this.trigger('form-pre-serialize',[this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');return this;}var a=this.formToArray(options.semantic);if(options.data){options.extraData=options.data;for(var n in options.data)a.push({name:n,value:options.data[n]});}if(options.beforeSubmit&&options.beforeSubmit(a,this,options)===false){log('ajaxSubmit: submit aborted via beforeSubmit callback');return this;}this.trigger('form-submit-validate',[a,this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-submit-validate trigger');return this;}var q=$.param(a);if(options.type.toUpperCase()=='GET'){options.url+=(options.url.indexOf('?')>=0?'&':'?')+q;options.data=null;}else
options.data=q;var $form=this,callbacks=[];if(options.resetForm)callbacks.push(function(){$form.resetForm();});if(options.clearForm)callbacks.push(function(){$form.clearForm();});if(!options.dataType&&options.target){var oldSuccess=options.success||function(){};callbacks.push(function(data){$(options.target).html(data).each(oldSuccess,arguments);});}else if(options.success)callbacks.push(options.success);options.success=function(data,status){for(var i=0,max=callbacks.length;i<max;i++)callbacks[i](data,status,$form);};var files=$('input:file',this).fieldValue();var found=false;for(var j=0;j<files.length;j++)if(files[j])found=true;if(options.iframe||found){if($.browser.safari&&options.closeKeepAlive)$.get(options.closeKeepAlive,fileUpload);else
fileUpload();}else
$.ajax(options);this.trigger('form-submit-notify',[this,options]);return this;function fileUpload(){var form=$form[0];var opts=$.extend({},$.ajaxSettings,options);var id='jqFormIO'+(new Date().getTime());var $io=$('<iframe id="'+id+'" name="'+id+'" />');var io=$io[0];if($.browser.msie||$.browser.opera)io.src='javascript:false;document.write("");';$io.css({position:'absolute',top:'-1000px',left:'-1000px'});var xhr={responseText:null,responseXML:null,status:0,statusText:'n/a',getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){}};var g=opts.global;if(g&&!$.active++)$.event.trigger("ajaxStart");if(g)$.event.trigger("ajaxSend",[xhr,opts]);var cbInvoked=0;var timedOut=0;setTimeout(function(){var t=$form.attr('target'),a=$form.attr('action');$form.attr({target:id,encoding:'multipart/form-data',enctype:'multipart/form-data',method:'POST',action:opts.url});if(opts.timeout)setTimeout(function(){timedOut=true;cb();},opts.timeout);var extraInputs=[];try{if(options.extraData)for(var n in options.extraData)extraInputs.push($('<input type="hidden" name="'+n+'" value="'+options.extraData[n]+'" />').appendTo(form)[0]);$io.appendTo('body');io.attachEvent?io.attachEvent('onload',cb):io.addEventListener('load',cb,false);form.submit();}finally{$form.attr('action',a);t?$form.attr('target',t):$form.removeAttr('target');$(extraInputs).remove();}},10);function cb(){if(cbInvoked++)return;io.detachEvent?io.detachEvent('onload',cb):io.removeEventListener('load',cb,false);var operaHack=0;var ok=true;try{if(timedOut)throw'timeout';var data,doc;doc=io.contentWindow?io.contentWindow.document:io.contentDocument?io.contentDocument:io.document;if(doc.body==null&&!operaHack&&$.browser.opera){operaHack=1;cbInvoked--;setTimeout(cb,100);return;}xhr.responseText=doc.body?doc.body.innerHTML:null;xhr.responseXML=doc.XMLDocument?doc.XMLDocument:doc;xhr.getResponseHeader=function(header){var headers={'content-type':opts.dataType};return headers[header];};if(opts.dataType=='json'||opts.dataType=='script'){var ta=doc.getElementsByTagName('textarea')[0];xhr.responseText=ta?ta.value:xhr.responseText;}else if(opts.dataType=='xml'&&!xhr.responseXML&&xhr.responseText!=null){xhr.responseXML=toXml(xhr.responseText);}data=$.httpData(xhr,opts.dataType);}catch(e){ok=false;$.handleError(opts,xhr,'error',e);}if(ok){opts.success(data,'success');if(g)$.event.trigger("ajaxSuccess",[xhr,opts]);}if(g)$.event.trigger("ajaxComplete",[xhr,opts]);if(g&&!--$.active)$.event.trigger("ajaxStop");if(opts.complete)opts.complete(xhr,ok?'success':'error');setTimeout(function(){$io.remove();xhr.responseXML=null;},100);};function toXml(s,doc){if(window.ActiveXObject){doc=new ActiveXObject('Microsoft.XMLDOM');doc.async='false';doc.loadXML(s);}else
doc=(new DOMParser()).parseFromString(s,'text/xml');return(doc&&doc.documentElement&&doc.documentElement.tagName!='parsererror')?doc:null;};};};$.fn.ajaxForm=function(options){return this.ajaxFormUnbind().bind('submit.form-plugin',function(){$(this).ajaxSubmit(options);return false;}).each(function(){$(":submit,input:image",this).bind('click.form-plugin',function(e){var $form=this.form;$form.clk=this;if(this.type=='image'){if(e.offsetX!=undefined){$form.clk_x=e.offsetX;$form.clk_y=e.offsetY;}else if(typeof $.fn.offset=='function'){var offset=$(this).offset();$form.clk_x=e.pageX-offset.left;$form.clk_y=e.pageY-offset.top;}else{$form.clk_x=e.pageX-this.offsetLeft;$form.clk_y=e.pageY-this.offsetTop;}}setTimeout(function(){$form.clk=$form.clk_x=$form.clk_y=null;},10);});});};$.fn.ajaxFormUnbind=function(){this.unbind('submit.form-plugin');return this.each(function(){$(":submit,input:image",this).unbind('click.form-plugin');});};$.fn.formToArray=function(semantic){var a=[];if(this.length==0)return a;var form=this[0];var els=semantic?form.getElementsByTagName('*'):form.elements;if(!els)return a;for(var i=0,max=els.length;i<max;i++){var el=els[i];var n=el.name;if(!n)continue;if(semantic&&form.clk&&el.type=="image"){if(!el.disabled&&form.clk==el)a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});continue;}var v=$.fieldValue(el,true);if(v&&v.constructor==Array){for(var j=0,jmax=v.length;j<jmax;j++)a.push({name:n,value:v[j]});}else if(v!==null&&typeof v!='undefined')a.push({name:n,value:v});}if(!semantic&&form.clk){var inputs=form.getElementsByTagName("input");for(var i=0,max=inputs.length;i<max;i++){var input=inputs[i];var n=input.name;if(n&&!input.disabled&&input.type=="image"&&form.clk==input)a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y});}}return a;};$.fn.formSerialize=function(semantic){return $.param(this.formToArray(semantic));};$.fn.fieldSerialize=function(successful){var a=[];this.each(function(){var n=this.name;if(!n)return;var v=$.fieldValue(this,successful);if(v&&v.constructor==Array){for(var i=0,max=v.length;i<max;i++)a.push({name:n,value:v[i]});}else if(v!==null&&typeof v!='undefined')a.push({name:this.name,value:v});});return $.param(a);};$.fn.fieldValue=function(successful){for(var val=[],i=0,max=this.length;i<max;i++){var el=this[i];var v=$.fieldValue(el,successful);if(v===null||typeof v=='undefined'||(v.constructor==Array&&!v.length))continue;v.constructor==Array?$.merge(val,v):val.push(v);}return val;};$.fieldValue=function(el,successful){var n=el.name,t=el.type,tag=el.tagName.toLowerCase();if(typeof successful=='undefined')successful=true;if(successful&&(!n||el.disabled||t=='reset'||t=='button'||(t=='checkbox'||t=='radio')&&!el.checked||(t=='submit'||t=='image')&&el.form&&el.form.clk!=el||tag=='select'&&el.selectedIndex==-1))return null;if(tag=='select'){var index=el.selectedIndex;if(index<0)return null;var a=[],ops=el.options;var one=(t=='select-one');var max=(one?index+1:ops.length);for(var i=(one?index:0);i<max;i++){var op=ops[i];if(op.selected){var v=$.browser.msie&&!(op.attributes['value'].specified)?op.text:op.value;if(one)return v;a.push(v);}}return a;}return el.value;};$.fn.clearForm=function(){return this.each(function(){$('input,select,textarea',this).clearFields();});};$.fn.clearFields=$.fn.clearInputs=function(){return this.each(function(){var t=this.type,tag=this.tagName.toLowerCase();if(t=='text'||t=='password'||tag=='textarea')this.value='';else if(t=='checkbox'||t=='radio')this.checked=false;else if(tag=='select')this.selectedIndex=-1;});};$.fn.resetForm=function(){return this.each(function(){if(typeof this.reset=='function'||(typeof this.reset=='object'&&!this.reset.nodeType))this.reset();});};$.fn.enable=function(b){if(b==undefined)b=true;return this.each(function(){this.disabled=!b});};$.fn.select=function(select){if(select==undefined)select=true;return this.each(function(){var t=this.type;if(t=='checkbox'||t=='radio')this.checked=select;else if(this.tagName.toLowerCase()=='option'){var $sel=$(this).parent('select');if(select&&$sel[0]&&$sel[0].type=='select-one'){$sel.find('option').select(false);}this.selected=select;}});};function log(){if($.fn.ajaxSubmit.debug&&window.console&&window.console.log)window.console.log('[jquery.form] '+Array.prototype.join.call(arguments,''));};})(jQuery);


/*
 * Interface elements for jQuery - http://interface.eyecon.ro
 *
 * Copyright (c) 2006 Stefan Petre
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
*/
jQuery.iUtil={getPosition:function(e)
{var x=0;var y=0;var es=e.style;var restoreStyles=false;if(jQuery(e).css('display')=='none'){var oldVisibility=es.visibility;var oldPosition=es.position;restoreStyles=true;es.visibility='hidden';es.display='block';es.position='absolute';}
var el=e;while(el){x+=el.offsetLeft+(el.currentStyle&&!jQuery.browser.opera?parseInt(el.currentStyle.borderLeftWidth)||0:0);y+=el.offsetTop+(el.currentStyle&&!jQuery.browser.opera?parseInt(el.currentStyle.borderTopWidth)||0:0);el=el.offsetParent;}
el=e;while(el&&el.tagName&&el.tagName.toLowerCase()!='body')
{x-=el.scrollLeft||0;y-=el.scrollTop||0;el=el.parentNode;}
if(restoreStyles==true){es.display='none';es.position=oldPosition;es.visibility=oldVisibility;}
return{x:x,y:y};},getPositionLite:function(el)
{var x=0,y=0;while(el){x+=el.offsetLeft||0;y+=el.offsetTop||0;el=el.offsetParent;}
return{x:x,y:y};},getSize:function(e)
{var w=jQuery.css(e,'width');var h=jQuery.css(e,'height');var wb=0;var hb=0;var es=e.style;if(jQuery(e).css('display')!='none'){wb=e.offsetWidth;hb=e.offsetHeight;}else{var oldVisibility=es.visibility;var oldPosition=es.position;es.visibility='hidden';es.display='block';es.position='absolute';wb=e.offsetWidth;hb=e.offsetHeight;es.display='none';es.position=oldPosition;es.visibility=oldVisibility;}
return{w:w,h:h,wb:wb,hb:hb};},getSizeLite:function(el)
{return{wb:el.offsetWidth||0,hb:el.offsetHeight||0};},getClient:function(e)
{var h,w,de;if(e){w=e.clientWidth;h=e.clientHeight;}else{de=document.documentElement;w=window.innerWidth||self.innerWidth||(de&&de.clientWidth)||document.body.clientWidth;h=window.innerHeight||self.innerHeight||(de&&de.clientHeight)||document.body.clientHeight;}
return{w:w,h:h};},getScroll:function(e)
{var t=0,l=0,w=0,h=0,iw=0,ih=0;if(e&&e.nodeName.toLowerCase()!='body'){t=e.scrollTop;l=e.scrollLeft;w=e.scrollWidth;h=e.scrollHeight;iw=0;ih=0;}else{if(document.documentElement){t=document.documentElement.scrollTop;l=document.documentElement.scrollLeft;w=document.documentElement.scrollWidth;h=document.documentElement.scrollHeight;}else if(document.body){t=document.body.scrollTop;l=document.body.scrollLeft;w=document.body.scrollWidth;h=document.body.scrollHeight;}
iw=self.innerWidth||document.documentElement.clientWidth||document.body.clientWidth||0;ih=self.innerHeight||document.documentElement.clientHeight||document.body.clientHeight||0;}
return{t:t,l:l,w:w,h:h,iw:iw,ih:ih};},getMargins:function(e,toInteger)
{var el=jQuery(e);var t=el.css('marginTop')||'';var r=el.css('marginRight')||'';var b=el.css('marginBottom')||'';var l=el.css('marginLeft')||'';if(toInteger)
return{t:parseInt(t)||0,r:parseInt(r)||0,b:parseInt(b)||0,l:parseInt(l)};else
return{t:t,r:r,b:b,l:l};},getPadding:function(e,toInteger)
{var el=jQuery(e);var t=el.css('paddingTop')||'';var r=el.css('paddingRight')||'';var b=el.css('paddingBottom')||'';var l=el.css('paddingLeft')||'';if(toInteger)
return{t:parseInt(t)||0,r:parseInt(r)||0,b:parseInt(b)||0,l:parseInt(l)};else
return{t:t,r:r,b:b,l:l};},getBorder:function(e,toInteger)
{var el=jQuery(e);var t=el.css('borderTopWidth')||'';var r=el.css('borderRightWidth')||'';var b=el.css('borderBottomWidth')||'';var l=el.css('borderLeftWidth')||'';if(toInteger)
return{t:parseInt(t)||0,r:parseInt(r)||0,b:parseInt(b)||0,l:parseInt(l)||0};else
return{t:t,r:r,b:b,l:l};},getPointer:function(event)
{var x=event.pageX||(event.clientX+(document.documentElement.scrollLeft||document.body.scrollLeft))||0;var y=event.pageY||(event.clientY+(document.documentElement.scrollTop||document.body.scrollTop))||0;return{x:x,y:y};},traverseDOM:function(nodeEl,func)
{func(nodeEl);nodeEl=nodeEl.firstChild;while(nodeEl){jQuery.iUtil.traverseDOM(nodeEl,func);nodeEl=nodeEl.nextSibling;}},purgeEvents:function(nodeEl)
{jQuery.iUtil.traverseDOM(nodeEl,function(el)
{for(var attr in el){if(typeof el[attr]==='function'){el[attr]=null;}}});},centerEl:function(el,axis)
{var clientScroll=jQuery.iUtil.getScroll();var windowSize=jQuery.iUtil.getSize(el);if(!axis||axis=='vertically')
jQuery(el).css({top:clientScroll.t+((Math.max(clientScroll.h,clientScroll.ih)-clientScroll.t-windowSize.hb)/2)+'px'});if(!axis||axis=='horizontally')
jQuery(el).css({left:clientScroll.l+((Math.max(clientScroll.w,clientScroll.iw)-clientScroll.l-windowSize.wb)/2)+'px'});},fixPNG:function(el,emptyGIF){var images=jQuery('img[@src*="png"]',el||document),png;images.each(function(){png=this.src;this.src=emptyGIF;this.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src='"+png+"')";});}};[].indexOf||(Array.prototype.indexOf=function(v,n){n=(n==null)?0:n;var m=this.length;for(var i=n;i<m;i++)
if(this[i]==v)
return i;return-1;});
jQuery.iDrag={helper:null,dragged:null,destroy:function()
{return this.each(function()
{if(this.isDraggable){this.dragCfg.dhe.unbind('mousedown',jQuery.iDrag.draginit);this.dragCfg=null;this.isDraggable=false;if(jQuery.browser.msie){this.unselectable="off";}else{this.style.MozUserSelect='';this.style.KhtmlUserSelect='';this.style.userSelect='';}}});},draginit:function(e)
{if(jQuery.iDrag.dragged!=null){jQuery.iDrag.dragstop(e);return false;}
var elm=this.dragElem;jQuery(document).bind('mousemove',jQuery.iDrag.dragmove).bind('mouseup',jQuery.iDrag.dragstop);elm.dragCfg.pointer=jQuery.iUtil.getPointer(e);elm.dragCfg.currentPointer=elm.dragCfg.pointer;elm.dragCfg.init=false;elm.dragCfg.fromHandler=this!=this.dragElem;jQuery.iDrag.dragged=elm;if(elm.dragCfg.si&&this!=this.dragElem){parentPos=jQuery.iUtil.getPosition(elm.parentNode);sliderSize=jQuery.iUtil.getSize(elm);sliderPos={x:parseInt(jQuery.css(elm,'left'))||0,y:parseInt(jQuery.css(elm,'top'))||0};dx=elm.dragCfg.currentPointer.x-parentPos.x-sliderSize.wb/2-sliderPos.x;dy=elm.dragCfg.currentPointer.y-parentPos.y-sliderSize.hb/2-sliderPos.y;jQuery.iSlider.dragmoveBy(elm,[dx,dy]);}
return jQuery.selectKeyHelper||false;},dragstart:function(e)
{var elm=jQuery.iDrag.dragged;elm.dragCfg.init=true;var dEs=elm.style;elm.dragCfg.oD=jQuery.css(elm,'display');elm.dragCfg.oP=jQuery.css(elm,'position');if(!elm.dragCfg.initialPosition)
elm.dragCfg.initialPosition=elm.dragCfg.oP;elm.dragCfg.oR={x:parseInt(jQuery.css(elm,'left'))||0,y:parseInt(jQuery.css(elm,'top'))||0};elm.dragCfg.diffX=0;elm.dragCfg.diffY=0;if(jQuery.browser.msie){var oldBorder=jQuery.iUtil.getBorder(elm,true);elm.dragCfg.diffX=oldBorder.l||0;elm.dragCfg.diffY=oldBorder.t||0;}
elm.dragCfg.oC=jQuery.extend(jQuery.iUtil.getPosition(elm),jQuery.iUtil.getSize(elm));if(elm.dragCfg.oP!='relative'&&elm.dragCfg.oP!='absolute'){dEs.position='relative';}
jQuery.iDrag.helper.empty();var clonedEl=elm.cloneNode(true);jQuery(clonedEl).css({display:'block',left:'0px',top:'0px'});clonedEl.style.marginTop='0';clonedEl.style.marginRight='0';clonedEl.style.marginBottom='0';clonedEl.style.marginLeft='0';jQuery.iDrag.helper.append(clonedEl);var dhs=jQuery.iDrag.helper.get(0).style;if(elm.dragCfg.autoSize){dhs.width='auto';dhs.height='auto';}else{dhs.height=elm.dragCfg.oC.hb+'px';dhs.width=elm.dragCfg.oC.wb+'px';}
dhs.display='block';dhs.marginTop='0px';dhs.marginRight='0px';dhs.marginBottom='0px';dhs.marginLeft='0px';jQuery.extend(elm.dragCfg.oC,jQuery.iUtil.getSize(clonedEl));if(elm.dragCfg.cursorAt){if(elm.dragCfg.cursorAt.left){elm.dragCfg.oR.x+=elm.dragCfg.pointer.x-elm.dragCfg.oC.x-elm.dragCfg.cursorAt.left;elm.dragCfg.oC.x=elm.dragCfg.pointer.x-elm.dragCfg.cursorAt.left;}
if(elm.dragCfg.cursorAt.top){elm.dragCfg.oR.y+=elm.dragCfg.pointer.y-elm.dragCfg.oC.y-elm.dragCfg.cursorAt.top;elm.dragCfg.oC.y=elm.dragCfg.pointer.y-elm.dragCfg.cursorAt.top;}
if(elm.dragCfg.cursorAt.right){elm.dragCfg.oR.x+=elm.dragCfg.pointer.x-elm.dragCfg.oC.x-elm.dragCfg.oC.hb+elm.dragCfg.cursorAt.right;elm.dragCfg.oC.x=elm.dragCfg.pointer.x-elm.dragCfg.oC.wb+elm.dragCfg.cursorAt.right;}
if(elm.dragCfg.cursorAt.bottom){elm.dragCfg.oR.y+=elm.dragCfg.pointer.y-elm.dragCfg.oC.y-elm.dragCfg.oC.hb+elm.dragCfg.cursorAt.bottom;elm.dragCfg.oC.y=elm.dragCfg.pointer.y-elm.dragCfg.oC.hb+elm.dragCfg.cursorAt.bottom;}}
elm.dragCfg.nx=elm.dragCfg.oR.x;elm.dragCfg.ny=elm.dragCfg.oR.y;if(elm.dragCfg.insideParent||elm.dragCfg.containment=='parent'){parentBorders=jQuery.iUtil.getBorder(elm.parentNode,true);elm.dragCfg.oC.x=elm.offsetLeft+(jQuery.browser.msie?0:jQuery.browser.opera?-parentBorders.l:parentBorders.l);elm.dragCfg.oC.y=elm.offsetTop+(jQuery.browser.msie?0:jQuery.browser.opera?-parentBorders.t:parentBorders.t);jQuery(elm.parentNode).append(jQuery.iDrag.helper.get(0));}
if(elm.dragCfg.containment){jQuery.iDrag.getContainment(elm);elm.dragCfg.onDragModifier.containment=jQuery.iDrag.fitToContainer;}
if(elm.dragCfg.si){jQuery.iSlider.modifyContainer(elm);}
dhs.left=elm.dragCfg.oC.x-elm.dragCfg.diffX+'px';dhs.top=elm.dragCfg.oC.y-elm.dragCfg.diffY+'px';dhs.width=elm.dragCfg.oC.wb+'px';dhs.height=elm.dragCfg.oC.hb+'px';jQuery.iDrag.dragged.dragCfg.prot=false;if(elm.dragCfg.gx){elm.dragCfg.onDragModifier.grid=jQuery.iDrag.snapToGrid;}
if(elm.dragCfg.zIndex!=false){jQuery.iDrag.helper.css('zIndex',elm.dragCfg.zIndex);}
if(elm.dragCfg.opacity){jQuery.iDrag.helper.css('opacity',elm.dragCfg.opacity);if(window.ActiveXObject){jQuery.iDrag.helper.css('filter','alpha(opacity='+elm.dragCfg.opacity*100+')');}}
if(elm.dragCfg.frameClass){jQuery.iDrag.helper.addClass(elm.dragCfg.frameClass);jQuery.iDrag.helper.get(0).firstChild.style.display='none';}
if(elm.dragCfg.onStart)
elm.dragCfg.onStart.apply(elm,[clonedEl,elm.dragCfg.oR.x,elm.dragCfg.oR.y]);if(jQuery.iDrop&&jQuery.iDrop.count>0){jQuery.iDrop.highlight(elm);}
if(elm.dragCfg.ghosting==false){dEs.display='none';}
return false;},getContainment:function(elm)
{if(elm.dragCfg.containment.constructor==String){if(elm.dragCfg.containment=='parent'){elm.dragCfg.cont=jQuery.extend({x:0,y:0},jQuery.iUtil.getSize(elm.parentNode));var contBorders=jQuery.iUtil.getBorder(elm.parentNode,true);elm.dragCfg.cont.w=elm.dragCfg.cont.wb-contBorders.l-contBorders.r;elm.dragCfg.cont.h=elm.dragCfg.cont.hb-contBorders.t-contBorders.b;}else if(elm.dragCfg.containment=='document'){var clnt=jQuery.iUtil.getClient();elm.dragCfg.cont={x:0,y:0,w:clnt.w,h:clnt.h};}}else if(elm.dragCfg.containment.constructor==Array){elm.dragCfg.cont={x:parseInt(elm.dragCfg.containment[0])||0,y:parseInt(elm.dragCfg.containment[1])||0,w:parseInt(elm.dragCfg.containment[2])||0,h:parseInt(elm.dragCfg.containment[3])||0};}
elm.dragCfg.cont.dx=elm.dragCfg.cont.x-elm.dragCfg.oC.x;elm.dragCfg.cont.dy=elm.dragCfg.cont.y-elm.dragCfg.oC.y;},hidehelper:function(dragged)
{if(dragged.dragCfg.insideParent||dragged.dragCfg.containment=='parent'){jQuery('body',document).append(jQuery.iDrag.helper.get(0));}
jQuery.iDrag.helper.empty().hide().css('opacity',1);if(window.ActiveXObject){jQuery.iDrag.helper.css('filter','alpha(opacity=100)');}},dragstop:function(e)
{jQuery(document).unbind('mousemove',jQuery.iDrag.dragmove).unbind('mouseup',jQuery.iDrag.dragstop);if(jQuery.iDrag.dragged==null){return;}
var dragged=jQuery.iDrag.dragged;jQuery.iDrag.dragged=null;if(dragged.dragCfg.init==false){return false;}
if(dragged.dragCfg.so==true){jQuery(dragged).css('position',dragged.dragCfg.oP);}
var dEs=dragged.style;if(dragged.si){jQuery.iDrag.helper.css('cursor','move');}
if(dragged.dragCfg.frameClass){jQuery.iDrag.helper.removeClass(dragged.dragCfg.frameClass);}
if(dragged.dragCfg.revert==false){if(dragged.dragCfg.fx>0){if(!dragged.dragCfg.axis||dragged.dragCfg.axis=='horizontally'){var x=new jQuery.fx(dragged,{duration:dragged.dragCfg.fx},'left');x.custom(dragged.dragCfg.oR.x,dragged.dragCfg.nRx);}
if(!dragged.dragCfg.axis||dragged.dragCfg.axis=='vertically'){var y=new jQuery.fx(dragged,{duration:dragged.dragCfg.fx},'top');y.custom(dragged.dragCfg.oR.y,dragged.dragCfg.nRy);}}else{if(!dragged.dragCfg.axis||dragged.dragCfg.axis=='horizontally')
dragged.style.left=dragged.dragCfg.nRx+'px';if(!dragged.dragCfg.axis||dragged.dragCfg.axis=='vertically')
dragged.style.top=dragged.dragCfg.nRy+'px';}
jQuery.iDrag.hidehelper(dragged);if(dragged.dragCfg.ghosting==false){jQuery(dragged).css('display',dragged.dragCfg.oD);}}else if(dragged.dragCfg.fx>0){dragged.dragCfg.prot=true;var dh=false;if(jQuery.iDrop&&jQuery.iSort&&dragged.dragCfg.so){dh=jQuery.iUtil.getPosition(jQuery.iSort.helper.get(0));}
jQuery.iDrag.helper.animate({left:dh?dh.x:dragged.dragCfg.oC.x,top:dh?dh.y:dragged.dragCfg.oC.y},dragged.dragCfg.fx,function()
{dragged.dragCfg.prot=false;if(dragged.dragCfg.ghosting==false){dragged.style.display=dragged.dragCfg.oD;}
jQuery.iDrag.hidehelper(dragged);});}else{jQuery.iDrag.hidehelper(dragged);if(dragged.dragCfg.ghosting==false){jQuery(dragged).css('display',dragged.dragCfg.oD);}}
if(jQuery.iDrop&&jQuery.iDrop.count>0){jQuery.iDrop.checkdrop(dragged);}
if(jQuery.iSort&&dragged.dragCfg.so){jQuery.iSort.check(dragged);}
if(dragged.dragCfg.onChange&&(dragged.dragCfg.nRx!=dragged.dragCfg.oR.x||dragged.dragCfg.nRy!=dragged.dragCfg.oR.y)){dragged.dragCfg.onChange.apply(dragged,dragged.dragCfg.lastSi||[0,0,dragged.dragCfg.nRx,dragged.dragCfg.nRy]);}
if(dragged.dragCfg.onStop)
dragged.dragCfg.onStop.apply(dragged);return false;},snapToGrid:function(x,y,dx,dy)
{if(dx!=0)
dx=parseInt((dx+(this.dragCfg.gx*dx/Math.abs(dx))/2)/this.dragCfg.gx)*this.dragCfg.gx;if(dy!=0)
dy=parseInt((dy+(this.dragCfg.gy*dy/Math.abs(dy))/2)/this.dragCfg.gy)*this.dragCfg.gy;return{dx:dx,dy:dy,x:0,y:0};},fitToContainer:function(x,y,dx,dy)
{dx=Math.min(Math.max(dx,this.dragCfg.cont.dx),this.dragCfg.cont.w+this.dragCfg.cont.dx-this.dragCfg.oC.wb);dy=Math.min(Math.max(dy,this.dragCfg.cont.dy),this.dragCfg.cont.h+this.dragCfg.cont.dy-this.dragCfg.oC.hb);return{dx:dx,dy:dy,x:0,y:0}},dragmove:function(e)
{if(jQuery.iDrag.dragged==null||jQuery.iDrag.dragged.dragCfg.prot==true){return;}
var dragged=jQuery.iDrag.dragged;dragged.dragCfg.currentPointer=jQuery.iUtil.getPointer(e);if(dragged.dragCfg.init==false){distance=Math.sqrt(Math.pow(dragged.dragCfg.pointer.x-dragged.dragCfg.currentPointer.x,2)+Math.pow(dragged.dragCfg.pointer.y-dragged.dragCfg.currentPointer.y,2));if(distance<dragged.dragCfg.snapDistance){return;}else{jQuery.iDrag.dragstart(e);}}
var dx=dragged.dragCfg.currentPointer.x-dragged.dragCfg.pointer.x;var dy=dragged.dragCfg.currentPointer.y-dragged.dragCfg.pointer.y;for(var i in dragged.dragCfg.onDragModifier){var newCoords=dragged.dragCfg.onDragModifier[i].apply(dragged,[dragged.dragCfg.oR.x+dx,dragged.dragCfg.oR.y+dy,dx,dy]);if(newCoords&&newCoords.constructor==Object){dx=i!='user'?newCoords.dx:(newCoords.x-dragged.dragCfg.oR.x);dy=i!='user'?newCoords.dy:(newCoords.y-dragged.dragCfg.oR.y);}}
dragged.dragCfg.nx=dragged.dragCfg.oC.x+dx-dragged.dragCfg.diffX;dragged.dragCfg.ny=dragged.dragCfg.oC.y+dy-dragged.dragCfg.diffY;if(dragged.dragCfg.si&&(dragged.dragCfg.onSlide||dragged.dragCfg.onChange)){jQuery.iSlider.onSlide(dragged,dragged.dragCfg.nx,dragged.dragCfg.ny);}
if(dragged.dragCfg.onDrag)
dragged.dragCfg.onDrag.apply(dragged,[dragged.dragCfg.oR.x+dx,dragged.dragCfg.oR.y+dy]);if(!dragged.dragCfg.axis||dragged.dragCfg.axis=='horizontally'){dragged.dragCfg.nRx=dragged.dragCfg.oR.x+dx;jQuery.iDrag.helper.get(0).style.left=dragged.dragCfg.nx+'px';}
if(!dragged.dragCfg.axis||dragged.dragCfg.axis=='vertically'){dragged.dragCfg.nRy=dragged.dragCfg.oR.y+dy;jQuery.iDrag.helper.get(0).style.top=dragged.dragCfg.ny+'px';}
if(jQuery.iDrop&&jQuery.iDrop.count>0){jQuery.iDrop.checkhover(dragged);}
return false;},build:function(o)
{if(!jQuery.iDrag.helper){jQuery('body',document).append('<div id="dragHelper"></div>');jQuery.iDrag.helper=jQuery('#dragHelper');var el=jQuery.iDrag.helper.get(0);var els=el.style;els.position='absolute';els.display='none';els.cursor='move';els.listStyle='none';els.overflow='hidden';if(window.ActiveXObject){el.unselectable="on";}else{els.mozUserSelect='none';els.userSelect='none';els.KhtmlUserSelect='none';}}
if(!o){o={};}
return this.each(function()
{if(this.isDraggable||!jQuery.iUtil)
return;if(window.ActiveXObject){this.onselectstart=function(){return false;};this.ondragstart=function(){return false;};}
var el=this;var dhe=o.handle?jQuery(this).find(o.handle):jQuery(this);if(jQuery.browser.msie){dhe.each(function()
{this.unselectable="on";});}else{dhe.css('-moz-user-select','none');dhe.css('user-select','none');dhe.css('-khtml-user-select','none');}
this.dragCfg={dhe:dhe,revert:o.revert?true:false,ghosting:o.ghosting?true:false,so:o.so?o.so:false,si:o.si?o.si:false,insideParent:o.insideParent?o.insideParent:false,zIndex:o.zIndex?parseInt(o.zIndex)||0:false,opacity:o.opacity?parseFloat(o.opacity):false,fx:parseInt(o.fx)||null,hpc:o.hpc?o.hpc:false,onDragModifier:{},pointer:{},onStart:o.onStart&&o.onStart.constructor==Function?o.onStart:false,onStop:o.onStop&&o.onStop.constructor==Function?o.onStop:false,onChange:o.onChange&&o.onChange.constructor==Function?o.onChange:false,axis:/vertically|horizontally/.test(o.axis)?o.axis:false,snapDistance:o.snapDistance?parseInt(o.snapDistance)||0:0,cursorAt:o.cursorAt?o.cursorAt:false,autoSize:o.autoSize?true:false,frameClass:o.frameClass||false};if(o.onDragModifier&&o.onDragModifier.constructor==Function)
this.dragCfg.onDragModifier.user=o.onDragModifier;if(o.onDrag&&o.onDrag.constructor==Function)
this.dragCfg.onDrag=o.onDrag;if(o.containment&&((o.containment.constructor==String&&(o.containment=='parent'||o.containment=='document'))||(o.containment.constructor==Array&&o.containment.length==4))){this.dragCfg.containment=o.containment;}
if(o.fractions){this.dragCfg.fractions=o.fractions;}
if(o.grid){if(typeof o.grid=='number'){this.dragCfg.gx=parseInt(o.grid)||1;this.dragCfg.gy=parseInt(o.grid)||1;}else if(o.grid.length==2){this.dragCfg.gx=parseInt(o.grid[0])||1;this.dragCfg.gy=parseInt(o.grid[1])||1;}}
if(o.onSlide&&o.onSlide.constructor==Function){this.dragCfg.onSlide=o.onSlide;}
this.isDraggable=true;dhe.each(function(){this.dragElem=el;});dhe.bind('mousedown',jQuery.iDrag.draginit);})}};jQuery.fn.extend({DraggableDestroy:jQuery.iDrag.destroy,Draggable:jQuery.iDrag.build});


jQuery.iDrop={fit:function(zonex,zoney,zonew,zoneh)
{return zonex<=jQuery.iDrag.dragged.dragCfg.nx&&(zonex+zonew)>=(jQuery.iDrag.dragged.dragCfg.nx+jQuery.iDrag.dragged.dragCfg.oC.w)&&zoney<=jQuery.iDrag.dragged.dragCfg.ny&&(zoney+zoneh)>=(jQuery.iDrag.dragged.dragCfg.ny+jQuery.iDrag.dragged.dragCfg.oC.h)?true:false;},intersect:function(zonex,zoney,zonew,zoneh)
{return!(zonex>(jQuery.iDrag.dragged.dragCfg.nx+jQuery.iDrag.dragged.dragCfg.oC.w)||(zonex+zonew)<jQuery.iDrag.dragged.dragCfg.nx||zoney>(jQuery.iDrag.dragged.dragCfg.ny+jQuery.iDrag.dragged.dragCfg.oC.h)||(zoney+zoneh)<jQuery.iDrag.dragged.dragCfg.ny)?true:false;},pointer:function(zonex,zoney,zonew,zoneh)
{return zonex<jQuery.iDrag.dragged.dragCfg.currentPointer.x&&(zonex+zonew)>jQuery.iDrag.dragged.dragCfg.currentPointer.x&&zoney<jQuery.iDrag.dragged.dragCfg.currentPointer.y&&(zoney+zoneh)>jQuery.iDrag.dragged.dragCfg.currentPointer.y?true:false;},overzone:false,highlighted:{},count:0,zones:{},highlight:function(elm)
{if(jQuery.iDrag.dragged==null){return;}
var i;jQuery.iDrop.highlighted={};var oneIsSortable=false;for(i in jQuery.iDrop.zones){if(jQuery.iDrop.zones[i]!=null){var iEL=jQuery.iDrop.zones[i].get(0);if(jQuery(jQuery.iDrag.dragged).is('.'+iEL.dropCfg.a)){if(iEL.dropCfg.m==false){iEL.dropCfg.p=jQuery.extend(jQuery.iUtil.getPositionLite(iEL),jQuery.iUtil.getSizeLite(iEL));iEL.dropCfg.m=true;}
if(iEL.dropCfg.ac){jQuery.iDrop.zones[i].addClass(iEL.dropCfg.ac);}
jQuery.iDrop.highlighted[i]=jQuery.iDrop.zones[i];if(jQuery.iSort&&iEL.dropCfg.s&&jQuery.iDrag.dragged.dragCfg.so){iEL.dropCfg.el=jQuery('.'+iEL.dropCfg.a,iEL);elm.style.display='none';jQuery.iSort.measure(iEL);iEL.dropCfg.os=jQuery.iSort.serialize(jQuery.attr(iEL,'id')).hash;elm.style.display=elm.dragCfg.oD;oneIsSortable=true;}
if(iEL.dropCfg.onActivate){iEL.dropCfg.onActivate.apply(jQuery.iDrop.zones[i].get(0),[jQuery.iDrag.dragged]);}}}}
if(oneIsSortable){jQuery.iSort.start();}},remeasure:function()
{jQuery.iDrop.highlighted={};for(i in jQuery.iDrop.zones){if(jQuery.iDrop.zones[i]!=null){var iEL=jQuery.iDrop.zones[i].get(0);if(jQuery(jQuery.iDrag.dragged).is('.'+iEL.dropCfg.a)){iEL.dropCfg.p=jQuery.extend(jQuery.iUtil.getPositionLite(iEL),jQuery.iUtil.getSizeLite(iEL));if(iEL.dropCfg.ac){jQuery.iDrop.zones[i].addClass(iEL.dropCfg.ac);}
jQuery.iDrop.highlighted[i]=jQuery.iDrop.zones[i];if(jQuery.iSort&&iEL.dropCfg.s&&jQuery.iDrag.dragged.dragCfg.so){iEL.dropCfg.el=jQuery('.'+iEL.dropCfg.a,iEL);elm.style.display='none';jQuery.iSort.measure(iEL);elm.style.display=elm.dragCfg.oD;}}}}},checkhover:function(e)
{if(jQuery.iDrag.dragged==null){return;}
jQuery.iDrop.overzone=false;var i;var applyOnHover=false;var hlt=0;for(i in jQuery.iDrop.highlighted)
{var iEL=jQuery.iDrop.highlighted[i].get(0);if(jQuery.iDrop.overzone==false&&jQuery.iDrop[iEL.dropCfg.t](iEL.dropCfg.p.x,iEL.dropCfg.p.y,iEL.dropCfg.p.wb,iEL.dropCfg.p.hb)){if(iEL.dropCfg.hc&&iEL.dropCfg.h==false){jQuery.iDrop.highlighted[i].addClass(iEL.dropCfg.hc);}
if(iEL.dropCfg.h==false&&iEL.dropCfg.onHover){applyOnHover=true;}
iEL.dropCfg.h=true;jQuery.iDrop.overzone=iEL;if(jQuery.iSort&&iEL.dropCfg.s&&jQuery.iDrag.dragged.dragCfg.so){jQuery.iSort.helper.get(0).className=iEL.dropCfg.shc;jQuery.iSort.checkhover(iEL);}
hlt++;}else if(iEL.dropCfg.h==true){if(iEL.dropCfg.onOut){iEL.dropCfg.onOut.apply(iEL,[e,jQuery.iDrag.helper.get(0).firstChild,iEL.dropCfg.fx]);}
if(iEL.dropCfg.hc){jQuery.iDrop.highlighted[i].removeClass(iEL.dropCfg.hc);}
iEL.dropCfg.h=false;}}
if(jQuery.iSort&&!jQuery.iDrop.overzone&&jQuery.iDrag.dragged.so){jQuery.iSort.helper.get(0).style.display='none';}
if(applyOnHover){jQuery.iDrop.overzone.dropCfg.onHover.apply(jQuery.iDrop.overzone,[e,jQuery.iDrag.helper.get(0).firstChild]);}},checkdrop:function(e)
{var i;for(i in jQuery.iDrop.highlighted){var iEL=jQuery.iDrop.highlighted[i].get(0);if(iEL.dropCfg.ac){jQuery.iDrop.highlighted[i].removeClass(iEL.dropCfg.ac);}
if(iEL.dropCfg.hc){jQuery.iDrop.highlighted[i].removeClass(iEL.dropCfg.hc);}
if(iEL.dropCfg.s){jQuery.iSort.changed[jQuery.iSort.changed.length]=i;}
if(iEL.dropCfg.onDrop&&iEL.dropCfg.h==true){iEL.dropCfg.h=false;iEL.dropCfg.onDrop.apply(iEL,[e,iEL.dropCfg.fx]);}
iEL.dropCfg.m=false;iEL.dropCfg.h=false;}
jQuery.iDrop.highlighted={};},destroy:function()
{return this.each(function()
{if(this.isDroppable){if(this.dropCfg.s){id=jQuery.attr(this,'id');jQuery.iSort.collected[id]=null;jQuery('.'+this.dropCfg.a,this).DraggableDestroy();}
jQuery.iDrop.zones['d'+this.idsa]=null;this.isDroppable=false;this.f=null;}});},build:function(o)
{return this.each(function()
{if(this.isDroppable==true||!o.accept||!jQuery.iUtil||!jQuery.iDrag){return;}
this.dropCfg={a:o.accept,ac:o.activeclass||false,hc:o.hoverclass||false,shc:o.helperclass||false,onDrop:o.ondrop||o.onDrop||false,onHover:o.onHover||o.onhover||false,onOut:o.onOut||o.onout||false,onActivate:o.onActivate||false,t:o.tolerance&&(o.tolerance=='fit'||o.tolerance=='intersect')?o.tolerance:'pointer',fx:o.fx?o.fx:false,m:false,h:false};if(o.sortable==true&&jQuery.iSort){id=jQuery.attr(this,'id');jQuery.iSort.collected[id]=this.dropCfg.a;this.dropCfg.s=true;if(o.onChange){this.dropCfg.onChange=o.onChange;this.dropCfg.os=jQuery.iSort.serialize(id).hash;}}
this.isDroppable=true;this.idsa=parseInt(Math.random()*10000);jQuery.iDrop.zones['d'+this.idsa]=jQuery(this);jQuery.iDrop.count++;});}};jQuery.fn.extend({DroppableDestroy:jQuery.iDrop.destroy,Droppable:jQuery.iDrop.build});jQuery.recallDroppables=jQuery.iDrop.remeasure;


jQuery.iSort={changed:[],collected:{},helper:false,inFrontOf:null,start:function()
{if(jQuery.iDrag.dragged==null){return;}
var shs,margins,c,cs;jQuery.iSort.helper.get(0).className=jQuery.iDrag.dragged.dragCfg.hpc;shs=jQuery.iSort.helper.get(0).style;shs.display='block';jQuery.iSort.helper.oC=jQuery.extend(jQuery.iUtil.getPosition(jQuery.iSort.helper.get(0)),jQuery.iUtil.getSize(jQuery.iSort.helper.get(0)));shs.width=jQuery.iDrag.dragged.dragCfg.oC.wb+'px';shs.height=jQuery.iDrag.dragged.dragCfg.oC.hb+'px';margins=jQuery.iUtil.getMargins(jQuery.iDrag.dragged);shs.marginTop=margins.t;shs.marginRight=margins.r;shs.marginBottom=margins.b;shs.marginLeft=margins.l;if(jQuery.iDrag.dragged.dragCfg.ghosting==true){c=jQuery.iDrag.dragged.cloneNode(true);cs=c.style;cs.marginTop='0px';cs.marginRight='0px';cs.marginBottom='0px';cs.marginLeft='0px';cs.display='block';jQuery.iSort.helper.empty().append(c);}
jQuery(jQuery.iDrag.dragged).after(jQuery.iSort.helper.get(0));jQuery.iDrag.dragged.style.display='none';},check:function(e)
{if(!e.dragCfg.so&&jQuery.iDrop.overzone.sortable){if(e.dragCfg.onStop)
e.dragCfg.onStop.apply(dragged);jQuery(e).css('position',e.dragCfg.initialPosition||e.dragCfg.oP);jQuery(e).DraggableDestroy();jQuery(jQuery.iDrop.overzone).SortableAddItem(e);}
jQuery.iSort.helper.removeClass(e.dragCfg.hpc).html('&nbsp;');jQuery.iSort.inFrontOf=null;var shs=jQuery.iSort.helper.get(0).style;shs.display='none';jQuery.iSort.helper.after(e);if(e.dragCfg.fx>0){jQuery(e).fadeIn(e.dragCfg.fx);}
jQuery('body').append(jQuery.iSort.helper.get(0));var ts=[];var fnc=false;for(var i=0;i<jQuery.iSort.changed.length;i++){var iEL=jQuery.iDrop.zones[jQuery.iSort.changed[i]].get(0);var id=jQuery.attr(iEL,'id');var ser=jQuery.iSort.serialize(id);if(iEL.dropCfg.os!=ser.hash){iEL.dropCfg.os=ser.hash;if(fnc==false&&iEL.dropCfg.onChange){fnc=iEL.dropCfg.onChange;}
ser.id=id;ts[ts.length]=ser;}}
jQuery.iSort.changed=[];if(fnc!=false&&ts.length>0){fnc(ts);}},checkhover:function(e,o)
{if(!jQuery.iDrag.dragged)
return;var cur=false;var i=0;if(e.dropCfg.el.size()>0){for(i=e.dropCfg.el.size();i>0;i--){if(e.dropCfg.el.get(i-1)!=jQuery.iDrag.dragged){if(!e.sortCfg.floats){if((e.dropCfg.el.get(i-1).pos.y+e.dropCfg.el.get(i-1).pos.hb/2)>jQuery.iDrag.dragged.dragCfg.ny){cur=e.dropCfg.el.get(i-1);}else{break;}}else{if((e.dropCfg.el.get(i-1).pos.x+e.dropCfg.el.get(i-1).pos.wb/2)>jQuery.iDrag.dragged.dragCfg.nx&&(e.dropCfg.el.get(i-1).pos.y+e.dropCfg.el.get(i-1).pos.hb/2)>jQuery.iDrag.dragged.dragCfg.ny){cur=e.dropCfg.el.get(i-1);}}}}}
if(cur&&jQuery.iSort.inFrontOf!=cur){jQuery.iSort.inFrontOf=cur;jQuery(cur).before(jQuery.iSort.helper.get(0));}else if(!cur&&(jQuery.iSort.inFrontOf!=null||jQuery.iSort.helper.get(0).parentNode!=e)){jQuery.iSort.inFrontOf=null;jQuery(e).append(jQuery.iSort.helper.get(0));}
jQuery.iSort.helper.get(0).style.display='block';},measure:function(e)
{if(jQuery.iDrag.dragged==null){return;}
e.dropCfg.el.each(function()
{this.pos=jQuery.extend(jQuery.iUtil.getSizeLite(this),jQuery.iUtil.getPositionLite(this));});},serialize:function(s)
{var i;var h='';var o={};if(s){if(jQuery.iSort.collected[s]){o[s]=[];jQuery('#'+s+' .'+jQuery.iSort.collected[s]).each(function()
{if(h.length>0){h+='&';}
h+=s+'[]='+jQuery.attr(this,'id');o[s][o[s].length]=jQuery.attr(this,'id');});}else{for(a in s){if(jQuery.iSort.collected[s[a]]){o[s[a]]=[];jQuery('#'+s[a]+' .'+jQuery.iSort.collected[s[a]]).each(function()
{if(h.length>0){h+='&';}
h+=s[a]+'[]='+jQuery.attr(this,'id');o[s[a]][o[s[a]].length]=jQuery.attr(this,'id');});}}}}else{for(i in jQuery.iSort.collected){o[i]=[];jQuery('#'+i+' .'+jQuery.iSort.collected[i]).each(function()
{if(h.length>0){h+='&';}
h+=i+'[]='+jQuery.attr(this,'id');o[i][o[i].length]=jQuery.attr(this,'id');});}}
return{hash:h,o:o};},addItem:function(e)
{if(!e.childNodes){return;}
return this.each(function()
{if(!this.sortCfg||!jQuery(e).is('.'+this.sortCfg.accept))
jQuery(e).addClass(this.sortCfg.accept);jQuery(e).Draggable(this.sortCfg.dragCfg);});},destroy:function()
{return this.each(function()
{jQuery('.'+this.sortCfg.accept).DraggableDestroy();jQuery(this).DroppableDestroy();this.sortCfg=null;this.isSortable=null;});},build:function(o)
{if(o.accept&&jQuery.iUtil&&jQuery.iDrag&&jQuery.iDrop){if(!jQuery.iSort.helper){jQuery('body',document).append('<div id="sortHelper">&nbsp;</div>');jQuery.iSort.helper=jQuery('#sortHelper');jQuery.iSort.helper.get(0).style.display='none';}
this.Droppable({accept:o.accept,activeclass:o.activeclass?o.activeclass:false,hoverclass:o.hoverclass?o.hoverclass:false,helperclass:o.helperclass?o.helperclass:false,onHover:o.onHover||o.onhover,onOut:o.onOut||o.onout,sortable:true,onChange:o.onChange||o.onchange,fx:o.fx?o.fx:false,ghosting:o.ghosting?true:false,tolerance:o.tolerance?o.tolerance:'intersect'});return this.each(function()
{var dragCfg={revert:o.revert?true:false,zindex:3000,opacity:o.opacity?parseFloat(o.opacity):false,hpc:o.helperclass?o.helperclass:false,fx:o.fx?o.fx:false,so:true,ghosting:o.ghosting?true:false,handle:o.handle?o.handle:null,containment:o.containment?o.containment:null,onStart:o.onStart&&o.onStart.constructor==Function?o.onStart:false,onDrag:o.onDrag&&o.onDrag.constructor==Function?o.onDrag:false,onStop:o.onStop&&o.onStop.constructor==Function?o.onStop:false,axis:/vertically|horizontally/.test(o.axis)?o.axis:false,snapDistance:o.snapDistance?parseInt(o.snapDistance)||0:false,cursorAt:o.cursorAt?o.cursorAt:false};jQuery('.'+o.accept,this).Draggable(dragCfg);this.isSortable=true;this.sortCfg={accept:o.accept,revert:o.revert?true:false,zindex:3000,opacity:o.opacity?parseFloat(o.opacity):false,hpc:o.helperclass?o.helperclass:false,fx:o.fx?o.fx:false,so:true,ghosting:o.ghosting?true:false,handle:o.handle?o.handle:null,containment:o.containment?o.containment:null,floats:o.floats?true:false,dragCfg:dragCfg}});}}};jQuery.fn.extend({Sortable:jQuery.iSort.build,SortableAddItem:jQuery.iSort.addItem,SortableDestroy:jQuery.iSort.destroy});jQuery.SortSerialize=jQuery.iSort.serialize;


/**
 *
 * Nested Sortable Plugin for jQuery/Interface.
 *
 * Version 1.0.1
 *
 *Change Log:
 * 1.0
 *       Initial Release
 * 1.0.1
 *       Added noNestingClass option to prevent nesting in some elements.
 *
 * Copyright (c) 2007 Bernardo de Padua dos Santos
 * Dual licensed under the MIT (MIT-LICENSE.txt)
 * and GPL (GPL-LICENSE.txt) licenses.
 *
 * http://code.google.com/p/nestedsortables/
 *
 * Compressed using Dean Edwards' Packer (http://dean.edwards.name/packer/)
 *
 */
jQuery.iNestedSortable={checkHover:function(e,o){if(e.isNestedSortable){jQuery.iNestedSortable.scroll(e);return jQuery.iNestedSortable.newCheckHover(e);}else{return jQuery.iNestedSortable.oldCheckHover(e,o);}},oldCheckHover:jQuery.iSort.checkhover,newCheckHover:function(e){if(!jQuery.iDrag.dragged){return;}
if(!(e.dropCfg.el.size()>0)){return;}
if(!e.nestedSortCfg.remeasured){jQuery.iSort.measure(e);e.nestedSortCfg.remeasured=true;}
var precItem=jQuery.iNestedSortable.findPrecedingItem(e);var shouldNest=jQuery.iNestedSortable.shouldNestItem(e,precItem);var touchingFirst=(!precItem)?jQuery.iNestedSortable.isTouchingFirstItem(e):false;var quit=false;if(precItem){if(e.nestedSortCfg.lastPrecedingItem===precItem&&e.nestedSortCfg.lastShouldNest===shouldNest){quit=true;}}
else if(e.nestedSortCfg.lastPrecedingItem===precItem&&e.nestedSortCfg.lastTouchingFirst===touchingFirst){quit=true;}
e.nestedSortCfg.lastPrecedingItem=precItem;e.nestedSortCfg.lastShouldNest=shouldNest;e.nestedSortCfg.lastTouchingFirst=touchingFirst;if(quit){return;}
if(precItem!==null){if(shouldNest){jQuery.iNestedSortable.nestItem(e,precItem);}else{jQuery.iNestedSortable.appendItem(e,precItem);}}else if(touchingFirst){jQuery.iNestedSortable.insertOnTop(e);}},scroll:function(e){if(!e.nestedSortCfg.autoScroll){return false;}
var sensitivity=e.nestedSortCfg.scrollSensitivity;var speed=e.nestedSortCfg.scrollSpeed;var pointer=jQuery.iDrag.dragged.dragCfg.currentPointer;var docDim=jQuery.iUtil.getScroll();if((pointer.y-docDim.ih)-docDim.t>-sensitivity){window.scrollBy(0,speed);}
if(pointer.y-docDim.t<sensitivity){window.scrollBy(0,-speed);}},check:function(dragged){jQuery.iNestedSortable.newCheck(dragged);return jQuery.iNestedSortable.oldCheck(dragged);},oldCheck:jQuery.iSort.check,newCheck:function(dragged){if(jQuery.iNestedSortable.latestNestingClass&&jQuery.iNestedSortable.currentNesting)
{jQuery.iNestedSortable.currentNesting.removeClass(jQuery.iNestedSortable.latestNestingClass);jQuery.iNestedSortable.currentNesting=null;jQuery.iNestedSortable.latestNestingClass="";}
if(jQuery.iDrop.overzone.isNestedSortable){jQuery.iDrop.overzone.nestedSortCfg.remeasured=false;}},serialize:function(s){if(jQuery('#'+s).get(0).isNestedSortable){return jQuery.iNestedSortable.newSerialize(s);}else{return jQuery.iNestedSortable.oldSerialize(s);}},oldSerialize:jQuery.iSort.serialize,newSerialize:function(s){var i;var h='';var currentPath='';var o={};var e;var buildHierarchySer=function(context){var retVal=[];thisChildren=jQuery(context).children('.'+jQuery.iSort.collected[s]);thisChildren.each(function(i){var serId=jQuery.attr(this,'id');if(serId&&serId.match){serId=serId.match(e.nestedSortCfg.serializeRegExp)[0];}
if(h.length>0){h+='&';}
h+=s+currentPath+'['+i+'][id]='+serId;retVal[i]={id:serId};var newContext=jQuery(this).children(e.nestedSortCfg.nestingTag+"."+e.nestedSortCfg.nestingTagClass.split(" ").join(".")).get(0);var oldPath=currentPath;currentPath+='['+i+'][children]';var thisChildren=buildHierarchySer(newContext);if(thisChildren.length>0){retVal[i].children=thisChildren;}
currentPath=oldPath;});return retVal;};if(s){if(jQuery.iSort.collected[s]){e=jQuery('#'+s).get(0);o[s]=buildHierarchySer(e);}else{for(a in s){if(jQuery.iSort.collected[s[a]]){e=jQuery('#'+s[a]).get(0);o[s[a]]=buildHierarchySer(e);}}}}else{for(i in jQuery.iSort.collected){e=jQuery('#'+i).get(0);o[i]=buildHierarchySer(e);}}
return{hash:h,o:o};},findPrecedingItem:function(e){var largestY=0;var preceding=jQuery.grep(e.dropCfg.el,function(i){var isOnTop=(i.pos.y<jQuery.iDrag.dragged.dragCfg.ny)&&(i.pos.y>largestY);if(!isOnTop){return false;}
var isSameLevel;if(e.nestedSortCfg.rightToLeft){isSameLevel=(i.pos.x+i.pos.wb+e.nestedSortCfg.snapTolerance>jQuery.iDrag.dragged.dragCfg.nx+jQuery.iDrag.dragged.dragCfg.oC.wb);}else{isSameLevel=(i.pos.x-e.nestedSortCfg.snapTolerance<jQuery.iDrag.dragged.dragCfg.nx);}
if(!isSameLevel){return false;}
var isBeingDragged=jQuery.iNestedSortable.isBeingDragged(e,i);if(isBeingDragged){return false;}
largestY=i.pos.y;return true;});if(preceding.length>0){return preceding[(preceding.length-1)];}else{return null;}},isTouchingFirstItem:function(e){var lowestY;var firstItem=jQuery.grep(e.dropCfg.el,function(i){var isBefore=(lowestY===undefined||i.pos.y<lowestY);if(!isBefore){return false;}
var isBeingDragged=jQuery.iNestedSortable.isBeingDragged(e,i);if(isBeingDragged){return false;}
lowestY=i.pos.y;return true;});if(firstItem.length>0){firstItem=firstItem[(firstItem.length-1)];return firstItem.pos.y<jQuery.iDrag.dragged.dragCfg.ny+jQuery.iDrag.dragged.dragCfg.oC.hb&&firstItem.pos.y>jQuery.iDrag.dragged.dragCfg.ny;}else{return false;}},isBeingDragged:function(e,elem){var dragged=jQuery.iDrag.dragged;if(!dragged){return false;}
if(elem==dragged){return true;}
if(jQuery(elem).parents("."+e.sortCfg.accept.split(" ").join(".")).filter(function(){return this==dragged;}).length!==0){return true;}else{return false;}},shouldNestItem:function(e,precedingItem){if(!precedingItem){return false;}
if(e.nestedSortCfg.noNestingClass&&jQuery(precedingItem).filter("."+e.nestedSortCfg.noNestingClass).get(0)===precedingItem)
{return false;}
if(e.nestedSortCfg.rightToLeft){return precedingItem.pos.x+precedingItem.pos.wb-(e.nestedSortCfg.nestingPxSpace-e.nestedSortCfg.snapTolerance)>jQuery.iDrag.dragged.dragCfg.nx+jQuery.iDrag.dragged.dragCfg.oC.wb;}else{return precedingItem.pos.x+(e.nestedSortCfg.nestingPxSpace-e.nestedSortCfg.snapTolerance)<jQuery.iDrag.dragged.dragCfg.nx;}},nestItem:function(e,parent){var parentNesting=jQuery(parent).children(e.nestedSortCfg.nestingTag+"."+e.nestedSortCfg.nestingTagClass.split(" ").join("."));var helper=jQuery.iSort.helper;styleHelper=helper.get(0).style;styleHelper.width='auto';if(!parentNesting.size()){var newUl="<"+e.nestedSortCfg.nestingTag+" class='"+e.nestedSortCfg.nestingTagClass+"'></"+e.nestedSortCfg.nestingTag+">";parentNesting=jQuery(parent).append(newUl).children(e.nestedSortCfg.nestingTag).css(e.nestedSortCfg.styleToAttach);}
jQuery.iNestedSortable.updateCurrentNestingClass(e,parentNesting);jQuery.iNestedSortable.beforeHelperRemove(e);parentNesting.prepend(helper.get(0));jQuery.iNestedSortable.afterHelperInsert(e);},appendItem:function(e,itemBefore){jQuery.iNestedSortable.updateCurrentNestingClass(e,jQuery(itemBefore).parent());jQuery.iNestedSortable.beforeHelperRemove(e);jQuery(itemBefore).after(jQuery.iSort.helper.get(0));jQuery.iNestedSortable.afterHelperInsert(e);},insertOnTop:function(e){jQuery.iNestedSortable.updateCurrentNestingClass(e,e);jQuery.iNestedSortable.beforeHelperRemove(e);jQuery(e).prepend(jQuery.iSort.helper.get(0));jQuery.iNestedSortable.afterHelperInsert(e);},beforeHelperRemove:function(e){var parent=jQuery.iSort.helper.parent(e.nestedSortCfg.nestingTag+"."+e.nestedSortCfg.nestingTagClass.split(" ").join("."));var numSiblings=parent.children("."+e.sortCfg.accept.split(" ").join(".")+":visible").size();if(numSiblings===0&&parent.get(0)!==e){parent.hide();}},afterHelperInsert:function(e){var parent=jQuery.iSort.helper.parent();if(parent.get(0)!==e){parent.show();}
e.nestedSortCfg.remeasured=false;},updateCurrentNestingClass:function(e,nestingElem){var nesting=jQuery(nestingElem);if((e.nestedSortCfg.currentNestingClass)&&(!jQuery.iNestedSortable.currentNesting||nesting.get(0)!=jQuery.iNestedSortable.currentNesting.get(0))){if(jQuery.iNestedSortable.currentNesting){jQuery.iNestedSortable.currentNesting.removeClass(e.nestedSortCfg.currentNestingClass);}
if(nesting.get(0)!=e){jQuery.iNestedSortable.currentNesting=nesting;nesting.addClass(e.nestedSortCfg.currentNestingClass);jQuery.iNestedSortable.latestNestingClass=e.nestedSortCfg.currentNestingClass;}else{jQuery.iNestedSortable.currentNesting=null;jQuery.iNestedSortable.latestNestingClass="";}}},destroy:function(){return this.each(function(){if(this.isNestedSortable){this.nestedSortCfg=null;this.isNestedSortable=null;jQuery(this).SortableDestroy();}});},build:function(conf){if(conf.accept&&jQuery.iUtil&&jQuery.iDrag&&jQuery.iDrop&&jQuery.iSort)
{this.each(function(){this.isNestedSortable=true;this.nestedSortCfg={noNestingClass:conf.noNestingClass?conf.noNestingClass:false,rightToLeft:conf.rightToLeft?true:false,nestingPxSpace:parseInt(conf.nestingPxSpace,10)||30,currentNestingClass:conf.currentNestingClass?conf.currentNestingClass:"",nestingLimit:conf.nestingLimit?conf.nestingLimit:false,autoScroll:conf.autoScroll!==undefined?conf.autoScroll==true:true,scrollSensitivity:conf.scrollSensitivity?conf.scrollSensitivity:20,scrollSpeed:conf.scrollSpeed?conf.scrollSpeed:20,serializeRegExp:conf.serializeRegExp?conf.serializeRegExp:/[^\-]*$/};this.nestedSortCfg.snapTolerance=parseInt(this.nestedSortCfg.nestingPxSpace*0.4,10);this.nestedSortCfg.nestingTag=this.tagName;this.nestedSortCfg.nestingTagClass=this.className;this.nestedSortCfg.styleToAttach=(this.nestedSortCfg.rightToLeft)?{"padding-left":0,"padding-right":this.nestedSortCfg.nestingPxSpace+'px'}:{"padding-left":this.nestedSortCfg.nestingPxSpace+'px',"padding-right":0};jQuery(this.nestedSortCfg.nestingTag,this).css(this.nestedSortCfg.styleToAttach);});jQuery.iSort.checkhover=jQuery.iNestedSortable.checkHover;jQuery.iSort.check=jQuery.iNestedSortable.check;jQuery.iSort.serialize=jQuery.iNestedSortable.serialize;}
return this.Sortable(conf);}};jQuery.fn.extend({NestedSortable:jQuery.iNestedSortable.build,NestedSortableDestroy:jQuery.iNestedSortable.destroy});jQuery.iUtil.getScroll=function(e)
{var t,l,w,h,iw,ih;if(e&&e.nodeName.toLowerCase()!='body'){t=e.scrollTop;l=e.scrollLeft;w=e.scrollWidth;h=e.scrollHeight;iw=0;ih=0;}else{if(document.documentElement&&document.documentElement.scrollTop){t=document.documentElement.scrollTop;l=document.documentElement.scrollLeft;w=document.documentElement.scrollWidth;h=document.documentElement.scrollHeight;}else if(document.body){t=document.body.scrollTop;l=document.body.scrollLeft;w=document.body.scrollWidth;h=document.body.scrollHeight;}
iw=self.innerWidth||document.documentElement.clientWidth||document.body.clientWidth||0;ih=self.innerHeight||document.documentElement.clientHeight||document.body.clientHeight||0;}
return{t:t,l:l,w:w,h:h,iw:iw,ih:ih};};
