---
layout: post
title: "3.5 Use Controllers in RESTier [>=0.4.0-beta]"
description: ""
category: "3. Extensions"
---

RESTier aims to achieve more OData features with less user code. Currently in OData Web API users have to write a controller for each entity set or singleton and a lot of actions in that controller to support various property access. Mostly code among controllers is similar and redundant. Thus `RestierController` (previously `ODataDomainController`) was introduced to serve as the globally unique controller to handle most OData requests. While most is not everything, there are a few scenarios not covered by `RestierController` yet. As a result, traditional controllers (`ODataController` or `ApiController`) are still supported in RESTier's routing convention with higher priority than `RestierController`. With such a flexible design, RESTier can satisfy various user requirements to implement an OData service.

### OData features supported by RestierController
Now users need not write any controller code any more to enjoy the following OData features provided by `RestierController`:

 - Query service document
{% highlight text %}
GET ~
{% endhighlight %}
 - Query metadata document
{% highlight text %}
GET ~/$metadata
{% endhighlight %}
 - Query entity set
{% highlight text %}
GET ~/People
{% endhighlight %}
 - Query single entity
{% highlight text %}
GET ~/People(1)
{% endhighlight %}
 - Query any property path
{% highlight text %}
GET ~/People(1)/FirstName (primitive property)
GET ~/People(1)/FavoriteFeature (enum property)
GET ~/People(1)/Friends (navigation property)
GET ~/People(1)/Emails (collection property)
GET ~/Events(1)/OccursAt (complex property)
GET ~/Events(1)/OccursAt/Address
{% endhighlight %}
 - Query entity/value count (by $count)
{% highlight text %}
GET ~/People(1)/$count
GET ~/People(1)/Friends/$count
GET ~/People(1)/Emails/$count
{% endhighlight %}
 - Query raw property value (by $value)
{% highlight text %}
GET ~/People(1)/FirstName/$value
GET ~/People(1)/FavoriteFeature/$value
GET ~/Events(1)/OccursAt/Address/$value
{% endhighlight %}
 - Create an entity
{% highlight text %}
POST ~/People
{% endhighlight %}
 - Fully update an entity
{% highlight text %}
PUT ~/People(1)
{% endhighlight %}
 - Partially update an entity
{% highlight text %}
PATCH ~/People(1)
{% endhighlight %}
 - Delete an entity
{% highlight text %}
DELETE ~/People(1)
{% endhighlight %}

### A little secret behind query
Users may wonder how RESTier handles all these queries in a generic way in only one controller. Actually `RestierController` will use an internal class `RestierQueryBuilder` to go through each `ODataPathSegment` and gradually compose a LINQ query. Here is an example. If user sends the following query:

{% highlight text %}
GET ~/People(1)/Emails/$count
{% endhighlight %}

The final LINQ query generated will be like (suppose EF is being used):

{% highlight csharp %}
DbContext.People.Where<Person>(p => p.PersonId == 1).SelectMany<string>(p => p.Emails).Count();
{% endhighlight %}

### Use custom controllers
Users may not always want their requests to be processed by `RestierController`. RESTier of course provides several ways to override this.

 - **Convention routing**. If user defines a controller (**MUST** inherit from `ODataController`) with specific name for an entity set (like `PeopleController` for the entity set `People`), all requests to that entity set will be routed to the the user-defined controller instead of `RestierController`.
 - **Attribute routing**. `ODataRouteAttribute` always has the highest priority in routing. Now users are recommended to use attribute routing to implement OData operation and singleton.