---
layout: post
title: "1.4 Bootstrap an OData service [>=0.4.0-beta]"
description: ""
category: "1. Getting Started"
---

After RESTier 0.4.0-beta, creating an OData service has never been easier! This subsection shows how to create an OData V4 endpoint using RESTier in a few minutes. [AdventureWorksLT](http://msftdbprodsamples.codeplex.com/downloads/get/354847) will be used as the sample database and [Entity Framework](http://msdn.microsoft.com/en-us/data/ef.aspx) as the data proxy.

### Create a project and a web app
1.Open Visual Studio 2015 or Visual Studio 2013. If you use Visual Studio 2013, the screens will be slightly different from the screenshots, but the procedures are essentially the same.

2.From the **File** menu, click **New > Project**.

3.In the **New Project** dialog box, click **C# > Web > ASP.NET Web Application**.

4.Clear the **Add Application Insights to Project** check box.

5.Name the application **HelloWorld**.

6.Click **OK**.

![]({{site.baseurl}}/images/solution.PNG)

7.In the **New ASP.NET Project** dialog box, select the **Empty** template.

8.Select the **Web API** check box.

9.Clear the **Host in the cloud** check box.

![]({{site.baseurl}}/images/project.PNG)

### Install the RESTier packages

1.In the **Solution Explorer** window, right click the project **HelloWorld** and select **Manage NuGet Packages...**.

2.In the **NuGet Package Manager** window, select the **Include prerelease** checkbox.

3.Type **Restier** in the **Search Box** beside and press **Enter**.

4.Select **Microsoft.Restier** and click the **Install** button.

![]({{site.baseurl}}/images/nuget.PNG)

5.In the **Preview** dialog box, click the **OK** button.

![]({{site.baseurl}}/images/preview.PNG)

6.In the **License Acceptance** dialog box, click the **I Accept** button.

![]({{site.baseurl}}/images/license.PNG)

### Generate the model classes

1.Download [AdventureWorksLT2012_Data.mdf](http://msftdbprodsamples.codeplex.com/downloads/get/354847) and [import](https://msdn.microsoft.com/en-us/library/8b6y4c7s.aspx) it into the `(localdb)\MSSQLLocalDB` database.

2.In the **Solution Explorer** window, right click the **Models** folder under the project **HelloWorld** and select **Add > New Item**.

3.In the **Add New Item - HelloWorld** dialog box, click **C# > Data > ADO.NET Entity Data Model**.

4.Name the model **AdventureWorksLT**.

5.Click the **Add** button.

![]({{site.baseurl}}/images/model.PNG)

6.In the **Entity Data Model Wizard** window, select the item **Code First from database**.

7.Click the **Next** button.

![]({{site.baseurl}}/images/codefirst1.PNG)

8.Click the **New Connection** button.

![]({{site.baseurl}}/images/codefirst2.PNG)

9.In the **Connection Properties** dialog box, type **(localdb)\MSSQLLocalDB** for **Server name**.

10.Select **AdventureWorksLT2012** for **database name**.

![]({{site.baseurl}}/images/codefirst3.PNG)

11.After returning to the **Entity Data Model Wizard** window, click the **Next** button.

![]({{site.baseurl}}/images/codefirst4.PNG)

12.Select the **Tables** check box and click the **Finish** button.

![]({{site.baseurl}}/images/codefirst5.PNG)

### Configure the OData Endpoint
In the **Solution Explorer** window, click **HelloWorld > App_Start > WebApiConfig.cs**. Replace the `WebApiConfig` class the following code.

{% highlight csharp %}
using System.Web.Http;
using HelloWorld.Models;
using Microsoft.Restier.EntityFramework;
using Microsoft.Restier.WebApi;
using Microsoft.Restier.WebApi.Batch;

namespace HelloWorld
{
    public static class WebApiConfig
    {
        public async static void Register(HttpConfiguration config)
        {
            await config.MapRestierRoute<DbApi<AdventureWorksLT>>(
                "AdventureWorksLT",
                "api/AdventureWorksLT",
                new RestierBatchHandler(GlobalConfiguration.DefaultServer));
        }
    }
}

{% endhighlight %}

After these steps, you will have finished bootstrapping an OData service endpoint. You can then *Run* the project and an OData service is started. Then you can start by accessing the URL `http://localhost:<ISS Express port>/api/AdventureWorksLT` to view all available entity sets, and try with other basic OData CRUD operations. For instance, you may try querying any of the entity sets using the `$select`, `$filter`, `$orderby`, `$top` or `$skip` query string parameters.