---
layout: post
title: "3.6 In-Memory Provider [>=0.4.0-beta]"
description: ""
category: "3. Extensions"
---

RESTier supports building an OData service with **all-in-memory** resources. However currently RESTier has not provided a dedicated in-memory provider (probably part of the future plan) module so users have to write some service code to bootstrap the initial model with EDM types themselves. There is a sample service with in-memory provider [here](https://github.com/OData/RESTier/tree/apidev/test/ODataEndToEndTests/Microsoft.Restier.WebApi.Test.Services.TrippinInMemory). This subsection mainly talks about how such a service is created.

First please create an **Empty ASP.NET Web API** project following the instructions in [1.4](http://odata.github.io/RESTier/#01-04-Bootstrap). Stop **BEFORE** the **Generate the model classes** part.

### Create the Api class
Create a simple data type `Person` with some properties and "fabricate" some fake data. Then add the first entity set `People` to the `Api` class:

{% highlight csharp %}
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using System.Web.OData.Builder;
using Microsoft.OData.Edm;
using Microsoft.Restier.Core;
using Microsoft.Restier.Core.Model;

namespace Microsoft.Restier.WebApi.Test.Services.TrippinInMemory
{
    public class TrippinApi : ApiBase
    {
        private static readonly List<Person> people = new List<Person>
        {
            ...
        };

        public IQueryable<Person> People
        {
            get { return people.AsQueryable(); }
        }
    }
}
{% endhighlight %}

### Create an initial model
Since the RESTier convention will not produce any EDM type, an initial model with at least the `Person` type needs to be created by service. Here the `ODataConventionModelBuilder` from OData Web API is used for quick model building.

{% highlight csharp %}
namespace Microsoft.Restier.WebApi.Test.Services.TrippinInMemory
{
    public class TrippinApi : ApiBase
    {
        protected override ApiConfiguration CreateApiConfiguration()
        {
            return base.CreateApiConfiguration()
                .AddHookHandler<IModelBuilder>(new ModelBuilder());
        }

        private class ModelBuilder : IModelBuilder
        {
            public Task<IEdmModel> GetModelAsync(InvocationContext context, CancellationToken cancellationToken)
            {
                var builder = new ODataConventionModelBuilder();
                builder.EntityType<Person>();
                return Task.FromResult(builder.GetEdmModel());
            }
        }
    }
}
{% endhighlight %}

### Configure the OData endpoint
Replace the `WebApiConfig` class with the following code. No need to create a custom controller if users don't have attribute routing.

{% highlight csharp %}
using System.Web.Http;
using Microsoft.Restier.WebApi.Batch;

namespace Microsoft.Restier.WebApi.Test.Services.TrippinInMemory
{
    public static class WebApiConfig
    {
        public static void Register(HttpConfiguration config)
        {
            config.MapRestierRoute<TrippinApi>(
                "TrippinApi",
                "api/Trippin",
                new RestierBatchHandler(GlobalConfiguration.DefaultServer)).Wait();
        }
    }
}
{% endhighlight %}