---
layout: post
title: "3.7 Use temporal types in RESTier EF [>=0.5.0-beta]"
description: ""
category: "3. Extensions"
---

Restier.EF now supports various temporal types. Compared to the previous support, the current solution is more consistent and extensible. You can find the detailed type-mapping table among *EF type*, *SQL type* and *EDM type* from the comment in [Issue #279](https://github.com/OData/RESTier/pull/279). Now almost all the OData scenarios (CRUD) of these temporal types should be well supported by RESTier.

This subsection shows how to use temporal types in Restier.EF.

### Add Edm.DateTimeOffset property
Suppose you have an entity class `Person`, all the following code define `Edm.DateTimeOffset` properties in the EDM model though the underlying SQL types are different (see the value of the `TypeName` property).

{% highlight csharp %}
using System;
using System.ComponentModel.DataAnnotations.Schema;

public class Person
{
    public DateTime BirthDateTime1 { get; set; }

    [Column(TypeName = "DateTime")]
    public DateTime BirthDateTime2 { get; set; }

    [Column(TypeName = "DateTime2")]
    public DateTime BirthDateTime3 { get; set; }

    public DateTimeOffset BirthDateTime4 { get; set; }
}
{% endhighlight %}

### Add Edm.Date property
The following code define an `Edm.Date` property in the EDM model.

{% highlight csharp %}
using System;
using System.ComponentModel.DataAnnotations.Schema;

public class Person
{
    [Column(TypeName = "Date")]
    public DateTime BirthDate { get; set; }
}
{% endhighlight %}

### Add Edm.Duration property
The following code define an `Edm.Duration` property in the EDM model.

{% highlight csharp %}
using System;
using System.ComponentModel.DataAnnotations.Schema;

public class Person
{
    public TimeSpan WorkingHours { get; set; }
}
{% endhighlight %}

### Add Edm.TimeOfDay property
The following code define an `Edm.TimeOfDay` property in the EDM model. Please note that you MUST NOT omit the `ColumnTypeAttribute` on a `TimeSpan` property otherwise it will be recognized as an `Edm.Duration` as described above.

{% highlight csharp %}
using System;
using System.ComponentModel.DataAnnotations.Schema;

public class Person
{
    [Column(TypeName = "Time")]
    public TimeSpan BirthTime { get; set; }
}
{% endhighlight %}

As before, if you have the need to override `ODataPayloadValueConverter`, please now change to override `RestierPayloadValueConverter` instead in order not to break the payload value conversion specialized for these temporal types.