*   Default the new `I18n.enforce_available_locales` config to `true`, meaning
    `I18n` will make sure that all locales passed to it must be declared in the
    `available_locales` list.

    To disable it add the following configuration to your application:

        config.i18n.enforce_available_locales = false

    This also ensures I18n configuration is properly initialized taking the new
    option into account, to avoid their deprecations while booting up the app.

    *Carlos Antonio da Silva*, *Yves Senn*

*   Introduce Module#concerning: a natural, low-ceremony way to separate
    responsibilities within a class.

    Imported from https://github.com/37signals/concerning#readme

        class Todo < ActiveRecord::Base
          concerning :EventTracking do
            included do
              has_many :events
            end

            def latest_event
              ...
            end

            private
              def some_internal_method
                ...
              end
          end

          concerning :Trashable do
            def trashed?
              ...
            end

            def latest_event
              super some_option: true
            end
          end
        end

    is equivalent to defining these modules inline, extending them into
    concerns, then mixing them in to the class.

    Inline concerns tame "junk drawer" classes that intersperse many unrelated
    class-level declarations, public instance methods, and private
    implementation. Coalesce related bits and give them definition.
    These are a stepping stone toward future growth & refactoring.

    When to move on from an inline concern:
     * Encapsulating state? Extract collaborator object.
     * Encompassing more public behavior or implementation? Move to separate file.
     * Sharing behavior among classes? Move to separate file.

    *Jeremy Kemper*

*   Fix file descriptor being leaked on each call to `Kernel.silence_stream`.

    *Mario Visic*

*   Added `Date#all_week/month/quarter/year` for generating date ranges.

    *Dmitriy Meremyanin*

*   Add `Time.zone.yesterday` and `Time.zone.tomorrow`. These follow the
    behavior of Ruby's `Date.yesterday` and `Date.tomorrow` but return localized
    versions, similar to how `Time.zone.today` has returned a localized version
    of `Date.today`.

    *Colin Bartlett*

*   Show valid keys when `assert_valid_keys` raises an exception, and show the
    wrong value as it was entered.

    *Gonzalo Rodríguez-Baltanás Díaz*

*   Both `cattr_*` and `mattr_*` method definitions now live in `active_support/core_ext/module/attribute_accessors`.

    Requires to `active_support/core_ext/class/attribute_accessors` are
    deprecated and will be removed in Ruby on Rails 4.2.

    *Genadi Samokovarov*

*   Deprecated `Numeric#{ago,until,since,from_now}`, the user is expected to explicitly
    convert the value into an AS::Duration, i.e. `5.ago` => `5.seconds.ago`

    This will help to catch subtle bugs like:

        def recent?(days = 3)
          self.created_at >= days.ago
        end

    The above code would check if the model is created within the last 3 **seconds**.

    In the future, `Numeric#{ago,until,since,from_now}` should be removed completely,
    or throw some sort of errors to indicate there are no implicit conversion from
    Numeric to AS::Duration.

    *Godfrey Chan*

*   Requires JSON gem version 1.7.7 or above due to a security issue in older versions.

    *Godfrey Chan*

*   Removed the old pure-Ruby JSON encoder and switched to a new encoder based on the built-in JSON
    gem.

    Support for encoding `BigDecimal` as a JSON number, as well as defining custom `encode_json`
    methods to control the JSON output has been **removed from core**. The new encoder will always
    encode BigDecimals as `String`s and ignore any custom `encode_json` methods.

    The old encoder has been extracted into the `activesupport-json_encoder` gem. Installing that
    gem will bring back the ability to encode `BigDecimal`s as numbers as well as `encode_json`
    support.

    Setting the related configuration `ActiveSupport.encode_big_decimal_as_string` without the
    `activesupport-json_encoder` gem installed will raise an error.

    *Godfrey Chan*

*   Add `ActiveSupport::Testing::TimeHelpers#travel` and `#travel_to`. These methods change current
    time to the given time or time difference by stubbing `Time.now` and `Date.today` to return the
    time or date after the difference calculation, or the time or date that got passed into the
    method respectively.

    Example for `#travel`:

        Time.now # => 2013-11-09 15:34:49 -05:00
        travel 1.day
        Time.now # => 2013-11-10 15:34:49 -05:00
        Date.today # => Sun, 10 Nov 2013

    Example for `#travel_to`:

        Time.now # => 2013-11-09 15:34:49 -05:00
        travel_to Time.new(2004, 11, 24, 01, 04, 44)
        Time.now # => 2004-11-24 01:04:44 -05:00
        Date.today # => Wed, 24 Nov 2004

    Both of these methods also accept a block, which will return the current time back to its
    original state at the end of the block:

        Time.now # => 2013-11-09 15:34:49 -05:00

        travel 1.day do
          User.create.created_at # => Sun, 10 Nov 2013 15:34:49 EST -05:00
        end

        travel_to Time.new(2004, 11, 24, 01, 04, 44) do
          User.create.created_at # => Wed, 24 Nov 2004 01:04:44 EST -05:00
        end

        Time.now # => 2013-11-09 15:34:49 -05:00

    This module is included in `ActiveSupport::TestCase` automatically.

    *Prem Sichanugrist*, *DHH*

*   Unify `cattr_*` interface: allow to pass a block to `cattr_reader`.

    Example:

        class A
          cattr_reader(:defr) { 'default_reader_value' }
        end
        A.defr # => 'default_reader_value'

    *Alexey Chernenkov*

*   Improved compatibility with the stdlib JSON gem.

    Previously, calling `::JSON.{generate,dump}` sometimes causes unexpected
    failures such as intridea/multi_json#86.

    `::JSON.{generate,dump}` now bypasses the ActiveSupport JSON encoder
    completely and yields the same result with or without ActiveSupport. This
    means that it will **not** call `as_json` and will ignore any options that
    the JSON gem does not natively understand. To invoke ActiveSupport's JSON
    encoder instead, use `obj.to_json(options)` or
    `ActiveSupport::JSON.encode(obj, options)`.

    *Godfrey Chan*

*   Fix Active Support `Time#to_json` and `DateTime#to_json` to return 3 decimal
    places worth of fractional seconds, similar to `TimeWithZone`.

    *Ryan Glover*

*   Removed circular reference protection in JSON encoder, deprecated
    `ActiveSupport::JSON::Encoding::CircularReferenceError`.

    *Godfrey Chan*, *Sergio Campamá*

*   Add `capitalize` option to `Inflector.humanize`, so strings can be humanized without being capitalized:

        'employee_salary'.humanize                    # => "Employee salary"
        'employee_salary'.humanize(capitalize: false) # => "employee salary"

    *claudiob*

*   Fixed `Object#as_json` and `Struct#as_json` not working properly with options. They now take
    the same options as `Hash#as_json`:

        struct = Struct.new(:foo, :bar).new
        struct.foo = "hello"
        struct.bar = "world"
        json = struct.as_json(only: [:foo]) # => {foo: "hello"}

    *Sergio Campamá*, *Godfrey Chan*

*   Added `Numeric#in_milliseconds`, like `1.hour.in_milliseconds`, so we can feed them to JavaScript functions like `getTime()`.

    *DHH*

*   Calling `ActiveSupport::JSON.decode` with unsupported options now raises an error.

    *Godfrey Chan*

*   Support `:unless_exist` in `FileStore`.

    *Michael Grosser*

*   Fix `slice!` deleting the default value of the hash.

    *Antonio Santos*

*   `require_dependency` accepts objects that respond to `to_path`, in
    particular `Pathname` instances.

    *Benjamin Fleischer*

*   Disable the ability to iterate over Range of AS::TimeWithZone
    due to significant performance issues.

    *Bogdan Gusiev*

*   Allow attaching event subscribers to ActiveSupport::Notifications namespaces
    before they're defined. Essentially, this means instead of this:

        class JokeSubscriber < ActiveSupport::Subscriber
          def sql(event)
            puts "A rabbi and a priest walk into a bar..."
          end

          # This call needs to happen *after* defining the methods.
          attach_to "active_record"
        end

    You can do this:

        class JokeSubscriber < ActiveSupport::Subscriber
          # This is much easier to read!
          attach_to "active_record"

          def sql(event)
            puts "A rabbi and a priest walk into a bar..."
          end
        end

    This should make it easier to read and understand these subscribers.

    *Daniel Schierbeck*

*   Add `Date#middle_of_day`, `DateTime#middle_of_day` and `Time#middle_of_day` methods.

    Also added `midday`, `noon`, `at_midday`, `at_noon` and `at_middle_of_day` as aliases.

    *Anatoli Makarevich*

*   Fix ActiveSupport::Cache::FileStore#cleanup to no longer rely on missing each_key method.

    *Murray Steele*

*   Ensure that autoloaded constants in all-caps nestings are marked as
    autoloaded.

    *Simon Coffey*

*   Add `String#remove(pattern)` as a short-hand for the common pattern of
    `String#gsub(pattern, '')`.

    *DHH*

*   Adds a new deprecation behaviour that raises an exception. Throwing this
    line into +config/environments/development.rb+

        ActiveSupport::Deprecation.behavior = :raise

    will cause the application to raise an +ActiveSupport::DeprecationException+
    on deprecations.

    Use this for aggressive deprecation cleanups.

    *Xavier Noria*

*   Remove 'cow' => 'kine' irregular inflection from default inflections.

    *Andrew White*

*   Add `DateTime#to_s(:iso8601)` and `Date#to_s(:iso8601)` for consistency.

    *Andrew White*

*   Add `Time#to_s(:iso8601)` for easy conversion of times to the iso8601 format for easy Javascript date parsing.

    *DHH*

*   Improve `ActiveSupport::Cache::MemoryStore` cache size calculation.
    The memory used by a key/entry pair is calculated via `#cached_size`:

        def cached_size(key, entry)
          key.to_s.bytesize + entry.size + PER_ENTRY_OVERHEAD
        end

    The value of `PER_ENTRY_OVERHEAD` is 240 bytes based on an [empirical
    estimation](https://gist.github.com/ssimeonov/6047200) for 64-bit MRI on
    1.9.3 and 2.0. GH#11512

    *Simeon Simeonov*

*   Only raise `Module::DelegationError` if it's the source of the exception.

    Fixes #10559

    *Andrew White*

*   Make `Time.at_with_coercion` retain the second fraction and return local time.

    Fixes #11350

    *Neer Friedman*, *Andrew White*

*   Make `HashWithIndifferentAccess#select` always return the hash, even when
    `Hash#select!` returns `nil`, to allow further chaining.

    *Marc Schütz*

*   Remove deprecated `String#encoding_aware?` core extensions (`core_ext/string/encoding`).

    *Arun Agrawal*

*   Remove deprecated `Module#local_constant_names` in favor of `Module#local_constants`.

    *Arun Agrawal*

*   Remove deprecated `DateTime.local_offset` in favor of `DateTime.civil_from_fromat`.

    *Arun Agrawal*

*   Remove deprecated `Logger` core extensions (`core_ext/logger.rb`).

    *Carlos Antonio da Silva*

*   Remove deprecated `Time#time_with_datetime_fallback`, `Time#utc_time`
    and `Time#local_time` in favor of `Time#utc` and `Time#local`.

    *Vipul A M*

*   Remove deprecated `Hash#diff` with no replacement.

    If you're using it to compare hashes for the purpose of testing, please use
    MiniTest's `assert_equal` instead.

    *Carlos Antonio da Silva*

*   Remove deprecated `Date#to_time_in_current_zone` in favor of `Date#in_time_zone`.

    *Vipul A M*

*   Remove deprecated `Proc#bind` with no replacement.

    *Carlos Antonio da Silva*

*   Remove deprecated `Array#uniq_by` and `Array#uniq_by!`, use native
    `Array#uniq` and `Array#uniq!` instead.

    *Carlos Antonio da Silva*

*   Remove deprecated `ActiveSupport::BasicObject`, use `ActiveSupport::ProxyObject` instead.

    *Carlos Antonio da Silva*

*   Remove deprecated `BufferedLogger`, use `ActiveSupport::Logger` instead.

    *Yves Senn*

*   Remove deprecated `assert_present` and `assert_blank` methods, use `assert
    object.blank?` and `assert object.present?` instead.

    *Yves Senn*

*   Fix return value from `BacktraceCleaner#noise` when the cleaner is configured
    with multiple silencers.

    Fixes #11030

    *Mark J. Titorenko*

*   `HashWithIndifferentAccess#select` now returns a `HashWithIndifferentAccess`
    instance instead of a `Hash` instance.

    Fixes #10723

    *Albert Llop*

*   Add `DateTime#usec` and `DateTime#nsec` so that `ActiveSupport::TimeWithZone` keeps
    sub-second resolution when wrapping a `DateTime` value.

    Fixes #10855

    *Andrew White*

*   Fix `ActiveSupport::Dependencies::Loadable#load_dependency` calling
    `#blame_file!` on Exceptions that do not have the Blamable mixin

    *Andrew Kreiling*

*   Override `Time.at` to support the passing of Time-like values when called with a single argument.

    *Andrew White*

*   Prevent side effects to hashes inside arrays when
    `Hash#with_indifferent_access` is called.

    Fixes #10526

    *Yves Senn*

*   Removed deprecated `ActiveSupport::JSON::Variable` with no replacement.

    *Toshinori Kajihara*

*   Raise an error when multiple `included` blocks are defined for a Concern.
    The old behavior would silently discard previously defined blocks, running
    only the last one.

    *Mike Dillon*

*   Replace `multi_json` with `json`.

    Since Rails requires Ruby 1.9 and since Ruby 1.9 includes `json` in the standard library,
    `multi_json` is no longer necessary.

    *Erik Michaels-Ober*

*   Added escaping of U+2028 and U+2029 inside the json encoder.
    These characters are legal in JSON but break the Javascript interpreter.
    After escaping them, the JSON is still legal and can be parsed by Javascript.

    *Mario Caropreso + Viktor Kelemen + zackham*

*   Fix skipping object callbacks using metadata fetched via callback chain
    inspection methods (`_*_callbacks`)

    *Sean Walbran*

*   Add a `fetch_multi` method to the cache stores. The method provides
    an easy to use API for fetching multiple values from the cache.

    Example:

        # Calculating scores is expensive, so we only do it for posts
        # that have been updated. Cache keys are automatically extracted
        # from objects that define a #cache_key method.
        scores = Rails.cache.fetch_multi(*posts) do |post|
          calculate_score(post)
        end

    *Daniel Schierbeck*

Please check [4-0-stable](https://github.com/rails/rails/blob/4-0-stable/activesupport/CHANGELOG.md) for previous changes.
