﻿' Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the Apache License, Version 2.0.  See License.txt in the project root for license information.
Imports System.Collections.Immutable
Imports System.Reflection.Metadata
Imports System.Reflection.Metadata.Ecma335
Imports Microsoft.CodeAnalysis.VisualBasic.Symbols
Imports Microsoft.CodeAnalysis.VisualBasic.UnitTests
Imports Microsoft.CodeAnalysis.Emit
Imports Microsoft.CodeAnalysis.Test.Utilities
Imports Roslyn.Test.Utilities

Namespace Microsoft.CodeAnalysis.VisualBasic.EditAndContinue.UnitTests

    Public Class EditAndContinuePdbTests
        Inherits EditAndContinueTestBase

        <Theory>
        <InlineData(DebugInformationFormat.Pdb)>
        <InlineData(DebugInformationFormat.PortablePdb)>
        Public Sub MethodExtents(format As DebugInformationFormat)
            Dim source0 = MarkedSource("
Imports System

Public Class C
    Function A() As Integer 
        Return 1
    End Function
                                   
    Sub F()              
#ExternalSource(""C:\F\A.vb"", 10)  
        Console.WriteLine()
#End ExternalSource
#ExternalSource(""C:\F\B.vb"", 20)  
        Console.WriteLine()
#End ExternalSource
    End Sub

    Function E() As Integer 
        Return 1
    End Function

    Sub G()
        Dim H1 = <N:0>Function() 1</N:0>

        Dim H2 = <N:1>Sub()
            Dim H3 = <N:2>Function() 3</N:2>
        End Sub</N:1>
    End Sub
End Class                           
", fileName:="C:\Enc1.vb")

            Dim source1 = MarkedSource("
Imports System

Public Class C
    Function A() As Integer 
        Return 1
    End Function
                                   
    Sub F()              
#ExternalSource(""C:\F\A.vb"", 10)  
        Console.WriteLine()
#End ExternalSource
#ExternalSource(""C:\F\C.vb"", 10)  
        Console.WriteLine()
#End ExternalSource
    End Sub

    Sub G()
        Dim H1 = <N:0>Function() 1</N:0>

        Dim H2 = <N:1>Sub()
            Dim H3 = <N:2>Function() 3</N:2>
            Dim H4 = <N:3>Function() 4</N:3>
        End Sub</N:1>
    End Sub

    Function E() As Integer 
        Return 1
    End Function
End Class", fileName:="C:\Enc1.vb")

            Dim source2 = MarkedSource("
Imports System

Public Class C
    Function A() As Integer 
        Return 3
    End Function
                                   
    Sub F()              
#ExternalSource(""C:\F\A.vb"", 10)  
        Console.WriteLine()
#End ExternalSource
#ExternalSource(""C:\F\E.vb"", 10)  
        Console.WriteLine()
#End ExternalSource
    End Sub

    Sub G()


        Dim H2 = <N:1>Sub()
            
            Dim H4 = <N:3>Function() 4</N:3>
        End Sub</N:1>
    End Sub

    Function E() As Integer 
        Return 1
    End Function

    Function B() As Integer 
        Return 4
    End Function
End Class", fileName:="C:\Enc1.vb")

            Dim compilation0 = CreateCompilationWithMscorlib({source0.Tree}, options:=ComSafeDebugDll.WithMetadataImportOptions(MetadataImportOptions.All), assemblyName:="EncMethodExtents")
            Dim compilation1 = compilation0.WithSource(source1.Tree)
            Dim compilation2 = compilation1.WithSource(source2.Tree)

            compilation0.VerifyDiagnostics()
            compilation1.VerifyDiagnostics()
            compilation2.VerifyDiagnostics()

            Dim v0 = CompileAndVerify(compilation0, emitOptions:=EmitOptions.Default.WithDebugInformationFormat(format))
            Dim md0 = ModuleMetadata.CreateFromImage(v0.EmittedAssemblyData)

            Dim f0 = compilation0.GetMember(Of MethodSymbol)("C.F")
            Dim f1 = compilation1.GetMember(Of MethodSymbol)("C.F")
            Dim f2 = compilation2.GetMember(Of MethodSymbol)("C.F")

            Dim g0 = compilation0.GetMember(Of MethodSymbol)("C.G")
            Dim g1 = compilation1.GetMember(Of MethodSymbol)("C.G")
            Dim g2 = compilation2.GetMember(Of MethodSymbol)("C.G")

            Dim a1 = compilation1.GetMember(Of MethodSymbol)("C.A")
            Dim a2 = compilation2.GetMember(Of MethodSymbol)("C.A")

            Dim b2 = compilation2.GetMember(Of MethodSymbol)("C.B")

            Dim generation0 = EmitBaseline.CreateInitialBaseline(md0, AddressOf v0.CreateSymReader().GetEncMethodDebugInfo)

            Dim syntaxMap1 = GetSyntaxMapFromMarkers(source0, source1)

            Dim diff1 = compilation1.EmitDifference(generation0,
                ImmutableArray.Create(New SemanticEdit(SemanticEditKind.Update, f0, f1, syntaxMap1, preserveLocalVariables:=True),
                                      New SemanticEdit(SemanticEditKind.Update, g0, g1, syntaxMap1, preserveLocalVariables:=True)))
            diff1.VerifySynthesizedMembers(
                "C: {_Closure$__}",
                "C._Closure$__: {$I4-0, $I4-2, $I4-3#1, $I4-1, _Lambda$__4-0, _Lambda$__4-1, _Lambda$__4-2, _Lambda$__4-3#1}")

            Dim reader1 = diff1.GetMetadata().Reader

            CheckEncLogDefinitions(reader1,
               Row(4, TableIndex.StandAloneSig, EditAndContinueOperation.Default),
               Row(5, TableIndex.StandAloneSig, EditAndContinueOperation.Default),
               Row(6, TableIndex.StandAloneSig, EditAndContinueOperation.Default),
               Row(5, TableIndex.TypeDef, EditAndContinueOperation.AddField),
               Row(5, TableIndex.Field, EditAndContinueOperation.Default),
               Row(11, TableIndex.MethodDef, EditAndContinueOperation.Default),
               Row(13, TableIndex.MethodDef, EditAndContinueOperation.Default),
               Row(16, TableIndex.MethodDef, EditAndContinueOperation.Default),
               Row(17, TableIndex.MethodDef, EditAndContinueOperation.Default),
               Row(18, TableIndex.MethodDef, EditAndContinueOperation.Default),
               Row(5, TableIndex.TypeDef, EditAndContinueOperation.AddMethod),
               Row(19, TableIndex.MethodDef, EditAndContinueOperation.Default))

            If format = DebugInformationFormat.PortablePdb Then
                Using pdbProvider = MetadataReaderProvider.FromPortablePdbImage(diff1.PdbDelta)
                    CheckEncMap(pdbProvider.GetMetadataReader(),
                        Handle(11, TableIndex.MethodDebugInformation),
                        Handle(13, TableIndex.MethodDebugInformation),
                        Handle(16, TableIndex.MethodDebugInformation),
                        Handle(17, TableIndex.MethodDebugInformation),
                        Handle(18, TableIndex.MethodDebugInformation),
                        Handle(19, TableIndex.MethodDebugInformation))
                End Using
            End If

            diff1.VerifyPdb(Enumerable.Range(&H6000001, 20),
<symbols>
    <files>
        <file id="1" name="C:\F\A.vb" language="3a12d0b8-c26c-11d0-b442-00a0244a1dd2" languageVendor="994b45c4-e6e9-11d2-903f-00c04fa302a1" documentType="5a869d0b-6611-11d3-bd2a-0000f80849bd"/>
        <file id="2" name="C:\F\C.vb" language="3a12d0b8-c26c-11d0-b442-00a0244a1dd2" languageVendor="994b45c4-e6e9-11d2-903f-00c04fa302a1" documentType="5a869d0b-6611-11d3-bd2a-0000f80849bd"/>
    </files>
    <methods>
        <method token="0x600000b">
            <sequencePoints>
                <entry offset="0x0" hidden="true" document="1"/>
                <entry offset="0x1" startLine="10" startColumn="9" endLine="10" endColumn="28" document="1"/>
                <entry offset="0x7" startLine="10" startColumn="9" endLine="10" endColumn="28" document="2"/>
                <entry offset="0xd" hidden="true" document="2"/>
            </sequencePoints>
            <scope startOffset="0x0" endOffset="0xe">
                <namespace name="System" importlevel="file"/>
                <currentnamespace name=""/>
            </scope>
        </method>
        <method token="0x600000d">
            <scope startOffset="0x0" endOffset="0x4c">
                <importsforward token="0x600000b"/>
                <local name="H1" il_index="2" il_start="0x0" il_end="0x4c" attributes="0"/>
                <local name="H2" il_index="3" il_start="0x0" il_end="0x4c" attributes="0"/>
            </scope>
        </method>
        <method token="0x6000010">
            <scope startOffset="0x0" endOffset="0x7">
                <importsforward token="0x600000b"/>
            </scope>
        </method>
        <method token="0x6000011">
            <scope startOffset="0x0" endOffset="0x4c">
                <importsforward token="0x600000b"/>
                <local name="H3" il_index="0" il_start="0x0" il_end="0x4c" attributes="0"/>
                <local name="H4" il_index="1" il_start="0x0" il_end="0x4c" attributes="0"/>
            </scope>
        </method>
        <method token="0x6000012">
            <scope startOffset="0x0" endOffset="0x7">
                <importsforward token="0x600000b"/>
            </scope>
        </method>
        <method token="0x6000013">
            <scope startOffset="0x0" endOffset="0x7">
                <importsforward token="0x600000b"/>
            </scope>
        </method>
    </methods>
</symbols>)

            Dim syntaxMap2 = GetSyntaxMapFromMarkers(source1, source2)
            Dim diff2 = compilation2.EmitDifference(diff1.NextGeneration,
                ImmutableArray.Create(New SemanticEdit(SemanticEditKind.Update, f1, f2, syntaxMap2, preserveLocalVariables:=True),
                                      New SemanticEdit(SemanticEditKind.Update, g1, g2, syntaxMap2, preserveLocalVariables:=True),
                                      New SemanticEdit(SemanticEditKind.Update, a1, a2, syntaxMap2, preserveLocalVariables:=True),
                                      New SemanticEdit(SemanticEditKind.Insert, Nothing, b2)))

            diff2.VerifySynthesizedMembers(
                "C: {_Closure$__}",
                "C._Closure$__: {$I4-3#1, $I4-1, _Lambda$__4-1, _Lambda$__4-3#1, $I4-0, $I4-2, _Lambda$__4-0, _Lambda$__4-2}")

            Dim reader2 = diff2.GetMetadata().Reader
            CheckEncLogDefinitions(reader2,
                Row(7, TableIndex.StandAloneSig, EditAndContinueOperation.Default),
                Row(8, TableIndex.StandAloneSig, EditAndContinueOperation.Default),
                Row(9, TableIndex.StandAloneSig, EditAndContinueOperation.Default),
                Row(10, TableIndex.StandAloneSig, EditAndContinueOperation.Default),
                Row(10, TableIndex.MethodDef, EditAndContinueOperation.Default),
                Row(11, TableIndex.MethodDef, EditAndContinueOperation.Default),
                Row(13, TableIndex.MethodDef, EditAndContinueOperation.Default),
                Row(17, TableIndex.MethodDef, EditAndContinueOperation.Default),
                Row(19, TableIndex.MethodDef, EditAndContinueOperation.Default),
                Row(4, TableIndex.TypeDef, EditAndContinueOperation.AddMethod),
                Row(20, TableIndex.MethodDef, EditAndContinueOperation.Default))

            If format = DebugInformationFormat.PortablePdb Then
                Using pdbProvider = MetadataReaderProvider.FromPortablePdbImage(diff2.PdbDelta)
                    CheckEncMap(pdbProvider.GetMetadataReader(),
                        Handle(10, TableIndex.MethodDebugInformation),
                        Handle(11, TableIndex.MethodDebugInformation),
                        Handle(13, TableIndex.MethodDebugInformation),
                        Handle(17, TableIndex.MethodDebugInformation),
                        Handle(19, TableIndex.MethodDebugInformation),
                        Handle(20, TableIndex.MethodDebugInformation))
                End Using
            End If

            diff2.VerifyPdb(Enumerable.Range(&H6000001, 20),
<symbols>
    <files>
        <file id="1" name="C:\F\A.vb" language="3a12d0b8-c26c-11d0-b442-00a0244a1dd2" languageVendor="994b45c4-e6e9-11d2-903f-00c04fa302a1" documentType="5a869d0b-6611-11d3-bd2a-0000f80849bd"/>
        <file id="2" name="C:\F\E.vb" language="3a12d0b8-c26c-11d0-b442-00a0244a1dd2" languageVendor="994b45c4-e6e9-11d2-903f-00c04fa302a1" documentType="5a869d0b-6611-11d3-bd2a-0000f80849bd"/>
    </files>
    <methods>
        <method token="0x600000a">
            <scope startOffset="0x0" endOffset="0x7">
                <namespace name="System" importlevel="file"/>
                <currentnamespace name=""/>
                <local name="A" il_index="1" il_start="0x0" il_end="0x7" attributes="0"/>
            </scope>
        </method>
        <method token="0x600000b">
            <sequencePoints>
                <entry offset="0x0" hidden="true" document="1"/>
                <entry offset="0x1" startLine="10" startColumn="9" endLine="10" endColumn="28" document="1"/>
                <entry offset="0x7" startLine="10" startColumn="9" endLine="10" endColumn="28" document="2"/>
                <entry offset="0xd" hidden="true" document="2"/>
            </sequencePoints>
            <scope startOffset="0x0" endOffset="0xe">
                <importsforward token="0x600000a"/>
            </scope>
        </method>
        <method token="0x600000d">
            <scope startOffset="0x0" endOffset="0x28">
                <importsforward token="0x600000a"/>
                <local name="H2" il_index="4" il_start="0x0" il_end="0x28" attributes="0"/>
            </scope>
        </method>
        <method token="0x6000011">
            <scope startOffset="0x0" endOffset="0x27">
                <importsforward token="0x600000a"/>
                <local name="H4" il_index="0" il_start="0x0" il_end="0x27" attributes="0"/>
            </scope>
        </method>
        <method token="0x6000013">
            <scope startOffset="0x0" endOffset="0x7">
                <importsforward token="0x600000a"/>
            </scope>
        </method>
        <method token="0x6000014">
            <scope startOffset="0x0" endOffset="0x7">
                <importsforward token="0x600000a"/>
                <local name="B" il_index="0" il_start="0x0" il_end="0x7" attributes="0"/>
            </scope>
        </method>
    </methods>
</symbols>)
        End Sub
    End Class
End Namespace
