#[derive(Default)]
pub struct IdTest {}

impl crate::Demo for IdTest {
    fn name(&self) -> &'static str {
        "ID Test"
    }

    fn show(&mut self, ctx: &egui::Context, open: &mut bool) {
        egui::Window::new(self.name()).open(open).show(ctx, |ui| {
            use crate::View as _;
            self.ui(ui);
        });
    }
}

impl crate::View for IdTest {
    fn ui(&mut self, ui: &mut egui::Ui) {
        // Make sure the warnings are on (by default they are only on in debug builds).
        ui.ctx().options_mut(|opt| opt.warn_on_id_clash = true);

        ui.heading("Name collision example");

        ui.label("\
            Widgets that store state require unique and persisting identifiers so we can track their state between frames.\n\
            For instance, collapsible headers needs to store whether or not they are open. \
            Their Id:s are derived from their names. \
            If you fail to give them unique names then clicking one will open both. \
            To help you debug this, an error message is printed on screen:");

        ui.collapsing("Collapsing header", |ui| {
            ui.label("Contents of first foldable ui");
        });
        ui.collapsing("Collapsing header", |ui| {
            ui.label("Contents of second foldable ui");
        });

        ui.label("\
            Any widget that can be interacted with also need a unique Id. \
            For most widgets the Id is generated by a running counter. \
            As long as elements are not added or removed, the Id stays the same. \
            This is fine, because during interaction (i.e. while dragging a slider), \
            the number of widgets previously in the same window is most likely not changing \
            (and if it is, the window will have a new layout, and the slider will end up somewhere else, and so aborting the interaction probably makes sense).");

        ui.label("So these buttons have automatic Id:s, and therefore there is no name clash:");
        let _ = ui.button("Button");
        let _ = ui.button("Button");

        ui.vertical_centered(|ui| {
            ui.add(crate::egui_github_link_file!());
        });
    }
}
