# What's New In v9.0

::: info Looking for the migration guide?
This article highlights some of the new features and improvements in v9. \
For details on migrating from v8 to v9, check out our [migration guide](https://v9.fakerjs.dev/guide/upgrading).
:::

## Optimizing Bundle Size with Tree-Shaking

In the v9 release of FakerJS, we've addressed an important issue related to bundle size. \
The problem? Unnecessary modules were being included during tree-shaking, leading to bloated final bundles. \
But fear not! We've implemented a solution.

The root issue was in how locale imports and exports were handled. \
Previously, the `allLocales` variable was defined using a named wildcard export (`export * as <name> from '<path>'`), which we've now refactored into a named variable export. \
Additionally, we updated the `package.json` file to specify `"sideEffects": false`, signaling to bundlers that all files in this package are side-effect-free and can be safely tree-shaken.

The results speak for themselves:

| Version | File Size |
| ------- | --------- |
| v8.4.1  | 2.77 MiB  |
| v9.0.0  | 438 KiB   |

This is a significant reduction by 84.5%!

## Use High Precision RNG by Default

In v9, we've switched from using a 32-bit random value to a 53-bit random value. \
While the underlying algorithm hasn't changed much, we now consume two seed values per step instead of one.
This affects generated values in two ways:

- **Improved distribution**: In large lists or long numbers, the values are more evenly spread, reducing the number of duplicates. For example, with `faker.number.int()`, the chance of duplicate values has dropped from `1 / 10,000` to less than `1 / 8,000,000`.
- **Subtle result differences**: If you start with the same initial seed, you may notice slight differences in generated values due to the higher precision. Additionally, since we now use two seed values per step, subsequent results may seem to skip a value each time.

Example:

```ts
import {
  SimpleFaker,
  generateMersenne32Randomizer,
  generateMersenne53Randomizer,
} from '@faker-js/faker';

// < v9 default
const oldFaker = new SimpleFaker({
  randomizer: generateMersenne32Randomizer(),
});
oldFaker.seed(123);
const oldValue = oldFaker.helpers.multiple(() => oldFaker.number.int(10), {
  count: 10,
});

// > v9 default
const newFaker = new SimpleFaker({
  randomizer: generateMersenne53Randomizer(),
});
newFaker.seed(123);
const newValue = newFaker.helpers.multiple(() => newFaker.number.int(10), {
  count: 5,
});

diff(oldValue, newValue);
// [
//   7,
//   7, // [!code --]
//   3,
//   4, // [!code --]
//   2,
//   7, // [!code --]
//   6,
//   7, // [!code --]
//   7,
//   5, // [!code --]
// ]
```

## New Modules

We are excited to introduce a new addition to FakerJS – the [FoodModule](https://v9.fakerjs.dev/api/food.html)! \
Whether you're building a restaurant app, a food blog, or just need some delicious data for testing, the Food Module has got you covered.
From spices to vegetables, meats, and fruits, you can generate a wide variety of ingredients to enrich your data or create engaging content with unique dish names and descriptions.
Whether you need a single ingredient or a full menu, the Food Module offers flexibility to meet your needs.

Additionally, the [MusicModule](https://v9.fakerjs.dev/api/music.html) now features two brand-new methods: `album()` and `artist()`.
These new methods provide detailed and diverse data, enhancing your music-related projects with even more variety.
Get the update and enjoy the latest tunes!

## Release Automation

As part of our ongoing effort to improve the release process for FakerJS, we've implemented the first steps towards an automated release pipeline. \
This new process improves efficiency, reduces manual errors, and ensures a smoother release cycle. In fact, this version was released using our new automated workflow.

The new process includes four key steps:

1. [Create a release Pull Request](https://github.com/faker-js/faker/pull/2981)
2. [Run an additional CI suite that tests against our playground](https://github.com/faker-js/faker/pull/2988)
3. [Draft a GitHub release](https://github.com/faker-js/faker/pull/2990)
4. [Publish the latest version to npm](https://github.com/faker-js/faker/pull/2991)

We can now initiate the process with a single manual trigger of the release preparation job.
The resulting PR runs additional CI tests (in parallel with our standard tests) against our [playground repo](https://github.com/faker-js/playground).
If the PR is successfully merged, another job automatically drafts a GitHub release.
This draft allows us to edit and highlight key changes.
Once the GitHub release is published, the final job automatically publishes the release to npm.
Previously, maintainers performed all these steps manually, often leading to missed steps or errors.

## Release Provenance

We now publish provenance for our npm releases, providing an additional layer of security and trust.
This provenance acts like a digital certificate, ensuring that the code has not been tampered with at any stage during the release process.

For example, it guarantees that no unauthorized changes were made to the code between tagging a version in the repository and publishing it on npm.
This safeguard enhances transparency and helps users verify the integrity of the code they are integrating into their projects.

For more details, you can refer to the [npm provenance documentation](https://docs.npmjs.com/generating-provenance-statements).
