import { execSync } from 'node:child_process';
import { writeFileSync } from 'node:fs';
import { resolve } from 'node:path';
import { formatTypescript } from '../utils/format';
import { FILE_PATH_API_DOCS } from '../utils/paths';
import { SCRIPT_COMMAND } from './constants';

const pathSourceBaseUrlFile = resolve(FILE_PATH_API_DOCS, 'source-base-url.ts');

/**
 * Writes the source base url to the correct location.
 */
export async function writeSourceBaseUrl(): Promise<void> {
  const baseUrl = getSourceBaseUrl();

  let content = `
  // This file is automatically generated.
  // Run '${SCRIPT_COMMAND}' to update
  export const sourceBaseUrl = '${baseUrl}';
  `.replace(/\n +/, '\n');

  content = await formatTypescript(content);

  writeFileSync(pathSourceBaseUrlFile, content);
}

function getSourceBaseUrl(): string {
  return `https://github.com/faker-js/faker/blob/${getCommitHash() || 'next'}/`;
}

function getCommitHash(): string | undefined {
  try {
    return execSync('git rev-parse --verify HEAD').toString('utf8').trim();
  } catch (error) {
    console.warn('Failed to get commit hash', error);
    return undefined;
  }
}
