import type { LocaleEntry } from './definitions';

/**
 * The possible definitions related to companies.
 */
export type CompanyDefinition = LocaleEntry<{
  /**
   * Business/products related adjectives that can be used to demonstrate data being viewed by a manager.
   */
  buzz_adjective: string[];

  /**
   * Business/products related nouns that can be used to demonstrate data being viewed by a manager.
   */
  buzz_noun: string[];

  /**
   * Business/products related verbs that can be used to demonstrate data being viewed by a manager.
   */
  buzz_verb: string[];

  /**
   * Catchphrase adjectives that can be displayed to an end user.
   */
  adjective: string[];

  /**
   * Catchphrase descriptors that can be displayed to an end user.
   */
  descriptor: string[];

  /**
   * A list of patterns used to generate company names.
   */
  name_pattern: string[];

  /**
   * Catchphrase nouns that can be displayed to an end user.
   */
  noun: string[];
}>;
