/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

using System;

namespace QuantConnect.Brokerages.InteractiveBrokers.Client
{
    /// <summary>
    /// Event arguments class for the <see cref="InteractiveBrokersClient.UpdateNewsBulletin"/> event
    /// </summary>
    public sealed class UpdateNewsBulletinEventArgs : EventArgs
    {
        /// <summary>
        /// The bulletin ID, incrementing for each new bulletin.
        /// </summary>
        public int MessageId { get; private set; }

        /// <summary>
        /// Specifies the type of bulletin.
        /// </summary>
        public int MessageType { get; private set; }

        /// <summary>
        /// The bulletin's message text.
        /// </summary>
        public string Message { get; private set; }

        /// <summary>
        /// The exchange from which this message originated.
        /// </summary>
        public string OriginalExchange { get; private set; }

        /// <summary>
        /// Initializes a new instance of the <see cref="UpdateNewsBulletinEventArgs"/> class
        /// </summary>
        public UpdateNewsBulletinEventArgs(int messageId, int messageType, string message, string originalExchange)
        {
            MessageId = messageId;
            MessageType = messageType;
            Message = message;
            OriginalExchange = originalExchange;
        }
    }
}