/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

//------------------------------------------------------------------------------
// This code was generated by a tool.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
//------------------------------------------------------------------------------

// To get up to date fundamental definition files for your hedgefund contact sales@quantconnect.com

using System;
using System.IO;
using Newtonsoft.Json;

namespace QuantConnect.Data.Fundamental
{
	/// <summary>
	/// Definition of the EarningRatios class
	/// </summary>
	public class EarningRatios : BaseData
	{
		/// <summary>
		/// The growth in the company's diluted earnings per share (EPS) on a percentage basis. Morningstar calculates the annualized growth
		/// percentage based on the underlying diluted EPS reported in the Income Statement within the company filings or reports.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 13015
		/// </remarks>
		[JsonProperty("13015")]
		public DilutedEPSGrowth DilutedEPSGrowth { get; set; }

		/// <summary>
		/// The growth in the company's diluted EPS from continuing operations on a percentage basis. Morningstar calculates the annualized
		/// growth percentage based on the underlying diluted EPS from continuing operations reported in the Income Statement within the
		/// company filings or reports.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 13016
		/// </remarks>
		[JsonProperty("13016")]
		public DilutedContEPSGrowth DilutedContEPSGrowth { get; set; }

		/// <summary>
		/// The growth in the company's dividends per share (DPS) on a percentage basis. Morningstar calculates the annualized growth
		/// percentage based on the underlying DPS from its dividend database.  Morningstar collects its DPS from company filings and
		/// reports, as well as from third party sources.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 13017
		/// </remarks>
		[JsonProperty("13017")]
		public DPSGrowth DPSGrowth { get; set; }

		/// <summary>
		/// The growth in the company's book value per share on a percentage basis. Morningstar calculates the annualized growth
		/// percentage based on the underlying equity and end of period shares outstanding reported in the company filings or reports.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 13018
		/// </remarks>
		[JsonProperty("13018")]
		public EquityPerShareGrowth EquityPerShareGrowth { get; set; }

		/// <summary>
		/// The five-year growth rate of dividends per share, calculated using regression analysis.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 13019
		/// </remarks>
		[JsonProperty("13019")]
		public RegressionGrowthofDividends5Years RegressionGrowthofDividends5Years { get; set; }

		/// <summary>
		/// Creates an instance of the EarningRatios class
		/// </summary>
		public EarningRatios()
		{
			DilutedEPSGrowth = new DilutedEPSGrowth();
			DilutedContEPSGrowth = new DilutedContEPSGrowth();
			DPSGrowth = new DPSGrowth();
			EquityPerShareGrowth = new EquityPerShareGrowth();
			RegressionGrowthofDividends5Years = new RegressionGrowthofDividends5Years();
		}

		/// <summary>
		/// Sets values for non existing periods from a previous instance
		/// </summary>
		/// <remarks>Used to fill-forward values from previous dates</remarks>
		/// <param name="previous">The previous instance</param>
		public void UpdateValues(EarningRatios previous)
		{
			if (previous == null) return;

			if (DilutedEPSGrowth != null) DilutedEPSGrowth.UpdateValues(previous.DilutedEPSGrowth);
			if (DilutedContEPSGrowth != null) DilutedContEPSGrowth.UpdateValues(previous.DilutedContEPSGrowth);
			if (DPSGrowth != null) DPSGrowth.UpdateValues(previous.DPSGrowth);
			if (EquityPerShareGrowth != null) EquityPerShareGrowth.UpdateValues(previous.EquityPerShareGrowth);
			if (RegressionGrowthofDividends5Years != null) RegressionGrowthofDividends5Years.UpdateValues(previous.RegressionGrowthofDividends5Years);
		}
	}
}
