/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

//------------------------------------------------------------------------------
// This code was generated by a tool.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
//------------------------------------------------------------------------------

// To get up to date fundamental definition files for your hedgefund contact sales@quantconnect.com

using System;
using Newtonsoft.Json;

namespace QuantConnect.Data.Fundamental
{
	/// <summary>
	/// Definition of the IncomeStatement class
	/// </summary>
	public class IncomeStatement
	{
		/// <summary>
		/// Used to reduce the value of intangible fixed assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20007
		/// </remarks>
		[JsonProperty("20007")]
		public AmortizationIncomeStatement Amortization { get; set; }

		/// <summary>
		/// The gradual elimination of a liability, such as a mortgage, in regular payments over a specified period of time. Such payments must
		/// be sufficient to cover both principal and interest.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20008
		/// </remarks>
		[JsonProperty("20008")]
		public SecuritiesAmortizationIncomeStatement SecuritiesAmortization { get; set; }

		/// <summary>
		/// The aggregate cost of goods produced and sold and services rendered during the reporting period. It excludes all operating
		/// expenses such as depreciation, depletion, amortization, and SG&amp;A. For the must have cost industry, if the number is not reported
		/// by the company, it will be calculated based on accounting equation.
		/// Cost of Revenue = Revenue - Operating Expenses - Operating Profit.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20013
		/// </remarks>
		[JsonProperty("20013")]
		public CostOfRevenueIncomeStatement CostOfRevenue { get; set; }

		/// <summary>
		/// Any cumulative gains or losses from change in accounting principles. A change in accounting principle constitutes a change from
		/// one generally accepted accounting principle to another generally accepted accounting principle. This may also include a change in
		/// the method of applying an accounting principle, such as depreciation or inventory methods.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20016
		/// </remarks>
		[JsonProperty("20016")]
		public CumulativeEffectOfAccountingChangeIncomeStatement CumulativeEffectOfAccountingChange { get; set; }

		/// <summary>
		/// Used to reduce the value of natural resource.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20017
		/// </remarks>
		[JsonProperty("20017")]
		public DepletionIncomeStatement Depletion { get; set; }

		/// <summary>
		/// Used to reduce the value of tangible fixed assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20018
		/// </remarks>
		[JsonProperty("20018")]
		public DepreciationIncomeStatement Depreciation { get; set; }

		/// <summary>
		/// The current period expense charged against earnings on long-lived, physical assets used in the normal conduct of business and not
		/// intended for resale to allocate or recognize the cost of assets over their useful lives; or to record the reduction in book value of an
		/// intangible asset over the benefit period of such asset. Examples include buildings, production and equipment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20019
		/// </remarks>
		[JsonProperty("20019")]
		public DepreciationAndAmortizationIncomeStatement DepreciationAndAmortization { get; set; }

		/// <summary>
		/// It is a non-cash charge that represents a reduction in the value of fixed assets due to wear, age, or obsolescence. This figure also
		/// includes amortization of leased property, intangibles, and goodwill, and depletion.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20020
		/// </remarks>
		[JsonProperty("20020")]
		public DepreciationAmortizationDepletionIncomeStatement DepreciationAmortizationDepletion { get; set; }

		/// <summary>
		/// To be classified as discontinued operations, if both of the following conditions are met:
		/// 1: The operations and cash flow of the component have been or will be removed from the ongoing operations of the entity as a
		/// result of the disposal transaction, and
		/// 2: The entity will have no significant continuing involvement in the operations of the component after the disposal transaction.
		/// The discontinued operation is reported net of tax.
		/// Gains/Loss on Disposal of Discontinued Operations: Any gains or loss recognized on disposal of discontinued operations,
		/// which is the difference between the carrying value of the division and its fair value less costs to sell.
		/// Provision for Gain/Loss on Disposal: The amount of current expense charged in order to prepare for the disposal of
		/// discontinued operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20022
		/// </remarks>
		[JsonProperty("20022")]
		public NetIncomeDiscontinuousOperationsIncomeStatement NetIncomeDiscontinuousOperations { get; set; }

		/// <summary>
		/// Excise taxes are taxes paid when purchases are made on a specific good, such as gasoline. Excise taxes are often included in the
		/// price of the product. There are also excise taxes on activities, such as on wagering or on highway usage by trucks.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20028
		/// </remarks>
		[JsonProperty("20028")]
		public ExciseTaxesIncomeStatement ExciseTaxes { get; set; }

		/// <summary>
		/// Gains (losses), whether arising from extinguishment of debt, prior period adjustments, or from other events or transactions, that are
		/// both unusual in nature and infrequent in occurrence thereby meeting the criteria for an event or transaction to be classified as an
		/// extraordinary item.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20030
		/// </remarks>
		[JsonProperty("20030")]
		public NetIncomeExtraordinaryIncomeStatement NetIncomeExtraordinary { get; set; }

		/// <summary>
		/// The aggregate amount of fees, commissions, and other income.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20031
		/// </remarks>
		[JsonProperty("20031")]
		public FeeRevenueAndOtherIncomeIncomeStatement FeeRevenueAndOtherIncome { get; set; }

		/// <summary>
		/// The aggregate total of general managing and administering expenses for the company.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20045
		/// </remarks>
		[JsonProperty("20045")]
		public GeneralAndAdministrativeExpenseIncomeStatement GeneralAndAdministrativeExpense { get; set; }

		/// <summary>
		/// Total revenue less cost of revenue. The number is as reported by the company on the income statement; however, the number will
		/// be calculated if it is not reported. This field is null if the cost of revenue is not given.
		/// Gross Profit = Total Revenue - Cost of Revenue.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20046
		/// </remarks>
		[JsonProperty("20046")]
		public GrossProfitIncomeStatement GrossProfit { get; set; }

		/// <summary>
		/// Relates to the general cost of borrowing money. It is the price that a lender charges a borrower for the use of the lender's money.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20057
		/// </remarks>
		[JsonProperty("20057")]
		public InterestExpenseIncomeStatement InterestExpense { get; set; }

		/// <summary>
		/// Interest expense caused by long term financing activities; such as interest expense incurred on trading liabilities, commercial paper,
		/// long-term debt, capital leases, deposits, and all other borrowings.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20064
		/// </remarks>
		[JsonProperty("20064")]
		public InterestExpenseNonOperatingIncomeStatement InterestExpenseNonOperating { get; set; }

		/// <summary>
		/// Interest expense caused by normal operating activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20065
		/// </remarks>
		[JsonProperty("20065")]
		public InterestExpenseOperatingIncomeStatement InterestExpenseOperating { get; set; }

		/// <summary>
		/// Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums,
		/// including consideration of the provisions for loan, lease, credit, and other related losses, if any.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20066
		/// </remarks>
		[JsonProperty("20066")]
		public InterestIncomeAfterProvisionForLoanLossIncomeStatement InterestIncomeAfterProvisionForLoanLoss { get; set; }

		/// <summary>
		/// Interest income earned from long term financing activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20075
		/// </remarks>
		[JsonProperty("20075")]
		public InterestIncomeNonOperatingIncomeStatement InterestIncomeNonOperating { get; set; }

		/// <summary>
		/// Interest income earned by normal operating activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20076
		/// </remarks>
		[JsonProperty("20076")]
		public InterestIncomeOperatingIncomeStatement InterestIncomeOperating { get; set; }

		/// <summary>
		/// Net-Non Operating interest income or expenses caused by financing activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20077
		/// </remarks>
		[JsonProperty("20077")]
		public NetNonOperatingInterestIncomeExpenseIncomeStatement NetNonOperatingInterestIncomeExpense { get; set; }

		/// <summary>
		/// Net operating interest income or expense caused by normal operating activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20078
		/// </remarks>
		[JsonProperty("20078")]
		public NetOperatingInterestIncomeExpenseIncomeStatement NetOperatingInterestIncomeExpense { get; set; }

		/// <summary>
		/// Losses generally refer to (1) the amount of reduction in the value of an insured's property caused by an insured peril, (2) the amount
		/// sought through an insured's claim, or (3) the amount paid on behalf of an insured under an insurance contract.  Loss Adjustment
		/// Expenses is expenses incurred in the course of investigating and settling claims that includes any legal and adjusters' fees and the
		/// costs of paying claims and all related expenses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20084
		/// </remarks>
		[JsonProperty("20084")]
		public LossAdjustmentExpenseIncomeStatement LossAdjustmentExpense { get; set; }

		/// <summary>
		/// Represents par or stated value of the subsidiary stock not owned by the parent company plus the minority interest's equity in the
		/// surplus of the subsidiary. This item includes preferred dividend averages on the minority preferred stock (preferred shares not
		/// owned by the reporting parent company). Minority interest also refers to stockholders who own less than 50% of a subsidiary's
		/// outstanding voting common stock. The minority stockholders hold an interest in the subsidiary's net assets and share earnings with
		/// the parent company.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20087
		/// </remarks>
		[JsonProperty("20087")]
		public MinorityInterestsIncomeStatement MinorityInterests { get; set; }

		/// <summary>
		/// Includes all the operations (continuing and discontinued) and all the other income or charges (extraordinary, accounting changes,
		/// tax loss carry forward, and other gains and losses).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20091
		/// </remarks>
		[JsonProperty("20091")]
		public NetIncomeIncomeStatement NetIncome { get; set; }

		/// <summary>
		/// Net income minus the preferred dividends paid as presented in the Income Statement.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20093
		/// </remarks>
		[JsonProperty("20093")]
		public NetIncomeCommonStockholdersIncomeStatement NetIncomeCommonStockholders { get; set; }

		/// <summary>
		/// Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from: Preferred Dividends;
		/// Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax
		/// Loss Carry forward; Other Gains/Losses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20094
		/// </remarks>
		[JsonProperty("20094")]
		public NetIncomeContinuousOperationsIncomeStatement NetIncomeContinuousOperations { get; set; }

		/// <summary>
		/// Total interest income minus total interest expense. It represents the difference between interest and dividends earned on interest-
		/// bearing assets and interest paid to depositors and other creditors.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20095
		/// </remarks>
		[JsonProperty("20095")]
		public NetInterestIncomeIncomeStatement NetInterestIncome { get; set; }

		/// <summary>
		/// Total of interest, dividends, and other earnings derived from the insurance company's invested assets minus the expenses
		/// associated with these investments. Excluded from this income are capital gains or losses as the result of the sale of assets, as well
		/// as any unrealized capital gains or losses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20096
		/// </remarks>
		[JsonProperty("20096")]
		public NetInvestmentIncomeIncomeStatement NetInvestmentIncome { get; set; }

		/// <summary>
		/// All revenues, sales and income that the company deems as a total sum of all of their income as reported in the company's income
		/// statement.
		/// Bank:  Total Revenue = Net Interest Income + Non-Interest Income.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20100
		/// </remarks>
		[JsonProperty("20100")]
		public TotalRevenueIncomeStatement TotalRevenue { get; set; }

		/// <summary>
		/// Any expenses that not related to interest. It includes labor and related expense, occupancy and equipment, commission,
		/// professional expense and contract services expenses, selling, general and administrative, research and development depreciation,
		/// amortization and depletion, and any other special income/charges.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20105
		/// </remarks>
		[JsonProperty("20105")]
		public NonInterestExpenseIncomeStatement NonInterestExpense { get; set; }

		/// <summary>
		/// The total amount of non-interest income which may be derived from: (1) fees and commissions; (2) premiums earned; (3) equity
		/// investment; (4) the sale or disposal of assets; and (5) other sources not otherwise
		/// specified.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20106
		/// </remarks>
		[JsonProperty("20106")]
		public NonInterestIncomeIncomeStatement NonInterestIncome { get; set; }

		/// <summary>
		/// Operating expenses are primary recurring costs associated with central operations (other than cost of goods sold) that are incurred
		/// in order to generate sales.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20108
		/// </remarks>
		[JsonProperty("20108")]
		public OperatingExpenseIncomeStatement OperatingExpense { get; set; }

		/// <summary>
		/// Income from normal business operations after deducting cost of revenue and operating expenses. It does not include income from
		/// any investing activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20109
		/// </remarks>
		[JsonProperty("20109")]
		public OperatingIncomeIncomeStatement OperatingIncome { get; set; }

		/// <summary>
		/// The operating revenue for transportation industry can be divided into three parts: revenue-passenger, revenue-cargo, and other
		/// operating revenue.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20112
		/// </remarks>
		[JsonProperty("20112")]
		public OperatingRevenueIncomeStatement OperatingRevenue { get; set; }

		/// <summary>
		/// Income or expense that comes from miscellaneous sources.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20117
		/// </remarks>
		[JsonProperty("20117")]
		public OtherIncomeExpenseIncomeStatement OtherIncomeExpense { get; set; }

		/// <summary>
		/// Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as
		/// underwriting expenses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20125
		/// </remarks>
		[JsonProperty("20125")]
		public PolicyAcquisitionExpenseIncomeStatement PolicyAcquisitionExpense { get; set; }

		/// <summary>
		/// The net provision in current period for future policy benefits, claims, and claims settlement expenses incurred in the claims
		/// settlement process before the effects of reinsurance arrangements. The value is net of the effects of contracts assumed and
		/// ceded.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20129
		/// </remarks>
		[JsonProperty("20129")]
		public NetPolicyholderBenefitsAndClaimsIncomeStatement NetPolicyholderBenefitsAndClaims { get; set; }

		/// <summary>
		/// The amount of dividends declared or paid in the period to preferred shareholders, or the amount for which the obligation to pay
		/// them dividends arose in the period. Preferred dividends are the amount required for the current year only, and not for any amount
		/// required in past years.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20134
		/// </remarks>
		[JsonProperty("20134")]
		public PreferredStockDividendsIncomeStatement PreferredStockDividends { get; set; }

		/// <summary>
		/// Premiums earned is the portion of an insurance written premium which is considered "earned" by the insurer, based on the part of
		/// the policy period that the insurance has been in effect, and during which the insurer has been exposed to loss.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20135
		/// </remarks>
		[JsonProperty("20135")]
		public TotalPremiumsEarnedIncomeStatement TotalPremiumsEarned { get; set; }

		/// <summary>
		/// Reported income before the deduction or benefit of income taxes.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20136
		/// </remarks>
		[JsonProperty("20136")]
		public PretaxIncomeIncomeStatement PretaxIncome { get; set; }

		/// <summary>
		/// Include any taxes on income, net of any investment tax credits for the current accounting period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20145
		/// </remarks>
		[JsonProperty("20145")]
		public TaxProvisionIncomeStatement TaxProvision { get; set; }

		/// <summary>
		/// A charge to income which represents an expense deemed adequate by management given the composition of a bank's credit
		/// portfolios, their probability of default, the economic environment and the allowance for credit losses already established. Specific
		/// provisions are established to reduce the book value of specific assets (primarily loans) to establish the amount expected to be
		/// recovered on the loans.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20146
		/// </remarks>
		[JsonProperty("20146")]
		public CreditLossesProvisionIncomeStatement CreditLossesProvision { get; set; }

		/// <summary>
		/// The aggregate amount of research and development expenses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20151
		/// </remarks>
		[JsonProperty("20151")]
		public ResearchAndDevelopmentIncomeStatement ResearchAndDevelopment { get; set; }

		/// <summary>
		/// The aggregate total amount of expenses directly related to the marketing or selling of products or services.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20158
		/// </remarks>
		[JsonProperty("20158")]
		public SellingAndMarketingExpenseIncomeStatement SellingAndMarketingExpense { get; set; }

		/// <summary>
		/// The aggregate total costs related to selling a firm's product and services, as well as all other general and administrative expenses.
		/// Selling expenses are those directly related to the company's efforts to generate sales (e.g., sales salaries, commissions,
		/// advertising, delivery expenses). General and administrative expenses are expenses related to general administration of the
		/// company's operation (e.g., officers and office salaries, office supplies, telephone, accounting and legal services, and business
		/// licenses and fees).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20159
		/// </remarks>
		[JsonProperty("20159")]
		public SellingGeneralAndAdministrationIncomeStatement SellingGeneralAndAdministration { get; set; }

		/// <summary>
		/// Earnings or losses attributable to occurrences or actions by the firm that is either infrequent or unusual.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20162
		/// </remarks>
		[JsonProperty("20162")]
		public SpecialIncomeChargesIncomeStatement SpecialIncomeCharges { get; set; }

		/// <summary>
		/// The sum of operating expense and cost of revenue. If the company does not give the reported number, it will be calculated by
		/// adding operating expense and cost of revenue.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20164
		/// </remarks>
		[JsonProperty("20164")]
		public TotalExpensesIncomeStatement TotalExpenses { get; set; }

		/// <summary>
		/// Financial Accounting Standard (FAS) requires that expenses associated with the sale or acquisition of an insurance policy should be
		/// deferred to future periods to match the premium income stream from that policy over its lifetime. Hence, the acquisition costs
		/// incurred in the year of sale is capitalized in order to create the deferred acquisition costs asset and be amortized over the life of the
		/// policy.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20176
		/// </remarks>
		[JsonProperty("20176")]
		public AmortizationOfDeferredAcquisitionCostsIncomeStatement AmortizationOfDeferredAcquisitionCosts { get; set; }

		/// <summary>
		/// Income generated from interest-bearing deposits or accounts.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20177
		/// </remarks>
		[JsonProperty("20177")]
		public InterestIncomeIncomeStatement InterestIncome { get; set; }

		/// <summary>
		/// The claims made under the liability insurance in order to protect the assets of a business when it is caused by an injury or damage.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20186
		/// </remarks>
		[JsonProperty("20186")]
		public PropertyLiabilityInsuranceClaimsIncomeStatement PropertyLiabilityInsuranceClaims { get; set; }

		/// <summary>
		/// Earnings minus expenses (excluding interest and tax expenses).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20189
		/// </remarks>
		[JsonProperty("20189")]
		public EBITIncomeStatement EBIT { get; set; }

		/// <summary>
		/// Earnings minus expenses (excluding interest, tax, depreciation, and amortization expenses).
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20190
		/// </remarks>
		[JsonProperty("20190")]
		public EBITDAIncomeStatement EBITDA { get; set; }

		/// <summary>
		/// Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
		/// Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
		/// Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20191
		/// </remarks>
		[JsonProperty("20191")]
		public NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement NetIncomeContinuousOperationsNetMinorityInterest { get; set; }

		/// <summary>
		/// Two situations may lead to accretion on a preferred stock - accretion related redemption premium and interest-like returns on
		/// accrued, but unpaid dividends that accumulated from accumulated preferred stock.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20192
		/// </remarks>
		[JsonProperty("20192")]
		public AccretionOnPreferredStockIncomeStatement AccretionOnPreferredStock { get; set; }

		/// <summary>
		/// An accrued preferred stock dividend is remuneration owed by a company to its preferred stock holders. Forms of accrued preferred
		/// stock dividends can be either cash or additional shares of preferred stock.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20193
		/// </remarks>
		[JsonProperty("20193")]
		public AccruedPreferredStockDividendsIncomeStatement AccruedPreferredStockDividends { get; set; }

		/// <summary>
		/// In-process research and development that is acquired through a merger or acquisition during the period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20194
		/// </remarks>
		[JsonProperty("20194")]
		public AcquiredInProcessRnDIncomeStatement AcquiredInProcessRnD { get; set; }

		/// <summary>
		/// Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as
		/// underwriting expenses. This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20195
		/// </remarks>
		[JsonProperty("20195")]
		public AcquisitionExpenseIncomeStatement AcquisitionExpense { get; set; }

		/// <summary>
		/// The expenses that an organization incurs not directly tied to a specific function such as manufacturing/production or sales. These
		/// expenses are related to the organization as a whole as opposed to an individual department
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20196
		/// </remarks>
		[JsonProperty("20196")]
		public AdministrativeExpenseIncomeStatement AdministrativeExpense { get; set; }

		/// <summary>
		/// Fees earned during the period for providing insurance service as an agent. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20197
		/// </remarks>
		[JsonProperty("20197")]
		public AgencyFeesIncomeStatement AgencyFees { get; set; }

		/// <summary>
		/// Total agency fees and commissions collected by the insurance company as a part of revenue. This item is usually only available for
		/// insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20198
		/// </remarks>
		[JsonProperty("20198")]
		public AgencyFeesAndCommissionsIncomeStatement AgencyFeesAndCommissions { get; set; }

		/// <summary>
		/// The establishment of allowances in construction contracts is a convenient method of allocating construction funds to portions of
		/// the work that cannot be specified with sufficient particularity for competitive bidding at the time of contracting. This item is usually
		/// not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20199
		/// </remarks>
		[JsonProperty("20199")]
		public AllowancesForConstructionIncomeStatement AllowancesForConstruction { get; set; }

		/// <summary>
		/// A tax imposed in some countries on the severance and production of coal, oil or gas from the earth or water for sale, transport,
		/// storage, profit or commercial use. Exemptions from the tax are provided for specific circumstances. This item is usually only
		/// available for mining industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20200
		/// </remarks>
		[JsonProperty("20200")]
		public CapitalnBusinessTaxesIncomeStatement CapitalnBusinessTaxes { get; set; }

		/// <summary>
		/// The amount of premiums paid and payable to another insurer as a result of reinsurance arrangements in order to exchange for that
		/// company accepting all or part of insurance on a risk or exposure. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20201
		/// </remarks>
		[JsonProperty("20201")]
		public CededPremiumsIncomeStatement CededPremiums { get; set; }

		/// <summary>
		/// Fees paid to another entity or agent based on commission contracts.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20202
		/// </remarks>
		[JsonProperty("20202")]
		public CommissionExpensesIncomeStatement CommissionExpenses { get; set; }

		/// <summary>
		/// The service charge by the insurance company in return for providing advice and handling investment. This item is usually only
		/// available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20203
		/// </remarks>
		[JsonProperty("20203")]
		public CommissionRevenueIncomeStatement CommissionRevenue { get; set; }

		/// <summary>
		/// Income earned from credit card services including late, over limit, and annual fees. This item is usually only available for bank
		/// industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20204
		/// </remarks>
		[JsonProperty("20204")]
		public CreditCardIncomeStatement CreditCard { get; set; }

		/// <summary>
		/// The costs associated with transitioning research to a commercially useful and marketable stage.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20205
		/// </remarks>
		[JsonProperty("20205")]
		public DevelopmentExpenseIncomeStatement DevelopmentExpense { get; set; }

		/// <summary>
		/// Dividends earned from equity investment securities. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20206
		/// </remarks>
		[JsonProperty("20206")]
		public DividendIncomeIncomeStatement DividendIncome { get; set; }

		/// <summary>
		/// The earning or loss resulting from the proportional part of the associated company's net income. This item is usually only available
		/// for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20207
		/// </remarks>
		[JsonProperty("20207")]
		public EarningLossOfEquityInvestmentsIncomeStatement EarningLossOfEquityInvestments { get; set; }

		/// <summary>
		/// The earnings from equity interest can be a result of any of the following: Income from earnings distribution of the business, either
		/// as dividends paid to corporate shareholders or as drawings in a partnership; Capital gain realized upon sale of the business; Capital
		/// gain realized from selling his or her interest to other partners. This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20208
		/// </remarks>
		[JsonProperty("20208")]
		public EarningsFromEquityInterestIncomeStatement EarningsFromEquityInterest { get; set; }

		/// <summary>
		/// Revenue from operations of public electric power supply systems, such as sale of electricity to residential, commercial, and
		/// industrial customers (including electricity for resale by other private or public electric utilities). This item is usually only available for
		/// utility industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20209
		/// </remarks>
		[JsonProperty("20209")]
		public ElectricRevenueIncomeStatement ElectricRevenue { get; set; }

		/// <summary>
		/// Equipment expenses include depreciation, repairs, rentals, and service contract costs. This also includes equipment purchases
		/// which do not qualify for capitalization in accordance with the entity's accounting policy. This item may also include furniture
		/// expenses. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20210
		/// </remarks>
		[JsonProperty("20210")]
		public EquipmentIncomeStatement Equipment { get; set; }

		/// <summary>
		/// Costs incurred in identifying areas that may warrant examination and in examining specific areas that are considered to have
		/// prospects of containing energy or metal reserves, including costs of drilling exploratory wells. Development expense is the
		/// capitalized costs incurred to obtain access to proved reserves and to provide facilities for extracting, treating, gathering and storing
		/// the energy and metal. Mineral property includes oil and gas wells, mines, and other natural deposits (including geothermal
		/// deposits). The payment for leasing those properties is called mineral property lease expense. Exploration expense is included in
		/// operation expenses for mining industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20211
		/// </remarks>
		[JsonProperty("20211")]
		public ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement ExplorationDevelopmentAndMineralPropertyLeaseExpenses { get; set; }

		/// <summary>
		/// Total fees earned from providing services. This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20212
		/// </remarks>
		[JsonProperty("20212")]
		public FeesIncomeStatement Fees { get; set; }

		/// <summary>
		/// Total fees and commissions earned from providing services such as leasing of space or maintaining: (1) depositor accounts; (2)
		/// transfer agent; (3) fiduciary and trust; (4) brokerage and underwriting; (5) mortgage; (6) credit cards; (7) correspondent clearing;
		/// and (8) other such services and activities performed for others. This item is usually available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20213
		/// </remarks>
		[JsonProperty("20213")]
		public FeesAndCommissionsIncomeStatement FeesAndCommissions { get; set; }

		/// <summary>
		/// Trading revenues that result from foreign exchange exposures such as cash instruments and off-balance sheet derivative
		/// instruments. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20214
		/// </remarks>
		[JsonProperty("20214")]
		public ForeignExchangeTradingGainsIncomeStatement ForeignExchangeTradingGains { get; set; }

		/// <summary>
		/// The aggregate amount of fuel cost for current period associated with the revenue generation. This item is usually only available for
		/// transportation industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20215
		/// </remarks>
		[JsonProperty("20215")]
		public FuelIncomeStatement Fuel { get; set; }

		/// <summary>
		/// Cost of fuel, purchase power and gas associated with revenue generation. This item is usually only available for utility industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20216
		/// </remarks>
		[JsonProperty("20216")]
		public FuelAndPurchasePowerIncomeStatement FuelAndPurchasePower { get; set; }

		/// <summary>
		/// The amount of excess earned in comparison to fair value when selling a business. This item is usually not available for insurance
		/// industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20217
		/// </remarks>
		[JsonProperty("20217")]
		public GainOnSaleOfBusinessIncomeStatement GainOnSaleOfBusiness { get; set; }

		/// <summary>
		/// The amount of excess earned in comparison to the net book value for sale of property, plant, equipment. This item is usually not
		/// available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20218
		/// </remarks>
		[JsonProperty("20218")]
		public GainOnSaleOfPPEIncomeStatement GainOnSaleOfPPE { get; set; }

		/// <summary>
		/// The amount of excess earned in comparison to the original purchase value of the security.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20219
		/// </remarks>
		[JsonProperty("20219")]
		public GainOnSaleOfSecurityIncomeStatement GainOnSaleOfSecurity { get; set; }

		/// <summary>
		/// Any gain or loss recognized on disposal of discontinued operations, which is the difference between the carrying value of the
		/// division and its fair value less costs to sell.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20220
		/// </remarks>
		[JsonProperty("20220")]
		public GainsLossOnDisposalOfDiscontinuedOperationsIncomeStatement GainsLossOnDisposalOfDiscontinuedOperations { get; set; }

		/// <summary>
		/// Revenue from operations of public gas supply systems, such as sale of natural gas to residential, commercial, and industrial
		/// customers (including natural gas for resale by other private or public gas supply utilities); connection fees; and other operations
		/// revenues. This item is usually only available for utility industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20221
		/// </remarks>
		[JsonProperty("20221")]
		public GasRevenueIncomeStatement GasRevenue { get; set; }

		/// <summary>
		/// An undivided investment account in which insurers maintain funds that support contractual obligations for guaranteed insurance
		/// products such as whole life insurance or fixed-rate annuities. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20222
		/// </remarks>
		[JsonProperty("20222")]
		public GeneralAccountAssetsIncomeStatement GeneralAccountAssets { get; set; }

		/// <summary>
		/// Expense incurred for operations other than selling, administrative, or cost of goods sold
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20223
		/// </remarks>
		[JsonProperty("20223")]
		public GeneralExpenseIncomeStatement GeneralExpense { get; set; }

		/// <summary>
		/// Total premiums generated from all policies written by an insurance company within a given period of time. This item is usually only
		/// available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20224
		/// </remarks>
		[JsonProperty("20224")]
		public GrossPremiumsWrittenIncomeStatement GrossPremiumsWritten { get; set; }

		/// <summary>
		/// Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future
		/// cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written
		/// down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the
		/// company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of
		/// discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future
		/// profit collection ability.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20225
		/// </remarks>
		[JsonProperty("20225")]
		public ImpairmentOfCapitalAssetsIncomeStatement ImpairmentOfCapitalAssets { get; set; }

		/// <summary>
		/// Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future
		/// cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written
		/// down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the
		/// company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of
		/// discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future
		/// profit collection ability; This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20226
		/// </remarks>
		[JsonProperty("20226")]
		public OtherImpairmentOfCapitalAssetsIncomeStatement OtherImpairmentOfCapitalAssets { get; set; }

		/// <summary>
		/// Company will report the income earned on the investment on its income statement and the reported value is based on the firm's
		/// share of the company assets. The reported profit is proportional to the size of the equity investment. This is the standard technique
		/// used when one company has significant influence over another.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20227
		/// </remarks>
		[JsonProperty("20227")]
		public IncomeFromEquityMethodInvestmentsIncomeStatement IncomeFromEquityMethodInvestments { get; set; }

		/// <summary>
		/// The in-process research and development acquired through a merger or acquisition during the period, which is related to non-
		/// operating activity. This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20228
		/// </remarks>
		[JsonProperty("20228")]
		public AcquiredInProcessRnDIncomeIncomeStatement AcquiredInProcessRnDIncome { get; set; }

		/// <summary>
		/// Income related to restructuring, merger, or acquisitions. This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20229
		/// </remarks>
		[JsonProperty("20229")]
		public RestructringAndMnAIncomeIncomeStatement RestructringAndMnAIncome { get; set; }

		/// <summary>
		/// Premium might contain a portion of the amount that has been paid in advance for insurance that has not yet been provided, which
		/// is called unearned premium. If either party cancels the contract, the insurer must have the unearned premium ready to refund.
		/// Hence, the amount of premium reserve maintained by insurers is called unearned premium reserves, which is prepared for
		/// liquidation.  This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20230
		/// </remarks>
		[JsonProperty("20230")]
		public IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement IncreaseDecreaseInNetUnearnedPremiumReserves { get; set; }

		/// <summary>
		/// Insurance and claims are the expenses in the period incurred with respect to protection provided by insurance entities against risks
		/// other than risks associated with production (which is allocated to cost of sales). This item is usually not available for insurance
		/// industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20231
		/// </remarks>
		[JsonProperty("20231")]
		public InsuranceAndClaimsIncomeStatement InsuranceAndClaims { get; set; }

		/// <summary>
		/// Premiums and Income / Loss from Insurance Activities
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20232
		/// </remarks>
		[JsonProperty("20232")]
		public InsuranceAndPremiumsIncomeStatement InsuranceAndPremiums { get; set; }

		/// <summary>
		/// This includes Checking account; Savings account; Deposit in foreign offices; Money Market Certificates &amp; Deposit Accounts. This
		/// item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20233
		/// </remarks>
		[JsonProperty("20233")]
		public InterestIncomeFromInterestBearingDepositsIncomeStatement InterestIncomeFromInterestBearingDeposits { get; set; }

		/// <summary>
		/// Aggregate interest expenses incurred on long-term capital lease obligation. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20234
		/// </remarks>
		[JsonProperty("20234")]
		public InterestExpenseForCapitalizedLeaseObligationsIncomeStatement InterestExpenseForCapitalizedLeaseObligations { get; set; }

		/// <summary>
		/// Includes interest expense on the following deposit accounts: Interest-bearing Demand deposit; Checking account; Savings account;
		/// Deposit in foreign offices; Money Market Certificates &amp; Deposit Accounts. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20235
		/// </remarks>
		[JsonProperty("20235")]
		public InterestExpenseForDepositIncomeStatement InterestExpenseForDeposit { get; set; }

		/// <summary>
		/// Gross expenses on the purchase of Federal funds at a specified price with a simultaneous agreement to sell the same to the same
		/// counterparty at a fixed or determinable price at a future date. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20236
		/// </remarks>
		[JsonProperty("20236")]
		public InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell { get; set; }

		/// <summary>
		/// The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant,
		/// equipment) that are leased for more than one year. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20237
		/// </remarks>
		[JsonProperty("20237")]
		public InterestExpenseForLongTermDebtIncomeStatement InterestExpenseForLongTermDebt { get; set; }

		/// <summary>
		/// The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant,
		/// equipment) that are leased due longer than one year. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20238
		/// </remarks>
		[JsonProperty("20238")]
		public InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement InterestExpenseForLongTermDebtAndCapitalSecurities { get; set; }

		/// <summary>
		/// The aggregate interest expenses incurred on short-term borrowings and any interest expenses on fixed assets (property, plant,
		/// equipment) that are leased within one year. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20239
		/// </remarks>
		[JsonProperty("20239")]
		public InterestExpenseForShortTermDebtIncomeStatement InterestExpenseForShortTermDebt { get; set; }

		/// <summary>
		/// Interest income generated from all deposit accounts. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20240
		/// </remarks>
		[JsonProperty("20240")]
		public InterestIncomeFromDepositsIncomeStatement InterestIncomeFromDeposits { get; set; }

		/// <summary>
		/// The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
		/// resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll.
		/// Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all
		/// interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all
		/// interest income generated from federal funds sold and securities purchases under agreements to resell.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20241
		/// </remarks>
		[JsonProperty("20241")]
		public InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell { get; set; }

		/// <summary>
		/// Includes any interest and dividends on investment securities that are not part of money market investments. This item is usually
		/// only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20242
		/// </remarks>
		[JsonProperty("20242")]
		public InterestIncomeFromInvestmentSecuritiesIncomeStatement InterestIncomeFromInvestmentSecurities { get; set; }

		/// <summary>
		/// Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20243
		/// </remarks>
		[JsonProperty("20243")]
		public InterestIncomeFromLeasesIncomeStatement InterestIncomeFromLeases { get; set; }

		/// <summary>
		/// Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes
		/// Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks
		/// earn interest from loans. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20244
		/// </remarks>
		[JsonProperty("20244")]
		public InterestIncomeFromLoansIncomeStatement InterestIncomeFromLoans { get; set; }

		/// <summary>
		/// Total interest and fee income generated by loans and lease. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20245
		/// </remarks>
		[JsonProperty("20245")]
		public InterestIncomeFromLoansAndLeaseIncomeStatement InterestIncomeFromLoansAndLease { get; set; }

		/// <summary>
		/// Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations,
		/// securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities
		/// (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only
		/// available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20246
		/// </remarks>
		[JsonProperty("20246")]
		public InterestIncomeFromSecuritiesIncomeStatement InterestIncomeFromSecurities { get; set; }

		/// <summary>
		/// Interest income from assets held in trading accounts. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20247
		/// </remarks>
		[JsonProperty("20247")]
		public InterestIncomeFromTradingAccountSecuritiesIncomeStatement InterestIncomeFromTradingAccountSecurities { get; set; }

		/// <summary>
		/// Includes (1) underwriting revenue (the spread between the resale price received and the cost of the securities and related
		/// expenses) generated through the purchasing, distributing and reselling of new issues of securities (alternatively, could be a
		/// secondary offering of a large block of previously issued securities); and (2) fees earned for mergers, acquisitions, divestitures,
		/// restructurings, and other types of financial advisory services. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20248
		/// </remarks>
		[JsonProperty("20248")]
		public InvestmentBankingProfitIncomeStatement InvestmentBankingProfit { get; set; }

		/// <summary>
		/// Premiums earned from life and annuity insurance. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20249
		/// </remarks>
		[JsonProperty("20249")]
		public LifeAnnuityPremiumsIncomeStatement LifeAnnuityPremiums { get; set; }

		/// <summary>
		/// Includes the loans that the bank is going to sell at a discount. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20250
		/// </remarks>
		[JsonProperty("20250")]
		public LoansHeldForResellIncomeStatement LoansHeldForResell { get; set; }

		/// <summary>
		/// Expenses incurred in the course of investigating and settling claims. This item is usually not available for bank and insurance
		/// industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20251
		/// </remarks>
		[JsonProperty("20251")]
		public LossAndLossAdjustmentExpectedIncurredIncomeStatement LossAndLossAdjustmentExpectedIncurred { get; set; }

		/// <summary>
		/// The aggregate amount of maintenance and repair expenses in the current period associated with the revenue generation. Mainly
		/// for fixed assets. This item is usually only available for transportation industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20252
		/// </remarks>
		[JsonProperty("20252")]
		public MaintenanceAndRepairsIncomeStatement MaintenanceAndRepairs { get; set; }

		/// <summary>
		/// Expenditures for planning and executing the conception, pricing, promotion, and distribution of ideas, goods, and services.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20253
		/// </remarks>
		[JsonProperty("20253")]
		public MarketingExpenseIncomeStatement MarketingExpense { get; set; }

		/// <summary>
		/// Includes any interest income collects from money market investments. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20254
		/// </remarks>
		[JsonProperty("20254")]
		public InterestIncomeFromOtherMoneyMarketInvestmentsIncomeStatement InterestIncomeFromOtherMoneyMarketInvestments { get; set; }

		/// <summary>
		/// The aggregate foreign currency translation gain or loss (both realized and unrealized) included as part of revenue. This item is
		/// usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20255
		/// </remarks>
		[JsonProperty("20255")]
		public NetForeignExchangeGainLossIncomeStatement NetForeignExchangeGainLoss { get; set; }

		/// <summary>
		/// Occupancy expense may include items, such as depreciation of facilities and equipment, lease expenses, property taxes and
		/// property and casualty insurance expense. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20256
		/// </remarks>
		[JsonProperty("20256")]
		public NetOccupancyExpenseIncomeStatement NetOccupancyExpense { get; set; }

		/// <summary>
		/// Net premiums written are gross premiums written less ceded premiums. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20257
		/// </remarks>
		[JsonProperty("20257")]
		public NetPremiumsWrittenIncomeStatement NetPremiumsWritten { get; set; }

		/// <summary>
		/// Gain or loss realized during the period of time for all kinds of investment securities. In might include trading, available-for-sale, or
		/// held-to-maturity securities. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20258
		/// </remarks>
		[JsonProperty("20258")]
		public NetRealizedGainLossOnInvestmentsIncomeStatement NetRealizedGainLossOnInvestments { get; set; }

		/// <summary>
		/// A one-time change expense that the company does not expect to encounter again.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20259
		/// </remarks>
		[JsonProperty("20259")]
		public NonRecurringOperationExpenseIncomeStatement NonRecurringOperationExpense { get; set; }

		/// <summary>
		/// Includes total expenses of occupancy and equipment. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20260
		/// </remarks>
		[JsonProperty("20260")]
		public OccupancyAndEquipmentIncomeStatement OccupancyAndEquipment { get; set; }

		/// <summary>
		/// Taxes and licenses expenses incurred and are directly related to goods produced and sold and services rendered during the
		/// reporting period. This item is usually only available for transportation industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20261
		/// </remarks>
		[JsonProperty("20261")]
		public OperatingTaxesnLicensesIncomeStatement OperatingTaxesnLicenses { get; set; }

		/// <summary>
		/// The aggregate amount of operation and maintenance expenses, which is the one important operating expense for the utility
		/// industry. It includes any costs related to production and maintenance cost of the property during the revenue generation process.
		/// This item is usually only available for mining and utility industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20262
		/// </remarks>
		[JsonProperty("20262")]
		public OperationAndMaintenanceIncomeStatement OperationAndMaintenance { get; set; }

		/// <summary>
		/// Represents fees and commissions earned from provide other services. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20263
		/// </remarks>
		[JsonProperty("20263")]
		public OtherCustomerServicesIncomeStatement OtherCustomerServices { get; set; }

		/// <summary>
		/// All other gain/loss from disposition of discontinued operations that are not otherwise classified
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20264
		/// </remarks>
		[JsonProperty("20264")]
		public OtherGainLossFromDispositionOfDiscontinuedOperationsIncomeStatement OtherGainLossFromDispositionOfDiscontinuedOperations { get; set; }

		/// <summary>
		/// All other interest expense that is not otherwise classified
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20265
		/// </remarks>
		[JsonProperty("20265")]
		public OtherInterestExpenseIncomeStatement OtherInterestExpense { get; set; }

		/// <summary>
		/// All other interest income that is not otherwise classified
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20266
		/// </remarks>
		[JsonProperty("20266")]
		public OtherInterestIncomeIncomeStatement OtherInterestIncome { get; set; }

		/// <summary>
		/// All other non interest expense that is not otherwise classified
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20267
		/// </remarks>
		[JsonProperty("20267")]
		public OtherNonInterestExpenseIncomeStatement OtherNonInterestExpense { get; set; }

		/// <summary>
		/// For transportation industry, this represents revenue from operation business excluding revenue of cargo and passengers. For utility
		/// industry, this represents any revenue generated other than electric, gas, and transportation. This item is usually available for
		/// transportation and utility industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20268
		/// </remarks>
		[JsonProperty("20268")]
		public OtherOperatingRevenueIncomeStatement OtherOperatingRevenue { get; set; }

		/// <summary>
		/// All other special charges that are not otherwise classified
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20269
		/// </remarks>
		[JsonProperty("20269")]
		public OtherSpecialChargesIncomeStatement OtherSpecialCharges { get; set; }

		/// <summary>
		/// All other miscellaneous special charges that are not otherwise classified
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20270
		/// </remarks>
		[JsonProperty("20270")]
		public MiscOtherSpecialChargesIncomeStatement MiscOtherSpecialCharges { get; set; }

		/// <summary>
		/// Any taxes that are not part of income taxes. This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20271
		/// </remarks>
		[JsonProperty("20271")]
		public OtherTaxesIncomeStatement OtherTaxes { get; set; }

		/// <summary>
		/// Fees generated from issuing or renewing an auto insurance policy. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20272
		/// </remarks>
		[JsonProperty("20272")]
		public PolicyFeesIncomeStatement PolicyFees { get; set; }

		/// <summary>
		/// The provision in current period for future policy benefits, claims, and claims settlement, which is under reinsurance arrangements.
		/// This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20273
		/// </remarks>
		[JsonProperty("20273")]
		public PolicyholderBenefitsCededIncomeStatement PolicyholderBenefitsCeded { get; set; }

		/// <summary>
		/// The gross amount of provision in current period for future policyholder benefits, claims, and claims settlement, incurred in the
		/// claims settlement process before the effects of reinsurance arrangements. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20274
		/// </remarks>
		[JsonProperty("20274")]
		public PolicyholderBenefitsGrossIncomeStatement PolicyholderBenefitsGross { get; set; }

		/// <summary>
		/// Payments made or credits extended to the insured by the company, usually at the end of a policy year results in reducing the net
		/// insurance cost to the policyholder. Such dividends may be paid in cash to the insured or applied by the insured as reductions of the
		/// premiums due for the next policy year. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20275
		/// </remarks>
		[JsonProperty("20275")]
		public PolicyholderDividendsIncomeStatement PolicyholderDividends { get; set; }

		/// <summary>
		/// The periodic income payment provided to the annuitant by the insurance company, which is determined by the assumed interest
		/// rate (AIR) and other factors. This item is usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20276
		/// </remarks>
		[JsonProperty("20276")]
		public PolicyholderInterestIncomeStatement PolicyholderInterest { get; set; }

		/// <summary>
		/// The aggregate amount of investment income comes from policyholder account and ceded insurance agreements. This item is
		/// usually only available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20277
		/// </remarks>
		[JsonProperty("20277")]
		public PolicyholderAndReinsurerAccountsIncomeStatement PolicyholderAndReinsurerAccounts { get; set; }

		/// <summary>
		/// This relates to any distributions and earning adjustments due to Trust Preferred Securities issued by the company and its
		/// subsidiaries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20278
		/// </remarks>
		[JsonProperty("20278")]
		public TrustPreferredSecuritiesIncomeStatement TrustPreferredSecurities { get; set; }

		/// <summary>
		/// Schedule of revenue by reporting categories or types of financial instruments, including derivatives but excluding dividends and
		/// interests, from trading for own account by broker dealers. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20279
		/// </remarks>
		[JsonProperty("20279")]
		public PrincipleTransactionRevenueIncomeStatement PrincipleTransactionRevenue { get; set; }

		/// <summary>
		/// Professional and contract service expense includes cost reimbursements for support services related to contracted projects,
		/// outsourced management, technical and staff support. This item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20280
		/// </remarks>
		[JsonProperty("20280")]
		public ProfessionalExpenseAndContractServicesExpenseIncomeStatement ProfessionalExpenseAndContractServicesExpense { get; set; }

		/// <summary>
		/// Costs associated with publicizing a good or need for sale. This category includes only expenses, which are specific as promotion, or
		/// advertising expenses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20281
		/// </remarks>
		[JsonProperty("20281")]
		public PromotionAndAdvertisingIncomeStatement PromotionAndAdvertising { get; set; }

		/// <summary>
		/// Premiums earned for all property and casualty insurance assumed from other insurers as a result of reinsurance arrangements. This
		/// item is usually only available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20282
		/// </remarks>
		[JsonProperty("20282")]
		public PropertyCasualtyPremiumsIncomeStatement PropertyCasualtyPremiums { get; set; }

		/// <summary>
		/// Amount of the current period expense charged against operations, the offset which is generally to the allowance for doubtful
		/// accounts for the purpose of reducing receivables, including notes receivable, to an amount that approximates their net realizable
		/// value (the amount expected to be collected). The category includes provision for loan losses, provision for any doubtful account
		/// receivable, and bad debt expenses. This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20283
		/// </remarks>
		[JsonProperty("20283")]
		public ProvisionForDoubtfulAccountsIncomeStatement ProvisionForDoubtfulAccounts { get; set; }

		/// <summary>
		/// The amount of current expense charged in order to prepare for the disposal of discontinued operations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20284
		/// </remarks>
		[JsonProperty("20284")]
		public ProvisionForGainLossOnDisposalIncomeStatement ProvisionForGainLossOnDisposal { get; set; }

		/// <summary>
		/// Represents the payment or accrual (net of fare revenues) to other transit agencies, public or private, for providing transportation
		/// service and purchased transportation (PT) fare revenues. This item is usually only available for transportation industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20285
		/// </remarks>
		[JsonProperty("20285")]
		public PurchasedTransportationServicesIncomeStatement PurchasedTransportationServices { get; set; }

		/// <summary>
		/// The amount by which an asset's selling price exceeds its initial purchase price is called capital gain. A realized capital gain is when
		/// it has been sold at a profit. This item is usually not available for bank and insurance industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20286
		/// </remarks>
		[JsonProperty("20286")]
		public RealizedCapitalGainIncomeStatement RealizedCapitalGain { get; set; }

		/// <summary>
		/// Rent fees are the cost of occupying space during the accounting period. Landing fees are a change paid to an airport company for
		/// landing at a particular airport. This item is not available for insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20287
		/// </remarks>
		[JsonProperty("20287")]
		public RentAndLandingFeesIncomeStatement RentAndLandingFees { get; set; }

		/// <summary>
		/// Expenses that may be directed toward the discovery of new facts, natural laws, or phenomena without regard to the immediate
		/// commercial application to which the results may be put or as costs directed toward more specific goals such as product
		/// improvement or the perfection and improvement of processes or techniques of production.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20288
		/// </remarks>
		[JsonProperty("20288")]
		public ResearchExpenseIncomeStatement ResearchExpense { get; set; }

		/// <summary>
		/// Expenses are related to restructuring, merger, or acquisitions. Restructuring expenses are charges associated with the
		/// consolidation and relocation of operations, disposition or abandonment of operations or productive assets. Merger and acquisition
		/// expenses are the amount of costs of a business combination including legal, accounting, and other costs that were charged to
		/// expense during the period.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20289
		/// </remarks>
		[JsonProperty("20289")]
		public RestructuringAndMergernAcquisitionIncomeStatement RestructuringAndMergernAcquisition { get; set; }

		/// <summary>
		/// Revenue is from transporting cargo and freight between locations. This item is usually only available for transportation industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20290
		/// </remarks>
		[JsonProperty("20290")]
		public RevenuesCargoIncomeStatement RevenuesCargo { get; set; }

		/// <summary>
		/// A transportation carrier's fare revenue is recognized in the period from carrying passengers between destinations. This item is
		/// usually only available for transportation industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20291
		/// </remarks>
		[JsonProperty("20291")]
		public RevenuesPassengerIncomeStatement RevenuesPassenger { get; set; }

		/// <summary>
		/// All salary, wages, compensation, management fees, and employee benefit expenses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20292
		/// </remarks>
		[JsonProperty("20292")]
		public SalariesAndWagesIncomeStatement SalariesAndWages { get; set; }

		/// <summary>
		/// Income/Loss from Securities and Activities
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20293
		/// </remarks>
		[JsonProperty("20293")]
		public SecuritiesActivitiesIncomeStatement SecuritiesActivities { get; set; }

		/// <summary>
		/// Expenses recognized in the period that are directly related to the selling and distribution of products or services.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20294
		/// </remarks>
		[JsonProperty("20294")]
		public SellingExpenseIncomeStatement SellingExpense { get; set; }

		/// <summary>
		/// Includes any service charges on following accounts: Demand Deposit; Checking account; Savings account; Deposit in foreign
		/// offices; ESCROW accounts; Money Market Certificates &amp; Deposit accounts, CDs (Negotiable Certificates of Deposits); NOW
		/// Accounts (Negotiable Order of Withdrawal); IRAs (Individual Retirement Accounts). This item is usually only available for bank
		/// industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20295
		/// </remarks>
		[JsonProperty("20295")]
		public ServiceChargeOnDepositorAccountsIncomeStatement ServiceChargeOnDepositorAccounts { get; set; }

		/// <summary>
		/// On the Income Statement; The portion of a firm that is either directly or indirectly controlled by the parent, but not consolidated
		/// with the parent for purposes of the financial statements.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20296
		/// </remarks>
		[JsonProperty("20296")]
		public ShareInNetIncomeOfUnconsolidatedEntitiesIncomeStatement ShareInNetIncomeOfUnconsolidatedEntities { get; set; }

		/// <summary>
		/// This item is typically available for bank industry. On the balance sheet, the aggregate amount of time deposits, including certificates
		/// of deposits, individual retirement accounts and open accounts. On the income statement, it represents interest earned on deposits
		/// that have to stay in the bank for a certain period of time before they can be collected without sustaining a penalty. Usually includes
		/// certificates of deposits, individual retirement accounts and open accounts.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20297
		/// </remarks>
		[JsonProperty("20297")]
		public TimeDepositsPlacedIncomeStatement TimeDepositsPlaced { get; set; }

		/// <summary>
		/// A broker-dealer or other financial entity may buy and sell securities exclusively for its own account, sometimes referred to as
		/// proprietary trading. The profit or loss is measured by the difference between the acquisition cost and the selling price or current
		/// market or fair value. The net gain or loss, includes both realized and unrealized, from trading cash instruments, equities and
		/// derivative contracts (including commodity contracts) that has been recognized during the accounting period for the broker dealer or
		/// other financial entity's own account. This item is typically available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20298
		/// </remarks>
		[JsonProperty("20298")]
		public TradingGainLossIncomeStatement TradingGainLoss { get; set; }

		/// <summary>
		/// Revenue from operations of public mass transportation systems (rapid transit, subway, bus, street railway, and commuter rail
		/// services), such as fares, charter fees, advertising income, and other operations revenues.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20299
		/// </remarks>
		[JsonProperty("20299")]
		public TransportationRevenueIncomeStatement TransportationRevenue { get; set; }

		/// <summary>
		/// Bank manages funds on behalf of its customers through the operation of various trust accounts. Any fees earned through managing
		/// those funds are called trust fees, which are recognized when earned. This item is typically available for bank industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20300
		/// </remarks>
		[JsonProperty("20300")]
		public TrustFeesbyCommissionsIncomeStatement TrustFeesbyCommissions { get; set; }

		/// <summary>
		/// Also known as Policy Acquisition Costs; and reported by insurance companies.  The cost incurred by an insurer when deciding
		/// whether to accept or decline a risk; may include meetings with the insureds or brokers, actuarial review of loss history, or physical
		/// inspections of exposures. Also, expenses deducted from insurance company revenues (including incurred losses and acquisition
		/// costs) to determine underwriting profit.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20301
		/// </remarks>
		[JsonProperty("20301")]
		public UnderwritingExpensesIncomeStatement UnderwritingExpenses { get; set; }

		/// <summary>
		/// Reducing the book value of an asset because it is overvalued compared to the current market value.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20302
		/// </remarks>
		[JsonProperty("20302")]
		public WriteDownIncomeStatement WriteDown { get; set; }

		/// <summary>
		/// Reducing the book value of an asset because it is overvalued compared to the current market value.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20303
		/// </remarks>
		[JsonProperty("20303")]
		public OtherWriteDownIncomeStatement OtherWriteDown { get; set; }

		/// <summary>
		/// A reduction in the value of an asset or earnings by the amount of an expense or loss.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20304
		/// </remarks>
		[JsonProperty("20304")]
		public WriteOffIncomeStatement WriteOff { get; set; }

		/// <summary>
		/// A reduction in the value of an asset or earnings by the amount of an expense or loss.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20305
		/// </remarks>
		[JsonProperty("20305")]
		public OtherWriteOffIncomeStatement OtherWriteOff { get; set; }

		/// <summary>
		/// Usually available for the banking industry.  This is Non-Interest Income that is not otherwise classified.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20306
		/// </remarks>
		[JsonProperty("20306")]
		public OtherNonInterestIncomeIncomeStatement OtherNonInterestIncome { get; set; }

		/// <summary>
		/// Insurance premium tax is a tax paid by some insurance companies and insurance brokers that sell taxable insurance within the
		/// united kingdom. This item is typically available for the insurance industry.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20307
		/// </remarks>
		[JsonProperty("20307")]
		public PremiumTaxesCreditIncomeStatement PremiumTaxesCredit { get; set; }

		/// <summary>
		/// The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in
		/// production) in a systematic and rational manner to the periods expected to benefit from such assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20308
		/// </remarks>
		[JsonProperty("20308")]
		public AmortizationOfIntangiblesIncomeStatement AmortizationOfIntangibles { get; set; }

		/// <summary>
		/// Net Income from Continuing Operations and Discontinued Operations, added together.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20309
		/// </remarks>
		[JsonProperty("20309")]
		public NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement NetIncomeFromContinuingAndDiscontinuedOperation { get; set; }

		/// <summary>
		/// Any gains or loss not otherwise attributable to Continuing Operations, Discontinued Operations, Extraordinary Items, Accumulated
		/// Effects of Accounting Changes or Income from Tax Loss Carryforward.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20310
		/// </remarks>
		[JsonProperty("20310")]
		public NetIncomeFromOtherGainsLossesIncomeStatement NetIncomeFromOtherGainsLosses { get; set; }

		/// <summary>
		/// Occurs if a company has had a net loss from operations on a previous year that can be carried forward to reduce net income for tax
		/// purposes.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20311
		/// </remarks>
		[JsonProperty("20311")]
		public NetIncomeFromTaxLossCarryforwardIncomeStatement NetIncomeFromTaxLossCarryforward { get; set; }

		/// <summary>
		/// The aggregate amount of operating expenses associated with normal operations. Will not include any gain, loss, benefit, or income;
		/// and its value reported by the company should be &lt;0.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20312
		/// </remarks>
		[JsonProperty("20312")]
		public OtherOperatingExpensesIncomeStatement OtherOperatingExpenses { get; set; }

		/// <summary>
		/// The sum of the money market investments held by a bank's depositors, which are FDIC insured.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20313
		/// </remarks>
		[JsonProperty("20313")]
		public TotalMoneyMarketInvestmentsIncomeStatement TotalMoneyMarketInvestments { get; set; }

		/// <summary>
		/// The Cost Of Revenue plus Depreciation, Depletion &amp; Amortization from the IncomeStatement; minus Depreciation, Depletion &amp;
		/// Amortization from the Cash Flow Statement
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20314
		/// </remarks>
		[JsonProperty("20314")]
		public ReconciledCostOfRevenueIncomeStatement ReconciledCostOfRevenue { get; set; }

		/// <summary>
		/// Is Depreciation, Depletion &amp; Amortization from the Cash Flow Statement
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20315
		/// </remarks>
		[JsonProperty("20315")]
		public ReconciledDepreciationIncomeStatement ReconciledDepreciation { get; set; }

		/// <summary>
		/// This is calculation that reverses the effects of extraordinary income or charges on Net Income, by adding back (extraordinary
		/// expense) or subtracting (extraordinary income) the value from Net Income.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20316
		/// </remarks>
		[JsonProperty("20316")]
		public NormalizedIncomeIncomeStatement NormalizedIncome { get; set; }

		/// <summary>
		/// Expenses incurred in performance of activities not directly related to the main business of a firm, such as for the insurance or
		/// maintenance of the assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20317
		/// </remarks>
		[JsonProperty("20317")]
		public NonOperatingExpensesIncomeStatement NonOperatingExpenses { get; set; }

		/// <summary>
		/// The portion of an organization's income that is derived from activities not related to its core operations; such as as dividend income,
		/// profits (and losses) from investments, gains (or losses) incurred due to foreign exchange, asset write-downs and other non-
		/// operating revenues and expenses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20318
		/// </remarks>
		[JsonProperty("20318")]
		public NonOperatingIncomeIncomeStatement NonOperatingIncome { get; set; }

		/// <summary>
		/// Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
		/// Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
		/// Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20331
		/// </remarks>
		[JsonProperty("20331")]
		public NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement NetIncomeFromContinuingOperationNetMinorityInterest { get; set; }

		/// <summary>
		/// Gain/Loss on the disposal of the investment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20332
		/// </remarks>
		[JsonProperty("20332")]
		public PrincipleInvestmentGainLossIncomeStatement PrincipleInvestmentGainLoss { get; set; }

		/// <summary>
		/// Any gain (loss) recognized on the sale of assets or a sale which generates profit or loss, which is a difference between sales price
		/// and net book value at the disposal time.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20333
		/// </remarks>
		[JsonProperty("20333")]
		public GainLossonSaleofAssetsIncomeStatement GainLossonSaleofAssets { get; set; }

		/// <summary>
		/// Gain on sale of any loans investment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20334
		/// </remarks>
		[JsonProperty("20334")]
		public GainonSaleofLoansIncomeStatement GainonSaleofLoans { get; set; }

		/// <summary>
		/// Gain on the disposal of investment property.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20335
		/// </remarks>
		[JsonProperty("20335")]
		public GainonSaleofInvestmentPropertyIncomeStatement GainonSaleofInvestmentProperty { get; set; }

		/// <summary>
		/// Special income that is either infrequent or unusual.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20336
		/// </remarks>
		[JsonProperty("20336")]
		public SpecialIncomeIncomeStatement SpecialIncome { get; set; }

		/// <summary>
		/// Income earned through R&amp;D department. This data point applies to the bank and insurance industry only.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20337
		/// </remarks>
		[JsonProperty("20337")]
		public AcquiredinProcessRnDIncomeBanksIncomeStatement AcquiredinProcessRnDIncomeBanks { get; set; }

		/// <summary>
		/// Relates to restructuring, merger, or acquisitions for non-operating activities. A restructuring charge might be incurred in the process
		/// of laying off employees, closing manufacturing plants, or shifting production to a new location.
		/// Merger - When two firms, often of about the same size, agree to go forward as a single new company rather than remain
		/// separately owned and operated.
		/// Acquisition - When one company takes over another and clearly establishes itself as the new owner.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20338
		/// </remarks>
		[JsonProperty("20338")]
		public RestructuringAndMergerAndAcquisitionIncomeIncomeStatement RestructuringAndMergerAndAcquisitionIncome { get; set; }

		/// <summary>
		/// Downward revaluation of fixed assets. Any impairment related with Fixed Assets &amp; Fixed Asset Investments comes under this
		/// exceptional data item.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20339
		/// </remarks>
		[JsonProperty("20339")]
		public ImpairmentofCapitalAssetsIncomeIncomeStatement ImpairmentofCapitalAssetsIncome { get; set; }

		/// <summary>
		/// Gain on extinguishment of debt is the accounting gain that results from a debt extinguishment. A debt shall be accounted for as
		/// having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by
		/// another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the
		/// payments made and the carrying amount of the debt at the time of its extinguishment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20340
		/// </remarks>
		[JsonProperty("20340")]
		public GainonExtinguishmentofDebtIncomeStatement GainonExtinguishmentofDebt { get; set; }

		/// <summary>
		/// Special expenses that are either infrequent or unusual.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20342
		/// </remarks>
		[JsonProperty("20342")]
		public SpecialChargeIncomeStatement SpecialCharge { get; set; }

		/// <summary>
		/// Loss on extinguishment of debt is the accounting loss that results from a debt extinguishment. A debt shall be accounted for as
		/// having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by
		/// another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the
		/// payments made and the carrying amount of the debt at the time of its extinguishment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20343
		/// </remarks>
		[JsonProperty("20343")]
		public LossonExtinguishmentofDebtIncomeStatement LossonExtinguishmentofDebt { get; set; }

		/// <summary>
		/// Income from other equity interest reported after Provision of Tax. This applies to all industries.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20345
		/// </remarks>
		[JsonProperty("20345")]
		public EarningsfromEquityInterestNetOfTaxIncomeStatement EarningsfromEquityInterestNetOfTax { get; set; }

		/// <summary>
		/// Net income of the group after the adjustment of all expenses and benefit.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20346
		/// </remarks>
		[JsonProperty("20346")]
		public NetIncomeIncludingNoncontrollingInterestsIncomeStatement NetIncomeIncludingNoncontrollingInterests { get; set; }

		/// <summary>
		/// Dividend paid to the preferred shareholders before the common stock shareholders.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20347
		/// </remarks>
		[JsonProperty("20347")]
		public OtherunderPreferredStockDividendIncomeStatement OtherunderPreferredStockDividend { get; set; }

		/// <summary>
		/// Earnings from equity interest, accounted for in the Revenue section. An equity interest is a proportion of ownership, typically
		/// through the investment in a business.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20348
		/// </remarks>
		[JsonProperty("20348")]
		public EarningsfromEquityInterestRevenueIncomeStatement EarningsfromEquityInterestRevenue { get; set; }

		/// <summary>
		/// Gain/loss on the disposal of assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20349
		/// </remarks>
		[JsonProperty("20349")]
		public GainLossfromDisposalSaleofAssetsIncomeStatement GainLossfromDisposalSaleofAssets { get; set; }

		/// <summary>
		/// Gain/loss on the disposal of assets in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20350
		/// </remarks>
		[JsonProperty("20350")]
		public GainLossfromDisposalSaleofAssetsOtherIncomeStatement GainLossfromDisposalSaleofAssetsOther { get; set; }

		/// <summary>
		/// Gain on disposal of real estate by the bank.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20351
		/// </remarks>
		[JsonProperty("20351")]
		public GainonSaleofOtherRealEstateOwnedIncomeStatement GainonSaleofOtherRealEstateOwned { get; set; }

		/// <summary>
		/// Interest income, accounted for in the Revenue section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20352
		/// </remarks>
		[JsonProperty("20352")]
		public InterestIncomeRevenueIncomeStatement InterestIncomeRevenue { get; set; }

		/// <summary>
		/// Expenses incurred by the company in relation to legal matters.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20353
		/// </remarks>
		[JsonProperty("20353")]
		public LitigationExpenseIncomeStatement LitigationExpense { get; set; }

		/// <summary>
		/// Adjustments to the value of investments, excluding temporary write-downs.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20354
		/// </remarks>
		[JsonProperty("20354")]
		public OtherthanTemporaryImpairmentLossesInvestmentsIncomeStatement OtherthanTemporaryImpairmentLossesInvestments { get; set; }

		/// <summary>
		/// Unrealized gains/losses incurred by the company in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20355
		/// </remarks>
		[JsonProperty("20355")]
		public UnrealizedGainorLossIncomeStatement UnrealizedGainorLoss { get; set; }

		/// <summary>
		/// Income/expense due to changes between periods in inventory.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20356
		/// </remarks>
		[JsonProperty("20356")]
		public ChangesinInventoriesofFinishedGoodsandWorkinProgressIncomeStatement ChangesinInventoriesofFinishedGoodsandWorkinProgress { get; set; }

		/// <summary>
		/// An amount paid in respect of work performed by entity.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20357
		/// </remarks>
		[JsonProperty("20357")]
		public WorkPerformedbyEntityandCapitalizedIncomeStatement WorkPerformedbyEntityandCapitalized { get; set; }

		/// <summary>
		/// Expenditures occurred on the distribution of the products.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20358
		/// </remarks>
		[JsonProperty("20358")]
		public DistributionCostsIncomeStatement DistributionCosts { get; set; }

		/// <summary>
		/// Total staff cost which is paid to the employees that is not part of Selling, General, and Administration expense.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20359
		/// </remarks>
		[JsonProperty("20359")]
		public StaffCostsIncomeStatement StaffCosts { get; set; }

		/// <summary>
		/// Benefits paid to the employees in respect of their work.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20360
		/// </remarks>
		[JsonProperty("20360")]
		public SocialSecurityCostsIncomeStatement SocialSecurityCosts { get; set; }

		/// <summary>
		/// The expense that a company incurs each year by providing a pension plan for its employees. Major expenses in the pension cost
		/// include employer matching contributions and management fees.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20361
		/// </remarks>
		[JsonProperty("20361")]
		public PensionCostsIncomeStatement PensionCosts { get; set; }

		/// <summary>
		/// Total Other Operating Income- including interest income, dividend income and other types of operating income.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20363
		/// </remarks>
		[JsonProperty("20363")]
		public OtherOperatingIncomeTotalIncomeStatement OtherOperatingIncomeTotal { get; set; }

		/// <summary>
		/// Share of profit from joint ventures and associates, accounted for in the Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20364
		/// </remarks>
		[JsonProperty("20364")]
		public ShareofOperatingProfitLossfromJointVenturesAndAssociatesIncomeStatement ShareofOperatingProfitLossfromJointVenturesAndAssociates { get; set; }

		/// <summary>
		/// Total value of non-recurring items in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20365
		/// </remarks>
		[JsonProperty("20365")]
		public ExceptionalItemsIncomeStatement ExceptionalItems { get; set; }

		/// <summary>
		/// Income from the related companies- subsidiaries and other equity holdings, accounted for in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20366
		/// </remarks>
		[JsonProperty("20366")]
		public IncomefromSharesinSubsidiariesGroupUndertakingsIncomeStatement IncomefromSharesinSubsidiariesGroupUndertakings { get; set; }

		/// <summary>
		/// Total income from the associates and joint venture via investment, accounted for in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20367
		/// </remarks>
		[JsonProperty("20367")]
		public IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement IncomefromAssociatesandOtherParticipatingInterests { get; set; }

		/// <summary>
		/// Any other finance cost which is not clearly defined in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20368
		/// </remarks>
		[JsonProperty("20368")]
		public TotalOtherFinanceCostIncomeStatement TotalOtherFinanceCost { get; set; }

		/// <summary>
		/// Total amount paid in dividends to investors- this includes dividends paid on equity and non-equity shares.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20371
		/// </remarks>
		[JsonProperty("20371")]
		public GrossDividendPaymentIncomeStatement GrossDividendPayment { get; set; }

		/// <summary>
		/// Income from cash and cash equivalents, short-term securities, debt securities, mortgage and loans, derivative investments, policy
		/// loans and other interest income.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20376
		/// </remarks>
		[JsonProperty("20376")]
		public InterestandSimilarIncomeIncomeStatement InterestandSimilarIncome { get; set; }

		/// <summary>
		/// Fees and commission income earned by bank and insurance companies on the rendering services.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20377
		/// </remarks>
		[JsonProperty("20377")]
		public FeesandCommissionIncomeIncomeStatement FeesandCommissionIncome { get; set; }

		/// <summary>
		/// Cost incurred by bank and insurance companies for fees and commission income.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20378
		/// </remarks>
		[JsonProperty("20378")]
		public FeesandCommissionExpenseIncomeStatement FeesandCommissionExpense { get; set; }

		/// <summary>
		/// Any trading income on the securities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20379
		/// </remarks>
		[JsonProperty("20379")]
		public NetTradingIncomeIncomeStatement NetTradingIncome { get; set; }

		/// <summary>
		/// Payment of reinsurance premium.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20380
		/// </remarks>
		[JsonProperty("20380")]
		public OutwardReinsurancePremiumsIncomeStatement OutwardReinsurancePremiums { get; set; }

		/// <summary>
		/// Other costs in incurred in lieu of the employees that cannot be identified by other specific items in the Staff Costs section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20381
		/// </remarks>
		[JsonProperty("20381")]
		public OtherStaffCostsIncomeStatement OtherStaffCosts { get; set; }

		/// <summary>
		/// Stock based expenses that occur in normal activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20382
		/// </remarks>
		[JsonProperty("20382")]
		public ShareBasedPaymentsIncomeStatement ShareBasedPayments { get; set; }

		/// <summary>
		/// Gain on disposal and change in fair value of investment properties.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20383
		/// </remarks>
		[JsonProperty("20383")]
		public GainonInvestmentPropertiesIncomeStatement GainonInvestmentProperties { get; set; }

		/// <summary>
		/// Adjustments to reported net income to calculate Diluted EPS, by assuming that all convertible instruments are converted to
		/// Common Equity. The adjustments usually include the interest expense of debentures when assumed converted and preferred
		/// dividends of convertible preferred stock when assumed converted.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20385
		/// </remarks>
		[JsonProperty("20385")]
		public AverageDilutionEarningsIncomeStatement AverageDilutionEarnings { get; set; }

		/// <summary>
		/// Gain on the redemption of the loan or repayment of the loan.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20389
		/// </remarks>
		[JsonProperty("20389")]
		public GainonRedemptionandExtinguishmentofDebtIncomeStatement GainonRedemptionandExtinguishmentofDebt { get; set; }

		/// <summary>
		/// Other income of the company that cannot be identified by other specific items in the Operating Income section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20390
		/// </remarks>
		[JsonProperty("20390")]
		public MiscellaneousOtherOperatingIncomeIncomeStatement MiscellaneousOtherOperatingIncome { get; set; }

		/// <summary>
		/// Gain/Loss through hedging activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20391
		/// </remarks>
		[JsonProperty("20391")]
		public GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement GainLossonFinancialInstrumentsDesignatedasCashFlowHedges { get; set; }

		/// <summary>
		/// Gain/loss on the write-off of financial assets available-for-sale.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20392
		/// </remarks>
		[JsonProperty("20392")]
		public GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement GainLossonDerecognitionofAvailableForSaleFinancialAssets { get; set; }

		/// <summary>
		/// Gain/loss on the write-off of any non-current assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20393
		/// </remarks>
		[JsonProperty("20393")]
		public GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotalIncomeStatement GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotal { get; set; }

		/// <summary>
		/// Negative Goodwill recognized in the Income Statement. Negative Goodwill arises where the net assets at the date of acquisition,
		/// fairly valued, falls below the cost of acquisition.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20394
		/// </remarks>
		[JsonProperty("20394")]
		public NegativeGoodwillImmediatelyRecognizedIncomeStatement NegativeGoodwillImmediatelyRecognized { get; set; }

		/// <summary>
		/// Gain or loss on derivatives investment due to the fair value adjustment.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20395
		/// </remarks>
		[JsonProperty("20395")]
		public GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal { get; set; }

		/// <summary>
		/// Impairment or reversal of impairment on financial instrument such as derivative. This is a contra account under Total Revenue in
		/// banks.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20396
		/// </remarks>
		[JsonProperty("20396")]
		public ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement ImpairmentLossesReversalsFinancialInstrumentsNet { get; set; }

		/// <summary>
		/// Income from equity investments in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20397
		/// </remarks>
		[JsonProperty("20397")]
		public ShareofProfitLossfromEquityAccountedInvestmentsIncomeStatement ShareofProfitLossfromEquityAccountedInvestments { get; set; }

		/// <summary>
		/// All reported claims arising out of incidents in that year are considered incurred grouped with claims paid out.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20400
		/// </remarks>
		[JsonProperty("20400")]
		public ClaimsandPaidIncurredIncomeStatement ClaimsandPaidIncurred { get; set; }

		/// <summary>
		/// Claim on the reinsurance company and take the benefits.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20401
		/// </remarks>
		[JsonProperty("20401")]
		public ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement ReinsuranceRecoveriesClaimsandBenefits { get; set; }

		/// <summary>
		/// Income/Expense due to changes between periods in insurance liabilities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20402
		/// </remarks>
		[JsonProperty("20402")]
		public ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement ChangeinInsuranceLiabilitiesNetofReinsurance { get; set; }

		/// <summary>
		/// Income/Expense due to changes between periods in Investment Contracts.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20405
		/// </remarks>
		[JsonProperty("20405")]
		public ChangeinInvestmentContractIncomeStatement ChangeinInvestmentContract { get; set; }

		/// <summary>
		/// Income/Expense due to changes between periods in Reinsurance Assets.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20408
		/// </remarks>
		[JsonProperty("20408")]
		public ChangeinReinsuranceAssetsIncomeStatement ChangeinReinsuranceAssets { get; set; }

		/// <summary>
		/// Provision for the risk of loss of principal or loss of a financial reward stemming from a borrower's failure to repay a loan or otherwise
		/// meet a contractual obligation. Credit risk arises whenever a borrower is expecting to use future cash flows to pay a current debt.
		/// Investors are compensated for assuming credit risk by way of interest payments from the borrower or issuer of a debt obligation.
		/// This is a contra account under Total Revenue in banks.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20409
		/// </remarks>
		[JsonProperty("20409")]
		public CreditRiskProvisionsIncomeStatement CreditRiskProvisions { get; set; }

		/// <summary>
		/// This is the portion under Staff Costs that represents salary paid to the employees in respect of their work.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20411
		/// </remarks>
		[JsonProperty("20411")]
		public WagesandSalariesIncomeStatement WagesandSalaries { get; set; }

		/// <summary>
		/// Total other income and expense of the company that cannot be identified by other specific items in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20412
		/// </remarks>
		[JsonProperty("20412")]
		public OtherNonOperatingIncomeExpensesIncomeStatement OtherNonOperatingIncomeExpenses { get; set; }

		/// <summary>
		/// Interest income earned by normal operating activities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20413
		/// </remarks>
		[JsonProperty("20413")]
		public InterestIncomeOtherOperatingIncomeIncomeStatement InterestIncomeOtherOperatingIncome { get; set; }

		/// <summary>
		/// Other income of the company that cannot be identified by other specific items in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20414
		/// </remarks>
		[JsonProperty("20414")]
		public OtherNonOperatingIncomeIncomeStatement OtherNonOperatingIncome { get; set; }

		/// <summary>
		/// Other expenses of the company that cannot be identified by other specific items in the Non-Operating section.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20415
		/// </remarks>
		[JsonProperty("20415")]
		public OtherNonOperatingExpensesIncomeStatement OtherNonOperatingExpenses { get; set; }

		/// <summary>
		/// Total unusual items including Negative Goodwill.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20416
		/// </remarks>
		[JsonProperty("20416")]
		public TotalUnusualItemsIncomeStatement TotalUnusualItems { get; set; }

		/// <summary>
		/// The sum of all the identifiable operating and non-operating unusual items.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20417
		/// </remarks>
		[JsonProperty("20417")]
		public TotalUnusualItemsExcludingGoodwillIncomeStatement TotalUnusualItemsExcludingGoodwill { get; set; }

		/// <summary>
		/// Tax rate used for Morningstar calculations.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20418
		/// </remarks>
		[JsonProperty("20418")]
		public TaxRateForCalcsIncomeStatement TaxRateForCalcs { get; set; }

		/// <summary>
		/// Tax effect of the usual items
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20419
		/// </remarks>
		[JsonProperty("20419")]
		public TaxEffectOfUnusualItemsIncomeStatement TaxEffectOfUnusualItems { get; set; }

		/// <summary>
		/// EBITDA - Total Unusual Items
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20420
		/// </remarks>
		[JsonProperty("20420")]
		public NormalizedEBITDAIncomeStatement NormalizedEBITDA { get; set; }

		/// <summary>
		/// Gain or loss resulting from an appreciation or devaluation of the non-local currency from borrowings related interest income or
		/// expenses.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20421
		/// </remarks>
		[JsonProperty("20421")]
		public GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCostsIncomeStatement GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCosts { get; set; }

		/// <summary>
		/// The cost to the company for granting stock options to reward employees.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20422
		/// </remarks>
		[JsonProperty("20422")]
		public StockBasedCompensationIncomeStatement StockBasedCompensation { get; set; }

		/// <summary>
		/// Filing date of the Income Statement.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20423
		/// </remarks>
		[JsonProperty("20423")]
		public DateTime ISFileDate { get; set; }

		/// <summary>
		/// Net income to calculate Diluted EPS, accounting for adjustments assuming that all the convertible instruments are being converted
		/// to Common Equity.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20424
		/// </remarks>
		[JsonProperty("20424")]
		public DilutedNIAvailtoComStockholdersIncomeStatement DilutedNIAvailtoComStockholders { get; set; }

		/// <summary>
		/// Income/Expenses due to the insurer's liabilities incurred in Investment Contracts.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20425
		/// </remarks>
		[JsonProperty("20425")]
		public InvestmentContractLiabilitiesIncurredIncomeStatement InvestmentContractLiabilitiesIncurred { get; set; }

		/// <summary>
		/// Income/Expense due to recoveries from reinsurers for Investment Contracts.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20426
		/// </remarks>
		[JsonProperty("20426")]
		public ReinsuranceRecoveriesofInvestmentContractIncomeStatement ReinsuranceRecoveriesofInvestmentContract { get; set; }

		/// <summary>
		/// Total amount paid in dividends to equity securities investors.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20429
		/// </remarks>
		[JsonProperty("20429")]
		public TotalDividendPaymentofEquitySharesIncomeStatement TotalDividendPaymentofEquityShares { get; set; }

		/// <summary>
		/// Total amount paid in dividends to Non-Equity securities investors.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20430
		/// </remarks>
		[JsonProperty("20430")]
		public TotalDividendPaymentofNonEquitySharesIncomeStatement TotalDividendPaymentofNonEquityShares { get; set; }

		/// <summary>
		/// The change in the amount of the unearned premium reserves maintained by insurers.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20431
		/// </remarks>
		[JsonProperty("20431")]
		public ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement ChangeinTheGrossProvisionforUnearnedPremiums { get; set; }

		/// <summary>
		/// The change in the amount of unearned premium reserve to be covered by reinsurers.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20432
		/// </remarks>
		[JsonProperty("20432")]
		public ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare { get; set; }

		/// <summary>
		/// Income/Expense due to the insurer's changes in insurance liabilities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20433
		/// </remarks>
		[JsonProperty("20433")]
		public ClaimsandChangeinInsuranceLiabilitiesIncomeStatement ClaimsandChangeinInsuranceLiabilities { get; set; }

		/// <summary>
		/// Income/Expense due to recoveries from reinsurers for insurance liabilities.
		/// </summary>
		/// <remarks>
		/// Morningstar DataId: 20434
		/// </remarks>
		[JsonProperty("20434")]
		public ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement ReinsuranceRecoveriesofInsuranceLiabilities { get; set; }

		/// <summary>
		/// Creates an instance of the IncomeStatement class
		/// </summary>
		public IncomeStatement()
		{
			Amortization = new AmortizationIncomeStatement();
			SecuritiesAmortization = new SecuritiesAmortizationIncomeStatement();
			CostOfRevenue = new CostOfRevenueIncomeStatement();
			CumulativeEffectOfAccountingChange = new CumulativeEffectOfAccountingChangeIncomeStatement();
			Depletion = new DepletionIncomeStatement();
			Depreciation = new DepreciationIncomeStatement();
			DepreciationAndAmortization = new DepreciationAndAmortizationIncomeStatement();
			DepreciationAmortizationDepletion = new DepreciationAmortizationDepletionIncomeStatement();
			NetIncomeDiscontinuousOperations = new NetIncomeDiscontinuousOperationsIncomeStatement();
			ExciseTaxes = new ExciseTaxesIncomeStatement();
			NetIncomeExtraordinary = new NetIncomeExtraordinaryIncomeStatement();
			FeeRevenueAndOtherIncome = new FeeRevenueAndOtherIncomeIncomeStatement();
			GeneralAndAdministrativeExpense = new GeneralAndAdministrativeExpenseIncomeStatement();
			GrossProfit = new GrossProfitIncomeStatement();
			InterestExpense = new InterestExpenseIncomeStatement();
			InterestExpenseNonOperating = new InterestExpenseNonOperatingIncomeStatement();
			InterestExpenseOperating = new InterestExpenseOperatingIncomeStatement();
			InterestIncomeAfterProvisionForLoanLoss = new InterestIncomeAfterProvisionForLoanLossIncomeStatement();
			InterestIncomeNonOperating = new InterestIncomeNonOperatingIncomeStatement();
			InterestIncomeOperating = new InterestIncomeOperatingIncomeStatement();
			NetNonOperatingInterestIncomeExpense = new NetNonOperatingInterestIncomeExpenseIncomeStatement();
			NetOperatingInterestIncomeExpense = new NetOperatingInterestIncomeExpenseIncomeStatement();
			LossAdjustmentExpense = new LossAdjustmentExpenseIncomeStatement();
			MinorityInterests = new MinorityInterestsIncomeStatement();
			NetIncome = new NetIncomeIncomeStatement();
			NetIncomeCommonStockholders = new NetIncomeCommonStockholdersIncomeStatement();
			NetIncomeContinuousOperations = new NetIncomeContinuousOperationsIncomeStatement();
			NetInterestIncome = new NetInterestIncomeIncomeStatement();
			NetInvestmentIncome = new NetInvestmentIncomeIncomeStatement();
			TotalRevenue = new TotalRevenueIncomeStatement();
			NonInterestExpense = new NonInterestExpenseIncomeStatement();
			NonInterestIncome = new NonInterestIncomeIncomeStatement();
			OperatingExpense = new OperatingExpenseIncomeStatement();
			OperatingIncome = new OperatingIncomeIncomeStatement();
			OperatingRevenue = new OperatingRevenueIncomeStatement();
			OtherIncomeExpense = new OtherIncomeExpenseIncomeStatement();
			PolicyAcquisitionExpense = new PolicyAcquisitionExpenseIncomeStatement();
			NetPolicyholderBenefitsAndClaims = new NetPolicyholderBenefitsAndClaimsIncomeStatement();
			PreferredStockDividends = new PreferredStockDividendsIncomeStatement();
			TotalPremiumsEarned = new TotalPremiumsEarnedIncomeStatement();
			PretaxIncome = new PretaxIncomeIncomeStatement();
			TaxProvision = new TaxProvisionIncomeStatement();
			CreditLossesProvision = new CreditLossesProvisionIncomeStatement();
			ResearchAndDevelopment = new ResearchAndDevelopmentIncomeStatement();
			SellingAndMarketingExpense = new SellingAndMarketingExpenseIncomeStatement();
			SellingGeneralAndAdministration = new SellingGeneralAndAdministrationIncomeStatement();
			SpecialIncomeCharges = new SpecialIncomeChargesIncomeStatement();
			TotalExpenses = new TotalExpensesIncomeStatement();
			AmortizationOfDeferredAcquisitionCosts = new AmortizationOfDeferredAcquisitionCostsIncomeStatement();
			InterestIncome = new InterestIncomeIncomeStatement();
			PropertyLiabilityInsuranceClaims = new PropertyLiabilityInsuranceClaimsIncomeStatement();
			EBIT = new EBITIncomeStatement();
			EBITDA = new EBITDAIncomeStatement();
			NetIncomeContinuousOperationsNetMinorityInterest = new NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement();
			AccretionOnPreferredStock = new AccretionOnPreferredStockIncomeStatement();
			AccruedPreferredStockDividends = new AccruedPreferredStockDividendsIncomeStatement();
			AcquiredInProcessRnD = new AcquiredInProcessRnDIncomeStatement();
			AcquisitionExpense = new AcquisitionExpenseIncomeStatement();
			AdministrativeExpense = new AdministrativeExpenseIncomeStatement();
			AgencyFees = new AgencyFeesIncomeStatement();
			AgencyFeesAndCommissions = new AgencyFeesAndCommissionsIncomeStatement();
			AllowancesForConstruction = new AllowancesForConstructionIncomeStatement();
			CapitalnBusinessTaxes = new CapitalnBusinessTaxesIncomeStatement();
			CededPremiums = new CededPremiumsIncomeStatement();
			CommissionExpenses = new CommissionExpensesIncomeStatement();
			CommissionRevenue = new CommissionRevenueIncomeStatement();
			CreditCard = new CreditCardIncomeStatement();
			DevelopmentExpense = new DevelopmentExpenseIncomeStatement();
			DividendIncome = new DividendIncomeIncomeStatement();
			EarningLossOfEquityInvestments = new EarningLossOfEquityInvestmentsIncomeStatement();
			EarningsFromEquityInterest = new EarningsFromEquityInterestIncomeStatement();
			ElectricRevenue = new ElectricRevenueIncomeStatement();
			Equipment = new EquipmentIncomeStatement();
			ExplorationDevelopmentAndMineralPropertyLeaseExpenses = new ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement();
			Fees = new FeesIncomeStatement();
			FeesAndCommissions = new FeesAndCommissionsIncomeStatement();
			ForeignExchangeTradingGains = new ForeignExchangeTradingGainsIncomeStatement();
			Fuel = new FuelIncomeStatement();
			FuelAndPurchasePower = new FuelAndPurchasePowerIncomeStatement();
			GainOnSaleOfBusiness = new GainOnSaleOfBusinessIncomeStatement();
			GainOnSaleOfPPE = new GainOnSaleOfPPEIncomeStatement();
			GainOnSaleOfSecurity = new GainOnSaleOfSecurityIncomeStatement();
			GainsLossOnDisposalOfDiscontinuedOperations = new GainsLossOnDisposalOfDiscontinuedOperationsIncomeStatement();
			GasRevenue = new GasRevenueIncomeStatement();
			GeneralAccountAssets = new GeneralAccountAssetsIncomeStatement();
			GeneralExpense = new GeneralExpenseIncomeStatement();
			GrossPremiumsWritten = new GrossPremiumsWrittenIncomeStatement();
			ImpairmentOfCapitalAssets = new ImpairmentOfCapitalAssetsIncomeStatement();
			OtherImpairmentOfCapitalAssets = new OtherImpairmentOfCapitalAssetsIncomeStatement();
			IncomeFromEquityMethodInvestments = new IncomeFromEquityMethodInvestmentsIncomeStatement();
			AcquiredInProcessRnDIncome = new AcquiredInProcessRnDIncomeIncomeStatement();
			RestructringAndMnAIncome = new RestructringAndMnAIncomeIncomeStatement();
			IncreaseDecreaseInNetUnearnedPremiumReserves = new IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement();
			InsuranceAndClaims = new InsuranceAndClaimsIncomeStatement();
			InsuranceAndPremiums = new InsuranceAndPremiumsIncomeStatement();
			InterestIncomeFromInterestBearingDeposits = new InterestIncomeFromInterestBearingDepositsIncomeStatement();
			InterestExpenseForCapitalizedLeaseObligations = new InterestExpenseForCapitalizedLeaseObligationsIncomeStatement();
			InterestExpenseForDeposit = new InterestExpenseForDepositIncomeStatement();
			InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell = new InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement();
			InterestExpenseForLongTermDebt = new InterestExpenseForLongTermDebtIncomeStatement();
			InterestExpenseForLongTermDebtAndCapitalSecurities = new InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement();
			InterestExpenseForShortTermDebt = new InterestExpenseForShortTermDebtIncomeStatement();
			InterestIncomeFromDeposits = new InterestIncomeFromDepositsIncomeStatement();
			InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell = new InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement();
			InterestIncomeFromInvestmentSecurities = new InterestIncomeFromInvestmentSecuritiesIncomeStatement();
			InterestIncomeFromLeases = new InterestIncomeFromLeasesIncomeStatement();
			InterestIncomeFromLoans = new InterestIncomeFromLoansIncomeStatement();
			InterestIncomeFromLoansAndLease = new InterestIncomeFromLoansAndLeaseIncomeStatement();
			InterestIncomeFromSecurities = new InterestIncomeFromSecuritiesIncomeStatement();
			InterestIncomeFromTradingAccountSecurities = new InterestIncomeFromTradingAccountSecuritiesIncomeStatement();
			InvestmentBankingProfit = new InvestmentBankingProfitIncomeStatement();
			LifeAnnuityPremiums = new LifeAnnuityPremiumsIncomeStatement();
			LoansHeldForResell = new LoansHeldForResellIncomeStatement();
			LossAndLossAdjustmentExpectedIncurred = new LossAndLossAdjustmentExpectedIncurredIncomeStatement();
			MaintenanceAndRepairs = new MaintenanceAndRepairsIncomeStatement();
			MarketingExpense = new MarketingExpenseIncomeStatement();
			InterestIncomeFromOtherMoneyMarketInvestments = new InterestIncomeFromOtherMoneyMarketInvestmentsIncomeStatement();
			NetForeignExchangeGainLoss = new NetForeignExchangeGainLossIncomeStatement();
			NetOccupancyExpense = new NetOccupancyExpenseIncomeStatement();
			NetPremiumsWritten = new NetPremiumsWrittenIncomeStatement();
			NetRealizedGainLossOnInvestments = new NetRealizedGainLossOnInvestmentsIncomeStatement();
			NonRecurringOperationExpense = new NonRecurringOperationExpenseIncomeStatement();
			OccupancyAndEquipment = new OccupancyAndEquipmentIncomeStatement();
			OperatingTaxesnLicenses = new OperatingTaxesnLicensesIncomeStatement();
			OperationAndMaintenance = new OperationAndMaintenanceIncomeStatement();
			OtherCustomerServices = new OtherCustomerServicesIncomeStatement();
			OtherGainLossFromDispositionOfDiscontinuedOperations = new OtherGainLossFromDispositionOfDiscontinuedOperationsIncomeStatement();
			OtherInterestExpense = new OtherInterestExpenseIncomeStatement();
			OtherInterestIncome = new OtherInterestIncomeIncomeStatement();
			OtherNonInterestExpense = new OtherNonInterestExpenseIncomeStatement();
			OtherOperatingRevenue = new OtherOperatingRevenueIncomeStatement();
			OtherSpecialCharges = new OtherSpecialChargesIncomeStatement();
			MiscOtherSpecialCharges = new MiscOtherSpecialChargesIncomeStatement();
			OtherTaxes = new OtherTaxesIncomeStatement();
			PolicyFees = new PolicyFeesIncomeStatement();
			PolicyholderBenefitsCeded = new PolicyholderBenefitsCededIncomeStatement();
			PolicyholderBenefitsGross = new PolicyholderBenefitsGrossIncomeStatement();
			PolicyholderDividends = new PolicyholderDividendsIncomeStatement();
			PolicyholderInterest = new PolicyholderInterestIncomeStatement();
			PolicyholderAndReinsurerAccounts = new PolicyholderAndReinsurerAccountsIncomeStatement();
			TrustPreferredSecurities = new TrustPreferredSecuritiesIncomeStatement();
			PrincipleTransactionRevenue = new PrincipleTransactionRevenueIncomeStatement();
			ProfessionalExpenseAndContractServicesExpense = new ProfessionalExpenseAndContractServicesExpenseIncomeStatement();
			PromotionAndAdvertising = new PromotionAndAdvertisingIncomeStatement();
			PropertyCasualtyPremiums = new PropertyCasualtyPremiumsIncomeStatement();
			ProvisionForDoubtfulAccounts = new ProvisionForDoubtfulAccountsIncomeStatement();
			ProvisionForGainLossOnDisposal = new ProvisionForGainLossOnDisposalIncomeStatement();
			PurchasedTransportationServices = new PurchasedTransportationServicesIncomeStatement();
			RealizedCapitalGain = new RealizedCapitalGainIncomeStatement();
			RentAndLandingFees = new RentAndLandingFeesIncomeStatement();
			ResearchExpense = new ResearchExpenseIncomeStatement();
			RestructuringAndMergernAcquisition = new RestructuringAndMergernAcquisitionIncomeStatement();
			RevenuesCargo = new RevenuesCargoIncomeStatement();
			RevenuesPassenger = new RevenuesPassengerIncomeStatement();
			SalariesAndWages = new SalariesAndWagesIncomeStatement();
			SecuritiesActivities = new SecuritiesActivitiesIncomeStatement();
			SellingExpense = new SellingExpenseIncomeStatement();
			ServiceChargeOnDepositorAccounts = new ServiceChargeOnDepositorAccountsIncomeStatement();
			ShareInNetIncomeOfUnconsolidatedEntities = new ShareInNetIncomeOfUnconsolidatedEntitiesIncomeStatement();
			TimeDepositsPlaced = new TimeDepositsPlacedIncomeStatement();
			TradingGainLoss = new TradingGainLossIncomeStatement();
			TransportationRevenue = new TransportationRevenueIncomeStatement();
			TrustFeesbyCommissions = new TrustFeesbyCommissionsIncomeStatement();
			UnderwritingExpenses = new UnderwritingExpensesIncomeStatement();
			WriteDown = new WriteDownIncomeStatement();
			OtherWriteDown = new OtherWriteDownIncomeStatement();
			WriteOff = new WriteOffIncomeStatement();
			OtherWriteOff = new OtherWriteOffIncomeStatement();
			OtherNonInterestIncome = new OtherNonInterestIncomeIncomeStatement();
			PremiumTaxesCredit = new PremiumTaxesCreditIncomeStatement();
			AmortizationOfIntangibles = new AmortizationOfIntangiblesIncomeStatement();
			NetIncomeFromContinuingAndDiscontinuedOperation = new NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement();
			NetIncomeFromOtherGainsLosses = new NetIncomeFromOtherGainsLossesIncomeStatement();
			NetIncomeFromTaxLossCarryforward = new NetIncomeFromTaxLossCarryforwardIncomeStatement();
			OtherOperatingExpenses = new OtherOperatingExpensesIncomeStatement();
			TotalMoneyMarketInvestments = new TotalMoneyMarketInvestmentsIncomeStatement();
			ReconciledCostOfRevenue = new ReconciledCostOfRevenueIncomeStatement();
			ReconciledDepreciation = new ReconciledDepreciationIncomeStatement();
			NormalizedIncome = new NormalizedIncomeIncomeStatement();
			NonOperatingExpenses = new NonOperatingExpensesIncomeStatement();
			NonOperatingIncome = new NonOperatingIncomeIncomeStatement();
			NetIncomeFromContinuingOperationNetMinorityInterest = new NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement();
			PrincipleInvestmentGainLoss = new PrincipleInvestmentGainLossIncomeStatement();
			GainLossonSaleofAssets = new GainLossonSaleofAssetsIncomeStatement();
			GainonSaleofLoans = new GainonSaleofLoansIncomeStatement();
			GainonSaleofInvestmentProperty = new GainonSaleofInvestmentPropertyIncomeStatement();
			SpecialIncome = new SpecialIncomeIncomeStatement();
			AcquiredinProcessRnDIncomeBanks = new AcquiredinProcessRnDIncomeBanksIncomeStatement();
			RestructuringAndMergerAndAcquisitionIncome = new RestructuringAndMergerAndAcquisitionIncomeIncomeStatement();
			ImpairmentofCapitalAssetsIncome = new ImpairmentofCapitalAssetsIncomeIncomeStatement();
			GainonExtinguishmentofDebt = new GainonExtinguishmentofDebtIncomeStatement();
			SpecialCharge = new SpecialChargeIncomeStatement();
			LossonExtinguishmentofDebt = new LossonExtinguishmentofDebtIncomeStatement();
			EarningsfromEquityInterestNetOfTax = new EarningsfromEquityInterestNetOfTaxIncomeStatement();
			NetIncomeIncludingNoncontrollingInterests = new NetIncomeIncludingNoncontrollingInterestsIncomeStatement();
			OtherunderPreferredStockDividend = new OtherunderPreferredStockDividendIncomeStatement();
			EarningsfromEquityInterestRevenue = new EarningsfromEquityInterestRevenueIncomeStatement();
			GainLossfromDisposalSaleofAssets = new GainLossfromDisposalSaleofAssetsIncomeStatement();
			GainLossfromDisposalSaleofAssetsOther = new GainLossfromDisposalSaleofAssetsOtherIncomeStatement();
			GainonSaleofOtherRealEstateOwned = new GainonSaleofOtherRealEstateOwnedIncomeStatement();
			InterestIncomeRevenue = new InterestIncomeRevenueIncomeStatement();
			LitigationExpense = new LitigationExpenseIncomeStatement();
			OtherthanTemporaryImpairmentLossesInvestments = new OtherthanTemporaryImpairmentLossesInvestmentsIncomeStatement();
			UnrealizedGainorLoss = new UnrealizedGainorLossIncomeStatement();
			ChangesinInventoriesofFinishedGoodsandWorkinProgress = new ChangesinInventoriesofFinishedGoodsandWorkinProgressIncomeStatement();
			WorkPerformedbyEntityandCapitalized = new WorkPerformedbyEntityandCapitalizedIncomeStatement();
			DistributionCosts = new DistributionCostsIncomeStatement();
			StaffCosts = new StaffCostsIncomeStatement();
			SocialSecurityCosts = new SocialSecurityCostsIncomeStatement();
			PensionCosts = new PensionCostsIncomeStatement();
			OtherOperatingIncomeTotal = new OtherOperatingIncomeTotalIncomeStatement();
			ShareofOperatingProfitLossfromJointVenturesAndAssociates = new ShareofOperatingProfitLossfromJointVenturesAndAssociatesIncomeStatement();
			ExceptionalItems = new ExceptionalItemsIncomeStatement();
			IncomefromSharesinSubsidiariesGroupUndertakings = new IncomefromSharesinSubsidiariesGroupUndertakingsIncomeStatement();
			IncomefromAssociatesandOtherParticipatingInterests = new IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement();
			TotalOtherFinanceCost = new TotalOtherFinanceCostIncomeStatement();
			GrossDividendPayment = new GrossDividendPaymentIncomeStatement();
			InterestandSimilarIncome = new InterestandSimilarIncomeIncomeStatement();
			FeesandCommissionIncome = new FeesandCommissionIncomeIncomeStatement();
			FeesandCommissionExpense = new FeesandCommissionExpenseIncomeStatement();
			NetTradingIncome = new NetTradingIncomeIncomeStatement();
			OutwardReinsurancePremiums = new OutwardReinsurancePremiumsIncomeStatement();
			OtherStaffCosts = new OtherStaffCostsIncomeStatement();
			ShareBasedPayments = new ShareBasedPaymentsIncomeStatement();
			GainonInvestmentProperties = new GainonInvestmentPropertiesIncomeStatement();
			AverageDilutionEarnings = new AverageDilutionEarningsIncomeStatement();
			GainonRedemptionandExtinguishmentofDebt = new GainonRedemptionandExtinguishmentofDebtIncomeStatement();
			MiscellaneousOtherOperatingIncome = new MiscellaneousOtherOperatingIncomeIncomeStatement();
			GainLossonFinancialInstrumentsDesignatedasCashFlowHedges = new GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement();
			GainLossonDerecognitionofAvailableForSaleFinancialAssets = new GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement();
			GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotal = new GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotalIncomeStatement();
			NegativeGoodwillImmediatelyRecognized = new NegativeGoodwillImmediatelyRecognizedIncomeStatement();
			GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal = new GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement();
			ImpairmentLossesReversalsFinancialInstrumentsNet = new ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement();
			ShareofProfitLossfromEquityAccountedInvestments = new ShareofProfitLossfromEquityAccountedInvestmentsIncomeStatement();
			ClaimsandPaidIncurred = new ClaimsandPaidIncurredIncomeStatement();
			ReinsuranceRecoveriesClaimsandBenefits = new ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement();
			ChangeinInsuranceLiabilitiesNetofReinsurance = new ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement();
			ChangeinInvestmentContract = new ChangeinInvestmentContractIncomeStatement();
			ChangeinReinsuranceAssets = new ChangeinReinsuranceAssetsIncomeStatement();
			CreditRiskProvisions = new CreditRiskProvisionsIncomeStatement();
			WagesandSalaries = new WagesandSalariesIncomeStatement();
			OtherNonOperatingIncomeExpenses = new OtherNonOperatingIncomeExpensesIncomeStatement();
			InterestIncomeOtherOperatingIncome = new InterestIncomeOtherOperatingIncomeIncomeStatement();
			OtherNonOperatingIncome = new OtherNonOperatingIncomeIncomeStatement();
			OtherNonOperatingExpenses = new OtherNonOperatingExpensesIncomeStatement();
			TotalUnusualItems = new TotalUnusualItemsIncomeStatement();
			TotalUnusualItemsExcludingGoodwill = new TotalUnusualItemsExcludingGoodwillIncomeStatement();
			TaxRateForCalcs = new TaxRateForCalcsIncomeStatement();
			TaxEffectOfUnusualItems = new TaxEffectOfUnusualItemsIncomeStatement();
			NormalizedEBITDA = new NormalizedEBITDAIncomeStatement();
			GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCosts = new GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCostsIncomeStatement();
			StockBasedCompensation = new StockBasedCompensationIncomeStatement();
			DilutedNIAvailtoComStockholders = new DilutedNIAvailtoComStockholdersIncomeStatement();
			InvestmentContractLiabilitiesIncurred = new InvestmentContractLiabilitiesIncurredIncomeStatement();
			ReinsuranceRecoveriesofInvestmentContract = new ReinsuranceRecoveriesofInvestmentContractIncomeStatement();
			TotalDividendPaymentofEquityShares = new TotalDividendPaymentofEquitySharesIncomeStatement();
			TotalDividendPaymentofNonEquityShares = new TotalDividendPaymentofNonEquitySharesIncomeStatement();
			ChangeinTheGrossProvisionforUnearnedPremiums = new ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement();
			ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare = new ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement();
			ClaimsandChangeinInsuranceLiabilities = new ClaimsandChangeinInsuranceLiabilitiesIncomeStatement();
			ReinsuranceRecoveriesofInsuranceLiabilities = new ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement();
		}

		/// <summary>
		/// Sets values for non existing periods from a previous instance
		/// </summary>
		/// <remarks>Used to fill-forward values from previous dates</remarks>
		/// <param name="previous">The previous instance</param>
		public void UpdateValues(IncomeStatement previous)
		{
			if (previous == null) return;

			if (Amortization != null) Amortization.UpdateValues(previous.Amortization);
			if (SecuritiesAmortization != null) SecuritiesAmortization.UpdateValues(previous.SecuritiesAmortization);
			if (CostOfRevenue != null) CostOfRevenue.UpdateValues(previous.CostOfRevenue);
			if (CumulativeEffectOfAccountingChange != null) CumulativeEffectOfAccountingChange.UpdateValues(previous.CumulativeEffectOfAccountingChange);
			if (Depletion != null) Depletion.UpdateValues(previous.Depletion);
			if (Depreciation != null) Depreciation.UpdateValues(previous.Depreciation);
			if (DepreciationAndAmortization != null) DepreciationAndAmortization.UpdateValues(previous.DepreciationAndAmortization);
			if (DepreciationAmortizationDepletion != null) DepreciationAmortizationDepletion.UpdateValues(previous.DepreciationAmortizationDepletion);
			if (NetIncomeDiscontinuousOperations != null) NetIncomeDiscontinuousOperations.UpdateValues(previous.NetIncomeDiscontinuousOperations);
			if (ExciseTaxes != null) ExciseTaxes.UpdateValues(previous.ExciseTaxes);
			if (NetIncomeExtraordinary != null) NetIncomeExtraordinary.UpdateValues(previous.NetIncomeExtraordinary);
			if (FeeRevenueAndOtherIncome != null) FeeRevenueAndOtherIncome.UpdateValues(previous.FeeRevenueAndOtherIncome);
			if (GeneralAndAdministrativeExpense != null) GeneralAndAdministrativeExpense.UpdateValues(previous.GeneralAndAdministrativeExpense);
			if (GrossProfit != null) GrossProfit.UpdateValues(previous.GrossProfit);
			if (InterestExpense != null) InterestExpense.UpdateValues(previous.InterestExpense);
			if (InterestExpenseNonOperating != null) InterestExpenseNonOperating.UpdateValues(previous.InterestExpenseNonOperating);
			if (InterestExpenseOperating != null) InterestExpenseOperating.UpdateValues(previous.InterestExpenseOperating);
			if (InterestIncomeAfterProvisionForLoanLoss != null) InterestIncomeAfterProvisionForLoanLoss.UpdateValues(previous.InterestIncomeAfterProvisionForLoanLoss);
			if (InterestIncomeNonOperating != null) InterestIncomeNonOperating.UpdateValues(previous.InterestIncomeNonOperating);
			if (InterestIncomeOperating != null) InterestIncomeOperating.UpdateValues(previous.InterestIncomeOperating);
			if (NetNonOperatingInterestIncomeExpense != null) NetNonOperatingInterestIncomeExpense.UpdateValues(previous.NetNonOperatingInterestIncomeExpense);
			if (NetOperatingInterestIncomeExpense != null) NetOperatingInterestIncomeExpense.UpdateValues(previous.NetOperatingInterestIncomeExpense);
			if (LossAdjustmentExpense != null) LossAdjustmentExpense.UpdateValues(previous.LossAdjustmentExpense);
			if (MinorityInterests != null) MinorityInterests.UpdateValues(previous.MinorityInterests);
			if (NetIncome != null) NetIncome.UpdateValues(previous.NetIncome);
			if (NetIncomeCommonStockholders != null) NetIncomeCommonStockholders.UpdateValues(previous.NetIncomeCommonStockholders);
			if (NetIncomeContinuousOperations != null) NetIncomeContinuousOperations.UpdateValues(previous.NetIncomeContinuousOperations);
			if (NetInterestIncome != null) NetInterestIncome.UpdateValues(previous.NetInterestIncome);
			if (NetInvestmentIncome != null) NetInvestmentIncome.UpdateValues(previous.NetInvestmentIncome);
			if (TotalRevenue != null) TotalRevenue.UpdateValues(previous.TotalRevenue);
			if (NonInterestExpense != null) NonInterestExpense.UpdateValues(previous.NonInterestExpense);
			if (NonInterestIncome != null) NonInterestIncome.UpdateValues(previous.NonInterestIncome);
			if (OperatingExpense != null) OperatingExpense.UpdateValues(previous.OperatingExpense);
			if (OperatingIncome != null) OperatingIncome.UpdateValues(previous.OperatingIncome);
			if (OperatingRevenue != null) OperatingRevenue.UpdateValues(previous.OperatingRevenue);
			if (OtherIncomeExpense != null) OtherIncomeExpense.UpdateValues(previous.OtherIncomeExpense);
			if (PolicyAcquisitionExpense != null) PolicyAcquisitionExpense.UpdateValues(previous.PolicyAcquisitionExpense);
			if (NetPolicyholderBenefitsAndClaims != null) NetPolicyholderBenefitsAndClaims.UpdateValues(previous.NetPolicyholderBenefitsAndClaims);
			if (PreferredStockDividends != null) PreferredStockDividends.UpdateValues(previous.PreferredStockDividends);
			if (TotalPremiumsEarned != null) TotalPremiumsEarned.UpdateValues(previous.TotalPremiumsEarned);
			if (PretaxIncome != null) PretaxIncome.UpdateValues(previous.PretaxIncome);
			if (TaxProvision != null) TaxProvision.UpdateValues(previous.TaxProvision);
			if (CreditLossesProvision != null) CreditLossesProvision.UpdateValues(previous.CreditLossesProvision);
			if (ResearchAndDevelopment != null) ResearchAndDevelopment.UpdateValues(previous.ResearchAndDevelopment);
			if (SellingAndMarketingExpense != null) SellingAndMarketingExpense.UpdateValues(previous.SellingAndMarketingExpense);
			if (SellingGeneralAndAdministration != null) SellingGeneralAndAdministration.UpdateValues(previous.SellingGeneralAndAdministration);
			if (SpecialIncomeCharges != null) SpecialIncomeCharges.UpdateValues(previous.SpecialIncomeCharges);
			if (TotalExpenses != null) TotalExpenses.UpdateValues(previous.TotalExpenses);
			if (AmortizationOfDeferredAcquisitionCosts != null) AmortizationOfDeferredAcquisitionCosts.UpdateValues(previous.AmortizationOfDeferredAcquisitionCosts);
			if (InterestIncome != null) InterestIncome.UpdateValues(previous.InterestIncome);
			if (PropertyLiabilityInsuranceClaims != null) PropertyLiabilityInsuranceClaims.UpdateValues(previous.PropertyLiabilityInsuranceClaims);
			if (EBIT != null) EBIT.UpdateValues(previous.EBIT);
			if (EBITDA != null) EBITDA.UpdateValues(previous.EBITDA);
			if (NetIncomeContinuousOperationsNetMinorityInterest != null) NetIncomeContinuousOperationsNetMinorityInterest.UpdateValues(previous.NetIncomeContinuousOperationsNetMinorityInterest);
			if (AccretionOnPreferredStock != null) AccretionOnPreferredStock.UpdateValues(previous.AccretionOnPreferredStock);
			if (AccruedPreferredStockDividends != null) AccruedPreferredStockDividends.UpdateValues(previous.AccruedPreferredStockDividends);
			if (AcquiredInProcessRnD != null) AcquiredInProcessRnD.UpdateValues(previous.AcquiredInProcessRnD);
			if (AcquisitionExpense != null) AcquisitionExpense.UpdateValues(previous.AcquisitionExpense);
			if (AdministrativeExpense != null) AdministrativeExpense.UpdateValues(previous.AdministrativeExpense);
			if (AgencyFees != null) AgencyFees.UpdateValues(previous.AgencyFees);
			if (AgencyFeesAndCommissions != null) AgencyFeesAndCommissions.UpdateValues(previous.AgencyFeesAndCommissions);
			if (AllowancesForConstruction != null) AllowancesForConstruction.UpdateValues(previous.AllowancesForConstruction);
			if (CapitalnBusinessTaxes != null) CapitalnBusinessTaxes.UpdateValues(previous.CapitalnBusinessTaxes);
			if (CededPremiums != null) CededPremiums.UpdateValues(previous.CededPremiums);
			if (CommissionExpenses != null) CommissionExpenses.UpdateValues(previous.CommissionExpenses);
			if (CommissionRevenue != null) CommissionRevenue.UpdateValues(previous.CommissionRevenue);
			if (CreditCard != null) CreditCard.UpdateValues(previous.CreditCard);
			if (DevelopmentExpense != null) DevelopmentExpense.UpdateValues(previous.DevelopmentExpense);
			if (DividendIncome != null) DividendIncome.UpdateValues(previous.DividendIncome);
			if (EarningLossOfEquityInvestments != null) EarningLossOfEquityInvestments.UpdateValues(previous.EarningLossOfEquityInvestments);
			if (EarningsFromEquityInterest != null) EarningsFromEquityInterest.UpdateValues(previous.EarningsFromEquityInterest);
			if (ElectricRevenue != null) ElectricRevenue.UpdateValues(previous.ElectricRevenue);
			if (Equipment != null) Equipment.UpdateValues(previous.Equipment);
			if (ExplorationDevelopmentAndMineralPropertyLeaseExpenses != null) ExplorationDevelopmentAndMineralPropertyLeaseExpenses.UpdateValues(previous.ExplorationDevelopmentAndMineralPropertyLeaseExpenses);
			if (Fees != null) Fees.UpdateValues(previous.Fees);
			if (FeesAndCommissions != null) FeesAndCommissions.UpdateValues(previous.FeesAndCommissions);
			if (ForeignExchangeTradingGains != null) ForeignExchangeTradingGains.UpdateValues(previous.ForeignExchangeTradingGains);
			if (Fuel != null) Fuel.UpdateValues(previous.Fuel);
			if (FuelAndPurchasePower != null) FuelAndPurchasePower.UpdateValues(previous.FuelAndPurchasePower);
			if (GainOnSaleOfBusiness != null) GainOnSaleOfBusiness.UpdateValues(previous.GainOnSaleOfBusiness);
			if (GainOnSaleOfPPE != null) GainOnSaleOfPPE.UpdateValues(previous.GainOnSaleOfPPE);
			if (GainOnSaleOfSecurity != null) GainOnSaleOfSecurity.UpdateValues(previous.GainOnSaleOfSecurity);
			if (GainsLossOnDisposalOfDiscontinuedOperations != null) GainsLossOnDisposalOfDiscontinuedOperations.UpdateValues(previous.GainsLossOnDisposalOfDiscontinuedOperations);
			if (GasRevenue != null) GasRevenue.UpdateValues(previous.GasRevenue);
			if (GeneralAccountAssets != null) GeneralAccountAssets.UpdateValues(previous.GeneralAccountAssets);
			if (GeneralExpense != null) GeneralExpense.UpdateValues(previous.GeneralExpense);
			if (GrossPremiumsWritten != null) GrossPremiumsWritten.UpdateValues(previous.GrossPremiumsWritten);
			if (ImpairmentOfCapitalAssets != null) ImpairmentOfCapitalAssets.UpdateValues(previous.ImpairmentOfCapitalAssets);
			if (OtherImpairmentOfCapitalAssets != null) OtherImpairmentOfCapitalAssets.UpdateValues(previous.OtherImpairmentOfCapitalAssets);
			if (IncomeFromEquityMethodInvestments != null) IncomeFromEquityMethodInvestments.UpdateValues(previous.IncomeFromEquityMethodInvestments);
			if (AcquiredInProcessRnDIncome != null) AcquiredInProcessRnDIncome.UpdateValues(previous.AcquiredInProcessRnDIncome);
			if (RestructringAndMnAIncome != null) RestructringAndMnAIncome.UpdateValues(previous.RestructringAndMnAIncome);
			if (IncreaseDecreaseInNetUnearnedPremiumReserves != null) IncreaseDecreaseInNetUnearnedPremiumReserves.UpdateValues(previous.IncreaseDecreaseInNetUnearnedPremiumReserves);
			if (InsuranceAndClaims != null) InsuranceAndClaims.UpdateValues(previous.InsuranceAndClaims);
			if (InsuranceAndPremiums != null) InsuranceAndPremiums.UpdateValues(previous.InsuranceAndPremiums);
			if (InterestIncomeFromInterestBearingDeposits != null) InterestIncomeFromInterestBearingDeposits.UpdateValues(previous.InterestIncomeFromInterestBearingDeposits);
			if (InterestExpenseForCapitalizedLeaseObligations != null) InterestExpenseForCapitalizedLeaseObligations.UpdateValues(previous.InterestExpenseForCapitalizedLeaseObligations);
			if (InterestExpenseForDeposit != null) InterestExpenseForDeposit.UpdateValues(previous.InterestExpenseForDeposit);
			if (InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell != null) InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell.UpdateValues(previous.InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell);
			if (InterestExpenseForLongTermDebt != null) InterestExpenseForLongTermDebt.UpdateValues(previous.InterestExpenseForLongTermDebt);
			if (InterestExpenseForLongTermDebtAndCapitalSecurities != null) InterestExpenseForLongTermDebtAndCapitalSecurities.UpdateValues(previous.InterestExpenseForLongTermDebtAndCapitalSecurities);
			if (InterestExpenseForShortTermDebt != null) InterestExpenseForShortTermDebt.UpdateValues(previous.InterestExpenseForShortTermDebt);
			if (InterestIncomeFromDeposits != null) InterestIncomeFromDeposits.UpdateValues(previous.InterestIncomeFromDeposits);
			if (InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell != null) InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell.UpdateValues(previous.InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell);
			if (InterestIncomeFromInvestmentSecurities != null) InterestIncomeFromInvestmentSecurities.UpdateValues(previous.InterestIncomeFromInvestmentSecurities);
			if (InterestIncomeFromLeases != null) InterestIncomeFromLeases.UpdateValues(previous.InterestIncomeFromLeases);
			if (InterestIncomeFromLoans != null) InterestIncomeFromLoans.UpdateValues(previous.InterestIncomeFromLoans);
			if (InterestIncomeFromLoansAndLease != null) InterestIncomeFromLoansAndLease.UpdateValues(previous.InterestIncomeFromLoansAndLease);
			if (InterestIncomeFromSecurities != null) InterestIncomeFromSecurities.UpdateValues(previous.InterestIncomeFromSecurities);
			if (InterestIncomeFromTradingAccountSecurities != null) InterestIncomeFromTradingAccountSecurities.UpdateValues(previous.InterestIncomeFromTradingAccountSecurities);
			if (InvestmentBankingProfit != null) InvestmentBankingProfit.UpdateValues(previous.InvestmentBankingProfit);
			if (LifeAnnuityPremiums != null) LifeAnnuityPremiums.UpdateValues(previous.LifeAnnuityPremiums);
			if (LoansHeldForResell != null) LoansHeldForResell.UpdateValues(previous.LoansHeldForResell);
			if (LossAndLossAdjustmentExpectedIncurred != null) LossAndLossAdjustmentExpectedIncurred.UpdateValues(previous.LossAndLossAdjustmentExpectedIncurred);
			if (MaintenanceAndRepairs != null) MaintenanceAndRepairs.UpdateValues(previous.MaintenanceAndRepairs);
			if (MarketingExpense != null) MarketingExpense.UpdateValues(previous.MarketingExpense);
			if (InterestIncomeFromOtherMoneyMarketInvestments != null) InterestIncomeFromOtherMoneyMarketInvestments.UpdateValues(previous.InterestIncomeFromOtherMoneyMarketInvestments);
			if (NetForeignExchangeGainLoss != null) NetForeignExchangeGainLoss.UpdateValues(previous.NetForeignExchangeGainLoss);
			if (NetOccupancyExpense != null) NetOccupancyExpense.UpdateValues(previous.NetOccupancyExpense);
			if (NetPremiumsWritten != null) NetPremiumsWritten.UpdateValues(previous.NetPremiumsWritten);
			if (NetRealizedGainLossOnInvestments != null) NetRealizedGainLossOnInvestments.UpdateValues(previous.NetRealizedGainLossOnInvestments);
			if (NonRecurringOperationExpense != null) NonRecurringOperationExpense.UpdateValues(previous.NonRecurringOperationExpense);
			if (OccupancyAndEquipment != null) OccupancyAndEquipment.UpdateValues(previous.OccupancyAndEquipment);
			if (OperatingTaxesnLicenses != null) OperatingTaxesnLicenses.UpdateValues(previous.OperatingTaxesnLicenses);
			if (OperationAndMaintenance != null) OperationAndMaintenance.UpdateValues(previous.OperationAndMaintenance);
			if (OtherCustomerServices != null) OtherCustomerServices.UpdateValues(previous.OtherCustomerServices);
			if (OtherGainLossFromDispositionOfDiscontinuedOperations != null) OtherGainLossFromDispositionOfDiscontinuedOperations.UpdateValues(previous.OtherGainLossFromDispositionOfDiscontinuedOperations);
			if (OtherInterestExpense != null) OtherInterestExpense.UpdateValues(previous.OtherInterestExpense);
			if (OtherInterestIncome != null) OtherInterestIncome.UpdateValues(previous.OtherInterestIncome);
			if (OtherNonInterestExpense != null) OtherNonInterestExpense.UpdateValues(previous.OtherNonInterestExpense);
			if (OtherOperatingRevenue != null) OtherOperatingRevenue.UpdateValues(previous.OtherOperatingRevenue);
			if (OtherSpecialCharges != null) OtherSpecialCharges.UpdateValues(previous.OtherSpecialCharges);
			if (MiscOtherSpecialCharges != null) MiscOtherSpecialCharges.UpdateValues(previous.MiscOtherSpecialCharges);
			if (OtherTaxes != null) OtherTaxes.UpdateValues(previous.OtherTaxes);
			if (PolicyFees != null) PolicyFees.UpdateValues(previous.PolicyFees);
			if (PolicyholderBenefitsCeded != null) PolicyholderBenefitsCeded.UpdateValues(previous.PolicyholderBenefitsCeded);
			if (PolicyholderBenefitsGross != null) PolicyholderBenefitsGross.UpdateValues(previous.PolicyholderBenefitsGross);
			if (PolicyholderDividends != null) PolicyholderDividends.UpdateValues(previous.PolicyholderDividends);
			if (PolicyholderInterest != null) PolicyholderInterest.UpdateValues(previous.PolicyholderInterest);
			if (PolicyholderAndReinsurerAccounts != null) PolicyholderAndReinsurerAccounts.UpdateValues(previous.PolicyholderAndReinsurerAccounts);
			if (TrustPreferredSecurities != null) TrustPreferredSecurities.UpdateValues(previous.TrustPreferredSecurities);
			if (PrincipleTransactionRevenue != null) PrincipleTransactionRevenue.UpdateValues(previous.PrincipleTransactionRevenue);
			if (ProfessionalExpenseAndContractServicesExpense != null) ProfessionalExpenseAndContractServicesExpense.UpdateValues(previous.ProfessionalExpenseAndContractServicesExpense);
			if (PromotionAndAdvertising != null) PromotionAndAdvertising.UpdateValues(previous.PromotionAndAdvertising);
			if (PropertyCasualtyPremiums != null) PropertyCasualtyPremiums.UpdateValues(previous.PropertyCasualtyPremiums);
			if (ProvisionForDoubtfulAccounts != null) ProvisionForDoubtfulAccounts.UpdateValues(previous.ProvisionForDoubtfulAccounts);
			if (ProvisionForGainLossOnDisposal != null) ProvisionForGainLossOnDisposal.UpdateValues(previous.ProvisionForGainLossOnDisposal);
			if (PurchasedTransportationServices != null) PurchasedTransportationServices.UpdateValues(previous.PurchasedTransportationServices);
			if (RealizedCapitalGain != null) RealizedCapitalGain.UpdateValues(previous.RealizedCapitalGain);
			if (RentAndLandingFees != null) RentAndLandingFees.UpdateValues(previous.RentAndLandingFees);
			if (ResearchExpense != null) ResearchExpense.UpdateValues(previous.ResearchExpense);
			if (RestructuringAndMergernAcquisition != null) RestructuringAndMergernAcquisition.UpdateValues(previous.RestructuringAndMergernAcquisition);
			if (RevenuesCargo != null) RevenuesCargo.UpdateValues(previous.RevenuesCargo);
			if (RevenuesPassenger != null) RevenuesPassenger.UpdateValues(previous.RevenuesPassenger);
			if (SalariesAndWages != null) SalariesAndWages.UpdateValues(previous.SalariesAndWages);
			if (SecuritiesActivities != null) SecuritiesActivities.UpdateValues(previous.SecuritiesActivities);
			if (SellingExpense != null) SellingExpense.UpdateValues(previous.SellingExpense);
			if (ServiceChargeOnDepositorAccounts != null) ServiceChargeOnDepositorAccounts.UpdateValues(previous.ServiceChargeOnDepositorAccounts);
			if (ShareInNetIncomeOfUnconsolidatedEntities != null) ShareInNetIncomeOfUnconsolidatedEntities.UpdateValues(previous.ShareInNetIncomeOfUnconsolidatedEntities);
			if (TimeDepositsPlaced != null) TimeDepositsPlaced.UpdateValues(previous.TimeDepositsPlaced);
			if (TradingGainLoss != null) TradingGainLoss.UpdateValues(previous.TradingGainLoss);
			if (TransportationRevenue != null) TransportationRevenue.UpdateValues(previous.TransportationRevenue);
			if (TrustFeesbyCommissions != null) TrustFeesbyCommissions.UpdateValues(previous.TrustFeesbyCommissions);
			if (UnderwritingExpenses != null) UnderwritingExpenses.UpdateValues(previous.UnderwritingExpenses);
			if (WriteDown != null) WriteDown.UpdateValues(previous.WriteDown);
			if (OtherWriteDown != null) OtherWriteDown.UpdateValues(previous.OtherWriteDown);
			if (WriteOff != null) WriteOff.UpdateValues(previous.WriteOff);
			if (OtherWriteOff != null) OtherWriteOff.UpdateValues(previous.OtherWriteOff);
			if (OtherNonInterestIncome != null) OtherNonInterestIncome.UpdateValues(previous.OtherNonInterestIncome);
			if (PremiumTaxesCredit != null) PremiumTaxesCredit.UpdateValues(previous.PremiumTaxesCredit);
			if (AmortizationOfIntangibles != null) AmortizationOfIntangibles.UpdateValues(previous.AmortizationOfIntangibles);
			if (NetIncomeFromContinuingAndDiscontinuedOperation != null) NetIncomeFromContinuingAndDiscontinuedOperation.UpdateValues(previous.NetIncomeFromContinuingAndDiscontinuedOperation);
			if (NetIncomeFromOtherGainsLosses != null) NetIncomeFromOtherGainsLosses.UpdateValues(previous.NetIncomeFromOtherGainsLosses);
			if (NetIncomeFromTaxLossCarryforward != null) NetIncomeFromTaxLossCarryforward.UpdateValues(previous.NetIncomeFromTaxLossCarryforward);
			if (OtherOperatingExpenses != null) OtherOperatingExpenses.UpdateValues(previous.OtherOperatingExpenses);
			if (TotalMoneyMarketInvestments != null) TotalMoneyMarketInvestments.UpdateValues(previous.TotalMoneyMarketInvestments);
			if (ReconciledCostOfRevenue != null) ReconciledCostOfRevenue.UpdateValues(previous.ReconciledCostOfRevenue);
			if (ReconciledDepreciation != null) ReconciledDepreciation.UpdateValues(previous.ReconciledDepreciation);
			if (NormalizedIncome != null) NormalizedIncome.UpdateValues(previous.NormalizedIncome);
			if (NonOperatingExpenses != null) NonOperatingExpenses.UpdateValues(previous.NonOperatingExpenses);
			if (NonOperatingIncome != null) NonOperatingIncome.UpdateValues(previous.NonOperatingIncome);
			if (NetIncomeFromContinuingOperationNetMinorityInterest != null) NetIncomeFromContinuingOperationNetMinorityInterest.UpdateValues(previous.NetIncomeFromContinuingOperationNetMinorityInterest);
			if (PrincipleInvestmentGainLoss != null) PrincipleInvestmentGainLoss.UpdateValues(previous.PrincipleInvestmentGainLoss);
			if (GainLossonSaleofAssets != null) GainLossonSaleofAssets.UpdateValues(previous.GainLossonSaleofAssets);
			if (GainonSaleofLoans != null) GainonSaleofLoans.UpdateValues(previous.GainonSaleofLoans);
			if (GainonSaleofInvestmentProperty != null) GainonSaleofInvestmentProperty.UpdateValues(previous.GainonSaleofInvestmentProperty);
			if (SpecialIncome != null) SpecialIncome.UpdateValues(previous.SpecialIncome);
			if (AcquiredinProcessRnDIncomeBanks != null) AcquiredinProcessRnDIncomeBanks.UpdateValues(previous.AcquiredinProcessRnDIncomeBanks);
			if (RestructuringAndMergerAndAcquisitionIncome != null) RestructuringAndMergerAndAcquisitionIncome.UpdateValues(previous.RestructuringAndMergerAndAcquisitionIncome);
			if (ImpairmentofCapitalAssetsIncome != null) ImpairmentofCapitalAssetsIncome.UpdateValues(previous.ImpairmentofCapitalAssetsIncome);
			if (GainonExtinguishmentofDebt != null) GainonExtinguishmentofDebt.UpdateValues(previous.GainonExtinguishmentofDebt);
			if (SpecialCharge != null) SpecialCharge.UpdateValues(previous.SpecialCharge);
			if (LossonExtinguishmentofDebt != null) LossonExtinguishmentofDebt.UpdateValues(previous.LossonExtinguishmentofDebt);
			if (EarningsfromEquityInterestNetOfTax != null) EarningsfromEquityInterestNetOfTax.UpdateValues(previous.EarningsfromEquityInterestNetOfTax);
			if (NetIncomeIncludingNoncontrollingInterests != null) NetIncomeIncludingNoncontrollingInterests.UpdateValues(previous.NetIncomeIncludingNoncontrollingInterests);
			if (OtherunderPreferredStockDividend != null) OtherunderPreferredStockDividend.UpdateValues(previous.OtherunderPreferredStockDividend);
			if (EarningsfromEquityInterestRevenue != null) EarningsfromEquityInterestRevenue.UpdateValues(previous.EarningsfromEquityInterestRevenue);
			if (GainLossfromDisposalSaleofAssets != null) GainLossfromDisposalSaleofAssets.UpdateValues(previous.GainLossfromDisposalSaleofAssets);
			if (GainLossfromDisposalSaleofAssetsOther != null) GainLossfromDisposalSaleofAssetsOther.UpdateValues(previous.GainLossfromDisposalSaleofAssetsOther);
			if (GainonSaleofOtherRealEstateOwned != null) GainonSaleofOtherRealEstateOwned.UpdateValues(previous.GainonSaleofOtherRealEstateOwned);
			if (InterestIncomeRevenue != null) InterestIncomeRevenue.UpdateValues(previous.InterestIncomeRevenue);
			if (LitigationExpense != null) LitigationExpense.UpdateValues(previous.LitigationExpense);
			if (OtherthanTemporaryImpairmentLossesInvestments != null) OtherthanTemporaryImpairmentLossesInvestments.UpdateValues(previous.OtherthanTemporaryImpairmentLossesInvestments);
			if (UnrealizedGainorLoss != null) UnrealizedGainorLoss.UpdateValues(previous.UnrealizedGainorLoss);
			if (ChangesinInventoriesofFinishedGoodsandWorkinProgress != null) ChangesinInventoriesofFinishedGoodsandWorkinProgress.UpdateValues(previous.ChangesinInventoriesofFinishedGoodsandWorkinProgress);
			if (WorkPerformedbyEntityandCapitalized != null) WorkPerformedbyEntityandCapitalized.UpdateValues(previous.WorkPerformedbyEntityandCapitalized);
			if (DistributionCosts != null) DistributionCosts.UpdateValues(previous.DistributionCosts);
			if (StaffCosts != null) StaffCosts.UpdateValues(previous.StaffCosts);
			if (SocialSecurityCosts != null) SocialSecurityCosts.UpdateValues(previous.SocialSecurityCosts);
			if (PensionCosts != null) PensionCosts.UpdateValues(previous.PensionCosts);
			if (OtherOperatingIncomeTotal != null) OtherOperatingIncomeTotal.UpdateValues(previous.OtherOperatingIncomeTotal);
			if (ShareofOperatingProfitLossfromJointVenturesAndAssociates != null) ShareofOperatingProfitLossfromJointVenturesAndAssociates.UpdateValues(previous.ShareofOperatingProfitLossfromJointVenturesAndAssociates);
			if (ExceptionalItems != null) ExceptionalItems.UpdateValues(previous.ExceptionalItems);
			if (IncomefromSharesinSubsidiariesGroupUndertakings != null) IncomefromSharesinSubsidiariesGroupUndertakings.UpdateValues(previous.IncomefromSharesinSubsidiariesGroupUndertakings);
			if (IncomefromAssociatesandOtherParticipatingInterests != null) IncomefromAssociatesandOtherParticipatingInterests.UpdateValues(previous.IncomefromAssociatesandOtherParticipatingInterests);
			if (TotalOtherFinanceCost != null) TotalOtherFinanceCost.UpdateValues(previous.TotalOtherFinanceCost);
			if (GrossDividendPayment != null) GrossDividendPayment.UpdateValues(previous.GrossDividendPayment);
			if (InterestandSimilarIncome != null) InterestandSimilarIncome.UpdateValues(previous.InterestandSimilarIncome);
			if (FeesandCommissionIncome != null) FeesandCommissionIncome.UpdateValues(previous.FeesandCommissionIncome);
			if (FeesandCommissionExpense != null) FeesandCommissionExpense.UpdateValues(previous.FeesandCommissionExpense);
			if (NetTradingIncome != null) NetTradingIncome.UpdateValues(previous.NetTradingIncome);
			if (OutwardReinsurancePremiums != null) OutwardReinsurancePremiums.UpdateValues(previous.OutwardReinsurancePremiums);
			if (OtherStaffCosts != null) OtherStaffCosts.UpdateValues(previous.OtherStaffCosts);
			if (ShareBasedPayments != null) ShareBasedPayments.UpdateValues(previous.ShareBasedPayments);
			if (GainonInvestmentProperties != null) GainonInvestmentProperties.UpdateValues(previous.GainonInvestmentProperties);
			if (AverageDilutionEarnings != null) AverageDilutionEarnings.UpdateValues(previous.AverageDilutionEarnings);
			if (GainonRedemptionandExtinguishmentofDebt != null) GainonRedemptionandExtinguishmentofDebt.UpdateValues(previous.GainonRedemptionandExtinguishmentofDebt);
			if (MiscellaneousOtherOperatingIncome != null) MiscellaneousOtherOperatingIncome.UpdateValues(previous.MiscellaneousOtherOperatingIncome);
			if (GainLossonFinancialInstrumentsDesignatedasCashFlowHedges != null) GainLossonFinancialInstrumentsDesignatedasCashFlowHedges.UpdateValues(previous.GainLossonFinancialInstrumentsDesignatedasCashFlowHedges);
			if (GainLossonDerecognitionofAvailableForSaleFinancialAssets != null) GainLossonDerecognitionofAvailableForSaleFinancialAssets.UpdateValues(previous.GainLossonDerecognitionofAvailableForSaleFinancialAssets);
			if (GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotal != null) GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotal.UpdateValues(previous.GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotal);
			if (NegativeGoodwillImmediatelyRecognized != null) NegativeGoodwillImmediatelyRecognized.UpdateValues(previous.NegativeGoodwillImmediatelyRecognized);
			if (GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal != null) GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal.UpdateValues(previous.GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal);
			if (ImpairmentLossesReversalsFinancialInstrumentsNet != null) ImpairmentLossesReversalsFinancialInstrumentsNet.UpdateValues(previous.ImpairmentLossesReversalsFinancialInstrumentsNet);
			if (ShareofProfitLossfromEquityAccountedInvestments != null) ShareofProfitLossfromEquityAccountedInvestments.UpdateValues(previous.ShareofProfitLossfromEquityAccountedInvestments);
			if (ClaimsandPaidIncurred != null) ClaimsandPaidIncurred.UpdateValues(previous.ClaimsandPaidIncurred);
			if (ReinsuranceRecoveriesClaimsandBenefits != null) ReinsuranceRecoveriesClaimsandBenefits.UpdateValues(previous.ReinsuranceRecoveriesClaimsandBenefits);
			if (ChangeinInsuranceLiabilitiesNetofReinsurance != null) ChangeinInsuranceLiabilitiesNetofReinsurance.UpdateValues(previous.ChangeinInsuranceLiabilitiesNetofReinsurance);
			if (ChangeinInvestmentContract != null) ChangeinInvestmentContract.UpdateValues(previous.ChangeinInvestmentContract);
			if (ChangeinReinsuranceAssets != null) ChangeinReinsuranceAssets.UpdateValues(previous.ChangeinReinsuranceAssets);
			if (CreditRiskProvisions != null) CreditRiskProvisions.UpdateValues(previous.CreditRiskProvisions);
			if (WagesandSalaries != null) WagesandSalaries.UpdateValues(previous.WagesandSalaries);
			if (OtherNonOperatingIncomeExpenses != null) OtherNonOperatingIncomeExpenses.UpdateValues(previous.OtherNonOperatingIncomeExpenses);
			if (InterestIncomeOtherOperatingIncome != null) InterestIncomeOtherOperatingIncome.UpdateValues(previous.InterestIncomeOtherOperatingIncome);
			if (OtherNonOperatingIncome != null) OtherNonOperatingIncome.UpdateValues(previous.OtherNonOperatingIncome);
			if (OtherNonOperatingExpenses != null) OtherNonOperatingExpenses.UpdateValues(previous.OtherNonOperatingExpenses);
			if (TotalUnusualItems != null) TotalUnusualItems.UpdateValues(previous.TotalUnusualItems);
			if (TotalUnusualItemsExcludingGoodwill != null) TotalUnusualItemsExcludingGoodwill.UpdateValues(previous.TotalUnusualItemsExcludingGoodwill);
			if (TaxRateForCalcs != null) TaxRateForCalcs.UpdateValues(previous.TaxRateForCalcs);
			if (TaxEffectOfUnusualItems != null) TaxEffectOfUnusualItems.UpdateValues(previous.TaxEffectOfUnusualItems);
			if (NormalizedEBITDA != null) NormalizedEBITDA.UpdateValues(previous.NormalizedEBITDA);
			if (GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCosts != null) GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCosts.UpdateValues(previous.GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCosts);
			if (StockBasedCompensation != null) StockBasedCompensation.UpdateValues(previous.StockBasedCompensation);
			if (DilutedNIAvailtoComStockholders != null) DilutedNIAvailtoComStockholders.UpdateValues(previous.DilutedNIAvailtoComStockholders);
			if (InvestmentContractLiabilitiesIncurred != null) InvestmentContractLiabilitiesIncurred.UpdateValues(previous.InvestmentContractLiabilitiesIncurred);
			if (ReinsuranceRecoveriesofInvestmentContract != null) ReinsuranceRecoveriesofInvestmentContract.UpdateValues(previous.ReinsuranceRecoveriesofInvestmentContract);
			if (TotalDividendPaymentofEquityShares != null) TotalDividendPaymentofEquityShares.UpdateValues(previous.TotalDividendPaymentofEquityShares);
			if (TotalDividendPaymentofNonEquityShares != null) TotalDividendPaymentofNonEquityShares.UpdateValues(previous.TotalDividendPaymentofNonEquityShares);
			if (ChangeinTheGrossProvisionforUnearnedPremiums != null) ChangeinTheGrossProvisionforUnearnedPremiums.UpdateValues(previous.ChangeinTheGrossProvisionforUnearnedPremiums);
			if (ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare != null) ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare.UpdateValues(previous.ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare);
			if (ClaimsandChangeinInsuranceLiabilities != null) ClaimsandChangeinInsuranceLiabilities.UpdateValues(previous.ClaimsandChangeinInsuranceLiabilities);
			if (ReinsuranceRecoveriesofInsuranceLiabilities != null) ReinsuranceRecoveriesofInsuranceLiabilities.UpdateValues(previous.ReinsuranceRecoveriesofInsuranceLiabilities);
		}
	}
}
