/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

//------------------------------------------------------------------------------
// This code was generated by a tool.
// Changes to this file may cause incorrect behavior and will be lost if
// the code is regenerated.
//------------------------------------------------------------------------------

// To get up to date fundamental definition files for your hedgefund contact sales@quantconnect.com

using System.Collections.Generic;
using Newtonsoft.Json;

namespace QuantConnect.Data.Fundamental
{
	/// <summary>
	/// Used to reduce the value of intangible fixed assets.
	/// </summary>
	public class AmortizationIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AmortizationIncomeStatement class
		/// </summary>
		public AmortizationIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AmortizationIncomeStatement class
		/// </summary>
		public AmortizationIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The gradual elimination of a liability, such as a mortgage, in regular payments over a specified period of time. Such payments must
	/// be sufficient to cover both principal and interest.
	/// </summary>
	public class SecuritiesAmortizationIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SecuritiesAmortizationIncomeStatement class
		/// </summary>
		public SecuritiesAmortizationIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SecuritiesAmortizationIncomeStatement class
		/// </summary>
		public SecuritiesAmortizationIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate cost of goods produced and sold and services rendered during the reporting period. It excludes all operating
	/// expenses such as depreciation, depletion, amortization, and SG&amp;A. For the must have cost industry, if the number is not reported
	/// by the company, it will be calculated based on accounting equation.
	/// Cost of Revenue = Revenue - Operating Expenses - Operating Profit.
	/// </summary>
	public class CostOfRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CostOfRevenueIncomeStatement class
		/// </summary>
		public CostOfRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CostOfRevenueIncomeStatement class
		/// </summary>
		public CostOfRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any cumulative gains or losses from change in accounting principles. A change in accounting principle constitutes a change from
	/// one generally accepted accounting principle to another generally accepted accounting principle. This may also include a change in
	/// the method of applying an accounting principle, such as depreciation or inventory methods.
	/// </summary>
	public class CumulativeEffectOfAccountingChangeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CumulativeEffectOfAccountingChangeIncomeStatement class
		/// </summary>
		public CumulativeEffectOfAccountingChangeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CumulativeEffectOfAccountingChangeIncomeStatement class
		/// </summary>
		public CumulativeEffectOfAccountingChangeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Used to reduce the value of natural resource.
	/// </summary>
	public class DepletionIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DepletionIncomeStatement class
		/// </summary>
		public DepletionIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DepletionIncomeStatement class
		/// </summary>
		public DepletionIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Used to reduce the value of tangible fixed assets.
	/// </summary>
	public class DepreciationIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DepreciationIncomeStatement class
		/// </summary>
		public DepreciationIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DepreciationIncomeStatement class
		/// </summary>
		public DepreciationIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The current period expense charged against earnings on long-lived, physical assets used in the normal conduct of business and not
	/// intended for resale to allocate or recognize the cost of assets over their useful lives; or to record the reduction in book value of an
	/// intangible asset over the benefit period of such asset. Examples include buildings, production and equipment.
	/// </summary>
	public class DepreciationAndAmortizationIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DepreciationAndAmortizationIncomeStatement class
		/// </summary>
		public DepreciationAndAmortizationIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DepreciationAndAmortizationIncomeStatement class
		/// </summary>
		public DepreciationAndAmortizationIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It is a non-cash charge that represents a reduction in the value of fixed assets due to wear, age, or obsolescence. This figure also
	/// includes amortization of leased property, intangibles, and goodwill, and depletion.
	/// </summary>
	public class DepreciationAmortizationDepletionIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DepreciationAmortizationDepletionIncomeStatement class
		/// </summary>
		public DepreciationAmortizationDepletionIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DepreciationAmortizationDepletionIncomeStatement class
		/// </summary>
		public DepreciationAmortizationDepletionIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// To be classified as discontinued operations, if both of the following conditions are met:
	/// 1: The operations and cash flow of the component have been or will be removed from the ongoing operations of the entity as a
	/// result of the disposal transaction, and
	/// 2: The entity will have no significant continuing involvement in the operations of the component after the disposal transaction.
	/// The discontinued operation is reported net of tax.
	/// Gains/Loss on Disposal of Discontinued Operations: Any gains or loss recognized on disposal of discontinued operations,
	/// which is the difference between the carrying value of the division and its fair value less costs to sell.
	/// Provision for Gain/Loss on Disposal: The amount of current expense charged in order to prepare for the disposal of
	/// discontinued operations.
	/// </summary>
	public class NetIncomeDiscontinuousOperationsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeDiscontinuousOperationsIncomeStatement class
		/// </summary>
		public NetIncomeDiscontinuousOperationsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeDiscontinuousOperationsIncomeStatement class
		/// </summary>
		public NetIncomeDiscontinuousOperationsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Excise taxes are taxes paid when purchases are made on a specific good, such as gasoline. Excise taxes are often included in the
	/// price of the product. There are also excise taxes on activities, such as on wagering or on highway usage by trucks.
	/// </summary>
	public class ExciseTaxesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ExciseTaxesIncomeStatement class
		/// </summary>
		public ExciseTaxesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ExciseTaxesIncomeStatement class
		/// </summary>
		public ExciseTaxesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gains (losses), whether arising from extinguishment of debt, prior period adjustments, or from other events or transactions, that are
	/// both unusual in nature and infrequent in occurrence thereby meeting the criteria for an event or transaction to be classified as an
	/// extraordinary item.
	/// </summary>
	public class NetIncomeExtraordinaryIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeExtraordinaryIncomeStatement class
		/// </summary>
		public NetIncomeExtraordinaryIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeExtraordinaryIncomeStatement class
		/// </summary>
		public NetIncomeExtraordinaryIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of fees, commissions, and other income.
	/// </summary>
	public class FeeRevenueAndOtherIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FeeRevenueAndOtherIncomeIncomeStatement class
		/// </summary>
		public FeeRevenueAndOtherIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FeeRevenueAndOtherIncomeIncomeStatement class
		/// </summary>
		public FeeRevenueAndOtherIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate total of general managing and administering expenses for the company.
	/// </summary>
	public class GeneralAndAdministrativeExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GeneralAndAdministrativeExpenseIncomeStatement class
		/// </summary>
		public GeneralAndAdministrativeExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GeneralAndAdministrativeExpenseIncomeStatement class
		/// </summary>
		public GeneralAndAdministrativeExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total revenue less cost of revenue. The number is as reported by the company on the income statement; however, the number will
	/// be calculated if it is not reported. This field is null if the cost of revenue is not given.
	/// Gross Profit = Total Revenue - Cost of Revenue.
	/// </summary>
	public class GrossProfitIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GrossProfitIncomeStatement class
		/// </summary>
		public GrossProfitIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GrossProfitIncomeStatement class
		/// </summary>
		public GrossProfitIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Relates to the general cost of borrowing money. It is the price that a lender charges a borrower for the use of the lender's money.
	/// </summary>
	public class InterestExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseIncomeStatement class
		/// </summary>
		public InterestExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseIncomeStatement class
		/// </summary>
		public InterestExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest expense caused by long term financing activities; such as interest expense incurred on trading liabilities, commercial paper,
	/// long-term debt, capital leases, deposits, and all other borrowings.
	/// </summary>
	public class InterestExpenseNonOperatingIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseNonOperatingIncomeStatement class
		/// </summary>
		public InterestExpenseNonOperatingIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseNonOperatingIncomeStatement class
		/// </summary>
		public InterestExpenseNonOperatingIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest expense caused by normal operating activities.
	/// </summary>
	public class InterestExpenseOperatingIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseOperatingIncomeStatement class
		/// </summary>
		public InterestExpenseOperatingIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseOperatingIncomeStatement class
		/// </summary>
		public InterestExpenseOperatingIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums,
	/// including consideration of the provisions for loan, lease, credit, and other related losses, if any.
	/// </summary>
	public class InterestIncomeAfterProvisionForLoanLossIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeAfterProvisionForLoanLossIncomeStatement class
		/// </summary>
		public InterestIncomeAfterProvisionForLoanLossIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeAfterProvisionForLoanLossIncomeStatement class
		/// </summary>
		public InterestIncomeAfterProvisionForLoanLossIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest income earned from long term financing activities.
	/// </summary>
	public class InterestIncomeNonOperatingIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeNonOperatingIncomeStatement class
		/// </summary>
		public InterestIncomeNonOperatingIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeNonOperatingIncomeStatement class
		/// </summary>
		public InterestIncomeNonOperatingIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest income earned by normal operating activities.
	/// </summary>
	public class InterestIncomeOperatingIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeOperatingIncomeStatement class
		/// </summary>
		public InterestIncomeOperatingIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeOperatingIncomeStatement class
		/// </summary>
		public InterestIncomeOperatingIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net-Non Operating interest income or expenses caused by financing activities.
	/// </summary>
	public class NetNonOperatingInterestIncomeExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetNonOperatingInterestIncomeExpenseIncomeStatement class
		/// </summary>
		public NetNonOperatingInterestIncomeExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetNonOperatingInterestIncomeExpenseIncomeStatement class
		/// </summary>
		public NetNonOperatingInterestIncomeExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net operating interest income or expense caused by normal operating activities.
	/// </summary>
	public class NetOperatingInterestIncomeExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetOperatingInterestIncomeExpenseIncomeStatement class
		/// </summary>
		public NetOperatingInterestIncomeExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetOperatingInterestIncomeExpenseIncomeStatement class
		/// </summary>
		public NetOperatingInterestIncomeExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Losses generally refer to (1) the amount of reduction in the value of an insured's property caused by an insured peril, (2) the amount
	/// sought through an insured's claim, or (3) the amount paid on behalf of an insured under an insurance contract.  Loss Adjustment
	/// Expenses is expenses incurred in the course of investigating and settling claims that includes any legal and adjusters' fees and the
	/// costs of paying claims and all related expenses.
	/// </summary>
	public class LossAdjustmentExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LossAdjustmentExpenseIncomeStatement class
		/// </summary>
		public LossAdjustmentExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LossAdjustmentExpenseIncomeStatement class
		/// </summary>
		public LossAdjustmentExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents par or stated value of the subsidiary stock not owned by the parent company plus the minority interest's equity in the
	/// surplus of the subsidiary. This item includes preferred dividend averages on the minority preferred stock (preferred shares not
	/// owned by the reporting parent company). Minority interest also refers to stockholders who own less than 50% of a subsidiary's
	/// outstanding voting common stock. The minority stockholders hold an interest in the subsidiary's net assets and share earnings with
	/// the parent company.
	/// </summary>
	public class MinorityInterestsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MinorityInterestsIncomeStatement class
		/// </summary>
		public MinorityInterestsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MinorityInterestsIncomeStatement class
		/// </summary>
		public MinorityInterestsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes all the operations (continuing and discontinued) and all the other income or charges (extraordinary, accounting changes,
	/// tax loss carry forward, and other gains and losses).
	/// </summary>
	public class NetIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeIncomeStatement class
		/// </summary>
		public NetIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeIncomeStatement class
		/// </summary>
		public NetIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net income minus the preferred dividends paid as presented in the Income Statement.
	/// </summary>
	public class NetIncomeCommonStockholdersIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeCommonStockholdersIncomeStatement class
		/// </summary>
		public NetIncomeCommonStockholdersIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeCommonStockholdersIncomeStatement class
		/// </summary>
		public NetIncomeCommonStockholdersIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from: Preferred Dividends;
	/// Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax
	/// Loss Carry forward; Other Gains/Losses.
	/// </summary>
	public class NetIncomeContinuousOperationsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeContinuousOperationsIncomeStatement class
		/// </summary>
		public NetIncomeContinuousOperationsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeContinuousOperationsIncomeStatement class
		/// </summary>
		public NetIncomeContinuousOperationsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total interest income minus total interest expense. It represents the difference between interest and dividends earned on interest-
	/// bearing assets and interest paid to depositors and other creditors.
	/// </summary>
	public class NetInterestIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetInterestIncomeIncomeStatement class
		/// </summary>
		public NetInterestIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetInterestIncomeIncomeStatement class
		/// </summary>
		public NetInterestIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total of interest, dividends, and other earnings derived from the insurance company's invested assets minus the expenses
	/// associated with these investments. Excluded from this income are capital gains or losses as the result of the sale of assets, as well
	/// as any unrealized capital gains or losses.
	/// </summary>
	public class NetInvestmentIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetInvestmentIncomeIncomeStatement class
		/// </summary>
		public NetInvestmentIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetInvestmentIncomeIncomeStatement class
		/// </summary>
		public NetInvestmentIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All revenues, sales and income that the company deems as a total sum of all of their income as reported in the company's income
	/// statement.
	/// Bank:  Total Revenue = Net Interest Income + Non-Interest Income.
	/// </summary>
	public class TotalRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalRevenueIncomeStatement class
		/// </summary>
		public TotalRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalRevenueIncomeStatement class
		/// </summary>
		public TotalRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any expenses that not related to interest. It includes labor and related expense, occupancy and equipment, commission,
	/// professional expense and contract services expenses, selling, general and administrative, research and development depreciation,
	/// amortization and depletion, and any other special income/charges.
	/// </summary>
	public class NonInterestExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonInterestExpenseIncomeStatement class
		/// </summary>
		public NonInterestExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonInterestExpenseIncomeStatement class
		/// </summary>
		public NonInterestExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The total amount of non-interest income which may be derived from: (1) fees and commissions; (2) premiums earned; (3) equity
	/// investment; (4) the sale or disposal of assets; and (5) other sources not otherwise
	/// specified.
	/// </summary>
	public class NonInterestIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonInterestIncomeIncomeStatement class
		/// </summary>
		public NonInterestIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonInterestIncomeIncomeStatement class
		/// </summary>
		public NonInterestIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Operating expenses are primary recurring costs associated with central operations (other than cost of goods sold) that are incurred
	/// in order to generate sales.
	/// </summary>
	public class OperatingExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OperatingExpenseIncomeStatement class
		/// </summary>
		public OperatingExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OperatingExpenseIncomeStatement class
		/// </summary>
		public OperatingExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income from normal business operations after deducting cost of revenue and operating expenses. It does not include income from
	/// any investing activities.
	/// </summary>
	public class OperatingIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OperatingIncomeIncomeStatement class
		/// </summary>
		public OperatingIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OperatingIncomeIncomeStatement class
		/// </summary>
		public OperatingIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The operating revenue for transportation industry can be divided into three parts: revenue-passenger, revenue-cargo, and other
	/// operating revenue.
	/// </summary>
	public class OperatingRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OperatingRevenueIncomeStatement class
		/// </summary>
		public OperatingRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OperatingRevenueIncomeStatement class
		/// </summary>
		public OperatingRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income or expense that comes from miscellaneous sources.
	/// </summary>
	public class OtherIncomeExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherIncomeExpenseIncomeStatement class
		/// </summary>
		public OtherIncomeExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherIncomeExpenseIncomeStatement class
		/// </summary>
		public OtherIncomeExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as
	/// underwriting expenses.
	/// </summary>
	public class PolicyAcquisitionExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyAcquisitionExpenseIncomeStatement class
		/// </summary>
		public PolicyAcquisitionExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyAcquisitionExpenseIncomeStatement class
		/// </summary>
		public PolicyAcquisitionExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The net provision in current period for future policy benefits, claims, and claims settlement expenses incurred in the claims
	/// settlement process before the effects of reinsurance arrangements. The value is net of the effects of contracts assumed and
	/// ceded.
	/// </summary>
	public class NetPolicyholderBenefitsAndClaimsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetPolicyholderBenefitsAndClaimsIncomeStatement class
		/// </summary>
		public NetPolicyholderBenefitsAndClaimsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetPolicyholderBenefitsAndClaimsIncomeStatement class
		/// </summary>
		public NetPolicyholderBenefitsAndClaimsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of dividends declared or paid in the period to preferred shareholders, or the amount for which the obligation to pay
	/// them dividends arose in the period. Preferred dividends are the amount required for the current year only, and not for any amount
	/// required in past years.
	/// </summary>
	public class PreferredStockDividendsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PreferredStockDividendsIncomeStatement class
		/// </summary>
		public PreferredStockDividendsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PreferredStockDividendsIncomeStatement class
		/// </summary>
		public PreferredStockDividendsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Premiums earned is the portion of an insurance written premium which is considered "earned" by the insurer, based on the part of
	/// the policy period that the insurance has been in effect, and during which the insurer has been exposed to loss.
	/// </summary>
	public class TotalPremiumsEarnedIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalPremiumsEarnedIncomeStatement class
		/// </summary>
		public TotalPremiumsEarnedIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalPremiumsEarnedIncomeStatement class
		/// </summary>
		public TotalPremiumsEarnedIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Reported income before the deduction or benefit of income taxes.
	/// </summary>
	public class PretaxIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PretaxIncomeIncomeStatement class
		/// </summary>
		public PretaxIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PretaxIncomeIncomeStatement class
		/// </summary>
		public PretaxIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Include any taxes on income, net of any investment tax credits for the current accounting period.
	/// </summary>
	public class TaxProvisionIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TaxProvisionIncomeStatement class
		/// </summary>
		public TaxProvisionIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TaxProvisionIncomeStatement class
		/// </summary>
		public TaxProvisionIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A charge to income which represents an expense deemed adequate by management given the composition of a bank's credit
	/// portfolios, their probability of default, the economic environment and the allowance for credit losses already established. Specific
	/// provisions are established to reduce the book value of specific assets (primarily loans) to establish the amount expected to be
	/// recovered on the loans.
	/// </summary>
	public class CreditLossesProvisionIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CreditLossesProvisionIncomeStatement class
		/// </summary>
		public CreditLossesProvisionIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CreditLossesProvisionIncomeStatement class
		/// </summary>
		public CreditLossesProvisionIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of research and development expenses.
	/// </summary>
	public class ResearchAndDevelopmentIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ResearchAndDevelopmentIncomeStatement class
		/// </summary>
		public ResearchAndDevelopmentIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ResearchAndDevelopmentIncomeStatement class
		/// </summary>
		public ResearchAndDevelopmentIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate total amount of expenses directly related to the marketing or selling of products or services.
	/// </summary>
	public class SellingAndMarketingExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SellingAndMarketingExpenseIncomeStatement class
		/// </summary>
		public SellingAndMarketingExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SellingAndMarketingExpenseIncomeStatement class
		/// </summary>
		public SellingAndMarketingExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate total costs related to selling a firm's product and services, as well as all other general and administrative expenses.
	/// Selling expenses are those directly related to the company's efforts to generate sales (e.g., sales salaries, commissions,
	/// advertising, delivery expenses). General and administrative expenses are expenses related to general administration of the
	/// company's operation (e.g., officers and office salaries, office supplies, telephone, accounting and legal services, and business
	/// licenses and fees).
	/// </summary>
	public class SellingGeneralAndAdministrationIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SellingGeneralAndAdministrationIncomeStatement class
		/// </summary>
		public SellingGeneralAndAdministrationIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SellingGeneralAndAdministrationIncomeStatement class
		/// </summary>
		public SellingGeneralAndAdministrationIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Earnings or losses attributable to occurrences or actions by the firm that is either infrequent or unusual.
	/// </summary>
	public class SpecialIncomeChargesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SpecialIncomeChargesIncomeStatement class
		/// </summary>
		public SpecialIncomeChargesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SpecialIncomeChargesIncomeStatement class
		/// </summary>
		public SpecialIncomeChargesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The sum of operating expense and cost of revenue. If the company does not give the reported number, it will be calculated by
	/// adding operating expense and cost of revenue.
	/// </summary>
	public class TotalExpensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalExpensesIncomeStatement class
		/// </summary>
		public TotalExpensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalExpensesIncomeStatement class
		/// </summary>
		public TotalExpensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Financial Accounting Standard (FAS) requires that expenses associated with the sale or acquisition of an insurance policy should be
	/// deferred to future periods to match the premium income stream from that policy over its lifetime. Hence, the acquisition costs
	/// incurred in the year of sale is capitalized in order to create the deferred acquisition costs asset and be amortized over the life of the
	/// policy.
	/// </summary>
	public class AmortizationOfDeferredAcquisitionCostsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AmortizationOfDeferredAcquisitionCostsIncomeStatement class
		/// </summary>
		public AmortizationOfDeferredAcquisitionCostsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AmortizationOfDeferredAcquisitionCostsIncomeStatement class
		/// </summary>
		public AmortizationOfDeferredAcquisitionCostsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income generated from interest-bearing deposits or accounts.
	/// </summary>
	public class InterestIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeIncomeStatement class
		/// </summary>
		public InterestIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeIncomeStatement class
		/// </summary>
		public InterestIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The claims made under the liability insurance in order to protect the assets of a business when it is caused by an injury or damage.
	/// </summary>
	public class PropertyLiabilityInsuranceClaimsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PropertyLiabilityInsuranceClaimsIncomeStatement class
		/// </summary>
		public PropertyLiabilityInsuranceClaimsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PropertyLiabilityInsuranceClaimsIncomeStatement class
		/// </summary>
		public PropertyLiabilityInsuranceClaimsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Earnings minus expenses (excluding interest and tax expenses).
	/// </summary>
	public class EBITIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EBITIncomeStatement class
		/// </summary>
		public EBITIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EBITIncomeStatement class
		/// </summary>
		public EBITIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Earnings minus expenses (excluding interest, tax, depreciation, and amortization expenses).
	/// </summary>
	public class EBITDAIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EBITDAIncomeStatement class
		/// </summary>
		public EBITDAIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EBITDAIncomeStatement class
		/// </summary>
		public EBITDAIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
	/// Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
	/// Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
	/// </summary>
	public class NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement class
		/// </summary>
		public NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement class
		/// </summary>
		public NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Two situations may lead to accretion on a preferred stock - accretion related redemption premium and interest-like returns on
	/// accrued, but unpaid dividends that accumulated from accumulated preferred stock.
	/// </summary>
	public class AccretionOnPreferredStockIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AccretionOnPreferredStockIncomeStatement class
		/// </summary>
		public AccretionOnPreferredStockIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AccretionOnPreferredStockIncomeStatement class
		/// </summary>
		public AccretionOnPreferredStockIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An accrued preferred stock dividend is remuneration owed by a company to its preferred stock holders. Forms of accrued preferred
	/// stock dividends can be either cash or additional shares of preferred stock.
	/// </summary>
	public class AccruedPreferredStockDividendsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AccruedPreferredStockDividendsIncomeStatement class
		/// </summary>
		public AccruedPreferredStockDividendsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AccruedPreferredStockDividendsIncomeStatement class
		/// </summary>
		public AccruedPreferredStockDividendsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// In-process research and development that is acquired through a merger or acquisition during the period.
	/// </summary>
	public class AcquiredInProcessRnDIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AcquiredInProcessRnDIncomeStatement class
		/// </summary>
		public AcquiredInProcessRnDIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AcquiredInProcessRnDIncomeStatement class
		/// </summary>
		public AcquiredInProcessRnDIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as
	/// underwriting expenses. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class AcquisitionExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AcquisitionExpenseIncomeStatement class
		/// </summary>
		public AcquisitionExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AcquisitionExpenseIncomeStatement class
		/// </summary>
		public AcquisitionExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The expenses that an organization incurs not directly tied to a specific function such as manufacturing/production or sales. These
	/// expenses are related to the organization as a whole as opposed to an individual department
	/// </summary>
	public class AdministrativeExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AdministrativeExpenseIncomeStatement class
		/// </summary>
		public AdministrativeExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AdministrativeExpenseIncomeStatement class
		/// </summary>
		public AdministrativeExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fees earned during the period for providing insurance service as an agent. This item is usually only available for insurance industry.
	/// </summary>
	public class AgencyFeesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AgencyFeesIncomeStatement class
		/// </summary>
		public AgencyFeesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AgencyFeesIncomeStatement class
		/// </summary>
		public AgencyFeesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total agency fees and commissions collected by the insurance company as a part of revenue. This item is usually only available for
	/// insurance industry.
	/// </summary>
	public class AgencyFeesAndCommissionsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AgencyFeesAndCommissionsIncomeStatement class
		/// </summary>
		public AgencyFeesAndCommissionsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AgencyFeesAndCommissionsIncomeStatement class
		/// </summary>
		public AgencyFeesAndCommissionsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The establishment of allowances in construction contracts is a convenient method of allocating construction funds to portions of
	/// the work that cannot be specified with sufficient particularity for competitive bidding at the time of contracting. This item is usually
	/// not available for bank and insurance industries.
	/// </summary>
	public class AllowancesForConstructionIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AllowancesForConstructionIncomeStatement class
		/// </summary>
		public AllowancesForConstructionIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AllowancesForConstructionIncomeStatement class
		/// </summary>
		public AllowancesForConstructionIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A tax imposed in some countries on the severance and production of coal, oil or gas from the earth or water for sale, transport,
	/// storage, profit or commercial use. Exemptions from the tax are provided for specific circumstances. This item is usually only
	/// available for mining industry.
	/// </summary>
	public class CapitalnBusinessTaxesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CapitalnBusinessTaxesIncomeStatement class
		/// </summary>
		public CapitalnBusinessTaxesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CapitalnBusinessTaxesIncomeStatement class
		/// </summary>
		public CapitalnBusinessTaxesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of premiums paid and payable to another insurer as a result of reinsurance arrangements in order to exchange for that
	/// company accepting all or part of insurance on a risk or exposure. This item is usually only available for insurance industry.
	/// </summary>
	public class CededPremiumsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CededPremiumsIncomeStatement class
		/// </summary>
		public CededPremiumsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CededPremiumsIncomeStatement class
		/// </summary>
		public CededPremiumsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fees paid to another entity or agent based on commission contracts.
	/// </summary>
	public class CommissionExpensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CommissionExpensesIncomeStatement class
		/// </summary>
		public CommissionExpensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CommissionExpensesIncomeStatement class
		/// </summary>
		public CommissionExpensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The service charge by the insurance company in return for providing advice and handling investment. This item is usually only
	/// available for insurance industry.
	/// </summary>
	public class CommissionRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CommissionRevenueIncomeStatement class
		/// </summary>
		public CommissionRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CommissionRevenueIncomeStatement class
		/// </summary>
		public CommissionRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income earned from credit card services including late, over limit, and annual fees. This item is usually only available for bank
	/// industry.
	/// </summary>
	public class CreditCardIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CreditCardIncomeStatement class
		/// </summary>
		public CreditCardIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CreditCardIncomeStatement class
		/// </summary>
		public CreditCardIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The costs associated with transitioning research to a commercially useful and marketable stage.
	/// </summary>
	public class DevelopmentExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DevelopmentExpenseIncomeStatement class
		/// </summary>
		public DevelopmentExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DevelopmentExpenseIncomeStatement class
		/// </summary>
		public DevelopmentExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Dividends earned from equity investment securities. This item is usually only available for bank industry.
	/// </summary>
	public class DividendIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DividendIncomeIncomeStatement class
		/// </summary>
		public DividendIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DividendIncomeIncomeStatement class
		/// </summary>
		public DividendIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The earning or loss resulting from the proportional part of the associated company's net income. This item is usually only available
	/// for bank industry.
	/// </summary>
	public class EarningLossOfEquityInvestmentsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EarningLossOfEquityInvestmentsIncomeStatement class
		/// </summary>
		public EarningLossOfEquityInvestmentsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EarningLossOfEquityInvestmentsIncomeStatement class
		/// </summary>
		public EarningLossOfEquityInvestmentsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The earnings from equity interest can be a result of any of the following: Income from earnings distribution of the business, either
	/// as dividends paid to corporate shareholders or as drawings in a partnership; Capital gain realized upon sale of the business; Capital
	/// gain realized from selling his or her interest to other partners. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class EarningsFromEquityInterestIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EarningsFromEquityInterestIncomeStatement class
		/// </summary>
		public EarningsFromEquityInterestIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EarningsFromEquityInterestIncomeStatement class
		/// </summary>
		public EarningsFromEquityInterestIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Revenue from operations of public electric power supply systems, such as sale of electricity to residential, commercial, and
	/// industrial customers (including electricity for resale by other private or public electric utilities). This item is usually only available for
	/// utility industry.
	/// </summary>
	public class ElectricRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ElectricRevenueIncomeStatement class
		/// </summary>
		public ElectricRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ElectricRevenueIncomeStatement class
		/// </summary>
		public ElectricRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Equipment expenses include depreciation, repairs, rentals, and service contract costs. This also includes equipment purchases
	/// which do not qualify for capitalization in accordance with the entity's accounting policy. This item may also include furniture
	/// expenses. This item is usually only available for bank industry.
	/// </summary>
	public class EquipmentIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EquipmentIncomeStatement class
		/// </summary>
		public EquipmentIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EquipmentIncomeStatement class
		/// </summary>
		public EquipmentIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Costs incurred in identifying areas that may warrant examination and in examining specific areas that are considered to have
	/// prospects of containing energy or metal reserves, including costs of drilling exploratory wells. Development expense is the
	/// capitalized costs incurred to obtain access to proved reserves and to provide facilities for extracting, treating, gathering and storing
	/// the energy and metal. Mineral property includes oil and gas wells, mines, and other natural deposits (including geothermal
	/// deposits). The payment for leasing those properties is called mineral property lease expense. Exploration expense is included in
	/// operation expenses for mining industry.
	/// </summary>
	public class ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement class
		/// </summary>
		public ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement class
		/// </summary>
		public ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total fees earned from providing services. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class FeesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FeesIncomeStatement class
		/// </summary>
		public FeesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FeesIncomeStatement class
		/// </summary>
		public FeesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total fees and commissions earned from providing services such as leasing of space or maintaining: (1) depositor accounts; (2)
	/// transfer agent; (3) fiduciary and trust; (4) brokerage and underwriting; (5) mortgage; (6) credit cards; (7) correspondent clearing;
	/// and (8) other such services and activities performed for others. This item is usually available for bank and insurance industries.
	/// </summary>
	public class FeesAndCommissionsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FeesAndCommissionsIncomeStatement class
		/// </summary>
		public FeesAndCommissionsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FeesAndCommissionsIncomeStatement class
		/// </summary>
		public FeesAndCommissionsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Trading revenues that result from foreign exchange exposures such as cash instruments and off-balance sheet derivative
	/// instruments. This item is usually only available for bank industry.
	/// </summary>
	public class ForeignExchangeTradingGainsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ForeignExchangeTradingGainsIncomeStatement class
		/// </summary>
		public ForeignExchangeTradingGainsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ForeignExchangeTradingGainsIncomeStatement class
		/// </summary>
		public ForeignExchangeTradingGainsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of fuel cost for current period associated with the revenue generation. This item is usually only available for
	/// transportation industry.
	/// </summary>
	public class FuelIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FuelIncomeStatement class
		/// </summary>
		public FuelIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FuelIncomeStatement class
		/// </summary>
		public FuelIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Cost of fuel, purchase power and gas associated with revenue generation. This item is usually only available for utility industry.
	/// </summary>
	public class FuelAndPurchasePowerIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FuelAndPurchasePowerIncomeStatement class
		/// </summary>
		public FuelAndPurchasePowerIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FuelAndPurchasePowerIncomeStatement class
		/// </summary>
		public FuelAndPurchasePowerIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of excess earned in comparison to fair value when selling a business. This item is usually not available for insurance
	/// industry.
	/// </summary>
	public class GainOnSaleOfBusinessIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainOnSaleOfBusinessIncomeStatement class
		/// </summary>
		public GainOnSaleOfBusinessIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainOnSaleOfBusinessIncomeStatement class
		/// </summary>
		public GainOnSaleOfBusinessIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of excess earned in comparison to the net book value for sale of property, plant, equipment. This item is usually not
	/// available for bank and insurance industries.
	/// </summary>
	public class GainOnSaleOfPPEIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainOnSaleOfPPEIncomeStatement class
		/// </summary>
		public GainOnSaleOfPPEIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainOnSaleOfPPEIncomeStatement class
		/// </summary>
		public GainOnSaleOfPPEIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of excess earned in comparison to the original purchase value of the security.
	/// </summary>
	public class GainOnSaleOfSecurityIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainOnSaleOfSecurityIncomeStatement class
		/// </summary>
		public GainOnSaleOfSecurityIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainOnSaleOfSecurityIncomeStatement class
		/// </summary>
		public GainOnSaleOfSecurityIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any gain or loss recognized on disposal of discontinued operations, which is the difference between the carrying value of the
	/// division and its fair value less costs to sell.
	/// </summary>
	public class GainsLossOnDisposalOfDiscontinuedOperationsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainsLossOnDisposalOfDiscontinuedOperationsIncomeStatement class
		/// </summary>
		public GainsLossOnDisposalOfDiscontinuedOperationsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainsLossOnDisposalOfDiscontinuedOperationsIncomeStatement class
		/// </summary>
		public GainsLossOnDisposalOfDiscontinuedOperationsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Revenue from operations of public gas supply systems, such as sale of natural gas to residential, commercial, and industrial
	/// customers (including natural gas for resale by other private or public gas supply utilities); connection fees; and other operations
	/// revenues. This item is usually only available for utility industry.
	/// </summary>
	public class GasRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GasRevenueIncomeStatement class
		/// </summary>
		public GasRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GasRevenueIncomeStatement class
		/// </summary>
		public GasRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An undivided investment account in which insurers maintain funds that support contractual obligations for guaranteed insurance
	/// products such as whole life insurance or fixed-rate annuities. This item is usually only available for insurance industry.
	/// </summary>
	public class GeneralAccountAssetsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GeneralAccountAssetsIncomeStatement class
		/// </summary>
		public GeneralAccountAssetsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GeneralAccountAssetsIncomeStatement class
		/// </summary>
		public GeneralAccountAssetsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expense incurred for operations other than selling, administrative, or cost of goods sold
	/// </summary>
	public class GeneralExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GeneralExpenseIncomeStatement class
		/// </summary>
		public GeneralExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GeneralExpenseIncomeStatement class
		/// </summary>
		public GeneralExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total premiums generated from all policies written by an insurance company within a given period of time. This item is usually only
	/// available for insurance industry.
	/// </summary>
	public class GrossPremiumsWrittenIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GrossPremiumsWrittenIncomeStatement class
		/// </summary>
		public GrossPremiumsWrittenIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GrossPremiumsWrittenIncomeStatement class
		/// </summary>
		public GrossPremiumsWrittenIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future
	/// cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written
	/// down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the
	/// company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of
	/// discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future
	/// profit collection ability.
	/// </summary>
	public class ImpairmentOfCapitalAssetsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ImpairmentOfCapitalAssetsIncomeStatement class
		/// </summary>
		public ImpairmentOfCapitalAssetsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ImpairmentOfCapitalAssetsIncomeStatement class
		/// </summary>
		public ImpairmentOfCapitalAssetsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future
	/// cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written
	/// down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the
	/// company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of
	/// discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future
	/// profit collection ability; This item is usually not available for bank and insurance industries.
	/// </summary>
	public class OtherImpairmentOfCapitalAssetsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherImpairmentOfCapitalAssetsIncomeStatement class
		/// </summary>
		public OtherImpairmentOfCapitalAssetsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherImpairmentOfCapitalAssetsIncomeStatement class
		/// </summary>
		public OtherImpairmentOfCapitalAssetsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Company will report the income earned on the investment on its income statement and the reported value is based on the firm's
	/// share of the company assets. The reported profit is proportional to the size of the equity investment. This is the standard technique
	/// used when one company has significant influence over another.
	/// </summary>
	public class IncomeFromEquityMethodInvestmentsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the IncomeFromEquityMethodInvestmentsIncomeStatement class
		/// </summary>
		public IncomeFromEquityMethodInvestmentsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the IncomeFromEquityMethodInvestmentsIncomeStatement class
		/// </summary>
		public IncomeFromEquityMethodInvestmentsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The in-process research and development acquired through a merger or acquisition during the period, which is related to non-
	/// operating activity. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class AcquiredInProcessRnDIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AcquiredInProcessRnDIncomeIncomeStatement class
		/// </summary>
		public AcquiredInProcessRnDIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AcquiredInProcessRnDIncomeIncomeStatement class
		/// </summary>
		public AcquiredInProcessRnDIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income related to restructuring, merger, or acquisitions. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class RestructringAndMnAIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RestructringAndMnAIncomeIncomeStatement class
		/// </summary>
		public RestructringAndMnAIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RestructringAndMnAIncomeIncomeStatement class
		/// </summary>
		public RestructringAndMnAIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Premium might contain a portion of the amount that has been paid in advance for insurance that has not yet been provided, which
	/// is called unearned premium. If either party cancels the contract, the insurer must have the unearned premium ready to refund.
	/// Hence, the amount of premium reserve maintained by insurers is called unearned premium reserves, which is prepared for
	/// liquidation.  This item is usually only available for insurance industry.
	/// </summary>
	public class IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement class
		/// </summary>
		public IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement class
		/// </summary>
		public IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Insurance and claims are the expenses in the period incurred with respect to protection provided by insurance entities against risks
	/// other than risks associated with production (which is allocated to cost of sales). This item is usually not available for insurance
	/// industries.
	/// </summary>
	public class InsuranceAndClaimsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InsuranceAndClaimsIncomeStatement class
		/// </summary>
		public InsuranceAndClaimsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InsuranceAndClaimsIncomeStatement class
		/// </summary>
		public InsuranceAndClaimsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Premiums and Income / Loss from Insurance Activities
	/// </summary>
	public class InsuranceAndPremiumsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InsuranceAndPremiumsIncomeStatement class
		/// </summary>
		public InsuranceAndPremiumsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InsuranceAndPremiumsIncomeStatement class
		/// </summary>
		public InsuranceAndPremiumsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This includes Checking account; Savings account; Deposit in foreign offices; Money Market Certificates &amp; Deposit Accounts. This
	/// item is usually only available for bank industry.
	/// </summary>
	public class InterestIncomeFromInterestBearingDepositsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromInterestBearingDepositsIncomeStatement class
		/// </summary>
		public InterestIncomeFromInterestBearingDepositsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromInterestBearingDepositsIncomeStatement class
		/// </summary>
		public InterestIncomeFromInterestBearingDepositsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Aggregate interest expenses incurred on long-term capital lease obligation. This item is usually only available for bank industry.
	/// </summary>
	public class InterestExpenseForCapitalizedLeaseObligationsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseForCapitalizedLeaseObligationsIncomeStatement class
		/// </summary>
		public InterestExpenseForCapitalizedLeaseObligationsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseForCapitalizedLeaseObligationsIncomeStatement class
		/// </summary>
		public InterestExpenseForCapitalizedLeaseObligationsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes interest expense on the following deposit accounts: Interest-bearing Demand deposit; Checking account; Savings account;
	/// Deposit in foreign offices; Money Market Certificates &amp; Deposit Accounts. This item is usually only available for bank industry.
	/// </summary>
	public class InterestExpenseForDepositIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseForDepositIncomeStatement class
		/// </summary>
		public InterestExpenseForDepositIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseForDepositIncomeStatement class
		/// </summary>
		public InterestExpenseForDepositIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gross expenses on the purchase of Federal funds at a specified price with a simultaneous agreement to sell the same to the same
	/// counterparty at a fixed or determinable price at a future date. This item is usually only available for bank industry.
	/// </summary>
	public class InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement class
		/// </summary>
		public InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement class
		/// </summary>
		public InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant,
	/// equipment) that are leased for more than one year. This item is usually only available for bank industry.
	/// </summary>
	public class InterestExpenseForLongTermDebtIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseForLongTermDebtIncomeStatement class
		/// </summary>
		public InterestExpenseForLongTermDebtIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseForLongTermDebtIncomeStatement class
		/// </summary>
		public InterestExpenseForLongTermDebtIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant,
	/// equipment) that are leased due longer than one year. This item is usually only available for bank industry.
	/// </summary>
	public class InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement class
		/// </summary>
		public InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement class
		/// </summary>
		public InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate interest expenses incurred on short-term borrowings and any interest expenses on fixed assets (property, plant,
	/// equipment) that are leased within one year. This item is usually only available for bank industry.
	/// </summary>
	public class InterestExpenseForShortTermDebtIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestExpenseForShortTermDebtIncomeStatement class
		/// </summary>
		public InterestExpenseForShortTermDebtIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestExpenseForShortTermDebtIncomeStatement class
		/// </summary>
		public InterestExpenseForShortTermDebtIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest income generated from all deposit accounts. This item is usually only available for bank industry.
	/// </summary>
	public class InterestIncomeFromDepositsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromDepositsIncomeStatement class
		/// </summary>
		public InterestIncomeFromDepositsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromDepositsIncomeStatement class
		/// </summary>
		public InterestIncomeFromDepositsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
	/// resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll.
	/// Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all
	/// interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all
	/// interest income generated from federal funds sold and securities purchases under agreements to resell.
	/// </summary>
	public class InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement class
		/// </summary>
		public InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement class
		/// </summary>
		public InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes any interest and dividends on investment securities that are not part of money market investments. This item is usually
	/// only available for bank industry.
	/// </summary>
	public class InterestIncomeFromInvestmentSecuritiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromInvestmentSecuritiesIncomeStatement class
		/// </summary>
		public InterestIncomeFromInvestmentSecuritiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromInvestmentSecuritiesIncomeStatement class
		/// </summary>
		public InterestIncomeFromInvestmentSecuritiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry.
	/// </summary>
	public class InterestIncomeFromLeasesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromLeasesIncomeStatement class
		/// </summary>
		public InterestIncomeFromLeasesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromLeasesIncomeStatement class
		/// </summary>
		public InterestIncomeFromLeasesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes
	/// Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks
	/// earn interest from loans. This item is usually only available for bank industry.
	/// </summary>
	public class InterestIncomeFromLoansIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromLoansIncomeStatement class
		/// </summary>
		public InterestIncomeFromLoansIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromLoansIncomeStatement class
		/// </summary>
		public InterestIncomeFromLoansIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total interest and fee income generated by loans and lease. This item is usually only available for bank industry.
	/// </summary>
	public class InterestIncomeFromLoansAndLeaseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromLoansAndLeaseIncomeStatement class
		/// </summary>
		public InterestIncomeFromLoansAndLeaseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromLoansAndLeaseIncomeStatement class
		/// </summary>
		public InterestIncomeFromLoansAndLeaseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations,
	/// securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities
	/// (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only
	/// available for bank industry.
	/// </summary>
	public class InterestIncomeFromSecuritiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromSecuritiesIncomeStatement class
		/// </summary>
		public InterestIncomeFromSecuritiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromSecuritiesIncomeStatement class
		/// </summary>
		public InterestIncomeFromSecuritiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest income from assets held in trading accounts. This item is usually only available for bank industry.
	/// </summary>
	public class InterestIncomeFromTradingAccountSecuritiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromTradingAccountSecuritiesIncomeStatement class
		/// </summary>
		public InterestIncomeFromTradingAccountSecuritiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromTradingAccountSecuritiesIncomeStatement class
		/// </summary>
		public InterestIncomeFromTradingAccountSecuritiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes (1) underwriting revenue (the spread between the resale price received and the cost of the securities and related
	/// expenses) generated through the purchasing, distributing and reselling of new issues of securities (alternatively, could be a
	/// secondary offering of a large block of previously issued securities); and (2) fees earned for mergers, acquisitions, divestitures,
	/// restructurings, and other types of financial advisory services. This item is usually only available for bank industry.
	/// </summary>
	public class InvestmentBankingProfitIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InvestmentBankingProfitIncomeStatement class
		/// </summary>
		public InvestmentBankingProfitIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InvestmentBankingProfitIncomeStatement class
		/// </summary>
		public InvestmentBankingProfitIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Premiums earned from life and annuity insurance. This item is usually only available for bank industry.
	/// </summary>
	public class LifeAnnuityPremiumsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LifeAnnuityPremiumsIncomeStatement class
		/// </summary>
		public LifeAnnuityPremiumsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LifeAnnuityPremiumsIncomeStatement class
		/// </summary>
		public LifeAnnuityPremiumsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes the loans that the bank is going to sell at a discount. This item is usually only available for bank industry.
	/// </summary>
	public class LoansHeldForResellIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LoansHeldForResellIncomeStatement class
		/// </summary>
		public LoansHeldForResellIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LoansHeldForResellIncomeStatement class
		/// </summary>
		public LoansHeldForResellIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expenses incurred in the course of investigating and settling claims. This item is usually not available for bank and insurance
	/// industries.
	/// </summary>
	public class LossAndLossAdjustmentExpectedIncurredIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LossAndLossAdjustmentExpectedIncurredIncomeStatement class
		/// </summary>
		public LossAndLossAdjustmentExpectedIncurredIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LossAndLossAdjustmentExpectedIncurredIncomeStatement class
		/// </summary>
		public LossAndLossAdjustmentExpectedIncurredIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of maintenance and repair expenses in the current period associated with the revenue generation. Mainly
	/// for fixed assets. This item is usually only available for transportation industry.
	/// </summary>
	public class MaintenanceAndRepairsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MaintenanceAndRepairsIncomeStatement class
		/// </summary>
		public MaintenanceAndRepairsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MaintenanceAndRepairsIncomeStatement class
		/// </summary>
		public MaintenanceAndRepairsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expenditures for planning and executing the conception, pricing, promotion, and distribution of ideas, goods, and services.
	/// </summary>
	public class MarketingExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MarketingExpenseIncomeStatement class
		/// </summary>
		public MarketingExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MarketingExpenseIncomeStatement class
		/// </summary>
		public MarketingExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes any interest income collects from money market investments. This item is usually only available for bank industry.
	/// </summary>
	public class InterestIncomeFromOtherMoneyMarketInvestmentsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeFromOtherMoneyMarketInvestmentsIncomeStatement class
		/// </summary>
		public InterestIncomeFromOtherMoneyMarketInvestmentsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeFromOtherMoneyMarketInvestmentsIncomeStatement class
		/// </summary>
		public InterestIncomeFromOtherMoneyMarketInvestmentsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate foreign currency translation gain or loss (both realized and unrealized) included as part of revenue. This item is
	/// usually only available for insurance industry.
	/// </summary>
	public class NetForeignExchangeGainLossIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetForeignExchangeGainLossIncomeStatement class
		/// </summary>
		public NetForeignExchangeGainLossIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetForeignExchangeGainLossIncomeStatement class
		/// </summary>
		public NetForeignExchangeGainLossIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Occupancy expense may include items, such as depreciation of facilities and equipment, lease expenses, property taxes and
	/// property and casualty insurance expense. This item is usually only available for bank industry.
	/// </summary>
	public class NetOccupancyExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetOccupancyExpenseIncomeStatement class
		/// </summary>
		public NetOccupancyExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetOccupancyExpenseIncomeStatement class
		/// </summary>
		public NetOccupancyExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net premiums written are gross premiums written less ceded premiums. This item is usually only available for insurance industry.
	/// </summary>
	public class NetPremiumsWrittenIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetPremiumsWrittenIncomeStatement class
		/// </summary>
		public NetPremiumsWrittenIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetPremiumsWrittenIncomeStatement class
		/// </summary>
		public NetPremiumsWrittenIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain or loss realized during the period of time for all kinds of investment securities. In might include trading, available-for-sale, or
	/// held-to-maturity securities. This item is usually only available for insurance industry.
	/// </summary>
	public class NetRealizedGainLossOnInvestmentsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetRealizedGainLossOnInvestmentsIncomeStatement class
		/// </summary>
		public NetRealizedGainLossOnInvestmentsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetRealizedGainLossOnInvestmentsIncomeStatement class
		/// </summary>
		public NetRealizedGainLossOnInvestmentsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A one-time change expense that the company does not expect to encounter again.
	/// </summary>
	public class NonRecurringOperationExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonRecurringOperationExpenseIncomeStatement class
		/// </summary>
		public NonRecurringOperationExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonRecurringOperationExpenseIncomeStatement class
		/// </summary>
		public NonRecurringOperationExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes total expenses of occupancy and equipment. This item is usually only available for bank industry.
	/// </summary>
	public class OccupancyAndEquipmentIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OccupancyAndEquipmentIncomeStatement class
		/// </summary>
		public OccupancyAndEquipmentIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OccupancyAndEquipmentIncomeStatement class
		/// </summary>
		public OccupancyAndEquipmentIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Taxes and licenses expenses incurred and are directly related to goods produced and sold and services rendered during the
	/// reporting period. This item is usually only available for transportation industry.
	/// </summary>
	public class OperatingTaxesnLicensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OperatingTaxesnLicensesIncomeStatement class
		/// </summary>
		public OperatingTaxesnLicensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OperatingTaxesnLicensesIncomeStatement class
		/// </summary>
		public OperatingTaxesnLicensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of operation and maintenance expenses, which is the one important operating expense for the utility
	/// industry. It includes any costs related to production and maintenance cost of the property during the revenue generation process.
	/// This item is usually only available for mining and utility industries.
	/// </summary>
	public class OperationAndMaintenanceIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OperationAndMaintenanceIncomeStatement class
		/// </summary>
		public OperationAndMaintenanceIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OperationAndMaintenanceIncomeStatement class
		/// </summary>
		public OperationAndMaintenanceIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents fees and commissions earned from provide other services. This item is usually only available for bank industry.
	/// </summary>
	public class OtherCustomerServicesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherCustomerServicesIncomeStatement class
		/// </summary>
		public OtherCustomerServicesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherCustomerServicesIncomeStatement class
		/// </summary>
		public OtherCustomerServicesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All other gain/loss from disposition of discontinued operations that are not otherwise classified
	/// </summary>
	public class OtherGainLossFromDispositionOfDiscontinuedOperationsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherGainLossFromDispositionOfDiscontinuedOperationsIncomeStatement class
		/// </summary>
		public OtherGainLossFromDispositionOfDiscontinuedOperationsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherGainLossFromDispositionOfDiscontinuedOperationsIncomeStatement class
		/// </summary>
		public OtherGainLossFromDispositionOfDiscontinuedOperationsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All other interest expense that is not otherwise classified
	/// </summary>
	public class OtherInterestExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherInterestExpenseIncomeStatement class
		/// </summary>
		public OtherInterestExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherInterestExpenseIncomeStatement class
		/// </summary>
		public OtherInterestExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All other interest income that is not otherwise classified
	/// </summary>
	public class OtherInterestIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherInterestIncomeIncomeStatement class
		/// </summary>
		public OtherInterestIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherInterestIncomeIncomeStatement class
		/// </summary>
		public OtherInterestIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All other non interest expense that is not otherwise classified
	/// </summary>
	public class OtherNonInterestExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherNonInterestExpenseIncomeStatement class
		/// </summary>
		public OtherNonInterestExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherNonInterestExpenseIncomeStatement class
		/// </summary>
		public OtherNonInterestExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// For transportation industry, this represents revenue from operation business excluding revenue of cargo and passengers. For utility
	/// industry, this represents any revenue generated other than electric, gas, and transportation. This item is usually available for
	/// transportation and utility industries.
	/// </summary>
	public class OtherOperatingRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherOperatingRevenueIncomeStatement class
		/// </summary>
		public OtherOperatingRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherOperatingRevenueIncomeStatement class
		/// </summary>
		public OtherOperatingRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All other special charges that are not otherwise classified
	/// </summary>
	public class OtherSpecialChargesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherSpecialChargesIncomeStatement class
		/// </summary>
		public OtherSpecialChargesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherSpecialChargesIncomeStatement class
		/// </summary>
		public OtherSpecialChargesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All other miscellaneous special charges that are not otherwise classified
	/// </summary>
	public class MiscOtherSpecialChargesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MiscOtherSpecialChargesIncomeStatement class
		/// </summary>
		public MiscOtherSpecialChargesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MiscOtherSpecialChargesIncomeStatement class
		/// </summary>
		public MiscOtherSpecialChargesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any taxes that are not part of income taxes. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class OtherTaxesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherTaxesIncomeStatement class
		/// </summary>
		public OtherTaxesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherTaxesIncomeStatement class
		/// </summary>
		public OtherTaxesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fees generated from issuing or renewing an auto insurance policy. This item is usually only available for insurance industry.
	/// </summary>
	public class PolicyFeesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyFeesIncomeStatement class
		/// </summary>
		public PolicyFeesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyFeesIncomeStatement class
		/// </summary>
		public PolicyFeesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The provision in current period for future policy benefits, claims, and claims settlement, which is under reinsurance arrangements.
	/// This item is usually only available for insurance industry.
	/// </summary>
	public class PolicyholderBenefitsCededIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyholderBenefitsCededIncomeStatement class
		/// </summary>
		public PolicyholderBenefitsCededIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyholderBenefitsCededIncomeStatement class
		/// </summary>
		public PolicyholderBenefitsCededIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The gross amount of provision in current period for future policyholder benefits, claims, and claims settlement, incurred in the
	/// claims settlement process before the effects of reinsurance arrangements. This item is usually only available for insurance industry.
	/// </summary>
	public class PolicyholderBenefitsGrossIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyholderBenefitsGrossIncomeStatement class
		/// </summary>
		public PolicyholderBenefitsGrossIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyholderBenefitsGrossIncomeStatement class
		/// </summary>
		public PolicyholderBenefitsGrossIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Payments made or credits extended to the insured by the company, usually at the end of a policy year results in reducing the net
	/// insurance cost to the policyholder. Such dividends may be paid in cash to the insured or applied by the insured as reductions of the
	/// premiums due for the next policy year. This item is usually only available for insurance industry.
	/// </summary>
	public class PolicyholderDividendsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyholderDividendsIncomeStatement class
		/// </summary>
		public PolicyholderDividendsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyholderDividendsIncomeStatement class
		/// </summary>
		public PolicyholderDividendsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The periodic income payment provided to the annuitant by the insurance company, which is determined by the assumed interest
	/// rate (AIR) and other factors. This item is usually only available for insurance industry.
	/// </summary>
	public class PolicyholderInterestIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyholderInterestIncomeStatement class
		/// </summary>
		public PolicyholderInterestIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyholderInterestIncomeStatement class
		/// </summary>
		public PolicyholderInterestIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of investment income comes from policyholder account and ceded insurance agreements. This item is
	/// usually only available for insurance industry.
	/// </summary>
	public class PolicyholderAndReinsurerAccountsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyholderAndReinsurerAccountsIncomeStatement class
		/// </summary>
		public PolicyholderAndReinsurerAccountsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyholderAndReinsurerAccountsIncomeStatement class
		/// </summary>
		public PolicyholderAndReinsurerAccountsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This relates to any distributions and earning adjustments due to Trust Preferred Securities issued by the company and its
	/// subsidiaries.
	/// </summary>
	public class TrustPreferredSecuritiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TrustPreferredSecuritiesIncomeStatement class
		/// </summary>
		public TrustPreferredSecuritiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TrustPreferredSecuritiesIncomeStatement class
		/// </summary>
		public TrustPreferredSecuritiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Schedule of revenue by reporting categories or types of financial instruments, including derivatives but excluding dividends and
	/// interests, from trading for own account by broker dealers. This item is usually only available for bank industry.
	/// </summary>
	public class PrincipleTransactionRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PrincipleTransactionRevenueIncomeStatement class
		/// </summary>
		public PrincipleTransactionRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PrincipleTransactionRevenueIncomeStatement class
		/// </summary>
		public PrincipleTransactionRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Professional and contract service expense includes cost reimbursements for support services related to contracted projects,
	/// outsourced management, technical and staff support. This item is usually only available for bank industry.
	/// </summary>
	public class ProfessionalExpenseAndContractServicesExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ProfessionalExpenseAndContractServicesExpenseIncomeStatement class
		/// </summary>
		public ProfessionalExpenseAndContractServicesExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ProfessionalExpenseAndContractServicesExpenseIncomeStatement class
		/// </summary>
		public ProfessionalExpenseAndContractServicesExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Costs associated with publicizing a good or need for sale. This category includes only expenses, which are specific as promotion, or
	/// advertising expenses.
	/// </summary>
	public class PromotionAndAdvertisingIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PromotionAndAdvertisingIncomeStatement class
		/// </summary>
		public PromotionAndAdvertisingIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PromotionAndAdvertisingIncomeStatement class
		/// </summary>
		public PromotionAndAdvertisingIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Premiums earned for all property and casualty insurance assumed from other insurers as a result of reinsurance arrangements. This
	/// item is usually only available for bank industry.
	/// </summary>
	public class PropertyCasualtyPremiumsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PropertyCasualtyPremiumsIncomeStatement class
		/// </summary>
		public PropertyCasualtyPremiumsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PropertyCasualtyPremiumsIncomeStatement class
		/// </summary>
		public PropertyCasualtyPremiumsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Amount of the current period expense charged against operations, the offset which is generally to the allowance for doubtful
	/// accounts for the purpose of reducing receivables, including notes receivable, to an amount that approximates their net realizable
	/// value (the amount expected to be collected). The category includes provision for loan losses, provision for any doubtful account
	/// receivable, and bad debt expenses. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class ProvisionForDoubtfulAccountsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ProvisionForDoubtfulAccountsIncomeStatement class
		/// </summary>
		public ProvisionForDoubtfulAccountsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ProvisionForDoubtfulAccountsIncomeStatement class
		/// </summary>
		public ProvisionForDoubtfulAccountsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of current expense charged in order to prepare for the disposal of discontinued operations.
	/// </summary>
	public class ProvisionForGainLossOnDisposalIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ProvisionForGainLossOnDisposalIncomeStatement class
		/// </summary>
		public ProvisionForGainLossOnDisposalIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ProvisionForGainLossOnDisposalIncomeStatement class
		/// </summary>
		public ProvisionForGainLossOnDisposalIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents the payment or accrual (net of fare revenues) to other transit agencies, public or private, for providing transportation
	/// service and purchased transportation (PT) fare revenues. This item is usually only available for transportation industry.
	/// </summary>
	public class PurchasedTransportationServicesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PurchasedTransportationServicesIncomeStatement class
		/// </summary>
		public PurchasedTransportationServicesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PurchasedTransportationServicesIncomeStatement class
		/// </summary>
		public PurchasedTransportationServicesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount by which an asset's selling price exceeds its initial purchase price is called capital gain. A realized capital gain is when
	/// it has been sold at a profit. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class RealizedCapitalGainIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RealizedCapitalGainIncomeStatement class
		/// </summary>
		public RealizedCapitalGainIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RealizedCapitalGainIncomeStatement class
		/// </summary>
		public RealizedCapitalGainIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Rent fees are the cost of occupying space during the accounting period. Landing fees are a change paid to an airport company for
	/// landing at a particular airport. This item is not available for insurance industry.
	/// </summary>
	public class RentAndLandingFeesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RentAndLandingFeesIncomeStatement class
		/// </summary>
		public RentAndLandingFeesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RentAndLandingFeesIncomeStatement class
		/// </summary>
		public RentAndLandingFeesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expenses that may be directed toward the discovery of new facts, natural laws, or phenomena without regard to the immediate
	/// commercial application to which the results may be put or as costs directed toward more specific goals such as product
	/// improvement or the perfection and improvement of processes or techniques of production.
	/// </summary>
	public class ResearchExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ResearchExpenseIncomeStatement class
		/// </summary>
		public ResearchExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ResearchExpenseIncomeStatement class
		/// </summary>
		public ResearchExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expenses are related to restructuring, merger, or acquisitions. Restructuring expenses are charges associated with the
	/// consolidation and relocation of operations, disposition or abandonment of operations or productive assets. Merger and acquisition
	/// expenses are the amount of costs of a business combination including legal, accounting, and other costs that were charged to
	/// expense during the period.
	/// </summary>
	public class RestructuringAndMergernAcquisitionIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RestructuringAndMergernAcquisitionIncomeStatement class
		/// </summary>
		public RestructuringAndMergernAcquisitionIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RestructuringAndMergernAcquisitionIncomeStatement class
		/// </summary>
		public RestructuringAndMergernAcquisitionIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Revenue is from transporting cargo and freight between locations. This item is usually only available for transportation industry.
	/// </summary>
	public class RevenuesCargoIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RevenuesCargoIncomeStatement class
		/// </summary>
		public RevenuesCargoIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RevenuesCargoIncomeStatement class
		/// </summary>
		public RevenuesCargoIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A transportation carrier's fare revenue is recognized in the period from carrying passengers between destinations. This item is
	/// usually only available for transportation industry.
	/// </summary>
	public class RevenuesPassengerIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RevenuesPassengerIncomeStatement class
		/// </summary>
		public RevenuesPassengerIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RevenuesPassengerIncomeStatement class
		/// </summary>
		public RevenuesPassengerIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All salary, wages, compensation, management fees, and employee benefit expenses.
	/// </summary>
	public class SalariesAndWagesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SalariesAndWagesIncomeStatement class
		/// </summary>
		public SalariesAndWagesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SalariesAndWagesIncomeStatement class
		/// </summary>
		public SalariesAndWagesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/Loss from Securities and Activities
	/// </summary>
	public class SecuritiesActivitiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SecuritiesActivitiesIncomeStatement class
		/// </summary>
		public SecuritiesActivitiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SecuritiesActivitiesIncomeStatement class
		/// </summary>
		public SecuritiesActivitiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expenses recognized in the period that are directly related to the selling and distribution of products or services.
	/// </summary>
	public class SellingExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SellingExpenseIncomeStatement class
		/// </summary>
		public SellingExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SellingExpenseIncomeStatement class
		/// </summary>
		public SellingExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes any service charges on following accounts: Demand Deposit; Checking account; Savings account; Deposit in foreign
	/// offices; ESCROW accounts; Money Market Certificates &amp; Deposit accounts, CDs (Negotiable Certificates of Deposits); NOW
	/// Accounts (Negotiable Order of Withdrawal); IRAs (Individual Retirement Accounts). This item is usually only available for bank
	/// industry.
	/// </summary>
	public class ServiceChargeOnDepositorAccountsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ServiceChargeOnDepositorAccountsIncomeStatement class
		/// </summary>
		public ServiceChargeOnDepositorAccountsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ServiceChargeOnDepositorAccountsIncomeStatement class
		/// </summary>
		public ServiceChargeOnDepositorAccountsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// On the Income Statement; The portion of a firm that is either directly or indirectly controlled by the parent, but not consolidated
	/// with the parent for purposes of the financial statements.
	/// </summary>
	public class ShareInNetIncomeOfUnconsolidatedEntitiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ShareInNetIncomeOfUnconsolidatedEntitiesIncomeStatement class
		/// </summary>
		public ShareInNetIncomeOfUnconsolidatedEntitiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ShareInNetIncomeOfUnconsolidatedEntitiesIncomeStatement class
		/// </summary>
		public ShareInNetIncomeOfUnconsolidatedEntitiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item is typically available for bank industry. On the balance sheet, the aggregate amount of time deposits, including certificates
	/// of deposits, individual retirement accounts and open accounts. On the income statement, it represents interest earned on deposits
	/// that have to stay in the bank for a certain period of time before they can be collected without sustaining a penalty. Usually includes
	/// certificates of deposits, individual retirement accounts and open accounts.
	/// </summary>
	public class TimeDepositsPlacedIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TimeDepositsPlacedIncomeStatement class
		/// </summary>
		public TimeDepositsPlacedIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TimeDepositsPlacedIncomeStatement class
		/// </summary>
		public TimeDepositsPlacedIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A broker-dealer or other financial entity may buy and sell securities exclusively for its own account, sometimes referred to as
	/// proprietary trading. The profit or loss is measured by the difference between the acquisition cost and the selling price or current
	/// market or fair value. The net gain or loss, includes both realized and unrealized, from trading cash instruments, equities and
	/// derivative contracts (including commodity contracts) that has been recognized during the accounting period for the broker dealer or
	/// other financial entity's own account. This item is typically available for bank industry.
	/// </summary>
	public class TradingGainLossIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TradingGainLossIncomeStatement class
		/// </summary>
		public TradingGainLossIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TradingGainLossIncomeStatement class
		/// </summary>
		public TradingGainLossIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Revenue from operations of public mass transportation systems (rapid transit, subway, bus, street railway, and commuter rail
	/// services), such as fares, charter fees, advertising income, and other operations revenues.
	/// </summary>
	public class TransportationRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TransportationRevenueIncomeStatement class
		/// </summary>
		public TransportationRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TransportationRevenueIncomeStatement class
		/// </summary>
		public TransportationRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Bank manages funds on behalf of its customers through the operation of various trust accounts. Any fees earned through managing
	/// those funds are called trust fees, which are recognized when earned. This item is typically available for bank industry.
	/// </summary>
	public class TrustFeesbyCommissionsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TrustFeesbyCommissionsIncomeStatement class
		/// </summary>
		public TrustFeesbyCommissionsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TrustFeesbyCommissionsIncomeStatement class
		/// </summary>
		public TrustFeesbyCommissionsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Also known as Policy Acquisition Costs; and reported by insurance companies.  The cost incurred by an insurer when deciding
	/// whether to accept or decline a risk; may include meetings with the insureds or brokers, actuarial review of loss history, or physical
	/// inspections of exposures. Also, expenses deducted from insurance company revenues (including incurred losses and acquisition
	/// costs) to determine underwriting profit.
	/// </summary>
	public class UnderwritingExpensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the UnderwritingExpensesIncomeStatement class
		/// </summary>
		public UnderwritingExpensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the UnderwritingExpensesIncomeStatement class
		/// </summary>
		public UnderwritingExpensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Reducing the book value of an asset because it is overvalued compared to the current market value.
	/// </summary>
	public class WriteDownIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the WriteDownIncomeStatement class
		/// </summary>
		public WriteDownIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the WriteDownIncomeStatement class
		/// </summary>
		public WriteDownIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Reducing the book value of an asset because it is overvalued compared to the current market value.
	/// </summary>
	public class OtherWriteDownIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherWriteDownIncomeStatement class
		/// </summary>
		public OtherWriteDownIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherWriteDownIncomeStatement class
		/// </summary>
		public OtherWriteDownIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A reduction in the value of an asset or earnings by the amount of an expense or loss.
	/// </summary>
	public class WriteOffIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the WriteOffIncomeStatement class
		/// </summary>
		public WriteOffIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the WriteOffIncomeStatement class
		/// </summary>
		public WriteOffIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A reduction in the value of an asset or earnings by the amount of an expense or loss.
	/// </summary>
	public class OtherWriteOffIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherWriteOffIncomeStatement class
		/// </summary>
		public OtherWriteOffIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherWriteOffIncomeStatement class
		/// </summary>
		public OtherWriteOffIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Usually available for the banking industry.  This is Non-Interest Income that is not otherwise classified.
	/// </summary>
	public class OtherNonInterestIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherNonInterestIncomeIncomeStatement class
		/// </summary>
		public OtherNonInterestIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherNonInterestIncomeIncomeStatement class
		/// </summary>
		public OtherNonInterestIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Insurance premium tax is a tax paid by some insurance companies and insurance brokers that sell taxable insurance within the
	/// united kingdom. This item is typically available for the insurance industry.
	/// </summary>
	public class PremiumTaxesCreditIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PremiumTaxesCreditIncomeStatement class
		/// </summary>
		public PremiumTaxesCreditIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PremiumTaxesCreditIncomeStatement class
		/// </summary>
		public PremiumTaxesCreditIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in
	/// production) in a systematic and rational manner to the periods expected to benefit from such assets.
	/// </summary>
	public class AmortizationOfIntangiblesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AmortizationOfIntangiblesIncomeStatement class
		/// </summary>
		public AmortizationOfIntangiblesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AmortizationOfIntangiblesIncomeStatement class
		/// </summary>
		public AmortizationOfIntangiblesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net Income from Continuing Operations and Discontinued Operations, added together.
	/// </summary>
	public class NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement class
		/// </summary>
		public NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement class
		/// </summary>
		public NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any gains or loss not otherwise attributable to Continuing Operations, Discontinued Operations, Extraordinary Items, Accumulated
	/// Effects of Accounting Changes or Income from Tax Loss Carryforward.
	/// </summary>
	public class NetIncomeFromOtherGainsLossesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeFromOtherGainsLossesIncomeStatement class
		/// </summary>
		public NetIncomeFromOtherGainsLossesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeFromOtherGainsLossesIncomeStatement class
		/// </summary>
		public NetIncomeFromOtherGainsLossesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Occurs if a company has had a net loss from operations on a previous year that can be carried forward to reduce net income for tax
	/// purposes.
	/// </summary>
	public class NetIncomeFromTaxLossCarryforwardIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeFromTaxLossCarryforwardIncomeStatement class
		/// </summary>
		public NetIncomeFromTaxLossCarryforwardIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeFromTaxLossCarryforwardIncomeStatement class
		/// </summary>
		public NetIncomeFromTaxLossCarryforwardIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of operating expenses associated with normal operations. Will not include any gain, loss, benefit, or income;
	/// and its value reported by the company should be &lt;0.
	/// </summary>
	public class OtherOperatingExpensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherOperatingExpensesIncomeStatement class
		/// </summary>
		public OtherOperatingExpensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherOperatingExpensesIncomeStatement class
		/// </summary>
		public OtherOperatingExpensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The sum of the money market investments held by a bank's depositors, which are FDIC insured.
	/// </summary>
	public class TotalMoneyMarketInvestmentsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalMoneyMarketInvestmentsIncomeStatement class
		/// </summary>
		public TotalMoneyMarketInvestmentsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalMoneyMarketInvestmentsIncomeStatement class
		/// </summary>
		public TotalMoneyMarketInvestmentsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The Cost Of Revenue plus Depreciation, Depletion &amp; Amortization from the IncomeStatement; minus Depreciation, Depletion &amp;
	/// Amortization from the Cash Flow Statement
	/// </summary>
	public class ReconciledCostOfRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReconciledCostOfRevenueIncomeStatement class
		/// </summary>
		public ReconciledCostOfRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReconciledCostOfRevenueIncomeStatement class
		/// </summary>
		public ReconciledCostOfRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Is Depreciation, Depletion &amp; Amortization from the Cash Flow Statement
	/// </summary>
	public class ReconciledDepreciationIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReconciledDepreciationIncomeStatement class
		/// </summary>
		public ReconciledDepreciationIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReconciledDepreciationIncomeStatement class
		/// </summary>
		public ReconciledDepreciationIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This is calculation that reverses the effects of extraordinary income or charges on Net Income, by adding back (extraordinary
	/// expense) or subtracting (extraordinary income) the value from Net Income.
	/// </summary>
	public class NormalizedIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NormalizedIncomeIncomeStatement class
		/// </summary>
		public NormalizedIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NormalizedIncomeIncomeStatement class
		/// </summary>
		public NormalizedIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expenses incurred in performance of activities not directly related to the main business of a firm, such as for the insurance or
	/// maintenance of the assets.
	/// </summary>
	public class NonOperatingExpensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonOperatingExpensesIncomeStatement class
		/// </summary>
		public NonOperatingExpensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonOperatingExpensesIncomeStatement class
		/// </summary>
		public NonOperatingExpensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The portion of an organization's income that is derived from activities not related to its core operations; such as as dividend income,
	/// profits (and losses) from investments, gains (or losses) incurred due to foreign exchange, asset write-downs and other non-
	/// operating revenues and expenses.
	/// </summary>
	public class NonOperatingIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonOperatingIncomeIncomeStatement class
		/// </summary>
		public NonOperatingIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonOperatingIncomeIncomeStatement class
		/// </summary>
		public NonOperatingIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
	/// Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
	/// Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
	/// </summary>
	public class NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement class
		/// </summary>
		public NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement class
		/// </summary>
		public NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain/Loss on the disposal of the investment.
	/// </summary>
	public class PrincipleInvestmentGainLossIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PrincipleInvestmentGainLossIncomeStatement class
		/// </summary>
		public PrincipleInvestmentGainLossIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PrincipleInvestmentGainLossIncomeStatement class
		/// </summary>
		public PrincipleInvestmentGainLossIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any gain (loss) recognized on the sale of assets or a sale which generates profit or loss, which is a difference between sales price
	/// and net book value at the disposal time.
	/// </summary>
	public class GainLossonSaleofAssetsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainLossonSaleofAssetsIncomeStatement class
		/// </summary>
		public GainLossonSaleofAssetsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainLossonSaleofAssetsIncomeStatement class
		/// </summary>
		public GainLossonSaleofAssetsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain on sale of any loans investment.
	/// </summary>
	public class GainonSaleofLoansIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainonSaleofLoansIncomeStatement class
		/// </summary>
		public GainonSaleofLoansIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainonSaleofLoansIncomeStatement class
		/// </summary>
		public GainonSaleofLoansIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain on the disposal of investment property.
	/// </summary>
	public class GainonSaleofInvestmentPropertyIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainonSaleofInvestmentPropertyIncomeStatement class
		/// </summary>
		public GainonSaleofInvestmentPropertyIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainonSaleofInvestmentPropertyIncomeStatement class
		/// </summary>
		public GainonSaleofInvestmentPropertyIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Special income that is either infrequent or unusual.
	/// </summary>
	public class SpecialIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SpecialIncomeIncomeStatement class
		/// </summary>
		public SpecialIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SpecialIncomeIncomeStatement class
		/// </summary>
		public SpecialIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income earned through R&amp;D department. This data point applies to the bank and insurance industry only.
	/// </summary>
	public class AcquiredinProcessRnDIncomeBanksIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AcquiredinProcessRnDIncomeBanksIncomeStatement class
		/// </summary>
		public AcquiredinProcessRnDIncomeBanksIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AcquiredinProcessRnDIncomeBanksIncomeStatement class
		/// </summary>
		public AcquiredinProcessRnDIncomeBanksIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Relates to restructuring, merger, or acquisitions for non-operating activities. A restructuring charge might be incurred in the process
	/// of laying off employees, closing manufacturing plants, or shifting production to a new location.
	/// Merger - When two firms, often of about the same size, agree to go forward as a single new company rather than remain
	/// separately owned and operated.
	/// Acquisition - When one company takes over another and clearly establishes itself as the new owner.
	/// </summary>
	public class RestructuringAndMergerAndAcquisitionIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RestructuringAndMergerAndAcquisitionIncomeIncomeStatement class
		/// </summary>
		public RestructuringAndMergerAndAcquisitionIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RestructuringAndMergerAndAcquisitionIncomeIncomeStatement class
		/// </summary>
		public RestructuringAndMergerAndAcquisitionIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Downward revaluation of fixed assets. Any impairment related with Fixed Assets &amp; Fixed Asset Investments comes under this
	/// exceptional data item.
	/// </summary>
	public class ImpairmentofCapitalAssetsIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ImpairmentofCapitalAssetsIncomeIncomeStatement class
		/// </summary>
		public ImpairmentofCapitalAssetsIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ImpairmentofCapitalAssetsIncomeIncomeStatement class
		/// </summary>
		public ImpairmentofCapitalAssetsIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain on extinguishment of debt is the accounting gain that results from a debt extinguishment. A debt shall be accounted for as
	/// having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by
	/// another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the
	/// payments made and the carrying amount of the debt at the time of its extinguishment.
	/// </summary>
	public class GainonExtinguishmentofDebtIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainonExtinguishmentofDebtIncomeStatement class
		/// </summary>
		public GainonExtinguishmentofDebtIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainonExtinguishmentofDebtIncomeStatement class
		/// </summary>
		public GainonExtinguishmentofDebtIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Special expenses that are either infrequent or unusual.
	/// </summary>
	public class SpecialChargeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SpecialChargeIncomeStatement class
		/// </summary>
		public SpecialChargeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SpecialChargeIncomeStatement class
		/// </summary>
		public SpecialChargeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Loss on extinguishment of debt is the accounting loss that results from a debt extinguishment. A debt shall be accounted for as
	/// having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by
	/// another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the
	/// payments made and the carrying amount of the debt at the time of its extinguishment.
	/// </summary>
	public class LossonExtinguishmentofDebtIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LossonExtinguishmentofDebtIncomeStatement class
		/// </summary>
		public LossonExtinguishmentofDebtIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LossonExtinguishmentofDebtIncomeStatement class
		/// </summary>
		public LossonExtinguishmentofDebtIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income from other equity interest reported after Provision of Tax. This applies to all industries.
	/// </summary>
	public class EarningsfromEquityInterestNetOfTaxIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EarningsfromEquityInterestNetOfTaxIncomeStatement class
		/// </summary>
		public EarningsfromEquityInterestNetOfTaxIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EarningsfromEquityInterestNetOfTaxIncomeStatement class
		/// </summary>
		public EarningsfromEquityInterestNetOfTaxIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net income of the group after the adjustment of all expenses and benefit.
	/// </summary>
	public class NetIncomeIncludingNoncontrollingInterestsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetIncomeIncludingNoncontrollingInterestsIncomeStatement class
		/// </summary>
		public NetIncomeIncludingNoncontrollingInterestsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetIncomeIncludingNoncontrollingInterestsIncomeStatement class
		/// </summary>
		public NetIncomeIncludingNoncontrollingInterestsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Dividend paid to the preferred shareholders before the common stock shareholders.
	/// </summary>
	public class OtherunderPreferredStockDividendIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherunderPreferredStockDividendIncomeStatement class
		/// </summary>
		public OtherunderPreferredStockDividendIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherunderPreferredStockDividendIncomeStatement class
		/// </summary>
		public OtherunderPreferredStockDividendIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Earnings from equity interest, accounted for in the Revenue section. An equity interest is a proportion of ownership, typically
	/// through the investment in a business.
	/// </summary>
	public class EarningsfromEquityInterestRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EarningsfromEquityInterestRevenueIncomeStatement class
		/// </summary>
		public EarningsfromEquityInterestRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EarningsfromEquityInterestRevenueIncomeStatement class
		/// </summary>
		public EarningsfromEquityInterestRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain/loss on the disposal of assets.
	/// </summary>
	public class GainLossfromDisposalSaleofAssetsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainLossfromDisposalSaleofAssetsIncomeStatement class
		/// </summary>
		public GainLossfromDisposalSaleofAssetsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainLossfromDisposalSaleofAssetsIncomeStatement class
		/// </summary>
		public GainLossfromDisposalSaleofAssetsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain/loss on the disposal of assets in the Non-Operating section.
	/// </summary>
	public class GainLossfromDisposalSaleofAssetsOtherIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainLossfromDisposalSaleofAssetsOtherIncomeStatement class
		/// </summary>
		public GainLossfromDisposalSaleofAssetsOtherIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainLossfromDisposalSaleofAssetsOtherIncomeStatement class
		/// </summary>
		public GainLossfromDisposalSaleofAssetsOtherIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain on disposal of real estate by the bank.
	/// </summary>
	public class GainonSaleofOtherRealEstateOwnedIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainonSaleofOtherRealEstateOwnedIncomeStatement class
		/// </summary>
		public GainonSaleofOtherRealEstateOwnedIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainonSaleofOtherRealEstateOwnedIncomeStatement class
		/// </summary>
		public GainonSaleofOtherRealEstateOwnedIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest income, accounted for in the Revenue section.
	/// </summary>
	public class InterestIncomeRevenueIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeRevenueIncomeStatement class
		/// </summary>
		public InterestIncomeRevenueIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeRevenueIncomeStatement class
		/// </summary>
		public InterestIncomeRevenueIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expenses incurred by the company in relation to legal matters.
	/// </summary>
	public class LitigationExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LitigationExpenseIncomeStatement class
		/// </summary>
		public LitigationExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LitigationExpenseIncomeStatement class
		/// </summary>
		public LitigationExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Adjustments to the value of investments, excluding temporary write-downs.
	/// </summary>
	public class OtherthanTemporaryImpairmentLossesInvestmentsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherthanTemporaryImpairmentLossesInvestmentsIncomeStatement class
		/// </summary>
		public OtherthanTemporaryImpairmentLossesInvestmentsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherthanTemporaryImpairmentLossesInvestmentsIncomeStatement class
		/// </summary>
		public OtherthanTemporaryImpairmentLossesInvestmentsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Unrealized gains/losses incurred by the company in the Non-Operating section.
	/// </summary>
	public class UnrealizedGainorLossIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the UnrealizedGainorLossIncomeStatement class
		/// </summary>
		public UnrealizedGainorLossIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the UnrealizedGainorLossIncomeStatement class
		/// </summary>
		public UnrealizedGainorLossIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/expense due to changes between periods in inventory.
	/// </summary>
	public class ChangesinInventoriesofFinishedGoodsandWorkinProgressIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ChangesinInventoriesofFinishedGoodsandWorkinProgressIncomeStatement class
		/// </summary>
		public ChangesinInventoriesofFinishedGoodsandWorkinProgressIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ChangesinInventoriesofFinishedGoodsandWorkinProgressIncomeStatement class
		/// </summary>
		public ChangesinInventoriesofFinishedGoodsandWorkinProgressIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An amount paid in respect of work performed by entity.
	/// </summary>
	public class WorkPerformedbyEntityandCapitalizedIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the WorkPerformedbyEntityandCapitalizedIncomeStatement class
		/// </summary>
		public WorkPerformedbyEntityandCapitalizedIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the WorkPerformedbyEntityandCapitalizedIncomeStatement class
		/// </summary>
		public WorkPerformedbyEntityandCapitalizedIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Expenditures occurred on the distribution of the products.
	/// </summary>
	public class DistributionCostsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DistributionCostsIncomeStatement class
		/// </summary>
		public DistributionCostsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DistributionCostsIncomeStatement class
		/// </summary>
		public DistributionCostsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total staff cost which is paid to the employees that is not part of Selling, General, and Administration expense.
	/// </summary>
	public class StaffCostsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the StaffCostsIncomeStatement class
		/// </summary>
		public StaffCostsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the StaffCostsIncomeStatement class
		/// </summary>
		public StaffCostsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Benefits paid to the employees in respect of their work.
	/// </summary>
	public class SocialSecurityCostsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SocialSecurityCostsIncomeStatement class
		/// </summary>
		public SocialSecurityCostsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SocialSecurityCostsIncomeStatement class
		/// </summary>
		public SocialSecurityCostsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The expense that a company incurs each year by providing a pension plan for its employees. Major expenses in the pension cost
	/// include employer matching contributions and management fees.
	/// </summary>
	public class PensionCostsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PensionCostsIncomeStatement class
		/// </summary>
		public PensionCostsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PensionCostsIncomeStatement class
		/// </summary>
		public PensionCostsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total Other Operating Income- including interest income, dividend income and other types of operating income.
	/// </summary>
	public class OtherOperatingIncomeTotalIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherOperatingIncomeTotalIncomeStatement class
		/// </summary>
		public OtherOperatingIncomeTotalIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherOperatingIncomeTotalIncomeStatement class
		/// </summary>
		public OtherOperatingIncomeTotalIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Share of profit from joint ventures and associates, accounted for in the Operating section.
	/// </summary>
	public class ShareofOperatingProfitLossfromJointVenturesAndAssociatesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ShareofOperatingProfitLossfromJointVenturesAndAssociatesIncomeStatement class
		/// </summary>
		public ShareofOperatingProfitLossfromJointVenturesAndAssociatesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ShareofOperatingProfitLossfromJointVenturesAndAssociatesIncomeStatement class
		/// </summary>
		public ShareofOperatingProfitLossfromJointVenturesAndAssociatesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total value of non-recurring items in the Non-Operating section.
	/// </summary>
	public class ExceptionalItemsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ExceptionalItemsIncomeStatement class
		/// </summary>
		public ExceptionalItemsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ExceptionalItemsIncomeStatement class
		/// </summary>
		public ExceptionalItemsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income from the related companies- subsidiaries and other equity holdings, accounted for in the Non-Operating section.
	/// </summary>
	public class IncomefromSharesinSubsidiariesGroupUndertakingsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the IncomefromSharesinSubsidiariesGroupUndertakingsIncomeStatement class
		/// </summary>
		public IncomefromSharesinSubsidiariesGroupUndertakingsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the IncomefromSharesinSubsidiariesGroupUndertakingsIncomeStatement class
		/// </summary>
		public IncomefromSharesinSubsidiariesGroupUndertakingsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total income from the associates and joint venture via investment, accounted for in the Non-Operating section.
	/// </summary>
	public class IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement class
		/// </summary>
		public IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement class
		/// </summary>
		public IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any other finance cost which is not clearly defined in the Non-Operating section.
	/// </summary>
	public class TotalOtherFinanceCostIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalOtherFinanceCostIncomeStatement class
		/// </summary>
		public TotalOtherFinanceCostIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalOtherFinanceCostIncomeStatement class
		/// </summary>
		public TotalOtherFinanceCostIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total amount paid in dividends to investors- this includes dividends paid on equity and non-equity shares.
	/// </summary>
	public class GrossDividendPaymentIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GrossDividendPaymentIncomeStatement class
		/// </summary>
		public GrossDividendPaymentIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GrossDividendPaymentIncomeStatement class
		/// </summary>
		public GrossDividendPaymentIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income from cash and cash equivalents, short-term securities, debt securities, mortgage and loans, derivative investments, policy
	/// loans and other interest income.
	/// </summary>
	public class InterestandSimilarIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestandSimilarIncomeIncomeStatement class
		/// </summary>
		public InterestandSimilarIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestandSimilarIncomeIncomeStatement class
		/// </summary>
		public InterestandSimilarIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fees and commission income earned by bank and insurance companies on the rendering services.
	/// </summary>
	public class FeesandCommissionIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FeesandCommissionIncomeIncomeStatement class
		/// </summary>
		public FeesandCommissionIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FeesandCommissionIncomeIncomeStatement class
		/// </summary>
		public FeesandCommissionIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Cost incurred by bank and insurance companies for fees and commission income.
	/// </summary>
	public class FeesandCommissionExpenseIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FeesandCommissionExpenseIncomeStatement class
		/// </summary>
		public FeesandCommissionExpenseIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FeesandCommissionExpenseIncomeStatement class
		/// </summary>
		public FeesandCommissionExpenseIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any trading income on the securities.
	/// </summary>
	public class NetTradingIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetTradingIncomeIncomeStatement class
		/// </summary>
		public NetTradingIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetTradingIncomeIncomeStatement class
		/// </summary>
		public NetTradingIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Payment of reinsurance premium.
	/// </summary>
	public class OutwardReinsurancePremiumsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OutwardReinsurancePremiumsIncomeStatement class
		/// </summary>
		public OutwardReinsurancePremiumsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OutwardReinsurancePremiumsIncomeStatement class
		/// </summary>
		public OutwardReinsurancePremiumsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other costs in incurred in lieu of the employees that cannot be identified by other specific items in the Staff Costs section.
	/// </summary>
	public class OtherStaffCostsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherStaffCostsIncomeStatement class
		/// </summary>
		public OtherStaffCostsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherStaffCostsIncomeStatement class
		/// </summary>
		public OtherStaffCostsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Stock based expenses that occur in normal activities.
	/// </summary>
	public class ShareBasedPaymentsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ShareBasedPaymentsIncomeStatement class
		/// </summary>
		public ShareBasedPaymentsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ShareBasedPaymentsIncomeStatement class
		/// </summary>
		public ShareBasedPaymentsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain on disposal and change in fair value of investment properties.
	/// </summary>
	public class GainonInvestmentPropertiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainonInvestmentPropertiesIncomeStatement class
		/// </summary>
		public GainonInvestmentPropertiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainonInvestmentPropertiesIncomeStatement class
		/// </summary>
		public GainonInvestmentPropertiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Adjustments to reported net income to calculate Diluted EPS, by assuming that all convertible instruments are converted to
	/// Common Equity. The adjustments usually include the interest expense of debentures when assumed converted and preferred
	/// dividends of convertible preferred stock when assumed converted.
	/// </summary>
	public class AverageDilutionEarningsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AverageDilutionEarningsIncomeStatement class
		/// </summary>
		public AverageDilutionEarningsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AverageDilutionEarningsIncomeStatement class
		/// </summary>
		public AverageDilutionEarningsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain on the redemption of the loan or repayment of the loan.
	/// </summary>
	public class GainonRedemptionandExtinguishmentofDebtIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainonRedemptionandExtinguishmentofDebtIncomeStatement class
		/// </summary>
		public GainonRedemptionandExtinguishmentofDebtIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainonRedemptionandExtinguishmentofDebtIncomeStatement class
		/// </summary>
		public GainonRedemptionandExtinguishmentofDebtIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other income of the company that cannot be identified by other specific items in the Operating Income section.
	/// </summary>
	public class MiscellaneousOtherOperatingIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MiscellaneousOtherOperatingIncomeIncomeStatement class
		/// </summary>
		public MiscellaneousOtherOperatingIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MiscellaneousOtherOperatingIncomeIncomeStatement class
		/// </summary>
		public MiscellaneousOtherOperatingIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain/Loss through hedging activities.
	/// </summary>
	public class GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement class
		/// </summary>
		public GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement class
		/// </summary>
		public GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain/loss on the write-off of financial assets available-for-sale.
	/// </summary>
	public class GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement class
		/// </summary>
		public GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement class
		/// </summary>
		public GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain/loss on the write-off of any non-current assets.
	/// </summary>
	public class GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotalIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotalIncomeStatement class
		/// </summary>
		public GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotalIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotalIncomeStatement class
		/// </summary>
		public GainLossonDerecognitionofNonCurrentAssetsNotHeldforSaleTotalIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Negative Goodwill recognized in the Income Statement. Negative Goodwill arises where the net assets at the date of acquisition,
	/// fairly valued, falls below the cost of acquisition.
	/// </summary>
	public class NegativeGoodwillImmediatelyRecognizedIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NegativeGoodwillImmediatelyRecognizedIncomeStatement class
		/// </summary>
		public NegativeGoodwillImmediatelyRecognizedIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NegativeGoodwillImmediatelyRecognizedIncomeStatement class
		/// </summary>
		public NegativeGoodwillImmediatelyRecognizedIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain or loss on derivatives investment due to the fair value adjustment.
	/// </summary>
	public class GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement class
		/// </summary>
		public GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement class
		/// </summary>
		public GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Impairment or reversal of impairment on financial instrument such as derivative. This is a contra account under Total Revenue in
	/// banks.
	/// </summary>
	public class ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement class
		/// </summary>
		public ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement class
		/// </summary>
		public ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income from equity investments in the Non-Operating section.
	/// </summary>
	public class ShareofProfitLossfromEquityAccountedInvestmentsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ShareofProfitLossfromEquityAccountedInvestmentsIncomeStatement class
		/// </summary>
		public ShareofProfitLossfromEquityAccountedInvestmentsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ShareofProfitLossfromEquityAccountedInvestmentsIncomeStatement class
		/// </summary>
		public ShareofProfitLossfromEquityAccountedInvestmentsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All reported claims arising out of incidents in that year are considered incurred grouped with claims paid out.
	/// </summary>
	public class ClaimsandPaidIncurredIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ClaimsandPaidIncurredIncomeStatement class
		/// </summary>
		public ClaimsandPaidIncurredIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ClaimsandPaidIncurredIncomeStatement class
		/// </summary>
		public ClaimsandPaidIncurredIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Claim on the reinsurance company and take the benefits.
	/// </summary>
	public class ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement class
		/// </summary>
		public ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement class
		/// </summary>
		public ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/Expense due to changes between periods in insurance liabilities.
	/// </summary>
	public class ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement class
		/// </summary>
		public ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement class
		/// </summary>
		public ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/Expense due to changes between periods in Investment Contracts.
	/// </summary>
	public class ChangeinInvestmentContractIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ChangeinInvestmentContractIncomeStatement class
		/// </summary>
		public ChangeinInvestmentContractIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ChangeinInvestmentContractIncomeStatement class
		/// </summary>
		public ChangeinInvestmentContractIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/Expense due to changes between periods in Reinsurance Assets.
	/// </summary>
	public class ChangeinReinsuranceAssetsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ChangeinReinsuranceAssetsIncomeStatement class
		/// </summary>
		public ChangeinReinsuranceAssetsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ChangeinReinsuranceAssetsIncomeStatement class
		/// </summary>
		public ChangeinReinsuranceAssetsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Provision for the risk of loss of principal or loss of a financial reward stemming from a borrower's failure to repay a loan or otherwise
	/// meet a contractual obligation. Credit risk arises whenever a borrower is expecting to use future cash flows to pay a current debt.
	/// Investors are compensated for assuming credit risk by way of interest payments from the borrower or issuer of a debt obligation.
	/// This is a contra account under Total Revenue in banks.
	/// </summary>
	public class CreditRiskProvisionsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CreditRiskProvisionsIncomeStatement class
		/// </summary>
		public CreditRiskProvisionsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CreditRiskProvisionsIncomeStatement class
		/// </summary>
		public CreditRiskProvisionsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This is the portion under Staff Costs that represents salary paid to the employees in respect of their work.
	/// </summary>
	public class WagesandSalariesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the WagesandSalariesIncomeStatement class
		/// </summary>
		public WagesandSalariesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the WagesandSalariesIncomeStatement class
		/// </summary>
		public WagesandSalariesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total other income and expense of the company that cannot be identified by other specific items in the Non-Operating section.
	/// </summary>
	public class OtherNonOperatingIncomeExpensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherNonOperatingIncomeExpensesIncomeStatement class
		/// </summary>
		public OtherNonOperatingIncomeExpensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherNonOperatingIncomeExpensesIncomeStatement class
		/// </summary>
		public OtherNonOperatingIncomeExpensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest income earned by normal operating activities.
	/// </summary>
	public class InterestIncomeOtherOperatingIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestIncomeOtherOperatingIncomeIncomeStatement class
		/// </summary>
		public InterestIncomeOtherOperatingIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestIncomeOtherOperatingIncomeIncomeStatement class
		/// </summary>
		public InterestIncomeOtherOperatingIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other income of the company that cannot be identified by other specific items in the Non-Operating section.
	/// </summary>
	public class OtherNonOperatingIncomeIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherNonOperatingIncomeIncomeStatement class
		/// </summary>
		public OtherNonOperatingIncomeIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherNonOperatingIncomeIncomeStatement class
		/// </summary>
		public OtherNonOperatingIncomeIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other expenses of the company that cannot be identified by other specific items in the Non-Operating section.
	/// </summary>
	public class OtherNonOperatingExpensesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherNonOperatingExpensesIncomeStatement class
		/// </summary>
		public OtherNonOperatingExpensesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherNonOperatingExpensesIncomeStatement class
		/// </summary>
		public OtherNonOperatingExpensesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total unusual items including Negative Goodwill.
	/// </summary>
	public class TotalUnusualItemsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalUnusualItemsIncomeStatement class
		/// </summary>
		public TotalUnusualItemsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalUnusualItemsIncomeStatement class
		/// </summary>
		public TotalUnusualItemsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The sum of all the identifiable operating and non-operating unusual items.
	/// </summary>
	public class TotalUnusualItemsExcludingGoodwillIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalUnusualItemsExcludingGoodwillIncomeStatement class
		/// </summary>
		public TotalUnusualItemsExcludingGoodwillIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalUnusualItemsExcludingGoodwillIncomeStatement class
		/// </summary>
		public TotalUnusualItemsExcludingGoodwillIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Tax rate used for Morningstar calculations.
	/// </summary>
	public class TaxRateForCalcsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TaxRateForCalcsIncomeStatement class
		/// </summary>
		public TaxRateForCalcsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TaxRateForCalcsIncomeStatement class
		/// </summary>
		public TaxRateForCalcsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Tax effect of the usual items
	/// </summary>
	public class TaxEffectOfUnusualItemsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TaxEffectOfUnusualItemsIncomeStatement class
		/// </summary>
		public TaxEffectOfUnusualItemsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TaxEffectOfUnusualItemsIncomeStatement class
		/// </summary>
		public TaxEffectOfUnusualItemsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// EBITDA - Total Unusual Items
	/// </summary>
	public class NormalizedEBITDAIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NormalizedEBITDAIncomeStatement class
		/// </summary>
		public NormalizedEBITDAIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NormalizedEBITDAIncomeStatement class
		/// </summary>
		public NormalizedEBITDAIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Gain or loss resulting from an appreciation or devaluation of the non-local currency from borrowings related interest income or
	/// expenses.
	/// </summary>
	public class GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCostsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCostsIncomeStatement class
		/// </summary>
		public GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCostsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCostsIncomeStatement class
		/// </summary>
		public GainOnForeignCurrencyExchangeFromBorrowingsRelatingToInterestCostsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The cost to the company for granting stock options to reward employees.
	/// </summary>
	public class StockBasedCompensationIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the StockBasedCompensationIncomeStatement class
		/// </summary>
		public StockBasedCompensationIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the StockBasedCompensationIncomeStatement class
		/// </summary>
		public StockBasedCompensationIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net income to calculate Diluted EPS, accounting for adjustments assuming that all the convertible instruments are being converted
	/// to Common Equity.
	/// </summary>
	public class DilutedNIAvailtoComStockholdersIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DilutedNIAvailtoComStockholdersIncomeStatement class
		/// </summary>
		public DilutedNIAvailtoComStockholdersIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DilutedNIAvailtoComStockholdersIncomeStatement class
		/// </summary>
		public DilutedNIAvailtoComStockholdersIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/Expenses due to the insurer's liabilities incurred in Investment Contracts.
	/// </summary>
	public class InvestmentContractLiabilitiesIncurredIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InvestmentContractLiabilitiesIncurredIncomeStatement class
		/// </summary>
		public InvestmentContractLiabilitiesIncurredIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InvestmentContractLiabilitiesIncurredIncomeStatement class
		/// </summary>
		public InvestmentContractLiabilitiesIncurredIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/Expense due to recoveries from reinsurers for Investment Contracts.
	/// </summary>
	public class ReinsuranceRecoveriesofInvestmentContractIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoveriesofInvestmentContractIncomeStatement class
		/// </summary>
		public ReinsuranceRecoveriesofInvestmentContractIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoveriesofInvestmentContractIncomeStatement class
		/// </summary>
		public ReinsuranceRecoveriesofInvestmentContractIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total amount paid in dividends to equity securities investors.
	/// </summary>
	public class TotalDividendPaymentofEquitySharesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalDividendPaymentofEquitySharesIncomeStatement class
		/// </summary>
		public TotalDividendPaymentofEquitySharesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalDividendPaymentofEquitySharesIncomeStatement class
		/// </summary>
		public TotalDividendPaymentofEquitySharesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total amount paid in dividends to Non-Equity securities investors.
	/// </summary>
	public class TotalDividendPaymentofNonEquitySharesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalDividendPaymentofNonEquitySharesIncomeStatement class
		/// </summary>
		public TotalDividendPaymentofNonEquitySharesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalDividendPaymentofNonEquitySharesIncomeStatement class
		/// </summary>
		public TotalDividendPaymentofNonEquitySharesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The change in the amount of the unearned premium reserves maintained by insurers.
	/// </summary>
	public class ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement class
		/// </summary>
		public ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement class
		/// </summary>
		public ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The change in the amount of unearned premium reserve to be covered by reinsurers.
	/// </summary>
	public class ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement class
		/// </summary>
		public ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement class
		/// </summary>
		public ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/Expense due to the insurer's changes in insurance liabilities.
	/// </summary>
	public class ClaimsandChangeinInsuranceLiabilitiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ClaimsandChangeinInsuranceLiabilitiesIncomeStatement class
		/// </summary>
		public ClaimsandChangeinInsuranceLiabilitiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ClaimsandChangeinInsuranceLiabilitiesIncomeStatement class
		/// </summary>
		public ClaimsandChangeinInsuranceLiabilitiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income/Expense due to recoveries from reinsurers for insurance liabilities.
	/// </summary>
	public class ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement class
		/// </summary>
		public ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement class
		/// </summary>
		public ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Any money that a company owes its suppliers for goods and services purchased on credit and is expected to pay within the next
	/// year or operating cycle.
	/// </summary>
	public class AccountsPayableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AccountsPayableBalanceSheet class
		/// </summary>
		public AccountsPayableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AccountsPayableBalanceSheet class
		/// </summary>
		public AccountsPayableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Accounts owed to a company by customers within a year as a result of exchanging goods or services on credit.
	/// </summary>
	public class AccountsReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AccountsReceivableBalanceSheet class
		/// </summary>
		public AccountsReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AccountsReceivableBalanceSheet class
		/// </summary>
		public AccountsReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An expense recognized before it is paid for. Includes compensation, interest, pensions and all other miscellaneous accruals
	/// reported by the company. Expenses incurred during the accounting period, but not required to be paid until a later date.
	/// </summary>
	public class CurrentAccruedExpensesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentAccruedExpensesBalanceSheet class
		/// </summary>
		public CurrentAccruedExpensesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentAccruedExpensesBalanceSheet class
		/// </summary>
		public CurrentAccruedExpensesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An expense that has occurred but the transaction has not been entered in the accounting records. Accordingly, an adjusting entry
	/// is made to debit the appropriate expense account and to credit a liability account such as accrued expenses payable or accounts
	/// payable.
	/// </summary>
	public class NonCurrentAccruedExpensesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentAccruedExpensesBalanceSheet class
		/// </summary>
		public NonCurrentAccruedExpensesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentAccruedExpensesBalanceSheet class
		/// </summary>
		public NonCurrentAccruedExpensesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Interest, dividends, rents, ancillary and other revenues earned but not yet received by the entity on its investments.
	/// </summary>
	public class AccruedInvestmentIncomeBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AccruedInvestmentIncomeBalanceSheet class
		/// </summary>
		public AccruedInvestmentIncomeBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AccruedInvestmentIncomeBalanceSheet class
		/// </summary>
		public AccruedInvestmentIncomeBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The cumulative amount of wear and tear or obsolescence charged against the fixed assets of a company.
	/// </summary>
	public class AccumulatedDepreciationBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AccumulatedDepreciationBalanceSheet class
		/// </summary>
		public AccumulatedDepreciationBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AccumulatedDepreciationBalanceSheet class
		/// </summary>
		public AccumulatedDepreciationBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of gains or losses that are not part of retained earnings. It is also called other comprehensive income.
	/// </summary>
	public class GainsLossesNotAffectingRetainedEarningsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GainsLossesNotAffectingRetainedEarningsBalanceSheet class
		/// </summary>
		public GainsLossesNotAffectingRetainedEarningsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GainsLossesNotAffectingRetainedEarningsBalanceSheet class
		/// </summary>
		public GainsLossesNotAffectingRetainedEarningsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Excess of issue price over par or stated value of the entity's capital stock and amounts received from other transactions involving
	/// the entity's stock or stockholders. Includes adjustments to additional paid in capital. There are two major categories of additional
	/// paid in capital: 1) Paid in capital in excess of par/stated value, which is the difference between the actual issue price of the shares
	/// and the shares' par/stated value. 2) Paid in capital from other transactions which includes treasury stock, retirement of stock, stock
	/// dividends recorded at market, lapse of stock purchase warrants, conversion of convertible bonds in excess of the par value of the
	/// stock, and any other additional capital from the company's own stock transactions.
	/// </summary>
	public class AdditionalPaidInCapitalBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AdditionalPaidInCapitalBalanceSheet class
		/// </summary>
		public AdditionalPaidInCapitalBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AdditionalPaidInCapitalBalanceSheet class
		/// </summary>
		public AdditionalPaidInCapitalBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A contra account sets aside as an allowance for bad loans (e.g. customer defaults).
	/// </summary>
	public class AllowanceForLoansAndLeaseLossesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AllowanceForLoansAndLeaseLossesBalanceSheet class
		/// </summary>
		public AllowanceForLoansAndLeaseLossesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AllowanceForLoansAndLeaseLossesBalanceSheet class
		/// </summary>
		public AllowanceForLoansAndLeaseLossesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// For an unclassified balance sheet, this item represents equity securities categorized neither as held-to-maturity nor trading. Equity
	/// securities represent ownership interests or the right to acquire ownership interests in corporations and other legal entities which
	/// ownership interest is represented by shares of common or preferred stock (which is not mandatory redeemable or redeemable at
	/// the option of the holder), convertible securities, stock rights, or stock warrants. This category includes preferred stocks, available-
	/// for-sale and common stock, available-for-sale.
	/// </summary>
	public class AvailableForSaleSecuritiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AvailableForSaleSecuritiesBalanceSheet class
		/// </summary>
		public AvailableForSaleSecuritiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AvailableForSaleSecuritiesBalanceSheet class
		/// </summary>
		public AvailableForSaleSecuritiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The total amount of stock authorized for issue by a corporation, including common and preferred stock.
	/// </summary>
	public class CapitalStockBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CapitalStockBalanceSheet class
		/// </summary>
		public CapitalStockBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CapitalStockBalanceSheet class
		/// </summary>
		public CapitalStockBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Cash includes currency on hand as well as demand deposits with banks or financial institutions. It also includes other kinds of
	/// accounts that have the general characteristics of demand deposits in that the customer may deposit additional funds at any time
	/// and also effectively may withdraw funds at any time without prior notice or penalty.
	/// </summary>
	public class CashBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CashBalanceSheet class
		/// </summary>
		public CashBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CashBalanceSheet class
		/// </summary>
		public CashBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Cash equivalents, excluding items classified as marketable securities, include short-term, highly liquid investments that are both
	/// readily convertible to known amounts of cash, and so near their maturity that they present insignificant risk of changes in value
	/// because of changes in interest rates.  Generally, only investments with original maturities of three months or less qualify under this
	/// definition. Original maturity means original maturity to the entity holding the investment. For example, both a three-month US
	/// Treasury bill and a three-year Treasury note purchased three months from maturity qualify as cash equivalents. However, a Treasury
	/// note purchased three years ago does not become a cash equivalent when its remaining maturity is three months.
	/// </summary>
	public class CashEquivalentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CashEquivalentsBalanceSheet class
		/// </summary>
		public CashEquivalentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CashEquivalentsBalanceSheet class
		/// </summary>
		public CashEquivalentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes unrestricted cash on hand, money market instruments and other debt securities which can be converted to cash
	/// immediately.
	/// </summary>
	public class CashAndCashEquivalentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CashAndCashEquivalentsBalanceSheet class
		/// </summary>
		public CashAndCashEquivalentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CashAndCashEquivalentsBalanceSheet class
		/// </summary>
		public CashAndCashEquivalentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Includes cash on hand (currency and coin), cash items in process of collection, non-interest bearing deposits due from other
	/// financial institutions (including corporate credit unions), and balances with the Federal Reserve Banks, Federal Home Loan Banks
	/// and central banks.
	/// </summary>
	public class CashAndDueFromBanksBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CashAndDueFromBanksBalanceSheet class
		/// </summary>
		public CashAndDueFromBanksBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CashAndDueFromBanksBalanceSheet class
		/// </summary>
		public CashAndDueFromBanksBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of cash, cash equivalents, and federal funds sold.
	/// </summary>
	public class CashCashEquivalentsAndFederalFundsSoldBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CashCashEquivalentsAndFederalFundsSoldBalanceSheet class
		/// </summary>
		public CashCashEquivalentsAndFederalFundsSoldBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CashCashEquivalentsAndFederalFundsSoldBalanceSheet class
		/// </summary>
		public CashCashEquivalentsAndFederalFundsSoldBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of cash, cash equivalents, and marketable securities.
	/// </summary>
	public class CashCashEquivalentsAndMarketableSecuritiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CashCashEquivalentsAndMarketableSecuritiesBalanceSheet class
		/// </summary>
		public CashCashEquivalentsAndMarketableSecuritiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CashCashEquivalentsAndMarketableSecuritiesBalanceSheet class
		/// </summary>
		public CashCashEquivalentsAndMarketableSecuritiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Common stock (all issues) at par value, as reported within the Stockholder's Equity section of the balance sheet; i.e. it is one
	/// component of Common Stockholder's Equity
	/// </summary>
	public class CommonStockBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CommonStockBalanceSheet class
		/// </summary>
		public CommonStockBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CommonStockBalanceSheet class
		/// </summary>
		public CommonStockBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The total amount of assets considered to be convertible into cash within a relatively short period of time, usually a year.
	/// </summary>
	public class CurrentAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentAssetsBalanceSheet class
		/// </summary>
		public CurrentAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentAssetsBalanceSheet class
		/// </summary>
		public CurrentAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents the total amount of long-term debt such as bank loans and commercial paper, which is due within one year.
	/// </summary>
	public class CurrentDebtBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentDebtBalanceSheet class
		/// </summary>
		public CurrentDebtBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentDebtBalanceSheet class
		/// </summary>
		public CurrentDebtBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All borrowings due within one year including current portions of long-term debt and capital leases as well as short-term debt such
	/// as bank loans and commercial paper.
	/// </summary>
	public class CurrentDebtAndCapitalLeaseObligationBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentDebtAndCapitalLeaseObligationBalanceSheet class
		/// </summary>
		public CurrentDebtAndCapitalLeaseObligationBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentDebtAndCapitalLeaseObligationBalanceSheet class
		/// </summary>
		public CurrentDebtAndCapitalLeaseObligationBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The debts or obligations of the firm that are due within one year.
	/// </summary>
	public class CurrentLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentLiabilitiesBalanceSheet class
		/// </summary>
		public CurrentLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentLiabilitiesBalanceSheet class
		/// </summary>
		public CurrentLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents the total amount of long-term capital leases that must be paid within the next accounting period. Capital lease
	/// obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract.
	/// </summary>
	public class CurrentCapitalLeaseObligationBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentCapitalLeaseObligationBalanceSheet class
		/// </summary>
		public CurrentCapitalLeaseObligationBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentCapitalLeaseObligationBalanceSheet class
		/// </summary>
		public CurrentCapitalLeaseObligationBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An amount owed to a firm that is not expected to be received by the firm within one year from the date of the balance sheet.
	/// </summary>
	public class DeferredAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DeferredAssetsBalanceSheet class
		/// </summary>
		public DeferredAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DeferredAssetsBalanceSheet class
		/// </summary>
		public DeferredAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An expenditure not recognized as a cost of operation of the period in which incurred, but carried forward to be written off in future
	/// periods.
	/// </summary>
	public class DeferredCostsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DeferredCostsBalanceSheet class
		/// </summary>
		public DeferredCostsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DeferredCostsBalanceSheet class
		/// </summary>
		public DeferredCostsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents the non-current portion of obligations, which is a liability that usually would have been paid but is now past due.
	/// </summary>
	public class NonCurrentDeferredLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredLiabilitiesBalanceSheet class
		/// </summary>
		public NonCurrentDeferredLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredLiabilitiesBalanceSheet class
		/// </summary>
		public NonCurrentDeferredLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents the current portion of obligations, which is a liability that usually would have been paid but is now past due.
	/// </summary>
	public class CurrentDeferredLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentDeferredLiabilitiesBalanceSheet class
		/// </summary>
		public CurrentDeferredLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentDeferredLiabilitiesBalanceSheet class
		/// </summary>
		public CurrentDeferredLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Net amount of deferred policy acquisition costs capitalized on contracts remaining in force as of the balance sheet date.
	/// </summary>
	public class DeferredPolicyAcquisitionCostsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DeferredPolicyAcquisitionCostsBalanceSheet class
		/// </summary>
		public DeferredPolicyAcquisitionCostsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DeferredPolicyAcquisitionCostsBalanceSheet class
		/// </summary>
		public DeferredPolicyAcquisitionCostsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents collections of cash or other assets related to revenue producing activity for which revenue has not yet been recognized.
	/// Generally, an entity records deferred revenue when it receives consideration from a customer before achieving certain criteria that
	/// must be met for revenue to be recognized in conformity with GAAP. It can be either current or non-current item. Also called
	/// unearned revenue.
	/// </summary>
	public class CurrentDeferredRevenueBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentDeferredRevenueBalanceSheet class
		/// </summary>
		public CurrentDeferredRevenueBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentDeferredRevenueBalanceSheet class
		/// </summary>
		public CurrentDeferredRevenueBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The non-current portion of deferred revenue amount as of the balance sheet date. Deferred revenue is a liability related to revenue
	/// producing activity for which revenue has not yet been recognized, and is not expected be recognized in the next twelve months.
	/// </summary>
	public class NonCurrentDeferredRevenueBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredRevenueBalanceSheet class
		/// </summary>
		public NonCurrentDeferredRevenueBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredRevenueBalanceSheet class
		/// </summary>
		public NonCurrentDeferredRevenueBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An asset on a company's balance sheet that may be used to reduce any subsequent period's income tax expense. Deferred tax
	/// assets can arise due to net loss carryovers, which are only recorded as assets if it is deemed more likely than not that the asset
	/// will be used in future fiscal periods.
	/// </summary>
	public class DeferredTaxAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DeferredTaxAssetsBalanceSheet class
		/// </summary>
		public DeferredTaxAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DeferredTaxAssetsBalanceSheet class
		/// </summary>
		public DeferredTaxAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Meaning a future tax asset, resulting from temporary differences between book (accounting) value of assets and liabilities and their
	/// tax value, or timing differences between the recognition of gains and losses in financial statements and their recognition in a tax
	/// computation. It is also called future tax.
	/// </summary>
	public class CurrentDeferredTaxesAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentDeferredTaxesAssetsBalanceSheet class
		/// </summary>
		public CurrentDeferredTaxesAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentDeferredTaxesAssetsBalanceSheet class
		/// </summary>
		public CurrentDeferredTaxesAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Meaning a future tax liability, resulting from temporary differences between book (accounting) value of assets and liabilities and
	/// their tax value, or timing differences between the recognition of gains and losses in financial statements and their recognition in a
	/// tax computation. Deferred tax liabilities generally arise where tax relief is provided in advance of an accounting expense, or income
	/// is accrued but not taxed until received.
	/// </summary>
	public class CurrentDeferredTaxesLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentDeferredTaxesLiabilitiesBalanceSheet class
		/// </summary>
		public CurrentDeferredTaxesLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentDeferredTaxesLiabilitiesBalanceSheet class
		/// </summary>
		public CurrentDeferredTaxesLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A result of timing differences between taxable incomes reported on the income statement and taxable income from the company's
	/// tax return. Depending on the positioning of deferred income taxes, the field may be either current (within current assets) or non-
	/// current (below total current assets). Typically a company will have two deferred income taxes fields.
	/// </summary>
	public class NonCurrentDeferredTaxesAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredTaxesAssetsBalanceSheet class
		/// </summary>
		public NonCurrentDeferredTaxesAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredTaxesAssetsBalanceSheet class
		/// </summary>
		public NonCurrentDeferredTaxesAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The estimated future tax obligations, which usually arise when different accounting methods are used for financial statements and
	/// tax statement It is also an add-back to the cash flow statement. Deferred income taxes include accumulated tax deferrals due to
	/// accelerated depreciation and investment credit.
	/// </summary>
	public class NonCurrentDeferredTaxesLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredTaxesLiabilitiesBalanceSheet class
		/// </summary>
		public NonCurrentDeferredTaxesLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredTaxesLiabilitiesBalanceSheet class
		/// </summary>
		public NonCurrentDeferredTaxesLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This asset represents equity securities categorized neither as held-to-maturity nor trading.
	/// </summary>
	public class EquityInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EquityInvestmentsBalanceSheet class
		/// </summary>
		public EquityInvestmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EquityInvestmentsBalanceSheet class
		/// </summary>
		public EquityInvestmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This liability refers to the amount shown on the books that a bank with insufficient reserves borrows, at the federal funds rate, from
	/// another bank to meet its reserve requirements; and the amount of securities that an institution sells and agrees to repurchase at a
	/// specified date for a specified price, net of any reductions or offsets.
	/// </summary>
	public class FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet class
		/// </summary>
		public FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet class
		/// </summary>
		public FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This asset refers to very-short-term loans of funds to other banks and securities dealers.
	/// </summary>
	public class FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet class
		/// </summary>
		public FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet class
		/// </summary>
		public FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This asset refers to the fair value of investments in debt securities that are deemed to be available for sale that are allocated to the
	/// segregated group of participating or dividend-paying policies and contracts identified as the closed block. Change in fair value of
	/// such securities is a component of change in other comprehensive income in the period, which is reflected in the closed block
	/// disclosure.
	/// </summary>
	public class FixedMaturitiesAvailableForSaleBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FixedMaturitiesAvailableForSaleBalanceSheet class
		/// </summary>
		public FixedMaturitiesAvailableForSaleBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FixedMaturitiesAvailableForSaleBalanceSheet class
		/// </summary>
		public FixedMaturitiesAvailableForSaleBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This asset represents the total of all debt securities grouped by maturity dates, at fair value, which are categorized as held-to-
	/// maturity.
	/// </summary>
	public class FixedMaturitiesHeldToMaturityBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FixedMaturitiesHeldToMaturityBalanceSheet class
		/// </summary>
		public FixedMaturitiesHeldToMaturityBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FixedMaturitiesHeldToMaturityBalanceSheet class
		/// </summary>
		public FixedMaturitiesHeldToMaturityBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This asset refers the total of all debt securities grouped by maturity dates, at fair value, which are categorized as trading.
	/// </summary>
	public class FixedMaturitiesTradingBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FixedMaturitiesTradingBalanceSheet class
		/// </summary>
		public FixedMaturitiesTradingBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FixedMaturitiesTradingBalanceSheet class
		/// </summary>
		public FixedMaturitiesTradingBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This asset refers to types of investments that may be contained within the fixed maturity category which securities are having a
	/// stated final repayment date. Examples of items within this category may include bonds, including convertibles and bonds with
	/// warrants, and redeemable preferred stocks.
	/// </summary>
	public class FixedMaturityInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FixedMaturityInvestmentsBalanceSheet class
		/// </summary>
		public FixedMaturityInvestmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FixedMaturityInvestmentsBalanceSheet class
		/// </summary>
		public FixedMaturityInvestmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Accounting policy pertaining to an insurance entity's net liability for future benefits (for example, death, cash surrender value) to be
	/// paid to or on behalf of policyholders, describing the bases, methodologies and components of the reserve, and assumptions
	/// regarding estimates of expected investment yields, mortality, morbidity, terminations and expenses.
	/// </summary>
	public class FuturePolicyBenefitsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FuturePolicyBenefitsBalanceSheet class
		/// </summary>
		public FuturePolicyBenefitsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FuturePolicyBenefitsBalanceSheet class
		/// </summary>
		public FuturePolicyBenefitsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// In a limited partnership or master limited partnership form of business, this represents the balance of capital held by the general
	/// partners.
	/// </summary>
	public class GeneralPartnershipCapitalBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GeneralPartnershipCapitalBalanceSheet class
		/// </summary>
		public GeneralPartnershipCapitalBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GeneralPartnershipCapitalBalanceSheet class
		/// </summary>
		public GeneralPartnershipCapitalBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The excess of the cost of an acquired company over the sum of the fair market value of its identifiable individual assets less the
	/// liabilities.
	/// </summary>
	public class GoodwillBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GoodwillBalanceSheet class
		/// </summary>
		public GoodwillBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GoodwillBalanceSheet class
		/// </summary>
		public GoodwillBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Rights or economic benefits, such as patents and goodwill, that is not physical in nature. They are those that are neither physical
	/// nor financial in nature, nevertheless, have value to the company. Intangibles are listed net of accumulated amortization.
	/// </summary>
	public class GoodwillAndOtherIntangibleAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GoodwillAndOtherIntangibleAssetsBalanceSheet class
		/// </summary>
		public GoodwillAndOtherIntangibleAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GoodwillAndOtherIntangibleAssetsBalanceSheet class
		/// </summary>
		public GoodwillAndOtherIntangibleAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents the sum of all loans (commercial, consumer, mortgage, etc.) as well as leases before any provisions for loan losses or
	/// unearned discounts.
	/// </summary>
	public class GrossLoanBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GrossLoanBalanceSheet class
		/// </summary>
		public GrossLoanBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GrossLoanBalanceSheet class
		/// </summary>
		public GrossLoanBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Carrying amount at the balance sheet date for long-lived physical assets used in the normal conduct of business and not intended
	/// for resale. This can include land, physical structures, machinery, vehicles, furniture, computer equipment, construction in progress,
	/// and similar items. Amount does not include depreciation.
	/// </summary>
	public class GrossPPEBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GrossPPEBalanceSheet class
		/// </summary>
		public GrossPPEBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GrossPPEBalanceSheet class
		/// </summary>
		public GrossPPEBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Debt securities that a firm has the ability and intent to hold until maturity.
	/// </summary>
	public class HeldToMaturitySecuritiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the HeldToMaturitySecuritiesBalanceSheet class
		/// </summary>
		public HeldToMaturitySecuritiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the HeldToMaturitySecuritiesBalanceSheet class
		/// </summary>
		public HeldToMaturitySecuritiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A current liability account which reflects the amount of income taxes currently due to the federal, state, and local governments.
	/// </summary>
	public class IncomeTaxPayableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the IncomeTaxPayableBalanceSheet class
		/// </summary>
		public IncomeTaxPayableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the IncomeTaxPayableBalanceSheet class
		/// </summary>
		public IncomeTaxPayableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate of all domestic and foreign deposits in the bank that earns interests.
	/// </summary>
	public class InterestBearingDepositsLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestBearingDepositsLiabilitiesBalanceSheet class
		/// </summary>
		public InterestBearingDepositsLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestBearingDepositsLiabilitiesBalanceSheet class
		/// </summary>
		public InterestBearingDepositsLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Sum of the carrying values as of the balance sheet date of interest payable on all forms of debt, including trade payable that has
	/// been incurred.
	/// </summary>
	public class InterestPayableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestPayableBalanceSheet class
		/// </summary>
		public InterestPayableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestPayableBalanceSheet class
		/// </summary>
		public InterestPayableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Deposit of money with a financial institution, in consideration of which the financial institution pays or credits interest, or amounts in the nature
	/// of interest.
	/// </summary>
	public class InterestBearingDepositsAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InterestBearingDepositsAssetsBalanceSheet class
		/// </summary>
		public InterestBearingDepositsAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InterestBearingDepositsAssetsBalanceSheet class
		/// </summary>
		public InterestBearingDepositsAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A company's merchandise, raw materials, and finished and unfinished products which have not yet been sold.
	/// </summary>
	public class InventoryBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InventoryBalanceSheet class
		/// </summary>
		public InventoryBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InventoryBalanceSheet class
		/// </summary>
		public InventoryBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All investments in affiliates, real estate, securities, etc. Non-current investment, not including marketable securities.
	/// </summary>
	public class InvestmentsAndAdvancesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InvestmentsAndAdvancesBalanceSheet class
		/// </summary>
		public InvestmentsAndAdvancesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InvestmentsAndAdvancesBalanceSheet class
		/// </summary>
		public InvestmentsAndAdvancesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// In a limited partnership or master limited partnership form of business, this represents the balance of capital held by the limited
	/// partners.
	/// </summary>
	public class LimitedPartnershipCapitalBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LimitedPartnershipCapitalBalanceSheet class
		/// </summary>
		public LimitedPartnershipCapitalBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LimitedPartnershipCapitalBalanceSheet class
		/// </summary>
		public LimitedPartnershipCapitalBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Sum of the carrying values as of the balance sheet date of all long-term debt, which is debt initially having maturities due after one
	/// year or beyond the operating cycle, if longer, but excluding the portions thereof scheduled to be repaid within one year or the
	/// normal operating cycle, if longer. Long-term debt includes notes payable, bonds payable, mortgage loans, convertible debt,
	/// subordinated debt and other types of long term debt.
	/// </summary>
	public class LongTermDebtBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LongTermDebtBalanceSheet class
		/// </summary>
		public LongTermDebtBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LongTermDebtBalanceSheet class
		/// </summary>
		public LongTermDebtBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// All borrowings lasting over one year including long-term debt and long-term portion of capital lease obligations.
	/// </summary>
	public class LongTermDebtAndCapitalLeaseObligationBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LongTermDebtAndCapitalLeaseObligationBalanceSheet class
		/// </summary>
		public LongTermDebtAndCapitalLeaseObligationBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LongTermDebtAndCapitalLeaseObligationBalanceSheet class
		/// </summary>
		public LongTermDebtAndCapitalLeaseObligationBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Often referred to simply as "investments". Long-term investments are to be held for many years and are not intended to be
	/// disposed in the near future. This group usually consists of four types of investments.
	/// </summary>
	public class LongTermInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LongTermInvestmentsBalanceSheet class
		/// </summary>
		public LongTermInvestmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LongTermInvestmentsBalanceSheet class
		/// </summary>
		public LongTermInvestmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents the total liability for long-term leases lasting over one year. Amount equal to the present value (the principal) at the
	/// beginning of the lease term less lease payments during the lease term.
	/// </summary>
	public class LongTermCapitalLeaseObligationBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LongTermCapitalLeaseObligationBalanceSheet class
		/// </summary>
		public LongTermCapitalLeaseObligationBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LongTermCapitalLeaseObligationBalanceSheet class
		/// </summary>
		public LongTermCapitalLeaseObligationBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Carrying amount of the equity interests owned by non-controlling shareholders, partners, or other equity holders in one or more of
	/// the entities included in the reporting entity's consolidated financial statements.
	/// </summary>
	public class MinorityInterestBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MinorityInterestBalanceSheet class
		/// </summary>
		public MinorityInterestBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MinorityInterestBalanceSheet class
		/// </summary>
		public MinorityInterestBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Short-term (typical maturity is less than one year), highly liquid government or corporate debt instrument such as bankers'
	/// acceptance, promissory notes, and treasury bills.
	/// </summary>
	public class MoneyMarketInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MoneyMarketInvestmentsBalanceSheet class
		/// </summary>
		public MoneyMarketInvestmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MoneyMarketInvestmentsBalanceSheet class
		/// </summary>
		public MoneyMarketInvestmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represents the value of all loans after deduction of the appropriate allowances for loan and lease losses.
	/// </summary>
	public class NetLoanBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetLoanBalanceSheet class
		/// </summary>
		public NetLoanBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetLoanBalanceSheet class
		/// </summary>
		public NetLoanBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Tangible assets that are held by an entity for use in the production or supply of goods and services, for rental to others, or for
	/// administrative purposes and that are expected to provide economic benefit for more than one year; net of accumulated
	/// depreciation.
	/// </summary>
	public class NetPPEBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetPPEBalanceSheet class
		/// </summary>
		public NetPPEBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetPPEBalanceSheet class
		/// </summary>
		public NetPPEBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of all domestic and foreign deposits in the banks that do not draw interest.
	/// </summary>
	public class NonInterestBearingDepositsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonInterestBearingDepositsBalanceSheet class
		/// </summary>
		public NonInterestBearingDepositsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonInterestBearingDepositsBalanceSheet class
		/// </summary>
		public NonInterestBearingDepositsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Written promises to pay a stated sum at one or more specified dates in the future, within the accounting period.
	/// </summary>
	public class CurrentNotesPayableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentNotesPayableBalanceSheet class
		/// </summary>
		public CurrentNotesPayableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentNotesPayableBalanceSheet class
		/// </summary>
		public CurrentNotesPayableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
	/// at a future date(s) within one year of the balance sheet date or the normal operating cycle, whichever is longer. Such amount may
	/// include accrued interest receivable in accordance with the terms of the note. The note also may contain provisions including a
	/// discount or premium, payable on demand, secured, or unsecured, interest bearing or non-interest bearing, among a myriad of other
	/// features and characteristics.
	/// </summary>
	public class NotesReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NotesReceivableBalanceSheet class
		/// </summary>
		public NotesReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NotesReceivableBalanceSheet class
		/// </summary>
		public NotesReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
	/// at a future date(s) , excluding the portion that is expected to be received within one year of the balance sheet date or the normal
	/// operating cycle, whichever is longer.
	/// </summary>
	public class NonCurrentNoteReceivablesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentNoteReceivablesBalanceSheet class
		/// </summary>
		public NonCurrentNoteReceivablesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentNoteReceivablesBalanceSheet class
		/// </summary>
		public NonCurrentNoteReceivablesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other current liabilities = Total current liabilities - Payables and accrued Expenses - Current debt and capital lease obligaton -
	/// provisions, current - deferred liabilities, current
	/// </summary>
	public class OtherCurrentLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherCurrentLiabilitiesBalanceSheet class
		/// </summary>
		public OtherCurrentLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherCurrentLiabilitiesBalanceSheet class
		/// </summary>
		public OtherCurrentLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Sum of the carrying amounts of all intangible assets, excluding goodwill.
	/// </summary>
	public class OtherIntangibleAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherIntangibleAssetsBalanceSheet class
		/// </summary>
		public OtherIntangibleAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherIntangibleAssetsBalanceSheet class
		/// </summary>
		public OtherIntangibleAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of short term investments, which will be expired within one year that are not specifically classified as
	/// Available-for-Sale, Held-to-Maturity,  nor Trading investments.
	/// </summary>
	public class OtherShortTermInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherShortTermInvestmentsBalanceSheet class
		/// </summary>
		public OtherShortTermInvestmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherShortTermInvestmentsBalanceSheet class
		/// </summary>
		public OtherShortTermInvestmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The sum of all payables owed and expected to be paid within one year or one operating cycle, including accounts payables, taxes
	/// payable, dividends payable and all other current payables.
	/// </summary>
	public class PayablesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PayablesBalanceSheet class
		/// </summary>
		public PayablesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PayablesBalanceSheet class
		/// </summary>
		public PayablesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This balance sheet account includes all current payables and accrued expenses.
	/// </summary>
	public class PayablesAndAccruedExpensesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PayablesAndAccruedExpensesBalanceSheet class
		/// </summary>
		public PayablesAndAccruedExpensesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PayablesAndAccruedExpensesBalanceSheet class
		/// </summary>
		public PayablesAndAccruedExpensesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Accounting policy pertaining to an insurance entity's net liability for future benefits (for example, death, cash surrender value) to be
	/// paid to or on behalf of policyholders, describing the bases, methodologies and components of the reserve, and assumptions
	/// regarding estimates of expected investment yields, mortality, morbidity, terminations and expenses.
	/// </summary>
	public class PolicyReservesBenefitsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyReservesBenefitsBalanceSheet class
		/// </summary>
		public PolicyReservesBenefitsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyReservesBenefitsBalanceSheet class
		/// </summary>
		public PolicyReservesBenefitsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The total liability as of the balance sheet date of amounts due to policy holders, excluding future policy benefits and claims,
	/// including unpaid policy dividends, retrospective refunds, and undistributed earnings on participating business.
	/// </summary>
	public class PolicyholderFundsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyholderFundsBalanceSheet class
		/// </summary>
		public PolicyholderFundsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyholderFundsBalanceSheet class
		/// </summary>
		public PolicyholderFundsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Preferred securities that that firm treats as a liability. It includes convertible preferred stock or redeemable preferred stock.
	/// </summary>
	public class PreferredSecuritiesOutsideStockEquityBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PreferredSecuritiesOutsideStockEquityBalanceSheet class
		/// </summary>
		public PreferredSecuritiesOutsideStockEquityBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PreferredSecuritiesOutsideStockEquityBalanceSheet class
		/// </summary>
		public PreferredSecuritiesOutsideStockEquityBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Preferred stock (all issues) at par value, as reported within the Stockholder's Equity section of the balance sheet.
	/// </summary>
	public class PreferredStockBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PreferredStockBalanceSheet class
		/// </summary>
		public PreferredStockBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PreferredStockBalanceSheet class
		/// </summary>
		public PreferredStockBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying amount as of the balance sheet date due the entity from agents insures, uncollected premiums and others.
	/// </summary>
	public class PremiumsReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PremiumsReceivableBalanceSheet class
		/// </summary>
		public PremiumsReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PremiumsReceivableBalanceSheet class
		/// </summary>
		public PremiumsReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Sum of the carrying amounts that are paid in advance for expenses, which will be charged against earnings in subsequent periods.
	/// </summary>
	public class PrepaidAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PrepaidAssetsBalanceSheet class
		/// </summary>
		public PrepaidAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PrepaidAssetsBalanceSheet class
		/// </summary>
		public PrepaidAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Sum of the carrying amounts that are paid in advance for expenses, which will be charged against earnings in periods after one
	/// year or beyond the operating cycle, if longer.
	/// </summary>
	public class NonCurrentPrepaidAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentPrepaidAssetsBalanceSheet class
		/// </summary>
		public NonCurrentPrepaidAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentPrepaidAssetsBalanceSheet class
		/// </summary>
		public NonCurrentPrepaidAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The sum of all receivables owed by customers and affiliates within one year, including accounts receivable, notes receivable,
	/// premiums receivable, and other current receivables.
	/// </summary>
	public class ReceivablesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReceivablesBalanceSheet class
		/// </summary>
		public ReceivablesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReceivablesBalanceSheet class
		/// </summary>
		public ReceivablesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Type of preferred stock which may be bought back by the issuing company on a specified date or after a specified period of notice.
	/// </summary>
	public class RedeemablePreferredStockBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RedeemablePreferredStockBalanceSheet class
		/// </summary>
		public RedeemablePreferredStockBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RedeemablePreferredStockBalanceSheet class
		/// </summary>
		public RedeemablePreferredStockBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of benefits the ceding insurer expects to recover on insurance policies ceded to other insurance entities as of the
	/// balance sheet date for all guaranteed benefit types. It includes estimated amounts for claims incurred but not reported, and policy
	/// benefits, net of any related valuation allowance.
	/// </summary>
	public class ReinsuranceRecoverableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoverableBalanceSheet class
		/// </summary>
		public ReinsuranceRecoverableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoverableBalanceSheet class
		/// </summary>
		public ReinsuranceRecoverableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The cumulative net income of the company from the date of its inception (or reorganization) to the date of the financial statement
	/// less the cumulative distributions to shareholders either directly (dividends) or indirectly (treasury stock).
	/// </summary>
	public class RetainedEarningsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RetainedEarningsBalanceSheet class
		/// </summary>
		public RetainedEarningsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RetainedEarningsBalanceSheet class
		/// </summary>
		public RetainedEarningsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying value as of the balance sheet date of the liabilities collateral securities loaned to other broker-dealers. Borrowers of
	/// securities generally are required to provide collateral to the lenders of securities, commonly cash but sometimes other securities or
	/// standby letters of credit, with a value slightly higher than that of the securities borrowed.
	/// </summary>
	public class SecuritiesLendingCollateralBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SecuritiesLendingCollateralBalanceSheet class
		/// </summary>
		public SecuritiesLendingCollateralBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SecuritiesLendingCollateralBalanceSheet class
		/// </summary>
		public SecuritiesLendingCollateralBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
	/// resell the identical security purchased or a security that meets the definition of "substantially the same" in the case of a dollar roll.
	/// Also includes purchases of participations in pools of securities that are subject to a resale agreement.
	/// </summary>
	public class SecurityAgreeToBeResellBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SecurityAgreeToBeResellBalanceSheet class
		/// </summary>
		public SecurityAgreeToBeResellBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SecurityAgreeToBeResellBalanceSheet class
		/// </summary>
		public SecurityAgreeToBeResellBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Represent obligations of the company to deliver the specified security at the contracted price and, thereby, create a liability to
	/// purchase the security in the market at prevailing prices.
	/// </summary>
	public class SecuritySoldNotYetRepurchasedBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SecuritySoldNotYetRepurchasedBalanceSheet class
		/// </summary>
		public SecuritySoldNotYetRepurchasedBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SecuritySoldNotYetRepurchasedBalanceSheet class
		/// </summary>
		public SecuritySoldNotYetRepurchasedBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The fair value of the assets held by the company for the benefit of separate account policyholders.
	/// </summary>
	public class SeparateAccountAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SeparateAccountAssetsBalanceSheet class
		/// </summary>
		public SeparateAccountAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SeparateAccountAssetsBalanceSheet class
		/// </summary>
		public SeparateAccountAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Refers to revenue that is generated that is not part of typical operations.
	/// </summary>
	public class SeparateAccountBusinessBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SeparateAccountBusinessBalanceSheet class
		/// </summary>
		public SeparateAccountBusinessBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SeparateAccountBusinessBalanceSheet class
		/// </summary>
		public SeparateAccountBusinessBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The current assets section of a company's balance sheet that contains the investments that a company holds with the purpose for
	/// trading.
	/// </summary>
	public class ShortTermInvestmentsAvailableForSaleBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ShortTermInvestmentsAvailableForSaleBalanceSheet class
		/// </summary>
		public ShortTermInvestmentsAvailableForSaleBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ShortTermInvestmentsAvailableForSaleBalanceSheet class
		/// </summary>
		public ShortTermInvestmentsAvailableForSaleBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The current assets section of a company's balance sheet that contains the investments that a company has made that will expire
	/// at a fixed date within one year.
	/// </summary>
	public class ShortTermInvestmentsHeldToMaturityBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ShortTermInvestmentsHeldToMaturityBalanceSheet class
		/// </summary>
		public ShortTermInvestmentsHeldToMaturityBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ShortTermInvestmentsHeldToMaturityBalanceSheet class
		/// </summary>
		public ShortTermInvestmentsHeldToMaturityBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The current assets section of a company's balance sheet that contains the investments that a company can trade at any moment.
	/// </summary>
	public class ShortTermInvestmentsTradingBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ShortTermInvestmentsTradingBalanceSheet class
		/// </summary>
		public ShortTermInvestmentsTradingBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ShortTermInvestmentsTradingBalanceSheet class
		/// </summary>
		public ShortTermInvestmentsTradingBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The residual interest in the assets of the enterprise that remains after deducting its liabilities. Equity is increased by owners'
	/// investments and by comprehensive income, and it is reduced by distributions to the owners.
	/// </summary>
	public class StockholdersEquityBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the StockholdersEquityBalanceSheet class
		/// </summary>
		public StockholdersEquityBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the StockholdersEquityBalanceSheet class
		/// </summary>
		public StockholdersEquityBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A liability that reflects the taxes owed to federal, state, and local tax authorities. It is the carrying value as of the balance sheet
	/// date of obligations incurred and payable for statutory income, sales, use, payroll, excise, real, property and other taxes.
	/// </summary>
	public class TotalTaxPayableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalTaxPayableBalanceSheet class
		/// </summary>
		public TotalTaxPayableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalTaxPayableBalanceSheet class
		/// </summary>
		public TotalTaxPayableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of probable future economic benefits obtained or controlled by a particular enterprise as a result of past
	/// transactions or events.
	/// </summary>
	public class TotalAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalAssetsBalanceSheet class
		/// </summary>
		public TotalAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalAssetsBalanceSheet class
		/// </summary>
		public TotalAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A liability account which represents the total amount of funds deposited.
	/// </summary>
	public class TotalDepositsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalDepositsBalanceSheet class
		/// </summary>
		public TotalDepositsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalDepositsBalanceSheet class
		/// </summary>
		public TotalDepositsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Asset that refers to the sum of all available for sale securities and other investments often reported on the balance sheet of
	/// insurance firms.
	/// </summary>
	public class TotalInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalInvestmentsBalanceSheet class
		/// </summary>
		public TotalInvestmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalInvestmentsBalanceSheet class
		/// </summary>
		public TotalInvestmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Probable future sacrifices of economic benefits arising from present obligations of an enterprise to transfer assets or provide
	/// services to others in the future as a result of past transactions or events.
	/// </summary>
	public class TotalLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalLiabilitiesBalanceSheet class
		/// </summary>
		public TotalLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalLiabilitiesBalanceSheet class
		/// </summary>
		public TotalLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Sum of the carrying amounts as of the balance sheet date of all assets that are expected to be realized in cash, sold or consumed
	/// after one year or beyond the normal operating cycle, if longer.
	/// </summary>
	public class TotalNonCurrentAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalNonCurrentAssetsBalanceSheet class
		/// </summary>
		public TotalNonCurrentAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalNonCurrentAssetsBalanceSheet class
		/// </summary>
		public TotalNonCurrentAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total obligations incurred as part of normal operations that is expected to be repaid beyond the following twelve months or one
	/// business cycle.
	/// </summary>
	public class TotalNonCurrentLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalNonCurrentLiabilitiesBalanceSheet class
		/// </summary>
		public TotalNonCurrentLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalNonCurrentLiabilitiesBalanceSheet class
		/// </summary>
		public TotalNonCurrentLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Ownership interest of different classes of partners in the publicly listed limited partnership or master limited partnership. Partners
	/// include general, limited and preferred partners.
	/// </summary>
	public class TotalPartnershipCapitalBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalPartnershipCapitalBalanceSheet class
		/// </summary>
		public TotalPartnershipCapitalBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalPartnershipCapitalBalanceSheet class
		/// </summary>
		public TotalPartnershipCapitalBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Trading account assets are bought and held principally for the purpose of selling them in the near term (thus held for only a short
	/// period of time). Unrealized holding gains and losses for trading securities are included in earnings.
	/// </summary>
	public class TradingAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TradingAssetsBalanceSheet class
		/// </summary>
		public TradingAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TradingAssetsBalanceSheet class
		/// </summary>
		public TradingAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying amount of liabilities as of the balance sheet date that pertain to principal and customer trading transactions, or which
	/// may be incurred with the objective of generating a profit from short-term fluctuations in price as part of an entity's market-making,
	/// hedging and proprietary trading. Examples include short positions in securities, derivatives and commodities, obligations under
	/// repurchase agreements, and securities borrowed arrangements.
	/// </summary>
	public class TradingLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TradingLiabilitiesBalanceSheet class
		/// </summary>
		public TradingLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TradingLiabilitiesBalanceSheet class
		/// </summary>
		public TradingLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The total of financial instruments that are bought and held principally for the purpose of selling them in the near term (thus held for
	/// only a short period of time) or for debt and equity securities formerly categorized as available-for-sale or held-to-maturity which the
	/// company held as of the date it opted to account for such securities at fair value.
	/// </summary>
	public class TradingSecuritiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TradingSecuritiesBalanceSheet class
		/// </summary>
		public TradingSecuritiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TradingSecuritiesBalanceSheet class
		/// </summary>
		public TradingSecuritiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The portion of shares that a company keeps in their own treasury. Treasury stock may have come from a repurchase or buyback
	/// from shareholders; or it may have never been issued to the public in the first place. These shares don't pay dividends, have no
	/// voting rights, and are not included in shares outstanding calculations.
	/// </summary>
	public class TreasuryStockBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TreasuryStockBalanceSheet class
		/// </summary>
		public TreasuryStockBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TreasuryStockBalanceSheet class
		/// </summary>
		public TreasuryStockBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Income received but not yet earned, it represents the unearned amount that is netted against the total loan.
	/// </summary>
	public class UnearnedIncomeBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the UnearnedIncomeBalanceSheet class
		/// </summary>
		public UnearnedIncomeBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the UnearnedIncomeBalanceSheet class
		/// </summary>
		public UnearnedIncomeBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Carrying amount of premiums written on insurance contracts that have not been earned as of the balance sheet date.
	/// </summary>
	public class UnearnedPremiumsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the UnearnedPremiumsBalanceSheet class
		/// </summary>
		public UnearnedPremiumsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the UnearnedPremiumsBalanceSheet class
		/// </summary>
		public UnearnedPremiumsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Liability amount that reflects claims that are expected based upon statistical projections, but which have not been reported to the
	/// insurer.
	/// </summary>
	public class UnpaidLossAndLossReserveBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the UnpaidLossAndLossReserveBalanceSheet class
		/// </summary>
		public UnpaidLossAndLossReserveBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the UnpaidLossAndLossReserveBalanceSheet class
		/// </summary>
		public UnpaidLossAndLossReserveBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Invested capital = common shareholders' equity + long term debt + current debt
	/// </summary>
	public class InvestedCapitalBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InvestedCapitalBalanceSheet class
		/// </summary>
		public InvestedCapitalBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InvestedCapitalBalanceSheet class
		/// </summary>
		public InvestedCapitalBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Payments that will be assigned as expenses with one accounting period, but that are paid in advance and temporarily set up as
	/// current assets on the balance sheet.
	/// </summary>
	public class CurrentDeferredAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentDeferredAssetsBalanceSheet class
		/// </summary>
		public CurrentDeferredAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentDeferredAssetsBalanceSheet class
		/// </summary>
		public CurrentDeferredAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Payments that will be assigned as expenses longer than one accounting period, but that are paid in advance and temporarily set up
	/// as non-current assets on the balance sheet.
	/// </summary>
	public class NonCurrentDeferredAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredAssetsBalanceSheet class
		/// </summary>
		public NonCurrentDeferredAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentDeferredAssetsBalanceSheet class
		/// </summary>
		public NonCurrentDeferredAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Asset, often applicable to Banks, which refers to the aggregate amount of all securities and investments.
	/// </summary>
	public class SecuritiesAndInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SecuritiesAndInvestmentsBalanceSheet class
		/// </summary>
		public SecuritiesAndInvestmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SecuritiesAndInvestmentsBalanceSheet class
		/// </summary>
		public SecuritiesAndInvestmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Probable future sacrifices of economic benefits arising from present obligations of an enterprise to transfer assets or provide
	/// services to others in the future as a result of past transactions or events, excluding minority interest.
	/// </summary>
	public class TotalLiabilitiesNetMinorityInterestBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalLiabilitiesNetMinorityInterestBalanceSheet class
		/// </summary>
		public TotalLiabilitiesNetMinorityInterestBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalLiabilitiesNetMinorityInterestBalanceSheet class
		/// </summary>
		public TotalLiabilitiesNetMinorityInterestBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Total obligations, net minority interest, incurred as part of normal operations that is expected to be repaid beyond the following
	/// twelve months or one business cycle.
	/// </summary>
	public class TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet class
		/// </summary>
		public TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet class
		/// </summary>
		public TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Residual interest, gross of minority interest, that remains in the assets of the enterprise after deducting its liabilities. Equity is
	/// increased by owners' investments and by comprehensive income, and it is reduced by distributions to the owners.
	/// </summary>
	public class TotalEquityGrossMinorityInterestBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the TotalEquityGrossMinorityInterestBalanceSheet class
		/// </summary>
		public TotalEquityGrossMinorityInterestBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the TotalEquityGrossMinorityInterestBalanceSheet class
		/// </summary>
		public TotalEquityGrossMinorityInterestBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Accounts owed to a company by customers within a year as a result of exchanging goods or services on credit.
	/// </summary>
	public class GrossAccountsReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GrossAccountsReceivableBalanceSheet class
		/// </summary>
		public GrossAccountsReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GrossAccountsReceivableBalanceSheet class
		/// </summary>
		public GrossAccountsReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Accounts receivable represents sums owed to the business that the business records as revenue. Gross accounts receivable is
	/// accounts receivable before the business deducts uncollectable accounts to calculate the true value of accounts receivable.
	/// </summary>
	public class NonCurrentAccountsReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentAccountsReceivableBalanceSheet class
		/// </summary>
		public NonCurrentAccountsReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentAccountsReceivableBalanceSheet class
		/// </summary>
		public NonCurrentAccountsReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This account shows the amount of unpaid interest accrued to the date of purchase and included in the purchase price of securities
	/// purchased between interest dates.
	/// </summary>
	public class AccruedInterestReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AccruedInterestReceivableBalanceSheet class
		/// </summary>
		public AccruedInterestReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AccruedInterestReceivableBalanceSheet class
		/// </summary>
		public AccruedInterestReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item is typically available for bank industry. It's the amount of borrowings as of the balance sheet date from the Federal Home
	/// Loan Bank, which are primarily used to cover shortages in the required reserve balance and liquidity shortages.
	/// </summary>
	public class AdvanceFromFederalHomeLoanBanksBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AdvanceFromFederalHomeLoanBanksBalanceSheet class
		/// </summary>
		public AdvanceFromFederalHomeLoanBanksBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AdvanceFromFederalHomeLoanBanksBalanceSheet class
		/// </summary>
		public AdvanceFromFederalHomeLoanBanksBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An Allowance for Doubtful Accounts measures receivables recorded but not expected to be collected.
	/// </summary>
	public class AllowanceForDoubtfulAccountsReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AllowanceForDoubtfulAccountsReceivableBalanceSheet class
		/// </summary>
		public AllowanceForDoubtfulAccountsReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AllowanceForDoubtfulAccountsReceivableBalanceSheet class
		/// </summary>
		public AllowanceForDoubtfulAccountsReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item is typically available for bank industry. It represents a provision relating to a written agreement to receive money  with the
	/// terms of the note (at a specified future date(s) within one year from the reporting date (or the normal operating cycle, whichever is
	/// longer), consisting of principal as well as any accrued interest) for the portion that is expected to be uncollectible.
	/// </summary>
	public class AllowanceForNotesReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AllowanceForNotesReceivableBalanceSheet class
		/// </summary>
		public AllowanceForNotesReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AllowanceForNotesReceivableBalanceSheet class
		/// </summary>
		public AllowanceForNotesReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item is typically available for bank industry. It's a part of long-lived assets, which has been decided for sale in the future.
	/// </summary>
	public class AssetsHeldForSaleBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AssetsHeldForSaleBalanceSheet class
		/// </summary>
		public AssetsHeldForSaleBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AssetsHeldForSaleBalanceSheet class
		/// </summary>
		public AssetsHeldForSaleBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A portion of a company's business that has been disposed of or sold.
	/// </summary>
	public class AssetsOfDiscontinuedOperationsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the AssetsOfDiscontinuedOperationsBalanceSheet class
		/// </summary>
		public AssetsOfDiscontinuedOperationsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the AssetsOfDiscontinuedOperationsBalanceSheet class
		/// </summary>
		public AssetsOfDiscontinuedOperationsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item is typically available for bank industry.  It is the carrying amount as of the balance sheet date of drafts and bills of
	/// exchange that have been accepted by the reporting bank or by others for its own account, as its liability to holders of the drafts.
	/// </summary>
	public class BankAcceptanceExecutedAndOutstandingBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the BankAcceptanceExecutedAndOutstandingBalanceSheet class
		/// </summary>
		public BankAcceptanceExecutedAndOutstandingBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the BankAcceptanceExecutedAndOutstandingBalanceSheet class
		/// </summary>
		public BankAcceptanceExecutedAndOutstandingBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It means all indebtedness for borrowed money or the deferred purchase price of property or services, including without limitation
	/// reimbursement and other obligations with respect to surety bonds and letters of credit, all obligations evidenced by notes, bonds
	/// debentures or similar instruments, all capital lease obligations and all contingent obligations. 
	/// </summary>
	public class BankIndebtednessBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the BankIndebtednessBalanceSheet class
		/// </summary>
		public BankIndebtednessBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the BankIndebtednessBalanceSheet class
		/// </summary>
		public BankIndebtednessBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It means an amount of money lent at interest by a bank to a borrower, usually on collateral security, for a certain period of time.
	/// </summary>
	public class BankLoanBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the BankLoanBalanceSheet class
		/// </summary>
		public BankLoanBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the BankLoanBalanceSheet class
		/// </summary>
		public BankLoanBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It means the carrying amount of a life insurance policy on an officer, executive or employee for which the reporting entity (a bank) is
	/// entitled to proceeds from the policy upon death of the insured or surrender of the insurance policy.
	/// </summary>
	public class BankOwnedLifeInsuranceBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the BankOwnedLifeInsuranceBalanceSheet class
		/// </summary>
		public BankOwnedLifeInsuranceBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the BankOwnedLifeInsuranceBalanceSheet class
		/// </summary>
		public BankOwnedLifeInsuranceBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The securities borrowed or on loan, which is the temporary loan of securities by a lender to a borrower in exchange for cash.  This
	/// item is usually only available for bank industry.
	/// </summary>
	public class SecurityBorrowedBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the SecurityBorrowedBalanceSheet class
		/// </summary>
		public SecurityBorrowedBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the SecurityBorrowedBalanceSheet class
		/// </summary>
		public SecurityBorrowedBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fixed assets that specifically deal with the facilities a company owns. Include the improvements associated with buildings.
	/// </summary>
	public class BuildingsAndImprovementsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the BuildingsAndImprovementsBalanceSheet class
		/// </summary>
		public BuildingsAndImprovementsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the BuildingsAndImprovementsBalanceSheet class
		/// </summary>
		public BuildingsAndImprovementsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate amount of claims made by the company under its casualty insurance policy.
	/// </summary>
	public class CasualtyClaimsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CasualtyClaimsBalanceSheet class
		/// </summary>
		public CasualtyClaimsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CasualtyClaimsBalanceSheet class
		/// </summary>
		public CasualtyClaimsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of unearned premiums paid and payable to another insurer as a result of reinsurance arrangements in order to
	/// exchange for that company accepting all or part of insurance on a risk or exposure.
	/// </summary>
	public class CededUnearnedPremiumsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CededUnearnedPremiumsBalanceSheet class
		/// </summary>
		public CededUnearnedPremiumsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CededUnearnedPremiumsBalanceSheet class
		/// </summary>
		public CededUnearnedPremiumsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Short-term loan, typically 90 days, used by a company to finance seasonal working capital needs.
	/// </summary>
	public class CommercialLoanBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CommercialLoanBalanceSheet class
		/// </summary>
		public CommercialLoanBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CommercialLoanBalanceSheet class
		/// </summary>
		public CommercialLoanBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Commercial paper is a money-market security issued by large banks and corporations. It represents the current obligation for the
	/// company. There are four basic kinds of commercial paper: promissory notes, drafts, checks, and certificates of deposit. The
	/// maturities of these money market securities generally do not exceed 270 days.
	/// </summary>
	public class CommercialPaperBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CommercialPaperBalanceSheet class
		/// </summary>
		public CommercialPaperBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CommercialPaperBalanceSheet class
		/// </summary>
		public CommercialPaperBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The portion of the Stockholders' Equity that reflects the amount of common stock, which are units of ownership.
	/// </summary>
	public class CommonStockEquityBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CommonStockEquityBalanceSheet class
		/// </summary>
		public CommonStockEquityBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CommonStockEquityBalanceSheet class
		/// </summary>
		public CommonStockEquityBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Stock, other than an entity's own stock, held and available for sale.  This item is usally available for the insurance industry.
	/// </summary>
	public class CommonStocksAvailableForSaleBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CommonStocksAvailableForSaleBalanceSheet class
		/// </summary>
		public CommonStocksAvailableForSaleBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CommonStocksAvailableForSaleBalanceSheet class
		/// </summary>
		public CommonStocksAvailableForSaleBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It represents carrying amount of long-lived asset under construction that includes construction costs to date on capital projects.
	/// Assets constructed, but not completed.
	/// </summary>
	public class ConstructionInProgressBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ConstructionInProgressBalanceSheet class
		/// </summary>
		public ConstructionInProgressBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ConstructionInProgressBalanceSheet class
		/// </summary>
		public ConstructionInProgressBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A loan that establishes consumer credit that is granted for personal use; usually unsecured and based on the borrower's integrity
	/// and ability to pay.
	/// </summary>
	public class ConsumerLoanBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ConsumerLoanBalanceSheet class
		/// </summary>
		public ConsumerLoanBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ConsumerLoanBalanceSheet class
		/// </summary>
		public ConsumerLoanBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The company's minimum pension obligations to its former employees, paid into a defined pension plan to satisfy all pension
	/// entitlements that have been earned by employees to date.
	/// </summary>
	public class MinimumPensionLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MinimumPensionLiabilitiesBalanceSheet class
		/// </summary>
		public MinimumPensionLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MinimumPensionLiabilitiesBalanceSheet class
		/// </summary>
		public MinimumPensionLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Amounts receivable from customers on short-term negotiable time drafts drawn on and accepted by the institution (also known as
	/// banker's acceptance transactions) that are outstanding on the reporting date.
	/// </summary>
	public class CustomerAcceptancesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CustomerAcceptancesBalanceSheet class
		/// </summary>
		public CustomerAcceptancesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CustomerAcceptancesBalanceSheet class
		/// </summary>
		public CustomerAcceptancesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// When a company defers the sales costs that are associated with acquiring a new customer over the term of the insurance
	/// contract.
	/// </summary>
	public class DeferredAcquisitionCostsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DeferredAcquisitionCostsBalanceSheet class
		/// </summary>
		public DeferredAcquisitionCostsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DeferredAcquisitionCostsBalanceSheet class
		/// </summary>
		public DeferredAcquisitionCostsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Deferred Finance is created where the purchaser agrees with the vendor to pay some of the purchase price at a future date, as
	/// opposed to paying the full purchase price in cash on day one.
	/// </summary>
	public class DeferredFinancingCostsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DeferredFinancingCostsBalanceSheet class
		/// </summary>
		public DeferredFinancingCostsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DeferredFinancingCostsBalanceSheet class
		/// </summary>
		public DeferredFinancingCostsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The recognition of an asset where pension fund assets exceed promised benefits.
	/// </summary>
	public class DefinedPensionBenefitBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DefinedPensionBenefitBalanceSheet class
		/// </summary>
		public DefinedPensionBenefitBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DefinedPensionBenefitBalanceSheet class
		/// </summary>
		public DefinedPensionBenefitBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fair values of all liabilities resulting from contracts that meet the criteria of being accounted for as derivative instruments; and
	/// which are expected to be extinguished or otherwise disposed of after one year or beyond the normal operating cycle.
	/// </summary>
	public class DerivativeProductLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DerivativeProductLiabilitiesBalanceSheet class
		/// </summary>
		public DerivativeProductLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DerivativeProductLiabilitiesBalanceSheet class
		/// </summary>
		public DerivativeProductLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fair values of assets resulting from contracts that meet the criteria of being accounted for as derivative instruments, net of the
	/// effects of master netting arrangements.
	/// </summary>
	public class DerivativeAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DerivativeAssetsBalanceSheet class
		/// </summary>
		public DerivativeAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DerivativeAssetsBalanceSheet class
		/// </summary>
		public DerivativeAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Sum of the carrying values of dividends declared but unpaid on equity securities issued and outstanding (also includes dividends
	/// collected on behalf of another owner of securities that are being held by entity) by the entity.
	/// </summary>
	public class DividendsPayableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the DividendsPayableBalanceSheet class
		/// </summary>
		public DividendsPayableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the DividendsPayableBalanceSheet class
		/// </summary>
		public DividendsPayableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// ESOP Debt Guarantee represents all transactions related to a company's Employee Stock Ownership Plan (ESOP), such as
	/// shares/debt/loans owned by ESOP.
	/// </summary>
	public class ESOPDebtGuaranteeBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ESOPDebtGuaranteeBalanceSheet class
		/// </summary>
		public ESOPDebtGuaranteeBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ESOPDebtGuaranteeBalanceSheet class
		/// </summary>
		public ESOPDebtGuaranteeBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Carrying amount as of the balance sheet date of the portion of the obligations recognized for the various benefits provided to former
	/// or inactive employees, their beneficiaries, and covered dependents after employment but before retirement.
	/// </summary>
	public class EmployeeBenefitsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the EmployeeBenefitsBalanceSheet class
		/// </summary>
		public EmployeeBenefitsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the EmployeeBenefitsBalanceSheet class
		/// </summary>
		public EmployeeBenefitsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An installation, contrivance, or other facilitates which service for transportation, such as Medical facility; Telecommunications
	/// facility; Post-production facility. This item is typically available for transportation industry.
	/// </summary>
	public class FacilitiesAndOtherBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FacilitiesAndOtherBalanceSheet class
		/// </summary>
		public FacilitiesAndOtherBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FacilitiesAndOtherBalanceSheet class
		/// </summary>
		public FacilitiesAndOtherBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount borrowed by a bank, at the federal funds rate, from another bank to meet its reserve requirements.  This item is
	/// typically available for the bank industry.
	/// </summary>
	public class FederalFundsPurchasedBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FederalFundsPurchasedBalanceSheet class
		/// </summary>
		public FederalFundsPurchasedBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FederalFundsPurchasedBalanceSheet class
		/// </summary>
		public FederalFundsPurchasedBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Federal funds transactions involve lending (federal funds sold) or borrowing (federal funds purchased) of immediately available
	/// reserve balances.  This item is typically available for the bank industry.
	/// </summary>
	public class FederalFundsSoldBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FederalFundsSoldBalanceSheet class
		/// </summary>
		public FederalFundsSoldBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FederalFundsSoldBalanceSheet class
		/// </summary>
		public FederalFundsSoldBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Federal Home Loan Bank stock represents an equity interest in a FHLB. It does not have a readily determinable fair value because
	/// its ownership is restricted and it lacks a market (liquidity).  This item is typically available for the bank industry.
	/// </summary>
	public class FederalHomeLoanBankStockBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FederalHomeLoanBankStockBalanceSheet class
		/// </summary>
		public FederalHomeLoanBankStockBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FederalHomeLoanBankStockBalanceSheet class
		/// </summary>
		public FederalHomeLoanBankStockBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fair values as of the balance sheet date of all assets resulting from contracts that meet the criteria of being accounted for as
	/// derivative instruments, net of the effects of master netting arrangements.
	/// </summary>
	public class FinancialAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FinancialAssetsBalanceSheet class
		/// </summary>
		public FinancialAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FinancialAssetsBalanceSheet class
		/// </summary>
		public FinancialAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying value as of the balance sheet date of securities that an institution sells and agrees to repurchase (the identical or
	/// substantially the same securities) as a seller-borrower at a specified date for a specified price, also known as a repurchase
	/// agreement.  This item is typically available for bank industry.
	/// </summary>
	public class FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet class
		/// </summary>
		public FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet class
		/// </summary>
		public FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying amount as of the balance sheet date of merchandise or goods held by the company that are readily available for sale.
	/// This item is typically available for mining and manufacturing industries.
	/// </summary>
	public class FinishedGoodsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FinishedGoodsBalanceSheet class
		/// </summary>
		public FinishedGoodsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FinishedGoodsBalanceSheet class
		/// </summary>
		public FinishedGoodsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It is one of the important fixed assets for transportation industry, which includes bicycles, cars, motorcycles, trains, ships, boats,
	/// and aircraft.  This item is typically available for transportation industry.
	/// </summary>
	public class FlightFleetVehicleAndRelatedEquipmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FlightFleetVehicleAndRelatedEquipmentsBalanceSheet class
		/// </summary>
		public FlightFleetVehicleAndRelatedEquipmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FlightFleetVehicleAndRelatedEquipmentsBalanceSheet class
		/// </summary>
		public FlightFleetVehicleAndRelatedEquipmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying amount as of the balance sheet date of all assets obtained in full or partial satisfaction of a debt arrangement through
	/// foreclosure proceedings or defeasance; includes real and personal property; equity interests in corporations, partnerships, and joint
	/// ventures; and beneficial interest in trusts.  This item is typically typically available for bank industry.
	/// </summary>
	public class ForeclosedAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ForeclosedAssetsBalanceSheet class
		/// </summary>
		public ForeclosedAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ForeclosedAssetsBalanceSheet class
		/// </summary>
		public ForeclosedAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Loans related to foreign countries.  This item is typically available for bank industry.
	/// </summary>
	public class ForeignComponentBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ForeignComponentBalanceSheet class
		/// </summary>
		public ForeignComponentBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ForeignComponentBalanceSheet class
		/// </summary>
		public ForeignComponentBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Changes to accumulated comprehensive income that results from the process of translating subsidiary financial statements and
	/// foreign equity investments into functional currency of the reporting company.
	/// </summary>
	public class ForeignCurrencyTranslationAdjustmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ForeignCurrencyTranslationAdjustmentsBalanceSheet class
		/// </summary>
		public ForeignCurrencyTranslationAdjustmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ForeignCurrencyTranslationAdjustmentsBalanceSheet class
		/// </summary>
		public ForeignCurrencyTranslationAdjustmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item discloses the period end balance sheet amount of fuel and natural gas. It is typically available for the utility industry.
	/// </summary>
	public class FuelAndNaturalGasBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the FuelAndNaturalGasBalanceSheet class
		/// </summary>
		public FuelAndNaturalGasBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the FuelAndNaturalGasBalanceSheet class
		/// </summary>
		public FuelAndNaturalGasBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Contracts held by defined benefit pension plans generally provide for a specified return on principal invested over a specified period.
	/// This item is typically available for the insurance industry.
	/// </summary>
	public class GuaranteedInvestmentContractBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GuaranteedInvestmentContractBalanceSheet class
		/// </summary>
		public GuaranteedInvestmentContractBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GuaranteedInvestmentContractBalanceSheet class
		/// </summary>
		public GuaranteedInvestmentContractBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item represents certain charges made in the current period in inventory resulting from such factors as breakage, spoilage,
	/// employee theft and shoplifting. This item is typically available for manufacturing, mining and utility industries.
	/// </summary>
	public class InventoriesAdjustmentsAllowancesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InventoriesAdjustmentsAllowancesBalanceSheet class
		/// </summary>
		public InventoriesAdjustmentsAllowancesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InventoriesAdjustmentsAllowancesBalanceSheet class
		/// </summary>
		public InventoriesAdjustmentsAllowancesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A specified percentage of the amount of certain new investment that a company can deduct as a credit against its income tax bill.
	/// This item is typically available for the utility industry.
	/// </summary>
	public class InvestmentTaxCreditsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InvestmentTaxCreditsBalanceSheet class
		/// </summary>
		public InvestmentTaxCreditsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InvestmentTaxCreditsBalanceSheet class
		/// </summary>
		public InvestmentTaxCreditsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The investments in (1) an entity in which the entity has significant influence, but does not have control; (2) subsidiaries that are
	/// required to be consolidated and are accounted for using the equity and or cost method; and (3) an entity in which the reporting
	/// entity shares control of the entity with another party or group.  This item is typically available for bank industry.
	/// </summary>
	public class InvestmentsInAffiliatesSubsidiariesAssociatesAndJointVenturesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InvestmentsInAffiliatesSubsidiariesAssociatesAndJointVenturesBalanceSheet class
		/// </summary>
		public InvestmentsInAffiliatesSubsidiariesAssociatesAndJointVenturesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InvestmentsInAffiliatesSubsidiariesAssociatesAndJointVenturesBalanceSheet class
		/// </summary>
		public InvestmentsInAffiliatesSubsidiariesAssociatesAndJointVenturesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item represents the carrying amount on the company's balance sheet of its investments in common stock of an equity method.
	/// This item is typically available for the insurance industry.
	/// </summary>
	public class InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet class
		/// </summary>
		public InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet class
		/// </summary>
		public InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item is typically available for bank industry. It means invest in an entity in which the investor holds a controlling interest that is
	/// not based on the majority of voting rights.
	/// </summary>
	public class InvestmentsInVariableInterestEntityBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the InvestmentsInVariableInterestEntityBalanceSheet class
		/// </summary>
		public InvestmentsInVariableInterestEntityBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the InvestmentsInVariableInterestEntityBalanceSheet class
		/// </summary>
		public InvestmentsInVariableInterestEntityBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fixed Assets that specifically deal with land a company owns. Includes the improvements associated with land. This excludes land
	/// held for sale.
	/// </summary>
	public class LandAndImprovementsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LandAndImprovementsBalanceSheet class
		/// </summary>
		public LandAndImprovementsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LandAndImprovementsBalanceSheet class
		/// </summary>
		public LandAndImprovementsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Carrying amount at the balance sheet date of a long-lived, depreciable asset that is an addition or improvement to assets held
	/// under lease arrangement. This item is usually not available for the insurance industry.
	/// </summary>
	public class LeasesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LeasesBalanceSheet class
		/// </summary>
		public LeasesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LeasesBalanceSheet class
		/// </summary>
		public LeasesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The obligations arising from the sale, disposal, or planned sale in the near future (generally within one year) of a disposal group,
	/// including a component of the entity (discontinued operation). This item is typically available for bank industry.
	/// </summary>
	public class LiabilitiesOfDiscontinuedOperationsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LiabilitiesOfDiscontinuedOperationsBalanceSheet class
		/// </summary>
		public LiabilitiesOfDiscontinuedOperationsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LiabilitiesOfDiscontinuedOperationsBalanceSheet class
		/// </summary>
		public LiabilitiesOfDiscontinuedOperationsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Two or more partners united to conduct a business jointly, and in which one or more of the partners is liable only to the extent of
	/// the amount of money that partner has invested. Limited partners do not receive dividends, but enjoy direct access to the flow of
	/// income and expenses.  This item is typically available for the insurance industry.
	/// </summary>
	public class LimitedPartnershipBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LimitedPartnershipBalanceSheet class
		/// </summary>
		public LimitedPartnershipBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LimitedPartnershipBalanceSheet class
		/// </summary>
		public LimitedPartnershipBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying value as of the balance sheet date of obligations drawn from a line of credit, which is a bank's commitment to make
	/// loans up to a specific amount.
	/// </summary>
	public class LineOfCreditBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LineOfCreditBalanceSheet class
		/// </summary>
		public LineOfCreditBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LineOfCreditBalanceSheet class
		/// </summary>
		public LineOfCreditBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It means the aggregate amount of loans receivable that will be sold to other entities.  This item is typically available for bank
	/// industry.
	/// </summary>
	public class LoansHeldForSaleBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LoansHeldForSaleBalanceSheet class
		/// </summary>
		public LoansHeldForSaleBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LoansHeldForSaleBalanceSheet class
		/// </summary>
		public LoansHeldForSaleBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Reflects the carrying amount of unpaid loans issued to other institutions for cash needs or an asset purchase.
	/// </summary>
	public class LoansReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LoansReceivableBalanceSheet class
		/// </summary>
		public LoansReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LoansReceivableBalanceSheet class
		/// </summary>
		public LoansReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Fixed assets specifically dealing with tools, equipment and office furniture. This item is usually not available for the insurance and
	/// utility industries.
	/// </summary>
	public class MachineryFurnitureEquipmentBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MachineryFurnitureEquipmentBalanceSheet class
		/// </summary>
		public MachineryFurnitureEquipmentBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MachineryFurnitureEquipmentBalanceSheet class
		/// </summary>
		public MachineryFurnitureEquipmentBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Aggregated amount of unprocessed materials to be used in manufacturing or production process and supplies that will be
	/// consumed. This item is typically available for the utility industry.
	/// </summary>
	public class MaterialsAndSuppliesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MaterialsAndSuppliesBalanceSheet class
		/// </summary>
		public MaterialsAndSuppliesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MaterialsAndSuppliesBalanceSheet class
		/// </summary>
		public MaterialsAndSuppliesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A fixed asset that represents strictly mineral type properties.  This item is typically available for mining industry.
	/// </summary>
	public class MineralPropertiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MineralPropertiesBalanceSheet class
		/// </summary>
		public MineralPropertiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MineralPropertiesBalanceSheet class
		/// </summary>
		public MineralPropertiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This is a lien on real estate to protect a lender.  This item is typically available for bank industry.
	/// </summary>
	public class MortgageLoanBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MortgageLoanBalanceSheet class
		/// </summary>
		public MortgageLoanBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MortgageLoanBalanceSheet class
		/// </summary>
		public MortgageLoanBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It means the aggregate amount of mortgage and consumer loans.  This item is typically available for the insurance industry.
	/// </summary>
	public class MortgageAndConsumerloansBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the MortgageAndConsumerloansBalanceSheet class
		/// </summary>
		public MortgageAndConsumerloansBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the MortgageAndConsumerloansBalanceSheet class
		/// </summary>
		public MortgageAndConsumerloansBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// It means a material source of wealth, such as timber, fresh water, or a mineral deposit, that occurs in a natural state and has
	/// economic value.  This item is typically available for bank industry.
	/// </summary>
	public class NaturalResourceAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NaturalResourceAssetsBalanceSheet class
		/// </summary>
		public NaturalResourceAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NaturalResourceAssetsBalanceSheet class
		/// </summary>
		public NaturalResourceAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of net unrealized gain or loss related to the change in fair value, not otherwise classified.
	/// </summary>
	public class NetOtherUnrealizedGainLossBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetOtherUnrealizedGainLossBalanceSheet class
		/// </summary>
		public NetOtherUnrealizedGainLossBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetOtherUnrealizedGainLossBalanceSheet class
		/// </summary>
		public NetOtherUnrealizedGainLossBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount of net unrealized gain or loss related to the change in fair value of foreign currency exchange rate.
	/// </summary>
	public class NetUnrealizedGainLossForeignCurrencyBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetUnrealizedGainLossForeignCurrencyBalanceSheet class
		/// </summary>
		public NetUnrealizedGainLossForeignCurrencyBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetUnrealizedGainLossForeignCurrencyBalanceSheet class
		/// </summary>
		public NetUnrealizedGainLossForeignCurrencyBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The aggregate increase (decrease) in the market value of unsold investments at the end of an accounting period.
	/// </summary>
	public class NetUnrealizedGainLossInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NetUnrealizedGainLossInvestmentsBalanceSheet class
		/// </summary>
		public NetUnrealizedGainLossInvestmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NetUnrealizedGainLossInvestmentsBalanceSheet class
		/// </summary>
		public NetUnrealizedGainLossInvestmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
	/// at a future date(s) within one year of the balance sheet date or the normal operating cycle. Such amount may include accrued
	/// interest receivable in accordance with the terms of the note. The note also may contain provisions including a discount or premium,
	/// payable on demand, secured, or unsecured, interest bearing or non-interest bearing, among myriad other features and
	/// characteristics. This item is typically available for bank industry.
	/// </summary>
	public class GrossNotesReceivableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the GrossNotesReceivableBalanceSheet class
		/// </summary>
		public GrossNotesReceivableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the GrossNotesReceivableBalanceSheet class
		/// </summary>
		public GrossNotesReceivableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other non-current assets that are not otherwise classified.
	/// </summary>
	public class OtherAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherAssetsBalanceSheet class
		/// </summary>
		public OtherAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherAssetsBalanceSheet class
		/// </summary>
		public OtherAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other Capital Stock that is not otherwise classified.
	/// </summary>
	public class OtherCapitalStockBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherCapitalStockBalanceSheet class
		/// </summary>
		public OtherCapitalStockBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherCapitalStockBalanceSheet class
		/// </summary>
		public OtherCapitalStockBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other current assets that are not otherwise classified.
	/// </summary>
	public class OtherCurrentAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherCurrentAssetsBalanceSheet class
		/// </summary>
		public OtherCurrentAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherCurrentAssetsBalanceSheet class
		/// </summary>
		public OtherCurrentAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Short Term Borrowings that are not otherwise classified.
	/// </summary>
	public class OtherCurrentBorrowingsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherCurrentBorrowingsBalanceSheet class
		/// </summary>
		public OtherCurrentBorrowingsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherCurrentBorrowingsBalanceSheet class
		/// </summary>
		public OtherCurrentBorrowingsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A cost that occurred in a transaction, but will not be expensed until a future accounting period.
	/// </summary>
	public class OtherDeferredCostsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherDeferredCostsBalanceSheet class
		/// </summary>
		public OtherDeferredCostsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherDeferredCostsBalanceSheet class
		/// </summary>
		public OtherDeferredCostsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other deposits that are not otherwise classified.
	/// </summary>
	public class OtherDepositsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherDepositsBalanceSheet class
		/// </summary>
		public OtherDepositsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherDepositsBalanceSheet class
		/// </summary>
		public OtherDepositsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other adjustments to stockholders' equity that is not otherwise classified.
	/// </summary>
	public class OtherEquityAdjustmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherEquityAdjustmentsBalanceSheet class
		/// </summary>
		public OtherEquityAdjustmentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherEquityAdjustmentsBalanceSheet class
		/// </summary>
		public OtherEquityAdjustmentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other investment assets that from which interest is earned, not otherwise classified.
	/// </summary>
	public class OtherInterestEarningAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherInterestEarningAssetsBalanceSheet class
		/// </summary>
		public OtherInterestEarningAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherInterestEarningAssetsBalanceSheet class
		/// </summary>
		public OtherInterestEarningAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other non-current inventories not otherwise classified.
	/// </summary>
	public class OtherInventoriesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherInventoriesBalanceSheet class
		/// </summary>
		public OtherInventoriesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherInventoriesBalanceSheet class
		/// </summary>
		public OtherInventoriesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// An item represents all the other investments or/and securities that cannot be defined into any category above. This item is typically
	/// available for the insurance industry.
	/// </summary>
	public class OtherInvestedAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherInvestedAssetsBalanceSheet class
		/// </summary>
		public OtherInvestedAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherInvestedAssetsBalanceSheet class
		/// </summary>
		public OtherInvestedAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other non-current assets that are not otherwise classified.
	/// </summary>
	public class OtherNonCurrentAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherNonCurrentAssetsBalanceSheet class
		/// </summary>
		public OtherNonCurrentAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherNonCurrentAssetsBalanceSheet class
		/// </summary>
		public OtherNonCurrentAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other fixed assets not otherwise classified.
	/// </summary>
	public class OtherPropertiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherPropertiesBalanceSheet class
		/// </summary>
		public OtherPropertiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherPropertiesBalanceSheet class
		/// </summary>
		public OtherPropertiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The Carrying amount as of the balance sheet date of other real estate, which may include real estate investments, real estate loans
	/// that qualify as investments in real estate, and premises that are no longer used in operations may also be included in real estate
	/// owned. This does not include real estate assets taken in settlement of troubled loans through surrender or foreclosure.  This item is
	/// typically available for bank industry.
	/// </summary>
	public class OtherRealEstateOwnedBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherRealEstateOwnedBalanceSheet class
		/// </summary>
		public OtherRealEstateOwnedBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherRealEstateOwnedBalanceSheet class
		/// </summary>
		public OtherRealEstateOwnedBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Other non-current receivables not otherwise classified.
	/// </summary>
	public class OtherReceivablesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the OtherReceivablesBalanceSheet class
		/// </summary>
		public OtherReceivablesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the OtherReceivablesBalanceSheet class
		/// </summary>
		public OtherReceivablesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A type of intangible asset, it provides an exclusive right to the patent holder to product or sell new inventions.
	/// </summary>
	public class PatentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PatentsBalanceSheet class
		/// </summary>
		public PatentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PatentsBalanceSheet class
		/// </summary>
		public PatentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A loan issued by an insurance company that uses the cash value of a person's life insurance policy as collateral.  This item is usually
	/// only available in the insurance industry.
	/// </summary>
	public class NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet class
		/// </summary>
		public NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet class
		/// </summary>
		public NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A loan issued by an insurance company that uses the cash value of a person's life insurance policy as collateral. This item is usually
	/// only available for insurance industry.
	/// </summary>
	public class PolicyLoansBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PolicyLoansBalanceSheet class
		/// </summary>
		public PolicyLoansBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PolicyLoansBalanceSheet class
		/// </summary>
		public PolicyLoansBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A class of ownership in a company that has a higher claim on the assets and earnings than common stock. Preferred stock
	/// generally has a dividend that must be paid out before dividends to common stockholders and the shares usually do not have voting
	/// rights.
	/// </summary>
	public class PreferredStockEquityBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PreferredStockEquityBalanceSheet class
		/// </summary>
		public PreferredStockEquityBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PreferredStockEquityBalanceSheet class
		/// </summary>
		public PreferredStockEquityBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This is preferred stock of a subsidiary, which belongs to the company's equity. This item is usually only available for utility industry.
	/// </summary>
	public class PreferredStockOfSubsidiaryBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PreferredStockOfSubsidiaryBalanceSheet class
		/// </summary>
		public PreferredStockOfSubsidiaryBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PreferredStockOfSubsidiaryBalanceSheet class
		/// </summary>
		public PreferredStockOfSubsidiaryBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// This item is usually only available for insurance industry.
	/// </summary>
	public class PreferredStocksAvailableForSaleBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PreferredStocksAvailableForSaleBalanceSheet class
		/// </summary>
		public PreferredStocksAvailableForSaleBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PreferredStocksAvailableForSaleBalanceSheet class
		/// </summary>
		public PreferredStocksAvailableForSaleBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The unexpired portion of premiums paid to another insurer as a result of reinsurance arrangement as of the balance sheet date. This
	/// item is usually only available for insurance industry.
	/// </summary>
	public class PrepaidReinsurancePremiumsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PrepaidReinsurancePremiumsBalanceSheet class
		/// </summary>
		public PrepaidReinsurancePremiumsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PrepaidReinsurancePremiumsBalanceSheet class
		/// </summary>
		public PrepaidReinsurancePremiumsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Tangible assets that are held by an entity for use in the production or supply of goods and services, for rental to others, or for
	/// administrative purposes and that are expected to provide economic benefit for more than one year. This item is available for
	/// manufacturing, bank and transportation industries.
	/// </summary>
	public class PropertiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PropertiesBalanceSheet class
		/// </summary>
		public PropertiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PropertiesBalanceSheet class
		/// </summary>
		public PropertiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Provisions are created to protect the interests of one or both parties named in a contract or legal document which is a preparatory
	/// action or measure. Current provision is expired within one accounting period.
	/// </summary>
	public class CurrentProvisionsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the CurrentProvisionsBalanceSheet class
		/// </summary>
		public CurrentProvisionsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the CurrentProvisionsBalanceSheet class
		/// </summary>
		public CurrentProvisionsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Provisions are created to protect the interests of one or both parties named in a contract or legal document which is a preparatory
	/// action or measure. Long-term provision is expired beyond one accounting period.
	/// </summary>
	public class LongTermProvisionsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the LongTermProvisionsBalanceSheet class
		/// </summary>
		public LongTermProvisionsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the LongTermProvisionsBalanceSheet class
		/// </summary>
		public LongTermProvisionsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Individual parts purchased in order to complete a finished product.
	/// </summary>
	public class PurchasedComponentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the PurchasedComponentsBalanceSheet class
		/// </summary>
		public PurchasedComponentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the PurchasedComponentsBalanceSheet class
		/// </summary>
		public PurchasedComponentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Carrying amount as of the balance sheet data of unprocessed items to be consumed in the manufacturing or production process.
	/// This item is available for manufacturing and mining industries.
	/// </summary>
	public class RawMaterialsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RawMaterialsBalanceSheet class
		/// </summary>
		public RawMaterialsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RawMaterialsBalanceSheet class
		/// </summary>
		public RawMaterialsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Held real estate investments with the purpose of being sold.  This includes direct and indirect investments.  This item is usually only
	/// available for insurance industry.
	/// </summary>
	public class RealEstateHeldForSaleBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RealEstateHeldForSaleBalanceSheet class
		/// </summary>
		public RealEstateHeldForSaleBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RealEstateHeldForSaleBalanceSheet class
		/// </summary>
		public RealEstateHeldForSaleBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The book value of investments in real estate joint ventures including direct and indirect investments.  This item is usually only
	/// available for insurance industry.
	/// </summary>
	public class RealEstateAndRealEstateJointVenturesHeldForInvestmentBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RealEstateAndRealEstateJointVenturesHeldForInvestmentBalanceSheet class
		/// </summary>
		public RealEstateAndRealEstateJointVenturesHeldForInvestmentBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RealEstateAndRealEstateJointVenturesHeldForInvestmentBalanceSheet class
		/// </summary>
		public RealEstateAndRealEstateJointVenturesHeldForInvestmentBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// A provision relating to a written agreement to receive money at a specified future date(s) (within one year from the reporting date
	/// or the normal operating cycle, whichever is longer), consisting of principal as well as any accrued interest).
	/// </summary>
	public class ReceivablesAdjustmentsAllowancesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReceivablesAdjustmentsAllowancesBalanceSheet class
		/// </summary>
		public ReceivablesAdjustmentsAllowancesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReceivablesAdjustmentsAllowancesBalanceSheet class
		/// </summary>
		public ReceivablesAdjustmentsAllowancesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// Carrying amount as of the balance sheet date of capitalized costs of regulated entities that are expected to be recovered through
	/// revenue sources over one year or beyond the normal operating cycle.
	/// </summary>
	public class RegulatoryAssetsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RegulatoryAssetsBalanceSheet class
		/// </summary>
		public RegulatoryAssetsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RegulatoryAssetsBalanceSheet class
		/// </summary>
		public RegulatoryAssetsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The amount for the individual regulatory noncurrent liability as itemized in a table of regulatory noncurrent liabilities as of the end of
	/// the period. Such things as the costs of energy efficiency programs and low-income energy assistances programs and deferred fuel.
	/// This item is usually only available for utility industry.
	/// </summary>
	public class RegulatoryLiabilitiesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RegulatoryLiabilitiesBalanceSheet class
		/// </summary>
		public RegulatoryLiabilitiesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RegulatoryLiabilitiesBalanceSheet class
		/// </summary>
		public RegulatoryLiabilitiesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying amount as of the balance sheet date of the known and estimated amounts owed to insurers under reinsurance
	/// treaties or other arrangements. This item is usually only available for insurance industry.
	/// </summary>
	public class ReinsuranceBalancesPayableBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReinsuranceBalancesPayableBalanceSheet class
		/// </summary>
		public ReinsuranceBalancesPayableBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReinsuranceBalancesPayableBalanceSheet class
		/// </summary>
		public ReinsuranceBalancesPayableBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The sum for all reinsurance arrangements of the known and estimated amount receivable as of the balance sheet date from a given
	/// reinsurers for claims paid or incurred by the ceding insurer and associated claims settlement expenses for each reinsurance
	/// arrangement (or, the sum of all cases determined individually, likely applying different assumptions to each arrangement). This item
	/// is usually only available for insurance industry.
	/// </summary>
	public class ReinsuranceReceivablesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReinsuranceReceivablesBalanceSheet class
		/// </summary>
		public ReinsuranceReceivablesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReinsuranceReceivablesBalanceSheet class
		/// </summary>
		public ReinsuranceReceivablesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The recoverable currently due from reinsurers for ceded paid losses. This item is usually only available for the insurance industry.
	/// </summary>
	public class ReinsuranceRecoverableForPaidLossesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoverableForPaidLossesBalanceSheet class
		/// </summary>
		public ReinsuranceRecoverableForPaidLossesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoverableForPaidLossesBalanceSheet class
		/// </summary>
		public ReinsuranceRecoverableForPaidLossesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The recoverable currently due from reinsurers for unpaid losses. This item is usually only available for the insurance industry.
	/// </summary>
	public class ReinsuranceRecoverableForUnpaidLossesBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoverableForUnpaidLossesBalanceSheet class
		/// </summary>
		public ReinsuranceRecoverableForUnpaidLossesBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the ReinsuranceRecoverableForUnpaidLossesBalanceSheet class
		/// </summary>
		public ReinsuranceRecoverableForUnpaidLossesBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying amounts of cash and cash equivalent items, which are restricted as to withdrawal or usage. Restrictions may include
	/// legally restricted deposits held as compensating balances against short-term borrowing arrangements, contracts entered into with
	/// others, or entity statements of intention with regard to particular deposits; however, time deposits and short-term certificates of
	/// deposit are not generally included in legally restricted deposits. Excludes compensating balance arrangements that are not
	/// agreements, which legally restrict the use of cash amounts shown on the balance sheet. For a classified balance sheet, represents
	/// the current portion only (the non-current portion has a separate concept); for an unclassified balance sheet represents the entire
	/// amount. This item is usually not available for bank and insurance industries.
	/// </summary>
	public class RestrictedCashBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the OneMonth period value for the field
		/// </summary>
		[JsonProperty(Period.OneMonth)]
		public decimal OneMonth
		{
			get { return GetPeriodValue(Period.OneMonth); }
			set { SetPeriodValue(Period.OneMonth, value); }
		}

		/// <summary>
		/// Gets/sets the TwoMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwoMonths)]
		public decimal TwoMonths
		{
			get { return GetPeriodValue(Period.TwoMonths); }
			set { SetPeriodValue(Period.TwoMonths, value); }
		}

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RestrictedCashBalanceSheet class
		/// </summary>
		public RestrictedCashBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RestrictedCashBalanceSheet class
		/// </summary>
		public RestrictedCashBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The carrying amounts of cash and cash equivalent items which are restricted as to withdrawal or usage. This item is available for
	/// bank and insurance industries.
	/// </summary>
	public class RestrictedCashAndCashEquivalentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { return GetPeriodValue(Period.SixMonths); }
			set { SetPeriodValue(Period.SixMonths, value); }
		}

		/// <summary>
		/// Gets/sets the NineMonths period value for the field
		/// </summary>
		[JsonProperty(Period.NineMonths)]
		public decimal NineMonths
		{
			get { return GetPeriodValue(Period.NineMonths); }
			set { SetPeriodValue(Period.NineMonths, value); }
		}

		/// <summary>
		/// Gets/sets the TwelveMonths period value for the field
		/// </summary>
		[JsonProperty(Period.TwelveMonths)]
		public decimal TwelveMonths
		{
			get { return GetPeriodValue(Period.TwelveMonths); }
			set { SetPeriodValue(Period.TwelveMonths, value); }
		}

		/// <summary>
		/// Creates an instance of the RestrictedCashAndCashEquivalentsBalanceSheet class
		/// </summary>
		public RestrictedCashAndCashEquivalentsBalanceSheet() { Store = new Dictionary<string, decimal>(); }

		/// <summary>
		/// Creates an instance of the RestrictedCashAndCashEquivalentsBalanceSheet class
		/// </summary>
		public RestrictedCashAndCashEquivalentsBalanceSheet(IDictionary<string, decimal> store) { Store = store; }
	}

	/// <summary>
	/// The cash and investments whose use in whole or in part is restricted for the long-term, generally by contractual agreements or
	/// regulatory requirements. This item is usually only available for bank industry.
	/// </summary>
	public class RestrictedCashAndInvestmentsBalanceSheet : MultiPeriodField
	{
		/// <summary>
		/// Gets the default period for the field
		/// </summary>
		protected override string DefaultPeriod { get { return Period.TwelveMonths; } }

		/// <summary>
		/// Gets/sets the ThreeMonths period value for the field
		/// </summary>
		[JsonProperty(Period.ThreeMonths)]
		public decimal ThreeMonths
		{
			get { return GetPeriodValue(Period.ThreeMonths); }
			set { SetPeriodValue(Period.ThreeMonths, value); }
		}

		/// <summary>
		/// Gets/sets the SixMonths period value for the field
		/// </summary>
		[JsonProperty(Period.SixMonths)]
		public decimal SixMonths
		{
			get { r