﻿/*
 * QUANTCONNECT.COM - Democratizing Finance, Empowering Individuals.
 * Lean Algorithmic Trading Engine v2.0. Copyright 2014 QuantConnect Corporation.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

namespace QuantConnect.Data.Fundamental
{
    /// <summary>
    /// Period constants for multi-period fields
    /// </summary>
    public static class Period
    {
        /// <summary>
        /// Period constant for one month
        /// </summary>
        public const string OneMonth = "1M";

        /// <summary>
        /// Period constant for two months
        /// </summary>
        public const string TwoMonths = "2M";

        /// <summary>
        /// Period constant for three months
        /// </summary>
        public const string ThreeMonths = "3M";

        /// <summary>
        /// Period constant for six months
        /// </summary>
        public const string SixMonths = "6M";

        /// <summary>
        /// Period constant for nine months
        /// </summary>
        public const string NineMonths = "9M";

        /// <summary>
        /// Period constant for twelve months
        /// </summary>
        public const string TwelveMonths = "12M";

        /// <summary>
        /// Period constant for one year
        /// </summary>
        public const string OneYear = "1Y";

        /// <summary>
        /// Period constant for two years
        /// </summary>
        public const string TwoYears = "2Y";

        /// <summary>
        /// Period constant for three years
        /// </summary>
        public const string ThreeYears = "3Y";

        /// <summary>
        /// Period constant for five years
        /// </summary>
        public const string FiveYears = "5Y";

        /// <summary>
        /// Period constant for ten years
        /// </summary>
        public const string TenYears = "10Y";
    }
}
