﻿namespace QuantConnect.Packets
{
    /// <summary>
    /// Debug packets generated by Lean
    /// </summary>
    public class SystemDebugPacket : DebugPacket
    {
        /// <summary>
        /// Default constructor for JSON
        /// </summary>
        public SystemDebugPacket()
            : base (PacketType.SystemDebug)
        { }

        /// <summary>
        /// Create a new instance of the system debug packet
        /// </summary>
        public SystemDebugPacket(int projectId, string algorithmId, string compileId, string message, bool toast = false)
            : base(PacketType.SystemDebug)
        {
            ProjectId = projectId;
            Message = message;
            CompileId = compileId;
            AlgorithmId = algorithmId;
            Toast = toast;
        }
    }
}
