/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.LongProbe;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.util.Preconditions;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public final class ThreadMetricSet {
    private ThreadMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        metricsRegistry.register(mxBean, "thread.threadCount", new LongProbe<ThreadMXBean>(){

            @Override
            public long get(ThreadMXBean threadMXBean) {
                return threadMXBean.getThreadCount();
            }
        });
        metricsRegistry.register(mxBean, "thread.peakThreadCount", new LongProbe<ThreadMXBean>(){

            @Override
            public long get(ThreadMXBean threadMXBean) {
                return threadMXBean.getPeakThreadCount();
            }
        });
        metricsRegistry.register(mxBean, "thread.daemonThreadCount", new LongProbe<ThreadMXBean>(){

            @Override
            public long get(ThreadMXBean threadMXBean) {
                return threadMXBean.getDaemonThreadCount();
            }
        });
        metricsRegistry.register(mxBean, "thread.totalStartedThreadCount", new LongProbe<ThreadMXBean>(){

            @Override
            public long get(ThreadMXBean threadMXBean) {
                return threadMXBean.getTotalStartedThreadCount();
            }
        });
    }
}

