/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.ConstructorFunction;

public final class ArrayDataSerializableFactory
implements DataSerializableFactory {
    private final ConstructorFunction<Integer, IdentifiedDataSerializable>[] constructors;
    private final int len;

    public ArrayDataSerializableFactory(ConstructorFunction<Integer, IdentifiedDataSerializable>[] ctorArray) {
        if (ctorArray != null && ctorArray.length > 0) {
            this.len = ctorArray.length;
            this.constructors = new ConstructorFunction[this.len];
            System.arraycopy(ctorArray, 0, this.constructors, 0, this.len);
        } else {
            this.len = 0;
            this.constructors = new ConstructorFunction[this.len];
        }
    }

    @Override
    public IdentifiedDataSerializable create(int typeId) {
        if (typeId >= 0 && typeId < this.len) {
            ConstructorFunction<Integer, IdentifiedDataSerializable> factory = this.constructors[typeId];
            return factory != null ? factory.createNew(typeId) : null;
        }
        return null;
    }
}

