/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp.dependencies;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.JavaFileObjectWithLocation;
import com.sun.tools.sjavac.comp.PubAPIs;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class NewDependencyCollector
implements TaskListener {
    private final Context context;
    private final Collection<JavaFileObject> explicitJFOs;
    private Map<String, Map<String, Set<String>>> deps;
    private Map<String, Map<String, Set<String>>> cpDeps;

    public NewDependencyCollector(Context context, Collection<JavaFileObject> explicitJFOs) {
        this.context = context;
        this.explicitJFOs = explicitJFOs;
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() == TaskEvent.Kind.COMPILATION) {
            this.collectPubApisOfDependencies(this.context, this.explicitJFOs);
            this.deps = this.getDependencies(this.context, this.explicitJFOs, false);
            this.cpDeps = this.getDependencies(this.context, this.explicitJFOs, true);
        }
    }

    public Map<String, Map<String, Set<String>>> getDependencies(boolean cp) {
        return cp ? this.cpDeps : this.deps;
    }

    private Set<Dependencies.GraphDependencies.CompletionNode> getDependencyNodes(Context context, Collection<JavaFileObject> explicitJFOs, boolean explicits) {
        Dependencies.GraphDependencies deps = (Dependencies.GraphDependencies)Dependencies.GraphDependencies.instance(context);
        return deps.getNodes().stream().filter(n -> n instanceof Dependencies.GraphDependencies.CompletionNode).map(n -> (Dependencies.GraphDependencies.CompletionNode)n).filter(n -> n.getClassSymbol().fullname != null).filter(n -> explicits == explicitJFOs.contains(n.getClassSymbol().classfile)).collect(Collectors.toSet());
    }

    private void collectPubApisOfDependencies(Context context, Collection<JavaFileObject> explicitJFOs) {
        PubAPIs pubApis = PubAPIs.instance(context);
        for (Dependencies.GraphDependencies.CompletionNode cDepNode : this.getDependencyNodes(context, explicitJFOs, false)) {
            Symbol.ClassSymbol cs = cDepNode.getClassSymbol().outermostClass();
            JavaFileManager.Location loc = this.getLocationOf(cs);
            if (loc != StandardLocation.CLASS_PATH && loc != StandardLocation.SOURCE_PATH) continue;
            pubApis.visitPubapi(cs);
        }
    }

    private JavaFileManager.Location getLocationOf(Symbol.ClassSymbol cs) {
        JavaFileObject jfo = cs.outermostClass().classfile;
        if (jfo instanceof JavaFileObjectWithLocation) {
            return ((JavaFileObjectWithLocation)jfo).getLocation();
        }
        return null;
    }

    private Map<String, Map<String, Set<String>>> getDependencies(Context context, Collection<JavaFileObject> explicitJFOs, boolean cp) {
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>();
        for (Dependencies.GraphDependencies.CompletionNode cnode : this.getDependencyNodes(context, explicitJFOs, true)) {
            String fqDep = cnode.getClassSymbol().outermostClass().flatname.toString();
            String depPkg = Util.pkgNameOfClassName(fqDep);
            HashMap<String, HashSet<String>> depsForThisClass = (HashMap<String, HashSet<String>>)result.get(depPkg);
            if (depsForThisClass == null) {
                depsForThisClass = new HashMap<String, HashSet<String>>();
                result.put(depPkg, depsForThisClass);
            }
            for (GraphUtils.Node node : cnode.getDependenciesByKind(Dependencies.GraphDependencies.Node.DependencyKind.REQUIRES)) {
                Dependencies.GraphDependencies.CompletionNode cDepNode;
                boolean isCompletionNode = node instanceof Dependencies.GraphDependencies.CompletionNode;
                if (!isCompletionNode || (cDepNode = (Dependencies.GraphDependencies.CompletionNode)node) == cnode || cDepNode.getClassSymbol().fullname == null) continue;
                JavaFileManager.Location depLoc = this.getLocationOf(cDepNode.getClassSymbol());
                boolean relevant = cp && depLoc == StandardLocation.CLASS_PATH || !cp && depLoc == StandardLocation.SOURCE_PATH;
                if (!relevant) continue;
                HashSet<String> fqDeps = (HashSet<String>)depsForThisClass.get(fqDep);
                if (fqDeps == null) {
                    fqDeps = new HashSet<String>();
                    depsForThisClass.put(fqDep, fqDeps);
                }
                fqDeps.add(cDepNode.getClassSymbol().outermostClass().flatname.toString());
            }
        }
        return result;
    }
}

