/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneCompiler;
import com.google.errorprone.ErrorProneError;
import com.google.errorprone.ErrorProneOptions;
import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import java.util.Queue;

public class ErrorProneJavacJavaCompiler
extends JavaCompiler {
    private final ErrorProneAnalyzer errorProneAnalyzer;

    public static void setupMessageBundle(Context context) {
        JavacMessages.instance(context).add("com.google.errorprone.errors");
    }

    private ErrorProneJavacJavaCompiler(Context context, CodeTransformer transformer, ErrorProneOptions errorProneOptions) {
        super(context);
        Preconditions.checkNotNull((Object)transformer);
        ErrorProneJavacJavaCompiler.setupMessageBundle(context);
        this.errorProneAnalyzer = ErrorProneAnalyzer.create(transformer).init(context, errorProneOptions);
    }

    public static void preRegister(Context context, final CodeTransformer transformer, final ErrorProneOptions errorProneOptions) {
        context.put(compilerKey, new Context.Factory<JavaCompiler>(){

            @Override
            public JavaCompiler make(Context ctx) {
                return new ErrorProneJavacJavaCompiler(ctx, transformer, errorProneOptions);
            }
        });
    }

    @Override
    protected void flow(Env<AttrContext> env, Queue<Env<AttrContext>> results) {
        if (this.compileStates.isDone(env, CompileStates.CompileState.FLOW)) {
            super.flow(env, results);
            return;
        }
        super.flow(env, results);
        try {
            this.postFlow(env);
        }
        catch (ErrorProneError e) {
            e.logFatalError(this.log);
            throw e;
        }
        catch (Throwable e) {
            String version = (String)ErrorProneCompiler.loadVersionFromPom().or((Object)"unknown version");
            this.log.error("error.prone.crash", Throwables.getStackTraceAsString((Throwable)e), version);
        }
    }

    public void postFlow(Env<AttrContext> env) {
        this.errorProneAnalyzer.finished(new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym));
    }
}

