/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.analysis;

import com.google.errorprone.DescriptionListener;
import com.google.errorprone.analysis.AnalysesConfig;
import com.google.errorprone.analysis.AutoValue_LocalAnalysisAsTopLevelAnalysis;
import com.google.errorprone.analysis.LocalAnalysis;
import com.google.errorprone.analysis.TopLevelAnalysis;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.util.Context;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

public abstract class LocalAnalysisAsTopLevelAnalysis
implements TopLevelAnalysis {
    static LocalAnalysisAsTopLevelAnalysis wrap(LocalAnalysis analysis) {
        return new AutoValue_LocalAnalysisAsTopLevelAnalysis(analysis);
    }

    abstract LocalAnalysis analysis();

    LocalAnalysisAsTopLevelAnalysis() {
    }

    @Override
    public Set<String> knownAnalysisNames() {
        return this.analysis().allNames();
    }

    private boolean suppressed(Tree tree) {
        switch (this.analysis().suppressibility()) {
            case UNSUPPRESSIBLE: {
                return false;
            }
            case CUSTOM_ANNOTATION: {
                for (Class<? extends Annotation> customSuppressionAnnotation : this.analysis().customSuppressionAnnotations()) {
                    if (!ASTHelpers.hasAnnotation(tree, customSuppressionAnnotation)) continue;
                    return true;
                }
                return false;
            }
            case SUPPRESS_WARNINGS: {
                SuppressWarnings suppressions = ASTHelpers.getAnnotation(tree, SuppressWarnings.class);
                return suppressions != null && !Collections.disjoint(Arrays.asList(suppressions.value()), this.analysis().allNames());
            }
        }
        throw new AssertionError();
    }

    @Override
    public void analyze(CompilationUnitTree compilationUnit, final Context context, final AnalysesConfig configuration, DescriptionListener listener) {
        new TreePathScanner<Void, DescriptionListener>(){

            @Override
            public Void scan(Tree tree, DescriptionListener listener) {
                if (!LocalAnalysisAsTopLevelAnalysis.this.suppressed(tree)) {
                    LocalAnalysisAsTopLevelAnalysis.this.analysis().analyze(this.getCurrentPath(), context, configuration, listener);
                    super.scan(tree, listener);
                }
                return null;
            }
        }.scan(new TreePath(compilationUnit), listener);
    }
}

