/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;

public abstract class AbstractReturnValueIgnored
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (Matchers.allOf(Matchers.parentNode(Matchers.kindIs(Tree.Kind.EXPRESSION_STATEMENT)), Matchers.not(Matchers.methodSelect(Matchers.allOf(Matchers.kindIs(Tree.Kind.IDENTIFIER), AbstractReturnValueIgnored.identifierHasName("super")))), this.specializedMatcher()).matches(methodInvocationTree, state)) {
            return this.describe(methodInvocationTree, state);
        }
        return Description.NO_MATCH;
    }

    public abstract Matcher<? super MethodInvocationTree> specializedMatcher();

    private static Matcher<ExpressionTree> identifierHasName(final String name) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree item, VisitorState state) {
                return ((IdentifierTree)item).getName().contentEquals(name);
            }
        };
    }

    public Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Fix fix;
        ExpressionTree identifierExpr = ASTHelpers.getRootAssignable(methodInvocationTree);
        String identifierStr = null;
        Type identifierType = null;
        if (identifierExpr != null) {
            identifierStr = identifierExpr.toString();
            if (identifierExpr instanceof JCTree.JCIdent) {
                identifierType = ((JCTree.JCIdent)identifierExpr).sym.type;
            } else if (identifierExpr instanceof JCTree.JCFieldAccess) {
                identifierType = ((JCTree.JCFieldAccess)identifierExpr).sym.type;
            } else {
                throw new IllegalStateException("Expected a JCIdent or a JCFieldAccess");
            }
        }
        Type returnType = ASTHelpers.getReturnType(((JCTree.JCMethodInvocation)methodInvocationTree).getMethodSelect());
        if (identifierStr != null && !"this".equals(identifierStr) && returnType != null && state.getTypes().isAssignable(returnType, identifierType)) {
            fix = SuggestedFix.prefixWith(methodInvocationTree, identifierStr + " = ");
        } else {
            Tree parent = state.getPath().getParentPath().getLeaf();
            fix = SuggestedFix.delete(parent);
        }
        return this.describeMatch(methodInvocationTree, fix);
    }
}

