/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ArrayToStringConcatenation", summary="Implicit toString used on an array (String + Array)", explanation="When concatenating an array to a string, the toString method on an array will yield its identity, such as [I@4488aabb. This is almost never needed. Use Arrays.toString to obtain a human-readable array summary.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ArrayToStringConcatenation
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Matcher<ExpressionTree> arrayMatcher = Matchers.isArrayType();
    private static final Matcher<BinaryTree> concatenationMatcher = Matchers.allOf(Matchers.kindIs(Tree.Kind.PLUS), Matchers.binaryTree(arrayMatcher, Matchers.isSameType("java.lang.String")));

    @Override
    public Description matchBinary(BinaryTree t, VisitorState state) {
        if (!concatenationMatcher.matches(t, state)) {
            return Description.NO_MATCH;
        }
        String leftOperand = t.getLeftOperand().toString();
        String rightOperand = t.getRightOperand().toString();
        String replacement = arrayMatcher.matches(t.getLeftOperand(), state) ? "Arrays.toString(" + leftOperand + ") + " + rightOperand : leftOperand + " + Arrays.toString(" + rightOperand + ")";
        Fix fix = SuggestedFix.builder().replace(t, replacement).addImport("java.util.Arrays").build();
        return this.describeMatch(t, fix);
    }
}

