/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.CompileTimeConstantExpressionMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Iterator;

@BugPattern(name="CompileTimeConstant", summary="Non-compile-time constant expression passed to parameter with @CompileTimeConstant type annotation.", explanation="A method or constructor with one or more parameters whose declaration is annotated with the @CompileTimeConstant type annotation must only be invoked with corresponding actual parameters that are computed as compile-time constant expressions, such as a literal or static final constant.", linkType=BugPattern.LinkType.NONE, category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class CompileTimeConstantChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String DID_YOU_MEAN_FINAL_FMT_MESSAGE = " Did you mean to make '%s' final?";
    private final Matcher<ExpressionTree> compileTimeConstExpressionMatcher = new CompileTimeConstantExpressionMatcher();

    private Description matchArguments(VisitorState state, Symbol.MethodSymbol calleeSymbol, Iterator<? extends ExpressionTree> actualParams) {
        Symbol lastFormalParam = null;
        for (Symbol.VarSymbol formalParam : calleeSymbol.getParameters()) {
            lastFormalParam = formalParam;
            if (!actualParams.hasNext()) {
                return Description.NO_MATCH;
            }
            ExpressionTree actualParam = actualParams.next();
            if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation(state, formalParam) || this.compileTimeConstExpressionMatcher.matches(actualParam, state)) continue;
            return this.handleMatch(actualParam, state);
        }
        if (lastFormalParam == null || (lastFormalParam.flags() & 0x400000000L) == 0L) {
            return Description.NO_MATCH;
        }
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation(state, lastFormalParam)) {
            return Description.NO_MATCH;
        }
        while (actualParams.hasNext()) {
            ExpressionTree actualParam = actualParams.next();
            if (this.compileTimeConstExpressionMatcher.matches(actualParam, state)) continue;
            return this.handleMatch(actualParam, state);
        }
        return Description.NO_MATCH;
    }

    private Description handleMatch(ExpressionTree actualParam, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(actualParam);
        if (!(sym instanceof Symbol.VarSymbol)) {
            return this.describeMatch(actualParam);
        }
        Symbol.VarSymbol var = (Symbol.VarSymbol)sym;
        if (!CompileTimeConstantExpressionMatcher.hasCompileTimeConstantAnnotation(state, var)) {
            return this.describeMatch(actualParam);
        }
        return this.buildDescription(actualParam).setMessage(this.message() + String.format(DID_YOU_MEAN_FINAL_FMT_MESSAGE, var.getSimpleName())).build();
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        JCTree.JCNewClass newClass = (JCTree.JCNewClass)tree;
        return this.matchArguments(state, (Symbol.MethodSymbol)newClass.constructor, tree.getArguments().iterator());
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree methodSelect = tree.getMethodSelect();
        Symbol sym = ASTHelpers.getSymbol(methodSelect);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        return this.matchArguments(state, (Symbol.MethodSymbol)sym, tree.getArguments().iterator());
    }
}

