/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Predicate;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Set;

@BugPattern(name="EqualsIncompatibleType", summary="An equality test between objects with incompatible types always returns false", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class EqualsIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> STATIC_EQUALS_INVOCATION_MATCHER = Matchers.anyOf(Matchers.allOf(Matchers.staticMethod().onClass("java.util.Objects").named("equals").withParameters("java.lang.Object", "java.lang.Object"), Matchers.isSameType(Suppliers.BOOLEAN_TYPE)), Matchers.allOf(Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal").withParameters("java.lang.Object", "java.lang.Object"), Matchers.isSameType(Suppliers.BOOLEAN_TYPE)));
    private static final Matcher<MethodInvocationTree> INSTANCE_EQUALS_INVOCATION_MATCHER = Matchers.allOf(Matchers.instanceMethod().anyClass().named("equals").withParameters("java.lang.Object"), Matchers.isSameType(Suppliers.BOOLEAN_TYPE));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree invocationTree, final VisitorState state) {
        Type argumentType;
        Type receiverType;
        if (!STATIC_EQUALS_INVOCATION_MATCHER.matches(invocationTree, state) && !INSTANCE_EQUALS_INVOCATION_MATCHER.matches(invocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (STATIC_EQUALS_INVOCATION_MATCHER.matches(invocationTree, state)) {
            receiverType = ASTHelpers.getType(invocationTree.getArguments().get(0));
            argumentType = ASTHelpers.getType(invocationTree.getArguments().get(1));
        } else {
            receiverType = ASTHelpers.getReceiverType(invocationTree);
            argumentType = ASTHelpers.getType(invocationTree.getArguments().get(0));
        }
        if (ASTHelpers.isCastable(receiverType, argumentType, state)) {
            return Description.NO_MATCH;
        }
        final Types types = state.getTypes();
        Predicate<Symbol.MethodSymbol> equalsPredicate = new Predicate<Symbol.MethodSymbol>(){

            public boolean apply(Symbol.MethodSymbol methodSymbol) {
                return !methodSymbol.isStatic() && (methodSymbol.flags() & 0x1000L) == 0L && types.isSameType(methodSymbol.getReturnType(), state.getSymtab().booleanType) && ((List)methodSymbol.getParameters()).size() == 1 && types.isSameType(((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)0)).type, state.getSymtab().objectType);
            }
        };
        Name equalsName = state.getName("equals");
        Set<Symbol.MethodSymbol> overridesOfEquals = ASTHelpers.findMatchingMethods(equalsName, equalsPredicate, receiverType, types);
        Symbol.ClassSymbol argumentClass = (Symbol.ClassSymbol)argumentType.tsym;
        for (Symbol.MethodSymbol method : overridesOfEquals) {
            Symbol.ClassSymbol methodClass = method.enclClass();
            if (!argumentClass.isSubClass(methodClass, types) || methodClass.equals(state.getSymtab().objectType.tsym)) continue;
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(invocationTree);
        description.setMessage("Calling " + ASTHelpers.getSymbol(invocationTree).getSimpleName() + " on incompatible types " + receiverType + " and " + argumentType);
        return description.build();
    }
}

