/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.AnnotationType;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="MoreThanOneInjectableConstructor", summary="A class may not have more than one injectable constructor.", explanation="Having more than one injectable constructor will throw a runtime error in compliant JSR-330 frameworks such as Guice or Dagger", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectMoreThanOneInjectableConstructor
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    private static final Matcher<MethodTree> INJECTABLE_METHOD_MATCHER = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.Inject"), Matchers.hasAnnotation("javax.inject.Inject"));
    private static final AnnotationType JAVAX_INJECT_MATCHER = new AnnotationType("javax.inject.Inject");
    private static final AnnotationType GUICE_INJECT_MATCHER = new AnnotationType("com.google.inject.Inject");

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        int numberOfInjectableConstructors = 0;
        if (ASTHelpers.getSymbol(methodTree).isConstructor() && INJECTABLE_METHOD_MATCHER.matches(methodTree, state)) {
            for (Tree tree : ((ClassTree)state.getPath().getParentPath().getLeaf()).getMembers()) {
                if (!ASTHelpers.getSymbol(tree).isConstructor() || !INJECTABLE_METHOD_MATCHER.matches((MethodTree)tree, state)) continue;
                ++numberOfInjectableConstructors;
            }
        }
        return numberOfInjectableConstructors > 1 ? this.describe(methodTree, state) : Description.NO_MATCH;
    }

    public Description describe(MethodTree methodTree, VisitorState state) {
        for (AnnotationTree annotationTree : methodTree.getModifiers().getAnnotations()) {
            if (!JAVAX_INJECT_MATCHER.matches(annotationTree, state) && !GUICE_INJECT_MATCHER.matches(annotationTree, state)) continue;
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        throw new IllegalStateException("Expected to find more than once constructor annotated with @Inject");
    }
}

