/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.EditDistance;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="ModifyingCollectionWithItself", summary="Modifying a collection with itself", explanation="Modifying a collection with itself is almost never what is intended. collection.addAll(collection) and collection.retainAll(collection) are both no-ops, and collection.removeAll(collection) is equivalent to collection.clear().", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class ModifyingCollectionWithItself
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    @Override
    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        if (Matchers.allOf(Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("addAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("removeAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("containsAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("retainAll")), Matchers.receiverSameAsArgument(0)).matches(t, state)) {
            return this.describe(t, state);
        }
        return Description.NO_MATCH;
    }

    public Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        ExpressionTree lhs = ASTHelpers.getReceiver(methodInvocationTree);
        ExpressionTree rhs = methodInvocationTree.getArguments().get(0);
        Fix fix = SuggestedFix.delete(parent);
        if (Matchers.instanceMethod().anyClass().named("removeAll").matches(methodInvocationTree, state)) {
            fix = SuggestedFix.replace(methodInvocationTree, lhs + ".clear()");
        }
        if (lhs.getKind() == Tree.Kind.MEMBER_SELECT) {
            TreePath path;
            assert (rhs.getKind() == Tree.Kind.IDENTIFIER || rhs.getKind() == Tree.Kind.MEMBER_SELECT);
            String rhsName = null;
            if (rhs.getKind() == Tree.Kind.IDENTIFIER) {
                rhsName = ((JCTree.JCIdent)rhs).name.toString();
            } else if (rhs.getKind() == Tree.Kind.MEMBER_SELECT) {
                rhsName = ((JCTree.JCFieldAccess)rhs).name.toString();
            }
            for (path = state.getPath(); path != null && path.getLeaf().getKind() != Tree.Kind.METHOD; path = path.getParentPath()) {
            }
            JCTree.JCMethodDecl method = (JCTree.JCMethodDecl)path.getLeaf();
            int minEditDistance = Integer.MAX_VALUE;
            String replacement = null;
            for (JCTree.JCVariableDecl var : method.params) {
                int editDistance;
                if (!Matchers.variableType(Matchers.isSubtypeOf("java.util.Collection")).matches(var, state) || (editDistance = EditDistance.getEditDistance(rhsName, var.name.toString())) >= minEditDistance) continue;
                minEditDistance = editDistance;
                replacement = var.name.toString();
            }
            if (replacement != null) {
                fix = SuggestedFix.replace(rhs, replacement);
            }
        } else if (rhs.getKind() == Tree.Kind.IDENTIFIER) {
            TreePath path;
            assert (lhs.getKind() == Tree.Kind.IDENTIFIER);
            String lhsName = ((JCTree.JCIdent)rhs).name.toString();
            for (path = state.getPath(); path != null && path.getLeaf().getKind() != Tree.Kind.CLASS; path = path.getParentPath()) {
            }
            JCTree.JCClassDecl klass = (JCTree.JCClassDecl)path.getLeaf();
            int minEditDistance = Integer.MAX_VALUE;
            String replacement = null;
            for (JCTree member : klass.getMembers()) {
                int editDistance;
                if (member.getKind() != Tree.Kind.VARIABLE) continue;
                JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)member;
                if (Flags.isStatic(var.sym) || !Matchers.variableType(Matchers.isSubtypeOf("java.util.Collection")).matches(var, state) || (editDistance = EditDistance.getEditDistance(lhsName, var.name.toString())) >= minEditDistance) continue;
                minEditDistance = editDistance;
                replacement = var.name.toString();
            }
            if (replacement != null) {
                fix = SuggestedFix.replace(lhs, "this." + replacement);
            }
        }
        return this.describeMatch(methodInvocationTree, fix);
    }
}

