/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@BugPattern(name="NonRuntimeAnnotation", summary="Calling getAnnotation on an annotation that is not retained at runtime.", explanation="Calling getAnnotation on an annotation that does not have its Retention set to RetentionPolicy.RUNTIME will always return null.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class NonRuntimeAnnotation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!Matchers.instanceMethod().onDescendantOf("java.lang.Class").named("getAnnotation").matches(tree, state)) {
            return Description.NO_MATCH;
        }
        MemberSelectTree memTree = (MemberSelectTree)tree.getArguments().get(0);
        Symbol.TypeSymbol annotation = ASTHelpers.getSymbol((Tree)memTree.getExpression()).type.tsym;
        Retention retention = ASTHelpers.getAnnotation(annotation, Retention.class);
        if (retention != null && retention.value().equals((Object)RetentionPolicy.RUNTIME)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, SuggestedFix.replace(tree, "null"));
    }
}

