/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="NullablePrimitive", summary="@Nullable should not be used for primitive types since they cannot be null", explanation="Primitives can never be null.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class NullablePrimitive
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<Tree> IS_PRIMITIVE_TYPE_MATCHER = Matchers.isPrimitiveType();
    private static final Matcher<MethodTree> METHOD_RETURNS_NON_PRIMITIVE_TYPE_MATCHER = Matchers.methodReturnsNonPrimitiveType();

    @Override
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (!sym.name.contentEquals("Nullable")) {
            return Description.NO_MATCH;
        }
        Tree annotatedNode = NullablePrimitive.getAnnotatedNode(state);
        Symbol annotatedSymbol = ASTHelpers.getSymbol(annotatedNode);
        if (annotatedSymbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        if (IS_PRIMITIVE_TYPE_MATCHER.matches(annotatedNode, state)) {
            return this.describeMatch(tree, SuggestedFix.delete(tree));
        }
        if (annotatedNode instanceof MethodTree && !METHOD_RETURNS_NON_PRIMITIVE_TYPE_MATCHER.matches((MethodTree)annotatedNode, state)) {
            return this.describeMatch(tree, SuggestedFix.delete(tree));
        }
        return Description.NO_MATCH;
    }

    private static Tree getAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }
}

