/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(name="SelfEquals", summary="An object is tested for equality to itself", explanation="The arguments to this equal method are the same object, so it always returns true.  Either change the arguments to point to different objects or substitute true.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class SelfEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> guavaMatcher = Matchers.allOf(Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal"), Matchers.sameArgument(0, 1));
    private static final Matcher<MethodInvocationTree> equalsMatcher = Matchers.allOf(Matchers.instanceMethod().anyClass().named("equals"), Matchers.receiverSameAsArgument(0));
    private MatchState matchState = MatchState.NONE;
    private boolean checkGuava = true;
    private boolean checkEquals = false;

    public SelfEquals() {
    }

    public SelfEquals(boolean checkGuava, boolean checkEquals) {
        if (!checkGuava && !checkEquals) {
            throw new IllegalArgumentException("SelfEquals should check something");
        }
        this.checkGuava = checkGuava;
        this.checkEquals = checkEquals;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (this.checkGuava && guavaMatcher.matches(methodInvocationTree, state)) {
            this.matchState = MatchState.OBJECTS_EQUAL;
            return this.describe(methodInvocationTree, state);
        }
        if (this.checkEquals && equalsMatcher.matches(methodInvocationTree, state)) {
            this.matchState = MatchState.EQUALS;
            return this.describe(methodInvocationTree, state);
        }
        return Description.NO_MATCH;
    }

    /*
     * WARNING - void declaration
     */
    public Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (this.matchState == MatchState.NONE) {
            throw new IllegalStateException("describe() called without a match");
        }
        Fix fix = SuggestedFix.replace(methodInvocationTree, "true");
        if (this.matchState == MatchState.OBJECTS_EQUAL) {
            void var6_8;
            List<? extends ExpressionTree> args = methodInvocationTree.getArguments();
            block3: for (ExpressionTree expressionTree : args) {
                switch (expressionTree.getKind()) {
                    case IDENTIFIER: 
                    case MEMBER_SELECT: {
                        continue block3;
                    }
                }
                throw new IllegalStateException("Expected arg " + expressionTree + " to be a field access or " + "identifier");
            }
            ExpressionTree toReplace = args.get(1).getKind() == Tree.Kind.IDENTIFIER ? args.get(1) : (args.get(0).getKind() == Tree.Kind.IDENTIFIER ? args.get(0) : args.get(1));
            TreePath treePath = state.getPath();
            while (var6_8.getLeaf().getKind() != Tree.Kind.BLOCK) {
                TreePath treePath2 = var6_8.getParentPath();
            }
            JCTree.JCBlock block = (JCTree.JCBlock)var6_8.getLeaf();
            for (JCTree.JCStatement jcStatement : block.getStatements()) {
                if (jcStatement.getKind() != Tree.Kind.VARIABLE) continue;
                JCTree.JCVariableDecl declaration = (JCTree.JCVariableDecl)jcStatement;
                Symbol.TypeSymbol variableTypeSymbol = declaration.getType().type.tsym;
                if (!ASTHelpers.getSymbol(toReplace).isMemberOf(variableTypeSymbol, state.getTypes())) continue;
                if (toReplace.getKind() == Tree.Kind.IDENTIFIER) {
                    fix = SuggestedFix.prefixWith(toReplace, declaration.getName() + ".");
                    continue;
                }
                fix = SuggestedFix.replace(((JCTree.JCFieldAccess)toReplace).getExpression(), declaration.getName().toString());
            }
        }
        return this.describeMatch(methodInvocationTree, fix);
    }

    private static enum MatchState {
        NONE,
        OBJECTS_EQUAL,
        EQUALS;

    }
}

