/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.SynchronizedTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;

@BugPattern(name="SynchronizeOnNonFinalField", summary="Synchronizing on non-final fields is not safe: if the field is ever updated, different threads may end up locking on different objects.", explanation="Possible fixes:\n* If the field is already effectively final, add the missing 'final' modifier.\n* If the field needs to be mutable, create a separate lock by adding a private  final field and synchronizing on it to guard all accesses.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class SynchronizeOnNonFinalField
extends BugChecker
implements BugChecker.SynchronizedTreeMatcher {
    @Override
    public Description matchSynchronized(SynchronizedTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol(TreeInfo.skipParens((JCTree.JCExpression)tree.getExpression()));
        if (!(symbol instanceof Symbol.VarSymbol)) {
            return Description.NO_MATCH;
        }
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
        if (varSymbol.isLocal() || varSymbol.isStatic() || (varSymbol.flags() & 0x10L) != 0L) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree.getExpression());
    }
}

