/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;

public class DatastoreMatchers {
    public static final String QUERY = "com.google.appengine.api.datastore.Query";
    public static final String ENTITY = "com.google.appengine.api.datastore.Entity";
    public static final Matcher<Tree> hasSetKeysOnlyMethodCall = Matchers.contains(Matchers.toType(ExpressionTree.class, Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Query").named("setKeysOnly")));
    private static final Matcher<ExpressionTree> queryExpr = Matchers.isSameType("com.google.appengine.api.datastore.Query");
    private static final Matcher<ExpressionTree> entityExpr = Matchers.isSameType("com.google.appengine.api.datastore.Entity");
    private static final Matcher<ExpressionTree> anyInstanceMethodOnEntity = Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").withAnyName();
    private static final Matcher<Tree> hasInstanceMethodCallOnEntity = Matchers.contains(Matchers.toType(ExpressionTree.class, anyInstanceMethodOnEntity));
    private static final Matcher<VariableTree> queryVar = Matchers.isSameType("com.google.appengine.api.datastore.Query");
    private static final Matcher<VariableTree> entityVar = Matchers.isSameType("com.google.appengine.api.datastore.Entity");
    private static final Matcher<VariableTree> iterableVar = Matchers.isSubtypeOf("java.lang.Iterable");
    private static final Matcher<MethodTree> hasParamOfTypeQueryEntityOrIterable = Matchers.methodHasParameters(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(queryVar, entityVar, iterableVar));
    private static final Matcher<ExpressionTree> prepareQuery = Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.DatastoreService").named("prepare");
    private static final Matcher<Tree> hasPrepareMethodCallOnDatastoreService = Matchers.contains(Matchers.toType(ExpressionTree.class, prepareQuery));
    private static final MultiMatcher<MethodInvocationTree, ExpressionTree> queryArg = Matchers.hasArguments(ChildMultiMatcher.MatchType.AT_LEAST_ONE, queryExpr);
    private static final Matcher<MethodInvocationTree> queryArgButNotPrepare = Matchers.allOf(queryArg, Matchers.not(prepareQuery));
    private static final Matcher<Tree> hasMethodCallOtherThanPrepareThatTakesQueryType = Matchers.contains(Matchers.toType(MethodInvocationTree.class, queryArgButNotPrepare));
    private static final MultiMatcher<MethodInvocationTree, ExpressionTree> entityArg = Matchers.hasArguments(ChildMultiMatcher.MatchType.AT_LEAST_ONE, entityExpr);
    private static final Matcher<Tree> hasMethodCallThatTakesEntityType = Matchers.contains(Matchers.toType(MethodInvocationTree.class, entityArg));
    private static final Matcher<ExpressionTree> onlyNeedKey = Matchers.anyOf(Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("clone"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("equals"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("getAppId"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("getAppIdNamespace"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("getKey"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("getKind"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("getNamespace"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("getParent"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("hashCode"), Matchers.instanceMethod().onExactClass("com.google.appengine.api.datastore.Entity").named("toString"));
    public static final Matcher<Tree> hasEntityMethodsThatNeedMoreThanKeys = Matchers.contains(Matchers.toType(ExpressionTree.class, Matchers.allOf(Matchers.not(onlyNeedKey), anyInstanceMethodOnEntity)));
    private static final Matcher<ExpressionTree> hasEntityTypeArgument = new Matcher<ExpressionTree>(){

        @Override
        public boolean matches(ExpressionTree tree, VisitorState state) {
            Type treeType = ASTHelpers.getType(tree);
            if (treeType == null) {
                return false;
            }
            List<Type> typeArgs = treeType.getTypeArguments();
            if (typeArgs == null || typeArgs.size() != 1) {
                return false;
            }
            return ((Type)typeArgs.get(0)).toString().equals(DatastoreMatchers.ENTITY);
        }
    };
    private static final Matcher<MethodInvocationTree> hasArgOfTypeIterableEntity = Matchers.hasArguments(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.allOf(Matchers.isSubtypeOf("java.lang.Iterable"), hasEntityTypeArgument));
    private static final Matcher<Tree> hasMethodCallWithArgOfTypeIterableEntity = Matchers.contains(Matchers.toType(MethodInvocationTree.class, hasArgOfTypeIterableEntity));
    public static final Matcher<MethodTree> baseMatcher = Matchers.allOf(hasPrepareMethodCallOnDatastoreService, hasInstanceMethodCallOnEntity, Matchers.not(hasParamOfTypeQueryEntityOrIterable), Matchers.not(hasMethodCallThatTakesEntityType), Matchers.not(hasMethodCallWithArgOfTypeIterableEntity), Matchers.not(hasMethodCallOtherThanPrepareThatTakesQueryType));
}

