/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Optional;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.AbstractChainedMatcher;
import com.google.errorprone.matchers.method.AbstractSimpleMatcher;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.matchers.method.ParameterMatcherImpl;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.regex.Pattern;

public abstract class MethodNameMatcherImpl
extends AbstractChainedMatcher<MatchState, MatchState>
implements MethodMatchers.MethodNameMatcher {
    MethodNameMatcherImpl(AbstractSimpleMatcher<MatchState> baseMatcher) {
        super(baseMatcher);
    }

    @Override
    public MethodMatchers.ParameterMatcher withParameters(String ... parameters) {
        return this.withParameters(Arrays.asList(parameters));
    }

    @Override
    public MethodMatchers.ParameterMatcher withParameters(Iterable<String> parameters) {
        return new ParameterMatcherImpl((AbstractSimpleMatcher<MatchState>)this, parameters);
    }

    static class Regex
    extends MethodNameMatcherImpl {
        private final Pattern regex;

        Regex(AbstractSimpleMatcher<MatchState> baseMatcher, Pattern regex) {
            super(baseMatcher);
            this.regex = regex;
        }

        @Override
        protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
            if (!this.regex.matcher(((Name)method.sym().getSimpleName()).toString()).matches()) {
                return Optional.absent();
            }
            return Optional.of((Object)method);
        }
    }

    static class Any
    extends MethodNameMatcherImpl {
        Any(AbstractSimpleMatcher<MatchState> baseMatcher) {
            super(baseMatcher);
        }

        @Override
        protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
            return Optional.of((Object)method);
        }
    }

    static class Exact
    extends MethodNameMatcherImpl {
        private final String name;

        Exact(AbstractSimpleMatcher<MatchState> baseMatcher, String name) {
            super(baseMatcher);
            this.name = name;
        }

        @Override
        protected Optional<MatchState> matchResult(ExpressionTree item, MatchState method, VisitorState state) {
            if (!((Name)method.sym().getSimpleName()).toString().equals(this.name)) {
                return Optional.absent();
            }
            return Optional.of((Object)method);
        }
    }
}

