/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.errorprone.VisitorState;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

public class ASTHelpers {
    private static final CharMatcher WHITESPACE_CHARS = CharMatcher.anyOf((CharSequence)" \t\f\n\r");

    public static boolean sameVariable(ExpressionTree expr1, ExpressionTree expr2) {
        if (expr1.getKind() != Tree.Kind.IDENTIFIER && expr1.getKind() != Tree.Kind.MEMBER_SELECT || expr2.getKind() != Tree.Kind.IDENTIFIER && expr2.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        Symbol sym1 = ASTHelpers.getSymbol(expr1);
        Symbol sym2 = ASTHelpers.getSymbol(expr2);
        if (sym1 == null) {
            throw new IllegalStateException("Couldn't get symbol for " + expr1);
        }
        if (sym2 == null) {
            throw new IllegalStateException("Couldn't get symbol for " + expr2);
        }
        if (expr1.getKind() == Tree.Kind.IDENTIFIER && expr2.getKind() == Tree.Kind.IDENTIFIER) {
            return sym1.equals(sym2);
        }
        if (expr1.getKind() == Tree.Kind.MEMBER_SELECT && expr2.getKind() == Tree.Kind.MEMBER_SELECT) {
            return sym1.equals(sym2) && ASTHelpers.sameVariable(((JCTree.JCFieldAccess)expr1).selected, ((JCTree.JCFieldAccess)expr2).selected);
        }
        JCTree.JCExpression selected = null;
        selected = expr1.getKind() == Tree.Kind.IDENTIFIER ? ((JCTree.JCFieldAccess)expr2).selected : ((JCTree.JCFieldAccess)expr1).selected;
        return ((Object)selected).toString().equals("this") && sym1.equals(sym2);
    }

    public static Symbol getSymbol(Tree tree) {
        if (tree instanceof ClassTree) {
            return ASTHelpers.getSymbol((ClassTree)tree);
        }
        if (tree instanceof MethodTree) {
            return ASTHelpers.getSymbol((MethodTree)tree);
        }
        if (tree instanceof VariableTree) {
            return ASTHelpers.getSymbol((VariableTree)tree);
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)tree).sym;
        }
        if (tree instanceof JCTree.JCIdent) {
            return ((JCTree.JCIdent)tree).sym;
        }
        if (tree instanceof JCTree.JCMethodInvocation) {
            return ASTHelpers.getSymbol((MethodInvocationTree)tree);
        }
        if (tree instanceof JCTree.JCNewClass) {
            return ((JCTree.JCNewClass)tree).constructor;
        }
        if (tree instanceof AnnotationTree) {
            return ASTHelpers.getSymbol(((AnnotationTree)tree).getAnnotationType());
        }
        if (tree instanceof PackageTree) {
            return ASTHelpers.getSymbol((PackageTree)tree);
        }
        return null;
    }

    public static Symbol.ClassSymbol getSymbol(ClassTree tree) {
        return ((JCTree.JCClassDecl)tree).sym;
    }

    public static Symbol.PackageSymbol getSymbol(PackageTree tree) {
        return ((JCTree.JCPackageDecl)tree).packge;
    }

    public static Symbol.MethodSymbol getSymbol(MethodTree tree) {
        return ((JCTree.JCMethodDecl)tree).sym;
    }

    public static Symbol.VarSymbol getSymbol(VariableTree tree) {
        return ((JCTree.JCVariableDecl)tree).sym;
    }

    public static Symbol.MethodSymbol getSymbol(MethodInvocationTree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree.getMethodSelect());
        if (!(sym instanceof Symbol.MethodSymbol)) {
            return null;
        }
        return (Symbol.MethodSymbol)sym;
    }

    public static <T> TreePath findPathFromEnclosingNodeToTopLevel(TreePath path, Class<T> klass) {
        while (path != null && !klass.isInstance(path.getLeaf())) {
            path = path.getParentPath();
        }
        return path;
    }

    public static <T> T findEnclosingNode(TreePath path, Class<T> klass) {
        return (path = ASTHelpers.findPathFromEnclosingNodeToTopLevel(path, klass)) == null ? null : (T)klass.cast(path.getLeaf());
    }

    public static ExpressionTree getRootAssignable(MethodInvocationTree methodInvocationTree) {
        if (!(methodInvocationTree instanceof JCTree.JCMethodInvocation)) {
            throw new IllegalArgumentException("Expected type to be JCMethodInvocation, but was " + methodInvocationTree.getClass());
        }
        if (((JCTree.JCMethodInvocation)methodInvocationTree).getMethodSelect() instanceof JCTree.JCIdent) {
            return null;
        }
        ExpressionTree expr = methodInvocationTree;
        while (expr instanceof JCTree.JCMethodInvocation) {
            if (!((expr = ((JCTree.JCMethodInvocation)expr).getMethodSelect()) instanceof JCTree.JCFieldAccess)) continue;
            expr = ((JCTree.JCFieldAccess)expr).getExpression();
        }
        Symbol sym = ASTHelpers.getSymbol(expr);
        if (sym instanceof Symbol.VarSymbol) {
            return expr;
        }
        return null;
    }

    public static Type getReturnType(ExpressionTree expressionTree) {
        if (expressionTree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess methodCall = (JCTree.JCFieldAccess)expressionTree;
            return methodCall.type.getReturnType();
        }
        if (expressionTree instanceof JCTree.JCIdent) {
            JCTree.JCIdent methodCall = (JCTree.JCIdent)expressionTree;
            return methodCall.type.getReturnType();
        }
        if (expressionTree instanceof JCTree.JCMethodInvocation) {
            return ASTHelpers.getReturnType(((JCTree.JCMethodInvocation)expressionTree).getMethodSelect());
        }
        throw new IllegalArgumentException("Expected a JCFieldAccess or JCIdent");
    }

    public static Type getReceiverType(ExpressionTree expressionTree) {
        if (expressionTree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess methodSelectFieldAccess = (JCTree.JCFieldAccess)expressionTree;
            return methodSelectFieldAccess.selected.type;
        }
        if (expressionTree instanceof JCTree.JCIdent) {
            JCTree.JCIdent methodCall = (JCTree.JCIdent)expressionTree;
            return methodCall.sym.owner.type;
        }
        if (expressionTree instanceof JCTree.JCMethodInvocation) {
            return ASTHelpers.getReceiverType(((JCTree.JCMethodInvocation)expressionTree).getMethodSelect());
        }
        throw new IllegalArgumentException("Expected a JCFieldAccess or JCIdent from expression " + expressionTree);
    }

    public static ExpressionTree getReceiver(ExpressionTree expressionTree) {
        if (expressionTree instanceof MethodInvocationTree) {
            return ASTHelpers.getReceiver(((MethodInvocationTree)expressionTree).getMethodSelect());
        }
        if (expressionTree instanceof MemberSelectTree) {
            return ((MemberSelectTree)expressionTree).getExpression();
        }
        throw new IllegalStateException(String.format("Expected expression '%s' to be a method invocation or field access, but was %s", new Object[]{expressionTree, expressionTree.getKind()}));
    }

    public static List<ExpressionTree> matchBinaryTree(BinaryTree tree, List<Matcher<ExpressionTree>> matchers, VisitorState state) {
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        if (matchers.get(0).matches(leftOperand, state) && matchers.get(1).matches(rightOperand, state)) {
            return Arrays.asList(leftOperand, rightOperand);
        }
        if (matchers.get(0).matches(rightOperand, state) && matchers.get(1).matches(leftOperand, state)) {
            return Arrays.asList(rightOperand, leftOperand);
        }
        return null;
    }

    public static int getActualStartPosition(JCTree.JCLiteral tree, CharSequence source) {
        Object value = tree.getValue();
        if (value instanceof Number && ((Number)value).doubleValue() < 0.0) {
            int start = tree.getStartPosition() - 1;
            while (WHITESPACE_CHARS.matches(source.charAt(start))) {
                --start;
            }
            if (source.charAt(start) == '-') {
                return start;
            }
        }
        return tree.getStartPosition();
    }

    public static Set<Symbol.MethodSymbol> findSuperMethods(Symbol.MethodSymbol methodSymbol, Types types) {
        HashSet<Symbol.MethodSymbol> supers = new HashSet<Symbol.MethodSymbol>();
        if (methodSymbol.isStatic()) {
            return supers;
        }
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)methodSymbol.owner;
        for (Type sup : types.closure(owner.type)) {
            if (sup == owner.type) continue;
            Scope.WriteableScope scope = sup.tsym.members();
            for (Symbol sym : scope.getSymbolsByName(methodSymbol.name)) {
                if (sym == null || sym.isStatic() || (sym.flags() & 0x1000L) != 0L || !sym.name.contentEquals(methodSymbol.name) || !methodSymbol.overrides(sym, owner, types, true)) continue;
                supers.add((Symbol.MethodSymbol)sym);
            }
        }
        return supers;
    }

    public static Set<Symbol.MethodSymbol> findMatchingMethods(Name name, final Predicate<Symbol.MethodSymbol> predicate, Type startClass, Types types) {
        Filter<Symbol> filter = new Filter<Symbol>(){

            public boolean accepts(Symbol symbol) {
                if (!(symbol instanceof Symbol.MethodSymbol)) {
                    return false;
                }
                return predicate.apply((Object)((Symbol.MethodSymbol)symbol));
            }
        };
        HashSet<Symbol.MethodSymbol> matchingMethods = new HashSet<Symbol.MethodSymbol>();
        for (Type superClass : types.closure(startClass)) {
            Symbol.TypeSymbol superClassSymbol = superClass.tsym;
            for (Symbol symbol : superClassSymbol.members().getSymbolsByName(name, (Filter)filter, Scope.LookupKind.NON_RECURSIVE)) {
                matchingMethods.add((Symbol.MethodSymbol)symbol);
            }
        }
        return matchingMethods;
    }

    public static Symbol.MethodSymbol findSuperMethod(Symbol.MethodSymbol method, Types types) {
        Symbol.TypeSymbol superClass = method.enclClass().getSuperclass().tsym;
        if (superClass == null) {
            return null;
        }
        for (Symbol sym : superClass.members().getSymbols()) {
            if (!sym.name.contentEquals(method.name) || !method.overrides(sym, superClass, types, true)) continue;
            return (Symbol.MethodSymbol)sym;
        }
        return null;
    }

    public static boolean hasAnnotation(Symbol sym, String annotationType, VisitorState state) {
        Symbol annotationSym = state.getSymbolFromString(annotationType);
        Symbol.TypeSymbol inheritedSym = state.getSymtab().inheritedType.tsym;
        if (sym == null || annotationSym == null) {
            return false;
        }
        if (sym instanceof Symbol.ClassSymbol && annotationSym.attribute(inheritedSym) != null) {
            while (sym != null) {
                if (sym.attribute(annotationSym) != null) {
                    return true;
                }
                sym = ((Symbol.ClassSymbol)sym).getSuperclass().tsym;
            }
            return false;
        }
        return sym.attribute(annotationSym) != null;
    }

    public static boolean hasAnnotation(Symbol sym, Class<? extends Annotation> annotationType) {
        return ASTHelpers.getAnnotation(sym, annotationType) != null;
    }

    public static boolean hasAnnotation(Tree tree, Class<? extends Annotation> annotationType) {
        return ASTHelpers.getAnnotation(tree, annotationType) != null;
    }

    public static <T extends Annotation> T getAnnotation(Tree tree, Class<T> annotationType) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym == null ? null : (T)ASTHelpers.getAnnotation(sym, annotationType);
    }

    public static <T extends Annotation> T getAnnotation(Symbol sym, Class<T> annotationType) {
        return sym == null ? null : (T)sym.getAnnotation(annotationType);
    }

    public static LinkedHashSet<String> enumValues(Symbol.TypeSymbol enumType) {
        if (enumType.getKind() != ElementKind.ENUM) {
            throw new IllegalStateException();
        }
        Scope.WriteableScope scope = enumType.members();
        ArrayDeque<String> values = new ArrayDeque<String>();
        for (Symbol sym : scope.getSymbols()) {
            Symbol.VarSymbol var;
            if (!(sym instanceof Symbol.VarSymbol) || ((var = (Symbol.VarSymbol)sym).flags() & 0x4000L) == 0L) continue;
            values.push(sym.name.toString());
        }
        return new LinkedHashSet<String>(values);
    }

    public static boolean isGeneratedConstructor(MethodTree tree) {
        if (!(tree instanceof JCTree.JCMethodDecl)) {
            return false;
        }
        return (((JCTree.JCMethodDecl)tree).mods.flags & 0x1000000000L) == 0x1000000000L;
    }

    public static Type getType(Tree tree) {
        if (tree instanceof JCTree) {
            return ((JCTree)tree).type;
        }
        return null;
    }

    public static Type.ClassType getType(ClassTree tree) {
        if (!(tree instanceof JCTree.JCClassDecl)) {
            return null;
        }
        Type type = ((JCTree.JCClassDecl)tree).type;
        if (!(type instanceof Type.ClassType)) {
            return null;
        }
        return (Type.ClassType)type;
    }

    public static String getAnnotationName(AnnotationTree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym == null ? null : sym.name.toString();
    }

    private static <T extends Symbol> T enclosingSymbol(Symbol sym, Class<T> clazz) {
        while (sym != null) {
            if (clazz.isInstance(sym)) {
                return (T)((Symbol)clazz.cast(sym));
            }
            sym = sym.owner;
        }
        return null;
    }

    public static Symbol.ClassSymbol enclosingClass(Symbol sym) {
        return ASTHelpers.enclosingSymbol(sym, Symbol.ClassSymbol.class);
    }

    public static Symbol.PackageSymbol enclosingPackage(Symbol sym) {
        return ASTHelpers.enclosingSymbol(sym, Symbol.PackageSymbol.class);
    }

    public static Nullness getNullnessValue(ExpressionTree expr, VisitorState state, NullnessAnalysis nullnessAnalysis) {
        TreePath pathToExpr = new TreePath(state.getPath(), expr);
        return nullnessAnalysis.getNullness(pathToExpr, state.context);
    }

    public static Object constValue(JCTree tree) {
        return tree instanceof JCTree.JCLiteral ? ((JCTree.JCLiteral)tree).value : tree.type.constValue();
    }

    public static boolean isVoidType(Type type, VisitorState state) {
        if (type == null) {
            return false;
        }
        return type.getKind() == TypeKind.VOID || state.getTypes().isSameType(Suppliers.JAVA_LANG_VOID_TYPE.get(state), type);
    }

    public static boolean isSubtype(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isSubtype(types.erasure(s), types.erasure(t));
    }

    public static boolean isCastable(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isCastable(types.erasure(s), types.erasure(t));
    }

    public static boolean isSameType(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isSameType(types.erasure(s), types.erasure(t));
    }

    @Nullable
    public static ModifiersTree getModifiers(Tree tree) {
        if (tree instanceof ClassTree) {
            return ((ClassTree)tree).getModifiers();
        }
        if (tree instanceof MethodTree) {
            return ((MethodTree)tree).getModifiers();
        }
        if (tree instanceof VariableTree) {
            return ((VariableTree)tree).getModifiers();
        }
        return null;
    }

    public static Type getUpperBound(Type type, Types types) {
        if (type.hasTag(TypeTag.WILDCARD)) {
            return types.wildUpperBound(type);
        }
        if (type.hasTag(TypeTag.TYPEVAR) && ((Type.TypeVar)type).isCaptured()) {
            return types.cvarUpperBound(type);
        }
        if (type.getUpperBound() != null) {
            return type.getUpperBound();
        }
        return type;
    }
}

