/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.DnsNameResolver;
import io.grpc.NameResolver;
import java.net.URI;

public final class DnsNameResolverFactory
extends NameResolver.Factory {
    private static final String SCHEME = "dns";
    private static final DnsNameResolverFactory instance = new DnsNameResolverFactory();

    @Override
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object[])new Object[]{targetPath, targetUri});
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, params);
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    private DnsNameResolverFactory() {
    }

    public static DnsNameResolverFactory getInstance() {
        return instance;
    }
}

