/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.DnsNameResolverFactory;
import io.grpc.NameResolver;
import java.net.URI;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class NameResolverRegistry
extends NameResolver.Factory {
    private static final NameResolverRegistry defaultRegistry = new NameResolverRegistry(DnsNameResolverFactory.getInstance());
    private final CopyOnWriteArrayList<NameResolver.Factory> registry = new CopyOnWriteArrayList();
    private final String defaultScheme;

    public static NameResolverRegistry getDefaultRegistry() {
        return defaultRegistry;
    }

    private NameResolverRegistry(NameResolver.Factory defaultResolverFactory) {
        this.register(defaultResolverFactory);
        this.defaultScheme = (String)Preconditions.checkNotNull((Object)defaultResolverFactory.getDefaultScheme(), (Object)"defaultScheme");
    }

    public void register(NameResolver.Factory factory) {
        this.registry.add(0, factory);
    }

    @Override
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        for (NameResolver.Factory factory : this.registry) {
            NameResolver resolver = factory.newNameResolver(targetUri, params);
            if (resolver == null) continue;
            return resolver;
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return this.defaultScheme;
    }
}

