/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BlankFutureProvider<T> {
    private Set<SettableFuture<T>> blankFutures = BlankFutureProvider.createSet();

    @VisibleForTesting
    Set<SettableFuture<T>> getBlankFutureSet() {
        return this.blankFutures;
    }

    public ListenableFuture<T> newBlankFuture() {
        final SettableFuture future = SettableFuture.create();
        this.blankFutures.add(future);
        final Set<SettableFuture<T>> savedSet = this.blankFutures;
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<T>(){

            public void onFailure(Throwable t) {
                if (t instanceof CancellationException) {
                    savedSet.remove(future);
                }
            }

            public void onSuccess(T result) {
            }
        });
        return future;
    }

    public FulfillmentBatch<T> createFulfillmentBatch() {
        Set<SettableFuture<T>> blankFuturesCopy = this.blankFutures;
        this.blankFutures = BlankFutureProvider.createSet();
        return new FulfillmentBatch(blankFuturesCopy);
    }

    private static <T> Set<SettableFuture<T>> createSet() {
        return Collections.synchronizedSet(new LinkedHashSet());
    }

    public static final class FulfillmentBatch<T> {
        private final Set<SettableFuture<T>> futures;

        private FulfillmentBatch(Set<SettableFuture<T>> futures) {
            this.futures = (Set)Preconditions.checkNotNull(futures, (Object)"futures");
        }

        public void link(Supplier<ListenableFuture<T>> source) {
            for (final SettableFuture<T> future : this.copyFutureList()) {
                ListenableFuture sourceFuture = (ListenableFuture)source.get();
                Futures.addCallback((ListenableFuture)sourceFuture, (FutureCallback)new FutureCallback<T>(){

                    public void onSuccess(T result) {
                        future.set(result);
                    }

                    public void onFailure(Throwable t) {
                        future.setException(t);
                    }
                });
            }
        }

        public void fail(Throwable error) {
            for (SettableFuture<T> future : this.copyFutureList()) {
                future.setException(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<SettableFuture<T>> copyFutureList() {
            Set<SettableFuture<T>> set = this.futures;
            synchronized (set) {
                return new ArrayList<SettableFuture<T>>(this.futures);
            }
        }
    }
}

