---
layout: posts
title: Bazel 0.2.0 Released
---

We are delighted to announce the
[0.2.0 release](https://github.com/bazelbuild/bazel/releases/tag/0.2.0) of
Bazel. This release marks major improvements in support for external
repositories, Skylark and testing, in particular how external repositories and
Skylark can work together.

## Improvements from our [roadmap](http://bazel.io/roadmap.html)

### Skylark rules can now be loaded from remote repositories

Skylark rules can now be loaded from a remote repository.  For example, to use
the Scala rules, add the following to your WORKSPACE file:

```python
git_repository(
    name = "io_bazel_rules_scala",
    remote = "https://github.com/bazelbuild/rules_scala.git",
    tag = "0.0.1",
)
load("@io_bazel_rules_scala//scala:scala.bzl", "scala_repositories")
scala_repositories()
```

This will download all of the tools the rules need to build Scala programs.

Then load and use normally from your BUILD files:

```python
load("@io_bazel_rules_scala//scala:scala.bzl", "scala_library")
scala_library(...)
```

We will gradually move the existing rules to their own repositories, announcing
changes on the [mailing
list](https://groups.google.com/forum/#!forum/bazel-discuss).

### Go build and test support

There is now Go language support, see [the
documentation](http://bazel.io/docs/be/go.html) for details.

### Open sourcing tests

We also open sourced over a
[hundred](https://github.com/bazelbuild/bazel/tree/master/src/test/java/com/google/devtools)
[tests](https://github.com/bazelbuild/bazel/tree/master/src/test/shell/integration)
and laid the foundation for open sourcing more. We will continue to open source
more tests (both to increase Bazel's stability and to make contributing easier),
but this marks a dramatic increase in test coverage.

## Other major changes since 0.1.0

* The `--package_path` definition in `.bazelrc` is no longer required, nor is
  the `base_workspace/` directory.
* JUnit test runner for Java tests - Use the `--nolegacy_bazel_java_test` flag
  (soon to be the default) to get XML output for easy integration into CI
  systems and easier debugging with `--java_debug`.
* Skylark macros can now be loaded and used in the WORKSPACE file.
* Remote repository filesystem changes are tracked.
* [Debian](https://github.com/bazelbuild/bazel/releases/latest/) packages and a
  [Homebrew](http://braumeister.org/formula/bazel) recipe.

For changes since 0.1.5 (the minor version before 0.2.0), see the release notes
for changes.

## Future plans

Looking ahead to 0.3.0:

* Windows support is coming!  (See the [Windows
  label](https://github.com/bazelbuild/bazel/labels/Windows) to follow the
  progress there).
* Remote caching and execution is in progress (see [Alpha Lam's
  work](https://docs.google.com/document/d/1CvEw3uu9mUszK-ukmSWp4Dmy43KDlHAjW75Gf17bUY8/preview)).
* XCode integration and generic IDE support.
* [Ulf](https://github.com/ulfjack) has been working on [sandboxing for OS
  X](https://github.com/bazelbuild/bazel/tree/osx-sandbox-hardlinks), which will
  hopefully be available soon.
* More work on parallelization. We currently have experimental support (which
  can be enabled with the `--experimental_interleave_loading_and_analysis` flag)
  which improves clean build time (~30% faster loading and analysis), especially
  for builds using a lot of `select()` expressions.

## Finally...

A big thank you to our community for your continued support.  Particular
shout-outs to the following contributors:

* [Brian Silverman](https://github.com/bsilver8192) - for tons of important bug
  fixes and answering lots of user questions.
* [Alpha Lam](https://github.com/hhclam) - for writing up design docs and
  implementing remote caching/execution.
* [P. Oscar Boykin](https://github.com/posco) - for putting tons of time and
  effort into the Scala rules, as well as being a tireless supporter on Twitter.

Thank you all, keep the discussion and bug reports coming!
