<?php
/*
    This file is part of the eQual framework <http://www.github.com/equalframework/equal>
    Some Rights Reserved, Cedric Francoys, 2010-2024
    Licensed under GNU GPL 3 license <http://www.gnu.org/licenses/>
*/
$params = eQual::announce([
    'description'   => 'Checks current installation directories integrity, create mandatory folders, and attempts to assign permissions.',
    'params'        => [],
    'constants'     => ['FILE_STORAGE_MODE', 'HTTP_PROCESS_USERNAME'],
    'access'        => [
        'visibility'    => 'protected',
        'groups'        => ['admins']
    ]
]);

// array holding files and directories to be tested
$paths = [
    [
        'rights'    =>  EQ_R_READ | EQ_R_WRITE,
        'path'      =>  QN_LOG_STORAGE_DIR
    ],
    [
        'rights'    =>  EQ_R_READ | EQ_R_WRITE,
        'path'      =>  EQ_BASEDIR.'/cache'
    ],
    [
        'rights'    =>  EQ_R_READ | EQ_R_WRITE,
        'path'      =>  EQ_BASEDIR.'/bin'
    ],
    [
        'rights'    =>  EQ_R_READ | EQ_R_WRITE,
        'path'      =>  EQ_BASEDIR.'/spool'
    ],
    [
        'rights'    =>  EQ_R_READ,
        'path'      =>  EQ_BASEDIR.'/lib'
    ],
    [
        'rights'    =>  EQ_R_READ,
        'path'      =>  EQ_BASEDIR.'/config'
    ],
    [
        'rights'    =>  EQ_R_READ,
        'path'      =>  EQ_BASEDIR.'/config/routing'
    ]
];

if(constant('FILE_STORAGE_MODE') == 'FS') {
    $paths[] = [
        'rights'    =>  EQ_R_READ | EQ_R_WRITE,
        'path'      =>  EQ_BASEDIR.'/bin'
    ];
}

$uid = 0;

$username = constant('HTTP_PROCESS_USERNAME');

// get UID of a user by its name
$output = [];
$result_code = 0;
exec("id -u \"$username\" 2>&1", $output, $result_code);

if($result_code !== 0 && PHP_OS_FAMILY != 'Windows') {
    throw new Exception(serialize(['uid_unavailable' => implode("\n", $output)]), EQ_ERROR_UNKNOWN);
}

$output = (array) $output;

if(count($output)) {
    $uid = intval(reset($output));
}

if(!$uid && PHP_OS_FAMILY != 'Windows') {
    throw new Exception(serialize(['unknown_user' => $username]), EQ_ERROR_INVALID_CONFIG);
}

// set mod
foreach($paths as $item) {

    ['path' => $path, 'rights' => $mask] = $item;

    if(!file_exists($path) && ($mask & EQ_R_WRITE)) {
        if(!mkdir($path, 0754, true)) {
            throw new Exception(serialize(['folder_creation_error' => "unable to create $path"]), EQ_ERROR_UNKNOWN);
        }
    }

    if(!file_exists($path)) {
        throw new Exception(serialize(['missing_mandatory_folder' => "$path not found"]), EQ_ERROR_UNKNOWN);
    }

    chgrp($path, $uid);

    $perms = fileperms($path);

    if($mask & EQ_R_READ) {
        $perms |= 0040;
    }

    if($mask & EQ_R_WRITE) {
        $perms |= 0020;
    }

    chmod($path, $perms);
}

// no error, exit code will be 0