var eQ;
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./build/ApiService.js":
/*!*****************************!*\
  !*** ./build/ApiService.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var jQuery = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports._ApiService = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _jqueryLib = __webpack_require__(/*! ./jquery-lib */ "./build/jquery-lib.js");

var _equalServices = __webpack_require__(/*! ./equal-services */ "./build/equal-services.js");

/**
 * This service acts as an interface between client and server and caches view objects to lower the traffic
 * Contents that can be cached are :
 * - Views
 * - Menus
 * - Translations
 * - Schemas
 */
var _ApiService = /*#__PURE__*/function () {
  /**
   * Internal objects for cache management
   * These are Map objects for storing promises of requests
   */
  function _ApiService() {
    (0, _classCallCheck2.default)(this, _ApiService);
    (0, _defineProperty2.default)(this, "views", void 0);
    (0, _defineProperty2.default)(this, "translations", void 0);
    (0, _defineProperty2.default)(this, "schemas", void 0);
    (0, _defineProperty2.default)(this, "last_count", void 0);
    (0, _defineProperty2.default)(this, "last_status", void 0);
    (0, _defineProperty2.default)(this, "last_headers", void 0);

    _jqueryLib.$.ajaxSetup({
      cache: true,
      // allow brower to cache the responses
      beforeSend: function beforeSend(xhr) {
        /*
        // #removed for XSS protection (we use httpOnly cookie instead)
        let access_token = this.getCookie('access_token');
        if(access_token) {
            xhr.setRequestHeader('Authorization', "Basic " + access_token);
        }
        */
      },
      xhrFields: {
        withCredentials: true
      }
    });

    this.views = {};
    this.translations = {};
    this.schemas = {};
    this.last_count = 0;
    this.last_status = 0;
    this.last_headers = {};
  }
  /**
   * ObjectManager methods
   */


  (0, _createClass2.default)(_ApiService, [{
    key: "getPackageName",
    value: function getPackageName(entity) {
      return entity.substr(0, entity.indexOf('\\'));
    }
  }, {
    key: "getClassName",
    value: function getClassName(entity) {
      return entity.substr(entity.indexOf('\\') + 1);
    }
    /**
     * schemas methods
     */

  }, {
    key: "loadSchema",
    value: function loadSchema(entity) {
      var _this = this;

      var package_name = this.getPackageName(entity);
      var class_name = this.getClassName(entity);

      if (typeof this.schemas[package_name] == 'undefined' || typeof this.schemas[package_name][class_name] == 'undefined') {
        if (typeof this.schemas[package_name] == 'undefined') {
          this.schemas[package_name] = {};
        }

        this.schemas[package_name][class_name] = _jqueryLib.$.Deferred();

        _equalServices.EnvService.getEnv().then(function (environment) {
          _jqueryLib.$.get({
            url: environment.backend_url + '/?get=model_schema&entity=' + entity
          }).then(function (json_data) {
            _this.schemas[package_name][class_name].resolve(json_data);
          }).catch(function (response) {
            console.debug('ApiService::loadSchema error', response.responseJSON);

            _this.schemas[package_name][class_name].resolve({});
          });
        });
      }

      return this.schemas[package_name][class_name];
    } // the view_id matches the following convention : view_type.view_name

  }, {
    key: "loadView",
    value: function loadView(entity, view_id) {
      var _this2 = this;

      var package_name = this.getPackageName(entity);
      var class_name = this.getClassName(entity);

      if (typeof this.views[package_name] == 'undefined' || typeof this.views[package_name][class_name] == 'undefined' || typeof this.views[package_name][class_name][view_id] == 'undefined') {
        if (typeof this.views[package_name] == 'undefined') {
          this.views[package_name] = {};
        }

        if (typeof this.views[package_name][class_name] == 'undefined') {
          this.views[package_name][class_name] = {};
        }

        this.views[package_name][class_name][view_id] = _jqueryLib.$.Deferred();

        _equalServices.EnvService.getEnv().then(function (environment) {
          _jqueryLib.$.get({
            url: environment.backend_url + '/?get=model_view&entity=' + entity + '&view_id=' + view_id
          }).then(function (json_data) {
            _this2.views[package_name][class_name][view_id].resolve(json_data);
          }).catch(function (response) {
            console.debug('ApiService::loadView error', response.responseJSON);

            _this2.views[package_name][class_name][view_id].resolve({});
          });
        });
      }

      return this.views[package_name][class_name][view_id];
    }
  }, {
    key: "loadTranslation",
    value: function loadTranslation(entity, locale) {
      var _this3 = this;

      var package_name = this.getPackageName(entity);
      var class_name = this.getClassName(entity);

      if (typeof this.translations[package_name] == 'undefined' || typeof this.translations[package_name][class_name] == 'undefined' || typeof this.translations[package_name][class_name][locale] == 'undefined') {
        if (typeof this.translations[package_name] == 'undefined') {
          this.translations[package_name] = {};
        }

        if (typeof this.translations[package_name][class_name] == 'undefined') {
          this.translations[package_name][class_name] = {};
        }

        this.translations[package_name][class_name][locale] = _jqueryLib.$.Deferred();

        _equalServices.EnvService.getEnv().then(function (environment) {
          _jqueryLib.$.get({
            url: environment.backend_url + '/?get=config_i18n&entity=' + entity + '&lang=' + locale
          }).then(function (json_data) {
            _this3.translations[package_name][class_name][locale].resolve(json_data);
          }).catch(function (response) {
            _this3.translations[package_name][class_name][locale].resolve({});
          });
        });
      } // stored object is a promise, that might or might not be resolved,
      // with either translation object or empty object if no translation was found


      return this.translations[package_name][class_name][locale];
    }
  }, {
    key: "getLastStatus",
    value: function getLastStatus() {
      return this.last_status;
    }
  }, {
    key: "getLastCount",
    value: function getLastCount() {
      return this.last_count;
    }
  }, {
    key: "getLastHeaders",
    value: function getLastHeaders() {
      return this.last_headers;
    }
  }, {
    key: "setLastHeaders",
    value: function setLastHeaders(headers) {
      var _this4 = this;

      // convert headers string to an array
      var headers_array = headers.trim().split(/[\r\n]+/); // reset

      this.last_headers = {}; // create a map of header names to values

      headers_array.forEach(function (line) {
        var parts = line.split(': ');
        var header = parts.shift();
        var value = parts.join(': ');
        _this4.last_headers[header] = value;
      });
    }
  }, {
    key: "getTranslation",
    value: function () {
      var _getTranslation = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(entity) {
        var locale,
            environment,
            translation,
            _args = arguments;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                locale = _args.length > 1 && _args[1] !== undefined ? _args[1] : '';
                _context.next = 3;
                return _equalServices.EnvService.getEnv();

              case 3:
                environment = _context.sent;
                _context.next = 6;
                return this.loadTranslation(entity, locale.length ? locale : environment.locale);

              case 6:
                translation = _context.sent;
                return _context.abrupt("return", translation);

              case 8:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getTranslation(_x) {
        return _getTranslation.apply(this, arguments);
      }

      return getTranslation;
    }()
  }, {
    key: "getSchema",
    value: function () {
      var _getSchema = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(entity) {
        var schema;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return this.loadSchema(entity);

              case 2:
                schema = _context2.sent;
                return _context2.abrupt("return", schema);

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function getSchema(_x2) {
        return _getSchema.apply(this, arguments);
      }

      return getSchema;
    }()
  }, {
    key: "getView",
    value: function () {
      var _getView = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(entity, view_id) {
        var view;
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return this.loadView(entity, view_id);

              case 2:
                view = _context3.sent;
                return _context3.abrupt("return", view);

              case 4:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function getView(_x3, _x4) {
        return _getView.apply(this, arguments);
      }

      return getView;
    }()
  }, {
    key: "getUser",
    value: function () {
      var _getUser = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4() {
        var result, environment, response;
        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                _context4.prev = 0;
                _context4.next = 3;
                return _equalServices.EnvService.getEnv();

              case 3:
                environment = _context4.sent;
                _context4.next = 6;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/userinfo'
                });

              case 6:
                response = _context4.sent;
                result = response;
                _context4.next = 13;
                break;

              case 10:
                _context4.prev = 10;
                _context4.t0 = _context4["catch"](0);
                throw _context4.t0.responseJSON;

              case 13:
                return _context4.abrupt("return", result);

              case 14:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, null, [[0, 10]]);
      }));

      function getUser() {
        return _getUser.apply(this, arguments);
      }

      return getUser;
    }()
  }, {
    key: "getSettings",
    value: function () {
      var _getSettings = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5() {
        var result, environment, response;
        return _regenerator.default.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                _context5.prev = 0;
                _context5.next = 3;
                return _equalServices.EnvService.getEnv();

              case 3:
                environment = _context5.sent;
                _context5.next = 6;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/appinfo'
                });

              case 6:
                response = _context5.sent;
                result = response;
                _context5.next = 13;
                break;

              case 10:
                _context5.prev = 10;
                _context5.t0 = _context5["catch"](0);
                throw _context5.t0.responseJSON;

              case 13:
                return _context5.abrupt("return", result);

              case 14:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, null, [[0, 10]]);
      }));

      function getSettings() {
        return _getSettings.apply(this, arguments);
      }

      return getSettings;
    }()
  }, {
    key: "fetch",
    value: function fetch(route) {
      var _this5 = this;

      var body = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var content_type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'application/json';
      return new Promise( /*#__PURE__*/function () {
        var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee6(resolve, reject) {
          var environment, xhr;
          return _regenerator.default.wrap(function _callee6$(_context6) {
            while (1) {
              switch (_context6.prev = _context6.next) {
                case 0:
                  _context6.prev = 0;
                  _context6.next = 3;
                  return _equalServices.EnvService.getEnv();

                case 3:
                  environment = _context6.sent;
                  xhr = new XMLHttpRequest();
                  xhr.open('GET', environment.backend_url + route + '?' + jQuery.param(body), true);

                  if (content_type == 'application/json') {
                    xhr.responseType = "json";
                  } else {
                    xhr.responseType = "arraybuffer";
                  }

                  xhr.withCredentials = true;
                  xhr.send(null);

                  xhr.onload = function () {
                    _this5.last_status = xhr.status;

                    if (xhr.status < 200 || xhr.status > 299) {
                      reject(xhr.response);
                    } else {
                      if (xhr.getResponseHeader('X-Total-Count')) {
                        _this5.last_count = parseInt(xhr.getResponseHeader('X-Total-Count'));
                      }

                      _this5.setLastHeaders(xhr.getAllResponseHeaders());

                      resolve(xhr.response);
                    }
                  };

                  _context6.next = 15;
                  break;

                case 12:
                  _context6.prev = 12;
                  _context6.t0 = _context6["catch"](0);
                  reject(_context6.t0);

                case 15:
                case "end":
                  return _context6.stop();
              }
            }
          }, _callee6, null, [[0, 12]]);
        }));

        return function (_x5, _x6) {
          return _ref.apply(this, arguments);
        };
      }());
    }
  }, {
    key: "call",
    value: function call(route) {
      var body = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return new Promise( /*#__PURE__*/function () {
        var _ref2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee7(resolve, reject) {
          var environment, xhr, params;
          return _regenerator.default.wrap(function _callee7$(_context7) {
            while (1) {
              switch (_context7.prev = _context7.next) {
                case 0:
                  _context7.prev = 0;
                  _context7.next = 3;
                  return _equalServices.EnvService.getEnv();

                case 3:
                  environment = _context7.sent;
                  xhr = new XMLHttpRequest();
                  xhr.open('POST', environment.backend_url + route, true);
                  xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                  params = jQuery.param(body);
                  xhr.responseType = "json";
                  xhr.withCredentials = true;
                  xhr.send(params);

                  xhr.onload = function () {
                    if (xhr.status < 200 || xhr.status > 299) {
                      reject(xhr.response);
                    } else {
                      resolve(xhr.response);
                    }
                  };

                  _context7.next = 17;
                  break;

                case 14:
                  _context7.prev = 14;
                  _context7.t0 = _context7["catch"](0);
                  reject(_context7.t0);

                case 17:
                case "end":
                  return _context7.stop();
              }
            }
          }, _callee7, null, [[0, 14]]);
        }));

        return function (_x7, _x8) {
          return _ref2.apply(this, arguments);
        };
      }());
    }
  }, {
    key: "create",
    value: function () {
      var _create = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee8(entity) {
        var fields,
            result,
            environment,
            params,
            response,
            _args8 = arguments;
        return _regenerator.default.wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                fields = _args8.length > 1 && _args8[1] !== undefined ? _args8[1] : {};
                _context8.prev = 1;
                _context8.next = 4;
                return _equalServices.EnvService.getEnv();

              case 4:
                environment = _context8.sent;
                params = {
                  entity: entity,
                  fields: fields,
                  lang: environment.lang
                };
                _context8.next = 8;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/?do=model_create',
                  dataType: 'json',
                  data: params,
                  contentType: 'application/x-www-form-urlencoded; charset=utf-8'
                });

              case 8:
                response = _context8.sent;
                result = response;
                _context8.next = 15;
                break;

              case 12:
                _context8.prev = 12;
                _context8.t0 = _context8["catch"](1);
                throw _context8.t0.responseJSON;

              case 15:
                return _context8.abrupt("return", result);

              case 16:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, null, [[1, 12]]);
      }));

      function create(_x9) {
        return _create.apply(this, arguments);
      }

      return create;
    }()
  }, {
    key: "read",
    value: function () {
      var _read = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee9(entity, ids, fields) {
        var lang,
            result,
            environment,
            params,
            response,
            _args9 = arguments;
        return _regenerator.default.wrap(function _callee9$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                lang = _args9.length > 3 && _args9[3] !== undefined ? _args9[3] : '';
                _context9.prev = 1;
                _context9.next = 4;
                return _equalServices.EnvService.getEnv();

              case 4:
                environment = _context9.sent;
                params = {
                  entity: entity,
                  ids: ids,
                  fields: fields,
                  lang: lang.length ? lang : environment.lang
                };
                _context9.next = 8;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/?get=model_read',
                  dataType: 'json',
                  data: params,
                  contentType: 'application/x-www-form-urlencoded; charset=utf-8'
                });

              case 8:
                response = _context9.sent;
                result = response;
                _context9.next = 15;
                break;

              case 12:
                _context9.prev = 12;
                _context9.t0 = _context9["catch"](1);
                throw _context9.t0.responseJSON;

              case 15:
                return _context9.abrupt("return", result);

              case 16:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee9, null, [[1, 12]]);
      }));

      function read(_x10, _x11, _x12) {
        return _read.apply(this, arguments);
      }

      return read;
    }()
  }, {
    key: "delete",
    value: function () {
      var _delete2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee10(entity, ids) {
        var permanent,
            result,
            environment,
            params,
            response,
            _args10 = arguments;
        return _regenerator.default.wrap(function _callee10$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                permanent = _args10.length > 2 && _args10[2] !== undefined ? _args10[2] : false;
                _context10.prev = 1;
                _context10.next = 4;
                return _equalServices.EnvService.getEnv();

              case 4:
                environment = _context10.sent;
                params = {
                  entity: entity,
                  ids: ids,
                  permanent: permanent
                };
                _context10.next = 8;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/?do=model_delete',
                  dataType: 'json',
                  data: params,
                  contentType: 'application/x-www-form-urlencoded; charset=utf-8'
                });

              case 8:
                response = _context10.sent;
                result = response;
                _context10.next = 15;
                break;

              case 12:
                _context10.prev = 12;
                _context10.t0 = _context10["catch"](1);
                throw _context10.t0.responseJSON;

              case 15:
                return _context10.abrupt("return", result);

              case 16:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee10, null, [[1, 12]]);
      }));

      function _delete(_x13, _x14) {
        return _delete2.apply(this, arguments);
      }

      return _delete;
    }()
  }, {
    key: "archive",
    value: function () {
      var _archive = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee11(entity, ids) {
        var result, environment, params, response;
        return _regenerator.default.wrap(function _callee11$(_context11) {
          while (1) {
            switch (_context11.prev = _context11.next) {
              case 0:
                _context11.prev = 0;
                _context11.next = 3;
                return _equalServices.EnvService.getEnv();

              case 3:
                environment = _context11.sent;
                params = {
                  entity: entity,
                  ids: ids
                };
                _context11.next = 7;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/?do=model_archive',
                  dataType: 'json',
                  data: params,
                  contentType: 'application/x-www-form-urlencoded; charset=utf-8'
                });

              case 7:
                response = _context11.sent;
                result = response;
                _context11.next = 14;
                break;

              case 11:
                _context11.prev = 11;
                _context11.t0 = _context11["catch"](0);
                throw _context11.t0.responseJSON;

              case 14:
                return _context11.abrupt("return", result);

              case 15:
              case "end":
                return _context11.stop();
            }
          }
        }, _callee11, null, [[0, 11]]);
      }));

      function archive(_x15, _x16) {
        return _archive.apply(this, arguments);
      }

      return archive;
    }()
    /**
     *
     * In practice, only one object is updated at a time (through form or list inline editing)
     *
     * @param entity
     * @param ids
     * @param fields
     */

  }, {
    key: "update",
    value: function () {
      var _update = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee12(entity, ids, fields) {
        var force,
            lang,
            result,
            environment,
            params,
            response,
            _args12 = arguments;
        return _regenerator.default.wrap(function _callee12$(_context12) {
          while (1) {
            switch (_context12.prev = _context12.next) {
              case 0:
                force = _args12.length > 3 && _args12[3] !== undefined ? _args12[3] : false;
                lang = _args12.length > 4 && _args12[4] !== undefined ? _args12[4] : '';
                console.debug('ApiService::update', entity, ids, fields);
                result = true;
                _context12.prev = 4;
                _context12.next = 7;
                return _equalServices.EnvService.getEnv();

              case 7:
                environment = _context12.sent;
                params = {
                  entity: entity,
                  ids: ids,
                  fields: fields,
                  lang: lang.length ? lang : environment.lang,
                  force: force
                };
                _context12.next = 11;
                return _jqueryLib.$.post({
                  url: environment.backend_url + '/?do=model_update',
                  dataType: 'json',
                  data: params,
                  contentType: 'application/x-www-form-urlencoded; charset=utf-8'
                });

              case 11:
                response = _context12.sent;
                result = response;
                _context12.next = 18;
                break;

              case 15:
                _context12.prev = 15;
                _context12.t0 = _context12["catch"](4);
                throw _context12.t0.responseJSON;

              case 18:
                return _context12.abrupt("return", result);

              case 19:
              case "end":
                return _context12.stop();
            }
          }
        }, _callee12, null, [[4, 15]]);
      }));

      function update(_x17, _x18, _x19) {
        return _update.apply(this, arguments);
      }

      return update;
    }()
  }, {
    key: "clone",
    value: function () {
      var _clone = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee13(entity, ids) {
        var result, environment, params, response;
        return _regenerator.default.wrap(function _callee13$(_context13) {
          while (1) {
            switch (_context13.prev = _context13.next) {
              case 0:
                _context13.prev = 0;
                _context13.next = 3;
                return _equalServices.EnvService.getEnv();

              case 3:
                environment = _context13.sent;
                params = {
                  entity: entity,
                  ids: ids,
                  lang: environment.lang
                };
                _context13.next = 7;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/?do=model_clone',
                  dataType: 'json',
                  data: params,
                  contentType: 'application/x-www-form-urlencoded; charset=utf-8'
                });

              case 7:
                response = _context13.sent;
                result = response;
                _context13.next = 14;
                break;

              case 11:
                _context13.prev = 11;
                _context13.t0 = _context13["catch"](0);
                throw _context13.t0.responseJSON;

              case 14:
                return _context13.abrupt("return", result);

              case 15:
              case "end":
                return _context13.stop();
            }
          }
        }, _callee13, null, [[0, 11]]);
      }));

      function clone(_x20, _x21) {
        return _clone.apply(this, arguments);
      }

      return clone;
    }()
    /**
     * Search for objects matching the given domain and return a list of objects holding requested fields and their values.
     *
     * @param entity
     * @param domain
     * @param fields
     * @param order     name of the field on which sort the collection
     * @param sort      'asc' or 'desc'
     * @param start
     * @param limit
     * @param lang
     * @returns     Promise     Upon success, the promise is resolved into an Array holding matching objects (collection).
     */

  }, {
    key: "collect",
    value: function () {
      var _collect = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee14(entity, domain, fields, order, sort, start, limit) {
        var _this6 = this;

        var lang,
            result,
            environment,
            params,
            response,
            _args14 = arguments;
        return _regenerator.default.wrap(function _callee14$(_context14) {
          while (1) {
            switch (_context14.prev = _context14.next) {
              case 0:
                lang = _args14.length > 7 && _args14[7] !== undefined ? _args14[7] : '';
                console.debug('ApiService::collect', entity, domain, fields, order, sort, start, limit);
                result = [];
                _context14.prev = 3;
                _context14.next = 6;
                return _equalServices.EnvService.getEnv();

              case 6:
                environment = _context14.sent;
                params = {
                  entity: entity,
                  domain: domain,
                  fields: fields,
                  lang: lang.length ? lang : environment.lang,
                  order: order,
                  sort: sort,
                  start: start,
                  limit: limit
                };
                _context14.next = 10;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/?get=model_collect',
                  dataType: 'json',
                  data: params,
                  contentType: 'application/x-www-form-urlencoded; charset=utf-8'
                }).done(function (event, textStatus, jqXHR) {
                  _this6.last_count = parseInt(jqXHR.getResponseHeader('X-Total-Count'));
                });

              case 10:
                response = _context14.sent;
                result = response;
                _context14.next = 17;
                break;

              case 14:
                _context14.prev = 14;
                _context14.t0 = _context14["catch"](3);
                throw _context14.t0.responseJSON;

              case 17:
                return _context14.abrupt("return", result);

              case 18:
              case "end":
                return _context14.stop();
            }
          }
        }, _callee14, null, [[3, 14]]);
      }));

      function collect(_x22, _x23, _x24, _x25, _x26, _x27, _x28) {
        return _collect.apply(this, arguments);
      }

      return collect;
    }()
    /**
     * Search for objects matching the given domain and return a list of identifiers.
     *
     * @param entity
     * @param domain
     * @param order
     * @param sort
     * @param start
     * @param limit
     * @returns
     */

  }, {
    key: "search",
    value: function () {
      var _search = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee15(entity, domain, order, sort, start, limit) {
        var result, environment, params, response;
        return _regenerator.default.wrap(function _callee15$(_context15) {
          while (1) {
            switch (_context15.prev = _context15.next) {
              case 0:
                result = [];
                _context15.prev = 1;
                _context15.next = 4;
                return _equalServices.EnvService.getEnv();

              case 4:
                environment = _context15.sent;
                params = {
                  entity: entity,
                  domain: domain,
                  order: order,
                  sort: sort,
                  start: start,
                  limit: limit
                };
                _context15.next = 8;
                return _jqueryLib.$.get({
                  url: environment.backend_url + '/?get=model_search',
                  dataType: 'json',
                  data: params,
                  contentType: 'application/x-www-form-urlencoded; charset=utf-8'
                });

              case 8:
                response = _context15.sent;
                // reponse should be an array of ids
                result = response;
                _context15.next = 15;
                break;

              case 12:
                _context15.prev = 12;
                _context15.t0 = _context15["catch"](1);
                throw _context15.t0.responseJSON;

              case 15:
                return _context15.abrupt("return", result);

              case 16:
              case "end":
                return _context15.stop();
            }
          }
        }, _callee15, null, [[1, 12]]);
      }));

      function search(_x29, _x30, _x31, _x32, _x33, _x34) {
        return _search.apply(this, arguments);
      }

      return search;
    }()
  }]);
  return _ApiService;
}();

exports._ApiService = _ApiService;
var _default = _ApiService;
exports.default = _default;

/***/ }),

/***/ "./build/Context.js":
/*!**************************!*\
  !*** ./build/Context.js ***!
  \**************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports.Context = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _jqueryLib = __webpack_require__(/*! ./jquery-lib */ "./build/jquery-lib.js");

var _equalLib = __webpack_require__(/*! ./equal-lib */ "./build/equal-lib.js");

var Context = /*#__PURE__*/function () {
  // flag for marking the context to be refreshed
  // callback to be called when the context closes

  /**
   * 
   * Contexts have a type and a mode, and are created for a purpose.
   * The purpose influences the need for available actions (buttons in the header),
   * and can be displayed to user as an indication of the expected action.
   *
   * {type = list} (toggleable mode)
   *     * {purpose = view}: View a list of existing objects : only possible action should be available ('create')
   *    * {purpose = select}: Select a value for a field : the displayed list purpose is to select an item (other actions should not be available)
   *    * {purpose = add}: Add one or more objects to a x2many fields
   *
   * {type = form}
   *    * {mode = view}
   *        * {purpose = view}: View a single object : only available actions should be 'edit'
   *    * {mode = edit}
   *        * {purpose = create}: Create a new object : only available actions should be 'save' and 'cancel'
   *        * {purpose = update}: Update an existing object : only available actions should be 'save' and 'cancel'
   * 
   */
  function Context(frame, entity, type, name, domain) {
    var mode = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 'view';
    var purpose = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 'view';
    var lang = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : '';
    var callback = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : function () {
      var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    };
    var config = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : null;
    (0, _classCallCheck2.default)(this, Context);
    (0, _defineProperty2.default)(this, "$container", void 0);
    (0, _defineProperty2.default)(this, "frame", void 0);
    (0, _defineProperty2.default)(this, "view", void 0);
    (0, _defineProperty2.default)(this, "has_changed", void 0);
    (0, _defineProperty2.default)(this, "callback", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    console.debug('Context::Construct - opening context', entity, type, name, domain, mode, purpose, lang, config);
    this.$container = (0, _jqueryLib.$)('<div />').addClass('sb-context');
    this.callback = callback;
    this.has_changed = false;
    this.config = config;
    this.frame = frame;
    this.view = new _equalLib.View(this, entity, type, name, domain, mode, purpose, lang, config); // inject View in parent Context object

    this.$container.append(this.view.getContainer());
  }

  (0, _createClass2.default)(Context, [{
    key: "getEnv",
    value: function getEnv() {
      return this.frame.getEnv();
    }
  }, {
    key: "getUser",
    value: function getUser() {
      return this.frame.getUser();
    }
    /**
     * Close current context.
     * Should be called only by parent Frame.
     *
     */

  }, {
    key: "close",
    value: function close(data) {
      console.debug('Context::close', data); // remove Context container

      this.$container.remove(); // invoke callback to relay events across contexts (select, add, ...)

      if ({}.toString.call(this.callback) === '[object Function]') {
        this.callback(data);
      }
    }
    /**
     * Close current context without calling callback
     * Should be called only by parent Frame.
     *
     */

  }, {
    key: "destroy",
    value: function destroy() {
      console.debug('Context::destroy'); // remove Context container

      this.$container.remove();
    }
    /**
     * Relay closing request (from View) to parent Frame.
     *
     * @param data
     */

  }, {
    key: "closeContext",
    value: function () {
      var _closeContext = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var data,
            silent,
            _args = arguments;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                data = _args.length > 0 && _args[0] !== undefined ? _args[0] : {};
                silent = _args.length > 1 && _args[1] !== undefined ? _args[1] : false;
                _context.next = 4;
                return this.frame.closeContext(data, silent);

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function closeContext() {
        return _closeContext.apply(this, arguments);
      }

      return closeContext;
    }()
    /**
     * Relay update notification (from View) to parent Frame.
     */

  }, {
    key: "updatedContext",
    value: function () {
      var _updatedContext = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                console.debug('Context::updatedContext');
                _context2.next = 3;
                return this.frame.updatedContext();

              case 3:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function updatedContext() {
        return _updatedContext.apply(this, arguments);
      }

      return updatedContext;
    }()
    /**
     * Mark the context as change (requires a refresh).
     * Called from parent Frame.
     */

  }, {
    key: "setChanged",
    value: function setChanged() {
      this.has_changed = true;
    }
    /**
     *
     * @returns Promise A promise that resolves when the View will be fully rendered
     */

  }, {
    key: "isReady",
    value: function isReady() {
      return this.view.isReady();
    }
  }, {
    key: "hasChanged",
    value: function hasChanged() {
      return this.has_changed || this.view.hasChanged();
    }
  }, {
    key: "getEntity",
    value: function getEntity() {
      return this.view.entity;
    }
  }, {
    key: "getMode",
    value: function getMode() {
      return this.view.mode;
    }
  }, {
    key: "getType",
    value: function getType() {
      return this.view.type;
    }
  }, {
    key: "getName",
    value: function getName() {
      return this.view.name;
    }
  }, {
    key: "getDomain",
    value: function getDomain() {
      return this.view.domain;
    }
  }, {
    key: "getPurpose",
    value: function getPurpose() {
      return this.view.purpose;
    }
  }, {
    key: "getLang",
    value: function getLang() {
      return this.view.lang;
    }
  }, {
    key: "getCallback",
    value: function getCallback() {
      return this.callback;
    }
  }, {
    key: "getContainer",
    value: function getContainer() {
      return this.$container;
    }
  }, {
    key: "getFrame",
    value: function getFrame() {
      return this.frame;
    }
  }, {
    key: "getView",
    value: function getView() {
      return this.view;
    }
  }, {
    key: "getConfig",
    value: function getConfig() {
      return this.config;
    }
  }, {
    key: "getParent",
    value: function getParent() {
      return this.frame.getParentContext();
    }
    /**
     * Calling this method means that we need to update the model : values displayed by the context have to be re-fetched from server
     */

  }, {
    key: "refresh",
    value: function () {
      var _refresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3() {
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return this.view.onchangeView();

              case 2:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function refresh() {
        return _refresh.apply(this, arguments);
      }

      return refresh;
    }()
    /**
     * Relay Context opening requests to parent Frame.
     *
     * @param config
     */

  }, {
    key: "openContext",
    value: function () {
      var _openContext = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(config) {
        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                _context4.next = 2;
                return this.frame.openContext(config);

              case 2:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function openContext(_x) {
        return _openContext.apply(this, arguments);
      }

      return openContext;
    }()
  }]);
  return Context;
}();

exports.Context = Context;
var _default = Context;
exports.default = _default;

/***/ }),

/***/ "./build/DateReference.js":
/*!********************************!*\
  !*** ./build/DateReference.js ***!
  \********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports.DateReference = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

/**
 * Class for Date descriptors parsing
 * 
 * 
 
    ## date parser

    * soit une chaine ISO
    * soit une description au format relatif à NOW

    Result of the parsing is always a date.


    Syntaxe:
    date.[this|prev|next].[day|week|month|quarter|semester|year].[first|last]


    * today = date.this.day

    * first day of current year = date.this.year.first

    * last day of last week = date.prev.week.last

 *
 */
var DateReference = /*#__PURE__*/function () {
  function DateReference(descriptor) {
    (0, _classCallCheck2.default)(this, DateReference);
    (0, _defineProperty2.default)(this, "date", void 0);
    this.date = new Date();
    this.parse(descriptor);
  }
  /**
   *
   * descriptor syntax: date.[this|prev|next].[day|week|month|quarter|semester|year].[first|last]
   * @param descriptor
   */


  (0, _createClass2.default)(DateReference, [{
    key: "parse",
    value: function parse(descriptor) {
      var date = new Date(descriptor);

      if (!descriptor || !isNaN(date.getMonth())) {
        this.date = date;
      } else {
        // init at today
        date = new Date();
        descriptor = descriptor.toLowerCase();

        if (descriptor.indexOf('date.') == 0) {
          var parts = descriptor.split('.');
          var len = parts.length;

          if (len > 2) {
            var offset = parts[1] == 'prev' ? -1 : parts[1] == 'next' ? 1 : 0;
            var day = len >= 4 && parts[3] == 'last' ? 'last' : 'first';

            switch (parts[2]) {
              case 'day':
                this.date = new Date(date);
                this.date.setDate(date.getDate() + offset);
                break;

              case 'week':
                this.date = new Date(date);
                var dow = date.getDay(),
                    diff = -dow + (dow == 0 ? -6 : 1);
                this.date.setDate(date.getDate() + diff + offset * 7);

                if (day == 'last') {
                  this.date.setDate(this.date.getDate() + 6);
                }

                break;

              case 'month':
                this.date = new Date(date.getFullYear(), date.getMonth() + offset, 1);

                if (day == 'last') {
                  this.date = new Date(date.getFullYear(), date.getMonth() + offset + 1, 0);
                }

                break;

              case 'quarter':
                break;

              case 'semester':
                break;

              case 'year':
                this.date = new Date(date.getFullYear() + offset, 0, 1);

                if (day == 'last') {
                  this.date = new Date(date.getFullYear() + offset, 11, 31);
                }

                break;
            }
          }
        }
      }
    }
  }, {
    key: "getDate",
    value: function getDate() {
      return this.date;
    }
  }]);
  return DateReference;
}();

exports.DateReference = DateReference;
var _default = DateReference;
/*

if(strpos('date.month'))

if(strpos('date.year'))
	if date.year.first_day
		var firstDay = new Date(date.getFullYear(), 0, 1);
	if date.year.last_day
		var lastDay = new Date(date.getFullYear(), 11, 31);

	else new Date().getFullYear();


if(strpos(date.week))
    d = new Date();
    // Set to nearest Thursday: current date + 4 - current day number
    // Make Sunday's day number 7
    d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay()||7));
    // Get first day of year
    var yearStart = new Date(Date.UTC(d.getFullYear(), 0, 1));
    // Calculate full weeks to nearest Thursday
    var weekNo = Math.ceil(( ( (d.getTime() - yearStart.getTime()) / 86400000) + 1)/7);


if(date.dow)
	var e = ((new Date()).getDay() + 6) % 7 + 1;

if(date.now)
	new Date();
*/

exports.default = _default;

/***/ }),

/***/ "./build/Domain.js":
/*!*************************!*\
  !*** ./build/Domain.js ***!
  \*************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports.Reference = exports.Condition = exports.Clause = exports.Domain = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _DateReference = __webpack_require__(/*! ./DateReference */ "./build/DateReference.js");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * Class Domain manipulations
 *
 */
var Domain = /*#__PURE__*/function () {
  function Domain(domain) {
    (0, _classCallCheck2.default)(this, Domain);
    (0, _defineProperty2.default)(this, "clauses", void 0);
    this.clauses = new Array();
    this.fromArray(domain);
  }

  (0, _createClass2.default)(Domain, [{
    key: "fromArray",
    value: function fromArray(domain) {
      // reset clauses
      this.clauses.splice(0, this.clauses.length);
      /*
          supported formats :
          1) empty  domain : []
          2) 1 condition only : [ '{operand}', '{operator}', '{value}' ]
          3) 1 clause only (one or more conditions) : [ [ '{operand}', '{operator}', '{value}' ], [ '{operand}', '{operator}', '{value}' ] ]
          4) multiple clauses : [ [ [ '{operand}', '{operator}', '{value}' ], [ '{operand}', '{operator}', '{value}' ] ], [ [ '{operand}', '{operator}', '{value}' ] ] ]
      */

      var normalized = Domain.normalize(domain);

      var _iterator = _createForOfIteratorHelper(normalized),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var d_clause = _step.value;
          var clause = new Clause();

          var _iterator2 = _createForOfIteratorHelper(d_clause),
              _step2;

          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var d_condition = _step2.value;
              clause.addCondition(new Condition(d_condition[0], d_condition[1], d_condition[2]));
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }

          this.addClause(clause);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      return this;
    }
  }, {
    key: "toArray",
    value: function toArray() {
      var domain = new Array();

      var _iterator3 = _createForOfIteratorHelper(this.clauses),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var clause = _step3.value;
          domain.push(clause.toArray());
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      return domain;
    }
  }, {
    key: "getClauses",
    value: function getClauses() {
      return this.clauses;
    }
  }, {
    key: "merge",
    value: function merge(domain) {
      var res_domain = new Array();
      var domain_a = domain.toArray();
      var domain_b = this.toArray();

      if (domain_a.length <= 0) {
        res_domain = domain_b;
      } else if (domain_b.length <= 0) {
        res_domain = domain_a;
      } else {
        var _iterator4 = _createForOfIteratorHelper(domain_a),
            _step4;

        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var clause_a = _step4.value;

            var _iterator5 = _createForOfIteratorHelper(domain_b),
                _step5;

            try {
              for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                var clause_b = _step5.value;
                res_domain.push(clause_a.concat(clause_b));
              }
            } catch (err) {
              _iterator5.e(err);
            } finally {
              _iterator5.f();
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      }

      return this.fromArray(res_domain);
    }
  }, {
    key: "addClause",
    value:
    /**
     * Add a clause at the Domain level : the clause is appened to the Domain
     */
    function addClause(clause) {
      this.clauses.push(clause);
    }
    /**
     * Add a condition at the Domain level : the condition is added to each clause of the Domain
     */

  }, {
    key: "addCondition",
    value: function addCondition(condition) {
      var _iterator6 = _createForOfIteratorHelper(this.clauses),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var clause = _step6.value;
          clause.addCondition(condition);
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
    }
    /**
     * Update domain by parsing conditions and replace any occurence of `object.` and `user.` notations with related attributes of given objects.
     *
     * @param object    Object to parse the conditions with.
     * @param user      Current User instance.
     * @returns Domain  Returns current instance with updated values.
     */

  }, {
    key: "parse",
    value: function parse() {
      var object = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      var user = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var _iterator7 = _createForOfIteratorHelper(this.clauses),
          _step7;

      try {
        for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
          var clause = _step7.value;

          var _iterator8 = _createForOfIteratorHelper(clause.conditions),
              _step8;

          try {
            for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
              var condition = _step8.value;
              // adapt value according to its syntax ('user.' or 'object.')
              var value = condition.value; // handle object references as `value` part

              if (typeof value === 'string' && value.indexOf('object.') == 0) {
                var target = value.substring('object.'.length);

                if (!object || !object.hasOwnProperty(target)) {
                  continue;
                }

                var tmp = object[target]; // target points to an object with subfields

                if (typeof tmp === 'object' && !Array.isArray(tmp)) {
                  if (tmp.hasOwnProperty('id')) {
                    value = tmp.id;
                  } else if (tmp.hasOwnProperty('name')) {
                    value = tmp.name;
                  } else {
                    continue;
                  }
                } else {
                  value = object[target];
                }
              } // handle user references as `value` part
              else if (typeof value === 'string' && value.indexOf('user.') == 0) {
                  var _target = value.substring('user.'.length);

                  if (!user || !user.hasOwnProperty(_target)) {
                    continue;
                  }

                  value = user[_target];
                } else if (typeof value === 'string' && value.indexOf('date.') == 0) {
                  value = new _DateReference.DateReference(value).getDate().toISOString();
                }

              condition.value = value;
            }
          } catch (err) {
            _iterator8.e(err);
          } finally {
            _iterator8.f();
          }
        }
      } catch (err) {
        _iterator7.e(err);
      } finally {
        _iterator7.f();
      }

      return this;
    }
    /**
     * Evaluate domain for a given object.
     * Object structure has to comply with the operands mentionned in the conditions of the domain. If no, related conditions are ignored (skipped).
     *
     * @param object
     * @returns boolean Return true if the object matches the domain, false otherwise.
     */

  }, {
    key: "evaluate",
    value: function evaluate(object) {
      var res = false;

      if (this.clauses.length == 0) {
        return true;
      } // parse any reference to object in conditions


      this.parse(object); // evaluate clauses (OR) and conditions (AND)

      var _iterator9 = _createForOfIteratorHelper(this.clauses),
          _step9;

      try {
        for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
          var clause = _step9.value;
          var c_res = true;

          var _iterator10 = _createForOfIteratorHelper(clause.getConditions()),
              _step10;

          try {
            for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
              var condition = _step10.value;

              if (!object.hasOwnProperty(condition.operand)) {
                continue;
              }

              var operand = object[condition.operand];
              var operator = condition.operator;
              var value = condition.value;
              var cc_res = void 0; // handle special cases

              if (operator == '=') {
                operator = '==';
              } else if (operator == '<>') {
                operator = '!=';
              }

              if (operator == 'is' && typeof value == 'number') {
                operator = '==';
              }

              if (operator == 'is') {
                if (value === true) {
                  cc_res = operand;
                } else if ([false, null, 'null', 'empty'].includes(value)) {
                  cc_res = ['', false, undefined, null].includes(operand) || Array.isArray(operand) && !operand.length;
                } else {
                  continue;
                }
              } else if (operator == 'in') {
                if (!Array.isArray(value)) {
                  continue;
                }

                cc_res = value.indexOf(operand) > -1;
              } else if (operator == 'not in') {
                if (!Array.isArray(value)) {
                  continue;
                }

                cc_res = value.indexOf(operand) == -1;
              } else {
                var c_condition = "( '" + operand + "' " + operator + " '" + value + "')";
                cc_res = eval(c_condition);
              }

              c_res = c_res && cc_res;
            }
          } catch (err) {
            _iterator10.e(err);
          } finally {
            _iterator10.f();
          }

          res = res || c_res;
        }
      } catch (err) {
        _iterator9.e(err);
      } finally {
        _iterator9.f();
      }

      return res;
    }
  }], [{
    key: "normalize",
    value: function normalize(domain) {
      if (domain.length <= 0) {
        return [];
      }

      if (!Array.isArray(domain[0])) {
        // single condition
        return [[domain]];
      } else {
        if (domain[0].length <= 0) {
          return [];
        }

        if (!Array.isArray(domain[0][0])) {
          // single clause
          return [domain];
        }
      }

      return domain;
    }
  }]);
  return Domain;
}();

exports.Domain = Domain;

var Clause = /*#__PURE__*/function () {
  function Clause() {
    var conditions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
    (0, _classCallCheck2.default)(this, Clause);
    (0, _defineProperty2.default)(this, "conditions", void 0);

    if (conditions.length == 0) {
      this.conditions = new Array();
    } else {
      this.conditions = conditions;
    }
  }

  (0, _createClass2.default)(Clause, [{
    key: "addCondition",
    value: function addCondition(condition) {
      this.conditions.push(condition);
    }
  }, {
    key: "getConditions",
    value: function getConditions() {
      return this.conditions;
    }
  }, {
    key: "toArray",
    value: function toArray() {
      var clause = new Array();

      var _iterator11 = _createForOfIteratorHelper(this.conditions),
          _step11;

      try {
        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
          var condition = _step11.value;
          clause.push(condition.toArray());
        }
      } catch (err) {
        _iterator11.e(err);
      } finally {
        _iterator11.f();
      }

      return clause;
    }
  }]);
  return Clause;
}();

exports.Clause = Clause;

var Condition = /*#__PURE__*/function () {
  function Condition(operand, operator, value) {
    (0, _classCallCheck2.default)(this, Condition);
    (0, _defineProperty2.default)(this, "operand", void 0);
    (0, _defineProperty2.default)(this, "operator", void 0);
    (0, _defineProperty2.default)(this, "value", void 0);
    this.operand = operand;
    this.operator = operator;
    this.value = value;
  }

  (0, _createClass2.default)(Condition, [{
    key: "toArray",
    value: function toArray() {
      var condition = new Array();
      condition.push(this.operand);
      condition.push(this.operator);
      condition.push(this.value);
      return condition;
    }
  }, {
    key: "getOperand",
    value: function getOperand() {
      return this.operand;
    }
  }, {
    key: "getOperator",
    value: function getOperator() {
      return this.operator;
    }
  }, {
    key: "getValue",
    value: function getValue() {
      return this.value;
    }
  }]);
  return Condition;
}();

exports.Condition = Condition;

var Reference = /*#__PURE__*/function () {
  function Reference(value) {
    (0, _classCallCheck2.default)(this, Reference);
    (0, _defineProperty2.default)(this, "value", void 0);
    this.value = value;
  }
  /**
   * Update value by replacing any occurence of `object.` and `user.` notations with related attributes of given objects.
   *
   * @param any   object  An entity object to serve as reference.
   * @param any   user    A user object to serve as reference.
   * @returns string      The result of the parsing.
   */


  (0, _createClass2.default)(Reference, [{
    key: "parse",
    value: function parse(object) {
      var user = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var result = this.value;

      if (this.value.indexOf('object.') == 0) {
        var target = this.value.substring('object.'.length);

        if (object && object.hasOwnProperty(target)) {
          var tmp = object[target]; // target points to an object with subfields

          if (typeof tmp === 'object' && !Array.isArray(tmp)) {
            if (tmp.hasOwnProperty('id')) {
              result = tmp.id;
            } else if (tmp.hasOwnProperty('name')) {
              result = tmp.name;
            }
          } else {
            result = object[target];
          }
        }
      } // handle user references as `value` part
      else if (this.value.indexOf('user.') == 0) {
          var _target2 = this.value.substring('user.'.length);

          if (user && user.hasOwnProperty(_target2)) {
            result = user[_target2];
          }
        }

      return result;
    }
  }]);
  return Reference;
}();

exports.Reference = Reference;
var _default = Domain;
exports.default = _default;

/***/ }),

/***/ "./build/EnvService.js":
/*!*****************************!*\
  !*** ./build/EnvService.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports._EnvService = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * This service centralizes environment vars
 */
var _EnvService = /*#__PURE__*/function () {
  function _EnvService() {
    (0, _classCallCheck2.default)(this, _EnvService);
    (0, _defineProperty2.default)(this, "environment", null);
    (0, _defineProperty2.default)(this, "promise", null);
    (0, _defineProperty2.default)(this, "default", {
      production: false,
      parent_domain: 'equal.local',
      backend_url: 'http://equal.local',
      rest_api_url: 'http://equal.local/v1',
      lang: 'en',
      locale: 'en'
    });
  }
  /**
   *
   * @returns Promise
   */


  (0, _createClass2.default)(_EnvService, [{
    key: "getEnv",
    value: function getEnv() {
      var _this = this;

      if (!this.promise) {
        this.promise = new Promise( /*#__PURE__*/function () {
          var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(resolve, reject) {
            var response, env;
            return _regenerator.default.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    _context.prev = 0;
                    _context.next = 3;
                    return fetch('/assets/env/config.json');

                  case 3:
                    response = _context.sent;
                    _context.next = 6;
                    return response.json();

                  case 6:
                    env = _context.sent;
                    _this.environment = _objectSpread(_objectSpread({}, _this.default), env);
                    resolve(_this.environment);
                    _context.next = 15;
                    break;

                  case 11:
                    _context.prev = 11;
                    _context.t0 = _context["catch"](0);
                    _this.environment = _objectSpread({}, _this.default);
                    resolve(_this.environment);

                  case 15:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee, null, [[0, 11]]);
          }));

          return function (_x, _x2) {
            return _ref.apply(this, arguments);
          };
        }());
      }

      return this.promise;
    }
  }, {
    key: "setEnv",
    value: function setEnv(property, value) {
      if (this.environment) {
        this.environment[property] = value;
      }
    }
  }, {
    key: "formatNumber",
    value: function formatNumber(value) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var thousand_sep = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ',';
      var decimal_sep = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '.';

      if (this.environment) {
        if (this.environment.hasOwnProperty('core.locale.currency.decimal_precision')) {
          scale = this.environment['core.locale.currency.decimal_precision'];
        }

        if (this.environment.hasOwnProperty('core.locale.numbers.decimal_separator')) {
          decimal_sep = this.environment['core.locale.numbers.decimal_separator'];
        }

        if (this.environment.hasOwnProperty('core.locale.numbers.thousands_separator')) {
          thousand_sep = this.environment['core.locale.numbers.thousands_separator'];
        }

        var parts = value.toFixed(scale).split(".");
        parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, thousand_sep);
        return parts.join(decimal_sep);
      }

      return value.toLocaleString();
    }
  }, {
    key: "formatCurrency",
    value: function formatCurrency(value) {
      var scale = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var thousand_sep = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ',';
      var decimal_sep = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '.';
      var result = this.formatNumber(value, scale, thousand_sep, decimal_sep);

      if (this.environment.hasOwnProperty('core.units.currency')) {
        if (this.environment.hasOwnProperty('core.locale.currency.symbol_position') && this.environment['core.locale.currency.symbol_position'] == 'before') {
          result = this.environment['core.units.currency'] + ' ' + result;
        } else {
          result = result + ' ' + this.environment['core.units.currency'];
        }
      } else {
        result = '$ ' + value;
      }

      return result;
    }
  }]);
  return _EnvService;
}();

exports._EnvService = _EnvService;
var _default = _EnvService;
exports.default = _default;

/***/ }),

/***/ "./build/EventsListener.js":
/*!*********************************!*\
  !*** ./build/EventsListener.js ***!
  \*********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _jqueryLib = __webpack_require__(/*! ./jquery-lib */ "./build/jquery-lib.js");

var _equalLib = __webpack_require__(/*! ./equal-lib */ "./build/equal-lib.js");

var _materialLib = __webpack_require__(/*! ./material-lib */ "./build/material-lib.js");

var _equalServices = __webpack_require__(/*! ./equal-services */ "./build/equal-services.js");

var _moment = _interopRequireDefault(__webpack_require__(/*! moment/moment.js */ "./node_modules/moment/moment.js"));

__webpack_require__(/*! ../node_modules/quill/dist/quill.core.css */ "./node_modules/quill/dist/quill.core.css");

__webpack_require__(/*! ../node_modules/quill/dist/quill.snow.css */ "./node_modules/quill/dist/quill.snow.css");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

__webpack_require__(/*! ../css/material-basics.css */ "./css/material-basics.css");

__webpack_require__(/*! ../css/equal.css */ "./css/equal.css");

/**
 * EqualEventsListener is the root entity for requesting display of View contexts.
 * It acts as a factory facade for relaying event to the Frames they relate to.
 *
 */
var EventsListener = /*#__PURE__*/function () {
  // jquery object for components communication (Views and Widgets)
  // map of Frames : mapping DOM selectors with Frame instances
  // stack of popups (when forcing opening in popups)
  // User (requested as instanciation of the View). This value can be applied on subsequent Domain objects.
  // global environment object
  // flag for preventing running callbacks on events
  function EventsListener() {
    var domListenerId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    (0, _classCallCheck2.default)(this, EventsListener);
    (0, _defineProperty2.default)(this, "$sbEvents", void 0);
    (0, _defineProperty2.default)(this, "frames", void 0);
    (0, _defineProperty2.default)(this, "popups", []);
    (0, _defineProperty2.default)(this, "user", {
      id: 0
    });
    (0, _defineProperty2.default)(this, "env", {});
    (0, _defineProperty2.default)(this, "mute", false);
    (0, _defineProperty2.default)(this, "subscribers", {});
    this.frames = {}; // $sbEvents is a jQuery object used to communicate: it allows an both internal services and external lib to connect with eQ-UI
    // if no name was given, use the default one

    if (domListenerId.length == 0) {
      domListenerId = 'eq-listener';
    }

    this.$sbEvents = (0, _jqueryLib.$)('#' + domListenerId); // if DOM element by given name cannot be found, create it

    if (!this.$sbEvents.length) {
      this.$sbEvents = (0, _jqueryLib.$)('<div/>').attr('id', domListenerId).css('display', 'none').appendTo('body');
    } // setup event handlers


    this.init();
  }

  (0, _createClass2.default)(EventsListener, [{
    key: "addSubscriber",
    value: function addSubscriber(events, callback) {
      var _iterator = _createForOfIteratorHelper(events),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var event = _step.value;
          if (!['open', 'close', 'updated', 'navigate'].includes(event)) continue;

          if (!this.subscribers.hasOwnProperty(event)) {
            this.subscribers[event] = [];
          }

          this.subscribers[event].push(callback);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }, {
    key: "navigate",
    value: function navigate(route) {
      // run callback of subscribers
      if (this.subscribers.hasOwnProperty('navigate') && this.subscribers['navigate'].length) {
        var _iterator2 = _createForOfIteratorHelper(this.subscribers['navigate']),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var callback = _step2.value;

            if ({}.toString.call(callback) === '[object Function]' && !this.mute) {
              callback({
                route: route
              });
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }
    }
  }, {
    key: "getActionButton",
    value: function () {
      var _getActionButton = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(entity, view_id, domain) {
        var type, name, parts, config, id, target, $container, frame, $view_container;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                type = 'list';
                name = 'default';

                if (view_id.length) {
                  parts = view_id.split('.');
                  if (parts.length) type = parts.shift();
                  if (parts.length) name = parts.shift();
                }

                config = {
                  entity: entity,
                  type: type,
                  name: name,
                  domain: domain,
                  mode: 'view',
                  purpose: 'view'
                }; // get a unique DOM id

                id = _materialLib.UIHelper.getUUID();
                target = '#' + id;
                $container = (0, _jqueryLib.$)('<div></div>').attr('id', id);
                $container.appendTo('body');
                frame = new _equalLib.Frame(this, target);
                _context.next = 11;
                return frame._openContext(config);

              case 11:
                // context has been created and is ready
                $view_container = frame.getContext().getView().getContainer();
                return _context.abrupt("return", $view_container.find('.layout-actions'));

              case 13:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getActionButton(_x, _x2, _x3) {
        return _getActionButton.apply(this, arguments);
      }

      return getActionButton;
    }()
  }, {
    key: "_openContext",
    value: function () {
      var _openContext2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(config) {
        var reset,
            environment,
            _iterator3,
            _step3,
            callback,
            _args2 = arguments;

        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                reset = _args2.length > 1 && _args2[1] !== undefined ? _args2[1] : false;

                if (!config) {
                  config = window.context;
                }

                _context2.next = 4;
                return _equalServices.EnvService.getEnv();

              case 4:
                environment = _context2.sent;
                // extend default params with received config
                config = _objectSpread(_objectSpread({}, {
                  entity: '',
                  type: 'list',
                  name: 'default',
                  domain: [],
                  mode: 'view',
                  // view, edit
                  purpose: 'view',
                  // view, select, add
                  lang: environment.lang,
                  locale: environment.locale,
                  callback: null,
                  target: '#sb-container'
                }), config);
                console.debug('eQ: received _openContext', config, reset, config.entity, config.entity.length); // abort invalid entities

                if (config.entity.length) {
                  _context2.next = 9;
                  break;
                }

                return _context2.abrupt("return");

              case 9:
                if (!(this.frames.hasOwnProperty(config.target) && reset)) {
                  _context2.next = 14;
                  break;
                }

                // prevent running callbacks while we close contexts
                this.mute = true; // #memo - after closing, the frame is deleted (@see _closeContext())

                _context2.next = 13;
                return this.frames[config.target].closeAll();

              case 13:
                // restore callbacks runs
                this.mute = false;

              case 14:
                if (!this.frames.hasOwnProperty(config.target)) {
                  this.frames[config.target] = new _equalLib.Frame(this, config.target);
                }

                _context2.next = 17;
                return this.frames[config.target]._openContext(config);

              case 17:
                // run callback of subscribers 
                if (this.subscribers.hasOwnProperty('open') && this.subscribers['open'].length && !this.mute) {
                  _iterator3 = _createForOfIteratorHelper(this.subscribers['open']);

                  try {
                    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                      callback = _step3.value;

                      if ({}.toString.call(callback) === '[object Function]') {
                        callback(config);
                      }
                    }
                  } catch (err) {
                    _iterator3.e(err);
                  } finally {
                    _iterator3.f();
                  }
                }

              case 18:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function _openContext(_x4) {
        return _openContext2.apply(this, arguments);
      }

      return _openContext;
    }()
    /**
     * Notify subscribers about a context update.
     */

  }, {
    key: "_updatedContext",
    value: function () {
      var _updatedContext2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3() {
        var _iterator4, _step4, callback;

        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                console.debug('EventsListener::_updatedContext', this.mute); // run callback of subscribers

                if (this.subscribers.hasOwnProperty('updated') && this.subscribers['updated'].length && !this.mute) {
                  console.debug('eQ::_updatedContext - running callbacks');
                  _iterator4 = _createForOfIteratorHelper(this.subscribers['updated']);

                  try {
                    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                      callback = _step4.value;

                      if ({}.toString.call(callback) === '[object Function]') {
                        // run callback with empty context
                        console.debug('calling callback');
                        callback();
                      }
                    }
                  } catch (err) {
                    _iterator4.e(err);
                  } finally {
                    _iterator4.f();
                  }
                }

              case 2:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function _updatedContext() {
        return _updatedContext2.apply(this, arguments);
      }

      return _updatedContext;
    }()
    /**
     * Close context non-silently with relayed data
     * @param params
     */

  }, {
    key: "_closeContext",
    value: function () {
      var _closeContext2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(params) {
        var frame, _context4, result, _iterator5, _step5, callback;

        return _regenerator.default.wrap(function _callee4$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                params = _objectSpread(_objectSpread({}, {
                  target: '#sb-container',
                  data: {},
                  silent: false
                }), params);

                if (!this.frames.hasOwnProperty(params.target)) {
                  _context5.next = 10;
                  break;
                }

                frame = this.frames[params.target];
                _context5.next = 5;
                return frame._closeContext(params.data, params.silent);

              case 5:
                _context4 = frame.getContext();
                result = {};

                if (Object.keys(_context4).length) {
                  result = {
                    entity: _context4.getEntity(),
                    type: _context4.getType(),
                    name: _context4.getName(),
                    domain: _context4.getDomain(),
                    mode: _context4.getMode(),
                    purpose: _context4.getPurpose(),
                    lang: _context4.getLang()
                  };
                } // run callback of subscribers


                if (this.subscribers.hasOwnProperty('close') && this.subscribers['close'].length && !this.mute && !params.silent) {
                  console.debug('eQ::_closeContext - running callbacks', params);
                  _iterator5 = _createForOfIteratorHelper(this.subscribers['close']);

                  try {
                    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                      callback = _step5.value;

                      if ({}.toString.call(callback) === '[object Function]') {
                        // run callback with empty context
                        callback(result);
                      }
                    }
                  } catch (err) {
                    _iterator5.e(err);
                  } finally {
                    _iterator5.f();
                  }
                }

                if (!Object.keys(_context4).length) {
                  delete this.frames[params.target];
                }

              case 10:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee4, this);
      }));

      function _closeContext(_x5) {
        return _closeContext2.apply(this, arguments);
      }

      return _closeContext;
    }()
    /**
     * Close all contexts silently
     */

  }, {
    key: "_closeAll",
    value: function () {
      var _closeAll2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5(params) {
        var _i, _Object$keys, target;

        return _regenerator.default.wrap(function _callee5$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                if (!(params && params.hasOwnProperty('target'))) {
                  _context6.next = 6;
                  break;
                }

                if (!this.frames.hasOwnProperty(params.target)) {
                  _context6.next = 4;
                  break;
                }

                _context6.next = 4;
                return this.frames[params.target]._closeContext(null, params.silent);

              case 4:
                _context6.next = 14;
                break;

              case 6:
                _i = 0, _Object$keys = Object.keys(this.frames);

              case 7:
                if (!(_i < _Object$keys.length)) {
                  _context6.next = 14;
                  break;
                }

                target = _Object$keys[_i];
                _context6.next = 11;
                return this.frames[target]._closeContext(null, true);

              case 11:
                _i++;
                _context6.next = 7;
                break;

              case 14:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee5, this);
      }));

      function _closeAll(_x6) {
        return _closeAll2.apply(this, arguments);
      }

      return _closeAll;
    }()
    /**
     * Asynchronous initialisation of the eQ instance.
     *
     */

  }, {
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee7() {
        var _this = this;

        var settings, key, environment, queryString, urlParams;
        return _regenerator.default.wrap(function _callee7$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                _context8.prev = 0;
                _context8.next = 3;
                return _equalServices.EnvService.getEnv();

              case 3:
                this.env = _context8.sent;
                _context8.next = 6;
                return _equalServices.ApiService.getUser();

              case 6:
                this.user = _context8.sent;

                if (this.user.hasOwnProperty('language')) {
                  _equalServices.EnvService.setEnv('locale', this.user.language);

                  _equalServices.TranslationService.init();
                } // attempt to retrieve app config


                _context8.next = 10;
                return _equalServices.ApiService.getSettings();

              case 10:
                settings = _context8.sent;

                for (key in settings) {
                  _equalServices.EnvService.setEnv(key, settings[key]);
                }

                _context8.next = 17;
                break;

              case 14:
                _context8.prev = 14;
                _context8.t0 = _context8["catch"](0);
                console.warn('unable to retrieve user info, fallback to guest');

              case 17:
                _context8.next = 19;
                return _equalServices.EnvService.getEnv();

              case 19:
                environment = _context8.sent;

                // init locale
                _moment.default.locale(environment.locale); // overload environment lang if set in URL


                queryString = window.location.search;
                urlParams = new URLSearchParams(queryString);

                if (urlParams.has('lang')) {
                  // #todo - remove ?
                  environment.lang = urlParams.get('lang');

                  _equalServices.EnvService.setEnv('lang', urlParams.get('lang'));
                }
                /**
                 *
                 * A new context can be requested by ngx (menu or app) or by opening a sub-object
                 */


                this.$sbEvents.on('_openContext', /*#__PURE__*/function () {
                  var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee6(event, config) {
                    var reset,
                        _args6 = arguments;
                    return _regenerator.default.wrap(function _callee6$(_context7) {
                      while (1) {
                        switch (_context7.prev = _context7.next) {
                          case 0:
                            reset = _args6.length > 2 && _args6[2] !== undefined ? _args6[2] : false;
                            console.debug('eQ: received _openContext', event, config, reset);

                            _this._openContext(config, reset);

                          case 3:
                          case "end":
                            return _context7.stop();
                        }
                      }
                    }, _callee6);
                  }));

                  return function (_x7, _x8) {
                    return _ref.apply(this, arguments);
                  };
                }());
                /**
                 *
                 * Event handler for request for closing current context
                 * When closing, a context might transmit some value (its the case, for instance, when selecting one or more records for m2m or o2m fields)
                 */

                this.$sbEvents.on('_closeContext', function (event) {
                  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

                  _this._closeContext(params);
                });
                this.$sbEvents.on('_closeAll', function (event) {
                  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

                  _this._closeAll(params);
                });

              case 27:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee7, this, [[0, 14]]);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }()
    /**
     * Mark current context as changed (called from Frame class).
     */

  }, {
    key: "updated",
    value: function () {
      var _updated = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee8() {
        return _regenerator.default.wrap(function _callee8$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                console.debug('EventsListener::updated');
                _context9.next = 3;
                return this._updatedContext();

              case 3:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee8, this);
      }));

      function updated() {
        return _updated.apply(this, arguments);
      }

      return updated;
    }()
  }, {
    key: "closeAll",
    value: function () {
      var _closeAll3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee9() {
        var params,
            _args9 = arguments;
        return _regenerator.default.wrap(function _callee9$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                params = _args9.length > 0 && _args9[0] !== undefined ? _args9[0] : {};
                console.debug('eQ:received closeAll');
                this.$sbEvents.trigger('_closeAll');
                _context10.next = 5;
                return this._closeAll(params);

              case 5:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee9, this);
      }));

      function closeAll() {
        return _closeAll3.apply(this, arguments);
      }

      return closeAll;
    }()
    /**
     * Close a context (can be invoked either from outside, or from Frame class).
     */

  }, {
    key: "close",
    value: function () {
      var _close = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee10(params) {
        return _regenerator.default.wrap(function _callee10$(_context11) {
          while (1) {
            switch (_context11.prev = _context11.next) {
              case 0:
                _context11.next = 2;
                return this._closeContext(params);

              case 2:
              case "end":
                return _context11.stop();
            }
          }
        }, _callee10, this);
      }));

      function close(_x9) {
        return _close.apply(this, arguments);
      }

      return close;
    }()
    /**
     * Interface method for integration with external tools.
     * @param context
     */

  }, {
    key: "open",
    value: function () {
      var _open = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee11(context) {
        var _this2 = this;

        return _regenerator.default.wrap(function _callee11$(_context12) {
          while (1) {
            switch (_context12.prev = _context12.next) {
              case 0:
                console.debug("eQ::open", context);

                _equalServices.EnvService.getEnv().then(function (environment) {
                  // extend default params with received config
                  var target_context = _objectSpread(_objectSpread({}, {
                    entity: '',
                    type: 'list',
                    name: 'default',
                    domain: [],
                    mode: 'view',
                    // view, edit
                    purpose: 'view',
                    // view, select, add
                    lang: environment.lang,
                    callback: null,
                    target: '#sb-container',
                    reset: false
                  }), context); // this.$sbEvents.trigger('click', [context, context.hasOwnProperty('reset') && context.reset]);


                  if (context.hasOwnProperty('view')) {
                    var parts = context.view.split('.');
                    var view_type = 'list',
                        view_name = 'default';
                    if (parts.length) view_type = parts.shift();
                    if (parts.length) view_name = parts.shift();

                    if (!context.hasOwnProperty('type')) {
                      target_context.type = view_type;
                    }

                    if (!context.hasOwnProperty('name')) {
                      target_context.name = view_name;
                    }
                  } // make context available to the outside


                  window.context = target_context; // ContextService uses 'window' global object to store the arguments (context parameters)
                  // this.$sbEvents.trigger('_openContext', [target_context, target_context.reset]);

                  _this2._openContext(target_context, target_context.reset);
                });

              case 2:
              case "end":
                return _context12.stop();
            }
          }
        }, _callee11);
      }));

      function open(_x10) {
        return _open.apply(this, arguments);
      }

      return open;
    }()
    /**
     * Open the requested context inside a new popup (no target container required).
     *
     * @param config
     */

  }, {
    key: "popup",
    value: function () {
      var _popup = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee12(config) {
        var domContainerSelector,
            $domContainer,
            $wrapper,
            popup_id,
            $popup,
            $inner,
            frame,
            _args12 = arguments;
        return _regenerator.default.wrap(function _callee12$(_context13) {
          while (1) {
            switch (_context13.prev = _context13.next) {
              case 0:
                domContainerSelector = _args12.length > 1 && _args12[1] !== undefined ? _args12[1] : 'body';
                $domContainer = (0, _jqueryLib.$)(domContainerSelector);
                $wrapper = $domContainer.find('.sb-popup-wrapper');

                if (!$wrapper.length) {
                  // origin not found, create container
                  $wrapper = (0, _jqueryLib.$)('<div class="sb-popup-wrapper"></div>');
                  $wrapper.css('left', window.pageXOffset + 'px');
                  $wrapper.css('top', window.pageYOffset + 'px');
                  $domContainer.append($wrapper);
                }

                popup_id = this.popups.length + 1;
                $popup = (0, _jqueryLib.$)('<div id="sb-popup-' + popup_id + '" class="sb-popup"></div>');
                $wrapper.append($popup);
                $popup.css('z-index', 9000 + popup_id);
                $inner = (0, _jqueryLib.$)('<div class="sb-popup-inner" id="sb-popup-inner-' + popup_id + '"></div>').on('_close', function () {
                  $popup.remove();
                });
                $popup.append($inner);
                frame = new _equalLib.Frame(this, '#sb-popup-inner-' + popup_id);
                config.display_mode = 'popup';
                _context13.next = 14;
                return frame._openContext(config);

              case 14:
                this.popups.push(frame);

              case 15:
              case "end":
                return _context13.stop();
            }
          }
        }, _callee12, this);
      }));

      function popup(_x11) {
        return _popup.apply(this, arguments);
      }

      return popup;
    }()
  }, {
    key: "popup_close",
    value: function () {
      var _popup_close = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee13(params) {
        var frame, $wrapper;
        return _regenerator.default.wrap(function _callee13$(_context14) {
          while (1) {
            switch (_context14.prev = _context14.next) {
              case 0:
                frame = this.popups.pop();
                $wrapper = (0, _jqueryLib.$)('body').find('.sb-popup-wrapper'); // pop last child of wrapper

                $wrapper.find('.sb-popup').last().remove(); // if there are no popup left, remove wrapper

                if (!this.popups.length) {
                  $wrapper.remove();
                } // close context (update frame header if necessary)


                _context14.next = 6;
                return frame._closeContext(params.data);

              case 6:
              case "end":
                return _context14.stop();
            }
          }
        }, _callee13, this);
      }));

      function popup_close(_x12) {
        return _popup_close.apply(this, arguments);
      }

      return popup_close;
    }()
  }, {
    key: "getUser",
    value: function getUser() {
      return this.user;
    }
  }, {
    key: "getEnv",
    value: function getEnv() {
      return this.env;
    }
    /**
     * Return global instance of the API service, for using by external tools.
     */

  }, {
    key: "getApiService",
    value: function getApiService() {
      return _equalServices.ApiService;
    }
  }, {
    key: "getTranslationService",
    value: function getTranslationService() {
      return _equalServices.TranslationService;
    }
    /**
     * Generates a menu to be displayed inside the #sb-emnu container.
     * Items of the menu trigger _openContext calls, independantly from any existing listener
     *
     * @param menu Menu object (JSON structure) describing the entries of each section.
     */

  }, {
    key: "loadMenu",
    value: function loadMenu(menu) {
      var _this3 = this;

      var _loop = function _loop() {
        item = menu[i];
        var $link = (0, _jqueryLib.$)('<div/>').addClass('sb-menu-button mdc-menu-surface--anchor').append(_materialLib.UIHelper.createButton('menu-entry' + '-' + item.name + '-' + item.target, item.name, 'text', item.icon)).appendTo((0, _jqueryLib.$)('#sb-menu')); // create floating menu for filters selection

        var $menu = _materialLib.UIHelper.createMenu('nav-menu').addClass('sb-view-header-list-filters-menu').css({
          "margin-top": '48px'
        }).appendTo($link);

        var $list = _materialLib.UIHelper.createList('nav-list').appendTo($menu);

        for (j = 0; j < menu[i].children.length; ++j) {
          item = menu[i].children[j];

          _materialLib.UIHelper.createListItem('menu_item-' + i + '-' + j, item.name + ' (' + item.entity + ')', item.icon).data('item', item).appendTo($list).on('click', function (event) {
            var $this = (0, _jqueryLib.$)(event.currentTarget);
            var item = $this.data('item');

            if (!item.hasOwnProperty('domain')) {
              item.domain = [];
            }

            var type = 'list';
            var name = 'default';

            if (item.hasOwnProperty('target')) {
              var parts = item.target.split('.');
              if (parts.length) type = parts.shift();
              if (parts.length) name = parts.shift();
            }

            _this3.$sbEvents.trigger('_closeAll');

            setTimeout(function () {
              _this3.$sbEvents.trigger('_openContext', {
                entity: item.entity,
                type: type,
                name: name,
                domain: item.domain
              });
            });
          });
        }

        _materialLib.UIHelper.decorateMenu($menu);

        $link.find('button').on('click', function () {
          return $menu.trigger('_toggle');
        });
      };

      // #todo - this is meant for testing and should be deprecated
      for (var i = 0; i < menu.length; ++i) {
        var item;
        var j;
        var item;

        _loop();
      }
    }
  }]);
  return EventsListener;
}();

module.exports = EventsListener;

/***/ }),

/***/ "./build/Frame.js":
/*!************************!*\
  !*** ./build/Frame.js ***!
  \************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports.Frame = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _jqueryLib = __webpack_require__(/*! ./jquery-lib */ "./build/jquery-lib.js");

var _equalLib = __webpack_require__(/*! ./equal-lib */ "./build/equal-lib.js");

var _equalServices = __webpack_require__(/*! ./equal-services */ "./build/equal-services.js");

var _materialLib = __webpack_require__(/*! ./material-lib */ "./build/material-lib.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * Frames handle a stack of contexts
 * and are in charge of their header and lang switcher.
 *
 */
var Frame = /*#__PURE__*/function () {
  // temporary var for computing width of rendered strings
  // stack of Context (only current context is visible)
  // root context
  // DOM selector of the element to which current Frame relates
  // interaction mode ('stacked' or 'popup')
  // allow to force showing close button in any context
  function Frame(eq) {
    var domContainerSelector = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '#sb-container';
    (0, _classCallCheck2.default)(this, Frame);
    (0, _defineProperty2.default)(this, "eq", void 0);
    (0, _defineProperty2.default)(this, "environment", null);
    (0, _defineProperty2.default)(this, "languages", {});
    (0, _defineProperty2.default)(this, "$headerContainer", void 0);
    (0, _defineProperty2.default)(this, "$canvas", void 0);
    (0, _defineProperty2.default)(this, "stack", void 0);
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "domContainerSelector", void 0);
    (0, _defineProperty2.default)(this, "display_mode", void 0);
    (0, _defineProperty2.default)(this, "close_button", void 0);
    this.eq = eq;
    this.context = {};
    this.stack = []; // default mode : contexts are displayed in the same container

    this.display_mode = 'stacked'; // if there is a single context, prevent closing the frame

    this.close_button = false; // As a convention, DOM element referenced by given selector must be present in the document.

    this.domContainerSelector = domContainerSelector;
    this.init();
  }

  (0, _createClass2.default)(Frame, [{
    key: "getContext",
    value: function getContext() {
      return this.context;
    }
  }, {
    key: "getParentContext",
    value: function getParentContext() {
      var offset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : -1;
      var len = this.stack.length;
      var pos = len - Math.abs(offset);

      if (pos >= 0) {
        return this.stack[pos];
      } // #memo - if stack is empty, current context is an empty object


      return this.context;
    }
  }, {
    key: "getEnv",
    value: function getEnv() {
      return this.environment;
    }
  }, {
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var _this = this;

        var languages, _iterator, _step, lang, resize_debounce;

        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return _equalServices.EnvService.getEnv();

              case 2:
                this.environment = _context2.sent;
                _context2.next = 5;
                return _equalServices.ApiService.collect('core\\Lang', [], ['id', 'code', 'name'], 'name', 'asc', 0, 100, this.environment.locale);

              case 5:
                languages = _context2.sent;
                _iterator = _createForOfIteratorHelper(languages);

                try {
                  for (_iterator.s(); !(_step = _iterator.n()).done;) {
                    lang = _step.value;
                    this.languages[lang.code] = lang.name;
                  } // trigger header re-draw when available horizontal space changes

                } catch (err) {
                  _iterator.e(err);
                } finally {
                  _iterator.f();
                }

                (0, _jqueryLib.$)(window).on('resize', function () {
                  clearTimeout(resize_debounce);
                  resize_debounce = setTimeout( /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
                    return _regenerator.default.wrap(function _callee$(_context) {
                      while (1) {
                        switch (_context.prev = _context.next) {
                          case 0:
                            return _context.abrupt("return", _this.updateHeader());

                          case 1:
                          case "end":
                            return _context.stop();
                        }
                      }
                    }, _callee);
                  })), 100);
                });

              case 9:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }()
  }, {
    key: "getTextWidth",
    value: function getTextWidth(text, font) {
      var result = 0; // re-use canvas object for better performance

      var canvas = this.$canvas || (this.$canvas = document.createElement("canvas"));
      var context = canvas.getContext("2d");
      context.font = font;
      var metrics = context.measureText(text);
      result = metrics.width;
      return result;
    }
  }, {
    key: "getPurposeString",
    value: function () {
      var _getPurposeString = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(context) {
        var result, entity, type, name, purpose, environment, view_schema, translation, parts, view_id, purpose_const, translated_purpose, objects, object;
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                result = '';
                entity = context.getEntity();
                type = context.getType();
                name = context.getName();
                purpose = context.getPurpose();
                _context3.next = 7;
                return _equalServices.EnvService.getEnv();

              case 7:
                environment = _context3.sent;
                _context3.next = 10;
                return _equalServices.ApiService.getView(entity, type + '.' + name);

              case 10:
                view_schema = _context3.sent;
                _context3.next = 13;
                return _equalServices.ApiService.getTranslation(entity, environment.locale);

              case 13:
                translation = _context3.sent;

                if (translation.hasOwnProperty('name')) {
                  entity = translation['name'];
                } else if (view_schema.hasOwnProperty('name')) {
                  entity = view_schema['name'];
                } else {
                  parts = entity.split('\\');
                  entity = parts.pop(); // set the first letter uppercase

                  entity = entity.charAt(0).toUpperCase() + entity.slice(1);
                }

                if (!(purpose == 'view')) {
                  _context3.next = 21;
                  break;
                }

                result = entity;

                if (type == 'list') {
                  if (translation.hasOwnProperty('plural')) {
                    result = translation['plural'];
                  }
                } // if view_id is defined in translation file : use its translated values, if present


                if (translation.hasOwnProperty('view')) {
                  view_id = context.getView().getId();

                  if (translation.view.hasOwnProperty(view_id) && translation.view[view_id].hasOwnProperty('name')) {
                    result = translation.view[view_id].name;
                  }
                }

                _context3.next = 37;
                break;

              case 21:
                // i18n: look in config translation file
                purpose_const = '';
                _context3.t0 = purpose;
                _context3.next = _context3.t0 === 'create' ? 25 : _context3.t0 === 'update' ? 27 : _context3.t0 === 'select' ? 29 : _context3.t0 === 'add' ? 31 : 33;
                break;

              case 25:
                purpose_const = 'SB_PURPOSE_CREATE';
                return _context3.abrupt("break", 33);

              case 27:
                purpose_const = 'SB_PURPOSE_UPDATE';
                return _context3.abrupt("break", 33);

              case 29:
                purpose_const = 'SB_PURPOSE_SELECT';
                return _context3.abrupt("break", 33);

              case 31:
                purpose_const = 'SB_PURPOSE_ADD';
                return _context3.abrupt("break", 33);

              case 33:
                _context3.next = 35;
                return _equalServices.TranslationService.translate(purpose_const);

              case 35:
                translated_purpose = _context3.sent;

                if (translated_purpose.length) {
                  result = translated_purpose + ' ' + entity;
                } else {
                  result = purpose.charAt(0).toUpperCase() + purpose.slice(1) + ' ' + entity;
                }

              case 37:
                if (!(type == 'form')) {
                  _context3.next = 42;
                  break;
                }

                _context3.next = 40;
                return context.getView().getModel().get();

              case 40:
                objects = _context3.sent;

                if (objects.length) {
                  object = objects[0]; // by convention, collections should always request the `name` field

                  if (object.hasOwnProperty('name') && purpose != 'create') {
                    result += ' <small>[' + object['name'] + ' - ' + object['id'] + ']</small>';
                  }
                }

              case 42:
                return _context3.abrupt("return", result);

              case 43:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      function getPurposeString(_x) {
        return _getPurposeString.apply(this, arguments);
      }

      return getPurposeString;
    }()
    /**
     * Refresh the header breadcrumb, according to available space.
     * .sb-container-header is managed automatically and shows the breadcrumb of the stack
     *
     * @returns
     */

  }, {
    key: "updateHeader",
    value: function () {
      var _updateHeader = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5() {
        var _this2 = this;

        var $domContainer, $elem, $temp, current_purpose_string, available_width, font, total_text_width, prepend_contexts_count, char_width, max_chars, _loop, i, _ret, model_schema, objects, link, environment, locale, $lang_selector;

        return _regenerator.default.wrap(function _callee5$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                console.debug('Frame::update header');
                $domContainer = (0, _jqueryLib.$)(this.domContainerSelector);

                if ($domContainer) {
                  _context6.next = 4;
                  break;
                }

                return _context6.abrupt("return");

              case 4:
                // instanciate header upon first call
                this.$headerContainer = $domContainer.find('.sb-container-header');

                if (this.$headerContainer.length == 0) {
                  this.$headerContainer = (0, _jqueryLib.$)('<div/>').addClass('sb-container-header').prependTo($domContainer);
                }

                if (!(this.stack.length == 0 || !this.context.hasOwnProperty('$container'))) {
                  _context6.next = 9;
                  break;
                }

                // hide header if there is no context
                this.$headerContainer.empty().hide();
                return _context6.abrupt("return");

              case 9:
                // make sure header is visible
                this.$headerContainer.show();
                $elem = (0, _jqueryLib.$)('<h3 />').css({
                  display: 'flex'
                }); // add temporary, invisible header for font size computations

                $temp = (0, _jqueryLib.$)('<h3 />').css({
                  visibility: 'hidden'
                }).appendTo(this.$headerContainer);
                _context6.next = 14;
                return this.getPurposeString(this.context);

              case 14:
                current_purpose_string = _context6.sent;
                available_width = this.$headerContainer.length && this.$headerContainer[0] ? this.$headerContainer[0].clientWidth * 0.9 : 300;
                font = $temp.css("font-weight") + ' ' + $temp.css("font-size") + ' ' + $temp.css("font-family");
                total_text_width = this.getTextWidth(current_purpose_string, font);
                prepend_contexts_count = 0;

                if (!(total_text_width > available_width)) {
                  _context6.next = 25;
                  break;
                }

                char_width = total_text_width / current_purpose_string.length;
                max_chars = available_width / char_width;
                current_purpose_string = current_purpose_string.substring(0, max_chars - 1) + '...';
                _context6.next = 35;
                break;

              case 25:
                _loop = /*#__PURE__*/_regenerator.default.mark(function _loop(i) {
                  var context, context_purpose_string, text_width, overflow;
                  return _regenerator.default.wrap(function _loop$(_context5) {
                    while (1) {
                      switch (_context5.prev = _context5.next) {
                        case 0:
                          context = _this2.stack[i];

                          if (!context.hasOwnProperty('$container')) {
                            _context5.next = 19;
                            break;
                          }

                          _context5.next = 4;
                          return _this2.getPurposeString(context);

                        case 4:
                          context_purpose_string = _context5.sent;
                          text_width = _this2.getTextWidth(context_purpose_string + ' > ', font);
                          overflow = false;

                          if (!(text_width + total_text_width >= available_width)) {
                            _context5.next = 13;
                            break;
                          }

                          overflow = true;
                          context_purpose_string = '...';
                          text_width = _this2.getTextWidth(context_purpose_string + ' > ', font);

                          if (!(text_width + total_text_width >= available_width)) {
                            _context5.next = 13;
                            break;
                          }

                          return _context5.abrupt("return", "break");

                        case 13:
                          total_text_width += text_width;
                          prepend_contexts_count++;
                          (0, _jqueryLib.$)('<a>' + context_purpose_string + '</a>').prependTo($elem).on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4() {
                            var j, validation;
                            return _regenerator.default.wrap(function _callee4$(_context4) {
                              while (1) {
                                switch (_context4.prev = _context4.next) {
                                  case 0:
                                    j = _this2.stack.length - 1;

                                  case 1:
                                    if (!(j > i)) {
                                      _context4.next = 13;
                                      break;
                                    }

                                    if (!_this2.context.getView().hasChanged()) {
                                      _context4.next = 9;
                                      break;
                                    }

                                    validation = confirm(_equalServices.TranslationService.instant('SB_ACTIONS_MESSAGE_ABANDON_CHANGE'));

                                    if (validation) {
                                      _context4.next = 6;
                                      break;
                                    }

                                    return _context4.abrupt("return");

                                  case 6:
                                    _this2.closeContext(null, true);

                                    _context4.next = 10;
                                    break;

                                  case 9:
                                    _this2.closeContext(null, true);

                                  case 10:
                                    --j;
                                    _context4.next = 1;
                                    break;

                                  case 13:
                                    _this2.closeContext();

                                  case 14:
                                  case "end":
                                    return _context4.stop();
                                }
                              }
                            }, _callee4);
                          })));

                          if (!overflow) {
                            _context5.next = 18;
                            break;
                          }

                          return _context5.abrupt("return", "break");

                        case 18:
                          if (i > 1) {
                            (0, _jqueryLib.$)('<span> › </span>').css({
                              'margin': '0 10px'
                            }).prependTo($elem);
                          }

                        case 19:
                        case "end":
                          return _context5.stop();
                      }
                    }
                  }, _loop);
                });
                i = this.stack.length - 1;

              case 27:
                if (!(i >= 0)) {
                  _context6.next = 35;
                  break;
                }

                return _context6.delegateYield(_loop(i), "t0", 29);

              case 29:
                _ret = _context6.t0;

                if (!(_ret === "break")) {
                  _context6.next = 32;
                  break;
                }

                return _context6.abrupt("break", 35);

              case 32:
                --i;
                _context6.next = 27;
                break;

              case 35:
                // ... plus the active context
                if (prepend_contexts_count > 0) {
                  (0, _jqueryLib.$)('<span> › </span>').css({
                    'margin': '0 10px'
                  }).appendTo($elem);
                }

                if (!(this.display_mode == 'popup')) {
                  _context6.next = 47;
                  break;
                }

                _context6.next = 39;
                return _equalServices.ApiService.getSchema(this.context.getEntity());

              case 39:
                model_schema = _context6.sent;
                _context6.next = 42;
                return this.context.getView().getModel().get();

              case 42:
                objects = _context6.sent;
                link = model_schema.link.replace(/object\.id/, objects[0].id);
                (0, _jqueryLib.$)('<a>' + current_purpose_string + '</a>').attr('href', link).attr('target', '_blank').prependTo($elem);
                _context6.next = 48;
                break;

              case 47:
                (0, _jqueryLib.$)('<span>' + current_purpose_string + '</span>').appendTo($elem);

              case 48:
                if (this.stack.length > 1 || this.display_mode == 'popup' || this.close_button) {
                  // #memo - for integration, we need to let user close any context
                  _materialLib.UIHelper.createButton('context-close', '', 'mini-fab', 'close').css({
                    'transform': 'scale(0.5)',
                    'margin-top': '3px',
                    'background': '#bababa',
                    'box-shadow': 'none'
                  }).appendTo($elem).addClass('context-close').on('click', function () {
                    var validation = true;

                    if (Object.keys(_this2.context).length && _this2.context.getView().hasChanged()) {
                      validation = confirm(_equalServices.TranslationService.instant('SB_ACTIONS_MESSAGE_ABANDON_CHANGE'));
                    }

                    if (!validation) return;

                    _this2.closeContext();
                  });
                } // lang selector controls the current context and is used for opening subsequent contexts


                _context6.next = 51;
                return _equalServices.EnvService.getEnv();

              case 51:
                environment = _context6.sent;
                locale = environment.locale; // if there is a current context, use its lang

                if (this.context.hasOwnProperty('$container')) {
                  locale = this.context.getLang();
                }

                $lang_selector = _materialLib.UIHelper.createSelect('lang-selector', '', this.languages, locale);
                $lang_selector.addClass('lang-selector');
                $lang_selector.find('.mdc-select__selected-text').css({
                  'text-transform': 'uppercase'
                }).text(locale);
                $lang_selector.on('change', function () {
                  // when the lang selector is changed by user, update current context
                  var lang = $lang_selector.find('input').val();
                  $lang_selector.find('.mdc-select__selected-text').css({
                    'text-transform': 'uppercase'
                  }).text(lang);
                  var context = new _equalLib.Context(_this2, _this2.context.getEntity(), _this2.context.getType(), _this2.context.getName(), _this2.context.getDomain(), _this2.context.getMode(), _this2.context.getPurpose(), lang, _this2.context.getCallback(), _this2.context.getConfig());

                  _this2.context.destroy();

                  _this2.context = context;

                  _this2.context.isReady().then(function () {
                    (0, _jqueryLib.$)(_this2.domContainerSelector).append(_this2.context.getContainer());
                  });
                });
                this.$headerContainer.show().empty().append($elem).append($lang_selector);

              case 59:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee5, this);
      }));

      function updateHeader() {
        return _updateHeader.apply(this, arguments);
      }

      return updateHeader;
    }()
    /**
     * Generate an object mapping fields of current entity with default values, based on current domain.
     *
     * @returns Object  A map of fields with their related default values
     */

  }, {
    key: "getNewObjectDefaults",
    value: function () {
      var _getNewObjectDefaults = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee6(entity) {
        var domain,
            fields,
            model_schema,
            model_fields,
            tmpDomain,
            _iterator2,
            _step2,
            clause,
            _iterator3,
            _step3,
            condition,
            field,
            _args7 = arguments;

        return _regenerator.default.wrap(function _callee6$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                domain = _args7.length > 1 && _args7[1] !== undefined ? _args7[1] : [];
                // create a new object as draft
                fields = {
                  state: 'draft'
                }; // retrieve fields definition

                _context7.next = 4;
                return _equalServices.ApiService.getSchema(entity);

              case 4:
                model_schema = _context7.sent;
                model_fields = model_schema.fields; // use View domain for setting default values

                tmpDomain = new _equalLib.Domain(domain);
                _iterator2 = _createForOfIteratorHelper(tmpDomain.getClauses());
                _context7.prev = 8;

                _iterator2.s();

              case 10:
                if ((_step2 = _iterator2.n()).done) {
                  _context7.next = 33;
                  break;
                }

                clause = _step2.value;
                _iterator3 = _createForOfIteratorHelper(clause.getConditions());
                _context7.prev = 13;

                _iterator3.s();

              case 15:
                if ((_step3 = _iterator3.n()).done) {
                  _context7.next = 23;
                  break;
                }

                condition = _step3.value;
                field = condition.getOperand();

                if (!(field == 'id')) {
                  _context7.next = 20;
                  break;
                }

                return _context7.abrupt("continue", 21);

              case 20:
                if (['ilike', 'like', '=', 'is'].includes(condition.getOperator()) && model_fields.hasOwnProperty(field)) {
                  fields[field] = condition.getValue();
                }

              case 21:
                _context7.next = 15;
                break;

              case 23:
                _context7.next = 28;
                break;

              case 25:
                _context7.prev = 25;
                _context7.t0 = _context7["catch"](13);

                _iterator3.e(_context7.t0);

              case 28:
                _context7.prev = 28;

                _iterator3.f();

                return _context7.finish(28);

              case 31:
                _context7.next = 10;
                break;

              case 33:
                _context7.next = 38;
                break;

              case 35:
                _context7.prev = 35;
                _context7.t1 = _context7["catch"](8);

                _iterator2.e(_context7.t1);

              case 38:
                _context7.prev = 38;

                _iterator2.f();

                return _context7.finish(38);

              case 41:
                return _context7.abrupt("return", fields);

              case 42:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee6, null, [[8, 35, 38, 41], [13, 25, 28, 31]]);
      }));

      function getNewObjectDefaults(_x2) {
        return _getNewObjectDefaults.apply(this, arguments);
      }

      return getNewObjectDefaults;
    }()
  }, {
    key: "getUser",
    value: function getUser() {
      return this.eq.getUser();
    }
  }, {
    key: "updatedContext",
    value: function () {
      var _updatedContext = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee7() {
        return _regenerator.default.wrap(function _callee7$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                console.debug('Frame::updatedContext');
                _context8.next = 3;
                return this.eq.updated();

              case 3:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee7, this);
      }));

      function updatedContext() {
        return _updatedContext.apply(this, arguments);
      }

      return updatedContext;
    }()
    /**
     * This method can be called by any child or sub-child (view, layout, widgets) (bottom-up).
     *
     * @param config
     */

  }, {
    key: "openContext",
    value: function () {
      var _openContext2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee8(config) {
        return _regenerator.default.wrap(function _callee8$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                config.target = this.domContainerSelector; // we use eventlistener :: open() method in order to relay the context change to the outside

                if (this.display_mode == 'stacked') {
                  this.eq.open(config);
                } else if (this.display_mode == 'popup') {
                  this.eq.popup(config);
                }

              case 2:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee8, this);
      }));

      function openContext(_x3) {
        return _openContext2.apply(this, arguments);
      }

      return openContext;
    }()
    /**
     * @param data
     * @param silent
     */

  }, {
    key: "closeContext",
    value: function () {
      var _closeContext2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee9() {
        var data,
            silent,
            _args10 = arguments;
        return _regenerator.default.wrap(function _callee9$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                data = _args10.length > 0 && _args10[0] !== undefined ? _args10[0] : null;
                silent = _args10.length > 1 && _args10[1] !== undefined ? _args10[1] : false;

                if (!(this.display_mode == 'stacked')) {
                  _context10.next = 7;
                  break;
                }

                _context10.next = 5;
                return this.eq.close({
                  target: this.domContainerSelector,
                  data: data,
                  silent: silent
                });

              case 5:
                _context10.next = 10;
                break;

              case 7:
                if (!(this.display_mode == 'popup')) {
                  _context10.next = 10;
                  break;
                }

                _context10.next = 10;
                return this.eq.popup_close({
                  data: data
                });

              case 10:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee9, this);
      }));

      function closeContext() {
        return _closeContext2.apply(this, arguments);
      }

      return closeContext;
    }()
    /**
     * Instanciate a new context and push it on the contexts stack (top-down).
     *
     * This method is meant to be called by the eventListener only (eQ object).
     *
     * @param config
     */

  }, {
    key: "_openContext",
    value: function () {
      var _openContext3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee10(config) {
        var environment, defaults, object, context, _iterator4, _step4, ctx;

        return _regenerator.default.wrap(function _callee10$(_context11) {
          while (1) {
            switch (_context11.prev = _context11.next) {
              case 0:
                console.debug('Frame::_openContext', config);
                _context11.next = 3;
                return _equalServices.EnvService.getEnv();

              case 3:
                environment = _context11.sent;
                // extend default params with received config
                config = _objectSpread(_objectSpread({}, {
                  entity: '',
                  type: 'list',
                  name: 'default',
                  domain: [],
                  mode: 'view',
                  // view, edit
                  purpose: 'view',
                  // view, select, add, create
                  lang: environment.lang,
                  locale: environment.locale,
                  callback: null
                }), config);

                if (config.hasOwnProperty('display_mode')) {
                  this.display_mode = config.display_mode;
                }

                if (config.hasOwnProperty('close_button')) {
                  this.close_button = config.close_button;
                } // if there is a current context, use its lang for the new context


                if (this.context.hasOwnProperty('$container')) {
                  config.lang = this.context.getLang();
                } // create a draft object if required: Edition is based on asynchronous creation: a draft is created (or recylcled) and is turned into an instance if 'update' action is triggered.


                if (!(config.purpose == 'create')) {
                  _context11.next = 17;
                  break;
                }

                console.debug('requesting draft object');
                _context11.next = 12;
                return this.getNewObjectDefaults(config.entity, config.domain);

              case 12:
                defaults = _context11.sent;
                _context11.next = 15;
                return _equalServices.ApiService.create(config.entity, defaults);

              case 15:
                object = _context11.sent;
                config.domain = [['id', '=', object.id], ['state', '=', 'draft']];

              case 17:
                context = new _equalLib.Context(this, config.entity, config.type, config.name, config.domain, config.mode, config.purpose, config.lang, config.callback, config); // stack current (previous) context

                this.stack.push(this.context);
                this.context = context;
                _context11.prev = 20;
                _context11.next = 23;
                return this.context.isReady();

              case 23:
                console.debug('context ready');
                _iterator4 = _createForOfIteratorHelper(this.stack);

                try {
                  for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
                    ctx = _step4.value;

                    if (ctx && typeof ctx.getContainer === 'function') {
                      // containers are hidden and not detached in order to maintain the listeners
                      ctx.getContainer().hide();
                    }
                  }
                } catch (err) {
                  _iterator4.e(err);
                } finally {
                  _iterator4.f();
                }

                (0, _jqueryLib.$)(this.domContainerSelector).append(this.context.getContainer()); // relay event to the outside

                (0, _jqueryLib.$)(this.domContainerSelector).show().trigger('_open', [{
                  context: config
                }]);
                this.updateHeader();
                _context11.next = 34;
                break;

              case 31:
                _context11.prev = 31;
                _context11.t0 = _context11["catch"](20);
                console.warn('unexpected error', _context11.t0);

              case 34:
              case "end":
                return _context11.stop();
            }
          }
        }, _callee10, this, [[20, 31]]);
      }));

      function _openContext(_x4) {
        return _openContext3.apply(this, arguments);
      }

      return _openContext;
    }()
  }, {
    key: "closeAll",
    value: function () {
      var _closeAll = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee11() {
        return _regenerator.default.wrap(function _callee11$(_context12) {
          while (1) {
            switch (_context12.prev = _context12.next) {
              case 0:
                if (!this.stack.length) {
                  _context12.next = 5;
                  break;
                }

                _context12.next = 3;
                return this.closeContext(null, true);

              case 3:
                _context12.next = 0;
                break;

              case 5:
                console.debug("Frame::closeAll - closed all contexts", this.context, this.stack);

              case 6:
              case "end":
                return _context12.stop();
            }
          }
        }, _callee11, this);
      }));

      function closeAll() {
        return _closeAll.apply(this, arguments);
      }

      return closeAll;
    }()
  }, {
    key: "_closeContext",
    value:
    /**
     * Handler for request for closing current context (top of stack).
     * When closing, a context might transmit some value (its the case, for instance, when selecting one or more records for m2m or o2m fields).
     *
     * This method is meant to be called by the eventListener only (eQ object).
     *
     * @param silent    If set to true, we do not show the pop-ed context and we do not refresh the header.
     */
    function () {
      var _closeContext3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee12() {
        var data,
            silent,
            _iterator5,
            _step5,
            ctx,
            _args13 = arguments;

        return _regenerator.default.wrap(function _callee12$(_context13) {
          while (1) {
            switch (_context13.prev = _context13.next) {
              case 0:
                data = _args13.length > 0 && _args13[0] !== undefined ? _args13[0] : null;
                silent = _args13.length > 1 && _args13[1] !== undefined ? _args13[1] : false;

                if (!this.stack.length) {
                  _context13.next = 14;
                  break;
                }

                if (this.context.hasChanged()) {
                  // mark all contexts in the stack as changed
                  _iterator5 = _createForOfIteratorHelper(this.stack);

                  try {
                    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
                      ctx = _step5.value;

                      if (ctx.hasOwnProperty('$container')) {
                        ctx.setChanged();
                      }
                    }
                  } catch (err) {
                    _iterator5.e(err);
                  } finally {
                    _iterator5.f();
                  }
                } // destroy current context and run callback, if any


                this.context.close(_objectSpread({
                  silent: silent
                }, data)); // restore previous context

                this.context = this.stack.pop();

                if (silent) {
                  _context13.next = 13;
                  break;
                }

                if (!(this.context && this.context.hasOwnProperty('$container'))) {
                  _context13.next = 12;
                  break;
                }

                if (!(this.context.hasChanged() && this.context.getMode() == 'view')) {
                  _context13.next = 11;
                  break;
                }

                _context13.next = 11;
                return this.context.refresh();

              case 11:
                this.context.$container.show();

              case 12:
                this.updateHeader();

              case 13:
                // if we closed the lastest Context from the stack, relay data to the outside
                // #todo - is this still necessary ? (since we run callbacks in eventlisteners)
                if (!this.stack.length) {// console.debug('Frame::_closeContext - stack empty, closing');
                  // $(this.domContainerSelector).hide().trigger('_close', [ data ]);
                }

              case 14:
              case "end":
                return _context13.stop();
            }
          }
        }, _callee12, this);
      }));

      function _closeContext() {
        return _closeContext3.apply(this, arguments);
      }

      return _closeContext;
    }()
  }, {
    key: "getDomContainer",
    value: function getDomContainer() {
      return (0, _jqueryLib.$)(this.domContainerSelector);
    }
  }]);
  return Frame;
}();

exports.Frame = Frame;
var _default = Frame;
exports.default = _default;

/***/ }),

/***/ "./build/Model.js":
/*!************************!*\
  !*** ./build/Model.js ***!
  \************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports.Model = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _jqueryLib = __webpack_require__(/*! ./jquery-lib */ "./build/jquery-lib.js");

var _equalServices = __webpack_require__(/*! ./equal-services */ "./build/equal-services.js");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Class for Model intercations
 * Acts like server-side Collection.class.php
 */
var Model = /*#__PURE__*/function () {
  // Collection (array) of objects (we use array to maintain objects order)
  // Map for keeping track of the fields that have been changed, on an object basis (keys are objects ids)
  // total objects matching the current domain on the back-end
  // Collecitons do not deal with lang: it is used from EnvService in ApiService
  function Model(view) {
    (0, _classCallCheck2.default)(this, Model);
    (0, _defineProperty2.default)(this, "view", void 0);
    (0, _defineProperty2.default)(this, "objects", void 0);
    (0, _defineProperty2.default)(this, "has_changed", void 0);
    (0, _defineProperty2.default)(this, "total", void 0);
    (0, _defineProperty2.default)(this, "loaded_promise", void 0);
    this.view = view;
    this.loaded_promise = _jqueryLib.$.Deferred();
    this.has_changed = {};
    this.objects = [];
    this.total = 0;
  }

  (0, _createClass2.default)(Model, [{
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return this.refresh();

              case 3:
                _context.next = 8;
                break;

              case 5:
                _context.prev = 5;
                _context.t0 = _context["catch"](0);
                console.warn('Something went wrong ', _context.t0);

              case 8:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 5]]);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }()
  }, {
    key: "deepCopy",
    value: function deepCopy(obj) {
      var copy; // Handle the 3 simple types, and null or undefined

      if (null == obj || "object" != typeof obj) return obj; // Handle Date

      if (obj instanceof Date) {
        copy = new Date();
        copy.setTime(obj.getTime());
        return copy;
      } // Handle Array


      if (obj instanceof Array) {
        copy = [];

        for (var i = 0, len = obj.length; i < len; i++) {
          copy[i] = this.deepCopy(obj[i]);
        }

        return copy;
      } // Handle Object


      if (obj instanceof Object) {
        copy = {};

        for (var attr in obj) {
          if (obj.hasOwnProperty(attr)) copy[attr] = this.deepCopy(obj[attr]);
        }

        return copy;
      }

      throw new Error("Unable to copy obj! Its type isn't supported.");
    }
    /**
     * Resolve the final type of a given field (handling 'alias' and 'computed').
     *
     * @param field
     * @returns string The final type. If final type cannot be resolved, the 'string' type is returned as default.
     */

  }, {
    key: "getFinalType",
    value: function getFinalType(field) {
      var result = 'string';
      var schema = this.view.getModelFields();

      if (schema) {
        while (schema.hasOwnProperty(field) && schema[field].hasOwnProperty('type') && schema[field].type == 'alias' && schema[field].hasOwnProperty('alias')) {
          field = schema[field].alias;
        }

        if (schema.hasOwnProperty(field) && schema[field].hasOwnProperty('type')) {
          if (schema[field].type == 'computed') {
            if (schema[field].hasOwnProperty('result_type')) {
              result = schema[field].result_type;
            }
          } else {
            result = schema[field].type;
          }
        }
      }

      return result;
    }
  }, {
    key: "getOperators",
    value: function getOperators(type) {
      var operators = {
        'boolean': ['=', '<>'],
        'integer': ['=', 'in', 'not in', '<>', '<', '>', '<=', '>='],
        'float': ['=', '<>', '<', '>', '<=', '>='],
        'string': ['like', 'in', '=', '<>'],
        'text': ['like', '='],
        'date': ['=', '<=', '>='],
        'time': ['=', '<=', '>='],
        'datetime': ['=', '<=', '>='],
        'file': ['like', '='],
        'binary': ['like', '='],
        'many2one': ['=', '<>'],
        'one2many': ['contains'],
        'many2many': ['contains']
      };
      return operators[type];
    }
  }, {
    key: "hasChanged",
    value: function hasChanged() {
      return Object.keys(this.has_changed).length > 0;
    }
  }, {
    key: "export",
    value: function _export(object) {
      console.debug('Model::export', object);
      var result = {};
      var schema = this.view.getModelFields();

      for (var field in schema) {
        if (!object.hasOwnProperty(field)) continue;
        var type = this.getFinalType(field);

        if (type == 'many2one') {
          if (typeof object[field] == 'object' && object[field]) {
            result[field] = object[field].id;
          } else {
            result[field] = object[field];
          }
        } else if (['one2many', 'many2many'].indexOf(type) > -1) {
          // #todo
          result[field] = object[field];
        } else {
          result[field] = object[field];
        }
      }

      return result;
    }
    /**
     * Update model by requesting data from server using parent View parameters
    */

  }, {
    key: "refresh",
    value: function () {
      var _refresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var full,
            view_fields,
            schema,
            fields,
            i,
            field,
            type,
            body,
            response,
            _args2 = arguments;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                full = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : false;
                console.debug('Model::refresh'); // fetch fields that are present in the parent View

                view_fields = Object.keys(this.view.getViewFields());
                schema = this.view.getModelFields();
                fields = [];
                _context2.t0 = _regenerator.default.keys(view_fields);

              case 6:
                if ((_context2.t1 = _context2.t0()).done) {
                  _context2.next = 16;
                  break;
                }

                i = _context2.t1.value;
                field = view_fields[i];

                if (!(!schema || !schema.hasOwnProperty(field))) {
                  _context2.next = 12;
                  break;
                }

                console.warn('unknown field', field);
                return _context2.abrupt("continue", 6);

              case 12:
                type = this.getFinalType(field); // append `name` subfield for relational fields, using the dot notation

                if ('many2one' == type) {
                  fields.push(field + '.name');
                } // we do not load relational fields, these can result in potentially long lists which are handled by the Widgets
                else if (['one2many', 'many2many'].indexOf(type) > -1) {
                    delete fields[i];
                  } else {
                    fields.push(field);
                  }

                _context2.next = 6;
                break;

              case 16:
                _context2.prev = 16;
                body = _objectSpread({
                  get: this.view.getController(),
                  entity: this.view.getEntity(),
                  fields: fields,
                  domain: this.view.getDomain()
                }, this.view.getParams()); // fetch objects using controller given by View (default is core_model_collect)

                _context2.next = 20;
                return _equalServices.ApiService.fetch('/', body);

              case 20:
                response = _context2.sent;
                this.total = _equalServices.ApiService.getLastCount();
                this.objects = response;
                this.loaded_promise.resolve();
                _context2.next = 32;
                break;

              case 26:
                _context2.prev = 26;
                _context2.t2 = _context2["catch"](16);
                console.warn('Unable to fetch Collection from server', _context2.t2);
                this.objects = [];
                this.loaded_promise.resolve();
                this.total = 0;

              case 32:
                _context2.next = 34;
                return this.view.onchangeModel(full);

              case 34:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this, [[16, 26]]);
      }));

      function refresh() {
        return _refresh.apply(this, arguments);
      }

      return refresh;
    }()
    /**
     * React to external request of Model change (one ore more objects in the collection have been updated through the Layout).
     * Changes are made on a field basis.
     *
     */

  }, {
    key: "change",
    value: function change(ids, values) {
      console.debug('Model::change', ids, values);
      var schema = this.view.getModelFields();

      for (var index in this.objects) {
        var object = this.objects[index];

        var _iterator = _createForOfIteratorHelper(ids),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var id = _step.value;

            if (object.hasOwnProperty('id') && object.id == id) {
              for (var field in values) {
                if (schema.hasOwnProperty(field)) {
                  if (!this.has_changed.hasOwnProperty(id)) {
                    this.has_changed[id] = [];
                  } // update field


                  this.objects[index][field] = values[field]; // mark field as changed

                  this.has_changed[id].push(field);
                }
              }
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    }
    /**
     * Handler for resetting change status and modified field of a given object, when an update occured and was accepted by server.
     *
     * @param id
     * @param values
     */

  }, {
    key: "reset",
    value: function reset(id, values) {
      console.debug('Model::reset', values);

      for (var index in this.objects) {
        var object = this.objects[index];

        if (object.hasOwnProperty('id') && object.id == id) {
          this.has_changed[id] = [];

          for (var field in values) {
            object[field] = values[field];
          }
        }
      }
    }
  }, {
    key: "ids",
    value: function ids() {
      if (this.objects.length == 0) {
        return [];
      }

      return this.objects.map(function (object) {
        return object.id;
      });
    }
    /**
     * Return the Collection.
     * The result set can be limited to a subset of specific objects by specifying an array of ids.
     *
     * @param ids array list of objects identifiers that must be returned
     */

  }, {
    key: "get",
    value: function get() {
      var _this = this;

      var ids = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      console.debug('Model::get', this.objects, this.has_changed);

      var promise = _jqueryLib.$.Deferred();

      this.loaded_promise.then(function () {
        if (ids.length) {
          // create a custom collection by filtering objects on their ids
          promise.resolve(_this.objects.filter(function (object) {
            return ids.indexOf(+object['id']) > -1;
          }));
        } else {
          // return the full collection
          promise.resolve(_this.objects);
        }
      }).catch(function () {
        return promise.resolve({});
      });
      return promise;
    }
    /**
     * Manually assign a list of objects from the current set (identified by their ids) to a given value (object).
     *
     * @param ids
     * @param object
     */

  }, {
    key: "set",
    value: function () {
      var _set = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3() {
        var _this2 = this;

        var ids,
            object,
            _iterator2,
            _step2,
            _loop,
            _args3 = arguments;

        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                ids = _args3.length > 0 && _args3[0] !== undefined ? _args3[0] : [];
                object = _args3.length > 1 ? _args3[1] : undefined;
                _iterator2 = _createForOfIteratorHelper(ids);

                try {
                  _loop = function _loop() {
                    var id = _step2.value;

                    var index = _this2.objects.findIndex(function (o) {
                      return o.id == id;
                    });

                    _this2.objects[index] = _this2.deepCopy(object);
                  };

                  for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                    _loop();
                  }
                } catch (err) {
                  _iterator2.e(err);
                } finally {
                  _iterator2.f();
                }

                _context3.next = 6;
                return this.view.onchangeModel();

              case 6:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function set() {
        return _set.apply(this, arguments);
      }

      return set;
    }()
    /**
     * Returns a collection holding only modified objects with their modified fields (not original objects).
     * The collection will be empty if no changes occured.
     *
     * @param ids array list of objects identifiers that must be returned (if changed)
     */

  }, {
    key: "getChanges",
    value: function getChanges() {
      var _this3 = this;

      var ids = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var collection = [];

      var _loop2 = function _loop2(id) {
        if (ids.length && ids.indexOf(+id) < 0) return "continue";
        var fields = _this3.has_changed[id];

        var object = _this3.objects.find(function (object) {
          return object.id == id;
        });

        if (object == undefined) return "continue";
        var result = {
          id: id
        };

        var _iterator3 = _createForOfIteratorHelper(fields),
            _step3;

        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var field = _step3.value;
            result[field] = object[field];
          } // force appending `state`and `modified` fields (when present) for concurrency control

        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }

        if (object.hasOwnProperty('modified')) {
          result['modified'] = object.modified;
        }

        if (object.hasOwnProperty('state')) {
          result['state'] = object.state;
        }

        collection.push(result);
      };

      for (var id in this.has_changed) {
        var _ret = _loop2(id);

        if (_ret === "continue") continue;
      }

      return collection;
    }
  }, {
    key: "getTotal",
    value: function getTotal() {
      return this.total;
    }
  }]);
  return Model;
}();

exports.Model = Model;
var _default = Model;
exports.default = _default;

/***/ }),

/***/ "./build/TranslationService.js":
/*!*************************************!*\
  !*** ./build/TranslationService.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports._TranslationService = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _equalServices = __webpack_require__(/*! ./equal-services */ "./build/equal-services.js");

var _jqueryLib = __webpack_require__(/*! ./jquery-lib */ "./build/jquery-lib.js");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * This service is in charge of loading the UI translations and provide getters to retrieve requested values.
 * It expects .json translation files in the /assets/i18n/ folder.
 *
 */
var _TranslationService = /*#__PURE__*/function () {
  // promise object
  // remember if the file fetching has been done
  function _TranslationService() {
    (0, _classCallCheck2.default)(this, _TranslationService);
    (0, _defineProperty2.default)(this, "translations", void 0);
    (0, _defineProperty2.default)(this, "resolved", void 0);
    this.resolved = null;
    this.init();
  }

  (0, _createClass2.default)(_TranslationService, [{
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var _this = this;

        var environment;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                this.translations = _jqueryLib.$.Deferred();
                this.resolved = false;
                _context.next = 4;
                return _equalServices.EnvService.getEnv();

              case 4:
                environment = _context.sent;
                // load i18n file from server
                fetch('/assets/i18n/' + environment.locale + '.json').then(function (response) {
                  if (response.ok) {
                    response.json().then(function (data) {
                      _this.resolved = data;

                      _this.translations.resolve(data);
                    });
                  } else {
                    _this.translations.resolve({});
                  }
                }).catch(function (err) {
                  console.warn('error fetch UI translation file');

                  _this.translations.resolve({});
                });

              case 6:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }()
    /**
     * Handle an asynchronous request for translation.
     *
     * @param   value    string       The string identifier to translate using current locale.
     * @returns Promise
     */

  }, {
    key: "translate",
    value: function () {
      var _translate = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(value) {
        var translation, translations;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                translation = '';
                _context2.prev = 1;
                _context2.next = 4;
                return this.translations;

              case 4:
                translations = _context2.sent;

                if (translations.hasOwnProperty(value)) {
                  translation = translations[value];
                }

                _context2.next = 10;
                break;

              case 8:
                _context2.prev = 8;
                _context2.t0 = _context2["catch"](1);

              case 10:
                return _context2.abrupt("return", translation);

              case 11:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this, [[1, 8]]);
      }));

      function translate(_x) {
        return _translate.apply(this, arguments);
      }

      return translate;
    }()
    /**
     * Handle instant request for translation (non-blocking).
     * If no value is found the given string is returned as result.
     *
     * @param   value   string
     * @returns string
     */

  }, {
    key: "instant",
    value: function instant(value) {
      var _default = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

      var translation = _default.length ? _default : value;

      if (this.resolved) {
        if (this.resolved.hasOwnProperty(value)) {
          translation = this.resolved[value];
        }
      }

      return translation;
    }
    /**
     * Helper method for resolution from a `translation` object (as provided by the ApiService)
     *
     * @param translation   Object holding the translations values (as returned by `ApiService::getTranslation()`).
     * @param type          Kind of terms we want to perform (''<root>, 'model','view','error').
     * @param path          An array describing the path to follow within the translation map, if any.
     * @param id            The identifier of the item we want to translate.
     * @param value         Default value, if any, to fall back to in case translation fails.
     * @param property      The translation section we're looking for, for the considered value ('label', 'help', ...).
     *
     * @returns The translated value, or the original value if translation fails.
     */

  }, {
    key: "resolve",
    value: function resolve(translation, type, path, id) {
      var value = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var property = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 'label';
      var result = value;

      if (typeof value === 'string' || value instanceof String) {
        result = value.charAt(0).toUpperCase() + value.replace(/_/g, ' ').slice(1);
      }

      if (type.length) {
        if (translation.hasOwnProperty(type)) {
          var map = translation[type];

          var _iterator = _createForOfIteratorHelper(path),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var elem = _step.value;

              if (map && map.hasOwnProperty(elem)) {
                map = map[elem];
              } else {
                break;
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }

          if (map && map.hasOwnProperty(id)) {
            if (map[id].hasOwnProperty(property)) {
              result = map[id][property];
            }
          }
        }
      } else {
        if (translation.hasOwnProperty(property)) {
          result = translation[property];
        }
      }

      return result;
    }
  }]);
  return _TranslationService;
}();

exports._TranslationService = _TranslationService;
var _default2 = _TranslationService;
exports.default = _default2;

/***/ }),

/***/ "./build/View.js":
/*!***********************!*\
  !*** ./build/View.js ***!
  \***********************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports.View = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/slicedToArray.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _jqueryLib = __webpack_require__(/*! ./jquery-lib */ "./build/jquery-lib.js");

var _materialLib = __webpack_require__(/*! ./material-lib */ "./build/material-lib.js");

var _equalServices = __webpack_require__(/*! ./equal-services */ "./build/equal-services.js");

var _equalLib = __webpack_require__(/*! ./equal-lib */ "./build/equal-lib.js");

var _equalWidgets = __webpack_require__(/*! ./equal-widgets */ "./build/equal-widgets.js");

var _equalLayouts = __webpack_require__(/*! ./equal-layouts */ "./build/equal-layouts.js");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var View = /*#__PURE__*/function () {
  // Mode under which the view is to be displayed ('View' [default], or 'edit')
  // Purpose for which the view is to be displayed (this impacts the action buttons in the header)
  // View holds the params for search requests performed by Model
  // associative array mapping additional params with their values (relayed to controller)
  // Map of fields mapping their View definitions
  // Map of fields mapping their Model definitions
  // Map of available filters from View definition mapping filters id with their definition
  // Map of available custom exports with their definition
  // custom actions of the view
  // config object for setting display of list controls and action buttons
  // List of currently selected filters from View definition (for filterable types)
  // When type is list, one or more objects might be selected

  /**
   *
   * @param entity    entity (package\Class) to be loaded: should be set only once (depend on the related view)
   * @param type      type of the view ('list', 'form', ...)
   * @param name      name of the view (eg. 'default')
   * @param domain    Array of conditions (disjunctions clauses of conjonctions conditions): predefined domain from the Context.
   * @param mode      ('view', 'edit')
   * @param purpose   ('view', 'select', 'add', 'create', 'update', 'widget')
   * @param lang
   * @param config    extra parameters related to contexts communications
   */
  function View(context, entity, type, name, domain, mode, purpose, lang) {
    var _this = this;

    var config = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : null;
    (0, _classCallCheck2.default)(this, View);
    (0, _defineProperty2.default)(this, "uuid", void 0);
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "entity", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "mode", void 0);
    (0, _defineProperty2.default)(this, "purpose", void 0);
    (0, _defineProperty2.default)(this, "domain", void 0);
    (0, _defineProperty2.default)(this, "order", void 0);
    (0, _defineProperty2.default)(this, "sort", void 0);
    (0, _defineProperty2.default)(this, "start", void 0);
    (0, _defineProperty2.default)(this, "limit", void 0);
    (0, _defineProperty2.default)(this, "group_by", void 0);
    (0, _defineProperty2.default)(this, "controller", void 0);
    (0, _defineProperty2.default)(this, "params", void 0);
    (0, _defineProperty2.default)(this, "lang", void 0);
    (0, _defineProperty2.default)(this, "layout", void 0);
    (0, _defineProperty2.default)(this, "model", void 0);
    (0, _defineProperty2.default)(this, "translation", void 0);
    (0, _defineProperty2.default)(this, "view_schema", void 0);
    (0, _defineProperty2.default)(this, "model_schema", void 0);
    (0, _defineProperty2.default)(this, "view_fields", void 0);
    (0, _defineProperty2.default)(this, "model_fields", void 0);
    (0, _defineProperty2.default)(this, "filters", void 0);
    (0, _defineProperty2.default)(this, "exports", void 0);
    (0, _defineProperty2.default)(this, "custom_actions", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "applied_filters_ids", void 0);
    (0, _defineProperty2.default)(this, "selected_ids", void 0);
    (0, _defineProperty2.default)(this, "subscribers", {});
    (0, _defineProperty2.default)(this, "is_ready_promise", void 0);
    (0, _defineProperty2.default)(this, "$container", void 0);
    (0, _defineProperty2.default)(this, "$headerContainer", void 0);
    (0, _defineProperty2.default)(this, "$layoutContainer", void 0);
    (0, _defineProperty2.default)(this, "$footerContainer", void 0);
    // generate a random UUID
    this.uuid = _materialLib.UIHelper.getUUID();
    this.params = {};
    this.context = context;
    this.entity = entity;
    this.type = type;
    this.name = name;
    this.domain = domain;
    this.mode = mode;
    this.purpose = purpose;
    this.lang = lang;
    this.is_ready_promise = _jqueryLib.$.Deferred(); // default config

    this.config = {
      show_actions: true,
      show_filter: true,
      show_pagination: true,
      // list of actions available for applying to a selection (relational fields widgets define their own actions)
      selection_actions: [{
        label: 'SB_ACTIONS_BUTTON_INLINE_UPDATE',
        icon: 'edit_attributes',
        primary: false,
        handler: function handler(selection, item) {
          return _this.actionListInlineEdit(selection);
        }
      }, {
        label: 'SB_ACTIONS_BUTTON_BULK_ASSIGN',
        icon: 'dynamic_form',
        primary: false,
        visible: false,
        handler: function handler(selection, item) {
          return _this.actionBulkAssign(selection);
        }
      }, {
        id: "action.update",
        label: 'SB_ACTIONS_BUTTON_UPDATE',
        icon: 'edit',
        primary: true,
        handler: function handler(selection, item) {
          var selected_id = selection[0];

          _this.openContext({
            entity: _this.entity,
            type: 'form',
            name: _this.name,
            domain: ['id', '=', selected_id],
            mode: 'edit',
            purpose: 'update'
          });
        }
      }, {
        label: 'SB_ACTIONS_BUTTON_CLONE',
        icon: 'content_copy',
        primary: false,
        handler: function () {
          var _handler = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(selection, item) {
            return _regenerator.default.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    _context.prev = 0;

                    // #todo - global loader: prevent any action (loader on context, frame, root)
                    // show loader
                    _this.layout.loading(true);

                    _context.next = 4;
                    return _equalServices.ApiService.clone(_this.entity, selection);

                  case 4:
                    // hide loader
                    _this.layout.loading(false); // refresh the model


                    _context.next = 7;
                    return _this.onchangeView();

                  case 7:
                    _context.next = 20;
                    break;

                  case 9:
                    _context.prev = 9;
                    _context.t0 = _context["catch"](0);
                    console.warn('unexpected error', _context.t0);
                    _context.prev = 12;
                    _context.next = 15;
                    return _this.displayErrorFeedback(_this.translation, _context.t0);

                  case 15:
                    _context.next = 20;
                    break;

                  case 17:
                    _context.prev = 17;
                    _context.t1 = _context["catch"](12);
                    console.warn(_context.t1);

                  case 20:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee, null, [[0, 9], [12, 17]]);
          }));

          function handler(_x, _x2) {
            return _handler.apply(this, arguments);
          }

          return handler;
        }()
      }, {
        label: 'SB_ACTIONS_BUTTON_ARCHIVE',
        icon: 'archive',
        primary: false,
        handler: function () {
          var _handler2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(selection, item) {
            var $dialog;
            return _regenerator.default.wrap(function _callee3$(_context3) {
              while (1) {
                switch (_context3.prev = _context3.next) {
                  case 0:
                    // display confirmation dialog with checkbox for archive
                    $dialog = _materialLib.UIHelper.createDialog('confirm_archive_dialog', _equalServices.TranslationService.instant('SB_ACTIONS_ARCHIVE_CONFIRM'), _equalServices.TranslationService.instant('SB_DIALOG_ACCEPT'), _equalServices.TranslationService.instant('SB_DIALOG_CANCEL'));
                    $dialog.addClass('sb-view-dialog').appendTo(_this.$container); // inject component as dialog content

                    _this.decorateDialogArchiveConfirm($dialog);

                    $dialog.trigger('_open').on('_ok', /*#__PURE__*/function () {
                      var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(event, result) {
                        return _regenerator.default.wrap(function _callee2$(_context2) {
                          while (1) {
                            switch (_context2.prev = _context2.next) {
                              case 0:
                                _context2.prev = 0;
                                _context2.next = 3;
                                return _equalServices.ApiService.archive(_this.entity, selection);

                              case 3:
                                _context2.next = 5;
                                return _this.onchangeView();

                              case 5:
                                _context2.next = 16;
                                break;

                              case 7:
                                _context2.prev = 7;
                                _context2.t0 = _context2["catch"](0);
                                _context2.prev = 9;
                                _context2.next = 12;
                                return _this.displayErrorFeedback(_this.translation, _context2.t0);

                              case 12:
                                _context2.next = 16;
                                break;

                              case 14:
                                _context2.prev = 14;
                                _context2.t1 = _context2["catch"](9);

                              case 16:
                              case "end":
                                return _context2.stop();
                            }
                          }
                        }, _callee2, null, [[0, 7], [9, 14]]);
                      }));

                      return function (_x5, _x6) {
                        return _ref.apply(this, arguments);
                      };
                    }());

                  case 4:
                  case "end":
                    return _context3.stop();
                }
              }
            }, _callee3);
          }));

          function handler(_x3, _x4) {
            return _handler2.apply(this, arguments);
          }

          return handler;
        }()
      }, {
        label: 'SB_ACTIONS_BUTTON_DELETE',
        icon: 'delete',
        primary: true,
        handler: function () {
          var _handler3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5(selection, item) {
            var $dialog;
            return _regenerator.default.wrap(function _callee5$(_context5) {
              while (1) {
                switch (_context5.prev = _context5.next) {
                  case 0:
                    // display confirmation dialog with checkbox for permanent deletion
                    $dialog = _materialLib.UIHelper.createDialog(_this.uuid + '_confirm-deletion-dialog', _equalServices.TranslationService.instant('SB_ACTIONS_DELETION_CONFIRM'), _equalServices.TranslationService.instant('SB_DIALOG_ACCEPT'), _equalServices.TranslationService.instant('SB_DIALOG_CANCEL'));
                    $dialog.addClass('sb-view-dialog').appendTo(_this.$container); // inject component as dialog content

                    _this.decorateDialogDeletionConfirm($dialog);

                    $dialog.trigger('_open').on('_ok', /*#__PURE__*/function () {
                      var _ref2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(event, result) {
                        return _regenerator.default.wrap(function _callee4$(_context4) {
                          while (1) {
                            switch (_context4.prev = _context4.next) {
                              case 0:
                                if (!result.confirm) {
                                  _context4.next = 17;
                                  break;
                                }

                                _context4.prev = 1;
                                _context4.next = 4;
                                return _equalServices.ApiService.delete(_this.entity, selection, false);

                              case 4:
                                _context4.next = 6;
                                return _this.onchangeView();

                              case 6:
                                _context4.next = 17;
                                break;

                              case 8:
                                _context4.prev = 8;
                                _context4.t0 = _context4["catch"](1);
                                _context4.prev = 10;
                                _context4.next = 13;
                                return _this.displayErrorFeedback(_this.translation, _context4.t0);

                              case 13:
                                _context4.next = 17;
                                break;

                              case 15:
                                _context4.prev = 15;
                                _context4.t1 = _context4["catch"](10);

                              case 17:
                              case "end":
                                return _context4.stop();
                            }
                          }
                        }, _callee4, null, [[1, 8], [10, 15]]);
                      }));

                      return function (_x9, _x10) {
                        return _ref2.apply(this, arguments);
                      };
                    }());

                  case 4:
                  case "end":
                    return _context5.stop();
                }
              }
            }, _callee5);
          }));

          function handler(_x7, _x8) {
            return _handler3.apply(this, arguments);
          }

          return handler;
        }()
      }] // selected_sections: {1: 2}

    }; // override config options, if other are given

    if (config) {
      this.config = _objectSpread(_objectSpread({}, this.config), config);
    }

    this.mode = this.config.hasOwnProperty('mode') ? this.config.mode : this.mode;
    this.controller = this.config.hasOwnProperty('controller') ? this.config.controller : 'model_collect';
    this.order = this.config.hasOwnProperty('order') ? this.config.order : 'id';
    this.sort = this.config.hasOwnProperty('sort') ? this.config.sort : 'asc';
    this.start = this.config.hasOwnProperty('start') ? this.config.start : 0;
    this.limit = this.config.hasOwnProperty('limit') ? this.config.limit : 25;
    this.group_by = this.config.hasOwnProperty('group_by') ? this.config.group_by : [];
    this.selected_ids = [];
    this.applied_filters_ids = [];
    this.filters = {};
    this.custom_actions = {};
    this.exports = {
      "export.pdf": {
        "id": "export.pdf",
        "label": _equalServices.TranslationService.instant('SB_EXPORTS_AS_PDF'),
        "icon": "print",
        "description": "Export as PDF",
        "controller": "model_export-pdf",
        "view": this.getId(),
        "domain": JSON.stringify(this.getDomain())
      },
      "export.xls": {
        "id": "export.xls",
        "label": _equalServices.TranslationService.instant('SB_EXPORTS_AS_XLS'),
        "icon": "print",
        "description": "Export as XLS",
        "controller": "model_export-xls",
        "view": this.getId()
      }
    };

    if (this.type == 'chart') {
      this.exports = {
        "export.xls": {
          "id": "export.xls",
          "label": _equalServices.TranslationService.instant('SB_EXPORTS_AS_XLS'),
          "icon": "print",
          "description": "Export as XLS",
          "controller": "model_export-chart-xls",
          "view": this.getId()
        }
      };
    }

    this.$container = (0, _jqueryLib.$)('<div />').addClass('sb-view').hide();
    this.$headerContainer = (0, _jqueryLib.$)('<div />').addClass('sb-view-header').appendTo(this.$container);
    this.$layoutContainer = (0, _jqueryLib.$)('<div />').addClass('sb-view-layout').appendTo(this.$container);
    this.$footerContainer = (0, _jqueryLib.$)('<div />').addClass('sb-view-footer').appendTo(this.$container);
    this.layout = _equalLayouts.LayoutFactory.getLayout(this);
    this.model = new _equalLib.Model(this);
    this.init();
  }

  (0, _createClass2.default)(View, [{
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee7() {
        var _this2 = this;

        var translation, model, view, _iterator, _step, item, _iterator2, _step2, _item, _i, _Object$entries, _Object$entries$_i, id, _item2, _i2, _Object$entries2, _Object$entries2$_i, _id, _item3, _iterator3, _step3, action, i, tmpDomain, _iterator4, _step4, clause, description, filter, domain, viewDomain, _tmpDomain;

        return _regenerator.default.wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                console.debug('View::init');
                _context7.prev = 1;
                _context7.next = 4;
                return _equalServices.ApiService.getTranslation(this.entity, this.getLocale());

              case 4:
                translation = _context7.sent;
                this.translation = this.deepCopy(translation);
                _context7.next = 8;
                return _equalServices.ApiService.getSchema(this.entity);

              case 8:
                model = _context7.sent;
                this.model_schema = this.deepCopy(model);
                _context7.next = 12;
                return _equalServices.ApiService.getView(this.entity, this.type + '.' + this.name);

              case 12:
                view = _context7.sent;

                if (Object.keys(view).length) {
                  _context7.next = 21;
                  break;
                }

                _context7.next = 16;
                return _equalServices.ApiService.getView(this.entity, this.type + '.default');

              case 16:
                view = _context7.sent;

                if (Object.keys(view).length) {
                  _context7.next = 20;
                  break;
                }

                console.warn("invalid view, stop processing");
                return _context7.abrupt("return");

              case 20:
                this.name = 'default';

              case 21:
                this.view_schema = this.deepCopy(view);
                this.loadViewFields(this.view_schema);
                this.loadModelFields(this.model_schema);

                if (this.view_schema.hasOwnProperty("order")) {
                  this.order = this.view_schema.order;
                }

                if (this.view_schema.hasOwnProperty("sort")) {
                  this.sort = this.view_schema.sort;
                }

                if (this.view_schema.hasOwnProperty("limit")) {
                  this.limit = +this.view_schema.limit;
                }

                if (this.view_schema.hasOwnProperty("group_by")) {
                  this.group_by = this.view_schema.group_by;
                } // predefined filters


                if (this.view_schema.hasOwnProperty("filters")) {
                  if (Array.isArray(this.view_schema.filters)) {
                    _iterator = _createForOfIteratorHelper(this.view_schema.filters);

                    try {
                      for (_iterator.s(); !(_step = _iterator.n()).done;) {
                        item = _step.value;
                        this.filters[item.id] = item;
                      }
                    } catch (err) {
                      _iterator.e(err);
                    } finally {
                      _iterator.f();
                    }
                  } else {
                    // 'filters' is set and is not an array (expected to be false)
                    this.config.show_filter = false;
                  }
                } // override of default controller


                if (this.view_schema.hasOwnProperty("controller")) {
                  this.controller = this.view_schema.controller;
                }

                if (this.view_schema.hasOwnProperty("mode")) {
                  this.mode = this.view_schema.mode;
                }

                if (this.view_schema.hasOwnProperty("exports")) {
                  _iterator2 = _createForOfIteratorHelper(this.view_schema.exports);

                  try {
                    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                      _item = _step2.value;
                      this.exports[_item.id] = _item;
                    }
                  } catch (err) {
                    _iterator2.e(err);
                  } finally {
                    _iterator2.f();
                  }
                } // #memo - actions handling differs from one view type to another (list, form, ...)


                if (this.view_schema.hasOwnProperty("header") && this.view_schema.header.hasOwnProperty("actions")) {
                  for (_i = 0, _Object$entries = Object.entries(this.view_schema.header.actions); _i < _Object$entries.length; _i++) {
                    _Object$entries$_i = (0, _slicedToArray2.default)(_Object$entries[_i], 2), id = _Object$entries$_i[0], _item2 = _Object$entries$_i[1];
                    this.custom_actions[id] = _item2;
                  }
                } // some custom actions might have been defined in the parent view, if so, override the view schema


                if (this.config.hasOwnProperty("header") && this.config.header.hasOwnProperty("actions")) {
                  for (_i2 = 0, _Object$entries2 = Object.entries(this.config.header.actions); _i2 < _Object$entries2.length; _i2++) {
                    _Object$entries2$_i = (0, _slicedToArray2.default)(_Object$entries2[_i2], 2), _id = _Object$entries2$_i[0], _item3 = _Object$entries2$_i[1];
                    this.custom_actions[_id] = _item3;
                  }
                } // support for custom selection_actions
                // expect a controller to which the selected_ids will be relayed, upon response the list is refreshed


                if (this.view_schema.hasOwnProperty('header') && this.view_schema.header.hasOwnProperty('selection')) {
                  if (this.view_schema.header.selection.hasOwnProperty('default') && !this.view_schema.header.selection.default) {
                    // remove default actions
                    this.config.selection_actions = [];
                  }

                  if (this.view_schema.header.selection.hasOwnProperty('actions')) {
                    _iterator3 = _createForOfIteratorHelper(this.view_schema.header.selection.actions);

                    try {
                      for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                        action = _step3.value;

                        action['handler'] = /*#__PURE__*/function () {
                          var _ref3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee6(selection, item) {
                            var result;
                            return _regenerator.default.wrap(function _callee6$(_context6) {
                              while (1) {
                                switch (_context6.prev = _context6.next) {
                                  case 0:
                                    if (!item.hasOwnProperty('controller')) {
                                      _context6.next = 11;
                                      break;
                                    }

                                    _context6.prev = 1;
                                    _context6.next = 4;
                                    return _equalServices.ApiService.call("/?do=" + item.controller, {
                                      entity: _this2.getEntity(),
                                      ids: selection,
                                      lang: _this2.getLang()
                                    });

                                  case 4:
                                    result = _context6.sent;

                                    _this2.onchangeView();

                                    _context6.next = 11;
                                    break;

                                  case 8:
                                    _context6.prev = 8;
                                    _context6.t0 = _context6["catch"](1);
                                    console.warn(_context6.t0);

                                  case 11:
                                  case "end":
                                    return _context6.stop();
                                }
                              }
                            }, _callee6, null, [[1, 8]]);
                          }));

                          return function (_x11, _x12) {
                            return _ref3.apply(this, arguments);
                          };
                        }();

                        this.config.selection_actions.push(action);
                      }
                    } catch (err) {
                      _iterator3.e(err);
                    } finally {
                      _iterator3.f();
                    }
                  }
                } // domain member is given by the context
                // if purpose is a non-widget list view then context domain is visible and can be changed by user
                // (otherwise, context domain is merged to view domain and cannot be changed by user)


                if (!(this.type == 'list' && this.purpose == 'view' && this.domain && Array.isArray(this.domain))) {
                  _context7.next = 61;
                  break;
                }

                i = 0;
                tmpDomain = new _equalLib.Domain(this.domain);
                _iterator4 = _createForOfIteratorHelper(tmpDomain.getClauses());
                _context7.prev = 39;

                _iterator4.s();

              case 41:
                if ((_step4 = _iterator4.n()).done) {
                  _context7.next = 52;
                  break;
                }

                clause = _step4.value;
                ++i;
                _context7.next = 46;
                return this.translateFilterClause(clause);

              case 46:
                description = _context7.sent;
                filter = {
                  "id": "filter_domain_" + i,
                  "label": "search",
                  "description": description,
                  "clause": clause.toArray()
                }; // add filter to applied filters

                this.filters[filter.id] = filter;
                this.applied_filters_ids.push(filter.id);

              case 50:
                _context7.next = 41;
                break;

              case 52:
                _context7.next = 57;
                break;

              case 54:
                _context7.prev = 54;
                _context7.t0 = _context7["catch"](39);

                _iterator4.e(_context7.t0);

              case 57:
                _context7.prev = 57;

                _iterator4.f();

                return _context7.finish(57);

              case 60:
                this.domain = [];

              case 61:
                // view schema specifies a domain
                // domain from the view is fixed, not visible, and cannot be changed by user
                if (this.view_schema.hasOwnProperty("domain")) {
                  // domain attribute is either a string or an array
                  domain = eval(this.view_schema.domain);
                  viewDomain = new _equalLib.Domain(domain); // assign domain to the view

                  if (this.purpose == 'view') {
                    this.domain = viewDomain.toArray();
                  } else {
                    // merge domains
                    _tmpDomain = new _equalLib.Domain(this.domain);
                    this.domain = _tmpDomain.merge(viewDomain).toArray();
                  }
                }

                if (['list', 'cards'].indexOf(this.type) >= 0) {
                  this.$layoutContainer.addClass('sb-view-layout-list');
                  this.layoutListHeader();
                  this.layoutListFooter();
                }

                if (['form'].indexOf(this.type) >= 0) {
                  this.$layoutContainer.addClass('sb-view-layout-form');
                  this.layoutFormHeader();
                }

                if (['chart'].indexOf(this.type) >= 0) {
                  if (this.mode == 'grid') {
                    this.layoutChartHeader();
                    this.$layoutContainer.addClass('sb-view-layout-list');
                  } else {
                    this.$layoutContainer.addClass('sb-view-layout-chart');
                  }
                }

                _context7.next = 67;
                return this.layout.init();

              case 67:
                _context7.next = 69;
                return this.model.init();

              case 69:
                _context7.next = 74;
                break;

              case 71:
                _context7.prev = 71;
                _context7.t1 = _context7["catch"](1);
                console.warn('Unable to init view (' + this.entity + '.' + this.getId() + ')', _context7.t1);

              case 74:
                this.is_ready_promise.resolve();
                this.$container.show();

              case 76:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this, [[1, 71], [39, 54, 57, 60]]);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }()
  }, {
    key: "deepCopy",
    value: function deepCopy(obj) {
      var copy; // Handle the 3 simple types, and null or undefined

      if (null == obj || "object" != typeof obj) return obj; // Handle Date

      if (obj instanceof Date) {
        copy = new Date();
        copy.setTime(obj.getTime());
        return copy;
      } // Handle Array


      if (obj instanceof Array) {
        copy = [];

        for (var i = 0, len = obj.length; i < len; i++) {
          copy[i] = this.deepCopy(obj[i]);
        }

        return copy;
      } // Handle Object


      if (obj instanceof Object) {
        copy = {};

        for (var attr in obj) {
          if (obj.hasOwnProperty(attr)) copy[attr] = this.deepCopy(obj[attr]);
        }

        return copy;
      }

      throw new Error("Unable to copy obj! Its type isn't supported.");
    }
  }, {
    key: "hasAdvancedFilters",
    value: function hasAdvancedFilters() {
      return ['core_model_collect', 'model_collect'].indexOf(this.controller) < 0;
    }
  }, {
    key: "addSubscriber",
    value: function addSubscriber(events, callback) {
      var _iterator5 = _createForOfIteratorHelper(events),
          _step5;

      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var event = _step5.value;

          // if(!['open', 'close', 'updated', 'navigate'].includes(event)) continue;
          if (!this.subscribers.hasOwnProperty(event)) {
            this.subscribers[event] = [];
          }

          this.subscribers[event].push(callback);
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }
    }
  }, {
    key: "isReady",
    value: function isReady() {
      return this.is_ready_promise;
    }
  }, {
    key: "getEnv",
    value: function getEnv() {
      return this.context.getEnv();
    }
  }, {
    key: "getContext",
    value: function getContext() {
      return this.context;
    }
  }, {
    key: "getUser",
    value: function getUser() {
      return this.context.getUser();
    }
    /**
     *
     * @returns Returns the identifier of the view (i.e. {type.name})
     */

  }, {
    key: "getId",
    value: function getId() {
      return this.type + '.' + this.name;
    }
  }, {
    key: "getUUID",
    value: function getUUID() {
      return this.uuid;
    }
  }, {
    key: "getCustomActions",
    value: function getCustomActions() {
      return this.custom_actions;
    }
    /**
     * Relay Context opening requests to parent Context.
     *
     * @param config
     */

  }, {
    key: "openContext",
    value: function () {
      var _openContext = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee8(config) {
        return _regenerator.default.wrap(function _callee8$(_context8) {
          while (1) {
            switch (_context8.prev = _context8.next) {
              case 0:
                console.debug('View::openContext', config);
                _context8.next = 3;
                return this.context.openContext(config);

              case 3:
              case "end":
                return _context8.stop();
            }
          }
        }, _callee8, this);
      }));

      function openContext(_x13) {
        return _openContext.apply(this, arguments);
      }

      return openContext;
    }()
  }, {
    key: "closeContext",
    value: function () {
      var _closeContext = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee9() {
        var data,
            silent,
            _args9 = arguments;
        return _regenerator.default.wrap(function _callee9$(_context9) {
          while (1) {
            switch (_context9.prev = _context9.next) {
              case 0:
                data = _args9.length > 0 && _args9[0] !== undefined ? _args9[0] : {};
                silent = _args9.length > 1 && _args9[1] !== undefined ? _args9[1] : false;
                _context9.next = 4;
                return this.context.closeContext(data, silent);

              case 4:
              case "end":
                return _context9.stop();
            }
          }
        }, _callee9, this);
      }));

      function closeContext() {
        return _closeContext.apply(this, arguments);
      }

      return closeContext;
    }()
    /**
     * Relay update notification (from View) to parent Frame.
     */

  }, {
    key: "updatedContext",
    value: function () {
      var _updatedContext = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee10() {
        return _regenerator.default.wrap(function _callee10$(_context10) {
          while (1) {
            switch (_context10.prev = _context10.next) {
              case 0:
                console.debug('View::updatedContext');
                _context10.next = 3;
                return this.context.updatedContext();

              case 3:
              case "end":
                return _context10.stop();
            }
          }
        }, _callee10, this);
      }));

      function updatedContext() {
        return _updatedContext.apply(this, arguments);
      }

      return updatedContext;
    }()
  }, {
    key: "getConfig",
    value: function getConfig() {
      return this.config;
    }
  }, {
    key: "setMode",
    value: function setMode(mode) {
      this.mode = mode;
    } // either the model or the view itself can be marked as change (to control the parent context refresh)

  }, {
    key: "hasChanged",
    value: function hasChanged() {
      return this.model.hasChanged();
    }
  }, {
    key: "getContainer",
    value: function getContainer() {
      return this.$container;
    }
  }, {
    key: "setField",
    value: function setField(field, value) {
      this.view_fields[field] = value;
    }
  }, {
    key: "getField",
    value: function getField(field) {
      return this.view_fields[field];
    }
  }, {
    key: "setSort",
    value: function setSort(sort) {
      this.sort = sort;
    }
  }, {
    key: "setOrder",
    value: function setOrder(order) {
      this.order = order;
    }
  }, {
    key: "setStart",
    value: function setStart(start) {
      this.start = start;
      ;
    }
  }, {
    key: "setLimit",
    value: function setLimit(limit) {
      this.limit = limit;
    }
  }, {
    key: "getEntity",
    value: function getEntity() {
      return this.entity;
    }
  }, {
    key: "getType",
    value: function getType() {
      return this.type;
    }
  }, {
    key: "getName",
    value: function getName() {
      return this.name;
    }
  }, {
    key: "getTranslation",
    value: function getTranslation() {
      return this.translation;
    }
  }, {
    key: "getViewSchema",
    value: function getViewSchema() {
      return this.view_schema;
    }
  }, {
    key: "getModelSchema",
    value: function getModelSchema() {
      return this.model_schema;
    }
    /**
     * Applicable domain for the View corresponds to initial domain (from parent Context) with additional filters currently applied on the View
     */

  }, {
    key: "getDomain",
    value: function getDomain() {
      console.debug('View::getDomain', this.domain, this.applied_filters_ids);
      var filters_domain = new _equalLib.Domain([]);

      var _iterator6 = _createForOfIteratorHelper(this.applied_filters_ids),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var filter_id = _step6.value;
          // filters clauses are cumulatives (conjunctions conditions)
          filters_domain.merge(new _equalLib.Domain(this.filters[filter_id].clause));
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      return new _equalLib.Domain(this.domain).merge(filters_domain).parse({}, this.getUser()).toArray();
    }
  }, {
    key: "getParams",
    value: function getParams() {
      return _objectSpread({
        lang: this.getLang(),
        order: this.getOrder(),
        sort: this.getSort(),
        start: this.getStart(),
        limit: this.getLimit()
      }, this.params);
    }
  }, {
    key: "getController",
    value: function getController() {
      return this.controller;
    }
  }, {
    key: "getSort",
    value: function getSort() {
      return this.sort;
    }
  }, {
    key: "getOrder",
    value: function getOrder() {
      return this.order;
    }
  }, {
    key: "getStart",
    value: function getStart() {
      return +this.start;
    }
  }, {
    key: "getLimit",
    value: function getLimit() {
      return +this.limit;
    }
  }, {
    key: "getGroupBy",
    value: function getGroupBy() {
      return this.group_by;
    }
  }, {
    key: "getLang",
    value: function getLang() {
      return this.lang;
    }
  }, {
    key: "getLocale",
    value: function getLocale() {
      return this.config.locale;
    }
  }, {
    key: "getTotal",
    value: function getTotal() {
      return this.getModel().getTotal();
    }
  }, {
    key: "getModel",
    value: function getModel() {
      return this.model;
    }
  }, {
    key: "getLayout",
    value: function getLayout() {
      return this.layout;
    }
  }, {
    key: "getMode",
    value: function getMode() {
      return this.mode;
    }
  }, {
    key: "getPurpose",
    value: function getPurpose() {
      return this.purpose;
    }
    /**
     * Returns an associative array mapping fields names with their layout definition
     */

  }, {
    key: "getViewFields",
    value: function getViewFields() {
      return this.view_fields;
    }
    /**
     * Returns an associative array mapping fields names with their model definition
     */

  }, {
    key: "getModelFields",
    value: function getModelFields() {
      return this.model_fields;
    }
    /**
     * Generates a map holding all fields (as items objects) that are present in a given view
     * and stores them in the `view_fields` map (does not maintain the field order)
     */

  }, {
    key: "loadViewFields",
    value: function loadViewFields(view_schema) {
      console.debug('View::loadFields', view_schema);
      this.view_fields = {};
      var stack = []; // view is valid

      if (view_schema.hasOwnProperty('layout')) {
        stack.push(view_schema['layout']);
        var path = ['groups', 'sections', 'rows', 'columns'];

        while (stack.length) {
          var elem = stack.pop();

          if (elem.hasOwnProperty('items')) {
            var _iterator7 = _createForOfIteratorHelper(elem['items']),
                _step7;

            try {
              for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
                var item = _step7.value;

                if (item.type == 'field' && item.hasOwnProperty('value')) {
                  this.view_fields[item.value] = item;
                }
              }
            } catch (err) {
              _iterator7.e(err);
            } finally {
              _iterator7.f();
            }
          } else {
            var _iterator8 = _createForOfIteratorHelper(path),
                _step8;

            try {
              for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
                var step = _step8.value;

                if (elem.hasOwnProperty(step)) {
                  var _iterator9 = _createForOfIteratorHelper(elem[step]),
                      _step9;

                  try {
                    for (_iterator9.s(); !(_step9 = _iterator9.n()).done;) {
                      var obj = _step9.value;
                      stack.push(obj);
                    }
                  } catch (err) {
                    _iterator9.e(err);
                  } finally {
                    _iterator9.f();
                  }
                }
              }
            } catch (err) {
              _iterator8.e(err);
            } finally {
              _iterator8.f();
            }
          }
        }
      }
    }
    /**
     * Generates a map holding all fields in the current model schema
     * and stores it in the `model_fields` member
     */

  }, {
    key: "loadModelFields",
    value: function loadModelFields(model_schema) {
      console.debug('View::loadVModelFields', model_schema);
      this.model_fields = model_schema.fields;
    }
  }, {
    key: "layoutListFooter",
    value: function layoutListFooter() {// it is best UX practice to avoid footer on lists
    }
  }, {
    key: "layoutListHeader",
    value: function layoutListHeader() {
      var _this3 = this;

      console.debug('View::layoutListHeader'); // apend header structure

      this.$headerContainer.append(' \
            <div class="sb-view-header-list"> \
                <div class="sb-view-header-actions"></div> \
                <div class="sb-view-header-advanced"></div> \
                <div class="sb-view-header-list-navigation"></div> \
            </div>');
      var $elem = this.$headerContainer.find('.sb-view-header-list');
      var $actions_set = $elem.find('.sb-view-header-actions');
      var $level1 = $elem.find('.sb-view-header-advanced');
      var $level2 = $elem.find('.sb-view-header-list-navigation'); // left side : standard actions for views

      var $std_actions = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-actions-std').appendTo($actions_set); // right side : the actions specific to the view, and depenging on object status

      var $view_actions = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-actions-view').appendTo($actions_set);
      var has_action_create = true;
      var has_action_select = true;

      if (this.custom_actions.hasOwnProperty('ACTION.SELECT')) {
        has_action_select = this.custom_actions['ACTION.SELECT'] ? true : false;
      }

      if (this.custom_actions.hasOwnProperty('ACTION.CREATE')) {
        has_action_create = this.custom_actions['ACTION.CREATE'] ? true : false;
      } // append view actions, if requested


      if (this.config.show_actions) {
        switch (this.purpose) {
          case 'view':
            if (has_action_create) {
              $std_actions.prepend(_materialLib.UIHelper.createButton(this.uuid + '_action-edit', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_CREATE'), 'raised').on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee11() {
                var view_type, view_name, domain, custom_action_create, parts, tmpDomain;
                return _regenerator.default.wrap(function _callee11$(_context11) {
                  while (1) {
                    switch (_context11.prev = _context11.next) {
                      case 0:
                        _context11.prev = 0;
                        view_type = 'form';
                        view_name = _this3.name;
                        domain = _this3.getDomain();

                        if (_this3.custom_actions.hasOwnProperty('ACTION.CREATE')) {
                          if (Array.isArray(_this3.custom_actions['ACTION.CREATE']) && _this3.custom_actions['ACTION.CREATE'].length) {
                            custom_action_create = _this3.custom_actions['ACTION.CREATE'][0];

                            if (custom_action_create.hasOwnProperty('view')) {
                              parts = custom_action_create.view.split('.');
                              if (parts.length) view_type = parts.shift();
                              if (parts.length) view_name = parts.shift();
                            }

                            if (custom_action_create.hasOwnProperty('domain')) {
                              tmpDomain = new _equalLib.Domain(domain);
                              tmpDomain.merge(new _equalLib.Domain(custom_action_create['domain']));
                              domain = tmpDomain.toArray();
                            }
                          }
                        } // request a new Context for editing a new object


                        _context11.next = 7;
                        return _this3.openContext({
                          entity: _this3.entity,
                          type: view_type,
                          name: view_name,
                          domain: domain,
                          mode: 'edit',
                          purpose: 'create'
                        });

                      case 7:
                        _context11.next = 18;
                        break;

                      case 9:
                        _context11.prev = 9;
                        _context11.t0 = _context11["catch"](0);
                        _context11.prev = 11;
                        _context11.next = 14;
                        return _this3.displayErrorFeedback(_this3.translation, _context11.t0);

                      case 14:
                        _context11.next = 18;
                        break;

                      case 16:
                        _context11.prev = 16;
                        _context11.t1 = _context11["catch"](11);

                      case 18:
                      case "end":
                        return _context11.stop();
                    }
                  }
                }, _callee11, null, [[0, 9], [11, 16]]);
              }))));
            }

            break;

          case 'select':
            if (has_action_create) {
              $std_actions.prepend(_materialLib.UIHelper.createButton(this.uuid + '_action-create', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_CREATE'), 'text').on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee12() {
                return _regenerator.default.wrap(function _callee12$(_context12) {
                  while (1) {
                    switch (_context12.prev = _context12.next) {
                      case 0:
                        _context12.prev = 0;
                        _context12.next = 3;
                        return _this3.openContext({
                          entity: _this3.entity,
                          type: 'form',
                          name: _this3.name,
                          domain: _this3.getDomain(),
                          mode: 'edit',
                          purpose: 'create'
                        });

                      case 3:
                        _context12.next = 14;
                        break;

                      case 5:
                        _context12.prev = 5;
                        _context12.t0 = _context12["catch"](0);
                        _context12.prev = 7;
                        _context12.next = 10;
                        return _this3.displayErrorFeedback(_this3.translation, _context12.t0);

                      case 10:
                        _context12.next = 14;
                        break;

                      case 12:
                        _context12.prev = 12;
                        _context12.t1 = _context12["catch"](7);

                      case 14:
                      case "end":
                        return _context12.stop();
                    }
                  }
                }, _callee12, null, [[0, 5], [7, 12]]);
              }))));
            }

            if (has_action_select) {
              $std_actions.prepend(_materialLib.UIHelper.createButton(this.uuid + '_action-select', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_SELECT'), 'raised', 'check').on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee13() {
                var objects;
                return _regenerator.default.wrap(function _callee13$(_context13) {
                  while (1) {
                    switch (_context13.prev = _context13.next) {
                      case 0:
                        _context13.next = 2;
                        return _this3.model.get(_this3.selected_ids);

                      case 2:
                        objects = _context13.sent;

                        _this3.closeContext({
                          selection: _this3.selected_ids,
                          objects: objects
                        });

                      case 4:
                      case "end":
                        return _context13.stop();
                    }
                  }
                }, _callee13);
              }))));
            }

            break;

          case 'add':
            if (has_action_create) {
              $std_actions.prepend(_materialLib.UIHelper.createButton(this.uuid + '_action-create', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_CREATE'), 'text').on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee14() {
                return _regenerator.default.wrap(function _callee14$(_context14) {
                  while (1) {
                    switch (_context14.prev = _context14.next) {
                      case 0:
                        _context14.prev = 0;
                        _context14.next = 3;
                        return _this3.openContext({
                          entity: _this3.entity,
                          type: 'form',
                          name: _this3.name,
                          domain: _this3.getDomain(),
                          mode: 'edit',
                          purpose: 'create'
                        });

                      case 3:
                        _context14.next = 14;
                        break;

                      case 5:
                        _context14.prev = 5;
                        _context14.t0 = _context14["catch"](0);
                        _context14.prev = 7;
                        _context14.next = 10;
                        return _this3.displayErrorFeedback(_this3.translation, _context14.t0);

                      case 10:
                        _context14.next = 14;
                        break;

                      case 12:
                        _context14.prev = 12;
                        _context14.t1 = _context14["catch"](7);

                      case 14:
                      case "end":
                        return _context14.stop();
                    }
                  }
                }, _callee14, null, [[0, 5], [7, 12]]);
              }))));
            }

            if (has_action_select) {
              $std_actions.prepend(_materialLib.UIHelper.createButton(this.uuid + '_action-add', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_ADD'), 'raised', 'check').on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee15() {
                var objects;
                return _regenerator.default.wrap(function _callee15$(_context15) {
                  while (1) {
                    switch (_context15.prev = _context15.next) {
                      case 0:
                        _context15.next = 2;
                        return _this3.model.get(_this3.selected_ids);

                      case 2:
                        objects = _context15.sent;

                        _this3.closeContext({
                          selection: _this3.selected_ids,
                          objects: objects
                        });

                      case 4:
                      case "end":
                        return _context15.stop();
                    }
                  }
                }, _callee15);
              }))));
            }

            break;

          case 'widget': // no buttons are displayed for widgets : these are handled at the widget level, since a callback must be set to fetch the resulting value

          default:
            break;
        }
      } // append advanced layout if requested


      if (this.hasAdvancedFilters()) {
        $elem.addClass('has-advanced-filters');
        var $layout = (0, _jqueryLib.$)('<div class="sb-view-header-advanced-layout" />').appendTo($level1);
        var view = new View(this.getContext(), this.controller.replace(/_/g, '\\'), 'search', 'default', [], 'edit', 'widget', this.lang, {});
        view.isReady().then(function () {
          var $container = view.getContainer();
          $layout.append($container); // detect view submission / change

          view.addSubscriber(['change'], /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee16() {
            var model, objects, object, field, value;
            return _regenerator.default.wrap(function _callee16$(_context16) {
              while (1) {
                switch (_context16.prev = _context16.next) {
                  case 0:
                    // retrieve model of the view
                    model = view.getModel();
                    _context16.next = 3;
                    return model.get();

                  case 3:
                    objects = _context16.sent;
                    object = objects[0]; // inject object as part of parent View's body for the Model service

                    for (field in object) {
                      value = object[field];

                      if (typeof value == 'object' && value !== null) {
                        value = value.id;
                      }

                      _this3.params[field] = value;
                    } // trigger a refresh of the current view


                    _this3.onchangeView();

                  case 7:
                  case "end":
                    return _context16.stop();
                }
              }
            }, _callee16);
          })));
        });
      } //  bulk assign action


      var $bulk_assign_dialog = _materialLib.UIHelper.createDialog(this.uuid + '_bulk-assign-dialog', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_BULK_ASSIGN'), _equalServices.TranslationService.instant('SB_DIALOG_ACCEPT'), _equalServices.TranslationService.instant('SB_DIALOG_CANCEL'));

      $bulk_assign_dialog.addClass('sb-view-dialog').appendTo(this.$container); // inject component as dialog content

      this.decorateBulkAssignDialog($bulk_assign_dialog); // container for holding chips of currently applied filters

      var $filters_set = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-list-filters-set mdc-chip-set').attr('role', 'grid'); // for creating a quick filter based on name

      var $filters_search = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-list-filters-search');

      var $search_input = _materialLib.UIHelper.createInput('sb-view-header-search', _equalServices.TranslationService.instant('SB_FILTERS_SEARCH'), '', '', '', false, 'outlined', 'close').appendTo($filters_search);

      $search_input.addClass('dialog-select').find('.mdc-text-field__icon').on('click', /*#__PURE__*/function () {
        var _ref10 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee17(e) {
          return _regenerator.default.wrap(function _callee17$(_context17) {
            while (1) {
              switch (_context17.prev = _context17.next) {
                case 0:
                  // reset input value
                  $search_input.find('input').val('').trigger('focus').trigger('blur'); // unapply related filter

                  _context17.next = 3;
                  return _this3.unapplyFilter('filter_search_on_name');

                case 3:
                case "end":
                  return _context17.stop();
              }
            }
          }, _callee17);
        }));

        return function (_x14) {
          return _ref10.apply(this, arguments);
        };
      }());
      $search_input.on('keypress', function (e) {
        if (e.key == 'Enter') $search_input.find('input').trigger('blur');
      });
      $search_input.find('input').on('blur', function (e) {
        setTimeout(function () {
          var value = String($search_input.find('input').val()).trim();

          if (value.length) {
            var filter = {
              "id": "filter_search_on_name",
              "label": "search",
              "description": _equalServices.TranslationService.instant('SB_FILTERS_SEARCH_ON_NAME'),
              "clause": ['name', 'ilike', '%' + value + '%']
            }; // add filter to available filters

            _this3.filters[filter.id] = filter;

            _this3.applyFilter(filter.id);
          }
        }, 100);
      });
      var $advanced_filters_button = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-advanced-filters-button').append(_materialLib.UIHelper.createButton(this.getUUID() + '-advanced-filters', 'filters', 'icon', 'chevron_right')).prependTo($level1);
      $advanced_filters_button.on('click', function () {
        $elem.toggleClass('is-advanced-open');

        var head_height = _this3.$headerContainer.height();

        _this3.$layoutContainer.css({
          height: 'calc(100% - ' + head_height + 'px)'
        });
      }); // fields toggle menu : button for displaying the filters menu

      var $filters_button = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-filters mdc-menu-surface--anchor').append(_materialLib.UIHelper.createButton('view-filters', 'filters', 'icon', 'filter_list')); // create floating menu for filters selection

      var $filters_menu = _materialLib.UIHelper.createMenu('filters-menu').addClass('sb-view-header-list-filters-menu').appendTo($filters_button);

      var $filters_list = _materialLib.UIHelper.createList('filters-list').appendTo($filters_menu); // generate filters list


      var _loop = function _loop(filter_id) {
        var filter = _this3.filters[filter_id];

        _materialLib.UIHelper.createListItem(filter_id, filter.description).appendTo($filters_list).on('click', function (event) {
          _this3.applyFilter(filter_id);
        });
      };

      for (var filter_id in this.filters) {
        _loop(filter_id);
      } // append additional option for custom filter


      if (Object.keys(this.filters).length) {
        _materialLib.UIHelper.createListDivider().appendTo($filters_list);
      }

      var $custom_filter_dialog = _materialLib.UIHelper.createDialog(this.uuid + '_custom-filter-dialog', _equalServices.TranslationService.instant('SB_FILTERS_ADD_CUSTOM_FILTER'), _equalServices.TranslationService.instant('SB_DIALOG_ACCEPT'), _equalServices.TranslationService.instant('SB_DIALOG_CANCEL'));

      $custom_filter_dialog.addClass('sb-view-dialog').appendTo(this.$container); // inject component as dialog content

      this.decorateCustomFilterDialog($custom_filter_dialog);

      _materialLib.UIHelper.createListItem('SB_FILTERS_ADD_CUSTOM_FILTER', _equalServices.TranslationService.instant('SB_FILTERS_ADD_CUSTOM_FILTER')).appendTo($filters_list).on('click', function (event) {
        return $custom_filter_dialog.trigger('_open');
      });

      _materialLib.UIHelper.decorateMenu($filters_menu);

      $filters_button.find('button').on('click', function () {
        return $filters_menu.trigger('_toggle');
      }); // fields toggle menu : button for displaying the fields menu

      var $fields_toggle_button = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-fields_toggle mdc-menu-surface--anchor').append(_materialLib.UIHelper.createButton('view-filters', 'fields', 'icon', 'more_vert')); // create floating menu for fields selection

      var $fields_toggle_menu = _materialLib.UIHelper.createMenu('fields-menu').addClass('sb-view-header-list-fields_toggle-menu').appendTo($fields_toggle_button);

      var $fields_toggle_list = _materialLib.UIHelper.createList('fields-list').appendTo($fields_toggle_menu); // #todo : translate fields names


      var _iterator10 = _createForOfIteratorHelper(this.getViewSchema().layout.items),
          _step10;

      try {
        var _loop2 = function _loop2() {
          var item = _step10.value;
          var label = item.hasOwnProperty('label') ? item.label : item.value.charAt(0).toUpperCase() + item.value.slice(1);
          var visible = item.hasOwnProperty('visible') ? item.visible : true;

          _materialLib.UIHelper.createListItemCheckbox('sb-fields-toggle-checkbox-' + item.value, label).appendTo($fields_toggle_list).find('input').on('change', function (event) {
            var $this = (0, _jqueryLib.$)(event.currentTarget);

            var def = _this3.getField(item.value);

            def.visible = $this.prop('checked');

            _this3.setField(item.value, def);

            _this3.onchangeModel(true);
          }).prop('checked', visible);
        };

        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
          _loop2();
        }
      } catch (err) {
        _iterator10.e(err);
      } finally {
        _iterator10.f();
      }

      _materialLib.UIHelper.decorateMenu($fields_toggle_menu);

      $fields_toggle_button.find('button').on('click', function () {
        return $fields_toggle_menu.trigger('_toggle');
      }); // pagination controls

      var $pagination = _materialLib.UIHelper.createPagination().addClass('sb-view-header-list-pagination');

      var $refresh_list_button = _materialLib.UIHelper.createButton('refresh-view', 'refresh', 'icon', 'refresh').on('click', function () {
        return _this3.onchangeView();
      });

      $pagination.find('.pagination-container').prepend($refresh_list_button);
      $pagination.find('.pagination-total').append((0, _jqueryLib.$)('<span class="sb-view-header-list-pagination-start"></span>')).append((0, _jqueryLib.$)('<span />').text('-')).append((0, _jqueryLib.$)('<span class="sb-view-header-list-pagination-end"></span>')).append((0, _jqueryLib.$)('<span />').text(' / ')).append((0, _jqueryLib.$)('<span class="sb-view-header-list-pagination-total"></span>'));
      $pagination.find('.pagination-navigation').append(_materialLib.UIHelper.createButton('', '', 'icon', 'first_page').addClass('sb-view-header-list-pagination-first_page').on('click', function (event) {
        _this3.setStart(0);

        _this3.onchangeView();
      })).append(_materialLib.UIHelper.createButton('', '', 'icon', 'chevron_left').addClass('sb-view-header-list-pagination-prev_page').on('click', function (event) {
        _this3.setStart(Math.max(0, _this3.getStart() - _this3.getLimit()));

        _this3.onchangeView();
      })).append(_materialLib.UIHelper.createButton('', '', 'icon', 'chevron_right').addClass('sb-view-header-list-pagination-next_page').on('click', function (event) {
        var new_start = Math.min(_this3.getTotal() - 1, _this3.getStart() + _this3.getLimit());

        _this3.setStart(new_start);

        _this3.onchangeView();
      })).append(_materialLib.UIHelper.createButton('', '', 'icon', 'last_page').addClass('sb-view-header-list-pagination-last_page').on('click', function (event) {
        var new_start = _this3.getTotal() - 1;

        _this3.setStart(new_start);

        _this3.onchangeView();
      }));

      var $select = _materialLib.UIHelper.createPaginationSelect('', '', [5, 10, 25, 50, 100, 500], this.limit).addClass('sb-view-header-list-pagination-limit_select');

      $pagination.find('.pagination-rows-per-page').append($select);
      $select.find('input').on('change', function (event) {
        var $this = (0, _jqueryLib.$)(event.currentTarget);

        _this3.setLimit($this.val());

        _this3.setStart(0);

        _this3.onchangeView();
      });

      if (this.config.show_filter) {
        $level2.append($filters_button);
        $level2.append($filters_search);
        $level2.append($filters_set); // show pre-applied filters (@see init())

        var _iterator11 = _createForOfIteratorHelper(this.applied_filters_ids),
            _step11;

        try {
          for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
            var _filter_id = _step11.value;
            this.showFilter(_filter_id);
          }
        } catch (err) {
          _iterator11.e(err);
        } finally {
          _iterator11.f();
        }
      }

      $level2.append($pagination);
      $level2.append($fields_toggle_button);
      this.$headerContainer.append($elem);
    }
  }, {
    key: "layoutChartHeader",
    value: function layoutChartHeader() {
      var _this4 = this;

      console.debug('View::layoutChartHeader'); // apend header structure

      this.$headerContainer.append(' \
            <div class="sb-view-header-list"> \
                <div class="sb-view-header-actions"></div> \
                <div class="sb-view-header-advanced"></div> \
                <div class="sb-view-header-list-navigation"></div> \
            </div>');
      var $elem = this.$headerContainer.find('.sb-view-header-list');
      var $actions_set = $elem.find('.sb-view-header-actions');
      var $level1 = $elem.find('.sb-view-header-advanced');
      var $level2 = $elem.find('.sb-view-header-list-navigation'); // left side : standard actions for views

      var $std_actions = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-actions-std').appendTo($actions_set); // right side : the actions specific to the view, and depenging on object status

      var $view_actions = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-actions-view').appendTo($actions_set); // append advanced layout if requested

      if (this.hasAdvancedFilters()) {
        $elem.addClass('has-advanced-filters');
        var $layout = (0, _jqueryLib.$)('<div class="sb-view-header-advanced-layout" />').appendTo($level1);
        var view = new View(this.getContext(), this.controller.replace(/_/g, '\\'), 'search', 'default', [], 'edit', 'widget', this.lang, {});
        view.isReady().then(function () {
          var $container = view.getContainer();
          $layout.append($container); // detect view submission / change

          view.addSubscriber(['change'], /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee18() {
            var model, objects, object, field, value;
            return _regenerator.default.wrap(function _callee18$(_context18) {
              while (1) {
                switch (_context18.prev = _context18.next) {
                  case 0:
                    // retrieve model of the view
                    model = view.getModel();
                    _context18.next = 3;
                    return model.get();

                  case 3:
                    objects = _context18.sent;
                    object = objects[0]; // inject object as part of parent View's body for the Model service

                    for (field in object) {
                      value = object[field];

                      if (typeof value == 'object' && value !== null) {
                        value = value.id;
                      }

                      _this4.params[field] = value;
                    } // trigger a refresh of the current view


                    _this4.onchangeView();

                  case 7:
                  case "end":
                    return _context18.stop();
                }
              }
            }, _callee18);
          })));
        });
      }

      var $advanced_filters_button = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-advanced-filters-button').append(_materialLib.UIHelper.createButton(this.getUUID() + '-advanced-filters', 'filters', 'icon', 'chevron_right')).prependTo($level1);
      $advanced_filters_button.on('click', function () {
        $elem.toggleClass('is-advanced-open');

        var head_height = _this4.$headerContainer.height();

        _this4.$layoutContainer.css({
          height: 'calc(100% - ' + head_height + 'px)'
        });
      }); // container for holding chips of currently applied filters

      var $filters_set = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-list-filters-set mdc-chip-set').attr('role', 'grid'); // fields toggle menu : button for displaying the filters menu

      var $filters_button = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-filters mdc-menu-surface--anchor').append(_materialLib.UIHelper.createButton('view-filters', 'filters', 'icon', 'filter_list')); // create floating menu for filters selection

      var $filters_menu = _materialLib.UIHelper.createMenu('filters-menu').addClass('sb-view-header-list-filters-menu').appendTo($filters_button);

      var $filters_list = _materialLib.UIHelper.createList('filters-list').appendTo($filters_menu); // generate filters list


      var _loop3 = function _loop3(filter_id) {
        var filter = _this4.filters[filter_id];

        _materialLib.UIHelper.createListItem(filter_id, filter.description).appendTo($filters_list).on('click', function (event) {
          _this4.applyFilter(filter_id);
        });
      };

      for (var filter_id in this.filters) {
        _loop3(filter_id);
      } // append additional option for custom filter


      if (Object.keys(this.filters).length) {
        _materialLib.UIHelper.createListDivider().appendTo($filters_list);
      }

      if (this.config.show_filter) {
        $level2.append($filters_button);
        $level2.append($filters_set); // show pre-applied filters (@see init())

        var _iterator12 = _createForOfIteratorHelper(this.applied_filters_ids),
            _step12;

        try {
          for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
            var _filter_id2 = _step12.value;
            this.showFilter(_filter_id2);
          }
        } catch (err) {
          _iterator12.e(err);
        } finally {
          _iterator12.f();
        }
      } // pagination controls


      var $pagination = _materialLib.UIHelper.createPagination().addClass('sb-view-header-list-pagination');

      var $refresh_list_button = _materialLib.UIHelper.createButton(this.getUUID() + '-refresh-view', 'refresh', 'icon', 'refresh').on('click', function () {
        return _this4.onchangeView();
      });

      var $switch_grid_button = _materialLib.UIHelper.createButton(this.getUUID() + 'switch-view', 'refresh', 'icon', 'list').on('click', function () {
        _this4.setMode('grid');

        _this4.$layoutContainer.removeClass('sb-view-layout-chart');

        _this4.$layoutContainer.addClass('sb-view-layout-list');

        _this4.onchangeView(true);

        $switch_grid_button.hide();
        $switch_chart_button.show();
      }).hide();

      var $switch_chart_button = _materialLib.UIHelper.createButton(this.getUUID() + 'switch-view', 'refresh', 'icon', 'bar_chart').on('click', function () {
        _this4.setMode('chart');

        _this4.$layoutContainer.removeClass('sb-view-layout-list');

        _this4.$layoutContainer.addClass('sb-view-layout-chart');

        _this4.onchangeView(true);

        $switch_chart_button.hide();
        $switch_grid_button.show();
      });

      $pagination.find('.pagination-container').prepend($switch_chart_button).prepend($switch_grid_button).prepend($refresh_list_button);
      $level2.append($pagination);
      this.$headerContainer.append($elem);
    }
    /**
     * Re-draw the list layout.
     * This method is triggered by a model change @see layoutRefresh() or a selection change @see onChangeSelection().
     *
     * @param full
     */

  }, {
    key: "layoutListRefresh",
    value: function layoutListRefresh() {
      var _this5 = this;

      var full = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      console.debug('View::layoutListRefresh', full); // update footer indicators (total count)

      var limit = this.getLimit();
      var total = this.getTotal();
      var start = total ? this.getStart() + 1 : 0;
      var end = start + limit - 1;
      end = total ? Math.min(end, start + this.model.ids().length - 1) : 0;
      this.$headerContainer.find('.sb-view-header-list-pagination-total').html(total);
      this.$headerContainer.find('.sb-view-header-list-pagination-start').html(start);
      this.$headerContainer.find('.sb-view-header-list-pagination-end').html(end);
      this.$headerContainer.find('.sb-view-header-list-pagination-first_page').prop('disabled', !(start > limit));
      this.$headerContainer.find('.sb-view-header-list-pagination-prev_page').prop('disabled', !(start > limit));
      this.$headerContainer.find('.sb-view-header-list-pagination-next_page').prop('disabled', !(start <= total - limit));
      this.$headerContainer.find('.sb-view-header-list-pagination-last_page').prop('disabled', !(start <= total - limit));
      var $action_set = this.$headerContainer.find('.sb-view-header-actions');
      var $std_actions = $action_set.find('.sb-view-header-actions-std'); // abort any pending edition

      var $actions_selected_edit = $action_set.find('.sb-view-header-list-actions-selected-edit');

      if ($actions_selected_edit.length) {
        $actions_selected_edit.find('.action-selected-edit-cancel').trigger('click');
      } // remove containers related to selection actions


      $action_set.find('.sb-view-header-list-actions-selected-edit').remove();
      $action_set.find('.sb-view-header-list-actions-selected').remove();
      $action_set.find('.sb-view-header-list-actions-export').remove(); // do not show the actions menu for 'add' and 'select' purposes

      if (['view', 'widget'].indexOf(this.purpose) > -1) {
        if (this.purpose == 'view') {
          // create export menu (always visible: no selection means "export all")
          var $export_actions_menu_button = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-actions-export mdc-menu-surface--anchor').append(_materialLib.UIHelper.createButton('selection-action-' + 'SB_ACTIONS_BUTTON_EXPORT', 'export', 'icon', 'file_download')).appendTo($std_actions);

          var $export_actions_menu = _materialLib.UIHelper.createMenu('export-actions-menu').addClass('sb-view-header-list-export-menu').appendTo($export_actions_menu_button);

          var $export_actions_list = _materialLib.UIHelper.createList('export-actions-list').appendTo($export_actions_menu); // generate filters list


          var _loop4 = function _loop4(export_id) {
            var item = _this5.exports[export_id];

            var export_title = _equalServices.TranslationService.resolve(_this5.translation, 'view', [_this5.getId(), 'exports'], item.id, item.label, 'label');

            _materialLib.UIHelper.createListItem('SB_ACTIONS_BUTTON_EXPORT-' + item.id, export_title, item.hasOwnProperty('icon') ? item.icon : '').on('click', function (event) {
              var params = new URLSearchParams({
                get: item.controller,
                view_id: item.view ? item.view : _this5.getId(),
                entity: _this5.entity,
                domain: JSON.stringify(_this5.getDomain()),
                id: _this5.selected_ids.length ? _this5.selected_ids[0] : 0,
                ids: JSON.stringify(_this5.selected_ids),
                lang: _this5.lang,
                controller: _this5.controller,
                params: JSON.stringify(_this5.getParams())
              }).toString();
              window.open(_this5.getEnv().backend_url + '/?' + params, "_blank");
            }).appendTo($export_actions_list);
          };

          for (var export_id in this.exports) {
            _loop4(export_id);
          }

          _materialLib.UIHelper.decorateMenu($export_actions_menu);

          $export_actions_menu_button.find('button').on('click', function () {
            return $export_actions_menu.trigger('_toggle');
          });
        } // create buttons with actions to apply on current selection


        if (this.selected_ids.length > 0) {
          var $container = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-actions-selected').appendTo($std_actions);
          var count = this.selected_ids.length;
          var $fields_toggle_button = (0, _jqueryLib.$)('<div/>').addClass('mdc-menu-surface--anchor').append(_materialLib.UIHelper.createButton('action-selected', count + ' ' + _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_SELECTED'), 'outlined'));

          var $list = _materialLib.UIHelper.createList('fields-list');

          var $menu = _materialLib.UIHelper.createMenu('fields-menu').addClass('sb-view-header-list-fields_toggle-menu');

          $menu.append($list);
          $fields_toggle_button.append($menu); // add actions defined in view

          var _iterator13 = _createForOfIteratorHelper(this.config.selection_actions),
              _step13;

          try {
            var _loop5 = function _loop5() {
              var item = _step13.value;
              var item_id = 'SB_ACTION_ITEM-' + item.label;

              var item_label = _equalServices.TranslationService.instant(item.label); // look for a translation based on id


              if (item.hasOwnProperty('id')) {
                item_id = 'SB_ACTION_ITEM-' + item.id;
                item_label = _equalServices.TranslationService.resolve(_this5.translation, 'view', [_this5.getId(), 'layout'], item.id, item_label);
              }

              var $list_item = _materialLib.UIHelper.createListItem(item_id, item_label, item.icon).on('click', function (event) {
                return item.handler(_this5.selected_ids, item);
              }).appendTo($list);

              if (item.hasOwnProperty('primary') && item.primary) {
                $container.append(_materialLib.UIHelper.createButton('selection-action-' + item.label, item.label, 'icon', item.icon).on('click', function (event) {
                  return item.handler(_this5.selected_ids, item);
                }));

                var $tooltip = _materialLib.UIHelper.createTooltip('selection-action-' + item.label, _equalServices.TranslationService.instant(item.label));

                $container.append($tooltip);

                _materialLib.UIHelper.decorateTooltip($tooltip);
              }

              if (item.hasOwnProperty('visible')) {
                if (!item.visible) {
                  $list_item.hide();
                }
              }
            };

            for (_iterator13.s(); !(_step13 = _iterator13.n()).done;) {
              _loop5();
            }
          } catch (err) {
            _iterator13.e(err);
          } finally {
            _iterator13.f();
          }

          _materialLib.UIHelper.decorateMenu($menu);

          $fields_toggle_button.find('button').on('click', function () {
            return $menu.trigger('_toggle');
          });
          $fields_toggle_button.appendTo($container);
        }
      }

      this.layout.loading(false);
    }
  }, {
    key: "layoutChartRefresh",
    value: function layoutChartRefresh() {
      var _this6 = this;

      var full = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      console.debug('View::layoutChartRefresh', full); // update footer indicators (total count)

      var $action_set = this.$headerContainer.find('.sb-view-header-actions');
      var $std_actions = $action_set.find('.sb-view-header-actions-std'); // remove containers related to selection actions

      $action_set.find('.sb-view-header-list-actions-export').remove(); // do not show the actions menu for 'add' and 'select' purposes

      if (['view', 'widget'].indexOf(this.purpose) > -1) {
        if (this.purpose == 'view') {
          // create export menu (always visible: no selection means "export all")
          var $export_actions_menu_button = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-actions-export mdc-menu-surface--anchor').append(_materialLib.UIHelper.createButton('selection-action-' + 'SB_ACTIONS_BUTTON_EXPORT', 'export', 'icon', 'file_download')).appendTo($std_actions);

          var $export_actions_menu = _materialLib.UIHelper.createMenu('export-actions-menu').addClass('sb-view-header-list-export-menu').appendTo($export_actions_menu_button);

          var $export_actions_list = _materialLib.UIHelper.createList('export-actions-list').appendTo($export_actions_menu); // generate filters list
          // #memo - for charts there is only one export (export-chart-xls)


          var _loop6 = function _loop6(export_id) {
            var item = _this6.exports[export_id];

            var export_title = _equalServices.TranslationService.resolve(_this6.translation, 'view', [_this6.getId(), 'exports'], item.id, item.label, 'label');

            _materialLib.UIHelper.createListItem('SB_ACTIONS_BUTTON_EXPORT-' + item.id, export_title, item.hasOwnProperty('icon') ? item.icon : '').on('click', function (event) {
              var params = new URLSearchParams({
                get: item.controller,
                entity: _this6.entity,
                view_id: item.view ? item.view : _this6.getId(),
                domain: JSON.stringify(_this6.getDomain()),
                lang: _this6.lang,
                params: JSON.stringify(_this6.getParams())
              }).toString();
              window.open(_this6.getEnv().backend_url + '/?' + params, "_blank");
            }).appendTo($export_actions_list);
          };

          for (var export_id in this.exports) {
            _loop6(export_id);
          }

          _materialLib.UIHelper.decorateMenu($export_actions_menu);

          $export_actions_menu_button.find('button').on('click', function () {
            return $export_actions_menu.trigger('_toggle');
          });
        }
      }

      this.layout.loading(false);
    }
  }, {
    key: "layoutFormHeader",
    value: function layoutFormHeader() {
      var _this7 = this;

      var $elem = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-form'); // container for holding chips of currently applied filters

      var $actions_set = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-actions').appendTo($elem); // left side : standard actions for views

      var $std_actions = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-actions-std').appendTo($actions_set); // right side : the actions specific to the view, and depenging on object status

      var $view_actions = (0, _jqueryLib.$)('<div />').addClass('sb-view-header-actions-view').appendTo($actions_set); // possible values for header.actions

      /*
          "ACTION.CREATE":   [],
          "ACTION.SELECT":   [],
          "ACTION.EDIT":     [],
          "ACTION.SAVE":     [
              {"id": "SAVE_AND_CLOSE"},                           // save and go back to list [edit] or parent context [create] (default)
              {"id": "SAVE_AND_VIEW"},                            // save and go back to view mode [edit] or list [create]
              {"id": "SAVE_AND_EDIT", "view": "form.default"},    // save and reopen a view in edit mode, change view if defined
              {"id": "SAVE_AND_CONTINUE"}                         // save and remain in edit mode
          ],
          "ACTION.CANCEL":   [
              {"id": "CANCEL_AND_CLOSE"},     // do not save and go back to list
              {"id": "CANCEL_AND_VIEW"}       // do not save and go back to view mode
          ]
      */
      // default order for header actions split buttons (can be overridden in view files)

      var default_header_actions = {
        "ACTION.EDIT": [],
        "ACTION.SAVE": [{
          "id": "SAVE_AND_CLOSE"
        }],
        "ACTION.CANCEL": [{
          "id": "CANCEL_AND_CLOSE"
        }]
      };
      var header_actions = {}; // overwrite with view schema, if defined

      if (this.custom_actions.hasOwnProperty('ACTION.SAVE')) {
        header_actions['ACTION.SAVE'] = this.custom_actions['ACTION.SAVE'];
      } else {
        if (default_header_actions.hasOwnProperty('ACTION.SAVE')) {
          header_actions['ACTION.SAVE'] = default_header_actions['ACTION.SAVE'];
        }
      }

      if (this.custom_actions.hasOwnProperty('ACTION.CANCEL')) {
        header_actions['ACTION.CANCEL'] = this.custom_actions['ACTION.CANCEL'];
      } else {
        if (default_header_actions.hasOwnProperty('ACTION.CANCEL')) {
          header_actions['ACTION.CANCEL'] = default_header_actions['ACTION.CANCEL'];
        }
      }

      var has_action_update = true;

      if (this.config.hasOwnProperty('header') && this.config.header.hasOwnProperty('actions')) {
        if (this.config.header.actions.hasOwnProperty('ACTION.EDIT')) {
          has_action_update = this.config.header.actions['ACTION.EDIT'] ? true : false;
        }
      }

      switch (this.mode) {
        case 'view':
          if (has_action_update) {
            $std_actions.append(_materialLib.UIHelper.createButton(this.uuid + '_action-edit', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_UPDATE'), 'raised').on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee19() {
              return _regenerator.default.wrap(function _callee19$(_context19) {
                while (1) {
                  switch (_context19.prev = _context19.next) {
                    case 0:
                      _context19.next = 2;
                      return _this7.openContext({
                        entity: _this7.entity,
                        type: _this7.type,
                        name: _this7.name,
                        domain: _this7.getDomain(),
                        mode: 'edit',
                        purpose: 'update',
                        // for UX consistency, inject current view widget context (currently selected tabs, ...)
                        selected_sections: _this7.layout.getSelectedSections()
                      });

                    case 2:
                    case "end":
                      return _context19.stop();
                  }
                }
              }, _callee19);
            }))));
          }

          break;

        case 'edit':
          var save_method = /*#__PURE__*/function () {
            var _ref13 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee20() {
              var objects, object, response, res;
              return _regenerator.default.wrap(function _callee20$(_context20) {
                while (1) {
                  switch (_context20.prev = _context20.next) {
                    case 0:
                      if (!(_this7.purpose == 'create')) {
                        _context20.next = 6;
                        break;
                      }

                      _context20.next = 3;
                      return _this7.model.get();

                    case 3:
                      objects = _context20.sent;
                      _context20.next = 7;
                      break;

                    case 6:
                      // get changed objects only
                      objects = _this7.model.getChanges();

                    case 7:
                      if (objects.length) {
                        _context20.next = 11;
                        break;
                      }

                      return _context20.abrupt("return", {});

                    case 11:
                      // we're in edit mode for single object (form)
                      object = objects[0];
                      _context20.prev = 12;
                      _context20.next = 15;
                      return _equalServices.ApiService.update(_this7.entity, [object['id']], _this7.model.export(object), false, _this7.getLang());

                    case 15:
                      response = _context20.sent;

                      if (response && response.length) {
                        // merge object with response (state and name fields might have changed)
                        object = _objectSpread(_objectSpread({}, object), response[0]);
                      }

                      return _context20.abrupt("return", {
                        selection: [object.id],
                        objects: [object]
                      });

                    case 20:
                      _context20.prev = 20;
                      _context20.t0 = _context20["catch"](12);
                      _context20.prev = 22;
                      _context20.next = 25;
                      return _this7.displayErrorFeedback(_this7.translation, _context20.t0, object, true);

                    case 25:
                      res = _context20.sent;

                      if (!(res !== false)) {
                        _context20.next = 28;
                        break;
                      }

                      return _context20.abrupt("return", {
                        selection: [object.id],
                        objects: [object]
                      });

                    case 28:
                      _context20.next = 32;
                      break;

                    case 30:
                      _context20.prev = 30;
                      _context20.t1 = _context20["catch"](22);

                    case 32:
                      return _context20.abrupt("return", null);

                    case 33:
                    case "end":
                      return _context20.stop();
                  }
                }
              }, _callee20, null, [[12, 20], [22, 30]]);
            }));

            return function save_method() {
              return _ref13.apply(this, arguments);
            };
          }();

          var save_actions = {
            "SAVE_AND_CONTINUE": function () {
              var _SAVE_AND_CONTINUE = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee21(action) {
                var res, object_id, tmpDomain, $snack;
                return _regenerator.default.wrap(function _callee21$(_context21) {
                  while (1) {
                    switch (_context21.prev = _context21.next) {
                      case 0:
                        _context21.next = 2;
                        return save_method();

                      case 2:
                        res = _context21.sent;

                        if (res && res.selection) {
                          object_id = res.selection.pop(); // reset domain (drop state=draft condition)

                          tmpDomain = new _equalLib.Domain(["id", "=", object_id]);
                          _this7.domain = tmpDomain.toArray(); // #memo - we don't want to refresh the view (would lose the current tab)
                          // this.onchangeView(true);
                          // feedback the user (since we're not closing the context)

                          $snack = _materialLib.UIHelper.createSnackbar('Modifications enregistrées', '', '', 4000);

                          _this7.$container.append($snack);
                        }

                      case 4:
                      case "end":
                        return _context21.stop();
                    }
                  }
                }, _callee21);
              }));

              function SAVE_AND_CONTINUE(_x15) {
                return _SAVE_AND_CONTINUE.apply(this, arguments);
              }

              return SAVE_AND_CONTINUE;
            }(),
            "SAVE_AND_VIEW": function () {
              var _SAVE_AND_VIEW = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee22(action) {
                var res, parent, object_id, view_name, view_type, parts;
                return _regenerator.default.wrap(function _callee22$(_context22) {
                  while (1) {
                    switch (_context22.prev = _context22.next) {
                      case 0:
                        _context22.next = 2;
                        return save_method();

                      case 2:
                        res = _context22.sent;

                        if (!res) {
                          _context22.next = 18;
                          break;
                        }

                        parent = _this7.context.getParent(); // if context has a parent, close and relay new object_id to parent view

                        if (!Object.keys(parent).length) {
                          _context22.next = 10;
                          break;
                        }

                        _context22.next = 8;
                        return _this7.closeContext(res);

                      case 8:
                        _context22.next = 18;
                        break;

                      case 10:
                        _context22.next = 12;
                        return _this7.closeContext(null, true);

                      case 12:
                        object_id = res.selection[0];
                        view_name = _this7.name;
                        view_type = _this7.type;

                        if (action.hasOwnProperty('view')) {
                          parts = action.view.split('.');
                          if (parts.length) view_type = parts.shift();
                          if (parts.length) view_name = parts.shift();
                        }

                        _context22.next = 18;
                        return _this7.openContext({
                          entity: _this7.entity,
                          type: view_type,
                          name: view_name,
                          domain: ['id', '=', object_id],
                          mode: 'view',
                          purpose: 'view'
                        });

                      case 18:
                      case "end":
                        return _context22.stop();
                    }
                  }
                }, _callee22);
              }));

              function SAVE_AND_VIEW(_x16) {
                return _SAVE_AND_VIEW.apply(this, arguments);
              }

              return SAVE_AND_VIEW;
            }(),
            "SAVE_AND_EDIT": function () {
              var _SAVE_AND_EDIT = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee23(action) {
                var res, object_id, view_name, view_type, parts;
                return _regenerator.default.wrap(function _callee23$(_context23) {
                  while (1) {
                    switch (_context23.prev = _context23.next) {
                      case 0:
                        _context23.next = 2;
                        return save_method();

                      case 2:
                        res = _context23.sent;

                        if (!res) {
                          _context23.next = 12;
                          break;
                        }

                        _context23.next = 6;
                        return _this7.closeContext(null, true);

                      case 6:
                        object_id = res.selection[0];
                        view_name = _this7.name;
                        view_type = _this7.type;

                        if (action.hasOwnProperty('view')) {
                          parts = action.view.split('.');
                          if (parts.length) view_type = parts.shift();
                          if (parts.length) view_name = parts.shift();
                        }

                        _context23.next = 12;
                        return _this7.openContext({
                          entity: _this7.entity,
                          type: view_type,
                          name: view_name,
                          domain: ['id', '=', object_id],
                          mode: 'edit',
                          purpose: 'edit'
                        });

                      case 12:
                      case "end":
                        return _context23.stop();
                    }
                  }
                }, _callee23);
              }));

              function SAVE_AND_EDIT(_x17) {
                return _SAVE_AND_EDIT.apply(this, arguments);
              }

              return SAVE_AND_EDIT;
            }(),
            "SAVE_AND_CLOSE": function () {
              var _SAVE_AND_CLOSE = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee24(action) {
                var res, parent;
                return _regenerator.default.wrap(function _callee24$(_context24) {
                  while (1) {
                    switch (_context24.prev = _context24.next) {
                      case 0:
                        _context24.next = 2;
                        return save_method();

                      case 2:
                        res = _context24.sent;

                        if (!res) {
                          _context24.next = 10;
                          break;
                        }

                        _context24.next = 6;
                        return _this7.closeContext(res);

                      case 6:
                        // close parent as well if current view was the edit mode of parent view
                        parent = _this7.context.getParent();

                        if (!(typeof parent.getView === 'function' && parent.getView().getMode() == "view" && _this7.purpose == 'update')) {
                          _context24.next = 10;
                          break;
                        }

                        _context24.next = 10;
                        return _this7.closeContext();

                      case 10:
                      case "end":
                        return _context24.stop();
                    }
                  }
                }, _callee24);
              }));

              function SAVE_AND_CLOSE(_x18) {
                return _SAVE_AND_CLOSE.apply(this, arguments);
              }

              return SAVE_AND_CLOSE;
            }()
          };

          var $cancel_button = _materialLib.UIHelper.createButton(this.uuid + '_action-cancel', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_CANCEL'), 'outlined');

          $cancel_button.on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee25() {
            var validation;
            return _regenerator.default.wrap(function _callee25$(_context25) {
              while (1) {
                switch (_context25.prev = _context25.next) {
                  case 0:
                    validation = true;

                    if (!_this7.hasChanged()) {
                      _context25.next = 5;
                      break;
                    }

                    _context25.next = 4;
                    return confirm(_equalServices.TranslationService.instant('SB_ACTIONS_MESSAGE_ABANDON_CHANGE'));

                  case 4:
                    validation = _context25.sent;

                  case 5:
                    if (!validation) {
                      _context25.next = 8;
                      break;
                    }

                    _context25.next = 8;
                    return _this7.closeContext();

                  case 8:
                  case "end":
                    return _context25.stop();
                }
              }
            }, _callee25);
          })));
          var $save_button = (0, _jqueryLib.$)();

          if (header_actions["ACTION.SAVE"].length <= 1) {
            var save_button_title_id = 'SB_ACTIONS_BUTTON_SAVE';
            /*
            if(header_actions["ACTION.SAVE"].length) {
                save_button_title_id = 'SB_ACTIONS_BUTTON_' + header_actions["ACTION.SAVE"][0].id;
            }
            */

            $save_button = _materialLib.UIHelper.createButton(this.uuid + '_action-save', _equalServices.TranslationService.instant(save_button_title_id), 'raised', '', 'secondary');
          } else {
            $save_button = _materialLib.UIHelper.createSplitButton(this.uuid + '_action-save', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_' + header_actions["ACTION.SAVE"][0].id), 'raised', '', 'secondary');

            var _loop7 = function _loop7(i, n) {
              // retrieve order in which actions must be invoked
              var header_action = header_actions["ACTION.SAVE"][i].id;
              if (!save_actions.hasOwnProperty(header_action)) return "continue";
              var save_action = save_actions[header_action];
              $save_button.find('.menu-list').append(_materialLib.UIHelper.createListItem(_this7.uuid + '_action-' + header_action, _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_' + header_action)) // onclick, save and stay in edit mode (save and go back to list)
              .on('click', function () {
                // #memo - delay action so that widgets onchange handlers are processed
                setTimeout( /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee26() {
                  return _regenerator.default.wrap(function _callee26$(_context26) {
                    while (1) {
                      switch (_context26.prev = _context26.next) {
                        case 0:
                          _context26.prev = 0;
                          _context26.next = 3;
                          return save_action(header_actions["ACTION.SAVE"][i]);

                        case 3:
                          _context26.next = 8;
                          break;

                        case 5:
                          _context26.prev = 5;
                          _context26.t0 = _context26["catch"](0);
                          console.warn(_context26.t0);

                        case 8:
                        case "end":
                          return _context26.stop();
                      }
                    }
                  }, _callee26, null, [[0, 5]]);
                })), 100);
              }));
            };

            for (var i = 1, n = header_actions["ACTION.SAVE"].length; i < n; ++i) {
              var _ret = _loop7(i, n);

              if (_ret === "continue") continue;
            }
          } // assign action on base button


          var header_action = header_actions["ACTION.SAVE"][0].id;

          if (save_actions.hasOwnProperty(header_action)) {
            var save_action = save_actions[header_action];
            $save_button.on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee28() {
              return _regenerator.default.wrap(function _callee28$(_context28) {
                while (1) {
                  switch (_context28.prev = _context28.next) {
                    case 0:
                      // #memo - delay action so that widgets onchange handlers are processed
                      setTimeout( /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee27() {
                        return _regenerator.default.wrap(function _callee27$(_context27) {
                          while (1) {
                            switch (_context27.prev = _context27.next) {
                              case 0:
                                _context27.prev = 0;
                                _context27.next = 3;
                                return save_action(header_actions["ACTION.SAVE"][0]);

                              case 3:
                                _context27.next = 8;
                                break;

                              case 5:
                                _context27.prev = 5;
                                _context27.t0 = _context27["catch"](0);
                                console.warn(_context27.t0);

                              case 8:
                              case "end":
                                return _context27.stop();
                            }
                          }
                        }, _callee27, null, [[0, 5]]);
                      })), 100);

                    case 1:
                    case "end":
                      return _context28.stop();
                  }
                }
              }, _callee28);
            })));
          }

          $std_actions.append($save_button).append($cancel_button);
          break;
      } // attach elements to header toolbar


      this.$headerContainer.append($elem);
    }
  }, {
    key: "layoutRefresh",
    value: function () {
      var _layoutRefresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee29() {
        var full,
            _args29 = arguments;
        return _regenerator.default.wrap(function _callee29$(_context29) {
          while (1) {
            switch (_context29.prev = _context29.next) {
              case 0:
                full = _args29.length > 0 && _args29[0] !== undefined ? _args29[0] : false;
                _context29.next = 3;
                return this.layout.refresh(full);

              case 3:
                if (['list', 'cards'].indexOf(this.type) >= 0) {
                  this.layoutListRefresh(full);
                }

                if (['chart'].indexOf(this.type) >= 0) {
                  this.layoutChartRefresh(full);
                }

              case 5:
              case "end":
                return _context29.stop();
            }
          }
        }, _callee29, this);
      }));

      function layoutRefresh() {
        return _layoutRefresh.apply(this, arguments);
      }

      return layoutRefresh;
    }()
  }, {
    key: "decorateBulkAssignDialog",
    value: function decorateBulkAssignDialog($dialog) {
      var _this8 = this;

      var $elem = (0, _jqueryLib.$)('<div />');
      var selected_field = '';
      var selected_value = '';
      var $select_field = (0, _jqueryLib.$)();
      var $select_value = (0, _jqueryLib.$)();
      $dialog.on('_open', function () {
        $select_field.find('input').trigger('change');
      });
      var fields = {};

      var _iterator14 = _createForOfIteratorHelper(this.view_schema.layout.items),
          _step14;

      try {
        for (_iterator14.s(); !(_step14 = _iterator14.n()).done;) {
          var item = _step14.value;
          var label = item.hasOwnProperty('label') ? item.label : item.value;
          fields[item.value] = _equalServices.TranslationService.resolve(this.translation, 'model', [], item.value, label, 'label');
        }
      } catch (err) {
        _iterator14.e(err);
      } finally {
        _iterator14.f();
      }

      $select_field = _materialLib.UIHelper.createSelect('bulk_assign_select_field', _equalServices.TranslationService.instant('SB_FILTERS_DIALOG_FIELD'), fields, Object.keys(fields)[0]).appendTo($elem); // setup handler for relaying value update to parent layout

      $select_field.find('input').on('change', function (event) {
        var $this = (0, _jqueryLib.$)(event.currentTarget);
        selected_field = $this.val();
        $elem.find('#bulk_assign_select_value').remove();

        var field_type = _this8.model.getFinalType(selected_field);

        switch (field_type) {
          case 'boolean':
            $select_value = _materialLib.UIHelper.createSelect('bulk_assign_select_value', _equalServices.TranslationService.instant('SB_FILTERS_DIALOG_VALUE'), ['true', 'false']);
            $select_value.find('input').on('change', function (event) {
              var $this = (0, _jqueryLib.$)(event.currentTarget);
              selected_value = $this.children("option:selected").val() == 'true';
            });
            break;

          case 'date':
          case 'datetime':
            // daterange selector
            $select_value = _materialLib.UIHelper.createInput('bulk_assign_select_value', _equalServices.TranslationService.instant('SB_FILTERS_DIALOG_VALUE'), '');
            $select_value.find('input').datepicker(_objectSpread(_objectSpread({}, _jqueryLib.jqlocale[_this8.config.locale]), {}, {
              onClose: function onClose() {
                $select_value.find('input').trigger('focus');
              }
            })).on('change', function (event) {
              // update widget value using jQuery `getDate`
              var $this = (0, _jqueryLib.$)(event.currentTarget);
              var date = $this.datepicker('getDate');
              selected_value = date;
            });
            break;

          case 'many2one': // #todo - select amongst exisiting objects typeahead

          case 'string': // #todo - display selection if any

          case 'integer':
          case 'float':
          default:
            $select_value = _materialLib.UIHelper.createInput('bulk_assign_select_value', _equalServices.TranslationService.instant('SB_FILTERS_DIALOG_VALUE'), '');
            $select_value.find('input').on('change', function (event) {
              var $this = (0, _jqueryLib.$)(event.currentTarget);
              selected_value = $this.val();
            });
        }

        $elem.append($select_value);
      }) // init
      .trigger('change');
      $dialog.find('.mdc-dialog__content').append($elem);
      $dialog.on('_accept', function () {
        // assign value to currently selected items
        var _iterator15 = _createForOfIteratorHelper(_this8.selected_ids),
            _step15;

        try {
          for (_iterator15.s(); !(_step15 = _iterator15.n()).done;) {
            var object_id = _step15.value;

            _this8.$layoutContainer.find('tr[data-id="' + object_id + '"]').trigger('_setValue', [selected_field, selected_value]);
          }
        } catch (err) {
          _iterator15.e(err);
        } finally {
          _iterator15.f();
        }
      });
    }
  }, {
    key: "decorateCustomFilterDialog",
    value: function decorateCustomFilterDialog($dialog) {
      var _this9 = this;

      var $elem = (0, _jqueryLib.$)('<div />');
      var selected_field = '';
      var selected_operator = '';
      var selected_value = '';
      var $select_field = (0, _jqueryLib.$)();
      var $select_operator = (0, _jqueryLib.$)();
      var $select_value = (0, _jqueryLib.$)();
      $dialog.on('_open', function () {
        $select_field.find('input').trigger('change');
      });
      var fields = {};

      var _iterator16 = _createForOfIteratorHelper(this.view_schema.layout.items),
          _step16;

      try {
        for (_iterator16.s(); !(_step16 = _iterator16.n()).done;) {
          var item = _step16.value;

          if (this.model_schema.fields.hasOwnProperty(item.value) && ['integer', 'float', 'boolean', 'string', 'date', 'time', 'datetime', 'many2one'].indexOf(this.model_schema.fields[item.value].type) >= 0) {
            var label = item.hasOwnProperty('label') ? item.label : item.value;
            fields[item.value] = _equalServices.TranslationService.resolve(this.translation, 'model', [], item.value, label, 'label');
          }
        }
      } catch (err) {
        _iterator16.e(err);
      } finally {
        _iterator16.f();
      }

      $select_field = _materialLib.UIHelper.createSelect(this.uuid + '_custom-filter-select-field', _equalServices.TranslationService.instant('SB_FILTERS_DIALOG_FIELD'), fields, Object.keys(fields)[0]).appendTo($elem); // setup handler for relaying value update to parent layout

      $select_field.addClass('dialog-select').find('input').on('change', function (event) {
        var $this = (0, _jqueryLib.$)(event.currentTarget);
        selected_field = $this.val();
        $elem.find('#' + _this9.uuid + '_custom-filter-select-operator').remove();
        $elem.find('.sb-widget').remove();

        var field_type = _this9.model.getFinalType(selected_field);

        var operators = _this9.model.getOperators(field_type);

        selected_operator = operators[0];
        $select_operator = _materialLib.UIHelper.createSelect(_this9.uuid + '_custom-filter-select-operator', _equalServices.TranslationService.instant('SB_FILTERS_DIALOG_OPERATOR'), operators, operators[0]); // setup handler for relaying value update to parent layout

        $select_operator.addClass('dialog-select').find('input').on('change', function (event) {
          var $this = (0, _jqueryLib.$)(event.currentTarget);
          selected_operator = $this.val();
        });

        var config = _equalWidgets.WidgetFactory.getWidgetConfig(_this9, selected_field, _this9.translation, _this9.model_fields, _this9.view_fields); // form form layout


        config.layout = 'form';
        var value = '';

        if (['date', 'datetime'].indexOf(config.type) >= 0) {
          value = new Date();
          selected_value = value.toISOString();
        }

        var widget = _equalWidgets.WidgetFactory.getWidget(_this9, config.type, fields[selected_field], value, config);

        widget.setMode('edit');
        widget.setReadonly(false);
        $select_value = widget.render();
        $select_value.on('_updatedWidget', function (event) {
          var value = widget.getValue();
          console.debug('_updatedWidget', value);
          selected_value = value;
        });
        $elem.append($select_operator);
        $elem.append($select_value);
      });
      $dialog.find('.mdc-dialog__content').append($elem); // init

      $select_field.trigger('change');
      $dialog.on('_accept', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee30() {
        var operand, operator, value, tmpDomain, clause, description, filter, $filters_list;
        return _regenerator.default.wrap(function _callee30$(_context30) {
          while (1) {
            switch (_context30.prev = _context30.next) {
              case 0:
                operand = selected_field;
                operator = selected_operator;
                value = selected_value;

                if (_this9.model_schema.fields[selected_field].type == 'many2one') {
                  value = selected_value.id;
                }

                if (selected_operator == 'like') {
                  operator = 'ilike';
                  value = '%' + value + '%';
                } else if (selected_operator == 'in' || selected_operator == 'not in') {
                  value = '[' + value + ']';
                }

                tmpDomain = new _equalLib.Domain([operand, operator, value]);
                clause = tmpDomain.getClauses()[0];
                _context30.next = 9;
                return _this9.translateFilterClause(clause);

              case 9:
                description = _context30.sent;
                filter = {
                  "id": "custom_filter_" + (Math.random() + 1).toString(36).substring(2, 9),
                  "label": "custom filter",
                  "description": description,
                  "clause": clause.toArray()
                }; // add filter to View available filters

                _this9.filters[filter.id] = filter;
                $filters_list = _this9.$headerContainer.find('#filters-list');

                _materialLib.UIHelper.createListItem(filter.id, filter.description).prependTo($filters_list).on('click', function (event) {
                  _this9.applyFilter(filter.id);
                });

                _this9.applyFilter(filter.id);

              case 15:
              case "end":
                return _context30.stop();
            }
          }
        }, _callee30);
      })));
    }
  }, {
    key: "decorateDialogDeletionConfirm",
    value: function decorateDialogDeletionConfirm($dialog) {
      var $elem = (0, _jqueryLib.$)('<div />');

      var $consent_confirm = _materialLib.UIHelper.createCheckbox('action-selected-delete-permanent', _equalServices.TranslationService.instant('SB_ACTIONS_DELETION_DIALOG_I_CONFIRM')).appendTo($elem);

      $dialog.find('.mdc-dialog__content').append($elem);
      $dialog.on('_accept', function () {
        $dialog.trigger('_ok', [{
          confirm: $consent_confirm.find('input').is(":checked")
        }]);
      });
    }
  }, {
    key: "decorateDialogArchiveConfirm",
    value: function decorateDialogArchiveConfirm($dialog) {
      var $elem = (0, _jqueryLib.$)('<div />').text(_equalServices.TranslationService.instant('SB_ACTIONS_ARCHIVE_DIALOG_MESSAGE'));
      $dialog.find('.mdc-dialog__content').append($elem);
      $dialog.on('_accept', function () {
        $dialog.trigger('_ok', []);
      });
    }
    /**
     * Callback for requesting a Model update.
     * Requested from layout when a change occured in the widgets.
     *
     * @param ids       array   one or more objecft identifiers
     * @param values    object   map of fields names and their related values
     */

  }, {
    key: "onchangeViewModel",
    value: function () {
      var _onchangeViewModel = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee31(ids, values) {
        var refresh,
            _i3,
            _Object$keys,
            event,
            _iterator17,
            _step17,
            callback,
            _args31 = arguments;

        return _regenerator.default.wrap(function _callee31$(_context31) {
          while (1) {
            switch (_context31.prev = _context31.next) {
              case 0:
                refresh = _args31.length > 2 && _args31[2] !== undefined ? _args31[2] : true;
                console.debug('View::onchangeViewModel', ids, values, refresh);
                this.model.change(ids, values); // model has changed : forms need to re-check the visibility attributes

                if (!refresh) {
                  _context31.next = 7;
                  break;
                }

                _context31.next = 6;
                return this.onchangeModel();

              case 6:
                // notify subscribers
                for (_i3 = 0, _Object$keys = Object.keys(this.subscribers); _i3 < _Object$keys.length; _i3++) {
                  event = _Object$keys[_i3];
                  _iterator17 = _createForOfIteratorHelper(this.subscribers[event]);

                  try {
                    for (_iterator17.s(); !(_step17 = _iterator17.n()).done;) {
                      callback = _step17.value;

                      if ({}.toString.call(callback) === '[object Function]') {
                        callback();
                      }
                    }
                  } catch (err) {
                    _iterator17.e(err);
                  } finally {
                    _iterator17.f();
                  }
                }

              case 7:
              case "end":
                return _context31.stop();
            }
          }
        }, _callee31, this);
      }));

      function onchangeViewModel(_x19, _x20) {
        return _onchangeViewModel.apply(this, arguments);
      }

      return onchangeViewModel;
    }()
    /**
     * Callback for requesting a Layout update: the widgets in the layout need to be refreshed.
     * Requested from Model when a change occured in the Collection (as consequence of domain or params update).
     * If `full`is set to true, then the layout is re-generated
     * @param full  boolean
     */

  }, {
    key: "onchangeModel",
    value: function () {
      var _onchangeModel = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee32() {
        var full,
            _args32 = arguments;
        return _regenerator.default.wrap(function _callee32$(_context32) {
          while (1) {
            switch (_context32.prev = _context32.next) {
              case 0:
                full = _args32.length > 0 && _args32[0] !== undefined ? _args32[0] : false;
                console.debug('View::onchangeModel', full);
                _context32.next = 4;
                return this.layoutRefresh(full);

              case 4:
              case "end":
                return _context32.stop();
            }
          }
        }, _callee32, this);
      }));

      function onchangeModel() {
        return _onchangeModel.apply(this, arguments);
      }

      return onchangeModel;
    }()
    /**
     * Callback for requesting a Model refresh.
     * Requested either from view: domain has been updated,
     * or from layout: context has been updated (sort column, sorting order, limit, page, ...)
     */

  }, {
    key: "onchangeView",
    value: function () {
      var _onchangeView = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee33() {
        var full,
            _args33 = arguments;
        return _regenerator.default.wrap(function _callee33$(_context33) {
          while (1) {
            switch (_context33.prev = _context33.next) {
              case 0:
                full = _args33.length > 0 && _args33[0] !== undefined ? _args33[0] : false;
                console.debug('View::onchangeView'); // notify about context update

                this.context.updatedContext(); // reset selection

                this.selected_ids = [];

                if (this.type == 'list') {
                  this.layout.loading(true);
                }

                _context33.next = 7;
                return this.model.refresh(full);

              case 7:
              case "end":
                return _context33.stop();
            }
          }
        }, _callee33, this);
      }));

      function onchangeView() {
        return _onchangeView.apply(this, arguments);
      }

      return onchangeView;
    }()
    /**
     * Callback for list selection update.
     *
     * @param selection
     */

  }, {
    key: "onchangeSelection",
    value: function onchangeSelection(selection) {
      console.debug('View::onchangeSelection', selection);
      this.selected_ids = selection;
      this.layoutListRefresh();
    }
  }, {
    key: "showFilter",
    value: function showFilter(filter_id) {
      var _this10 = this;

      console.debug('View::showFilter', this.filters, this.applied_filters_ids);
      var filter = this.filters[filter_id];
      var $filters_set = this.$headerContainer.find('.sb-view-header-list-filters-set'); // make sure not to append a chip for same filter twice

      $filters_set.find('#' + filter_id).remove();
      $filters_set.append(_materialLib.UIHelper.createChip(filter.description).attr('id', filter_id).on('click', /*#__PURE__*/function () {
        var _ref19 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee34(event) {
          var $this;
          return _regenerator.default.wrap(function _callee34$(_context34) {
            while (1) {
              switch (_context34.prev = _context34.next) {
                case 0:
                  // unapply filter
                  $this = (0, _jqueryLib.$)(event.currentTarget);
                  _context34.next = 3;
                  return _this10.unapplyFilter($this.attr('id'));

                case 3:
                case "end":
                  return _context34.stop();
              }
            }
          }, _callee34);
        }));

        return function (_x21) {
          return _ref19.apply(this, arguments);
        };
      }()));
    }
    /**
     * Apply a filter on the current view, and reload the Collection with the new resulting domain.
     *
     * Expected structure for `filter`:
     *       "id": "lang.french",
     *       "label": "français",
     *       "description": "Utilisateurs parlant français",
     *       "clause": ["language", "=", "fr"]
     */

  }, {
    key: "applyFilter",
    value: function () {
      var _applyFilter = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee35(filter_id) {
        return _regenerator.default.wrap(function _callee35$(_context35) {
          while (1) {
            switch (_context35.prev = _context35.next) {
              case 0:
                this.applied_filters_ids.push(filter_id);
                this.showFilter(filter_id);
                this.setStart(0);
                this.onchangeView();

              case 4:
              case "end":
                return _context35.stop();
            }
          }
        }, _callee35, this);
      }));

      function applyFilter(_x22) {
        return _applyFilter.apply(this, arguments);
      }

      return applyFilter;
    }()
  }, {
    key: "unapplyFilter",
    value: function () {
      var _unapplyFilter = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee36(filter_id) {
        var index, $filters_set;
        return _regenerator.default.wrap(function _callee36$(_context36) {
          while (1) {
            switch (_context36.prev = _context36.next) {
              case 0:
                index = this.applied_filters_ids.indexOf(filter_id);

                if (index > -1) {
                  this.applied_filters_ids.splice(index, 1); // #memo - keep filters to allow re-apply while current view is active
                  // delete this.filters[filter_id];

                  $filters_set = this.$headerContainer.find('.sb-view-header-list-filters-set');
                  $filters_set.find('#' + filter_id).remove();

                  if (filter_id == 'filter_search_on_name') {
                    // reset value of search input
                    this.$headerContainer.find('.sb-view-header-list-filters-search').find('.mdc-text-field__icon').trigger('click');
                  }

                  this.setStart(0);
                  this.onchangeView();
                }

              case 2:
              case "end":
                return _context36.stop();
            }
          }
        }, _callee36, this);
      }));

      function unapplyFilter(_x23) {
        return _unapplyFilter.apply(this, arguments);
      }

      return unapplyFilter;
    }()
  }, {
    key: "actionBulkAssign",
    value: function () {
      var _actionBulkAssign = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee37(selection) {
        return _regenerator.default.wrap(function _callee37$(_context37) {
          while (1) {
            switch (_context37.prev = _context37.next) {
              case 0:
                console.debug('View::opening bulk assign dialog');
                this.$container.find('#' + this.uuid + '_bulk-assign-dialog').trigger('_open');

              case 2:
              case "end":
                return _context37.stop();
            }
          }
        }, _callee37, this);
      }));

      function actionBulkAssign(_x24) {
        return _actionBulkAssign.apply(this, arguments);
      }

      return actionBulkAssign;
    }()
  }, {
    key: "actionListInlineEdit",
    value: function () {
      var _actionListInlineEdit = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee43(selection) {
        var _this11 = this;

        var $action_set, $action_set_selected_edit_actions, $button_save, $button_cancel, _iterator20, _step20, _loop10;

        return _regenerator.default.wrap(function _callee43$(_context43) {
          while (1) {
            switch (_context43.prev = _context43.next) {
              case 0:
                if (selection.length && !this.$container.find('.sb-view-header-list-actions-selected-edit').length) {
                  this.$headerContainer.find('#' + 'SB_ACTION_ITEM-' + 'SB_ACTIONS_BUTTON_INLINE_UPDATE').hide();
                  this.$headerContainer.find('#' + 'SB_ACTION_ITEM-' + 'SB_ACTIONS_BUTTON_BULK_ASSIGN').show();
                  $action_set = this.$container.find('.sb-view-header-actions-std');
                  $action_set_selected_edit_actions = (0, _jqueryLib.$)('<div/>').addClass('sb-view-header-list-actions-selected-edit');
                  $button_save = _materialLib.UIHelper.createButton('action-selected-edit-save', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_SAVE'), 'raised', '', 'secondary').appendTo($action_set_selected_edit_actions);
                  $button_cancel = _materialLib.UIHelper.createButton('action-selected-edit-cancel', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_CANCEL'), 'outlined').appendTo($action_set_selected_edit_actions);
                  $action_set.append($action_set_selected_edit_actions);
                  $button_save.on('click', function () {
                    // handle changed objects
                    var objects = _this11.model.getChanges(selection);

                    var promises = [];

                    var _iterator18 = _createForOfIteratorHelper(selection),
                        _step18;

                    try {
                      var _loop8 = function _loop8() {
                        var object_id = _step18.value;
                        var promise = new Promise( /*#__PURE__*/function () {
                          var _ref20 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee39(resolve, reject) {
                            var object;
                            return _regenerator.default.wrap(function _callee39$(_context39) {
                              while (1) {
                                switch (_context39.prev = _context39.next) {
                                  case 0:
                                    object = objects.find(function (o) {
                                      return o.id == object_id;
                                    });

                                    _this11.$layoutContainer.find('tr[data-id="' + object_id + '"]').each( /*#__PURE__*/function () {
                                      var _ref21 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee38(i, tr) {
                                        var $tr, response, res;
                                        return _regenerator.default.wrap(function _callee38$(_context38) {
                                          while (1) {
                                            switch (_context38.prev = _context38.next) {
                                              case 0:
                                                $tr = (0, _jqueryLib.$)(tr);

                                                if (object) {
                                                  _context38.next = 7;
                                                  break;
                                                }

                                                $tr.trigger('_toggle_mode', 'view');
                                                $tr.attr('data-edit', '0');
                                                resolve(true);
                                                _context38.next = 29;
                                                break;

                                              case 7:
                                                _context38.prev = 7;
                                                _context38.next = 10;
                                                return _equalServices.ApiService.update(_this11.entity, [object_id], _this11.model.export(object), false, _this11.getLang());

                                              case 10:
                                                response = _context38.sent;
                                                $tr.trigger('_toggle_mode', 'view');
                                                $tr.attr('data-edit', '0'); // update the modfied field otherwise a confirmation will be displayed at next update

                                                if (Array.isArray(response) && response.length) {
                                                  _this11.model.reset(object_id, response[0]);
                                                }

                                                resolve(true);
                                                _context38.next = 29;
                                                break;

                                              case 17:
                                                _context38.prev = 17;
                                                _context38.t0 = _context38["catch"](7);
                                                _context38.prev = 19;
                                                _context38.next = 22;
                                                return _this11.displayErrorFeedback(_this11.translation, _context38.t0, object, true);

                                              case 22:
                                                res = _context38.sent;

                                                if (res === false) {
                                                  reject();
                                                } else {
                                                  resolve(true);
                                                }

                                                _context38.next = 29;
                                                break;

                                              case 26:
                                                _context38.prev = 26;
                                                _context38.t1 = _context38["catch"](19);
                                                reject();

                                              case 29:
                                              case "end":
                                                return _context38.stop();
                                            }
                                          }
                                        }, _callee38, null, [[7, 17], [19, 26]]);
                                      }));

                                      return function (_x28, _x29) {
                                        return _ref21.apply(this, arguments);
                                      };
                                    }());

                                  case 2:
                                  case "end":
                                    return _context39.stop();
                                }
                              }
                            }, _callee39);
                          }));

                          return function (_x26, _x27) {
                            return _ref20.apply(this, arguments);
                          };
                        }());
                        promises.push(promise);
                      };

                      for (_iterator18.s(); !(_step18 = _iterator18.n()).done;) {
                        _loop8();
                      }
                    } catch (err) {
                      _iterator18.e(err);
                    } finally {
                      _iterator18.f();
                    }

                    Promise.all(promises).then(function () {
                      $action_set_selected_edit_actions.remove();

                      _this11.$headerContainer.find('#' + 'SB_ACTION_ITEM-' + 'SB_ACTIONS_BUTTON_INLINE_UPDATE').show();

                      _this11.$headerContainer.find('#' + 'SB_ACTION_ITEM-' + 'SB_ACTIONS_BUTTON_BULK_ASSIGN').hide();
                    }).catch(function () {});
                  });
                  $button_cancel.on('click', function () {
                    // restore original values for changed objects
                    var objects = _this11.model.getChanges(selection);

                    var _iterator19 = _createForOfIteratorHelper(objects),
                        _step19;

                    try {
                      var _loop9 = function _loop9() {
                        var object = _step19.value;
                        var object_id = object.id;

                        _this11.$layoutContainer.find('tr[data-id="' + object_id + '"]').each( /*#__PURE__*/function () {
                          var _ref23 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee41(i, tr) {
                            var $tr, original, _i4, _Object$keys2, field;

                            return _regenerator.default.wrap(function _callee41$(_context41) {
                              while (1) {
                                switch (_context41.prev = _context41.next) {
                                  case 0:
                                    $tr = (0, _jqueryLib.$)(tr);
                                    original = $tr.data('original');

                                    for (_i4 = 0, _Object$keys2 = Object.keys(original); _i4 < _Object$keys2.length; _i4++) {
                                      field = _Object$keys2[_i4];

                                      _this11.layout.updateFieldValue(object_id, field, original[field]);
                                    }

                                  case 3:
                                  case "end":
                                    return _context41.stop();
                                }
                              }
                            }, _callee41);
                          }));

                          return function (_x32, _x33) {
                            return _ref23.apply(this, arguments);
                          };
                        }());
                      };

                      for (_iterator19.s(); !(_step19 = _iterator19.n()).done;) {
                        _loop9();
                      }
                    } catch (err) {
                      _iterator19.e(err);
                    } finally {
                      _iterator19.f();
                    }

                    _this11.$layoutContainer.find('tr.sb-view-layout-list-row').each( /*#__PURE__*/function () {
                      var _ref22 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee40(i, tr) {
                        var $tr;
                        return _regenerator.default.wrap(function _callee40$(_context40) {
                          while (1) {
                            switch (_context40.prev = _context40.next) {
                              case 0:
                                $tr = (0, _jqueryLib.$)(tr);
                                $tr.trigger('_toggle_mode', 'view');
                                $tr.attr('data-edit', '0');

                              case 3:
                              case "end":
                                return _context40.stop();
                            }
                          }
                        }, _callee40);
                      }));

                      return function (_x30, _x31) {
                        return _ref22.apply(this, arguments);
                      };
                    }());

                    $action_set_selected_edit_actions.remove();

                    _this11.$headerContainer.find('#' + 'SB_ACTION_ITEM-' + 'SB_ACTIONS_BUTTON_INLINE_UPDATE').show();

                    _this11.$headerContainer.find('#' + 'SB_ACTION_ITEM-' + 'SB_ACTIONS_BUTTON_BULK_ASSIGN').hide();

                    _this11.selected_ids = [];

                    _this11.layout.setSelection(_this11.selected_ids);

                    return false;
                  });
                }

                _iterator20 = _createForOfIteratorHelper(selection);

                try {
                  _loop10 = function _loop10() {
                    var object_id = _step20.value;

                    _this11.$layoutContainer.find('tr[data-id="' + object_id + '"]').each( /*#__PURE__*/function () {
                      var _ref24 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee42(i, tr) {
                        var $tr, $td, collection, object;
                        return _regenerator.default.wrap(function _callee42$(_context42) {
                          while (1) {
                            switch (_context42.prev = _context42.next) {
                              case 0:
                                $tr = (0, _jqueryLib.$)(tr);
                                $tr.addClass('sb-widget'); // not already in edit mode

                                if (!($tr.attr('data-edit') != '1')) {
                                  _context42.next = 11;
                                  break;
                                }

                                $td = $tr.children().first();
                                _context42.next = 6;
                                return _this11.model.get([object_id]);

                              case 6:
                                collection = _context42.sent;
                                object = collection[0]; // save original object in the row

                                $tr.data('original', _this11.deepCopy(object)); // mark row as being edited (prevent click handling)

                                $tr.attr('data-edit', '1'); // for each widget of the row, switch to edit mode

                                $tr.trigger('_toggle_mode', 'edit');

                              case 11:
                              case "end":
                                return _context42.stop();
                            }
                          }
                        }, _callee42);
                      }));

                      return function (_x34, _x35) {
                        return _ref24.apply(this, arguments);
                      };
                    }());
                  };

                  for (_iterator20.s(); !(_step20 = _iterator20.n()).done;) {
                    _loop10();
                  }
                } catch (err) {
                  _iterator20.e(err);
                } finally {
                  _iterator20.f();
                }

              case 3:
              case "end":
                return _context43.stop();
            }
          }
        }, _callee43, this);
      }));

      function actionListInlineEdit(_x25) {
        return _actionListInlineEdit.apply(this, arguments);
      }

      return actionListInlineEdit;
    }()
    /**
     *
     * This method can be invoked by methods from the Layout class.
     *
     * @param translation   Associative array mapping transaltions sections with their values (@see http://doc.equal.run/usage/i18n/)
     * @param response      HttpResponse holding the error description.
     * @param object        Object involved in the HTTP request that returned with an error status.
     * @param snack         Flag to request a snack showing the error message. BY default, no snack is created.
     *
     * @returns
     */

  }, {
    key: "displayErrorFeedback",
    value: function () {
      var _displayErrorFeedback = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee44(translation, response) {
        var _this12 = this;

        var object,
            snack,
            delay,
            errors,
            i,
            _loop11,
            field,
            error_id,
            msg,
            translated_msg,
            translated_error,
            $snack,
            _msg,
            _$snack,
            _i5,
            _loop12,
            _field,
            _error_id,
            _msg2,
            _translated_msg,
            _translated_error2,
            _$snack2,
            _i6,
            _loop13,
            _field2,
            _response,
            title,
            _msg3,
            _$snack3,
            _args44 = arguments;

        return _regenerator.default.wrap(function _callee44$(_context44) {
          while (1) {
            switch (_context44.prev = _context44.next) {
              case 0:
                object = _args44.length > 2 && _args44[2] !== undefined ? _args44[2] : null;
                snack = _args44.length > 3 && _args44[3] !== undefined ? _args44[3] : true;
                console.debug('View::displayErrorFeedback', translation, response, object, snack);
                delay = 4000;

                if (!(response && response.hasOwnProperty('errors'))) {
                  _context44.next = 43;
                  break;
                }

                errors = response['errors'];

                if (!errors.hasOwnProperty('INVALID_PARAM')) {
                  _context44.next = 10;
                  break;
                }

                if (typeof errors['INVALID_PARAM'] == 'object') {
                  i = 0; // stack snackbars (LIFO: decreasing timeout)

                  _loop11 = function _loop11(field) {
                    // for each field, we handle one error at a time (the first one)
                    var error_id = String(Object.keys(errors['INVALID_PARAM'][field])[0]);
                    var msg = Object.values(errors['INVALID_PARAM'][field])[0];

                    var translated_msg = _equalServices.TranslationService.resolve(translation, 'error', [], field, msg, error_id);

                    if (translated_msg == msg.replace(/_/g, ' ')) {
                      var translated_error = _equalServices.TranslationService.instant('SB_ERROR_' + error_id.toUpperCase());

                      if (translated_error != 'SB_ERROR_' + error_id.toUpperCase()) {
                        translated_msg = translated_error;
                      }
                    } // update widget to provide feedback (as error hint)


                    if (object) {
                      _this12.layout.markFieldAsInvalid(object['id'], field, translated_msg);
                    } // generate snack, if required


                    if (snack) {
                      setTimeout(function () {
                        var title = _equalServices.TranslationService.resolve(translation, 'model', [], field, field, 'label');

                        var $snack = _materialLib.UIHelper.createSnackbar(title + ': ' + translated_msg, _equalServices.TranslationService.instant('SB_ERROR_ERROR'), '', delay);

                        _this12.$container.append($snack);
                      }, delay * i);
                    }

                    ++i;
                  };

                  for (field in errors['INVALID_PARAM']) {
                    _loop11(field);
                  }
                } // errors['INVALID_PARAM'] is a string
                else {
                    if (snack) {
                      error_id = String(errors['INVALID_PARAM']); // try to resolve the error message

                      msg = _equalServices.TranslationService.instant('SB_ERROR_INVALID_PARAM');
                      translated_msg = _equalServices.TranslationService.resolve(translation, 'error', [], 'errors', error_id, error_id);

                      if (translated_msg == error_id.replace(/_/g, ' ')) {
                        translated_error = _equalServices.TranslationService.instant('SB_ERROR_' + error_id.toUpperCase());

                        if (translated_error != 'SB_ERROR_' + error_id.toUpperCase()) {
                          msg = translated_error;
                        }
                      } else {
                        msg = translated_msg;
                      }

                      $snack = _materialLib.UIHelper.createSnackbar(msg, _equalServices.TranslationService.instant('SB_ERROR_ERROR'), '', 4000);
                      this.$container.append($snack);
                    }
                  }

                _context44.next = 43;
                break;

              case 10:
                if (!errors.hasOwnProperty('MISSING_PARAM')) {
                  _context44.next = 16;
                  break;
                }

                _msg = _equalServices.TranslationService.instant('SB_ERROR_CONFIG_MISSING_PARAM');
                _$snack = _materialLib.UIHelper.createSnackbar(_msg + ' \'' + errors['MISSING_PARAM'] + '\'', _equalServices.TranslationService.instant('SB_ERROR_ERROR'), '', delay);
                this.$container.append(_$snack);
                _context44.next = 43;
                break;

              case 16:
                if (!errors.hasOwnProperty('NOT_ALLOWED')) {
                  _context44.next = 20;
                  break;
                }

                if (typeof errors['NOT_ALLOWED'] == 'object') {
                  _i5 = 0; // stack snackbars (LIFO: decreasing timeout)

                  _loop12 = function _loop12(_field) {
                    // for each field, we handle one error at a time (the first one)
                    var error_id = String(Object.keys(errors['NOT_ALLOWED'][_field])[0]);
                    var msg = Object.values(errors['NOT_ALLOWED'][_field])[0];

                    var translated_msg = _equalServices.TranslationService.resolve(translation, 'error', [], _field, msg, error_id);

                    if (translated_msg == msg.replace(/_/g, ' ')) {
                      var _translated_error = _equalServices.TranslationService.instant('SB_ERROR_' + error_id.toUpperCase());

                      if (_translated_error != 'SB_ERROR_' + error_id.toUpperCase()) {
                        translated_msg = _translated_error;
                      }
                    } // update widget to provide feedback (as error hint)


                    if (object) {
                      _this12.layout.markFieldAsInvalid(object['id'], _field, translated_msg);
                    } // generate snack, if required


                    if (snack) {
                      setTimeout(function () {
                        var title = _equalServices.TranslationService.resolve(translation, 'model', [], _field, _field, 'label');

                        var $snack = _materialLib.UIHelper.createSnackbar(title + ': ' + translated_msg, _equalServices.TranslationService.instant('SB_ERROR_ERROR'), '', delay);

                        _this12.$container.append($snack);
                      }, delay * _i5);
                    }

                    ++_i5;
                  };

                  for (_field in errors['NOT_ALLOWED']) {
                    _loop12(_field);
                  }
                } // errors['NOT_ALLOWED'] is a string
                else {
                    if (snack) {
                      _error_id = String(errors['NOT_ALLOWED']);
                      _msg2 = _equalServices.TranslationService.instant('SB_ERROR_NOT_ALLOWED'); // try to resolve the error message

                      _translated_msg = _equalServices.TranslationService.resolve(translation, 'error', [], 'errors', _error_id, _error_id);

                      if (_translated_msg == _error_id.replace(/_/g, ' ')) {
                        _translated_error2 = _equalServices.TranslationService.instant('SB_ERROR_' + _error_id.toUpperCase());

                        if (_translated_error2 != 'SB_ERROR_' + _error_id.toUpperCase()) {
                          _msg2 = _translated_error2;
                        }
                      } else {
                        _msg2 = _translated_msg;
                      }

                      _$snack2 = _materialLib.UIHelper.createSnackbar(_msg2, _equalServices.TranslationService.instant('SB_ERROR_ERROR'), '', delay);
                      this.$container.append(_$snack2);
                    }
                  }

                _context44.next = 43;
                break;

              case 20:
                if (!errors.hasOwnProperty('CONFLICT_OBJECT')) {
                  _context44.next = 43;
                  break;
                }

                if (!(typeof errors['CONFLICT_OBJECT'] == 'object')) {
                  _context44.next = 27;
                  break;
                }

                _i6 = 0;

                _loop13 = function _loop13(_field2) {
                  var msg = _equalServices.TranslationService.instant('SB_ERROR_DUPLICATE_VALUE');

                  if (object) {
                    _this12.layout.markFieldAsInvalid(object['id'], _field2, msg);
                  }

                  if (snack) {
                    setTimeout(function () {
                      var title = _equalServices.TranslationService.resolve(translation, 'model', [], _field2, _field2, 'label');

                      var $snack = _materialLib.UIHelper.createSnackbar(title + ': ' + msg, _equalServices.TranslationService.instant('SB_ERROR_ERROR'), '', delay);

                      _this12.$container.append($snack);
                    }, delay * _i6);
                  }

                  ++_i6;
                };

                for (_field2 in errors['CONFLICT_OBJECT']) {
                  _loop13(_field2);
                }

                _context44.next = 43;
                break;

              case 27:
                if (!(errors['CONFLICT_OBJECT'] == 'concurrent_change')) {
                  _context44.next = 42;
                  break;
                }

                _context44.prev = 28;
                _context44.next = 31;
                return new Promise(function (resolve, reject) {
                  var confirmed = confirm(_equalServices.TranslationService.instant('SB_ACTIONS_MESSAGE_ERASE_CONCURRENT_CHANGES'));
                  return confirmed ? resolve(true) : reject(false);
                });

              case 31:
                _context44.next = 33;
                return _equalServices.ApiService.update(this.entity, [object['id']], this.model.export(object), true, this.getLang());

              case 33:
                _response = _context44.sent;
                return _context44.abrupt("return", _response);

              case 37:
                _context44.prev = 37;
                _context44.t0 = _context44["catch"](28);
                throw _context44.t0;

              case 40:
                _context44.next = 43;
                break;

              case 42:
                if (snack) {
                  title = _equalServices.TranslationService.instant('SB_ERROR_CONFLICT_OBJECT'); // try to resolve the error message

                  _msg3 = _equalServices.TranslationService.resolve(translation, 'error', [], 'errors', errors['CONFLICT_OBJECT'], errors['CONFLICT_OBJECT']);
                  _$snack3 = _materialLib.UIHelper.createSnackbar(title + ' ' + _msg3, _equalServices.TranslationService.instant('SB_ERROR_ERROR'), '', 4000);
                  this.$container.append(_$snack3);
                }

              case 43:
                return _context44.abrupt("return", false);

              case 44:
              case "end":
                return _context44.stop();
            }
          }
        }, _callee44, this, [[28, 37]]);
      }));

      function displayErrorFeedback(_x36, _x37) {
        return _displayErrorFeedback.apply(this, arguments);
      }

      return displayErrorFeedback;
    }()
  }, {
    key: "translateFilterClause",
    value: function () {
      var _translateFilterClause = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee45(clause) {
        var result, _iterator21, _step21, conditionObj, condition, translation, model_fields, operand, operator, value, field, res_operand, res_operator, res_value, type, translated, values, _i7, n, entity, response, _object;

        return _regenerator.default.wrap(function _callee45$(_context45) {
          while (1) {
            switch (_context45.prev = _context45.next) {
              case 0:
                result = '';
                console.debug('View::translateFilterClause', clause);
                _iterator21 = _createForOfIteratorHelper(clause.getConditions());
                _context45.prev = 3;

                _iterator21.s();

              case 5:
                if ((_step21 = _iterator21.n()).done) {
                  _context45.next = 58;
                  break;
                }

                conditionObj = _step21.value;
                condition = conditionObj.toArray();

                if (!(condition.length == 3)) {
                  _context45.next = 56;
                  break;
                }

                translation = this.getTranslation();
                model_fields = this.getModelFields();
                operand = condition[0];
                operator = condition[1];
                value = condition[2];
                field = operand; // assign default resulting values

                res_operand = operand;
                res_operator = operator;
                res_value = value;
                /*
                    Translate field
                */

                res_operand = _equalServices.TranslationService.resolve(translation, 'model', [], field, field, 'label');
                /*
                    Translate operator
                */

                _context45.t0 = operator;
                _context45.next = _context45.t0 === 'like' ? 22 : _context45.t0 === 'in' ? 23 : _context45.t0 === 'is' ? 23 : _context45.t0 === '=' ? 23 : _context45.t0 === 'not in' ? 25 : _context45.t0 === '<>' ? 25 : _context45.t0 === '!=' ? 25 : 27;
                break;

              case 22:
                res_value = res_value.replace(/%/g, '');

              case 23:
                res_operator = '=';
                return _context45.abrupt("break", 27);

              case 25:
                res_operator = '<>';
                return _context45.abrupt("break", 27);

              case 27:
                if (!model_fields.hasOwnProperty(field)) {
                  _context45.next = 54;
                  break;
                }

                // get field type
                type = this.model.getFinalType(field); // handle translation by type

                if (!(type == 'string' && model_fields[field].selection)) {
                  _context45.next = 36;
                  break;
                }

                translated = _equalServices.TranslationService.resolve(translation, 'model', [], field, model_fields[field].selection, 'selection'); // assign translation map

                values = translated; // normalize translation map

                if (Array.isArray(translated)) {
                  values = {};

                  for (_i7 = 0, n = model_fields[field].selection.length; _i7 < n; ++_i7) {
                    values[model_fields[field].selection[_i7]] = translated[_i7];
                  }
                }

                if (values.hasOwnProperty(value)) {
                  res_value = values[value];
                }

                _context45.next = 54;
                break;

              case 36:
                if (!(['date', 'datetime'].indexOf(type) >= 0)) {
                  _context45.next = 41;
                  break;
                }

                if (value instanceof Date) {
                  res_value = value.toISOString();
                }

                res_value = res_value.substring(0, 10);
                _context45.next = 54;
                break;

              case 41:
                if (!(type == 'many2one')) {
                  _context45.next = 54;
                  break;
                }

                if (!model_fields[field].hasOwnProperty('foreign_object')) {
                  _context45.next = 54;
                  break;
                }

                entity = model_fields[field].foreign_object; // value should be an ID
                // read name field of targeted entity

                _context45.prev = 44;
                _context45.next = 47;
                return _equalServices.ApiService.read(entity, [value], ['name'], this.getLang());

              case 47:
                response = _context45.sent;
                _object = response[0];
                res_value = _object['name'];
                _context45.next = 54;
                break;

              case 52:
                _context45.prev = 52;
                _context45.t1 = _context45["catch"](44);

              case 54:
                if (result.length) {
                  result = result + ' & ';
                }

                result = res_operand + ' ' + res_operator + ' ' + res_value;

              case 56:
                _context45.next = 5;
                break;

              case 58:
                _context45.next = 63;
                break;

              case 60:
                _context45.prev = 60;
                _context45.t2 = _context45["catch"](3);

                _iterator21.e(_context45.t2);

              case 63:
                _context45.prev = 63;

                _iterator21.f();

                return _context45.finish(63);

              case 66:
                return _context45.abrupt("return", result);

              case 67:
              case "end":
                return _context45.stop();
            }
          }
        }, _callee45, this, [[3, 60, 63, 66], [44, 52]]);
      }));

      function translateFilterClause(_x38) {
        return _translateFilterClause.apply(this, arguments);
      }

      return translateFilterClause;
    }()
  }]);
  return View;
}();

exports.View = View;
var _default = View;
exports.default = _default;

/***/ }),

/***/ "./build/equal-layouts.js":
/*!********************************!*\
  !*** ./build/equal-layouts.js ***!
  \********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LayoutFactory = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _equalLib = __webpack_require__(/*! ./equal-lib */ "./build/equal-lib.js");

var _LayoutList = __webpack_require__(/*! ./layouts/LayoutList */ "./build/layouts/LayoutList.js");

var _LayoutForm = __webpack_require__(/*! ./layouts/LayoutForm */ "./build/layouts/LayoutForm.js");

var _LayoutSearch = __webpack_require__(/*! ./layouts/LayoutSearch */ "./build/layouts/LayoutSearch.js");

var _LayoutChart = __webpack_require__(/*! ./layouts/LayoutChart */ "./build/layouts/LayoutChart.js");

var _LayoutDashboard = __webpack_require__(/*! ./layouts/LayoutDashboard */ "./build/layouts/LayoutDashboard.js");

var LayoutFactory = /*#__PURE__*/function () {
  function LayoutFactory() {
    (0, _classCallCheck2.default)(this, LayoutFactory);
  }

  (0, _createClass2.default)(LayoutFactory, null, [{
    key: "getLayout",
    value:
    /**
     * Layout factory : maps type guessed from view with a specific layout.
     * @param {View} view
     */
    function getLayout(view) {
      var type = view.getType();

      switch (type) {
        case 'list':
          return new _LayoutList.LayoutList(view);

        case 'form':
          return new _LayoutForm.LayoutForm(view);

        case 'search':
          return new _LayoutSearch.LayoutSearch(view);

        case 'chart':
          return new _LayoutChart.LayoutChart(view);

        case 'dashboard':
          return new _LayoutDashboard.LayoutDashboard(view);
      }

      return new _equalLib.Layout(view);
    }
  }]);
  return LayoutFactory;
}();

exports.LayoutFactory = LayoutFactory;

/***/ }),

/***/ "./build/equal-lib.js":
/*!****************************!*\
  !*** ./build/equal-lib.js ***!
  \****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Domain", ({
  enumerable: true,
  get: function get() {
    return _Domain.default;
  }
}));
Object.defineProperty(exports, "DateReference", ({
  enumerable: true,
  get: function get() {
    return _DateReference.default;
  }
}));
Object.defineProperty(exports, "Frame", ({
  enumerable: true,
  get: function get() {
    return _Frame.default;
  }
}));
Object.defineProperty(exports, "Context", ({
  enumerable: true,
  get: function get() {
    return _Context.default;
  }
}));
Object.defineProperty(exports, "Layout", ({
  enumerable: true,
  get: function get() {
    return _Layout.default;
  }
}));
Object.defineProperty(exports, "Model", ({
  enumerable: true,
  get: function get() {
    return _Model.default;
  }
}));
Object.defineProperty(exports, "View", ({
  enumerable: true,
  get: function get() {
    return _View.default;
  }
}));

var _Domain = _interopRequireDefault(__webpack_require__(/*! ./Domain */ "./build/Domain.js"));

var _DateReference = _interopRequireDefault(__webpack_require__(/*! ./DateReference */ "./build/DateReference.js"));

var _Frame = _interopRequireDefault(__webpack_require__(/*! ./Frame */ "./build/Frame.js"));

var _Context = _interopRequireDefault(__webpack_require__(/*! ./Context */ "./build/Context.js"));

var _Layout = _interopRequireDefault(__webpack_require__(/*! ./layouts/Layout */ "./build/layouts/Layout.js"));

var _Model = _interopRequireDefault(__webpack_require__(/*! ./Model */ "./build/Model.js"));

var _View = _interopRequireDefault(__webpack_require__(/*! ./View */ "./build/View.js"));

/***/ }),

/***/ "./build/equal-services.js":
/*!*********************************!*\
  !*** ./build/equal-services.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.TranslationService = exports.EnvService = exports.ApiService = void 0;

var _ApiService2 = _interopRequireDefault(__webpack_require__(/*! ./ApiService */ "./build/ApiService.js"));

var _EnvService2 = _interopRequireDefault(__webpack_require__(/*! ./EnvService */ "./build/EnvService.js"));

var _TranslationService2 = _interopRequireDefault(__webpack_require__(/*! ./TranslationService */ "./build/TranslationService.js"));

/**
 * Singleton instances
 */
var ApiService = new _ApiService2.default();
exports.ApiService = ApiService;
var EnvService = new _EnvService2.default();
exports.EnvService = EnvService;
var TranslationService = new _TranslationService2.default();
exports.TranslationService = TranslationService;

/***/ }),

/***/ "./build/equal-widgets.js":
/*!********************************!*\
  !*** ./build/equal-widgets.js ***!
  \********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "Widget", ({
  enumerable: true,
  get: function get() {
    return _Widget.default;
  }
}));
exports.WidgetFactory = void 0;

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _Widget = _interopRequireDefault(__webpack_require__(/*! ./widgets/Widget */ "./build/widgets/Widget.js"));

var _WidgetBoolean = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetBoolean */ "./build/widgets/WidgetBoolean.js"));

var _WidgetDate = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetDate */ "./build/widgets/WidgetDate.js"));

var _WidgetDateTime = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetDateTime */ "./build/widgets/WidgetDateTime.js"));

var _WidgetInteger = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetInteger */ "./build/widgets/WidgetInteger.js"));

var _WidgetFloat = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetFloat */ "./build/widgets/WidgetFloat.js"));

var _WidgetString = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetString */ "./build/widgets/WidgetString.js"));

var _WidgetText = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetText */ "./build/widgets/WidgetText.js"));

var _WidgetLink = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetLink */ "./build/widgets/WidgetLink.js"));

var _WidgetSelect = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetSelect */ "./build/widgets/WidgetSelect.js"));

var _WidgetFile = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetFile */ "./build/widgets/WidgetFile.js"));

var _WidgetImage = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetImage */ "./build/widgets/WidgetImage.js"));

var _WidgetOne2Many = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetOne2Many */ "./build/widgets/WidgetOne2Many.js"));

var _WidgetMany2One = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetMany2One */ "./build/widgets/WidgetMany2One.js"));

var _WidgetMany2Many = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetMany2Many */ "./build/widgets/WidgetMany2Many.js"));

var _WidgetLabel = _interopRequireDefault(__webpack_require__(/*! ./widgets/WidgetLabel */ "./build/widgets/WidgetLabel.js"));

var _equalLib = __webpack_require__(/*! ./equal-lib */ "./build/equal-lib.js");

var _equalServices = __webpack_require__(/*! ./equal-services */ "./build/equal-services.js");

var _Domain = __webpack_require__(/*! ./Domain */ "./build/Domain.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var WidgetFactory = /*#__PURE__*/function () {
  function WidgetFactory() {
    (0, _classCallCheck2.default)(this, WidgetFactory);
  }

  (0, _createClass2.default)(WidgetFactory, null, [{
    key: "getWidget",
    value:
    /*
    Widgets are based on final type either ORM types or special View types
    widgets support two modes : view & edit, and are responsible for rendering accordingly
        un widget à un type, un mode, une valeur (qui s'affiche selon le type et le mode)
    et des infos de décoration: un label et un helper (facultatif)
      les widgets sont liés à des éléments (layout items) qui ont un type propre (fields, label, button, ...)
      les widgets liés à d'autres éléments que des fields disposent d'un ID qui permet de faire le lien avec la View parente et les infos additionnelles (aide, traduction)
    config: {
    id:
    helper:
    view:
    domain:
    }
    */

    /**
     * Widget factory : maps type guessed from model and view schema with a specific widget.
     * @param type
     * @param value
     */
    function getWidget(parent, type, label) {
      var value = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
      var config = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};
      var view_type, layout;

      if (parent instanceof _equalLib.Layout) {
        layout = parent;
        view_type = layout.getView().getType();
      } else {
        layout = new _equalLib.Layout(parent);
        view_type = parent.getType();
      }

      switch (type) {
        case 'boolean':
          return new _WidgetBoolean.default(layout, label, value, config);

        case 'date':
          return new _WidgetDate.default(layout, label, value, config);

        case 'datetime':
          return new _WidgetDateTime.default(layout, label, value, config);

        case 'one2many':
          return new _WidgetOne2Many.default(layout, label, value, config);

        case 'many2one':
          return new _WidgetMany2One.default(layout, label, value, config);

        case 'many2many':
          return new _WidgetMany2Many.default(layout, label, value, config);

        case 'select':
          return new _WidgetSelect.default(layout, label, value, config);

        case 'integer':
          return new _WidgetInteger.default(layout, label, value, config);

        case 'float':
          return new _WidgetFloat.default(layout, label, value, config);

        case 'link':
          return new _WidgetLink.default(layout, label, value, config);

        case 'binary':
        case 'file':
          if (config.hasOwnProperty('usage') && config.usage.substring(0, 5) == 'image') {
            return new _WidgetImage.default(layout, label, value, config);
          }

          return new _WidgetFile.default(layout, label, value, config);

        case 'label':
          return new _WidgetLabel.default(layout, label, value, config);

        case 'text':
          return new _WidgetText.default(layout, label, value, config);

        case 'string':
        default:
          return new _WidgetString.default(layout, label, value, config);
      }
    }
    /**
     * Generate a widget config based on a layout item (from View schema)
     *
     * @param {View} view           View    field
     * @param {string} field        Field name.
     * @param {any} translation     View translation map.
     * @param {any} model_fields    Associative array mapping fields with their model definition.
     * @param {string} view_fields  Associative array mapping fields with their view definition.
     * @return {}                   Returns a widget configuration object.
     */

  }, {
    key: "getWidgetConfig",
    value: function getWidgetConfig(view, field, translation, model_fields, view_fields) {
      var config = {
        widget_type: 'field'
      };
      var item = view_fields[field];

      if (!model_fields || !model_fields.hasOwnProperty(field)) {
        return null;
      }

      var def = model_fields[field];
      var label = item.hasOwnProperty('label') ? item.label : field; // #todo - handle help and relay to Context

      var helper = item.hasOwnProperty('help') ? item.help : def.hasOwnProperty('help') ? def['help'] : '';
      var description = item.hasOwnProperty('description') ? item.description : def.hasOwnProperty('description') ? def['description'] : '';

      if (def.hasOwnProperty('type')) {
        var type = def['type'];

        if (def.hasOwnProperty('result_type')) {
          type = def['result_type'];
        }

        if (def.hasOwnProperty('usage')) {
          switch (def.usage) {
            // #todo - complete the list
            case 'string/text':
            case 'text/plain':
            case 'text/html':
            case 'markup/html':
              type = 'text';
              break;

            case 'uri/url:http':
            case 'uri/url':
              type = 'link';
              break;

            case 'image/gif':
            case 'image/png':
            case 'image/jpeg':
              // binary alt
              type = 'file';
              break;
          }
        }

        config.type = type;
      } else {
        // we shouldn't end up here : malformed schema
        console.warn('ERROR - malformed schema for field ' + field);
        return config;
      }

      if (def.hasOwnProperty('usage')) {
        config.usage = def.usage;
      }

      if (def.hasOwnProperty('foreign_object')) {
        config.foreign_object = def.foreign_object;
      }

      if (def.hasOwnProperty('foreign_field')) {
        config.foreign_field = def.foreign_field;
      }

      if (def.hasOwnProperty('selection')) {
        config.selection = def.selection;
        config.type = 'select';

        var translated = _equalServices.TranslationService.resolve(translation, 'model', [], field, config.selection, 'selection');

        var values = translated;

        if (Array.isArray(translated)) {
          // convert array to a Map (original values as keys and translations as values)
          values = {};

          for (var i = 0, n = config.selection.length; i < n; ++i) {
            values[config.selection[i]] = translated[i];
          }
        }

        config.values = values;
      }

      config.field = field;
      config.visible = true; // #memo - ready property is set to true during the 'feed' phase

      config.ready = false;
      config.title = _equalServices.TranslationService.resolve(translation, 'model', [], field, label, 'label');
      config.description = _equalServices.TranslationService.resolve(translation, 'model', [], field, description, 'description');
      config.readonly = def.hasOwnProperty('readonly') ? def.readonly : item.hasOwnProperty('readonly') ? item['readonly'] : false;
      config.align = item.hasOwnProperty('align') ? item.align : 'left';
      config.sortable = item.hasOwnProperty('sortable') && item.sortable; // only 'list' and 'form' are supported for widgets

      config.layout = view.getType() == 'list' ? 'list' : 'form';
      config.lang = view.getLang();
      config.locale = view.getLocale();

      if (item.hasOwnProperty('widget')) {
        // overload config with widget config, if any
        config = _objectSpread(_objectSpread({}, config), item.widget);
      }

      if (def.hasOwnProperty('visible')) {
        config.visible = def.visible;
      }

      if (item.hasOwnProperty('visible')) {
        config.visible = item.visible;
      } // convert visible property to JSON


      config.visible = eval(config.visible); // for relational fields, we need some additional values

      if (['one2many', 'many2one', 'many2many'].indexOf(config.type) > -1) {
        // defined config for Widget's view with a custom domain according to object values
        var view_id = config.hasOwnProperty('view') ? config.view : 'list.default';
        var parts = view_id.split(".", 2);
        var view_type = parts.length > 1 ? parts[0] : 'list';
        var view_name = parts.length > 1 ? parts[1] : parts[0];
        var def_domain = def.hasOwnProperty('domain') ? def['domain'] : [];
        var view_domain = config.hasOwnProperty('domain') ? config['domain'] : [];
        var domain = new _Domain.Domain(def_domain);
        domain.merge(new _Domain.Domain(view_domain));
        config = _objectSpread(_objectSpread({}, config), {}, {
          entity: def['foreign_object'],
          view_type: view_type,
          view_name: view_name,
          original_domain: domain.toArray(),
          has_action_create: true,
          has_action_open: true,
          has_action_select: true
        });

        if (config.hasOwnProperty('header')) {
          if (config.header === false) {
            config.has_action_create = false;
            config.has_action_open = false;
            config.has_action_select = false;
          } else if (config.header.hasOwnProperty('actions')) {
            if (config.header.actions.hasOwnProperty('ACTION.CREATE')) {
              config.has_action_create = config.header.actions['ACTION.CREATE'];
            }

            if (config.header.actions.hasOwnProperty('ACTION.OPEN')) {
              config.has_action_open = config.header.actions['ACTION.OPEN'];
            }

            if (config.header.actions.hasOwnProperty('ACTION.SELECT')) {
              config.has_action_select = config.header.actions['ACTION.SELECT'];
            }
          }
        }
      }

      return config;
    }
  }]);
  return WidgetFactory;
}();

exports.WidgetFactory = WidgetFactory;

/***/ }),

/***/ "./build/i18n/jqueryui.js":
/*!********************************!*\
  !*** ./build/i18n/jqueryui.js ***!
  \********************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.locale = void 0;
var locale = {
  'fr': {
    closeText: "Fermer",
    prevText: "Précédent",
    nextText: "Suivant",
    currentText: "Aujourd'hui",
    monthNames: ["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"],
    monthNamesShort: ["janv.", "févr.", "mars", "avr.", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc."],
    dayNames: ["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"],
    dayNamesShort: ["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."],
    dayNamesMin: ["D", "L", "M", "M", "J", "V", "S"],
    weekHeader: "Sem.",
    dateFormat: "dd/mm/yy",
    firstDay: 1,
    isRTL: false,
    showMonthAfterYear: false,
    yearSuffix: ""
  }
};
exports.locale = locale;

/***/ }),

/***/ "./build/jquery-datepicker.js":
/*!************************************!*\
  !*** ./build/jquery-datepicker.js ***!
  \************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";
var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

(function (root, factory) {
  if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js")], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
})(void 0, function ($) {
  console.log('Init jquery-datepicker', $.datepicker); // overriding functions meant to be private (starting with an underscore)

  $.datepicker._updateDatepicker_orig = $.datepicker._updateDatepicker;
  $.datepicker._doKeyDown_orig = $.datepicker._doKeyDown;
  $.datepicker._newInst_orig = $.datepicker._newInst;
  $.datepicker._getDateDatepicker_orig = $.datepicker._getDateDatepicker;
  $.extend($.datepicker, {
    _newInst: function _newInst(target, inline) {
      var inst = this._newInst_orig(target, inline); // inject additional default values


      var today = new Date();
      inst.settings = $.extend({}, inst.settings, {
        datetime: false,
        twentyFour: false,
        showSeconds: false
      });
      this.setHours(inst, today.getHours());
      this.setMinutes(inst, today.getMinutes());
      this.setSeconds(inst, 0);
      return inst;
    },
    _doKeyDown: function _doKeyDown(event) {
      var inst = $.datepicker._getInst(event.target);

      var handled = true; //var isRTL = inst.dpDiv.is('.ui-datepicker-rtl');

      inst._keyEvent = true;

      if ($.datepicker._datepickerShowing) {
        switch (event.keyCode) {
          case 27:
            if ($('.ui-datepicker-select-month').is(':visible')) {
              $.datepicker._updateDatepicker(inst);
            } else if ($('.ui-datepicker-select-year').is(':visible')) {
              $.datepicker._toggleDisplay('#' + inst.id, 2, this);
            } else {
              // hide on esc
              $.datepicker._hideDatepicker();
            }

            break;

          default:
            //call the original function
            $.datepicker._doKeyDown_orig(event);

        }
      } else {
        //call the original function
        $.datepicker._doKeyDown_orig(event);
      }
    },
    _setDateTimeDatepicker: function _setDateTimeDatepicker(target, date) {
      var inst = $.datepicker._getInst(target);

      this._setDateDatepicker(target, date);

      this.setHours(inst, date.getHours());
      this.setMinutes(inst, date.getMinutes());
      this.setSeconds(inst, date.getSeconds());
      this.setText(inst);
    },
    _getDateDatepicker: function _getDateDatepicker(target, noDefault) {
      var date = this._getDateDatepicker_orig(target, noDefault);

      var inst = $.datepicker._getInst(target);

      if (!date) {
        date = new Date();
      }

      if (inst) {
        date = new Date(date.getFullYear(), date.getMonth(), date.getDate(), inst.selectedHour, inst.selectedMin, inst.selectedSec);
      }

      return date;
    },
    _updateDatepicker: function _updateDatepicker(inst) {
      //call the original function
      this._updateDatepicker_orig(inst); //TODO: multiMonth


      var numMonths = this._getNumberOfMonths(inst);

      var isMultiMonth = numMonths[0] != 1 || numMonths[1] != 1;

      var changeMonth = this._get(inst, 'changeMonth');

      var changeYear = this._get(inst, 'changeYear');

      if (isMultiMonth || changeMonth || changeYear) {
        return;
      }

      var uidptitle = inst.dpDiv.find('.ui-datepicker-title');
      inst.dpDiv.append(this._generateMonthYearPicker(inst));

      if (inst.settings.datetime) {
        var time_button = $('<button class="mdc-button mdc-button--raised"><span class="material-icons mdc-fab__icon">access_time</span></button>');
        uidptitle.parent().append($('<div />').addClass('ui-datepicker-header-time-switch').append(time_button));
        time_button.on('click', function () {
          $.datepicker._toggleDisplay('#' + inst.id, 4);

          return false;
        });
        inst.dpDiv.append(this._generateTimePicker(inst));
        this.setText(inst);
      }

      var uidptitle_link = uidptitle.wrapInner('<a href="#"/>');
      uidptitle_link.on('click', function () {
        $.datepicker._toggleDisplay('#' + inst.id, 2);

        return false;
      });
    },
    //focus the date input field
    _instInputFocus_MYP: function _instInputFocus_MYP(inst) {
      //code copied from datePicker's _updateDatepicker()
      if (inst == $.datepicker._curInst && $.datepicker._datepickerShowing && inst.input && // #6694 - don't focus the input if it's already focused
      // this breaks the change event in IE
      inst.input.is(':visible') && !inst.input.is(':disabled') && inst.input[0] != document.activeElement) inst.input.focus();
    },
    _generateMonthPickerHTML_MonthYearPicker: function _generateMonthPickerHTML_MonthYearPicker(inst, minDate, maxDate, drawMonth, inMinYear, inMaxYear) {
      //TODO RTL?
      var monthNamesShort = this._get(inst, 'monthNamesShort');

      var monthPicker = '<table><tbody><tr>';
      var unselectable = false;

      for (var month = 0; month < 12;) {
        unselectable = inMinYear && month < minDate.getMonth() || inMaxYear && month > maxDate.getMonth();
        monthPicker += '<td class="' + (unselectable ? ' ' + this._unselectableClass + ' ui-state-disabled' : '') + ( // highlight unselectable months
        month == drawMonth ? ' ui-datepicker-today' : '') + '"' + (unselectable ? '' : ' onclick="$.datepicker._pickMonthYear_MonthYearPicker(\'#' + inst.id + '\', ' + month + ', \'M\');return false;"') + '>' + ( // actions
        unselectable ? '<span class="ui-state-default">' + monthNamesShort[month] + '</span>' : '<a class="ui-state-default ' + ( //(month == drawMonth ? ' ui-state-highlight' : '') +
        month == drawMonth ? ' ui-state-active' : '') + // highlight selected day
        //(otherMonth ? ' ui-priority-secondary' : '') + // distinguish dates from other months
        '" href="#">' + monthNamesShort[month] + '</a>') + '</td>'; // display selectable date

        if (++month % 4 === 0) {
          monthPicker += '</tr>';

          if (month != 12) {
            monthPicker += '<tr>';
          }
        }
      }

      monthPicker += '</tbody></table>';
      return monthPicker;
    },
    _incrementTime: function _incrementTime(inst, targetClass, operator) {
      if (targetClass.endsWith('hours')) {
        this.setHours(inst, eval(this.getHours(inst) + operator + '1'));
      } else if (targetClass.endsWith('minutes')) {
        this.setMinutes(inst, eval(this.getMinutes(inst) + operator + '1'));
      } else if (targetClass.endsWith('seconds')) {
        this.setSeconds(inst, eval(this.getSeconds(inst) + operator + '1'));
      } else {
        this.setMeridiem(inst);
      }

      this.setText(inst);

      if (inst.input && inst.input.hasClass('hasDatepicker')) {
        inst.input.change();
      }
    },
    setText: function setText(inst) {
      $(inst.dpDiv).find('.timepicker__controls__control--hours').text(this.getHours(inst).toString().padStart(2, '0'));
      $(inst.dpDiv).find('.timepicker__controls__control--minutes').text(this.getMinutes(inst).toString().padStart(2, '0'));
      $(inst.dpDiv).find('.timepicker__controls__control--seconds').text(this.getSeconds(inst).toString().padStart(2, '0'));
      $(inst.dpDiv).find('.timepicker__controls__control--meridiem').text(this.getMeridiem(inst));
    },
    setHours: function setHours(inst, hours) {
      if (inst.settings.twentyFour) {
        if (hours > 23) hours = 0;
        if (hours < 0) hours = 23;
      } else {
        if (hours > 11) {
          hours = hours % 12;
          inst.selectedMeridiem = 'PM';
        }

        if (hours < 0) hours = 11;
      }

      inst.selectedHour = hours;
    },
    setMinutes: function setMinutes(inst, minutes) {
      if (minutes > 59) minutes = minutes % 60;
      if (minutes < 0) minutes = 59;
      inst.selectedMin = minutes;
    },
    setSeconds: function setSeconds(inst, seconds) {
      inst.selectedSec = seconds;
    },
    setMeridiem: function setMeridiem(inst) {
      var inputMeridiem = 'AM';

      if (inst.selectedMeridiem == 'AM') {
        inputMeridiem = 'PM';
      }

      inst.selectedMeridiem = inputMeridiem;
    },
    getHours: function getHours(inst) {
      return inst.selectedHour;
    },
    getMinutes: function getMinutes(inst) {
      return inst.selectedMin;
    },
    getSeconds: function getSeconds(inst) {
      return inst.selectedSec;
    },
    getMeridiem: function getMeridiem(inst) {
      return inst.selectedMeridiem;
    },
    _generateTimePicker: function _generateTimePicker(inst) {
      var $elem = $('<div />').addClass('ui-datepicker-select-time').hide();
      var picker = '<div class="timepicker"><ul class="timepicker__controls"><li class="timepicker__controls__control"><span class="timepicker__controls__control-up"></span><span class="timepicker__controls__control--hours" tabindex="-1">00</span><span class="timepicker__controls__control-down"></span></li><li class="timepicker__controls__control--separator"><span class="timepicker__controls__control--separator-inner">:</span></li><li class="timepicker__controls__control"><span class="timepicker__controls__control-up"></span><span class="timepicker__controls__control--minutes" tabindex="-1">00</span><span class="timepicker__controls__control-down"></span></li>';

      if (inst.settings.showSeconds) {
        picker += '<li class="timepicker__controls__control--separator"><span class="timepicker__controls__control--separator-inner">:</span></li><li class="timepicker__controls__control"><span class="timepicker__controls__control-up"></span><span class="timepicker__controls__control--seconds" tabindex="-1">00</span><span class="timepicker__controls__control-down"></span> </li>';
      }

      if (!inst.settings.twentyFour) {
        picker += '<li class="timepicker__controls__control"><span class="timepicker__controls__control-up"></span><span class="timepicker__controls__control--meridiem" tabindex="-1">AM</span><span class="timepicker__controls__control-down"></span></li></ul></div>';
      }

      var $picker = $(picker);
      var self = this;
      var timeOut = null;
      $picker.find('.timepicker__controls__control-up').add($picker.find('.timepicker__controls__control-down')).on('mousedown touchstart', function (event) {
        var operator = this.className.indexOf('up') > -1 ? '+' : '-';
        var $next = $(this.nextSibling);
        var $prev = $(this.previousSibling);
        var $target = operator === '+' ? $next : $prev;
        var targetClass = $target.attr('class');
        timeOut = setInterval(function () {
          self._incrementTime(inst, targetClass, operator);
        }, 200);
        return false;
      }).on('mouseup touchend mouseout', function () {
        clearInterval(timeOut);
        return false;
      }).on('click', function () {
        var operator = this.className.indexOf('up') > -1 ? '+' : '-';
        var $next = $(this.nextSibling);
        var $prev = $(this.previousSibling);
        var $target = operator === '+' ? $next : $prev;
        var targetClass = $target.attr('class');

        self._incrementTime(inst, targetClass, operator);

        return false;
      });
      $elem.append($picker);
      return $elem;
    },
    _generateMonthYearPicker: function _generateMonthYearPicker(inst) {
      var minDate = this._getMinMaxDate(inst, 'min');

      var maxDate = this._getMinMaxDate(inst, 'max');

      var drawYear = inst.drawYear;
      var drawMonth = inst.drawMonth;
      var inMinYear = minDate && minDate.getFullYear() == drawYear;
      var inMaxYear = maxDate && maxDate.getFullYear() == drawYear;

      var monthPicker = this._generateMonthPickerHTML_MonthYearPicker(inst, minDate, maxDate, drawMonth, inMinYear, inMaxYear);

      return $('<div class="ui-datepicker-select-month" style="display: none">' + monthPicker + '</div>' + '<div class="ui-datepicker-select-year" style="display: none"></div>'); //yearPicker gets filled dinamically
    },
    _pickMonthYear_MonthYearPicker: function _pickMonthYear_MonthYearPicker(id, valueMY, period) {
      var target = $(id),
          inst = this._getInst(target[0]); // keep track of the current drawYear (will be erased by next call)


      var drawYear = inst.drawYear;
      var dummySelect = $('<select/>').append(new Option(valueMY, valueMY, true, true)); //select month/year and show datepicker

      this._selectMonthYear(id, dummySelect[0], period); // if a month has been selected, select tht displayed date as well


      if (period == 'M') {
        dummySelect = $('<select/>').append(new Option(drawYear, drawYear, true, true));

        this._selectMonthYear(id, dummySelect[0], 'Y');
      } // if we selected a year, force display of the monthpicker


      if (period == 'Y') {
        this._toggleDisplay(id, 2);
      }
    },
    _addHoverEvents_MonthYearPicker: function _addHoverEvents_MonthYearPicker(parent) {
      var dpMonths = parent.find('.ui-state-default');
      dpMonths.hover(function () {
        $(this).addClass('ui-state-hover');
      }, function () {
        $(this).removeClass("ui-state-hover");
      });
    },
    _toggleDisplay: function _toggleDisplay(id, screen, input) {
      var target = $(id);

      var inst = this._getInst(target[0]);

      if (this._isDisabledDatepicker(target[0])) {
        return;
      } //keep the focus for _doKeyDown to work


      this._instInputFocus_MYP(inst);

      var minDate = this._getMinMaxDate(inst, 'min');

      var maxDate = this._getMinMaxDate(inst, 'max');

      var drawYear = inst.drawYear; //inst.drawYear = inst.selectedYear = inst.currentYear

      var drawMonth = inst.drawMonth;
      var minYear = minDate ? minDate.getFullYear() : 0; //TODO

      var maxYear = maxDate ? maxDate.getFullYear() : undefined;
      var dpHeader = inst.dpDiv.children('.ui-datepicker-header');
      var dpPrev = dpHeader.children('a.ui-datepicker-prev');
      var dpNext = dpHeader.children('a.ui-datepicker-next');
      var dpTitle = dpHeader.children('.ui-datepicker-title');
      var self = this;

      switch (screen) {
        case 2:
          //month picker
          var inMinYear = minYear !== undefined && minYear == drawYear;
          var inMaxYear = maxYear !== undefined && maxYear == drawYear;

          var _advanceYear_MYP = function _advanceYear_MYP(diff) {
            drawYear += diff;
            inst.drawYear = drawYear;
            dpTitle.children(':first').text(drawYear); //update screen

            if (minDate || maxDate) {
              inMinYear = minYear == drawYear;
              inMaxYear = maxYear == drawYear; //update month selection

              var monthPicker = self._generateMonthPickerHTML_MonthYearPicker(inst, minDate, maxDate, drawMonth, inMinYear, inMaxYear);

              inst.dpDiv.children('.ui-datepicker-select-month').html(monthPicker);
            }

            _updatePrevNextYear_MYP();
          };

          var _updatePrevNextYear_MYP = function _updatePrevNextYear_MYP() {
            dpPrev.unbind('click');

            if (!inMinYear) {
              dpPrev.removeClass('ui-state-disabled').on('click', function () {
                _advanceYear_MYP(-1);

                self._instInputFocus_MYP(inst);
              });
            } else {
              dpPrev.addClass('ui-state-disabled');
            }

            dpNext.unbind('click');

            if (!inMaxYear) {
              dpNext.removeClass('ui-state-disabled').on('click', function () {
                _advanceYear_MYP(1);

                self._instInputFocus_MYP(inst);
              });
            } else {
              dpNext.addClass('ui-state-disabled');
            }
          }; //change title link behaviour


          dpTitle.html('<a href="#" class="ui-datepicker-yearpicker" onclick="$.datepicker._toggleDisplay(\'#' + inst.id + '\', 3);return false;">' + drawYear + '</a>'); // update prev next behaviour

          dpPrev.off('click').removeAttr('onclick');
          dpNext.off('click').removeAttr('onclick');

          _updatePrevNextYear_MYP();

          var dpMonthSelector = inst.dpDiv.find('.ui-datepicker-select-month table');

          this._addHoverEvents_MonthYearPicker(dpMonthSelector);

          inst.dpDiv.find('table.ui-datepicker-calendar').hide();
          inst.dpDiv.find('.ui-datepicker-select-time').hide();
          inst.dpDiv.find('.ui-datepicker-select-year').hide();
          inst.dpDiv.find('.ui-datepicker-select-month').show();
          break;

        case 3:
          //year picker
          var year = parseInt(drawYear / 10, 10) * 10; //first year in this decade
          //change title link behaviour

          dpTitle.unbind('click'); //change prev next behaviour

          $.backToActualMonth = function () {
            //var d = new Date();
            //var month = d.getMonth()+1;
            $.datepicker._pickMonthYear_MonthYearPicker('#' + inst.id, drawMonth, 'M');

            return false;
          };

          var _updateYearPicker_MYP = function _updateYearPicker_MYP(year) {
            //TODO RTL
            //change title html
            dpTitle.html('<a class="ui-datepicker-title" ' + 'onclick="return $.backToActualMonth();" ' + 'href="#">' + year + '-' + (year + 9) + '</a>'); //change prev next behaviour

            dpPrev.unbind('click');
            dpNext.unbind('click');

            if (year > minYear) {
              dpPrev.removeClass('ui-state-disabled').on('click', function () {
                _updateYearPicker_MYP(year - 21);

                self._instInputFocus_MYP(inst);
              });
            } else {
              dpPrev.addClass('ui-state-disabled');
            }

            if (maxYear === undefined || year + 9 < maxYear) {
              dpNext.removeClass('ui-state-disabled').on('click', function () {
                _updateYearPicker_MYP(year - 1);

                self._instInputFocus_MYP(inst);
              });
            } else {
              dpNext.addClass('ui-state-disabled');
            } //generate year picker HTML


            var yearPicker = '<table><tbody><tr>'; //show years in 4x3 matrix 

            year--; //last year of the previous decade

            try {
              for (var i = 1; i <= 12; i++) {
                var unselectable = minYear && year < minYear || maxYear && year > maxYear; //html += '<span class="year'+(i == -1 || i == 10 ? ' old' : '')+(currentYear == year ? ' active' : '')+'">'+year+'</span>';

                yearPicker += '<td class="' + (unselectable ? ' ' + this._unselectableClass + ' ui-state-disabled' : '') + ( // highlight unselectable months
                !unselectable && (i == 1 || i == 12) ? ' outoffocus' : '') + (year == drawYear ? ' ui-datepicker-today' : '') + '"' + (unselectable ? '' : ' onclick="$.datepicker._pickMonthYear_MonthYearPicker(\'#' + inst.id + '\', ' + year + ', \'Y\');return false;"') + '>' + ( // actions
                unselectable ? '<span class="ui-state-default">' + year + '</span>' : '<a class="ui-state-default ' + ( //(month == drawMonth ? ' ui-state-highlight' : '') +
                year == drawYear ? ' ui-state-active' : '') + // highlight selected day
                //(otherMonth ? ' ui-priority-secondary' : '') + // distinguish dates from other months
                '" href="#">' + year + '</a>') + '</td>'; // display selectable date

                if (i % 4 == 0) {
                  yearPicker += '</tr>';

                  if (i != 12) {
                    yearPicker += '<tr>';
                  }
                }

                year++;
              }
            } catch (error) {
              console.log(error);
            }

            yearPicker += '</tbody></table>';
            $('.ui-datepicker-select-year').html(yearPicker);
          };

          _updateYearPicker_MYP(year);

          var dpYearSelector = inst.dpDiv.find('.ui-datepicker-select-year table');

          this._addHoverEvents_MonthYearPicker(dpYearSelector);

          inst.dpDiv.find('table.ui-datepicker-calendar').hide();
          inst.dpDiv.find('.ui-datepicker-select-month').hide();
          inst.dpDiv.find('.ui-datepicker-select-time').hide();
          inst.dpDiv.find('.ui-datepicker-select-year').show();
          break;

        case 4:
          inst.dpDiv.find('table.ui-datepicker-calendar').hide();
          inst.dpDiv.find('.ui-datepicker-select-month').hide();
          inst.dpDiv.find('.ui-datepicker-select-year').hide();
          inst.dpDiv.find('.ui-datepicker-select-time').show();
          break;
      }
    }
  });
});

/***/ }),

/***/ "./build/jquery-lib.js":
/*!*****************************!*\
  !*** ./build/jquery-lib.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "$", ({
  enumerable: true,
  get: function get() {
    return _jquery.default;
  }
}));
Object.defineProperty(exports, "jqlocale", ({
  enumerable: true,
  get: function get() {
    return _jqueryui.locale;
  }
}));

var _jquery = _interopRequireDefault(__webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js"));

__webpack_require__(/*! jquery-ui */ "./node_modules/jquery-ui/ui/widget.js");

__webpack_require__(/*! jquery-ui/ui/widgets/draggable */ "./node_modules/jquery-ui/ui/widgets/draggable.js");

__webpack_require__(/*! jquery-ui/ui/widgets/droppable */ "./node_modules/jquery-ui/ui/widgets/droppable.js");

__webpack_require__(/*! jquery-ui/ui/widgets/resizable */ "./node_modules/jquery-ui/ui/widgets/resizable.js");

__webpack_require__(/*! jquery-ui/ui/widgets/sortable */ "./node_modules/jquery-ui/ui/widgets/sortable.js");

__webpack_require__(/*! jquery-ui/ui/widgets/selectable */ "./node_modules/jquery-ui/ui/widgets/selectable.js");

__webpack_require__(/*! jquery-ui/ui/widgets/dialog */ "./node_modules/jquery-ui/ui/widgets/dialog.js");

__webpack_require__(/*! jquery-ui/ui/widgets/datepicker */ "./node_modules/jquery-ui/ui/widgets/datepicker.js");

__webpack_require__(/*! daterangepicker/daterangepicker.js */ "./node_modules/daterangepicker/daterangepicker.js");

__webpack_require__(/*! ./jquery-datepicker.js */ "./build/jquery-datepicker.js");

var _jqueryui = __webpack_require__(/*! ./i18n/jqueryui */ "./build/i18n/jqueryui.js");

/***/ }),

/***/ "./build/layouts/Layout.js":
/*!*********************************!*\
  !*** ./build/layouts/Layout.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = exports.Layout = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _jqueryLib = __webpack_require__(/*! ../jquery-lib */ "./build/jquery-lib.js");

var _equalWidgets = __webpack_require__(/*! ../equal-widgets */ "./build/equal-widgets.js");

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

var _Domain = __webpack_require__(/*! ../Domain */ "./build/Domain.js");

var _fileSaver = __webpack_require__(/*! file-saver */ "./node_modules/file-saver/dist/FileSaver.min.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var Layout = /*#__PURE__*/function () {
  // parent view the layout belongs to

  /**
   *
   * @param view  View    Parent View object
   */
  function Layout(view) {
    (0, _classCallCheck2.default)(this, Layout);
    (0, _defineProperty2.default)(this, "uuid", void 0);
    (0, _defineProperty2.default)(this, "view", void 0);
    (0, _defineProperty2.default)(this, "$layout", void 0);
    (0, _defineProperty2.default)(this, "model_widgets", void 0);
    this.uuid = _materialLib.UIHelper.getUUID();
    this.view = view;
    this.$layout = (0, _jqueryLib.$)('<div />').addClass('sb-layout');
    this.model_widgets = {};
    this.view.$layoutContainer.append(this.$layout);
  }
  /*
      Methods from interface, meant to be overloaded in inherited classes
  */


  (0, _createClass2.default)(Layout, [{
    key: "init",
    value: function init() {}
  }, {
    key: "refresh",
    value: function () {
      var _refresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        var full,
            _args = arguments;
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                full = _args.length > 0 && _args[0] !== undefined ? _args[0] : false;

              case 1:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function refresh() {
        return _refresh.apply(this, arguments);
      }

      return refresh;
    }()
  }, {
    key: "loading",
    value: function (_loading) {
      function loading(_x) {
        return _loading.apply(this, arguments);
      }

      loading.toString = function () {
        return _loading.toString();
      };

      return loading;
    }(function (loading) {}
    /*
        Common methods meant to be overloaded in inherited classes
    */
    )
  }, {
    key: "layout",
    value: function layout() {}
  }, {
    key: "feed",
    value: function () {
      var _feed = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(objects) {
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      function feed(_x2) {
        return _feed.apply(this, arguments);
      }

      return feed;
    }()
  }, {
    key: "getView",
    value: function getView() {
      return this.view;
    }
  }, {
    key: "getEnv",
    value: function getEnv() {
      return this.view.getEnv();
    }
    /**
     * Relay Context opening requests to parent View.
     *
     * @param config
     */

  }, {
    key: "openContext",
    value: function openContext(config) {
      console.debug("Layout::openContext", config);
      this.view.openContext(config);
    }
    /**
     *
     * @param field
     * @param message
     */

  }, {
    key: "markFieldAsInvalid",
    value: function markFieldAsInvalid(object_id, field, message) {
      console.debug('Layout::markFieldAsInvalid', object_id, field);

      if (this.view.getType() == 'form') {
        // by convention, form widgets are strored in first index
        object_id = 0;
      }

      if (this.model_widgets.hasOwnProperty(object_id) && this.model_widgets[object_id].hasOwnProperty(field)) {
        var widget = this.model_widgets[object_id][field];
        var $elem = this.$layout.find('#' + widget.getId());
        $elem.addClass('mdc-text-field--invalid');
        $elem.find('.mdc-text-field-helper-text').addClass('mdc-text-field-helper-text--persistent mdc-text-field-helper-text--validation-msg').text(message).attr('title', message);
      }
    }
  }, {
    key: "updateFieldValue",
    value: function updateFieldValue(object_id, field, value) {
      var model_fields = this.view.getModelFields();

      if (!model_fields || !model_fields.hasOwnProperty(field)) {
        return null;
      }

      var type = this.view.getModel().getFinalType(field);

      if (['one2many', 'many2one', 'many2many'].indexOf(type) > -1) {
        // by convention, `name` subfield is always loaded for relational fields
        if (type == 'many2one') {
          value = value['name'];
        } else {// #todo : this method should use the same logic as the feed* methods.
        }
      }

      if (this.model_widgets[object_id][field]) {
        this.model_widgets[object_id][field].setValue(value);
      }
    }
  }, {
    key: "getSelected",
    value: function getSelected() {
      var selection = [];
      var $tbody = this.$layout.find("tbody");
      $tbody.find("input:checked").each(function (i, elem) {
        var id = (0, _jqueryLib.$)(elem).attr('data-id');

        if (id != undefined) {
          selection.push(parseInt(id, 10));
        }
      });
      return selection;
    }
  }, {
    key: "setSelection",
    value: function setSelection(selection) {
      console.debug('Layout::setSelection', selection);
      var $tbody = this.$layout.find("tbody");
      $tbody.find('input[type="checkbox"]').each(function (i, elem) {
        var data = (0, _jqueryLib.$)(elem).attr('data-id');

        if (data != undefined) {
          var id = parseInt(data, 10);
          var $elem = (0, _jqueryLib.$)(elem);

          if (selection.indexOf(id) >= 0) {
            $elem.prop('checked', true);
            $elem.trigger('change');
          } else {
            $elem.prop('checked', false);
            $elem.trigger('change');
          }
        }
      });
    }
  }, {
    key: "addToSelection",
    value: function addToSelection(selection) {
      var _this = this;

      console.debug('Layout::addToSelection', selection);
      var $tbody = this.$layout.find("tbody");
      $tbody.find('input[type="checkbox"]').each(function (i, elem) {
        var data = (0, _jqueryLib.$)(elem).attr('data-id');

        if (data != undefined) {
          var id = parseInt(data, 10);
          var $elem = (0, _jqueryLib.$)(elem);

          if (selection.indexOf(id) >= 0) {
            $elem.prop('checked', true);
            $elem.trigger('change');
          }
        }
      });
      this.$layout.find('thead').find('th:first-child').find('input').trigger('refresh');
      setTimeout(function () {
        return _this.view.onchangeSelection(_this.getSelected());
      });
    }
  }, {
    key: "removeFromSelection",
    value: function removeFromSelection(selection) {
      var _this2 = this;

      console.debug('Layout::removeFromSelection', selection);
      var $tbody = this.$layout.find("tbody");
      $tbody.find('input[type="checkbox"]').each(function (i, elem) {
        var data = (0, _jqueryLib.$)(elem).attr('data-id');

        if (data != undefined) {
          var id = parseInt(data, 10);
          var $elem = (0, _jqueryLib.$)(elem);

          if (selection.indexOf(id) >= 0) {
            $elem.prop('checked', false);
            $elem.trigger('change');
          }
        }
      });
      this.$layout.find('thead').find('th:first-child').find('input').trigger('refresh');
      setTimeout(function () {
        return _this2.view.onchangeSelection(_this2.getSelected());
      });
    }
  }, {
    key: "getSelectedSections",
    value: function getSelectedSections() {
      var selectedSections = {};
      this.$layout.find('.sb-view-form-group').each(function (i, group) {
        (0, _jqueryLib.$)(group).find('.sb-view-form-sections-tabbar').find('.sb-view-form-section-tab').each(function (j, tab) {
          if ((0, _jqueryLib.$)(tab).hasClass('mdc-tab--active')) {
            selectedSections[i] = j;
          }
        });
      });
      return selectedSections;
    }
  }, {
    key: "decorateActionButton",
    value: function () {
      var _decorateActionButton = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5($button, action) {
        var _this3 = this;

        var object,
            _args5 = arguments;
        return _regenerator.default.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                object = _args5.length > 2 && _args5[2] !== undefined ? _args5[2] : {};
                $button.on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4() {
                  var resulting_params, missing_params, user, _i, _Object$keys, param, ref, result, params, response_descr, description, _i2, _Object$keys2, _param, translation, translated_description, defer, $description, $dialog, _$dialog, _$dialog2;

                  return _regenerator.default.wrap(function _callee4$(_context4) {
                    while (1) {
                      switch (_context4.prev = _context4.next) {
                        case 0:
                          _context4.prev = 0;
                          resulting_params = {};
                          missing_params = {};
                          user = _this3.view.getUser(); // 1) pre-feed with params from the action, if any

                          if (!action.hasOwnProperty('params')) {
                            action['params'] = {};
                          } // by convention, add current object id as reference


                          if (object.hasOwnProperty('id') && !action.params.hasOwnProperty('id')) {
                            action.params['id'] = 'object.id';
                          }

                          for (_i = 0, _Object$keys = Object.keys(action.params); _i < _Object$keys.length; _i++) {
                            param = _Object$keys[_i];
                            ref = new _Domain.Reference(action.params[param]);
                            resulting_params[param] = ref.parse(object, user);
                          } // 2) retrieve announcement from the target action controller


                          _context4.next = 9;
                          return _equalServices.ApiService.fetch("/", {
                            do: action.controller,
                            announce: true
                          });

                        case 9:
                          result = _context4.sent;
                          params = {};
                          response_descr = {};
                          description = '';

                          if (result.hasOwnProperty('announcement')) {
                            if (result.announcement.hasOwnProperty('params')) {
                              params = result.announcement.params;
                            }

                            for (_i2 = 0, _Object$keys2 = Object.keys(params); _i2 < _Object$keys2.length; _i2++) {
                              _param = _Object$keys2[_i2];

                              if (Object.keys(resulting_params).indexOf(_param) < 0) {
                                missing_params[_param] = params[_param];
                              }
                            }

                            if (result.announcement.hasOwnProperty('response')) {
                              response_descr = result.announcement.response;
                            }

                            if (result.announcement.hasOwnProperty('description')) {
                              description = result.announcement.description;
                            }
                          } // 3) retrieve translation related to action, if any


                          _context4.next = 16;
                          return _equalServices.ApiService.getTranslation(action.controller.replaceAll('_', '\\'), _this3.view.getLocale());

                        case 16:
                          translation = _context4.sent;

                          // check presence of description and fallback to controller description
                          if (action.hasOwnProperty('description')) {
                            description = action.description;
                          }

                          translated_description = _equalServices.TranslationService.resolve(translation, '', [], '', description, 'description'); // no translation was found for controller

                          if (translated_description == description) {
                            // fallback to current view translation
                            description = _equalServices.TranslationService.resolve(_this3.view.getTranslation(), 'view', [_this3.view.getId(), 'actions'], action.id, description, 'description');
                          } else {
                            description = translated_description;
                          }

                          defer = _jqueryLib.$.Deferred();
                          $description = (0, _jqueryLib.$)('<p />').text(description);

                          if (!(action.hasOwnProperty('confirm') && action.confirm)) {
                            _context4.next = 40;
                            break;
                          }

                          if (!Object.keys(missing_params).length) {
                            _context4.next = 33;
                            break;
                          }

                          $dialog = _materialLib.UIHelper.createDialog(_this3.view.getUUID() + '_' + action.id + '_custom_action_dialog', _equalServices.TranslationService.instant('SB_ACTIONS_PROVIDE_PARAMS'), _equalServices.TranslationService.instant('SB_DIALOG_SEND'), _equalServices.TranslationService.instant('SB_DIALOG_CANCEL'));
                          $dialog.find('.mdc-dialog__content').append($description);
                          _context4.next = 28;
                          return _this3.decorateViewActionDialog($dialog, action, missing_params);

                        case 28:
                          $dialog.addClass('sb-view-dialog').appendTo(_this3.view.getContainer());
                          $dialog.on('_accept', function () {
                            return defer.resolve($dialog.data('result'));
                          }).on('_reject', function () {
                            return defer.reject();
                          });
                          $dialog.trigger('_open');
                          _context4.next = 38;
                          break;

                        case 33:
                          // display confirmation dialog with checkbox for archive
                          _$dialog = _materialLib.UIHelper.createDialog(_this3.view.getUUID() + '_' + action.id + '_confirm-action-dialog', _equalServices.TranslationService.instant('SB_ACTIONS_CONFIRM'), _equalServices.TranslationService.instant('SB_DIALOG_ACCEPT'), _equalServices.TranslationService.instant('SB_DIALOG_CANCEL'));

                          _$dialog.find('.mdc-dialog__content').append($description);

                          _$dialog.appendTo(_this3.view.getContainer());

                          _$dialog.on('_accept', function () {
                            return defer.resolve();
                          }).on('_reject', function () {
                            return defer.reject();
                          });

                          _$dialog.trigger('_open');

                        case 38:
                          _context4.next = 51;
                          break;

                        case 40:
                          if (!Object.keys(missing_params).length) {
                            _context4.next = 50;
                            break;
                          }

                          _$dialog2 = _materialLib.UIHelper.createDialog(_this3.view.getUUID() + '_' + action.id + '_custom_action_dialog', _equalServices.TranslationService.instant('SB_ACTIONS_PROVIDE_PARAMS'), _equalServices.TranslationService.instant('SB_DIALOG_SEND'), _equalServices.TranslationService.instant('SB_DIALOG_CANCEL'));

                          _$dialog2.find('.mdc-dialog__content').append($description);

                          _context4.next = 45;
                          return _this3.decorateViewActionDialog(_$dialog2, action, missing_params);

                        case 45:
                          _$dialog2.addClass('sb-view-dialog').appendTo(_this3.view.getContainer());

                          _$dialog2.on('_accept', function () {
                            return defer.resolve(_$dialog2.data('result'));
                          }).on('_reject', function () {
                            return defer.reject();
                          });

                          _$dialog2.trigger('_open');

                          _context4.next = 51;
                          break;

                        case 50:
                          defer.resolve();

                        case 51:
                          defer.promise().then( /*#__PURE__*/function () {
                            var _ref2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(result) {
                              var $action_dropdown;
                              return _regenerator.default.wrap(function _callee3$(_context3) {
                                while (1) {
                                  switch (_context3.prev = _context3.next) {
                                    case 0:
                                      // mark action button as loading
                                      $action_dropdown = $button.closest('button');
                                      $action_dropdown.addClass('mdc-button--spinner');
                                      _context3.prev = 2;
                                      _context3.next = 5;
                                      return _this3.performViewAction(action, _objectSpread(_objectSpread({}, resulting_params), result), translation, response_descr);

                                    case 5:
                                      _context3.next = 9;
                                      break;

                                    case 7:
                                      _context3.prev = 7;
                                      _context3.t0 = _context3["catch"](2);

                                    case 9:
                                      // restore action button
                                      $action_dropdown.removeClass('mdc-button--spinner');

                                    case 10:
                                    case "end":
                                      return _context3.stop();
                                  }
                                }
                              }, _callee3, null, [[2, 7]]);
                            }));

                            return function (_x5) {
                              return _ref2.apply(this, arguments);
                            };
                          }()).catch(function () {
                            $button.closest('button').removeClass('mdc-button--spinner');
                          });
                          _context4.next = 60;
                          break;

                        case 54:
                          _context4.prev = 54;
                          _context4.t0 = _context4["catch"](0);
                          console.warn('unknown error', _context4.t0); // restore action button

                          $button.closest('button').removeClass('mdc-button--spinner');
                          _context4.next = 60;
                          return _this3.view.displayErrorFeedback(_this3.view.getTranslation(), _context4.t0);

                        case 60:
                        case "end":
                          return _context4.stop();
                      }
                    }
                  }, _callee4, null, [[0, 54]]);
                })));

              case 2:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5);
      }));

      function decorateActionButton(_x3, _x4) {
        return _decorateActionButton.apply(this, arguments);
      }

      return decorateActionButton;
    }()
  }, {
    key: "decorateViewActionDialog",
    value: function () {
      var _decorateViewActionDialog = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee6($dialog, action, params) {
        var $elem, widgets, translation, _i3, _Object$keys3, field, def, model_fields, view_fields, config, widget, $node;

        return _regenerator.default.wrap(function _callee6$(_context6) {
          while (1) {
            switch (_context6.prev = _context6.next) {
              case 0:
                $elem = (0, _jqueryLib.$)('<div />');
                widgets = {}; // load translation related to controller

                _context6.next = 4;
                return _equalServices.ApiService.getTranslation(action.controller.replaceAll('_', '\\'), this.view.getLocale());

              case 4:
                translation = _context6.sent;

                for (_i3 = 0, _Object$keys3 = Object.keys(params); _i3 < _Object$keys3.length; _i3++) {
                  field = _Object$keys3[_i3];
                  def = params[field];
                  model_fields = {};
                  model_fields[field] = def;
                  view_fields = {};
                  view_fields[field] = {
                    "type": "field",
                    "value": field
                  };
                  config = _equalWidgets.WidgetFactory.getWidgetConfig(this.view, field, translation, model_fields, view_fields);
                  widget = _equalWidgets.WidgetFactory.getWidget(this, config.type, config.title, '', config);
                  widget.setMode('edit');
                  widget.setReadonly(config.readonly);
                  $node = widget.render();
                  $node.css({
                    'margin-bottom': '24px'
                  });
                  $elem.append($node);
                  widgets[field] = widget;
                }

                $dialog.find('.mdc-dialog__content').append($elem);
                $dialog.on('_accept', function () {
                  var result = {}; // send payload to target controller
                  // read result :
                  // if no error refresh view
                  // otherwise display error

                  for (var _i4 = 0, _Object$keys4 = Object.keys(widgets); _i4 < _Object$keys4.length; _i4++) {
                    var _field = _Object$keys4[_i4];
                    var _widget = widgets[_field];
                    result[_field] = _widget.getValue();
                  }

                  $dialog.data('result', result);
                });

              case 8:
              case "end":
                return _context6.stop();
            }
          }
        }, _callee6, this);
      }));

      function decorateViewActionDialog(_x6, _x7, _x8) {
        return _decorateViewActionDialog.apply(this, arguments);
      }

      return decorateViewActionDialog;
    }()
  }, {
    key: "performViewAction",
    value: function () {
      var _performViewAction = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee7(action, params, translation) {
        var response_descr,
            content_type,
            result,
            status,
            headers,
            blob,
            filename,
            parts,
            _args7 = arguments;
        return _regenerator.default.wrap(function _callee7$(_context7) {
          while (1) {
            switch (_context7.prev = _context7.next) {
              case 0:
                response_descr = _args7.length > 3 && _args7[3] !== undefined ? _args7[3] : {};
                console.debug('Layout::performViewAction');
                _context7.prev = 2;
                content_type = 'application/json';

                if (response_descr.hasOwnProperty('content-type')) {
                  content_type = response_descr['content-type'];
                }

                _context7.next = 7;
                return _equalServices.ApiService.fetch("/", _objectSpread({
                  do: action.controller
                }, params), content_type);

              case 7:
                result = _context7.sent;
                status = _equalServices.ApiService.getLastStatus();
                headers = _equalServices.ApiService.getLastHeaders(); // handle binary data response

                if (content_type != 'application/json') {
                  blob = new Blob([result], {
                    type: content_type
                  });
                  filename = "file.download";

                  if (headers.hasOwnProperty('content-disposition')) {
                    parts = headers['content-disposition'].split('=');

                    if (parts.length > 1) {
                      filename = parts[1].slice(1, -1);
                    }
                  }

                  (0, _fileSaver.saveAs)(blob, filename);
                }

                if (!(status == 205)) {
                  _context7.next = 16;
                  break;
                }

                _context7.next = 14;
                return this.view.closeContext();

              case 14:
                _context7.next = 18;
                break;

              case 16:
                _context7.next = 18;
                return this.view.onchangeView();

              case 18:
                _context7.next = 26;
                break;

              case 20:
                _context7.prev = 20;
                _context7.t0 = _context7["catch"](2);
                _context7.next = 24;
                return this.view.updatedContext();

              case 24:
                _context7.next = 26;
                return this.view.displayErrorFeedback(translation, _context7.t0);

              case 26:
              case "end":
                return _context7.stop();
            }
          }
        }, _callee7, this, [[2, 20]]);
      }));

      function performViewAction(_x9, _x10, _x11) {
        return _performViewAction.apply(this, arguments);
      }

      return performViewAction;
    }()
  }]);
  return Layout;
}();

exports.Layout = Layout;
var _default = Layout;
exports.default = _default;

/***/ }),

/***/ "./build/layouts/LayoutChart.js":
/*!**************************************!*\
  !*** ./build/layouts/LayoutChart.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LayoutChart = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "./node_modules/@babel/runtime/helpers/assertThisInitialized.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _jqueryLib = __webpack_require__(/*! ../jquery-lib */ "./build/jquery-lib.js");

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _Layout2 = __webpack_require__(/*! ./Layout */ "./build/layouts/Layout.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

var _Domain = __webpack_require__(/*! ../Domain */ "./build/Domain.js");

var _equalLib = __webpack_require__(/*! ../equal-lib */ "./build/equal-lib.js");

var _auto = _interopRequireDefault(__webpack_require__(/*! chart.js/auto */ "./node_modules/chart.js/auto/auto.esm.js"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var LayoutChart = /*#__PURE__*/function (_Layout) {
  (0, _inherits2.default)(LayoutChart, _Layout);

  var _super = _createSuper(LayoutChart);

  function LayoutChart() {
    var _this;

    (0, _classCallCheck2.default)(this, LayoutChart);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "config", {});
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "parsed_datasets", {});
    return _this;
  }

  (0, _createClass2.default)(LayoutChart, [{
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                console.debug('LayoutChart::init');

                try {
                  // initialize the layout
                  this.layout();
                } catch (err) {
                  console.warn('Something went wrong ', err);
                }

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }() // refresh layout
    // this method is called in response to parent View `onchangeModel` method

  }, {
    key: "refresh",
    value: function () {
      var _refresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var full,
            objects,
            _args2 = arguments;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                full = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : false;
                console.debug('LayoutChart::refresh'); // also re-generate the layout

                if (full) {
                  this.$layout.empty();
                  this.layout();
                } // feed layout with current Model


                _context2.next = 5;
                return this.view.getModel().get();

              case 5:
                objects = _context2.sent;
                this.feed(objects);

              case 7:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function refresh() {
        return _refresh.apply(this, arguments);
      }

      return refresh;
    }()
    /**
     *
     * This method also stores the list of instanciated widgets to allow switching from view mode to edit mode  (for a form or a cell)
     *
     */

  }, {
    key: "layout",
    value: function () {
      var _layout = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3() {
        var _this2 = this;

        var view_schema, layout;
        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                console.debug('LayoutChart::layout');
                view_schema = this.view.getViewSchema();
                layout = view_schema.layout;
                this.config = _objectSpread({
                  type: 'bar',
                  stacked: false,
                  group_by: 'range',
                  field: 'created',
                  range_interval: 'month',
                  range_from: 'date.this.year.first',
                  range_to: 'date.this.year.last'
                }, layout); // parse schema to get the operations (datasets), relative dates : range_from, range_to

                this.parsed_datasets = layout.datasets.map(function (a, index) {
                  var dataset = _objectSpread({
                    label: 'label',
                    operation: ['COUNT', 'object.id']
                  }, a);

                  if (a.hasOwnProperty('domain')) {
                    var tmpDomain = new _Domain.Domain(a.domain);

                    var user = _this2.view.getUser();

                    dataset.domain = tmpDomain.parse({}, user).toArray();
                  }

                  return dataset;
                });

              case 5:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function layout() {
        return _layout.apply(this, arguments);
      }

      return layout;
    }()
  }, {
    key: "feed",
    value: function () {
      var _feed = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(objects) {
        var _this3 = this;

        var view_schema, layout, result, $elem, $container, $table, $thead, $tbody, object, $hrow, i, keys, _iterator, _step, field, $cell, _iterator2, _step2, _object, $row, _iterator3, _step3, _field, CHART_COLORS, datasets, options;

        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                // #todo : split between layout and feed
                this.$layout.empty(); // display the first object from the collection

                view_schema = this.view.getViewSchema();
                layout = view_schema.layout;
                _context4.prev = 3;
                _context4.next = 6;
                return _equalServices.ApiService.fetch('/', _objectSpread({
                  get: 'model_chart',
                  type: this.config.type,
                  entity: this.config.entity,
                  group_by: this.config.group_by,
                  field: this.config.field,
                  range_interval: this.config.range_interval,
                  range_from: new _equalLib.DateReference(this.config.range_from).getDate().toISOString(),
                  range_to: new _equalLib.DateReference(this.config.range_to).getDate().toISOString(),
                  datasets: this.parsed_datasets,
                  mode: this.view.getMode()
                }, this.view.getParams()));

              case 6:
                result = _context4.sent;
                _context4.next = 13;
                break;

              case 9:
                _context4.prev = 9;
                _context4.t0 = _context4["catch"](3);
                console.warn(_context4.t0);
                return _context4.abrupt("return");

              case 13:
                if (this.view.getMode() == 'grid') {
                  $elem = (0, _jqueryLib.$)('<div/>').addClass('table-wrapper').css({
                    "width": "100%"
                  });
                  $container = (0, _jqueryLib.$)('<div/>').css({
                    "width": "100%"
                  }).appendTo($elem);
                  $table = (0, _jqueryLib.$)('<table/>').css({
                    "width": "100%"
                  }).appendTo($container);
                  $thead = (0, _jqueryLib.$)('<thead/>').appendTo($table);
                  $tbody = (0, _jqueryLib.$)('<tbody/>').appendTo($table);
                  object = result[0];
                  $hrow = (0, _jqueryLib.$)('<tr/>').appendTo($thead);
                  i = 0;
                  keys = Object.keys(object).sort();
                  _iterator = _createForOfIteratorHelper(keys);

                  try {
                    for (_iterator.s(); !(_step = _iterator.n()).done;) {
                      field = _step.value;
                      $cell = (0, _jqueryLib.$)('<th/>').append(field).appendTo($hrow);

                      if (i == 0) {
                        $cell.css({
                          width: "20%"
                        });
                      }

                      ++i;
                    }
                  } catch (err) {
                    _iterator.e(err);
                  } finally {
                    _iterator.f();
                  }

                  _iterator2 = _createForOfIteratorHelper(result);

                  try {
                    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                      _object = _step2.value;
                      $row = (0, _jqueryLib.$)('<tr/>').appendTo($tbody);
                      _iterator3 = _createForOfIteratorHelper(keys);

                      try {
                        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                          _field = _step3.value;
                          (0, _jqueryLib.$)('<td/>').attr('title', _object[_field]).append(_object[_field]).appendTo($row);
                        }
                      } catch (err) {
                        _iterator3.e(err);
                      } finally {
                        _iterator3.f();
                      }
                    }
                  } catch (err) {
                    _iterator2.e(err);
                  } finally {
                    _iterator2.f();
                  }

                  _materialLib.UIHelper.decorateTable($elem);
                } else {
                  $elem = (0, _jqueryLib.$)('<canvas/>').css({
                    "width": "100%",
                    "height": "calc(100% - 20px)",
                    "margin-top": "20px"
                  });
                  CHART_COLORS = ['rgb(75, 192, 192)', // green
                  'rgb(255, 99, 132)', // red
                  'rgb(54, 162, 235)', // blue
                  'rgb(255, 159, 64)', // orange
                  'rgb(153, 102, 255)', // purple
                  'rgb(255, 205, 86)', // yellow
                  'rgb(201, 203, 207)' // grey
                  ];

                  if (['pie', 'doughnut', 'polarArea'].indexOf(this.config.type) >= 0) {
                    datasets = result.datasets.map(function (a, index) {
                      return {
                        label: layout.datasets[index].label,
                        data: a,
                        backgroundColor: CHART_COLORS
                      };
                    });
                    options = {
                      responsive: true,
                      maintainAspectRatio: false
                    };
                  } else {
                    datasets = result.datasets.map(function (a, index) {
                      return {
                        label: layout.datasets[index].label,
                        data: a,
                        backgroundColor: CHART_COLORS[index % 7]
                      };
                    });
                    options = {
                      responsive: true,
                      maintainAspectRatio: false,
                      scales: {
                        x: {
                          stacked: this.config.stacked
                        },
                        y: {
                          beginAtZero: true,
                          stacked: this.config.stacked
                        }
                      }
                    };
                  }

                  this.getView().isReady().then(function () {
                    var myChart = new _auto.default($elem[0], {
                      type: _this3.config.type,
                      data: {
                        labels: result.labels,
                        datasets: datasets
                      },
                      options: options
                    });
                  });
                }

                this.$layout.append($elem);

              case 15:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this, [[3, 9]]);
      }));

      function feed(_x) {
        return _feed.apply(this, arguments);
      }

      return feed;
    }()
  }]);
  return LayoutChart;
}(_Layout2.Layout);

exports.LayoutChart = LayoutChart;

/***/ }),

/***/ "./build/layouts/LayoutDashboard.js":
/*!******************************************!*\
  !*** ./build/layouts/LayoutDashboard.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LayoutDashboard = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _jqueryLib = __webpack_require__(/*! ../jquery-lib */ "./build/jquery-lib.js");

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _Layout2 = __webpack_require__(/*! ./Layout */ "./build/layouts/Layout.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

var _WidgetDashboardItem = __webpack_require__(/*! ../widgets/WidgetDashboardItem */ "./build/widgets/WidgetDashboardItem.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var LayoutDashboard = /*#__PURE__*/function (_Layout) {
  (0, _inherits2.default)(LayoutDashboard, _Layout);

  var _super = _createSuper(LayoutDashboard);

  function LayoutDashboard() {
    (0, _classCallCheck2.default)(this, LayoutDashboard);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(LayoutDashboard, [{
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                console.debug('LayoutDashboard::init');

                try {
                  // initialize the layout
                  this.layout();
                } catch (err) {
                  console.warn('Something went wrong ', err);
                }

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }() // refresh layout
    // this method is called in response to parent View `onchangeModel` method

  }, {
    key: "refresh",
    value: function () {
      var _refresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var full,
            _args2 = arguments;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                full = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : false;
                console.debug('LayoutDashboard::refresh'); // also re-generate the layout

                if (full) {
                  this.$layout.empty();
                  this.layout();
                } // feed layout (render widgets)


                this.feed([]);

              case 4:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function refresh() {
        return _refresh.apply(this, arguments);
      }

      return refresh;
    }()
    /**
     *
     * This method also stores the list of instanciated widgets to allow switching from view mode to edit mode  (for a form or a cell)
     *
     */

  }, {
    key: "layout",
    value: function layout() {
      var _this = this;

      console.debug('LayoutDashboard::layout');
      var $elem = (0, _jqueryLib.$)('<div/>').css({
        "width": "100%"
      });
      var view_schema = this.view.getViewSchema();
      var translation = this.view.getTranslation();
      var view_config = this.view.getConfig();

      if (!view_schema.hasOwnProperty('layout') || !view_schema.layout.hasOwnProperty('groups')) {
        console.warn("invalid layout, stop processing");
        return;
      }

      _jqueryLib.$.each(view_schema.layout.groups, function (i, group) {
        var group_id = 'group-' + i;
        var $group = (0, _jqueryLib.$)('<div />').addClass('sb-view-dashboard-group').appendTo($elem);
        var selected_section = 0;

        if (view_config && view_config.hasOwnProperty('selected_sections') && view_config.selected_sections.hasOwnProperty(i)) {
          selected_section = view_config.selected_sections[i];
        }

        var $tabs = _materialLib.UIHelper.createTabBar('sections-' + group_id, '', '').addClass('sb-view-form-sections-tabbar');

        if (group.sections.length > 1 || group.sections[0].hasOwnProperty('label')) {
          $group.append($tabs);
        }

        _jqueryLib.$.each(group.sections, function (j, section) {
          var section_id = group_id + '-section-' + j;
          var $section = (0, _jqueryLib.$)('<div />').attr('id', section_id).addClass('sb-view-dashboard-section mdc-layout-grid').appendTo($group);

          if (j != selected_section) {
            $section.hide();
          }

          if (group.sections.length > 1 || section.hasOwnProperty('label')) {
            // try to resolve the section title
            var section_title = section.hasOwnProperty('label') ? section.label : section_id;

            if (section.hasOwnProperty('id')) {
              section_title = _equalServices.TranslationService.resolve(translation, 'view', [_this.view.getId(), 'layout'], section.id, section_title);
            }

            var $tab = _materialLib.UIHelper.createTabButton(section_id + '-tab', section_title, j == selected_section).addClass('sb-view-form-section-tab').on('click', function () {
              $group.find('.sb-view-form-section').hide();
              $group.find('#' + section_id).show();
            });

            if (section.hasOwnProperty('visible')) {
              $tab.attr('data-visible', JSON.stringify(section.visible));
            }

            $tabs.find('.sb-view-form-sections').append($tab);
          }

          _jqueryLib.$.each(section.rows, function (k, row) {
            var $row = (0, _jqueryLib.$)('<div />').addClass('sb-view-dashboard-row mdc-layout-grid__inner').appendTo($section);

            if (row.hasOwnProperty('height')) {
              // once the view will be ready, update height according to context total height
              _this.getView().isReady().then(function () {
                var available_height = _this.getView().getContext().getContainer().height() - section.rows.length * 24;
                var height = Math.floor(parseInt(row.height, 10) / 100 * available_height);
                $row.css('height', height + 'px');
                $row.find('.mdc-layout-grid__cell').css('height', height + 'px');
              }); // do the same when window is resized


              var timeout;
              (0, _jqueryLib.$)(window).on('resize', function () {
                clearTimeout(timeout);
                timeout = setTimeout(function () {
                  var available_height = _this.getView().getContext().getContainer().height() - section.rows.length * 24;
                  var height = Math.floor(parseInt(row.height, 10) / 100 * available_height);
                  $row.css('height', height + 'px');
                  $row.find('.mdc-layout-grid__cell').css('height', height + 'px');
                });
              });
            }

            _jqueryLib.$.each(row.columns, function (l, column) {
              var $column = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($row);

              if (column.hasOwnProperty('width')) {
                $column.addClass('mdc-layout-grid__cell--span-' + Math.round(parseInt(column.width, 10) / 100 * 12));
              }

              var $inner_cell = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($column);
              $column = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__inner').appendTo($inner_cell);

              _jqueryLib.$.each(column.items, function (i, item) {
                var $cell = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($column); // try to resolve the cell title

                var cell_title = item.hasOwnProperty('label') ? item.label : '';

                if (item.hasOwnProperty('id')) {
                  cell_title = _equalServices.TranslationService.resolve(translation, 'view', [_this.view.getId(), 'layout'], item.id, cell_title);
                } // append the group title, if any


                if (cell_title.length) {
                  $cell.append((0, _jqueryLib.$)('<div/>').addClass('sb-view-dashboard-cell-title').text(cell_title));
                } // compute the width (on a 12 columns grid basis), from 1 to 12


                var width = item.hasOwnProperty('width') ? Math.round(parseInt(item.width, 10) / 100 * 12) : 12;
                $cell.addClass('mdc-layout-grid__cell--span-' + width);

                if (item.hasOwnProperty('entity') && item.hasOwnProperty('view')) {
                  var config = _objectSpread({}, item);

                  var view_id = config.hasOwnProperty('view') ? config.view : 'list.default';
                  var parts = view_id.split(".", 2);
                  var view_type = parts.length > 1 ? parts[0] : 'list';
                  var view_name = parts.length > 1 ? parts[1] : parts[0];
                  var domain = config.hasOwnProperty('domain') ? config['domain'] : [];
                  config.domain = domain;
                  config.view_type = view_type;
                  config.view_name = view_name;
                  var widget = new _WidgetDashboardItem.WidgetDashboardItem(_this, item.label, '', config); // store widget in widgets Map, using field name as key

                  if (typeof _this.model_widgets[0] == 'undefined') {
                    _this.model_widgets[0] = {};
                  }

                  _this.model_widgets[0][item.id] = widget;
                  $cell.append(widget.attach());
                }
              });
            });
          });
        });

        _materialLib.UIHelper.decorateTabBar($tabs);
      });

      this.$layout.append($elem);
    }
  }, {
    key: "feed",
    value: function () {
      var _feed = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(objects) {
        var _i, _Object$keys, widget_id, widget, $parent;

        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _i = 0, _Object$keys = Object.keys(this.model_widgets[0]);

              case 1:
                if (!(_i < _Object$keys.length)) {
                  _context3.next = 11;
                  break;
                }

                widget_id = _Object$keys[_i];
                widget = this.model_widgets[0][widget_id]; // widget might be missing (if not visible)

                if (widget) {
                  _context3.next = 6;
                  break;
                }

                return _context3.abrupt("continue", 8);

              case 6:
                $parent = this.$layout.find('#' + widget.getId()).parent(); // $parent.empty().append(widget.render());

                $parent.append(widget.render());

              case 8:
                _i++;
                _context3.next = 1;
                break;

              case 11:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function feed(_x) {
        return _feed.apply(this, arguments);
      }

      return feed;
    }()
  }]);
  return LayoutDashboard;
}(_Layout2.Layout);

exports.LayoutDashboard = LayoutDashboard;

/***/ }),

/***/ "./build/layouts/LayoutForm.js":
/*!*************************************!*\
  !*** ./build/layouts/LayoutForm.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LayoutForm = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/slicedToArray.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _jqueryLib = __webpack_require__(/*! ../jquery-lib */ "./build/jquery-lib.js");

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _equalWidgets = __webpack_require__(/*! ../equal-widgets */ "./build/equal-widgets.js");

var _Layout2 = __webpack_require__(/*! ./Layout */ "./build/layouts/Layout.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

var _Domain = __webpack_require__(/*! ../Domain */ "./build/Domain.js");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var LayoutForm = /*#__PURE__*/function (_Layout) {
  (0, _inherits2.default)(LayoutForm, _Layout);

  var _super = _createSuper(LayoutForm);

  function LayoutForm() {
    (0, _classCallCheck2.default)(this, LayoutForm);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(LayoutForm, [{
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                console.debug('LayoutForm::init');

                try {
                  // initialize the layout
                  this.layout();
                } catch (err) {
                  console.warn('Something went wrong ', err);
                }

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }() // refresh layout
    // this method is called in response to parent View `onchangeModel` method

  }, {
    key: "refresh",
    value: function () {
      var _refresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var full,
            objects,
            _args2 = arguments;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                full = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : false;
                console.debug('LayoutForm::refresh'); // also re-generate the layout

                if (full) {
                  this.$layout.empty();
                  this.layout();
                } // feed layout with current Model


                _context2.next = 5;
                return this.view.getModel().get();

              case 5:
                objects = _context2.sent;
                this.feed(objects);

              case 7:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function refresh() {
        return _refresh.apply(this, arguments);
      }

      return refresh;
    }()
    /**
     *
     * This method also stores the list of instanciated widgets to allow switching from view mode to edit mode  (for a form or a cell)
     *
     */

  }, {
    key: "layout",
    value: function layout() {
      var _this = this;

      console.debug('LayoutForm::layout');
      var $elem = (0, _jqueryLib.$)('<div/>').css({
        "width": "100%"
      });
      var view_schema = this.view.getViewSchema();
      var view_fields = this.view.getViewFields();
      var model_fields = this.view.getModelFields();
      var translation = this.view.getTranslation();
      var view_config = this.view.getConfig();

      if (!view_schema.hasOwnProperty('layout') || !view_schema.layout.hasOwnProperty('groups')) {
        console.warn("invalid layout, stop processing");
        return;
      }

      _jqueryLib.$.each(view_schema.layout.groups, function (i, group) {
        var group_id = 'group-' + i;
        var $group = (0, _jqueryLib.$)('<div />').addClass('sb-view-form-group').appendTo($elem); // try to resolve the group title

        var group_title = group.hasOwnProperty('label') ? group.label : '';

        if (group.hasOwnProperty('id')) {
          group_title = _equalServices.TranslationService.resolve(translation, 'view', [_this.view.getId(), 'layout'], group.id, group_title);
        } // append the group title, if any


        if (group_title.length) {
          $group.append((0, _jqueryLib.$)('<div/>').addClass('sb-view-form-group-title').text(group_title));
        }

        var selected_section = 0;

        if (view_config && view_config.hasOwnProperty('selected_sections') && view_config.selected_sections.hasOwnProperty(i)) {
          selected_section = view_config.selected_sections[i];
        }

        var $tabs = _materialLib.UIHelper.createTabBar('sections-' + group_id, '', '').addClass('sb-view-form-sections-tabbar');

        if (group.sections.length > 1 || group.sections[0].hasOwnProperty('label')) {
          $group.append($tabs);
        }

        _jqueryLib.$.each(group.sections, function (j, section) {
          var section_id = group_id + '-section-' + j;
          var $section = (0, _jqueryLib.$)('<div />').attr('id', section_id).addClass('sb-view-form-section mdc-layout-grid').appendTo($group);

          if (j != selected_section) {
            $section.hide();
          }

          if (group.sections.length > 1 || section.hasOwnProperty('label')) {
            // try to resolve the section title
            var section_title = section.hasOwnProperty('label') ? section.label : section_id;

            if (section.hasOwnProperty('id')) {
              section_title = _equalServices.TranslationService.resolve(translation, 'view', [_this.view.getId(), 'layout'], section.id, section_title);
            }

            var $tab = _materialLib.UIHelper.createTabButton(section_id + '-tab', section_title, j == selected_section).addClass('sb-view-form-section-tab').on('click', function () {
              $group.find('.sb-view-form-section').hide();
              $group.find('#' + section_id).show();
            });

            if (section.hasOwnProperty('visible')) {
              $tab.attr('data-visible', JSON.stringify(section.visible));
            }

            $tabs.find('.sb-view-form-sections').append($tab);
          }

          _jqueryLib.$.each(section.rows, function (k, row) {
            var $row = (0, _jqueryLib.$)('<div />').addClass('sb-view-form-row mdc-layout-grid__inner').appendTo($section);

            _jqueryLib.$.each(row.columns, function (l, column) {
              var $column = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($row);

              if (column.hasOwnProperty('width')) {
                $column.addClass('mdc-layout-grid__cell--span-' + Math.round(parseInt(column.width, 10) / 100 * 12));
              }

              if (column.hasOwnProperty('align') && column.align == 'right') {
                $column.css({
                  'margin-left': 'auto'
                });
              }

              var $inner_cell = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($column);
              $column = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__inner').appendTo($inner_cell);

              _jqueryLib.$.each(column.items, function (i, item) {
                if (typeof _this.model_widgets[0] == 'undefined') {
                  _this.model_widgets[0] = {};
                }

                var $cell = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($column); // compute the width (on a 12 columns grid basis), from 1 to 12

                var width = item.hasOwnProperty('width') ? Math.round(parseInt(item.width, 10) / 100 * 12) : 12;
                $cell.addClass('mdc-layout-grid__cell--span-' + width);

                if (item.hasOwnProperty('align') && item.align == 'right') {
                  $cell.css({
                    'margin-left': 'auto'
                  });
                }

                if (item.hasOwnProperty('type') && item.hasOwnProperty('value')) {
                  if (item.type == 'field') {
                    var config = _equalWidgets.WidgetFactory.getWidgetConfig(_this.view, item.value, translation, model_fields, view_fields);

                    if (config) {
                      var widget = _equalWidgets.WidgetFactory.getWidget(_this, config.type, config.title, '', config);

                      widget.setReadonly(config.readonly); // store widget in widgets Map, using field name as key

                      _this.model_widgets[0][item.value] = widget;
                      $cell.append(widget.attach());
                    }
                  } else if (item.type == 'label') {
                    var label_title = _equalServices.TranslationService.resolve(translation, 'view', [_this.view.getId(), 'layout'], item.id, item.value);

                    var _widget = _equalWidgets.WidgetFactory.getWidget(_this, 'label', '', label_title, _objectSpread({
                      widget_type: 'label'
                    }, item));

                    _this.model_widgets[0]['__label_' + _widget.getId()] = _widget;
                    $cell.append(_widget.render());
                  }
                }
              });
            });
          });
        });

        _materialLib.UIHelper.decorateTabBar($tabs);
      });

      this.$layout.append($elem);
    }
  }, {
    key: "feed",
    value: function () {
      var _feed = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(objects) {
        var _this2 = this;

        var fields, model_fields, translation, focused_widget_id;
        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                console.debug('LayoutForm::feed', objects); // display the first object from the collection

                fields = Object.keys(this.view.getViewFields());
                model_fields = this.view.getModelFields();
                translation = this.view.getTranslation(); // remember which element has focus (DOM is going to be modified)

                focused_widget_id = (0, _jqueryLib.$)("input:focus").closest('.sb-widget').attr('id');

                if (objects.length > 0) {
                  (function () {
                    // #todo - keep internal index of the object to display (with a prev/next navigation in the header)
                    var object = objects[0]; // update actions in view header

                    var view_schema = _this2.view.getViewSchema();

                    var $view_actions = _this2.view.getContainer().find('.sb-view-header-actions-view'); // show object status, if defined and present


                    if (model_fields.hasOwnProperty('status')) {
                      var $status_container = $view_actions.find('#' + _this2.uuid + '_status');

                      if ($status_container.length == 0) {
                        var status_title = _equalServices.TranslationService.resolve(translation, 'model', [], 'status', 'status', 'label');

                        $status_container = (0, _jqueryLib.$)('<div style="margin-left: auto;"></div>').attr('id', _this2.uuid + '_status').append((0, _jqueryLib.$)('<span style="line-height: 46px;margin-right: 12px; text-transform: capitalize;">' + status_title + ': <span class="status-value"></span></span>')).appendTo($view_actions);
                      }

                      var status_selection = _equalServices.TranslationService.resolve(translation, 'model', [], 'status', model_fields['status'].selection, 'selection');

                      var status_value = status_selection[object['status']];
                      $status_container.find('.status-value').empty().append((0, _jqueryLib.$)('<b>' + status_value + '</b>'));
                    }

                    if (view_schema.hasOwnProperty('actions')) {
                      // there is a single action: show it as a button
                      if (view_schema.actions.length == 1) {
                        $view_actions.empty();
                        var action = view_schema.actions[0];
                        var visible = true;

                        if (action.hasOwnProperty('visible')) {
                          // visible attribute is a Domain
                          if (Array.isArray(action.visible)) {
                            var domain = new _Domain.Domain(action.visible);
                            visible = domain.evaluate(object);
                          } else {
                            visible = action.visible;
                          }
                        }

                        if (visible) {
                          var action_title = _equalServices.TranslationService.resolve(_this2.view.getTranslation(), 'view', [_this2.view.getId(), 'actions'], action.id, action.label);

                          var $button = _materialLib.UIHelper.createButton('action-view-' + action.id, action_title, 'outlined');

                          _this2.decorateActionButton($button, action, object);

                          $view_actions.append($button);
                        }
                      } // there are several actions: display a dropdown
                      else {
                          var $actions_button = $view_actions.find('#' + _this2.uuid + '_actions-dropdown');

                          if ($actions_button.length == 0) {
                            $actions_button = _materialLib.UIHelper.createDropDown(_this2.uuid + '_actions-dropdown', 'Actions', 'text', '', '').addClass('layout-actions').appendTo($view_actions);
                          }

                          $actions_button.find('.menu-list').empty();

                          var _iterator = _createForOfIteratorHelper(view_schema.actions),
                              _step;

                          try {
                            for (_iterator.s(); !(_step = _iterator.n()).done;) {
                              var _action = _step.value;
                              var _visible = true;

                              if (_action.hasOwnProperty('visible')) {
                                // visible attribute is a Domain
                                if (Array.isArray(_action.visible)) {
                                  var _domain = new _Domain.Domain(_action.visible);

                                  _visible = _domain.evaluate(object);
                                } else {
                                  _visible = _action.visible;
                                }
                              }

                              if (_visible) {
                                var _action_title = _equalServices.TranslationService.resolve(_this2.view.getTranslation(), 'view', [_this2.view.getId(), 'actions'], _action.id, _action.label); // let $button = UIHelper.createButton('action-view-'+action.id, action_title, 'outlined')
                                // this.decorateActionButton($button, action, object);
                                // $view_actions.append($button);


                                var $item = _materialLib.UIHelper.createListItem(_this2.uuid + '_action-' + _action.id.replace('.', '_'), _action_title);

                                _this2.decorateActionButton($item, _action, object);

                                $actions_button.find('.menu-list').append($item);
                              }
                            }
                          } catch (err) {
                            _iterator.e(err);
                          } finally {
                            _iterator.f();
                          }
                        }
                    } // update tabs visibility, if any


                    var $tabs = _this2.$layout.find('.mdc-tab.sb-view-form-section-tab');

                    $tabs.each(function (i, elem) {
                      var $tab = (0, _jqueryLib.$)(elem);
                      var visible = $tab.attr('data-visible');

                      if (visible != undefined) {
                        if (visible == 'false') {
                          $tab.hide();
                        } else {
                          var _domain2 = new _Domain.Domain(JSON.parse(visible));

                          if (_domain2.evaluate(object)) {
                            $tab.show();
                          } else {
                            $tab.hide();
                          }
                        }
                      }
                    });

                    var _loop = function _loop() {
                      var widget_index = _Object$keys[_i];
                      var widget = _this2.model_widgets[0][widget_index];
                      var config = widget.getConfig();

                      if (config['widget_type'] == 'label') {
                        var _visible2 = true; // handle visibility tests (domain)

                        if (config.hasOwnProperty('visible')) {
                          // visible attribute is a Domain
                          if (Array.isArray(config.visible)) {
                            var _domain3 = new _Domain.Domain(config.visible);

                            _visible2 = _domain3.evaluate(object);
                          } else {
                            _visible2 = config.visible;
                          }
                        }

                        var $parent = _this2.$layout.find('#' + widget.getId()).parent();

                        if (!_visible2) {
                          $parent.empty().append(widget.attach()).hide();
                        } else {
                          $parent.empty().append(widget.render()).show();
                        }
                      } else {
                        var field = config.field; // widget might be missing (if not visible)

                        if (!widget) return "continue";

                        var _$parent = _this2.$layout.find('#' + widget.getId()).parent();

                        var type = _this2.view.getModel().getFinalType(field);

                        var has_changed = false;
                        var value = object.hasOwnProperty(field) ? object[field] : undefined; // for relational fields, we need to check if the Model has been fetched

                        if (['one2many', 'many2one', 'many2many'].indexOf(type) > -1) {
                          var user = _this2.view.getUser(); // if widget has a domain, parse it using current object and user


                          if (config.hasOwnProperty('original_domain')) {
                            var tmpDomain = new _Domain.Domain(config.original_domain);
                            config.domain = tmpDomain.parse(object, user).toArray();
                          } else {
                            config.domain = [];
                          } // if widget has a custom header defintion, parse subsequent domains, if any


                          if (config.hasOwnProperty('header') && config.header.hasOwnProperty('actions')) {
                            for (var _i2 = 0, _Object$entries = Object.entries(config.header.actions); _i2 < _Object$entries.length; _i2++) {
                              var _Object$entries$_i = (0, _slicedToArray2.default)(_Object$entries[_i2], 2),
                                  id = _Object$entries$_i[0],
                                  items = _Object$entries$_i[1];

                              for (var index in items) {
                                var item = items[index];

                                if (item.hasOwnProperty('domain')) {
                                  var _tmpDomain = new _Domain.Domain(item.domain);

                                  config.header.actions[id][index].domain = _tmpDomain.parse(object, user).toArray();
                                }
                              }
                            }
                          } // by convention, `name` subfield is always loaded for relational fields


                          if (type == 'many2one') {
                            if (object[field]) {
                              value = object[field]['name'];
                              config.object_id = object[field]['id'];
                            }
                          } else if (type == 'many2many' || type == 'one2many') {
                            // init field if not present yet (o2m and m2m are not loaded by Model)
                            if (!object.hasOwnProperty(field)) {
                              object[field] = []; // force change detection (upon re-feed, the field do not change and remains an empty array)

                              _$parent.data('value', null);
                            } // for m2m fields, the value of the field is an array of ids
                            // by convention, when a relation is to be removed, the id field is set to its negative value


                            value = object[field]; // select ids to load by filtering targeted objects

                            config.ids_to_add = object[field].filter(function (id) {
                              return id > 0;
                            });
                            config.ids_to_del = object[field].filter(function (id) {
                              return id < 0;
                            }).map(function (id) {
                              return -id;
                            }); // we need the current object id for new objects creation

                            config.object_id = object.id;
                          }
                        }

                        has_changed = !value || _$parent.data('value') != JSON.stringify(value);
                        widget.setConfig(_objectSpread(_objectSpread({}, config), {}, {
                          ready: true
                        })).setMode(_this2.view.getMode()).setValue(value); // store data to parent, for tracking changes at next refresh (prevent storing references)

                        _$parent.data('value', JSON.stringify(value) || null);

                        var _visible3 = true; // handle visibility tests (domain)

                        if (config.hasOwnProperty('visible')) {
                          // visible attribute is a Domain
                          if (Array.isArray(config.visible)) {
                            var _domain4 = new _Domain.Domain(config.visible);

                            _visible3 = _domain4.evaluate(object);
                          } else {
                            _visible3 = config.visible;
                          }
                        }

                        if (!_visible3) {
                          _$parent.empty().append(widget.attach()).hide(); // visibility update need to trigger a redraw, whatever the value (so we change it to an arbitrary value)


                          _$parent.data('value', null);
                        } else {
                          var $widget = widget.render(); // Handle Widget update handler

                          $widget.on('_updatedWidget', /*#__PURE__*/function () {
                            var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(event) {
                              var refresh,
                                  values,
                                  result,
                                  _i3,
                                  _Object$keys2,
                                  _field,
                                  _args3 = arguments;

                              return _regenerator.default.wrap(function _callee3$(_context3) {
                                while (1) {
                                  switch (_context3.prev = _context3.next) {
                                    case 0:
                                      refresh = _args3.length > 1 && _args3[1] !== undefined ? _args3[1] : true;
                                      console.debug("Layout::feedForm : received _updatedWidget", field, widget.getValue(), refresh); // update object with new value

                                      values = {};
                                      values[field] = widget.getValue(); // if value is less than 1k, relay onchange to server
                                      // #todo - choose an objectivable limit

                                      if (!(String(widget.getValue()).length < 1000)) {
                                        _context3.next = 15;
                                        break;
                                      }

                                      _context3.prev = 5;
                                      _context3.next = 8;
                                      return _equalServices.ApiService.call("/?do=model_onchange", {
                                        entity: _this2.view.getEntity(),
                                        changes: _this2.view.getModel().export(values),
                                        values: _this2.view.getModel().export(object),
                                        lang: _this2.view.getLang()
                                      });

                                    case 8:
                                      result = _context3.sent;

                                      for (_i3 = 0, _Object$keys2 = Object.keys(result); _i3 < _Object$keys2.length; _i3++) {
                                        _field = _Object$keys2[_i3];
                                        // if some changes are returned from the back-end, append them to the view model update
                                        values[_field] = result[_field];
                                      }

                                      _context3.next = 15;
                                      break;

                                    case 12:
                                      _context3.prev = 12;
                                      _context3.t0 = _context3["catch"](5);
                                      // ignore faulty responses
                                      console.warn('unable to send onupdate request', _context3.t0);

                                    case 15:
                                      _this2.view.onchangeViewModel([object.id], values, refresh);

                                    case 16:
                                    case "end":
                                      return _context3.stop();
                                  }
                                }
                              }, _callee3, null, [[5, 12]]);
                            }));

                            return function (_x2) {
                              return _ref.apply(this, arguments);
                            };
                          }()); // prevent refreshing objects that haven't changed

                          if (has_changed) {
                            // append rendered widget
                            _$parent.empty().append($widget).show();
                          }
                        }
                      }
                    };

                    for (var _i = 0, _Object$keys = Object.keys(_this2.model_widgets[0]); _i < _Object$keys.length; _i++) {
                      var _ret = _loop();

                      if (_ret === "continue") continue;
                    } // try to give the focus back to the previously focused widget


                    (0, _jqueryLib.$)('#' + focused_widget_id).find('input').trigger('focus');
                  })();
                }

              case 6:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function feed(_x) {
        return _feed.apply(this, arguments);
      }

      return feed;
    }()
  }]);
  return LayoutForm;
}(_Layout2.Layout);

exports.LayoutForm = LayoutForm;

/***/ }),

/***/ "./build/layouts/LayoutList.js":
/*!*************************************!*\
  !*** ./build/layouts/LayoutList.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LayoutList = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _jqueryLib = __webpack_require__(/*! ../jquery-lib */ "./build/jquery-lib.js");

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _equalWidgets = __webpack_require__(/*! ../equal-widgets */ "./build/equal-widgets.js");

var _Layout2 = __webpack_require__(/*! ./Layout */ "./build/layouts/Layout.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

var _Domain = __webpack_require__(/*! ../Domain */ "./build/Domain.js");

var _moment = _interopRequireDefault(__webpack_require__(/*! moment/moment.js */ "./node_modules/moment/moment.js"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var LayoutList = /*#__PURE__*/function (_Layout) {
  (0, _inherits2.default)(LayoutList, _Layout);

  var _super = _createSuper(LayoutList);

  function LayoutList() {
    (0, _classCallCheck2.default)(this, LayoutList);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(LayoutList, [{
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                console.debug('LayoutList::init');

                try {
                  // initialize the layout
                  this.layout();
                } catch (err) {
                  console.warn('Something went wrong ', err);
                }

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }() // refresh layout
    // this method is called in response to parent View `onchangeModel` method

  }, {
    key: "refresh",
    value: function () {
      var _refresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var full,
            objects,
            _args2 = arguments;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                full = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : false;
                console.debug('LayoutList::refresh'); // also re-generate the layout

                if (full) {
                  this.$layout.empty();
                  this.layout();
                } else {
                  // unselect all
                  (0, _jqueryLib.$)('td:first-child', this.$layout.find('tbody')).each(function (i, elem) {
                    (0, _jqueryLib.$)('input[type="checkbox"]', elem).prop('checked', false);
                  });
                  this.$layout.find('thead').find('th:first-child').find('input').trigger('refresh');
                } // feed layout with current Model


                _context2.next = 5;
                return this.view.getModel().get();

              case 5:
                objects = _context2.sent;
                this.feed(objects);

              case 7:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function refresh() {
        return _refresh.apply(this, arguments);
      }

      return refresh;
    }()
  }, {
    key: "loading",
    value: function loading(_loading) {
      var $elem = this.$layout.find('.table-wrapper');
      var $loader = $elem.find('.table-loader');

      if (_loading) {
        $loader.show();
      } else {
        $loader.hide();
      }
    }
  }, {
    key: "layout",
    value: function layout() {
      var _this = this;

      // create table
      // we define a tree structure according to MDC pattern
      var $elem = (0, _jqueryLib.$)('<div/>').addClass('table-wrapper').css({
        "width": "100%"
      });
      var $container = (0, _jqueryLib.$)('<div/>').css({
        "width": "100%"
      }).appendTo($elem); // add spinner

      $container.append((0, _jqueryLib.$)('<div class="table-loader"> <div class="table-spinner"><div class="spinner__element"></div></div> <div class="table-overlay"></div> </div>'));
      var $table = (0, _jqueryLib.$)('<table/>').css({
        "width": "100%"
      }).appendTo($container);
      var $thead = (0, _jqueryLib.$)('<thead/>').appendTo($table);
      var $tbody = (0, _jqueryLib.$)('<tbody/>').appendTo($table); // instanciate header row and the first column which contains the 'select-all' checkbox

      var $hrow = (0, _jqueryLib.$)('<tr/>');

      if (this.view.getPurpose() != 'widget' || this.view.getMode() == 'edit') {
        _materialLib.UIHelper.createTableCellCheckbox(true).appendTo($hrow).find('input').on('click', function () {
          return setTimeout(function () {
            return _this.view.onchangeSelection(_this.getSelected());
          });
        });
      }

      var group_by = this.view.getGroupBy();

      if (group_by.length > 0) {
        var $fold_toggle = (0, _jqueryLib.$)('<th />').addClass('sb-group-cell folded').css({
          'width': '44px',
          'cursor': 'pointer'
        }).append((0, _jqueryLib.$)('<i/>').addClass('material-icons sb-toggle-button').text('chevron_right'));
        $hrow.append($fold_toggle);
        $fold_toggle.on('click', function () {
          var $tbody = _this.$layout.find('tbody');

          var folded = $fold_toggle.hasClass('folded');

          if (folded) {
            $fold_toggle.removeClass('folded');
          } else {
            $fold_toggle.addClass('folded');
          }

          folded = !folded;
          $tbody.find('.sb-group-row').each(function (index, elem) {
            var $this = (0, _jqueryLib.$)(elem);
            var subfolded = $this.hasClass('folded');

            if (subfolded != folded) {
              $this.trigger('click');
            }
          });
        });
      } // create other columns, based on the col_model given in the configuration


      var view_schema = this.view.getViewSchema();
      var translation = this.view.getTranslation();
      var model_fields = this.view.getModelFields();
      var view_fields = this.view.getViewFields(); // pre-processing: check columns width consistency

      var item_width_total = 0; // 1) sum total width and items with null width

      var _iterator = _createForOfIteratorHelper(view_schema.layout.items),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _item2 = _step.value;

          if (!_item2.hasOwnProperty('visible') || _item2.visible == true) {
            // set minimum width to 10%
            var _width = 10;

            if (_item2.hasOwnProperty('width')) {
              _width = Math.round(parseInt(_item2.width, 10) * 100) / 100.0;
              if (_width < 10) _width = 10;
            }

            _item2.width = _width;
            item_width_total += _width;
          }
        } // 2) normalize columns widths (to be exactly 100%)

      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }

      if (item_width_total != 100) {
        var ratio = 100.0 / item_width_total;

        var _iterator2 = _createForOfIteratorHelper(view_schema.layout.items),
            _step2;

        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var item = _step2.value;

            if ((!item.hasOwnProperty('visible') || item.visible == true) && item.hasOwnProperty('width')) {
              item.width *= ratio;
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }

      var first_column = true;

      var _iterator3 = _createForOfIteratorHelper(view_schema.layout.items),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _item3 = _step3.value;
          var _field = _item3.value;

          var config = _equalWidgets.WidgetFactory.getWidgetConfig(this.view, _field, translation, model_fields, view_fields); // append only visible columns


          if (config && (!config.hasOwnProperty('visible') || config.visible)) {
            var _width2 = Math.floor(10 * _item3.width) / 10;

            var _$cell = (0, _jqueryLib.$)('<th/>').attr('name', _field) // .attr('width', width+'%')
            .css({
              width: _width2 + '%'
            }).append(config.title).on('click', function (event) {
              var $this = (0, _jqueryLib.$)(event.currentTarget);

              if ($this.hasClass('sortable')) {
                // unselect all lines
                (0, _jqueryLib.$)('td:first-child', _this.$layout.find('tbody')).each(function (i, elem) {
                  (0, _jqueryLib.$)('input[type="checkbox"]', elem).prop('checked', false).prop('indeterminate', false);
                });
                $thead.find('th:first-child').find('input').trigger('refresh'); // wait for handling of sort toggle (table decorator)

                setTimeout(function () {
                  // change sortname and/or sortorder
                  _this.view.setOrder($this.attr('name'));

                  _this.view.setSort($this.attr('data-sort'));

                  _this.view.onchangeView();
                });
              }
            });

            if (['float', 'integer'].indexOf(config.type) >= 0 && !first_column) {
              _$cell.css({
                'text-align': 'right',
                'padding-right': '16px'
              });
            }

            if (config.sortable) {
              _$cell.addClass('sortable').attr('data-sort', '');
            }

            $hrow.append(_$cell);
            first_column = false;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      $thead.append($hrow);
      this.$layout.append($elem);

      if (view_schema.hasOwnProperty('operations')) {
        var $operations = (0, _jqueryLib.$)('<div>').addClass('table-operations');

        for (var operation in view_schema.operations) {
          var op_descriptor = view_schema.operations[operation];
          var $op_div = (0, _jqueryLib.$)('<div>').addClass('operation');
          var $title = (0, _jqueryLib.$)('<div>').addClass('operation-title').text(operation); // $op_div.append($title);

          var $op_row = (0, _jqueryLib.$)('<div>').addClass('operation-row').appendTo($op_div);
          var pos = 0;

          var _iterator4 = _createForOfIteratorHelper(view_schema.layout.items),
              _step4;

          try {
            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
              var _item = _step4.value;

              if (!_item.hasOwnProperty('visible') || _item.visible == true) {
                var width = Math.ceil(10 * _item.width) / 10;
                var $cell = (0, _jqueryLib.$)('<div>').addClass('operation-cell').css({
                  width: width + '%'
                });
                var field = _item.value;

                if (op_descriptor.hasOwnProperty(field)) {
                  var $input = (0, _jqueryLib.$)('<input>').attr('data-id', 'operation-' + operation + '-' + field);
                  var type = this.view.getModel().getFinalType(field);

                  if (['float', 'integer'].indexOf(type) >= 0 && field != 'id') {
                    $input.css({
                      'text-align': 'right',
                      'padding-right': '16px'
                    });
                  }

                  $cell.append($input);
                } else if (pos == 0) {
                  $cell.append($title);
                }

                $op_row.append($cell);
              }

              ++pos;
            }
          } catch (err) {
            _iterator4.e(err);
          } finally {
            _iterator4.f();
          }

          $operations.append($op_div);
        }

        $elem.append($operations);
      }

      _materialLib.UIHelper.decorateTable($elem);

      if (view_schema.hasOwnProperty('actions') && this.view.getPurpose() != 'widget') {
        var $view_actions = this.view.getContainer().find('.sb-view-header-actions-view');

        var _iterator5 = _createForOfIteratorHelper(view_schema.actions),
            _step5;

        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var action = _step5.value;

            var action_title = _equalServices.TranslationService.resolve(this.view.getTranslation(), 'view', [this.view.getId(), 'actions'], action.id, action.label);

            var $button = _materialLib.UIHelper.createButton('action-view-' + action.id, action_title, 'outlined');

            this.decorateActionButton($button, action);
            $view_actions.append($button);
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }
      }
    }
  }, {
    key: "feed",
    value: function () {
      var _feed = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(objects) {
        var group_by, groups, schema, $elem, $table, $tbody, stack, group, $previous, parent_group_id, _iterator6, _step6, object, $row, _$row, keys, _iterator7, _step7, key, operation, descriptor, _iterator8, _step8, item, type, result, _iterator9, _step9, _object, value, prefix, suffix, usage;

        return _regenerator.default.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                console.debug('LayoutList::feed', objects);
                this.$layout.find("tbody").remove();
                group_by = this.view.getGroupBy();
                groups = {};

                if (group_by.length > 0) {
                  groups = this.feedListGroupObjects(objects, group_by);
                }

                schema = this.view.getViewSchema();
                $elem = this.$layout.find('.table-wrapper');
                $table = $elem.find('table');
                $tbody = (0, _jqueryLib.$)('<tbody/>');
                stack = group_by.length == 0 ? [objects] : [groups];

              case 10:
                if (false) {}

                if (!(stack.length == 0)) {
                  _context3.next = 13;
                  break;
                }

                return _context3.abrupt("break", 49);

              case 13:
                group = stack.pop();

                if (!Array.isArray(group)) {
                  _context3.next = 22;
                  break;
                }

                $previous = $tbody.children().last();
                parent_group_id = '';

                if ($previous && $previous.hasClass('sb-group-row')) {
                  parent_group_id = $previous.attr('data-id');
                } // group is an array of objects: render a row for each object


                _iterator6 = _createForOfIteratorHelper(group);

                try {
                  for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
                    object = _step6.value;
                    $row = this.feedListCreateObjectRow(object, parent_group_id);
                    $tbody.append($row);
                  } // #todo - if operations are defined, add a line for each group

                } catch (err) {
                  _iterator6.e(err);
                } finally {
                  _iterator6.f();
                }

                _context3.next = 47;
                break;

              case 22:
                if (!group.hasOwnProperty('_is_group')) {
                  _context3.next = 27;
                  break;
                }

                _$row = this.feedListCreateGroupRow(group, $tbody);
                $tbody.append(_$row);
                _context3.next = 47;
                break;

              case 27:
                // #memo - keys must be strings
                keys = Object.keys(group).sort().reverse();
                _iterator7 = _createForOfIteratorHelper(keys);
                _context3.prev = 29;

                _iterator7.s();

              case 31:
                if ((_step7 = _iterator7.n()).done) {
                  _context3.next = 39;
                  break;
                }

                key = _step7.value;

                if (!(['_id', '_parent_id', '_key', '_label'].indexOf(key) >= 0)) {
                  _context3.next = 35;
                  break;
                }

                return _context3.abrupt("continue", 37);

              case 35:
                // add object or array
                if (group[key].hasOwnProperty('_data')) {
                  stack.push(group[key]['_data']);
                } else {
                  stack.push(group[key]);
                }

                stack.push(_objectSpread({
                  '_is_group': true
                }, group[key]));

              case 37:
                _context3.next = 31;
                break;

              case 39:
                _context3.next = 44;
                break;

              case 41:
                _context3.prev = 41;
                _context3.t0 = _context3["catch"](29);

                _iterator7.e(_context3.t0);

              case 44:
                _context3.prev = 44;

                _iterator7.f();

                return _context3.finish(44);

              case 47:
                _context3.next = 10;
                break;

              case 49:
                $table.find('tbody').remove();
                $table.append($tbody);

                if (!schema.hasOwnProperty('operations')) {
                  _context3.next = 109;
                  break;
                }

                _context3.t1 = _regenerator.default.keys(schema.operations);

              case 53:
                if ((_context3.t2 = _context3.t1()).done) {
                  _context3.next = 109;
                  break;
                }

                operation = _context3.t2.value;
                descriptor = schema.operations[operation];
                _iterator8 = _createForOfIteratorHelper(schema.layout.items);
                _context3.prev = 57;

                _iterator8.s();

              case 59:
                if ((_step8 = _iterator8.n()).done) {
                  _context3.next = 99;
                  break;
                }

                item = _step8.value;

                if (!(!item.hasOwnProperty('visible') || item.visible == true)) {
                  _context3.next = 97;
                  break;
                }

                if (!descriptor.hasOwnProperty(item.value)) {
                  _context3.next = 97;
                  break;
                }

                type = descriptor[item.value]['operation'];
                result = 0.0;
                _iterator9 = _createForOfIteratorHelper(objects);
                _context3.prev = 66;

                _iterator9.s();

              case 68:
                if ((_step9 = _iterator9.n()).done) {
                  _context3.next = 82;
                  break;
                }

                _object = _step9.value;
                _context3.t3 = type;
                _context3.next = _context3.t3 === 'SUM' ? 73 : _context3.t3 === 'COUNT' ? 75 : _context3.t3 === 'MIN' ? 77 : _context3.t3 === 'MAX' ? 78 : _context3.t3 === 'AVG' ? 79 : 80;
                break;

              case 73:
                result += _object[item.value];
                return _context3.abrupt("break", 80);

              case 75:
                result += 1;
                return _context3.abrupt("break", 80);

              case 77:
                return _context3.abrupt("break", 80);

              case 78:
                return _context3.abrupt("break", 80);

              case 79:
                return _context3.abrupt("break", 80);

              case 80:
                _context3.next = 68;
                break;

              case 82:
                _context3.next = 87;
                break;

              case 84:
                _context3.prev = 84;
                _context3.t4 = _context3["catch"](66);

                _iterator9.e(_context3.t4);

              case 87:
                _context3.prev = 87;

                _iterator9.f();

                return _context3.finish(87);

              case 90:
                value = result;
                prefix = '';
                suffix = '';

                if (descriptor[item.value].hasOwnProperty('usage')) {
                  usage = descriptor[item.value]['usage'];

                  if (usage.indexOf('amount/percent') >= 0 || usage.indexOf('amount/rate') >= 0) {
                    suffix = '%';
                    value = (value * 100).toFixed(0);
                  } else if (usage.indexOf('amount/money') >= 0) {
                    value = _equalServices.EnvService.formatCurrency(value);
                  } else if (usage.indexOf('numeric/integer') >= 0) {
                    value = value.toFixed(0);
                  }
                } else {
                  value = _equalServices.EnvService.formatNumber(value);
                }

                if (descriptor[item.value].hasOwnProperty('prefix')) {
                  prefix = descriptor[item.value]['prefix'];
                }

                if (descriptor[item.value].hasOwnProperty('suffix')) {
                  suffix = descriptor[item.value]['suffix'];
                }

                this.$layout.find('[data-id="' + 'operation-' + operation + '-' + item.value + '"]').val(prefix + value + suffix);

              case 97:
                _context3.next = 59;
                break;

              case 99:
                _context3.next = 104;
                break;

              case 101:
                _context3.prev = 101;
                _context3.t5 = _context3["catch"](57);

                _iterator8.e(_context3.t5);

              case 104:
                _context3.prev = 104;

                _iterator8.f();

                return _context3.finish(104);

              case 107:
                _context3.next = 53;
                break;

              case 109:
                _materialLib.UIHelper.decorateTable($elem);

              case 110:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this, [[29, 41, 44, 47], [57, 101, 104, 107], [66, 84, 87, 90]]);
      }));

      function feed(_x) {
        return _feed.apply(this, arguments);
      }

      return feed;
    }()
  }, {
    key: "feedListGroupObjects",
    value: function feedListGroupObjects(objects, group_by) {
      var groups = {};
      var model_fields = this.view.getModelFields(); // group objects

      var _iterator10 = _createForOfIteratorHelper(objects),
          _step10;

      try {
        for (_iterator10.s(); !(_step10 = _iterator10.n()).done;) {
          var object = _step10.value;
          var n = group_by.length;
          var parent = groups;
          var parent_id = '';

          for (var i = 0; i < n; ++i) {
            var field = void 0,
                group = group_by[i];

            if (typeof group == 'object') {
              if (!group.hasOwnProperty('field')) {
                continue;
              }

              field = group.field;
            } else {
              field = group;
            }

            var model_def = model_fields[field];
            var key = object[field];
            var label = key;

            if (key.hasOwnProperty('name')) {
              label = key.name;
              key = key.name;
            }

            if (['date', 'datetime'].indexOf(model_def['type']) >= 0) {
              label = (0, _moment.default)(key).format(_moment.default.localeData().longDateFormat('L'));
              key = (0, _moment.default)(key).format('YYYY-MM-DD');
            } else if (model_def.hasOwnProperty('usage')) {
              if (model_def.usage == 'date/month') {
                // convert ISO8601 month (1-12) to js month  (0-11)
                key = parseInt(key) - 1;
                label = (0, _moment.default)().month(key).format('MMMM');
                key = String(key).padStart(2, '0');
              }
            }

            if (!parent.hasOwnProperty(key)) {
              if (i < n - 1) {
                parent[key] = {
                  '_id': parent_id + key,
                  '_parent_id': parent_id,
                  '_key': key,
                  '_label': label
                };
              } else {
                parent[key] = {
                  '_id': parent_id + key,
                  '_parent_id': parent_id,
                  '_key': key,
                  '_label': label,
                  '_data': []
                };

                if (typeof group == 'object' && group.hasOwnProperty('operation')) {
                  parent[key]['_operation'] = group.operation;
                }
              }
            }

            parent_id = parent_id + key;
            parent = parent[key];
          }

          if (parent.hasOwnProperty('_data') && Array.isArray(parent['_data'])) {
            parent['_data'].push(object);
          }
        }
      } catch (err) {
        _iterator10.e(err);
      } finally {
        _iterator10.f();
      }

      return groups;
    }
  }, {
    key: "feedListCreateObjectRow",
    value: function feedListCreateObjectRow(object, parent_group_id) {
      var _this2 = this;

      var schema = this.view.getViewSchema();
      var view_fields = this.view.getViewFields();
      var model_fields = this.view.getModelFields();
      var translation = this.view.getTranslation();
      var group_by = this.view.getGroupBy();
      var $row = (0, _jqueryLib.$)('<tr/>').addClass('sb-view-layout-list-row').attr('data-parent-id', parent_group_id).attr('data-id', object.id).attr('data-edit', '0') // open form view on click
      .on('click', function (event) {
        var $this = (0, _jqueryLib.$)(event.currentTarget); // discard click when row is being edited

        if ($this.attr('data-edit') == '0') {
          // #todo - allow overloading default action ('ACTIONS.UPDATE')
          _this2.openContext({
            entity: _this2.view.getEntity(),
            type: 'form',
            name: _this2.view.getName(),
            domain: ['id', '=', object.id]
          });
        }
      }) // toggle mode for all cells in row
      .on('_toggle_mode', function (event) {
        var mode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'view';
        console.debug('Layout - received toggle_mode', mode);
        var $this = (0, _jqueryLib.$)(event.currentTarget);
        $this.find('td.sb-widget-cell').each(function (index, elem) {
          var $cell = (0, _jqueryLib.$)(elem);
          var field = $cell.attr('data-field');
          var widget = _this2.model_widgets[object.id][field]; // switch to given mode

          if (widget.getMode() == mode) return;
          var $widget = widget.setMode(mode).render(); // handle special situations that allow cell content to overflow

          if (widget.getType() == 'boolean') {
            $cell.addClass('allow-overflow');
          }

          $cell.empty().append($widget);

          if (mode == 'edit') {
            $widget.on('_updatedWidget', function (event) {
              console.debug('Layout - received _updatedWidget event', widget.getValue());
              var value = {};
              value[field] = widget.getValue(); // propagate model change, without requesting a layout refresh

              _this2.view.onchangeViewModel([object.id], value, false);
            });
          }
        });
      }) // dispatch value setter
      .on('_setValue', function (event, field, value) {
        var widget = _this2.model_widgets[object.id][field];
        widget.change(value);
      }); // for lists in edit mode (excepted widgets), add a checkbox

      if (this.view.getPurpose() != 'widget' || this.view.getMode() == 'edit') {
        _materialLib.UIHelper.createTableCellCheckbox().addClass('sb-view-layout-list-row-checkbox').appendTo($row).find('input').attr('data-id', object.id).on('click', function (event) {
          // wait for widget to update and notify about change
          setTimeout(function () {
            return _this2.view.onchangeSelection(_this2.getSelected());
          }); // prevent handling of click on parent `tr` element

          event.stopPropagation();
        });
      }

      if (group_by.length > 0) {
        // add a cell for the toggle chevron column
        $row.append((0, _jqueryLib.$)('<td/>'));
      } // for each field, create a widget, append to a cell, and append cell to row


      var is_first = true;

      var _iterator11 = _createForOfIteratorHelper(schema.layout.items),
          _step11;

      try {
        for (_iterator11.s(); !(_step11 = _iterator11.n()).done;) {
          var item = _step11.value;

          var config = _equalWidgets.WidgetFactory.getWidgetConfig(this.view, item.value, translation, model_fields, view_fields); // unknown or invisible field


          if (config === null || config.hasOwnProperty('visible') && !config.visible) continue;
          var value = object[item.value]; // for relational fields, we need to check if the Model has been fetched

          if (['one2many', 'many2one', 'many2many'].indexOf(config.type) > -1) {
            // if widget has a domain, parse it using current object and user
            if (config.hasOwnProperty('original_domain')) {
              var user = this.view.getUser();
              var tmpDomain = new _Domain.Domain(config.original_domain);
              config.domain = tmpDomain.parse(object, user).toArray();
            } else {
              config.domain = [];
            } // by convention, `name` subfield is always loaded for relational fields


            if (config.type == 'many2one') {
              value = object[item.value] && object[item.value].hasOwnProperty('name') ? object[item.value]['name'] : '';
              config.object_id = object[item.value] && object[item.value].hasOwnProperty('id') ? object[item.value]['id'] : 0;
            } else {
              // Model do not load o2m and m2m fields : these are handled by sub-views
              // value = object[item.value].map( (o:any) => o.name).join(', ');
              // value = (value.length > 35)? value.substring(0, 35) + "..." : value;
              value = "..."; // we need the current object id for new objects creation

              config.object_id = object.id;
            }
          }

          var widget = _equalWidgets.WidgetFactory.getWidget(this, config.type, '', '', config);

          widget.setValue(value);
          widget.setReadonly(config.readonly);
          widget.setIsFirst(is_first);
          is_first = false; // store widget in widgets Map, using widget id as key (there are several rows for each field)

          if (typeof this.model_widgets[object.id] == 'undefined') {
            this.model_widgets[object.id] = {};
          } // store widget: use id and field as keys for storing widgets (current layout is for a single entity)


          this.model_widgets[object.id][item.value] = widget;
          var $cell = (0, _jqueryLib.$)('<td/>').addClass('sb-widget-cell').attr('data-type', config.type).attr('data-field', item.value).append(widget.render());
          $row.append($cell);
        }
      } catch (err) {
        _iterator11.e(err);
      } finally {
        _iterator11.f();
      }

      if (parent_group_id.length) {
        $row.hide();
      }

      return $row;
    }
  }, {
    key: "feedListCreateGroupRow",
    value: function feedListCreateGroupRow(group, $tbody) {
      var _this3 = this;

      var schema = this.view.getViewSchema();
      var label = group['_label'];
      var prefix = '';
      var suffix = '';
      var children_count = 0;
      var parent_group_id = group['_parent_id'];

      if (parent_group_id.length > 0) {
        var $prev_td = $tbody.find("[data-id='" + parent_group_id + "']").find('.sb-group-cell-label').first();

        if ($prev_td) {
          prefix = $prev_td.attr('title') + ' › ';
        }
      }

      if (group.hasOwnProperty('_data')) {
        children_count = group['_data'].length;

        if (group.hasOwnProperty('_operation')) {
          var op_result = 0;
          var op_type = group._operation[0];

          var op_field = group._operation[1].split('.')[1];

          var _iterator12 = _createForOfIteratorHelper(group['_data']),
              _step12;

          try {
            for (_iterator12.s(); !(_step12 = _iterator12.n()).done;) {
              var obj = _step12.value;

              if (obj.hasOwnProperty(op_field)) {
                // #todo - handle all cases of operations
                op_result += obj[op_field];
              }
            }
          } catch (err) {
            _iterator12.e(err);
          } finally {
            _iterator12.f();
          }

          suffix = '[' + op_result + ']';
        } else {
          suffix = '[' + children_count + ']';
        }
      } else {// sum children groups
      }

      var $row = (0, _jqueryLib.$)('<tr/>').addClass('sb-view-layout-list-row sb-group-row folded').attr('data-parent-id', parent_group_id).attr('data-id', group['_id']).attr('data-key', group['_key']).attr('data-label', group['_label']).attr('data-children-count', children_count).attr('id', _materialLib.UIHelper.getUUID());

      if (this.view.getPurpose() != 'widget' || this.view.getMode() == 'edit') {
        var $checkbox = _materialLib.UIHelper.createTableCellCheckbox().addClass('sb-view-layout-list-row-checkbox');

        $checkbox.find('input').on('click', function (event) {
          event.stopPropagation();

          var $tbody = _this3.$layout.find('tbody');

          var checked = $checkbox.find('input').prop('checked');
          var selection = [];
          $tbody.find("[data-parent-id='" + group['_id'] + "']").each(function (index, elem) {
            var $this = (0, _jqueryLib.$)(elem);

            if ($this.hasClass('sb-group-row')) {
              var subchecked = $this.children().first().find('input').prop('checked');

              if (checked != subchecked) {
                $this.children().first().find('input').trigger('click');
              }
            } else {
              selection.push(parseInt($this.children().first().find('input').attr('data-id'), 10));
            }
          });

          if (checked) {
            _this3.addToSelection(selection);
          } else {
            _this3.removeFromSelection(selection);
          }
        });
        $row.append($checkbox);
      }

      $row.append((0, _jqueryLib.$)('<td />').addClass('sb-group-cell').append((0, _jqueryLib.$)('<i/>').addClass('material-icons sb-toggle-button').text('chevron_right')));
      $row.append((0, _jqueryLib.$)('<td/>').attr('title', prefix + label).attr('colspan', schema.layout.items.length).addClass('sb-group-cell sb-group-cell-label').append('<div style="display: flex;"> <div style="overflow: hidden;text-overflow: ellipsis;">' + prefix + ' <span>' + label + '</span></div>' + '<div style="font-weight: 500; margin-left: 20px;">' + suffix + '</div></div>'));
      $row.on('click', function () {
        var $tbody = _this3.$layout.find('tbody');

        var group_id = $row.attr('data-id');

        if ($row.hasClass('folded')) {
          $row.removeClass('folded');
          $tbody.find("[data-parent-id='" + group_id + "']").each(function (index, elem) {
            var $this = (0, _jqueryLib.$)(elem);

            if ($this.hasClass('sb-group-row')) {
              $this.trigger('show');
            } else {
              $this.show();
            }
          });
        } else {
          $row.addClass('folded');
          $tbody.find("[data-parent-id='" + group_id + "']").each(function (index, elem) {
            var $this = (0, _jqueryLib.$)(elem);

            if ($this.hasClass('sb-group-row')) {
              $this.trigger('hide');
            } else {
              $this.hide();
            }
          });
        }
      });
      $row.on('show', function () {
        var $tbody = _this3.$layout.find('tbody');

        var group_id = $row.attr('data-id');
        $row.show();
        $tbody.find("[data-parent-id='" + group_id + "']").each(function (index, elem) {
          var $this = (0, _jqueryLib.$)(elem);

          if ($this.hasClass('sb-group-row')) {// $this.trigger('show');
          } else if (!$row.hasClass('folded')) {
            $this.show();
          }
        });
      });
      $row.on('hide', function () {
        var $tbody = _this3.$layout.find('tbody');

        var group_id = $row.attr('data-id');
        $row.hide();
        $tbody.find("[data-parent-id='" + group_id + "']").each(function (index, elem) {
          var $this = (0, _jqueryLib.$)(elem);

          if ($this.hasClass('sb-group-row')) {
            $this.trigger('hide');
          } else {
            $this.hide();
          }
        });
      });

      if (parent_group_id.length) {
        $row.hide();
      }

      return $row;
    }
  }]);
  return LayoutList;
}(_Layout2.Layout);

exports.LayoutList = LayoutList;

/***/ }),

/***/ "./build/layouts/LayoutSearch.js":
/*!***************************************!*\
  !*** ./build/layouts/LayoutSearch.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LayoutSearch = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _slicedToArray2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/slicedToArray.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _jqueryLib = __webpack_require__(/*! ../jquery-lib */ "./build/jquery-lib.js");

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _equalWidgets = __webpack_require__(/*! ../equal-widgets */ "./build/equal-widgets.js");

var _Layout2 = __webpack_require__(/*! ./Layout */ "./build/layouts/Layout.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

var _Domain = __webpack_require__(/*! ../Domain */ "./build/Domain.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var LayoutSearch = /*#__PURE__*/function (_Layout) {
  (0, _inherits2.default)(LayoutSearch, _Layout);

  var _super = _createSuper(LayoutSearch);

  function LayoutSearch() {
    (0, _classCallCheck2.default)(this, LayoutSearch);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(LayoutSearch, [{
    key: "init",
    value: function () {
      var _init = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
        return _regenerator.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                console.debug('LayoutSearch::init');

                try {
                  // initialize the layout
                  this.layout();
                } catch (err) {
                  console.warn('Something went wrong ', err);
                }

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function init() {
        return _init.apply(this, arguments);
      }

      return init;
    }() // refresh layout
    // this method is called in response to parent View `onchangeModel` method

  }, {
    key: "refresh",
    value: function () {
      var _refresh = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
        var full,
            objects,
            _args2 = arguments;
        return _regenerator.default.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                full = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : false;
                console.debug('LayoutSearch::refresh'); // also re-generate the layout

                if (full) {
                  this.$layout.empty();
                  this.layout();
                } // feed layout with current Model


                _context2.next = 5;
                return this.view.getModel().get();

              case 5:
                objects = _context2.sent;
                this.feed(objects);

              case 7:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this);
      }));

      function refresh() {
        return _refresh.apply(this, arguments);
      }

      return refresh;
    }()
    /**
     *
     * This method also stores the list of instanciated widgets to allow switching from view mode to edit mode  (for a form or a cell)
     *
     */

  }, {
    key: "layout",
    value: function layout() {
      var _this = this;

      console.debug('LayoutSearch::layout');
      var $elem = (0, _jqueryLib.$)('<div/>').css({
        "width": "100%"
      });
      var view_schema = this.view.getViewSchema();
      var view_fields = this.view.getViewFields();
      var model_fields = this.view.getModelFields();
      var translation = this.view.getTranslation();
      var view_config = this.view.getConfig();

      if (!view_schema.hasOwnProperty('layout') || !view_schema.layout.hasOwnProperty('groups')) {
        console.warn("invalid layout, stop processing");
        return;
      }

      _jqueryLib.$.each(view_schema.layout.groups, function (i, group) {
        var group_id = 'group-' + i;
        var $group = (0, _jqueryLib.$)('<div />').addClass('sb-view-form-group').appendTo($elem); // try to resolve the group title

        var group_title = group.hasOwnProperty('label') ? group.label : '';

        if (group.hasOwnProperty('id')) {
          group_title = _equalServices.TranslationService.resolve(translation, 'view', [_this.view.getId(), 'layout'], group.id, group_title);
        } // append the group title, if any


        if (group_title.length) {
          $group.append((0, _jqueryLib.$)('<div/>').addClass('sb-view-form-group-title').text(group_title));
        }

        var selected_section = 0;

        if (view_config && view_config.hasOwnProperty('selected_sections') && view_config.selected_sections.hasOwnProperty(i)) {
          selected_section = view_config.selected_sections[i];
        }

        var $tabs = _materialLib.UIHelper.createTabBar('sections-' + group_id, '', '').addClass('sb-view-form-sections-tabbar');

        if (group.sections.length > 1 || group.sections[0].hasOwnProperty('label')) {
          $group.append($tabs);
        }

        _jqueryLib.$.each(group.sections, function (j, section) {
          var section_id = group_id + '-section-' + j;
          var $section = (0, _jqueryLib.$)('<div />').attr('id', section_id).addClass('sb-view-form-section mdc-layout-grid').appendTo($group);

          if (j != selected_section) {
            $section.hide();
          }

          if (group.sections.length > 1 || section.hasOwnProperty('label')) {
            // try to resolve the section title
            var section_title = section.hasOwnProperty('label') ? section.label : section_id;

            if (section.hasOwnProperty('id')) {
              section_title = _equalServices.TranslationService.resolve(translation, 'view', [_this.view.getId(), 'layout'], section.id, section_title);
            }

            var $tab = _materialLib.UIHelper.createTabButton(section_id + '-tab', section_title, j == selected_section).addClass('sb-view-form-section-tab').on('click', function () {
              $group.find('.sb-view-form-section').hide();
              $group.find('#' + section_id).show();
            });

            if (section.hasOwnProperty('visible')) {
              $tab.attr('data-visible', JSON.stringify(section.visible));
            }

            $tabs.find('.sb-view-form-sections').append($tab);
          }

          _jqueryLib.$.each(section.rows, function (k, row) {
            var $row = (0, _jqueryLib.$)('<div />').addClass('sb-view-form-row mdc-layout-grid__inner').appendTo($section);

            _jqueryLib.$.each(row.columns, function (l, column) {
              var $column = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($row);

              if (column.hasOwnProperty('width')) {
                $column.addClass('mdc-layout-grid__cell--span-' + Math.round(parseInt(column.width, 10) / 100 * 12));
              }

              if (column.hasOwnProperty('align') && column.align == 'right') {
                $column.css({
                  'margin-left': 'auto'
                });
              }

              var $inner_cell = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($column);
              $column = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__inner').appendTo($inner_cell);

              _jqueryLib.$.each(column.items, function (i, item) {
                if (typeof _this.model_widgets[0] == 'undefined') {
                  _this.model_widgets[0] = {};
                }

                var $cell = (0, _jqueryLib.$)('<div />').addClass('mdc-layout-grid__cell').appendTo($column); // compute the width (on a 12 columns grid basis), from 1 to 12

                var width = item.hasOwnProperty('width') ? Math.round(parseInt(item.width, 10) / 100 * 12) : 12;
                $cell.addClass('mdc-layout-grid__cell--span-' + width);

                if (item.hasOwnProperty('type') && item.hasOwnProperty('value')) {
                  if (item.type == 'field') {
                    var config = _equalWidgets.WidgetFactory.getWidgetConfig(_this.view, item.value, translation, model_fields, view_fields);

                    if (config) {
                      config.has_action_create = false;
                      config.has_action_open = false;

                      var widget = _equalWidgets.WidgetFactory.getWidget(_this, config.type, config.title, '', config);

                      widget.setMode(_this.view.getMode()); // store widget in widgets Map, using field name as key

                      _this.model_widgets[0][item.value] = widget;
                      $cell.append(widget.attach());
                    }
                  } else if (item.type == 'label') {
                    var label_title = _equalServices.TranslationService.resolve(translation, 'view', [_this.view.getId(), 'layout'], item.id, item.value);

                    var _widget = _equalWidgets.WidgetFactory.getWidget(_this, 'label', '', label_title, _objectSpread({
                      widget_type: 'label'
                    }, item));

                    _this.model_widgets[0]['__label_' + _widget.getId()] = _widget;
                    $cell.append(_widget.render());
                  }
                }
              });
            });
          });
        });

        _materialLib.UIHelper.decorateTabBar($tabs);
      });

      this.$layout.append($elem);
    }
  }, {
    key: "feed",
    value: function () {
      var _feed = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4(objects) {
        var _this2 = this;

        var fields, model_fields, focused_widget_id;
        return _regenerator.default.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                console.debug('LayoutSearch::feed', objects); // display the first object from the collection

                fields = Object.keys(this.view.getViewFields());
                model_fields = this.view.getModelFields(); // remember which element has focus (DOM is going to be modified)

                focused_widget_id = (0, _jqueryLib.$)("input:focus").closest('.sb-widget').attr('id');

                if (objects.length > 0) {
                  (function () {
                    // #todo - keep internal index of the object to display (with a prev/next navigation in the header)
                    var object = objects[0]; // update actions in view header

                    var view_schema = _this2.view.getViewSchema(); // update tabs visibility, if any


                    var $tabs = _this2.$layout.find('.mdc-tab.sb-view-form-section-tab');

                    $tabs.each(function (i, elem) {
                      var $tab = (0, _jqueryLib.$)(elem);
                      var visible = $tab.attr('data-visible');

                      if (visible != undefined) {
                        var domain = new _Domain.Domain(JSON.parse(visible));

                        if (domain.evaluate(object)) {
                          $tab.show();
                        } else {
                          $tab.hide();
                        }
                      }
                    });

                    var _loop = function _loop() {
                      var widget_index = _Object$keys[_i];
                      var widget = _this2.model_widgets[0][widget_index];
                      var config = widget.getConfig();

                      if (config['widget_type'] == 'label') {
                        var visible = true; // handle visibility tests (domain)

                        if (config.hasOwnProperty('visible')) {
                          // visible attribute is a Domain
                          if (Array.isArray(config.visible)) {
                            var domain = new _Domain.Domain(config.visible);
                            visible = domain.evaluate(object);
                          } else {
                            visible = config.visible;
                          }
                        }

                        var $parent = _this2.$layout.find('#' + widget.getId()).parent();

                        if (!visible) {
                          $parent.empty().append(widget.attach()).hide();
                        } else {
                          $parent.empty().append(widget.render()).show();
                        }
                      } else {
                        var field = config.field; // widget might be missing (if not visible)

                        if (!widget) return "continue";

                        var _$parent = _this2.$layout.find('#' + widget.getId()).parent();

                        var type = _this2.view.getModel().getFinalType(field);

                        var has_changed = false;
                        var value = object.hasOwnProperty(field) ? object[field] : undefined; // for relational fields, we need to check if the Model has been fetched

                        if (['one2many', 'many2one', 'many2many'].indexOf(type) > -1) {
                          var user = _this2.view.getUser(); // if widget has a domain, parse it using current object and user


                          if (config.hasOwnProperty('original_domain')) {
                            var tmpDomain = new _Domain.Domain(config.original_domain);
                            config.domain = tmpDomain.parse(object, user).toArray();
                          } else {
                            config.domain = [];
                          } // if widget has a custom header defintion, parse subsequent domains, if any


                          if (config.hasOwnProperty('header') && config.header.hasOwnProperty('actions')) {
                            for (var _i2 = 0, _Object$entries = Object.entries(config.header.actions); _i2 < _Object$entries.length; _i2++) {
                              var _Object$entries$_i = (0, _slicedToArray2.default)(_Object$entries[_i2], 2),
                                  id = _Object$entries$_i[0],
                                  items = _Object$entries$_i[1];

                              for (var index in items) {
                                var item = items[index];

                                if (item.hasOwnProperty('domain')) {
                                  var _tmpDomain = new _Domain.Domain(item.domain);

                                  config.header.actions[id][index].domain = _tmpDomain.parse(object, user).toArray();
                                }
                              }
                            }
                          } // by convention, `name` subfield is always loaded for relational fields


                          if (type == 'many2one') {
                            if (object[field]) {
                              value = object[field]['name'];
                              config.object_id = object[field]['id'];
                            }
                          } else if (type == 'many2many' || type == 'one2many') {
                            // init field if not present yet (o2m and m2m are not loaded by Model)
                            if (!object.hasOwnProperty(field)) {
                              object[field] = []; // force change detection (upon re-feed, the field do not change and remains an empty array)

                              _$parent.data('value', null);
                            } // for m2m fields, the value of the field is an array of ids
                            // by convention, when a relation is to be removed, the id field is set to its negative value


                            value = object[field]; // select ids to load by filtering targeted objects

                            config.ids_to_add = object[field].filter(function (id) {
                              return id > 0;
                            });
                            config.ids_to_del = object[field].filter(function (id) {
                              return id < 0;
                            }).map(function (id) {
                              return -id;
                            }); // we need the current object id for new objects creation

                            config.object_id = object.id;
                          }
                        }

                        has_changed = !value || _$parent.data('value') != JSON.stringify(value);
                        widget.setConfig(_objectSpread(_objectSpread({}, config), {}, {
                          ready: true
                        })).setMode(_this2.view.getMode()).setValue(value); // store data to parent, for tracking changes at next refresh (prevent storing references)

                        _$parent.data('value', JSON.stringify(value) || null);

                        var _visible = true; // handle visibility tests (domain)

                        if (config.hasOwnProperty('visible')) {
                          // visible attribute is a Domain
                          if (Array.isArray(config.visible)) {
                            var _domain = new _Domain.Domain(config.visible);

                            _visible = _domain.evaluate(object);
                          } else {
                            _visible = config.visible;
                          }
                        }

                        if (!_visible) {
                          _$parent.empty().append(widget.attach()).hide(); // visibility update need to trigger a redraw, whatever the value (so we change it to an arbitrary value)


                          _$parent.data('value', null);
                        } else {
                          var $widget = widget.render(); // Handle Widget update handler

                          $widget.on('_updatedWidget', /*#__PURE__*/function () {
                            var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3(event) {
                              var refresh,
                                  values,
                                  _args3 = arguments;
                              return _regenerator.default.wrap(function _callee3$(_context3) {
                                while (1) {
                                  switch (_context3.prev = _context3.next) {
                                    case 0:
                                      refresh = _args3.length > 1 && _args3[1] !== undefined ? _args3[1] : true;
                                      console.debug("Layout::feedForm : received _updatedWidget", field, widget.getValue(), refresh); // update object with new value

                                      values = {};
                                      values[field] = widget.getValue(); // update model without refreshing the view

                                      _this2.view.onchangeViewModel([object.id], values, true);

                                    case 5:
                                    case "end":
                                      return _context3.stop();
                                  }
                                }
                              }, _callee3);
                            }));

                            return function (_x2) {
                              return _ref.apply(this, arguments);
                            };
                          }()); // prevent refreshing objects that haven't changed

                          if (has_changed) {
                            // append rendered widget
                            _$parent.empty().append($widget).show();
                          }
                        }
                      }
                    };

                    for (var _i = 0, _Object$keys = Object.keys(_this2.model_widgets[0]); _i < _Object$keys.length; _i++) {
                      var _ret = _loop();

                      if (_ret === "continue") continue;
                    } // try to give the focus back to the previously focused widget


                    (0, _jqueryLib.$)('#' + focused_widget_id).find('input').trigger('focus');
                  })();
                }

              case 5:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function feed(_x) {
        return _feed.apply(this, arguments);
      }

      return feed;
    }()
  }]);
  return LayoutSearch;
}(_Layout2.Layout);

exports.LayoutSearch = LayoutSearch;

/***/ }),

/***/ "./build/material-lib.js":
/*!*******************************!*\
  !*** ./build/material-lib.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
Object.defineProperty(exports, "MDCFormField", ({
  enumerable: true,
  get: function get() {
    return _formField.MDCFormField;
  }
}));
Object.defineProperty(exports, "MDCRipple", ({
  enumerable: true,
  get: function get() {
    return _ripple.MDCRipple;
  }
}));
Object.defineProperty(exports, "MDCCheckbox", ({
  enumerable: true,
  get: function get() {
    return _checkbox.MDCCheckbox;
  }
}));
Object.defineProperty(exports, "MDCDataTable", ({
  enumerable: true,
  get: function get() {
    return _dataTable.MDCDataTable;
  }
}));
Object.defineProperty(exports, "MDCSelect", ({
  enumerable: true,
  get: function get() {
    return _select.MDCSelect;
  }
}));
Object.defineProperty(exports, "MDCMenu", ({
  enumerable: true,
  get: function get() {
    return _menu.MDCMenu;
  }
}));
exports.UIHelper = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _formField = __webpack_require__(/*! @material/form-field */ "./node_modules/@material/form-field/index.js");

var _ripple = __webpack_require__(/*! @material/ripple */ "./node_modules/@material/ripple/index.js");

var _checkbox = __webpack_require__(/*! @material/checkbox */ "./node_modules/@material/checkbox/index.js");

var _textfield = __webpack_require__(/*! @material/textfield */ "./node_modules/@material/textfield/index.js");

var _dataTable = __webpack_require__(/*! @material/data-table */ "./node_modules/@material/data-table/index.js");

var _select = __webpack_require__(/*! @material/select */ "./node_modules/@material/select/index.js");

var _menu = __webpack_require__(/*! @material/menu */ "./node_modules/@material/menu/index.js");

var _tabBar = __webpack_require__(/*! @material/tab-bar */ "./node_modules/@material/tab-bar/index.js");

var _snackbar = __webpack_require__(/*! @material/snackbar */ "./node_modules/@material/snackbar/index.js");

var _switch = __webpack_require__(/*! @material/switch */ "./node_modules/@material/switch/index.js");

var _dialog = __webpack_require__(/*! @material/dialog */ "./node_modules/@material/dialog/index.js");

var _tooltip = __webpack_require__(/*! @material/tooltip */ "./node_modules/@material/tooltip/index.js");

var _jqueryLib = __webpack_require__(/*! ./jquery-lib */ "./build/jquery-lib.js");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var UIHelper = /*#__PURE__*/function () {
  function UIHelper() {
    (0, _classCallCheck2.default)(this, UIHelper);
  }

  (0, _createClass2.default)(UIHelper, null, [{
    key: "getUUID",
    value: function getUUID() {
      var S4 = function S4() {
        return ((1 + Math.random()) * 0x10000 | 0).toString(16).substring(1);
      }; // generate a random guid


      return S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4();
    }
    /*
     Helpers for element creation
    */

  }, {
    key: "createButton",
    value: function createButton(id, label) {
      var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
      var icon = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var variant = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var $button = (0, _jqueryLib.$)('<button/>').attr('id', id);

      if (['outlined', 'raised', 'text'].indexOf(type) >= 0) {
        $button.addClass('mdc-button mdc-button--touch').append((0, _jqueryLib.$)('<span/>').addClass('mdc-button__ripple'));

        if (icon.length) {
          $button.append((0, _jqueryLib.$)('<i/>').addClass('material-icons mdc-button__icon').text(icon));
        }

        $button.append((0, _jqueryLib.$)('<span/>').attr('for', id).addClass('mdc-button__label').text(label));

        switch (type) {
          case 'outlined':
            $button.addClass('mdc-button--outlined');
            break;

          case 'raised':
            $button.addClass('mdc-button--raised');
            break;

          case 'text':
          default:
        }
      } else if (['fab', 'mini-fab'].indexOf(type) >= 0) {
        $button.addClass('mdc-fab').append((0, _jqueryLib.$)('<div/>').addClass('mdc-fab__ripple'));

        if (type == 'mini-fab') {
          $button.addClass('mdc-fab--mini');
        } else {
          $button.addClass('mdc-fab--touch');
        }

        $button.append((0, _jqueryLib.$)('<span/>').addClass('material-icons mdc-fab__icon').text(icon));
        $button.append((0, _jqueryLib.$)('<div/>').addClass('mdc-fab__touch'));
      } else if (['icon'].indexOf(type) >= 0) {
        $button.addClass('mdc-icon-button').attr('aria-describedby', id + '-tooltip').attr('data-tooltip-id', id + '-tooltip').append((0, _jqueryLib.$)('<span/>').addClass('material-icons mdc-icon-button__icon').text(icon)); // #todo - fix ripple not working on icon-button
        // workaround to fix tooltips not hiding

        $button.on("mouseenter", function () {
          $button.parent().find('#' + id + '-tooltip').removeClass('mdc-tooltip--hide');
        });
        $button.on("mouseleave", function () {
          $button.parent().find('#' + id + '-tooltip').addClass('mdc-tooltip--hide');
        });
      }

      switch (variant) {
        case 'primary':
          $button.addClass('mdc-button--primary');
          break;

        case 'secondary':
          $button.addClass('mdc-button--secondary');
          break;

        default:
      }

      new _ripple.MDCRipple($button[0]);
      return $button;
    }
  }, {
    key: "createSplitButton",
    value: function createSplitButton(id, label) {
      var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
      var icon = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var variant = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var $elem = (0, _jqueryLib.$)('<div id="' + id + '" style="display: inline-flex;"></div>');
      var $button = this.createButton(id + '_button', label, type, icon, variant).addClass('mdc-button-split_button');
      var $drop_button = this.createButton(id + '_drop', '', type, 'arrow_drop_down', variant).addClass('mdc-button-split_drop');
      var $drop_menu = this.createMenu(id + '_drop' + 'menu').appendTo($drop_button);
      var $menu_list = this.createList(id + '_drop' + 'menu-list').addClass('menu-list').appendTo($drop_menu);
      this.decorateMenu($drop_menu);
      $drop_button.css({
        'right': 0
      });
      $drop_button.on('click', function (event) {
        event.preventDefault();
        event.stopPropagation();
        var parent_width = Math.round($button.innerWidth()) + Math.round($drop_button.innerWidth());

        if (parent_width > $drop_menu.innerWidth()) {
          $drop_menu.css({
            'width': parent_width + 'px'
          });
        } else {
          $drop_menu.css({
            'left': '-' + Math.round($button.innerWidth()) + 'px'
          });
        }

        $drop_menu.trigger('_toggle');
        return false;
      });
      return $elem.append($button).append($drop_button);
    }
  }, {
    key: "createDropDown",
    value: function createDropDown(id, label) {
      var type = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
      var icon = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var variant = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var $elem = (0, _jqueryLib.$)('<div id="' + id + '" style="display: inline-flex;"></div>');
      var $drop_button = this.createButton(id + '_button', label, type, icon, variant).addClass('mdc-dropdown');
      $drop_button.append((0, _jqueryLib.$)('<i/>').addClass('material-icons mdc-button__icon').text('arrow_drop_down'));
      var $drop_menu = this.createMenu(id + '_drop-' + 'menu').appendTo($drop_button);
      var $menu_list = this.createList(id + '_drop-' + 'menu-list').addClass('menu-list').appendTo($drop_menu);
      this.decorateMenu($drop_menu);
      $drop_button.css({
        'right': 0
      });
      $drop_button.on('click', function (event) {
        event.preventDefault();
        event.stopPropagation();
        var parent_width = Math.round($drop_button.innerWidth());

        if (parent_width > $drop_menu.innerWidth()) {
          $drop_menu.css({
            'width': parent_width + 'px'
          });
        } else {
          $drop_menu.css({
            'left': '-' + Math.round($drop_button.innerWidth()) + 'px'
          });
        }

        $drop_menu.trigger('_toggle');
        return false;
      });
      return $elem.append($drop_button);
    }
  }, {
    key: "createTooltip",
    value: function createTooltip(id, label) {
      var $elem = (0, _jqueryLib.$)('<div/>').attr('id', id + '-tooltip').addClass('mdc-tooltip').attr('role', 'tooltip').attr('aria-hidden', 'true').append((0, _jqueryLib.$)('<div/>').addClass('mdc-tooltip__surface').text(label));
      return $elem;
    }
  }, {
    key: "createIcon",
    value: function createIcon(icon) {
      var $elem = (0, _jqueryLib.$)('<span class="material-icons">' + icon + '</span>');
      return $elem;
    }
  }, {
    key: "createSwitch",
    value: function createSwitch(id, label, value) {
      var helper = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var icon = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var disabled = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
      var $elem = (0, _jqueryLib.$)('\
        <div id="' + id + '"> \
            <div class="sb-ui-switch" > \
                <div class="mdc-switch ' + (disabled ? 'mdc-switch--disabled' : '') + '"> \
                    <div class="mdc-switch__track"></div> \
                    <div class="mdc-switch__thumb-underlay"> \
                        <div class="mdc-switch__thumb"></div> \
                        <input type="checkbox" class="mdc-switch__native-control" role="switch" ' + (value ? 'checked' : '') + ' ' + (disabled ? 'disabled' : '') + '> \
                    </div> \
                </div> \
                <label for="basic-switch">' + label + '</label> \
            </div> \
            <div class="mdc-text-field-helper-line"> \
                <div class="mdc-text-field-helper-text" aria-hidden="true" title="' + helper + '">' + helper + '</div> \
            </div> \
        </div>');
      new _switch.MDCSwitch($elem.find('.mdc-switch')[0]);
      return $elem;
    }
    /**
     *
     * @param type  'filled' (default) or 'outlined'
     */

  }, {
    key: "createInput",
    value: function createInput(id, label, value) {
      var helper = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var icon = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var disabled = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
      var type = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 'filled';
      var trailing_icon = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : '';
      var $elem = (0, _jqueryLib.$)('\
        <div id="' + id + '"> \
            <label class="mdc-text-field mdc-text-field--' + type + ' mdc-text-field--with-trailing-icon"> \
                <span class="mdc-text-field__ripple"></span> \
                <span class="mdc-floating-label">' + label + '</span> \
                ' + (icon.length ? '<i aria-hidden="true" class="material-icons mdc-text-field__icon">' + icon + '</i>' : '') + '\
                <input id="' + id + '_input" ' + (disabled ? 'disabled' : '') + ' class="mdc-text-field__input" type="text" role="presentation" autocorrect="off" autocomplete="off" spellcheck="false" value="' + value + '"> \
                ' + (trailing_icon.length ? '<i class="material-icons mdc-text-field__icon mdc-text-field__icon--trailing" tabindex="0" role="button">' + trailing_icon + '</i>' : '') + '\
                <span class="mdc-line-ripple"></span> \
            </label> \
            <div class="mdc-text-field-helper-line"> \
                <div class="mdc-text-field-helper-text" aria-hidden="true" title="' + helper + '">' + helper + '</div> \
            </div> \
        </div>');
      var text = new _textfield.MDCTextField($elem[0]);
      $elem.find('input').on('change', function () {
        // sync MDC object and input
        text.value = $elem.find('input').val();
      });
      return $elem;
    }
  }, {
    key: "createTextArea",
    value: function createTextArea(id, label, value) {
      var helper = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var icon = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var disabled = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
      var $elem = (0, _jqueryLib.$)('\
        <div> \
            <label class="mdc-text-field mdc-text-field--filled mdc-text-field--textarea mdc-text-field--with-internal-counter"> \
                <span class="mdc-text-field__ripple"></span> \
                <span class="mdc-floating-label" id="my-label-id">' + label + '</span> \
                <span class="mdc-text-field__resizer"> \
                    <textarea ' + (disabled ? 'disabled' : '') + ' class="mdc-text-field__input" rows="8" cols="40" maxlength="255" aria-label="Label">' + value + '</textarea> \
                </span> \
                <span class="mdc-line-ripple"></span> \
            </label> \
            <div class="mdc-text-field-helper-line"> \
              <div class="mdc-text-field-helper-text" aria-hidden="true" title="' + helper + '">' + helper + '</div> \
              <div class="mdc-text-field-character-counter">0 / 255</div> \
          </div> \
        </div>');
      new _textfield.MDCTextField($elem[0]);
      return $elem;
    }
  }, {
    key: "createInputView",
    value: function createInputView(id, label, value, helper) {
      var $elem = (0, _jqueryLib.$)('\
        <div> \
        <label class="mdc-text-field mdc-text-field--filled"> \
            <span class="mdc-floating-label">' + label + '</span> \
            <input disabled class="mdc-text-field__input" type="text" value="' + value + '"> \
            <span class="mdc-line-ripple"></span>\
        </label> \
        <div class="mdc-text-field-helper-line"> \
            <div class="mdc-text-field-helper-text" aria-hidden="true" title="' + helper + '">' + helper + '</div> \
        </div> \
        </div>');
      new _textfield.MDCTextField($elem[0]);
      return $elem;
    }
  }, {
    key: "createCheckbox",
    value: function createCheckbox(id, label) {
      var $elem = (0, _jqueryLib.$)('\
        <div class="mdc-form-field"> \
            <div class="mdc-checkbox"> \
                <input type="checkbox" class="mdc-checkbox__native-control" id="' + id + '"/> \
                <div class="mdc-checkbox__background"> \
                    <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24"> \
                        <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/> \
                    </svg> \
                    <div class="mdc-checkbox__mixedmark"></div> \
                </div> \
                <div class="mdc-checkbox__ripple"></div> \
            </div> \
            <label for="' + id + '">' + label + '</label> \
        </div>');
      return $elem;
    }
  }, {
    key: "createListItem",
    value: function createListItem(id, label) {
      var icon = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
      var $elem = (0, _jqueryLib.$)('\
        <li class="mdc-list-item" tabindex="-1" id="' + id + '"> \
            <span class="mdc-list-item__text">' + label + '</span> \
            <span class="mdc-list-item__ripple"></span> \
        </li>');

      if (icon.length) {
        $elem.prepend((0, _jqueryLib.$)('<span/>').addClass('mdc-list-item__graphic material-icons').text(icon));
      }

      new _ripple.MDCRipple($elem[0]);
      return $elem;
    }
  }, {
    key: "createListDivider",
    value: function createListDivider() {
      return (0, _jqueryLib.$)('<li role="separator" class="mdc-list-divider"></li>');
    }
  }, {
    key: "createListItemCheckbox",
    value: function createListItemCheckbox(id, label) {
      var $elem = (0, _jqueryLib.$)('\
        <li class="mdc-list-item"> \
            <div class="mdc-touch-target-wrapper"> \
                <div class="mdc-checkbox mdc-checkbox--touch"> \
                    <input type="checkbox" class="mdc-checkbox__native-control" id="' + id + '"/> \
                    <div class="mdc-checkbox__background"> \
                        <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24"> \
                            <path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59"/> \
                        </svg> \
                        <div class="mdc-checkbox__mixedmark"></div> \
                    </div> \
                    <div class="mdc-checkbox__ripple"></div> \
                </div> \
            </div> \
            <span class="mdc-list-item__ripple"></span> \
            <span class="mdc-list-item__text">' + label + '</span> \
        </li>');
      new _ripple.MDCRipple($elem[0]);
      return $elem;
    }
  }, {
    key: "createTableCellCheckbox",
    value: function createTableCellCheckbox() {
      var is_header = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var elem = is_header ? 'th' : 'td';
      var suffix = is_header ? 'header-' : '';
      var $elem = (0, _jqueryLib.$)('\
        <' + elem + ' class="mdc-data-table__' + suffix + 'cell mdc-data-table__' + suffix + 'cell--checkbox"> \
            <div class="sb-ui-checkbox mdc-checkbox mdc-data-table__' + suffix + 'row-checkbox"> \
                <input type="checkbox" class ="mdc-checkbox__native-control" /> \
                <div class="mdc-checkbox__background"> \
                    <svg class="mdc-checkbox__checkmark" viewBox="0 0 24 24"><path class="mdc-checkbox__checkmark-path" fill="none" d="M1.73,12.91 8.1,19.28 22.79,4.59" /></svg> \
                <div class="mdc-checkbox__mixedmark"></div> \
            </div> \
            <div class="mdc-checkbox__ripple"></div> \
        </' + elem + '> \
        ');
      new _ripple.MDCRipple($elem[0]);
      return $elem;
    }
  }, {
    key: "createChip",
    value: function createChip(label) {
      var $elem = (0, _jqueryLib.$)(' \
        <div class="mdc-chip" role="row"> \
            <div class="mdc-chip__ripple"></div> \
            <span role="gridcell"> \
                <span role="button" tabindex="0" class="mdc-chip__primary-action"> \
                <span class="mdc-chip__text">' + label + '</span> \
                </span> \
            </span> \
            <span role="gridcell"> \
                <i class="material-icons mdc-chip__icon mdc-chip__icon--trailing" tabindex="-1" role="button">cancel</i> \
            </span> \
        </div>');
      return $elem;
    }
  }, {
    key: "createSnackbar",
    value: function createSnackbar(label) {
      var action = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      var link = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
      var timeout = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 4000;
      var elem = ' \
        <div class="mdc-snackbar"> \
            <div class="mdc-snackbar__surface" role="status" aria-relevant="additions"> \
                <div class="mdc-snackbar__label" aria-atomic="false"> \
                ' + label + ' \
                </div> \
                <div class="mdc-snackbar__actions" aria-atomic="true">';

      if (action.length) {
        elem += '\
                    <button type="button" class="mdc-button mdc-snackbar__action"> \
                        <div class="mdc-button__ripple"></div> \
                        <span class="mdc-button__label">' + action + '</span> \
                    </button>';
      }

      elem += '\
                    <button class="mdc-icon-button mdc-snackbar__dismiss material-icons" title="Dismiss">close</button> \
                </div> \
            </div> \
        </div>';
      var $elem = (0, _jqueryLib.$)(elem);
      var snackbar = new _snackbar.MDCSnackbar($elem[0]);
      snackbar.timeoutMs = timeout;
      snackbar.open();
      return $elem;
    }
  }, {
    key: "createSelect",
    value: function createSelect(id, label, values) {
      var selected = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var helper = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : '';
      var disabled = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : false;
      var $elem = (0, _jqueryLib.$)('\
        <div id="' + id + '" class="mdc-select mdc-select--filled ' + (label.length ? '' : 'mdc-select--no-label') + ' ' + (disabled ? 'mdc-select--disabled' : '') + '"> \
            <div class="mdc-select__anchor" role="button" tabindex="0"> \
                <span class="mdc-select__ripple"></span> \
                ' + (label.length ? '<span class="mdc-floating-label">' + label + '</span>' : '') + '\
                <span class="mdc-select__selected-text-container"> \
                    <span class="mdc-select__selected-text">' + selected + '</span> \
                </span> \
                <span class="mdc-select__dropdown-icon"> \
                    <svg class="mdc-select__dropdown-icon-graphic" viewBox="7 10 10 5"> \
                        <polygon class="mdc-select__dropdown-icon-inactive" stroke="none" fill-rule="evenodd" points="7 10 12 15 17 10"></polygon> \
                        <polygon class="mdc-select__dropdown-icon-active" stroke="none" fill-rule="evenodd" points="7 15 12 10 17 15"></polygon> \
                    </svg> \
                </span> \
                <span class="mdc-line-ripple"></span> \
            </div> \
            <div id="' + id + '_menu" tabindex="-1" class="mdc-select__menu mdc-menu mdc-menu-surface--fixed mdc-menu-surface" role="listbox"> \
                <input id="' + id + '_input" type="text" style="display: none" value="' + selected + '" /> \
                <ul id="' + id + '_menu_list" class="mdc-list"></ul> \
            </div> \
            <div class="mdc-text-field-helper-line"> \
                <div class="mdc-text-field-helper-text" aria-hidden="true" title="' + helper + '">' + helper + '</div> \
            </div> \
        </div>');
      var $list = $elem.find('ul.mdc-list'); // we recevied an object as param (map)

      if (!Array.isArray(values)) {
        for (var key in values) {
          var $line = (0, _jqueryLib.$)(' \
                <li id="' + id + '_menu_list-' + key + '" class="mdc-list-item" role="option" data-value="' + key + '"> \
                    <span class="mdc-list-item__ripple"></span> \
                    <span class="mdc-list-item__text">' + values[key] + '</span> \
                </li>');

          if (key == selected) {
            $line.addClass('mdc-list-item--selected').attr('aria-selected', 'true');
          }

          $list.append($line);
        }
      } // we received an array
      else {
          var _iterator = _createForOfIteratorHelper(values),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var value = _step.value;

              var _$line = (0, _jqueryLib.$)(' \
                <li class="mdc-list-item" tabindex="-1" role="option" data-value="' + value + '"> \
                    <span class="mdc-list-item__ripple"></span> \
                    <span class="mdc-list-item__text">' + value + '</span> \
                </li>');

              if (value == selected) {
                _$line.addClass('mdc-list-item--selected').attr('aria-selected', 'true');
              }

              $list.append(_$line);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }

      var select = new _select.MDCSelect($elem[0]); // make the element behave like an `input` element

      select.listen('MDCSelect:change', function () {
        $elem.find('input').val(select.value).trigger('change');
      });
      $elem.on('select', function (event, value) {
        select.value = value;
      }); // workaround for --fixed style width (mandatory to display list above inputs as sub-items)

      $elem.on('click', function () {
        $elem.find('.mdc-menu-surface').width($elem.width());
      });
      return $elem;
    }
  }, {
    key: "createList",
    value: function createList(id) {
      var label = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      var values = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
      var $elem = (0, _jqueryLib.$)('<ul id="' + id + '" tabindex="-1" role="menu" class="mdc-list"></ul>');
      return $elem;
    }
  }, {
    key: "createMenu",
    value: function createMenu(id) {
      var label = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
      var values = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
      var $elem = (0, _jqueryLib.$)('<div id="' + id + '" tabindex="-1" class="sb-ui-menu mdc-menu mdc-menu-surface mdc-menu-surface--fixed"></div>');
      return $elem;
    }
  }, {
    key: "createTabBar",
    value: function createTabBar(id, label, value) {
      var $elem = (0, _jqueryLib.$)('\
        <div id="' + id + '" class="mdc-tab-bar" role="tablist"> \
            <div class="mdc-tab-scroller"> \
            <div class="mdc-tab-scroller__scroll-area"> \
                <div class="sb-view-form-sections mdc-tab-scroller__scroll-content"> \
                </div> \
            </div> \
            </div> \
        </div>');
      return $elem;
    }
  }, {
    key: "createTabButton",
    value: function createTabButton(id, label, active) {
      var $elem = (0, _jqueryLib.$)('\
        <button id="' + id + '" class="mdc-tab ' + (active ? 'mdc-tab--active' : '') + '" role="tab" tabindex="0"> \
            <span class="mdc-tab__content"> \
                <span class="mdc-tab__text-label">' + label + '</span> \
            </span> \
            <span class="mdc-tab-indicator ' + (active ? 'mdc-tab-indicator--active' : '') + '"> \
                <span class="mdc-tab-indicator__content mdc-tab-indicator__content--underline"></span> \
            </span> \
            <span class="mdc-tab__ripple"></span> \
        </button>');
      return $elem;
    }
  }, {
    key: "createPagination",
    value: function createPagination() {
      var $elem = (0, _jqueryLib.$)(' \
        <div class="mdc-data-table__pagination"> \
            <div class="pagination-container mdc-data-table__pagination-trailing"> \
                <div class="pagination-rows-per-page mdc-data-table__pagination-rows-per-page"></div> \
                <div class="pagination-navigation mdc-data-table__pagination-navigation"> \
                    <div class="pagination-total mdc-data-table__pagination-total"></div> \
                </div> \
            </div> \
        </div>');
      return $elem;
    }
  }, {
    key: "createPaginationSelect",
    value: function createPaginationSelect(id, label, values) {
      var selected = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
      var $elem = UIHelper.createSelect(id, label, values, selected);
      $elem.addClass('mdc-data-table__pagination-rows-per-page-select');
      return $elem;
    }
  }, {
    key: "createDialog",
    value: function createDialog(id, title) {
      var label_accept = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'Ok';
      var label_cancel = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'Cancel';
      var $elem = (0, _jqueryLib.$)('\
        <div class="mdc-dialog" id="' + id + '"> \
            <div class="mdc-dialog__container"> \
                <div class="mdc-dialog__surface" role="alertdialog" aria-modal="true" style="overflow: hidden"> \
                    <h2 class="mdc-dialog__title">' + title + '</h2> \
                    <div class="mdc-dialog__content"></div> \
                    <div class="mdc-dialog__actions"> \
                        <button tabindex="0" type="button" class="mdc-button mdc-dialog__button" data-mdc-dialog-action="cancel"> \
                            <div class="mdc-button__ripple"></div> \
                            <span class="mdc-button__label">' + label_cancel + '</span> \
                        </button> \
                        <button tabindex="0" type="button" class="mdc-button mdc-dialog__button" data-mdc-dialog-action="accept"> \
                            <div class="mdc-button__ripple"></div> \
                            <span class="mdc-button__label">' + label_accept + '</span> \
                        </button> \
                    </div> \
                </div> \
            </div> \
            <div class="mdc-dialog__scrim"></div> \
        </div');
      var dialog = new _dialog.MDCDialog($elem[0]);
      dialog.listen('MDCDialog:opened', function () {
        dialog.layout();
        $elem.find('button[tabindex=0]').focus();
      });
      dialog.listen('MDCDialog:closed', function (event) {
        if (event.detail.action == 'accept') {
          $elem.trigger('_accept');
        }

        if (event.detail.action == 'reject') {
          $elem.trigger('_reject');
        }
      });
      $elem.on('_open', function () {
        dialog.open();
      });
      return $elem;
    }
    /*
     Decorators
     Some widgets need to be injected in DOM document before running MDC methods on them.
    */

  }, {
    key: "decorateMenu",
    value: function decorateMenu($elem) {
      if (!$elem.length) return;
      var fields_toggle_menu = new _menu.MDCMenu($elem[0]); // prevent menu from getting the focus

      fields_toggle_menu.setDefaultFocusState(_menu.DefaultFocusState.NONE); // UI elements having a menu rely on this custom _toggle

      $elem.on('_toggle', function () {
        fields_toggle_menu.open = !$elem.hasClass('mdc-menu-surface--open');
      });
      $elem.on('_open', function (event) {
        console.debug('MDCMenu _open');
        event.stopPropagation();

        if (!fields_toggle_menu.open) {
          fields_toggle_menu.open = true;
          fields_toggle_menu.selectedIndex = 0; // prevent tab capture

          $elem.find('.mdc-list-item').attr('tabindex', -1);
        }
      });
      $elem.on('_close', function (event) {
        console.debug('MDCMenu _close'); // event.stopPropagation();
        // fields_toggle_menu.open = false;
      });
      $elem.on('_moveup', function (event) {
        event.stopPropagation();
        var index = fields_toggle_menu.selectedIndex;
        fields_toggle_menu.selectedIndex = index > 0 ? index - 1 : 0; // prevent tab capture

        $elem.find('.mdc-list-item').attr('tabindex', -1);
      });
      $elem.on('_movedown', function (event) {
        event.stopPropagation();
        var index = fields_toggle_menu.selectedIndex;
        fields_toggle_menu.selectedIndex = index + 1; // prevent tab capture

        $elem.find('.mdc-list-item').attr('tabindex', -1);
      });
      $elem.on('_select', function (event) {
        event.stopPropagation();
        $elem.find('.mdc-list-item--selected').trigger('click');
      });
    }
  }, {
    key: "decorateTabBar",
    value: function decorateTabBar($elem) {
      if (!$elem.length) return;
      new _tabBar.MDCTabBar($elem[0]);
    }
  }, {
    key: "decorateTooltip",
    value: function decorateTooltip($elem) {
      if (!$elem.length) return;
      new _tooltip.MDCTooltip($elem[0]);
    }
  }, {
    key: "decorateTableStatic",
    value: function decorateTableStatic($elem) {
      if (!$elem.length) return;
      $elem.addClass('mdc-data-table').children().first().addClass('mdc-data-table__table-container');
      var $thead = $elem.find('thead');
      var $table = $elem.find('table').addClass('mdc-data-table__table');
      var $tbody = $table.find('tbody').addClass('mdc-data-table__content');
      $thead.find('th').addClass('mdc-data-table__header-cell');
      $tbody.find('td').addClass('mdc-data-table__cell');
    }
  }, {
    key: "decorateTable",
    value: function decorateTable($elem) {
      if (!$elem.length) return;
      $elem.addClass('mdc-data-table').children().first().addClass('mdc-data-table__table-container');
      var $thead = $elem.find('thead');
      var $table = $elem.find('table').addClass('mdc-data-table__table');
      var $tbody = $table.find('tbody').addClass('mdc-data-table__content');
      $thead.find('th').addClass('mdc-data-table__header-cell');
      $tbody.find('td').addClass('mdc-data-table__cell');
      /*
       handler for click on header checkbox
      */

      $thead.find('th:first-child').find('input[type="checkbox"]:not([data-decorated])').attr('data-decorated', '1').on('change', function (event) {
        var $this = (0, _jqueryLib.$)(event.currentTarget); // tbody might

        var $tbody = $table.find('tbody');

        if ($this.prop('checked')) {
          $tbody.find('td:first-child').find('input[type="checkbox"]').prop('checked', true).prop('indeterminate', false);
          $tbody.find('tbody').find('tr').addClass('mdc-data-table__row--selected');
        } else {
          $tbody.find('td:first-child').find('input[type="checkbox"]').prop('checked', false).prop('indeterminate', false);
          $tbody.find('tr').removeClass('mdc-data-table__row--selected');
        }
      }).on('refresh', function (event) {
        var $tbody = $table.find('tbody');
        var rows_count = $tbody.find('tr').length;
        var selection_count = 0;
        (0, _jqueryLib.$)('td:first-child', $tbody).each(function (i, elem) {
          selection_count += +(0, _jqueryLib.$)('input[type="checkbox"]', elem).prop('checked');
        });

        if (selection_count == rows_count && rows_count) {
          $thead.find('th:first-child').find('input').prop("indeterminate", false).prop("checked", true);
        } else if (selection_count) {
          $thead.find('th:first-child').find('input').prop("indeterminate", true).prop("checked", false);
        } else {
          $thead.find('th:first-child').find('input').prop("indeterminate", false).prop("checked", false);
        }
      });
      /*
       handler for click on rows checkboxes
      */

      $tbody.find('td:first-child').find('input[type="checkbox"]:not([data-decorated]').attr('data-decorated', '1').on('change', function (event) {
        var $this = (0, _jqueryLib.$)(event.currentTarget);
        var $tbody = $table.find('tbody');
        var rows_count = $tbody.find('tr').length;
        var selection_count = 0;
        (0, _jqueryLib.$)('td:first-child', $tbody).each(function (i, elem) {
          selection_count += +(0, _jqueryLib.$)('input[type="checkbox"]', elem).prop('checked');
        });

        if ($this.prop('checked')) {
          $tbody.find('tbody').find('tr').addClass('mdc-data-table__row--selected'); // all checkboxes checked ?

          if (selection_count == rows_count) {
            $thead.find('th:first-child').find('input').prop("indeterminate", false).prop("checked", true);
          } else {
            $thead.find('th:first-child').find('input').prop("indeterminate", true).prop("checked", false);
          }
        } else {
          $this.closest('tr').removeClass('mdc-data-table__row--selected'); // none of the checkboxes checked ?

          if (selection_count == 0) {
            $thead.find('th:first-child').find('input').prop("indeterminate", false).prop("checked", false);
          } else {
            $thead.find('th:first-child').find('input').prop("indeterminate", true).prop("checked", false);
          }
        }

        return true;
      });
      /*
       handlers for column sorting
      */

      $thead.find('th:not([data-decorated]').attr('data-decorated', '1').hover(function (event) {
        // set hover and sort order indicator
        var $this = (0, _jqueryLib.$)(event.currentTarget);
        $this.addClass('hover');

        if ($this.hasClass('sortable')) {
          if ($this.hasClass('sorted')) {
            if ($this.hasClass('asc')) {
              $this.removeClass('asc').addClass('desc');
            } else {
              $this.removeClass('desc').addClass('asc');
            }
          } else {
            $this.addClass('asc');
          }
        }
      }, function (event) {
        // unset hover and sort order indicator
        var $this = (0, _jqueryLib.$)(event.currentTarget);
        $this.removeClass('hover');

        if ($this.hasClass('sortable')) {
          if ($this.hasClass('sorted')) {
            if ($this.hasClass('asc')) {
              $this.removeClass('asc').addClass('desc');
            } else {
              $this.removeClass('desc').addClass('asc');
            }
          } else {
            $this.removeClass('asc');
          }
        }
      }).on('click', function (event) {
        var $this = (0, _jqueryLib.$)(event.currentTarget); // change sortname and/or sortorder

        if ($this.hasClass('sortable')) {
          // set order according to column field
          if (!$this.hasClass('sorted')) {
            var sort = $this.attr('data-sort').length ? $this.attr('data-sort') : 'asc';
            $this.removeClass('sorted').removeClass('asc').removeClass('desc');
            $this.addClass('sorted').addClass(sort);
            $this.attr('data-sort', sort);
          } // toggle sorting order
          else {
              var _sort = $this.attr('data-sort');

              if (_sort == 'asc') {
                $this.removeClass('asc').addClass('desc');
                _sort = 'desc';
              } else {
                $this.removeClass('desc').addClass('asc');
                _sort = 'asc';
              }

              $this.attr('data-sort', _sort);
            }
        }
      }); // new MDCDataTable($elem);
    }
  }]);
  return UIHelper;
}();

exports.UIHelper = UIHelper;

/***/ }),

/***/ "./build/widgets/Widget.js":
/*!*********************************!*\
  !*** ./build/widgets/Widget.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var Widget = /*#__PURE__*/function () {
  function Widget(layout, type, label, value, config) {
    (0, _classCallCheck2.default)(this, Widget);
    (0, _defineProperty2.default)(this, "layout", void 0);
    (0, _defineProperty2.default)(this, "$elem", void 0);
    (0, _defineProperty2.default)(this, "value", void 0);
    (0, _defineProperty2.default)(this, "label", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "is_first", void 0);
    (0, _defineProperty2.default)(this, "mode", '');
    (0, _defineProperty2.default)(this, "id", '');
    (0, _defineProperty2.default)(this, "readonly", false);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.layout = layout;
    this.is_first = false;
    this.value = value;
    this.label = label;
    this.type = type;
    this.config = config; // assign default mode

    this.mode = 'view';
    this.$elem = $();

    var S4 = function S4() {
      return ((1 + Math.random()) * 0x10000 | 0).toString(16).substring(1);
    }; // generate a random guid


    this.id = S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4();
  }

  (0, _createClass2.default)(Widget, [{
    key: "getLayout",
    value: function getLayout() {
      return this.layout;
    }
  }, {
    key: "getId",
    value: function getId() {
      return this.id;
    }
  }, {
    key: "getElement",
    value: function getElement() {
      return this.$elem;
    }
  }, {
    key: "getValue",
    value: function getValue() {
      return this.value;
    }
  }, {
    key: "getLabel",
    value: function getLabel() {
      return this.label;
    }
  }, {
    key: "getType",
    value: function getType() {
      return this.type;
    }
  }, {
    key: "getMode",
    value: function getMode() {
      return this.mode;
    }
  }, {
    key: "getConfig",
    value: function getConfig() {
      return this.config;
    }
  }, {
    key: "setIsFirst",
    value: function setIsFirst(is_first) {
      this.is_first = is_first;
    }
  }, {
    key: "setValue",
    value: function setValue(value) {
      this.value = value;
      return this;
    }
  }, {
    key: "setLabel",
    value: function setLabel(label) {
      this.label = label;
      return this;
    }
  }, {
    key: "setType",
    value: function setType(type) {
      this.type = type;
      return this;
    }
  }, {
    key: "setMode",
    value: function setMode(mode) {
      this.mode = mode;
      return this;
    }
  }, {
    key: "setReadonly",
    value: function setReadonly(readonly) {
      this.readonly = readonly;
      return this;
    }
  }, {
    key: "setConfig",
    value: function setConfig(config) {
      this.config = config;
      return this;
    }
    /**
     *
     * This method is called by LayoutList for setting a widget with bulk assign.
     * @param value
     */

  }, {
    key: "change",
    value: function change(value) {
      this.setValue(value);
    }
    /**
     * @return always returns a JQuery object
     */

  }, {
    key: "render",
    value: function render() {
      return this.$elem;
    }
  }, {
    key: "attach",
    value: function attach() {
      this.$elem = $('<div/>').addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
      return this.$elem;
    }
  }]);
  return Widget;
}();

exports.default = Widget;

/***/ }),

/***/ "./build/widgets/WidgetBoolean.js":
/*!****************************************!*\
  !*** ./build/widgets/WidgetBoolean.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetBoolean = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetBoolean, _Widget);

  var _super = _createSuper(WidgetBoolean);

  function WidgetBoolean(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetBoolean);
    return _super.call(this, layout, 'boolean', label, value, config);
  }

  (0, _createClass2.default)(WidgetBoolean, [{
    key: "change",
    value: function change(value) {
      this.$elem.find('input').val(value).trigger('change');
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      switch (this.mode) {
        case 'edit':
          this.$elem = _materialLib.UIHelper.createSwitch('bool_' + this.id, this.label, this.value, this.config.description, '', this.readonly); // setup handler for relaying value update to parent layout

          this.$elem.find('input').on('change', function (event) {
            var $this = $(event.currentTarget);
            _this.value = $this.prop("checked");

            _this.$elem.trigger('_updatedWidget');
          });
          break;

        case 'view':
        default:
          /*
          let value:string = (this.value)?'true':'false';
          $elem = UIHelper.createInputView('', this.label, value);
          */
          this.$elem = _materialLib.UIHelper.createSwitch('', this.label, this.value, this.config.description, '', true);
          break;
      }

      return this.$elem.addClass('sb-widget').addClass('sb-widget-type-boolean').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
    }
  }]);
  return WidgetBoolean;
}(_Widget2.default);

exports.default = WidgetBoolean;

/***/ }),

/***/ "./build/widgets/WidgetDashboardItem.js":
/*!**********************************************!*\
  !*** ./build/widgets/WidgetDashboardItem.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WidgetDashboardItem = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _equalLib = __webpack_require__(/*! ../equal-lib */ "./build/equal-lib.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetDashboardItem = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetDashboardItem, _Widget);

  var _super = _createSuper(WidgetDashboardItem);

  function WidgetDashboardItem(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetDashboardItem);
    return _super.call(this, layout, 'dashboarditem', label, value, config);
  }

  (0, _createClass2.default)(WidgetDashboardItem, [{
    key: "render",
    value: function render() {
      var _this = this;

      this.$elem = $('<div />');
      var view = new _equalLib.View(this.getLayout().getView().getContext(), this.config.entity, this.config.view_type, this.config.view_name, this.config.domain, this.mode, 'widget', this.getLayout().getView().getLang(), this.config);
      view.isReady().then(function () {
        var $container = view.getContainer(); // inject View in parent Context object

        _this.$elem.append($container);
      });
      this.$elem.addClass('sb-widget').attr('id', this.getId()).css('height', '100%');
      return this.$elem;
    }
  }]);
  return WidgetDashboardItem;
}(_Widget2.default);

exports.WidgetDashboardItem = WidgetDashboardItem;

/***/ }),

/***/ "./build/widgets/WidgetDate.js":
/*!*************************************!*\
  !*** ./build/widgets/WidgetDate.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _moment = _interopRequireDefault(__webpack_require__(/*! moment/moment.js */ "./node_modules/moment/moment.js"));

var _jqueryLib = __webpack_require__(/*! ../jquery-lib */ "./build/jquery-lib.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetDate = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetDate, _Widget);

  var _super = _createSuper(WidgetDate);

  function WidgetDate(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetDate);
    return _super.call(this, layout, 'date', label, value, config);
  }

  (0, _createClass2.default)(WidgetDate, [{
    key: "change",
    value: function change(value) {
      this.$elem.find('input').datepicker('setDate', value).trigger('change');
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var date = new Date(this.value);
      var value;

      switch (this.mode) {
        case 'edit':
          value = (0, _moment.default)(date).format('L');
          this.$elem = _materialLib.UIHelper.createInput('date_' + this.id, this.label, value, this.config.description, 'calendar_today', this.readonly);

          if (this.config.layout == 'list') {
            this.$elem.css({
              "width": "calc(100% - 10px)"
            });
          } // setup handler for relaying value update to parent layout


          this.$elem.find('input').datepicker(_objectSpread(_objectSpread({
            showOn: "button"
          }, _jqueryLib.jqlocale[this.getLayout().getEnv().locale]), {}, {
            onClose: function onClose() {
              // give the focus back once the widget will have been refreshed
              setTimeout(function () {
                (0, _jqueryLib.$)('#' + _this.getId()).find('input').first().trigger('focus');
              }, 250);
            }
          })).on('change', function (event) {
            // update widget value using jQuery `getDate`
            var $this = (0, _jqueryLib.$)(event.currentTarget);
            var date = $this.datepicker('getDate');
            _this.value = date.toISOString();

            _this.$elem.trigger('_updatedWidget');
          });
          this.$elem.find('button').attr('tabindex', -1);
          break;

        case 'view':
        default:
          value = this.value ? (0, _moment.default)(date).format('ll') : '';
          this.$elem = _materialLib.UIHelper.createInputView('', this.label, value, this.config.description);
          break;
      }

      if (this.config.hasOwnProperty('heading') && this.config.layout == 'form') {
        this.$elem.addClass('title');
      }

      return this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
    }
  }]);
  return WidgetDate;
}(_Widget2.default);

exports.default = WidgetDate;

/***/ }),

/***/ "./build/widgets/WidgetDateTime.js":
/*!*****************************************!*\
  !*** ./build/widgets/WidgetDateTime.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _moment = _interopRequireDefault(__webpack_require__(/*! moment/moment.js */ "./node_modules/moment/moment.js"));

var _jqueryLib = __webpack_require__(/*! ../jquery-lib */ "./build/jquery-lib.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetDateTime = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetDateTime, _Widget);

  var _super = _createSuper(WidgetDateTime);

  function WidgetDateTime(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetDateTime);
    return _super.call(this, layout, 'date', label, value, config);
  }

  (0, _createClass2.default)(WidgetDateTime, [{
    key: "change",
    value: function change(value) {
      this.$elem.find('input').val(value).trigger('change');
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var date = new Date(this.value);
      var value;
      var format = 'LLL';

      switch (this.mode) {
        case 'edit':
          format = _moment.default.localeData().longDateFormat('L') + ' ' + _moment.default.localeData().longDateFormat('LT');
          value = (0, _moment.default)(date).format(format);
          this.$elem = _materialLib.UIHelper.createInput('date_' + this.id, this.label, value, this.config.description, 'calendar_today', this.readonly); // setup handler for relaying value update to parent layout

          if (this.config.layout == 'list') {
            this.$elem.css({
              "width": "calc(100% - 10px)"
            });
          }

          this.$elem.find('input').on('keypress', function (event) {
            if (event.which == 9) {
              // #todo: force focus to the next input
              event.preventDefault();
            }
          }).on('change', function (event) {
            var $this = (0, _jqueryLib.$)(event.currentTarget);
            _this.value = $this.val();
            var mdate = (0, _moment.default)(_this.value, format, true);

            if (mdate.isValid()) {
              date = mdate.toDate();
              $datetimepicker.datepicker('setDateTime', date);
            }
          });
          var $datetimepicker = (0, _jqueryLib.$)('<input type="text" />').addClass('sb-view-layout-form-input-decoy').datepicker(_objectSpread(_objectSpread({
            datetime: true,
            twentyFour: true,
            showSeconds: false
          }, _jqueryLib.jqlocale[this.getLayout().getEnv().locale]), {}, {
            onClose: function onClose() {
              var date = $datetimepicker.datepicker('getDate');
              _this.value = date.toISOString();

              _this.$elem.trigger('_updatedWidget'); // give the focus back once the widget will have been refreshed


              setTimeout(function () {
                (0, _jqueryLib.$)('#' + _this.getId()).find('input').first().trigger('focus');
              }, 250);
            }
          })).on('change', function (event) {
            // update widget value using jQuery `getDate`
            var $this = (0, _jqueryLib.$)(event.currentTarget);
            var new_date = $this.datepicker('getDate'); // $elem.trigger('_updatedWidget', date.toISOString());

            _this.$elem.find('input').val((0, _moment.default)(new_date).format(format));
          });
          this.$elem.append($datetimepicker);
          this.$elem.append((0, _jqueryLib.$)('<div />').addClass('sb-view-layout-form-input-button').one('click', function () {
            $datetimepicker.datepicker('setDateTime', date);
          }).on('click', function () {
            $datetimepicker.datepicker('show');
          }));
          break;

        case 'view':
        default:
          if (this.config.hasOwnProperty('usage')) {
            if (this.config.usage == 'datetime/short') {
              format = (_moment.default.localeData().longDateFormat('L') + ' ' + _moment.default.localeData().longDateFormat('LT')).replace(/YYYY/g, 'YY');
            }

            if (this.config.usage == 'datetime/full') {
              format = 'LLLL';
            }
          }

          value = (0, _moment.default)(date).format(format);
          this.$elem = _materialLib.UIHelper.createInputView('', this.label, value, this.config.description);
          break;
      }

      if (this.config.hasOwnProperty('heading') && this.config.layout == 'form') {
        this.$elem.addClass('title');
      }

      return this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
    }
  }]);
  return WidgetDateTime;
}(_Widget2.default);

exports.default = WidgetDateTime;

/***/ }),

/***/ "./build/widgets/WidgetFile.js":
/*!*************************************!*\
  !*** ./build/widgets/WidgetFile.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetFile = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetFile, _Widget);

  var _super = _createSuper(WidgetFile);

  function WidgetFile(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetFile);
    return _super.call(this, layout, 'file', label, value, config);
  }

  (0, _createClass2.default)(WidgetFile, [{
    key: "change",
    value: function change(value) {// this.$elem.find('input').val(value).trigger('change');
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var value = typeof this.value != undefined && this.value != undefined ? this.value : '';

      var $button_open = _materialLib.UIHelper.createButton('link-actions-open-' + this.id, '', 'icon', 'open_in_new'); // open target in new window


      $button_open.on('click', /*#__PURE__*/function () {
        var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(event) {
          var w;
          return _regenerator.default.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  event.stopPropagation();

                  if (window) {
                    w = window.open(value, '_blank');

                    if (w) {
                      w.focus();
                    }
                  }

                case 2:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));

        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
      this.$elem = $('<div />');

      switch (this.mode) {
        case 'edit':
          this.$elem.css({
            "display": "flex",
            "align-items": "center"
          });
          var $input = $('<input type="file" />').hide();

          var $button = _materialLib.UIHelper.createButton(this.getId() + '_upload-button', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_SELECT'), 'raised', '', 'primary').css({
            "margin-left": "10px"
          });

          var $text = _materialLib.UIHelper.createInputView('', this.label, '', this.config.description);

          $text.on('click', function () {
            return $input.trigger('click');
          });
          $button.on('click', function () {
            return $input.trigger('click');
          });
          $input.on('change', /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(event) {
              var val, filename;
              return _regenerator.default.wrap(function _callee2$(_context2) {
                while (1) {
                  switch (_context2.prev = _context2.next) {
                    case 0:
                      val = $input.val();
                      _context2.next = 3;
                      return function (blob) {
                        var defer = $.Deferred();
                        var reader = new FileReader();

                        reader.onload = function (e) {
                          defer.resolve(e.target.result);
                        };

                        reader.readAsDataURL(blob);
                        return defer.promise();
                      }($input.prop('files')[0]);

                    case 3:
                      _this.value = _context2.sent;

                      _this.$elem.trigger('_updatedWidget', [false]);

                      filename = val.split('\\').pop();
                      $text.remove();
                      $text = _materialLib.UIHelper.createInputView('', _this.label, filename, _this.config.description);

                      _this.$elem.prepend($text);

                    case 9:
                    case "end":
                      return _context2.stop();
                  }
                }
              }, _callee2);
            }));

            return function (_x2) {
              return _ref2.apply(this, arguments);
            };
          }());
          this.$elem.append($text).append($button).append($input);
          break;

        case 'view':
        default:
          this.$elem.append('[binary data]');
          break;
      }

      return this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
    }
  }]);
  return WidgetFile;
}(_Widget2.default);

exports.default = WidgetFile;

/***/ }),

/***/ "./build/widgets/WidgetFloat.js":
/*!**************************************!*\
  !*** ./build/widgets/WidgetFloat.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "./node_modules/@babel/runtime/helpers/get.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _WidgetString2 = _interopRequireDefault(__webpack_require__(/*! ./WidgetString */ "./build/widgets/WidgetString.js"));

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetFloat = /*#__PURE__*/function (_WidgetString) {
  (0, _inherits2.default)(WidgetFloat, _WidgetString);

  var _super = _createSuper(WidgetFloat);

  function WidgetFloat(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetFloat);
    return _super.call(this, layout, label, value, config);
  }

  (0, _createClass2.default)(WidgetFloat, [{
    key: "setValue",
    value: function setValue(value) {
      var res = Number.parseFloat(value);
      this.value = isNaN(res) ? 0 : res;
      return this;
    }
  }, {
    key: "render",
    value: function render() {
      this.$elem = (0, _get2.default)((0, _getPrototypeOf2.default)(WidgetFloat.prototype), "render", this).call(this);
      var $input = this.$elem.find('input'); // numeric fields are aligned right

      $input.css({
        'text-align': 'right'
      });

      if (this.mode == 'edit') {
        $input.attr("type", "number");
      } else if (this.mode == 'view') {
        // in view mode, display 2 decimal digits
        var value = this.value;

        if (this.config.hasOwnProperty('usage')) {
          var usage = this.config.usage;

          if (usage.indexOf('amount/percent') >= 0 || usage.indexOf('amount/rate') >= 0) {
            value = (value * 100).toFixed(0) + '%';
          } else if (usage.indexOf('amount/money') >= 0) {
            value = _equalServices.EnvService.formatCurrency(value);
          }
        } else {
          value = _equalServices.EnvService.formatNumber(value);
        } // for lists, item is a DIV


        if (this.config.layout == 'list') {
          this.$elem.html(value);
          this.$elem.css({
            "text-align": "right",
            "white-space": "nowrap"
          });
        } else {
          $input.val(value);
        }
      }

      return this.$elem;
    }
  }]);
  return WidgetFloat;
}(_WidgetString2.default);

exports.default = WidgetFloat;

/***/ }),

/***/ "./build/widgets/WidgetImage.js":
/*!**************************************!*\
  !*** ./build/widgets/WidgetImage.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetImage = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetImage, _Widget);

  var _super = _createSuper(WidgetImage);

  function WidgetImage(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetImage);
    return _super.call(this, layout, 'file', label, value, config);
  }

  (0, _createClass2.default)(WidgetImage, [{
    key: "change",
    value: function change(value) {// this.$elem.find('input').val(value).trigger('change');
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var value = typeof this.value != undefined && this.value != undefined ? this.value : '';

      var $button_open = _materialLib.UIHelper.createButton('link-actions-open-' + this.id, '', 'icon', 'open_in_new'); // open target in new window


      $button_open.on('click', /*#__PURE__*/function () {
        var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(event) {
          var w;
          return _regenerator.default.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  event.stopPropagation();

                  if (window) {
                    w = window.open(value, '_blank');

                    if (w) {
                      w.focus();
                    }
                  }

                case 2:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));

        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());
      var content_type = this.config.hasOwnProperty('usage') ? this.config.usage : 'image/jpeg';
      this.$elem = $('<div />').addClass('sb-image-thumbnail');

      switch (this.mode) {
        case 'edit':
          this.$elem.addClass('sb-dropable');
          this.$elem.css({
            'background-image': 'url(' + 'data:' + content_type + ';base64,' + value + ')'
          });
          var upqueue = [];

          if (window.File && window.FileReader && window.FileList && window.Blob) {
            window.addEventListener("dragover", function (e) {
              return e.preventDefault();
            }); // window.addEventListener("drop", (e) => e.preventDefault() );

            this.$elem.on("dragenter", function (event) {
              event.preventDefault();
              event.stopPropagation();

              _this.$elem.addClass("highlight");
            });
            this.$elem.on("dragleave", function (event) {
              event.preventDefault();
              event.stopPropagation();

              _this.$elem.removeClass("highlight");
            });
            this.$elem.on("dragover", function (event) {
              event.preventDefault();
              event.stopPropagation();
            });
            this.$elem[0].addEventListener("drop", /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2(event) {
                var file, _value;

                return _regenerator.default.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        event.preventDefault();
                        event.stopPropagation();

                        _this.$elem.removeClass("highlight");

                        if (!(event.dataTransfer && event.dataTransfer.files && event.dataTransfer.files.length)) {
                          _context2.next = 10;
                          break;
                        }

                        // we want to store the data inside the Model field
                        file = event.dataTransfer.files[0];
                        _context2.next = 7;
                        return function (blob) {
                          var defer = $.Deferred();
                          var reader = new FileReader();

                          reader.onload = function (e) {
                            defer.resolve(e.target.result);
                          };

                          reader.readAsDataURL(blob);
                          return defer.promise();
                        }(file);

                      case 7:
                        _value = _context2.sent;
                        _this.value = _value;

                        _this.$elem.trigger('_updatedWidget', [false]);

                      case 10:
                      case "end":
                        return _context2.stop();
                    }
                  }
                }, _callee2);
              }));

              return function (_x2) {
                return _ref2.apply(this, arguments);
              };
            }());
          }

          break;

        case 'view':
        default:
          this.$elem.css({
            'background-image': 'url(' + 'data:' + content_type + ';base64,' + value + ')'
          });
          break;
      }

      return this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
    }
  }]);
  return WidgetImage;
}(_Widget2.default);

exports.default = WidgetImage;

/***/ }),

/***/ "./build/widgets/WidgetInteger.js":
/*!****************************************!*\
  !*** ./build/widgets/WidgetInteger.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _get2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/get */ "./node_modules/@babel/runtime/helpers/get.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _WidgetString2 = _interopRequireDefault(__webpack_require__(/*! ./WidgetString */ "./build/widgets/WidgetString.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetInteger = /*#__PURE__*/function (_WidgetString) {
  (0, _inherits2.default)(WidgetInteger, _WidgetString);

  var _super = _createSuper(WidgetInteger);

  function WidgetInteger(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetInteger);
    return _super.call(this, layout, label, value, config);
  }

  (0, _createClass2.default)(WidgetInteger, [{
    key: "render",
    value: function render() {
      this.$elem = (0, _get2.default)((0, _getPrototypeOf2.default)(WidgetInteger.prototype), "render", this).call(this);
      var $input = this.$elem.find('input'); // numeric fields are aligned right (except for `id` column)

      if (this.config.field != 'id') {
        $input.css({
          'text-align': 'right'
        });
      }

      if (this.mode == 'edit') {
        $input.attr("type", "number");

        if (this.config.hasOwnProperty('min')) {
          $input.attr("min", this.config.min);
        }

        if (this.config.hasOwnProperty('max')) {
          $input.attr("max", this.config.max);
        }
      } else if (this.mode == 'view') {
        // for lists, item is a DIV
        if (this.config.field != 'id' && this.config.layout == 'list') {
          this.$elem.css({
            'text-align': 'right'
          });
        }
      }

      return this.$elem;
    }
  }]);
  return WidgetInteger;
}(_WidgetString2.default);

exports.default = WidgetInteger;

/***/ }),

/***/ "./build/widgets/WidgetLabel.js":
/*!**************************************!*\
  !*** ./build/widgets/WidgetLabel.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetLabel = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetLabel, _Widget);

  var _super = _createSuper(WidgetLabel);

  function WidgetLabel(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetLabel);
    return _super.call(this, layout, 'string', label, value, config);
  }

  (0, _createClass2.default)(WidgetLabel, [{
    key: "render",
    value: function render() {
      var value = typeof this.value != undefined && this.value != undefined ? this.value : '';

      if (typeof value == 'string') {
        value = value.replace(/"/g, "&quot;");
      }

      this.$elem = $('<span style="font-weight: 600;">' + value + '</span>');
      return this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
    }
  }]);
  return WidgetLabel;
}(_Widget2.default);

exports.default = WidgetLabel;

/***/ }),

/***/ "./build/widgets/WidgetLink.js":
/*!*************************************!*\
  !*** ./build/widgets/WidgetLink.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetLink = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetLink, _Widget);

  var _super = _createSuper(WidgetLink);

  function WidgetLink(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetLink);
    return _super.call(this, layout, 'string', label, value, config);
  }

  (0, _createClass2.default)(WidgetLink, [{
    key: "change",
    value: function change(value) {
      this.$elem.find('input').val(value).trigger('change');
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var value = typeof this.value != undefined && this.value != undefined ? this.value : '';

      var $button_open = _materialLib.UIHelper.createButton('link-actions-open-' + this.id, '', 'icon', 'open_in_new'); // open target in new window


      $button_open.on('click', /*#__PURE__*/function () {
        var _ref = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee(event) {
          var w;
          return _regenerator.default.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  event.stopPropagation();

                  if (window) {
                    w = window.open(value, '_blank');

                    if (w) {
                      w.focus();
                    }
                  }

                case 2:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));

        return function (_x) {
          return _ref.apply(this, arguments);
        };
      }());

      switch (this.mode) {
        case 'edit':
          if (this.config.layout == 'list') {
            this.$elem = _materialLib.UIHelper.createInput('', this.label, value, this.config.description, '', this.readonly);
            this.$elem.css({
              "width": "calc(100% - 10px)"
            });
          } else {
            this.$elem = $('<div />');

            var $input = _materialLib.UIHelper.createInput('', this.label, value, this.config.description, '', this.readonly).css({
              "width": "calc(100% - 48px)",
              "display": "inline-block"
            });

            this.$elem.append($input).append($button_open);
          } // setup handler for relaying value update to parent layout


          this.$elem.find('input').on('change', function (event) {
            var $this = $(event.currentTarget);
            _this.value = $this.val();

            if (_this.value != value) {
              _this.$elem.trigger('_updatedWidget', [false]);
            }
          });
          break;

        case 'view':
        default:
          this.$elem = $('<div />');

          if (this.config.layout == 'list') {
            var $link = $('<a target="_blank" href="' + value + '">' + value + '</a>');
            $link.on('click', function (event) {
              event.stopPropagation();
            });
            this.$elem.append($link);
          } else {
            var _$input = _materialLib.UIHelper.createInputView('', this.label, value, this.config.description).css({
              "width": "calc(100% - 48px)",
              "display": "inline-block"
            });

            this.$elem.append(_$input).append($button_open);
          }

          break;
      }

      if (this.config.hasOwnProperty('heading') && this.config.layout == 'form') {
        this.$elem.addClass('title');
      }

      return this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
    }
  }]);
  return WidgetLink;
}(_Widget2.default);

exports.default = WidgetLink;

/***/ }),

/***/ "./build/widgets/WidgetMany2Many.js":
/*!******************************************!*\
  !*** ./build/widgets/WidgetMany2Many.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _assertThisInitialized2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/assertThisInitialized */ "./node_modules/@babel/runtime/helpers/assertThisInitialized.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _equalLib = __webpack_require__(/*! ../equal-lib */ "./build/equal-lib.js");

var _Domain = __webpack_require__(/*! ../Domain */ "./build/Domain.js");

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetMany2Many = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetMany2Many, _Widget);

  var _super = _createSuper(WidgetMany2Many);

  function WidgetMany2Many(layout, label, value, config) {
    var _this;

    (0, _classCallCheck2.default)(this, WidgetMany2Many);
    _this = _super.call(this, layout, 'many2many', label, value, config);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "rel_type", void 0);
    _this.rel_type = 'many2many';
    return _this;
  }

  (0, _createClass2.default)(WidgetMany2Many, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      this.$elem = $('<div />'); // make sure view is not instanciated during 'layout' phase (while config is still incomplete)

      if (this.config.hasOwnProperty('ready') && this.config.ready) {
        var view_config = _objectSpread(_objectSpread({}, this.config), {
          show_actions: true,
          // update the actions of the "current selection" button
          selection_actions: [{
            label: 'SB_ACTIONS_BUTTON_REMOVE',
            icon: 'delete',
            handler: function handler(selection) {
              var _iterator = _createForOfIteratorHelper(selection),
                  _step;

              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  var id = _step.value;

                  var index = _this2.value.indexOf(id);

                  if (index > -1) {
                    _this2.value.splice(index, 1);
                  }

                  index = _this2.value.indexOf(-id);

                  if (index > -1) {
                    _this2.value.splice(index, 1);
                  }

                  _this2.value.push(-id);
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }

              _this2.$elem.trigger('_updatedWidget');
            }
          }]
        });

        var domain = new _Domain.Domain(this.config.domain); // add join condition for limiting list to the current object
        // this is only valid on the first rendering, afterward the layout controls the ids

        if (['one2many', 'many2many'].indexOf(this.config.type) > -1 && this.config.hasOwnProperty('foreign_field')) {
          if (this.config.type == 'one2many') {
            domain.merge(new _Domain.Domain([this.config.foreign_field, '=', this.config.object_id]));
          } else {
            domain.merge(new _Domain.Domain([this.config.foreign_field, 'contains', this.config.object_id]));
          }
        } // domain is updated based on user actions: an additional clause for + (accept these whatever the other conditions) and addtional conditions for - (prevent these whatever the other conditions)


        if (this.config.hasOwnProperty('ids_to_add') && this.config.ids_to_add.length) {
          domain.addClause(new _Domain.Clause([new _Domain.Condition("id", "in", this.config.ids_to_add)]));
        }

        if (this.config.hasOwnProperty('ids_to_del') && this.config.ids_to_del.length) {
          domain.addCondition(new _Domain.Condition("id", "not in", this.config.ids_to_del));
        }

        var view = new _equalLib.View(this.getLayout().getView().getContext(), this.config.entity, this.config.view_type, this.config.view_name, domain.toArray(), this.mode, 'widget', this.config.lang, view_config);
        view.isReady().then(function () {
          var $container = view.getContainer();

          if (_this2.mode == 'edit') {
            // default values
            var has_action_select = _this2.rel_type == 'many2many';
            var has_action_create = true; // override with view schema

            if (_this2.config.hasOwnProperty('header') && _this2.config.header.hasOwnProperty('actions')) {
              if (_this2.config.header.actions.hasOwnProperty('ACTION.SELECT')) {
                has_action_select = _this2.config.header.actions['ACTION.SELECT'] ? true : false;
              }

              if (_this2.config.header.actions.hasOwnProperty('ACTION.CREATE')) {
                has_action_create = _this2.config.header.actions['ACTION.CREATE'] ? true : false;
              }
            }

            var $actions_set = $container.find('.sb-view-header-actions-std');

            if (has_action_select) {
              var _domain = _this2.config.domain;

              if (_this2.config.hasOwnProperty('header') && _this2.config.header.hasOwnProperty('actions') && _this2.config.header.actions.hasOwnProperty('ACTION.SELECT')) {
                if (Array.isArray(_this2.config.header.actions['ACTION.SELECT'])) {
                  var item = _this2.config.header.actions['ACTION.SELECT'][0];

                  if (item.hasOwnProperty('domain')) {
                    var tmpDomain = new _Domain.Domain(_domain);
                    tmpDomain.merge(new _Domain.Domain(item.domain));
                    _domain = tmpDomain.toArray();
                  }
                }
              }

              var button_label = _equalServices.TranslationService.instant(_this2.rel_type == 'many2many' ? 'SB_ACTIONS_BUTTON_ADD' : 'SB_ACTIONS_BUTTON_SELECT');

              $actions_set.append(_materialLib.UIHelper.createButton(_this2.getId() + '_action-edit', button_label, 'raised').on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
                var purpose;
                return _regenerator.default.wrap(function _callee$(_context) {
                  while (1) {
                    switch (_context.prev = _context.next) {
                      case 0:
                        purpose = _this2.rel_type == 'many2many' ? 'add' : 'select'; // request a new Context for selecting an existing object to add to current selection

                        _this2.getLayout().openContext({
                          entity: _this2.config.entity,
                          type: 'list',
                          name: 'default',
                          domain: _domain,
                          mode: 'view',
                          purpose: purpose,
                          callback: function callback(data) {
                            if (data && data.selection) {
                              // add ids that are not yet in the Object value
                              var _iterator2 = _createForOfIteratorHelper(data.selection),
                                  _step2;

                              try {
                                for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                                  var id = _step2.value;

                                  var index = _this2.value.indexOf(id);

                                  if (index > -1) {
                                    _this2.value.splice(index, 1);
                                  }

                                  index = _this2.value.indexOf(-id);

                                  if (index > -1) {
                                    _this2.value.splice(index, 1);
                                  }

                                  _this2.value.push(id);
                                }
                              } catch (err) {
                                _iterator2.e(err);
                              } finally {
                                _iterator2.f();
                              }

                              _this2.$elem.trigger('_updatedWidget');
                            }
                          }
                        });

                      case 2:
                      case "end":
                        return _context.stop();
                    }
                  }
                }, _callee);
              }))));
            }

            if (has_action_create) {
              // generate domain for object creation
              var _domain2 = _this2.config.domain;

              var _tmpDomain = new _Domain.Domain(_domain2);

              _tmpDomain.merge(new _Domain.Domain([_this2.config.foreign_field, '=', _this2.config.object_id]));

              _domain2 = _tmpDomain.toArray();
              $actions_set.append(_materialLib.UIHelper.createButton(_this2.getId() + '_action-create', _equalServices.TranslationService.instant('SB_ACTIONS_BUTTON_CREATE'), 'raised').on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
                var view_type, view_name, custom_actions, custom_action_create, parts, _tmpDomain2;

                return _regenerator.default.wrap(function _callee2$(_context2) {
                  while (1) {
                    switch (_context2.prev = _context2.next) {
                      case 0:
                        view_type = 'form';
                        view_name = view.getName();
                        custom_actions = view.getCustomActions();

                        if (custom_actions.hasOwnProperty('ACTION.CREATE')) {
                          if (Array.isArray(custom_actions['ACTION.CREATE']) && custom_actions['ACTION.CREATE'].length) {
                            custom_action_create = custom_actions['ACTION.CREATE'][0];

                            if (custom_action_create.hasOwnProperty('view')) {
                              parts = custom_action_create.view.split('.');
                              if (parts.length) view_type = parts.shift();
                              if (parts.length) view_name = parts.shift();
                            }

                            if (custom_action_create.hasOwnProperty('domain')) {
                              _tmpDomain2 = new _Domain.Domain(_domain2);

                              _tmpDomain2.merge(new _Domain.Domain(custom_action_create['domain']));

                              _domain2 = _tmpDomain2.toArray();
                            }
                          }
                        } // request a new Context for selecting an existing object to add to current selection


                        _this2.getLayout().openContext({
                          entity: _this2.config.entity,
                          type: view_type,
                          name: view_name,
                          domain: _domain2,
                          mode: 'edit',
                          purpose: 'create',
                          callback: function callback(data) {
                            if (data && data.selection) {
                              if (data.selection.length) {
                                var _iterator3 = _createForOfIteratorHelper(data.selection),
                                    _step3;

                                try {
                                  for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                                    var id = _step3.value;

                                    _this2.value.push(id);
                                  }
                                } catch (err) {
                                  _iterator3.e(err);
                                } finally {
                                  _iterator3.f();
                                }

                                _this2.$elem.trigger('_updatedWidget');
                              }
                            }
                          }
                        });

                      case 5:
                      case "end":
                        return _context2.stop();
                    }
                  }
                }, _callee2);
              }))));
            }
          } // inject View in parent Context object


          _this2.$elem.append($container);
        });
      }

      this.$elem.addClass('sb-widget').attr('id', this.getId());
      return this.$elem;
    }
  }]);
  return WidgetMany2Many;
}(_Widget2.default);

exports.default = WidgetMany2Many;

/***/ }),

/***/ "./build/widgets/WidgetMany2One.js":
/*!*****************************************!*\
  !*** ./build/widgets/WidgetMany2One.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _regenerator = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/regenerator */ "./node_modules/@babel/runtime/regenerator/index.js"));

var _defineProperty2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/defineProperty.js"));

var _asyncToGenerator2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/asyncToGenerator */ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js"));

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _equalServices = __webpack_require__(/*! ../equal-services */ "./build/equal-services.js");

var _Domain = _interopRequireDefault(__webpack_require__(/*! ../Domain */ "./build/Domain.js"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetMany2One = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetMany2One, _Widget);

  var _super = _createSuper(WidgetMany2One);

  function WidgetMany2One(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetMany2One);
    return _super.call(this, layout, 'many2one', label, value, config);
  }

  (0, _createClass2.default)(WidgetMany2One, [{
    key: "render",
    value: function render() {
      var _this = this;

      // in edit mode, we should have received an id, and in view mode, a name
      var value = this.value ? this.value : '';
      var domain = [];

      if (this.config.hasOwnProperty('domain')) {
        domain = this.config.domain;
      } // #todo : display many2one as sub-forms
      // on right side of widget, add an icon to open the target object (current selection) into a new context


      var $button_open = _materialLib.UIHelper.createButton('m2o-actions-open-' + this.id, '', 'icon', 'open_in_new').attr('tabindex', -1);

      var $button_create = _materialLib.UIHelper.createButton('m2o-actions-create-' + this.id, '', 'icon', 'add').attr('tabindex', -1);

      switch (this.mode) {
        case 'edit':
          var objects = [];
          this.$elem = $('<div />');

          var $select = _materialLib.UIHelper.createInput('m2o-input-' + this.id, this.label, value, this.config.description, '', this.readonly).addClass('mdc-menu-surface--anchor').css({
            "width": "100%",
            "display": "inline-block"
          });

          var $menu = _materialLib.UIHelper.createMenu('m2o-menu-' + this.id).appendTo($select);

          var $menu_list = _materialLib.UIHelper.createList('m2o-menu-list-' + this.id).appendTo($menu);

          var $link = _materialLib.UIHelper.createListItem('m2o-actions-create-' + this.id, '<a style="text-decoration: underline;">' + _equalServices.TranslationService.instant('SB_WIDGETS_MANY2ONE_ADVANCED_SEARCH') + '</a>');

          if (this.config.has_action_open || this.config.has_action_create) {
            $select.css({
              "width": "calc(100% - 48px)"
            });
          }

          _materialLib.UIHelper.decorateMenu($menu);

          if (value.length) {
            $button_create.hide();
          } else {
            $button_open.hide();
          }

          this.$elem.append($select);

          if (this.config.hasOwnProperty('object_id') && this.config.object_id > 0) {
            $select.attr('data-selected', this.config.object_id);
          }

          if (!this.config.has_action_open) {
            $button_open.hide();
          } else {
            this.$elem.append($button_open); // open targeted object in new context

            $button_open.on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
              return _regenerator.default.wrap(function _callee$(_context) {
                while (1) {
                  switch (_context.prev = _context.next) {
                    case 0:
                      if (_this.config.hasOwnProperty('object_id')) {
                        _this.getLayout().openContext({
                          entity: _this.config.foreign_object,
                          type: 'form',
                          mode: 'edit',
                          name: _this.config.hasOwnProperty('view_name') ? _this.config.view_name : 'default',
                          domain: ['id', '=', _this.config.object_id],
                          callback: function callback(data) {
                            if (data && data.selection && data.objects && data.selection.length) {
                              // we should have received a single (partial) object with up-to-date name and id
                              var object = data.objects.find(function (o) {
                                return o.id == data.selection[0];
                              });
                              _this.value = {
                                id: object.id,
                                name: object.name
                              };

                              _this.$elem.trigger('_updatedWidget');
                            }
                          }
                        });
                      }

                    case 1:
                    case "end":
                      return _context.stop();
                  }
                }
              }, _callee);
            })));
          }

          if (!this.config.has_action_create) {
            $button_create.hide();
          } else {
            this.$elem.append($button_create); // open creation form in new context

            $button_create.on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee2() {
              return _regenerator.default.wrap(function _callee2$(_context2) {
                while (1) {
                  switch (_context2.prev = _context2.next) {
                    case 0:
                      _this.getLayout().openContext({
                        entity: _this.config.foreign_object,
                        type: 'form',
                        mode: 'edit',
                        purpose: 'create',
                        domain: domain,
                        name: _this.config.hasOwnProperty('view_name') ? _this.config.view_name : 'default',
                        callback: function callback(data) {
                          if (data && data.selection && data.objects && data.selection.length) {
                            $button_create.hide();
                            $button_open.show(); // m2o relations are always loaded as an object with {id:, name:}

                            var object = data.objects.find(function (o) {
                              return o.id == data.selection[0];
                            });
                            _this.value = {
                              id: object.id,
                              name: object.name
                            };

                            _this.$elem.trigger('_updatedWidget');
                          }
                        }
                      });

                    case 1:
                    case "end":
                      return _context2.stop();
                  }
                }
              }, _callee2);
            })));
          }

          var openSelectContext = function openSelectContext() {
            _this.getLayout().openContext(_objectSpread(_objectSpread({}, _this.config), {}, {
              entity: _this.config.foreign_object,

              /*
              type: (this.config.hasOwnProperty('view_type'))?this.config.view_type:'list',
              name: (this.config.hasOwnProperty('view_name'))?this.config.view_name:'default',
              */
              type: 'list',
              name: 'default',
              domain: domain,
              mode: 'view',
              purpose: 'select',
              limit: 25,
              callback: function callback(data) {
                if (data && data.selection && data.objects && data.selection.length) {
                  // m2o relations are always loaded as an object with {id:, name:}
                  var object = data.objects.find(function (o) {
                    return o.id == data.selection[0];
                  });
                  _this.value = {
                    id: object.id,
                    name: object.name
                  };

                  _this.$elem.trigger('_updatedWidget');
                }
              }
            }));
          };

          var query = '';

          var feedObjects = /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee3() {
              var $input, val, parts, domainArray, _iterator, _step, word, cond, tmpDomain, limit, response, _iterator2, _step2, _loop, object;

              return _regenerator.default.wrap(function _callee3$(_context3) {
                while (1) {
                  switch (_context3.prev = _context3.next) {
                    case 0:
                      $input = $select.find('input');

                      if ($input.length) {
                        _context3.next = 3;
                        break;
                      }

                      return _context3.abrupt("return");

                    case 3:
                      val = $input.val();
                      parts = val.split(" ");

                      if (!(val != query || !objects.length)) {
                        _context3.next = 29;
                        break;
                      }

                      query = val;
                      domainArray = [];
                      _iterator = _createForOfIteratorHelper(parts);

                      try {
                        for (_iterator.s(); !(_step = _iterator.n()).done;) {
                          word = _step.value;
                          cond = ['name', 'ilike', '%' + word + '%'];
                          domainArray.push(cond);
                        }
                      } catch (err) {
                        _iterator.e(err);
                      } finally {
                        _iterator.f();
                      }

                      tmpDomain = new _Domain.default(domainArray);
                      tmpDomain.merge(new _Domain.default(domain)); // fetch first objects from config.foreign_object (use config.domain) + add an extra line ("advanced search...")

                      limit = _this.config.limit ? _this.config.limit : 5;
                      _context3.prev = 13;
                      _context3.next = 16;
                      return _equalServices.ApiService.collect(_this.config.foreign_object, tmpDomain.toArray(), ['id', 'name'], 'id', 'asc', 0, limit, _this.config.lang);

                    case 16:
                      response = _context3.sent;
                      objects = response;
                      $menu_list.empty();
                      _iterator2 = _createForOfIteratorHelper(objects);

                      try {
                        _loop = function _loop() {
                          var object = _step2.value;

                          _materialLib.UIHelper.createListItem(_this.id + '-object-' + object.id, object.name.replaceAll(' ', '&nbsp;')).appendTo($menu_list).attr('id', object.id).on('click', function (event) {
                            $input.val(object.name).trigger('change');
                            $select.attr('data-selected', object.id);
                            $select.trigger('update');
                          });
                        };

                        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                          _loop();
                        }
                      } catch (err) {
                        _iterator2.e(err);
                      } finally {
                        _iterator2.f();
                      }

                      if (objects.length) {
                        if (objects.length == 1) {
                          // if list is exactly 1 object long : auto-select
                          object = objects[0];
                          $input.val(object.name).trigger('change');
                          $select.attr('data-selected', object.id);
                          $select.trigger('update');
                        } else {
                          $menu_list.append(_materialLib.UIHelper.createListDivider());
                        }
                      } // advanced search button


                      $link.on('click', openSelectContext);
                      $menu_list.append($link);
                      _context3.next = 29;
                      break;

                    case 26:
                      _context3.prev = 26;
                      _context3.t0 = _context3["catch"](13);
                      console.warn('request failed', _context3.t0);

                    case 29:
                      // make the menu sync with its parent width (menu is 'fixed')
                      $select.find('.mdc-menu-surface').width($select.width());

                    case 30:
                    case "end":
                      return _context3.stop();
                  }
                }
              }, _callee3, null, [[13, 26]]);
            }));

            return function feedObjects() {
              return _ref3.apply(this, arguments);
            };
          }();

          if (this.config.layout == 'form' && !this.readonly) {
            var $button_reset = _materialLib.UIHelper.createButton('m2o-actions-reset-' + this.id, '', 'icon', 'close').css({
              "position": "absolute",
              "right": "45px",
              "top": "5px",
              "z-index": "2"
            });

            if (!this.config.has_action_open && !this.config.has_action_create) {
              $button_reset.css({
                "right": "5px"
              });
            }

            if (value.length) {
              this.$elem.append($button_reset); // make room for reset button

              $select.find('input').css({
                'width': 'calc(100% - 50px)'
              });
            }

            var has_focus = false;
            var dblclick_timeout = false;
            $button_reset.on('click', function (event) {
              _this.value = {
                id: 0,
                name: ''
              };
              $select.attr('data-selected', 0);

              _this.$elem.trigger('_updatedWidget'); // if keyboard, give back the focus to the input after refreshing the view (other object, same ID)


              if (event.screenX == 0 && event.screenY == 0) {
                setTimeout(function () {
                  $('#m2o-input-' + _this.id).find('input').trigger('focus');
                  $('#m2o-input-' + _this.id).trigger('click');
                }, 500);
              }
            });
            $select.find('input').on('blur', function (event) {
              event.stopPropagation();

              if (dblclick_timeout) {
                return;
              }

              if (!has_focus) {
                return;
              } // wait for the focus be given at next widget AND change to be relayed, if any


              setTimeout(function () {
                has_focus = false;
                $menu.trigger('_close');
              }, 150);
            });
            $select.on('click', function (event) {
              event.stopPropagation();

              if (dblclick_timeout) {
                return;
              } // click on a focused input blurs (workaround for disapearing menu)


              if (has_focus) {
                has_focus = false;
                dblclick_timeout = true;
                $select.find('input').blur();
                setTimeout(function () {
                  dblclick_timeout = false; // $menu.trigger('_close');
                }, 500);
              } else {
                if (!value.length) {
                  $menu.trigger('_open');
                }
              }
            });
            $select.find('input').on('focus', function (event) {
              event.stopPropagation();

              if ($select.attr('data-selected')) {
                return;
              }

              if (dblclick_timeout) {
                $select.find('input').blur();
                return;
              }

              if (has_focus) {
                return;
              }

              has_focus = false;
              feedObjects(); // delay has_focus to distinguish first focus and later

              setTimeout(function () {
                has_focus = true;
              }, 250);
            });
            var timeout = null;
            $select.find('input').on('keyup', function (event) {
              if (event.which == 9) {
                // if clicked ok, if tab only not
                $select.trigger('click'); // prevent double handling tab

                return;
              } else if (event.which == 13) {
                // enter
                $menu.trigger('_select');
              } else if (event.which == 38) {
                // up arrow
                $menu.trigger('_moveup');
              } else if (event.which == 40) {
                // down arrow
                $menu.trigger('_movedown');
              } else {
                // new char : update results
                if (timeout) {
                  clearTimeout(timeout);
                }

                timeout = setTimeout(function () {
                  timeout = null;
                  feedObjects();
                }, 300);
              }
            }); // upon value change, relay updated value to parent layout

            $select.on('update', function (event) {
              console.debug('WidgetMany2One : received change event', $select.attr('data-selected')); // m2o relations are always loaded as an object with {id:, name:}

              var object = objects.find(function (o) {
                return o.id == $select.attr('data-selected');
              });

              if (object) {
                if (_this.config.has_action_open) {
                  $button_open.show();
                }

                $button_create.hide();
                _this.value = {
                  id: object.id,
                  name: object.name
                };

                _this.$elem.trigger('_updatedWidget');
              } else {
                if (_this.config.has_action_create) {
                  $button_create.show();
                }

                $button_open.hide();
              }
            });
          } // #memo - we condition load on init to fields with empty values AND having a domain set
          // (to prevent burst requests when view is displayed in edit mode)


          if ((!value || !value.length) && domain.length) {
            setTimeout(function () {
              return feedObjects();
            }, 250);
          }

          break;

        case 'view':
        default:
          this.$elem = $('<div />');

          var $input = _materialLib.UIHelper.createInputView('', this.label, value.toString(), this.config.description);

          switch (this.config.layout) {
            case 'form':
              $input.css({
                "width": "calc(100% - 48px)",
                "display": "inline-block"
              });
              this.$elem.append($input);

              if (this.config.has_action_open) {
                this.$elem.append($button_open); // open targeted object in new context

                $button_open.on('click', /*#__PURE__*/(0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee4() {
                  return _regenerator.default.wrap(function _callee4$(_context4) {
                    while (1) {
                      switch (_context4.prev = _context4.next) {
                        case 0:
                          if (_this.config.hasOwnProperty('object_id') && _this.config.object_id && _this.config.object_id > 0) {
                            _this.getLayout().openContext({
                              entity: _this.config.foreign_object,
                              type: 'form',
                              name: _this.config.hasOwnProperty('view_name') ? _this.config.view_name : 'default',
                              domain: ['id', '=', _this.config.object_id]
                            });
                          }

                        case 1:
                        case "end":
                          return _context4.stop();
                      }
                    }
                  }, _callee4);
                })));
              }

              break;

            case 'list':
            default:
              // by convention, first column of each row opens the object no matter the type of the field
              if (this.is_first) {
                this.$elem.addClass('is-first');
              }

              this.$elem.text(value.toString());
              this.$elem.css({
                "width": "100%",
                "height": "auto",
                "max-height": "calc(44px - 2px)",
                "white-space": "break-spaces",
                "overflow": "hidden",
                "cusor": "pointer"
              });

              if (!this.is_first) {
                // open targeted object in new context
                this.$elem.on('click', /*#__PURE__*/function () {
                  var _ref5 = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee5(event) {
                    return _regenerator.default.wrap(function _callee5$(_context5) {
                      while (1) {
                        switch (_context5.prev = _context5.next) {
                          case 0:
                            _this.getLayout().openContext({
                              entity: _this.config.foreign_object,
                              type: 'form',
                              name: _this.config.hasOwnProperty('view_name') ? _this.config.view_name : 'default',
                              domain: ['id', '=', _this.config.object_id]
                            });

                            event.stopPropagation();

                          case 2:
                          case "end":
                            return _context5.stop();
                        }
                      }
                    }, _callee5);
                  }));

                  return function (_x) {
                    return _ref5.apply(this, arguments);
                  };
                }());
              }

          }

          break;
      }

      this.$elem.addClass('sb-widget').addClass('sb-widget-type-many2one').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
      return this.$elem;
    }
  }]);
  return WidgetMany2One;
}(_Widget2.default);

exports.default = WidgetMany2One;

/***/ }),

/***/ "./build/widgets/WidgetOne2Many.js":
/*!*****************************************!*\
  !*** ./build/widgets/WidgetOne2Many.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _WidgetMany2Many2 = _interopRequireDefault(__webpack_require__(/*! ./WidgetMany2Many */ "./build/widgets/WidgetMany2Many.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetOne2Many = /*#__PURE__*/function (_WidgetMany2Many) {
  (0, _inherits2.default)(WidgetOne2Many, _WidgetMany2Many);

  var _super = _createSuper(WidgetOne2Many);

  function WidgetOne2Many(layout, label, value, config) {
    var _this;

    (0, _classCallCheck2.default)(this, WidgetOne2Many);
    _this = _super.call(this, layout, label, value, config);
    _this.rel_type = 'one2many';
    return _this;
  }

  return WidgetOne2Many;
}(_WidgetMany2Many2.default);

exports.default = WidgetOne2Many;

/***/ }),

/***/ "./build/widgets/WidgetSelect.js":
/*!***************************************!*\
  !*** ./build/widgets/WidgetSelect.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetSelect = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetSelect, _Widget);

  var _super = _createSuper(WidgetSelect);

  function WidgetSelect(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetSelect);
    return _super.call(this, layout, 'select', label, value, config);
  }

  (0, _createClass2.default)(WidgetSelect, [{
    key: "change",
    value: function change(value) {
      this.$elem.trigger('select', value);
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var value = this.value ? this.value : '';

      switch (this.mode) {
        case 'edit':
          this.$elem = _materialLib.UIHelper.createSelect(this.getId(), this.label, this.config.values, value, this.config.description, this.readonly);

          if (this.config.layout == 'list') {
            this.$elem.css({
              "width": "calc(100% - 10px)"
            });
          } // setup handler for relaying value update to parent layout


          this.$elem.find('input').on('change', function (event) {
            console.debug('WidgetSelect : received change event');
            var $this = $(event.currentTarget);
            _this.value = $this.val();

            _this.$elem.trigger('_updatedWidget');
          });
          break;

        case 'view':
        default:
          var val = Array.isArray(this.config.values) ? value : this.config.values[value];
          this.$elem = _materialLib.UIHelper.createInputView('', this.label, val, this.config.description);
          break;
      }

      if (this.config.hasOwnProperty('heading') && this.config.layout == 'form') {
        this.$elem.addClass('title');
      }

      this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
      return this.$elem;
    }
  }]);
  return WidgetSelect;
}(_Widget2.default);

exports.default = WidgetSelect;

/***/ }),

/***/ "./build/widgets/WidgetString.js":
/*!***************************************!*\
  !*** ./build/widgets/WidgetString.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetString = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetString, _Widget);

  var _super = _createSuper(WidgetString);

  function WidgetString(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetString);
    return _super.call(this, layout, 'string', label, value, config);
  }

  (0, _createClass2.default)(WidgetString, [{
    key: "change",
    value: function change(value) {
      if (typeof value == 'string') {
        value = value.replace(/"/g, "&quot;");
      }

      this.$elem.find('input').val(value).trigger('change');
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var value = typeof this.value != undefined && this.value != undefined ? this.value : '';

      if (typeof value == 'string') {
        value = value.replace(/"/g, "&quot;");
      }

      switch (this.mode) {
        case 'edit':
          this.$elem = _materialLib.UIHelper.createInput('string_' + this.id, this.label, value, this.config.description, '', this.readonly);

          if (this.config.layout == 'list') {
            this.$elem.css({
              "width": "calc(100% - 10px)"
            });
          } // #memo - not dealing with keydown is preferred to avoid confusion about special keys role
          // #memo - we use 'change' event to cover float and integers changes with up and down buttons (same timeout)


          this.$elem.find('input').on('change', function (event) {
            var $this = $(event.currentTarget);

            if (_this.value != $this.val()) {
              _this.value = $this.val();

              _this.$elem.trigger('_updatedWidget', [false]);
            }
          });
          break;

        case 'view':
        default:
          var $link;

          if (this.config.layout == 'list' && this.config.hasOwnProperty('usage')) {
            var usage = this.config.usage;

            if (usage.indexOf('phone') >= 0) {
              $link = $('<a target="_blank" href="tel:' + value + '">' + value + '</a>');
              $link.on('click', function (event) {
                event.stopPropagation();
              });
            } else if (usage.indexOf('email') >= 0) {
              $link = $('<a target="_blank" href="mailto:' + value + '">' + value + '</a>');
              $link.on('click', function (event) {
                event.stopPropagation();
              });
            }
          }

          if ($link) {
            this.$elem = $('<div />');
            this.$elem.append($link);
          } else {
            if (this.config.layout == 'list') {
              this.$elem = $('<div />').html(value);
              this.$elem.css({
                "width": "100%",
                "height": "auto",
                "max-height": "calc(44px - 2px)",
                "white-space": "break-spaces",
                "overflow": "hidden"
              });
            } else {
              this.$elem = _materialLib.UIHelper.createInputView('', this.label, value, this.config.description);
            }

            this.$elem.attr('title', value);
          }

          break;
      }

      if (this.config.hasOwnProperty('heading') && this.config.layout == 'form') {
        this.$elem.addClass('title');
      }

      return this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
    }
  }]);
  return WidgetString;
}(_Widget2.default);

exports.default = WidgetString;

/***/ }),

/***/ "./build/widgets/WidgetText.js":
/*!*************************************!*\
  !*** ./build/widgets/WidgetText.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "./node_modules/jquery/dist/jquery-exposed.js");


var _interopRequireDefault = __webpack_require__(/*! @babel/runtime/helpers/interopRequireDefault */ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js");

Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/classCallCheck.js"));

var _createClass2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/createClass.js"));

var _inherits2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/inherits */ "./node_modules/@babel/runtime/helpers/inherits.js"));

var _possibleConstructorReturn2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/possibleConstructorReturn */ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js"));

var _getPrototypeOf2 = _interopRequireDefault(__webpack_require__(/*! @babel/runtime/helpers/getPrototypeOf */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js"));

var _Widget2 = _interopRequireDefault(__webpack_require__(/*! ./Widget */ "./build/widgets/Widget.js"));

var _materialLib = __webpack_require__(/*! ../material-lib */ "./build/material-lib.js");

var _quill = _interopRequireDefault(__webpack_require__(/*! quill */ "./node_modules/quill/dist/quill.js"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var WidgetText = /*#__PURE__*/function (_Widget) {
  (0, _inherits2.default)(WidgetText, _Widget);

  var _super = _createSuper(WidgetText);

  function WidgetText(layout, label, value, config) {
    (0, _classCallCheck2.default)(this, WidgetText);
    return _super.call(this, layout, 'text', label, value, config);
  }

  (0, _createClass2.default)(WidgetText, [{
    key: "change",
    value: function change(value) {
      // this.$elem.find('textarea').val(value).trigger('change');
      if (this.$elem.data('quill')) {
        var editor = this.$elem.data('quill');
        editor.root.innerHTML = value;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this = this;

      var value = this.value ? this.value : '';

      switch (this.mode) {
        case 'edit':
          if (this.config.layout == 'list') {
            this.$elem = _materialLib.UIHelper.createInput('', this.label, value, this.config.description, '', this.readonly);
            this.$elem.css({
              "width": "calc(100% - 10px)"
            }); // setup handler for relaying value update to parent layout

            this.$elem.find('input').on('change', function (event) {
              var $this = $(event.currentTarget);
              _this.value = $this.val();

              if (_this.value != value) {
                _this.$elem.trigger('_updatedWidget', [false]);
              }
            });
          } else {
            this.$elem = $('<div class="sb-ui-textarea" />');
            var $editor = $('<div quill__editor></div>');
            this.$elem.append($editor);
            this.getLayout().getView().isReady().then(function () {
              // init inline styling
              var ColorClass = _quill.default.import('attributors/class/color');

              var SizeStyle = _quill.default.import('attributors/style/size');

              var AlignStyle = _quill.default.import('attributors/style/align');

              _quill.default.register(ColorClass, true);

              _quill.default.register(SizeStyle, true);

              _quill.default.register(AlignStyle, true);

              var editor = new _quill.default($editor[0], {
                placeholder: _this.config.description,
                theme: "snow",
                modules: {
                  toolbar: [['bold', 'italic', 'underline', 'strike'], ['blockquote'], // [{ 'header': [1, 2, 3, 4, 5, 6, false]}],
                  [{
                    'list': 'ordered'
                  }, {
                    'list': 'bullet'
                  }], [{
                    "align": ''
                  }, {
                    "align": 'center'
                  }, {
                    'align': 'right'
                  }], [{
                    'size': ['small', false, 'large', 'huge']
                  }], ['fullscreen']]
                }
              });

              _this.$elem.find('.ql-fullscreen').on('click', function () {
                var elem = _this.$elem[0];

                if (elem.requestFullscreen) {
                  elem.requestFullscreen();
                } else if (elem.hasOwnProperty('webkitRequestFullscreen')) {
                  elem['webkitRequestFullscreen']();
                }
              });

              _this.$elem.find('.ql-formats *').attr('tabindex', -1);

              _this.$elem.data('quill', editor);

              editor.root.innerHTML = value;
              var timeout;
              editor.on('text-change', function (delta, source) {
                _this.value = editor.root.innerHTML; // update value without refreshing the layout

                if (_this.value != value) {
                  // debounce updates
                  if (timeout) {
                    clearTimeout(timeout);
                  }

                  timeout = setTimeout(function () {
                    _this.$elem.trigger('_updatedWidget', [false]); // we set timeout to 1s because there is no hurry here and we want to minimize requests

                  }, 1000);
                }
              });
            });
          }

          break;

        case 'view':
        default:
          if (this.config.layout == 'list') {
            value = $("<div/>").html(value).text();
            this.$elem = _materialLib.UIHelper.createInputView('', this.label, value, this.config.description);
            this.$elem.attr('title', value);
          } else {
            this.$elem = $('<div class="sb-ui-textarea" />');
            this.$elem.append($('<div class="textarea-content" />').html(value.replace(/(?:\r\n|\r|\n)/g, '<br />')));
          }

          break;
      }

      if (this.config.layout != 'list') {
        this.$elem.append($('<div class="textarea-title" />').text(this.label));
      }

      this.$elem.addClass('sb-widget').addClass('sb-widget-mode-' + this.mode).attr('id', this.getId());
      return this.$elem;
    }
  }]);
  return WidgetText;
}(_Widget2.default);

exports.default = WidgetText;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/arrayLikeToArray.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/arrayLikeToArray.js ***!
  \*****************************************************************/
/***/ ((module) => {

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) {
    arr2[i] = arr[i];
  }

  return arr2;
}

module.exports = _arrayLikeToArray;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/arrayWithHoles.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/arrayWithHoles.js ***!
  \***************************************************************/
/***/ ((module) => {

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

module.exports = _arrayWithHoles;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/assertThisInitialized.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/assertThisInitialized.js ***!
  \**********************************************************************/
/***/ ((module) => {

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

module.exports = _assertThisInitialized;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/asyncToGenerator.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/asyncToGenerator.js ***!
  \*****************************************************************/
/***/ ((module) => {

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }

  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}

function _asyncToGenerator(fn) {
  return function () {
    var self = this,
        args = arguments;
    return new Promise(function (resolve, reject) {
      var gen = fn.apply(self, args);

      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }

      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }

      _next(undefined);
    });
  };
}

module.exports = _asyncToGenerator;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/classCallCheck.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/classCallCheck.js ***!
  \***************************************************************/
/***/ ((module) => {

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

module.exports = _classCallCheck;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/createClass.js":
/*!************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/createClass.js ***!
  \************************************************************/
/***/ ((module) => {

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

module.exports = _createClass;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/defineProperty.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/defineProperty.js ***!
  \***************************************************************/
/***/ ((module) => {

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

module.exports = _defineProperty;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/get.js":
/*!****************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/get.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var superPropBase = __webpack_require__(/*! ./superPropBase.js */ "./node_modules/@babel/runtime/helpers/superPropBase.js");

function _get(target, property, receiver) {
  if (typeof Reflect !== "undefined" && Reflect.get) {
    module.exports = _get = Reflect.get;
    module.exports.default = module.exports, module.exports.__esModule = true;
  } else {
    module.exports = _get = function _get(target, property, receiver) {
      var base = superPropBase(target, property);
      if (!base) return;
      var desc = Object.getOwnPropertyDescriptor(base, property);

      if (desc.get) {
        return desc.get.call(receiver);
      }

      return desc.value;
    };

    module.exports.default = module.exports, module.exports.__esModule = true;
  }

  return _get(target, property, receiver || target);
}

module.exports = _get;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/getPrototypeOf.js ***!
  \***************************************************************/
/***/ ((module) => {

function _getPrototypeOf(o) {
  module.exports = _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  module.exports.default = module.exports, module.exports.__esModule = true;
  return _getPrototypeOf(o);
}

module.exports = _getPrototypeOf;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/inherits.js":
/*!*********************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/inherits.js ***!
  \*********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var setPrototypeOf = __webpack_require__(/*! ./setPrototypeOf.js */ "./node_modules/@babel/runtime/helpers/setPrototypeOf.js");

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) setPrototypeOf(subClass, superClass);
}

module.exports = _inherits;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/interopRequireDefault.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/interopRequireDefault.js ***!
  \**********************************************************************/
/***/ ((module) => {

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {
    "default": obj
  };
}

module.exports = _interopRequireDefault;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/iterableToArrayLimit.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/iterableToArrayLimit.js ***!
  \*********************************************************************/
/***/ ((module) => {

function _iterableToArrayLimit(arr, i) {
  var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"];

  if (_i == null) return;
  var _arr = [];
  var _n = true;
  var _d = false;

  var _s, _e;

  try {
    for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

module.exports = _iterableToArrayLimit;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/nonIterableRest.js":
/*!****************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/nonIterableRest.js ***!
  \****************************************************************/
/***/ ((module) => {

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

module.exports = _nonIterableRest;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/possibleConstructorReturn.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js").default;

var assertThisInitialized = __webpack_require__(/*! ./assertThisInitialized.js */ "./node_modules/@babel/runtime/helpers/assertThisInitialized.js");

function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  }

  return assertThisInitialized(self);
}

module.exports = _possibleConstructorReturn;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/setPrototypeOf.js":
/*!***************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/setPrototypeOf.js ***!
  \***************************************************************/
/***/ ((module) => {

function _setPrototypeOf(o, p) {
  module.exports = _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  module.exports.default = module.exports, module.exports.__esModule = true;
  return _setPrototypeOf(o, p);
}

module.exports = _setPrototypeOf;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/slicedToArray.js":
/*!**************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/slicedToArray.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayWithHoles = __webpack_require__(/*! ./arrayWithHoles.js */ "./node_modules/@babel/runtime/helpers/arrayWithHoles.js");

var iterableToArrayLimit = __webpack_require__(/*! ./iterableToArrayLimit.js */ "./node_modules/@babel/runtime/helpers/iterableToArrayLimit.js");

var unsupportedIterableToArray = __webpack_require__(/*! ./unsupportedIterableToArray.js */ "./node_modules/@babel/runtime/helpers/unsupportedIterableToArray.js");

var nonIterableRest = __webpack_require__(/*! ./nonIterableRest.js */ "./node_modules/@babel/runtime/helpers/nonIterableRest.js");

function _slicedToArray(arr, i) {
  return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || unsupportedIterableToArray(arr, i) || nonIterableRest();
}

module.exports = _slicedToArray;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/superPropBase.js":
/*!**************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/superPropBase.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getPrototypeOf = __webpack_require__(/*! ./getPrototypeOf.js */ "./node_modules/@babel/runtime/helpers/getPrototypeOf.js");

function _superPropBase(object, property) {
  while (!Object.prototype.hasOwnProperty.call(object, property)) {
    object = getPrototypeOf(object);
    if (object === null) break;
  }

  return object;
}

module.exports = _superPropBase;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/typeof.js":
/*!*******************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/typeof.js ***!
  \*******************************************************/
/***/ ((module) => {

function _typeof(obj) {
  "@babel/helpers - typeof";

  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    module.exports = _typeof = function _typeof(obj) {
      return typeof obj;
    };

    module.exports.default = module.exports, module.exports.__esModule = true;
  } else {
    module.exports = _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };

    module.exports.default = module.exports, module.exports.__esModule = true;
  }

  return _typeof(obj);
}

module.exports = _typeof;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/unsupportedIterableToArray.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/unsupportedIterableToArray.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayLikeToArray = __webpack_require__(/*! ./arrayLikeToArray.js */ "./node_modules/@babel/runtime/helpers/arrayLikeToArray.js");

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return arrayLikeToArray(o, minLen);
}

module.exports = _unsupportedIterableToArray;
module.exports.default = module.exports, module.exports.__esModule = true;

/***/ }),

/***/ "./node_modules/@babel/runtime/regenerator/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@babel/runtime/regenerator/index.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! regenerator-runtime */ "./node_modules/regenerator-runtime/runtime.js");


/***/ }),

/***/ "./node_modules/@material/animation/animationframe.js":
/*!************************************************************!*\
  !*** ./node_modules/@material/animation/animationframe.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnimationFrame": () => (/* binding */ AnimationFrame)
/* harmony export */ });
/**
 * @license
 * Copyright 2020 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 * AnimationFrame provides a user-friendly abstraction around requesting
 * and canceling animation frames.
 */
var AnimationFrame = /** @class */ (function () {
    function AnimationFrame() {
        this.rafIDs = new Map();
    }
    /**
     * Requests an animation frame. Cancels any existing frame with the same key.
     * @param {string} key The key for this callback.
     * @param {FrameRequestCallback} callback The callback to be executed.
     */
    AnimationFrame.prototype.request = function (key, callback) {
        var _this = this;
        this.cancel(key);
        var frameID = requestAnimationFrame(function (frame) {
            _this.rafIDs.delete(key);
            // Callback must come *after* the key is deleted so that nested calls to
            // request with the same key are not deleted.
            callback(frame);
        });
        this.rafIDs.set(key, frameID);
    };
    /**
     * Cancels a queued callback with the given key.
     * @param {string} key The key for this callback.
     */
    AnimationFrame.prototype.cancel = function (key) {
        var rafID = this.rafIDs.get(key);
        if (rafID) {
            cancelAnimationFrame(rafID);
            this.rafIDs.delete(key);
        }
    };
    /**
     * Cancels all queued callback.
     */
    AnimationFrame.prototype.cancelAll = function () {
        var _this = this;
        // Need to use forEach because it's the only iteration method supported
        // by IE11. Suppress the underscore because we don't need it.
        // tslint:disable-next-line:enforce-name-casing
        this.rafIDs.forEach(function (_, key) {
            _this.cancel(key);
        });
    };
    /**
     * Returns the queue of unexecuted callback keys.
     */
    AnimationFrame.prototype.getQueue = function () {
        var queue = [];
        // Need to use forEach because it's the only iteration method supported
        // by IE11. Suppress the underscore because we don't need it.
        // tslint:disable-next-line:enforce-name-casing
        this.rafIDs.forEach(function (_, key) {
            queue.push(key);
        });
        return queue;
    };
    return AnimationFrame;
}());

//# sourceMappingURL=animationframe.js.map

/***/ }),

/***/ "./node_modules/@material/animation/util.js":
/*!**************************************************!*\
  !*** ./node_modules/@material/animation/util.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getCorrectPropertyName": () => (/* binding */ getCorrectPropertyName),
/* harmony export */   "getCorrectEventName": () => (/* binding */ getCorrectEventName)
/* harmony export */ });
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var cssPropertyNameMap = {
    animation: {
        prefixed: '-webkit-animation',
        standard: 'animation',
    },
    transform: {
        prefixed: '-webkit-transform',
        standard: 'transform',
    },
    transition: {
        prefixed: '-webkit-transition',
        standard: 'transition',
    },
};
var jsEventTypeMap = {
    animationend: {
        cssProperty: 'animation',
        prefixed: 'webkitAnimationEnd',
        standard: 'animationend',
    },
    animationiteration: {
        cssProperty: 'animation',
        prefixed: 'webkitAnimationIteration',
        standard: 'animationiteration',
    },
    animationstart: {
        cssProperty: 'animation',
        prefixed: 'webkitAnimationStart',
        standard: 'animationstart',
    },
    transitionend: {
        cssProperty: 'transition',
        prefixed: 'webkitTransitionEnd',
        standard: 'transitionend',
    },
};
function isWindow(windowObj) {
    return Boolean(windowObj.document) && typeof windowObj.document.createElement === 'function';
}
function getCorrectPropertyName(windowObj, cssProperty) {
    if (isWindow(windowObj) && cssProperty in cssPropertyNameMap) {
        var el = windowObj.document.createElement('div');
        var _a = cssPropertyNameMap[cssProperty], standard = _a.standard, prefixed = _a.prefixed;
        var isStandard = standard in el.style;
        return isStandard ? standard : prefixed;
    }
    return cssProperty;
}
function getCorrectEventName(windowObj, eventType) {
    if (isWindow(windowObj) && eventType in jsEventTypeMap) {
        var el = windowObj.document.createElement('div');
        var _a = jsEventTypeMap[eventType], standard = _a.standard, prefixed = _a.prefixed, cssProperty = _a.cssProperty;
        var isStandard = cssProperty in el.style;
        return isStandard ? standard : prefixed;
    }
    return eventType;
}
//# sourceMappingURL=util.js.map

/***/ }),

/***/ "./node_modules/@material/base/component.js":
/*!**************************************************!*\
  !*** ./node_modules/@material/base/component.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCComponent": () => (/* binding */ MDCComponent),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/base/foundation.js");
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


var MDCComponent = /** @class */ (function () {
    function MDCComponent(root, foundation) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        this.root = root;
        this.initialize.apply(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__spread)(args));
        // Note that we initialize foundation here and not within the constructor's default param so that
        // this.root_ is defined and can be used within the foundation class.
        this.foundation =
            foundation === undefined ? this.getDefaultFoundation() : foundation;
        this.foundation.init();
        this.initialSyncWithDOM();
    }
    MDCComponent.attachTo = function (root) {
        // Subclasses which extend MDCBase should provide an attachTo() method that takes a root element and
        // returns an instantiated component with its root set to that element. Also note that in the cases of
        // subclasses, an explicit foundation class will not have to be passed in; it will simply be initialized
        // from getDefaultFoundation().
        return new MDCComponent(root, new _foundation__WEBPACK_IMPORTED_MODULE_1__.MDCFoundation({}));
    };
    /* istanbul ignore next: method param only exists for typing purposes; it does not need to be unit tested */
    MDCComponent.prototype.initialize = function () {
        var _args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            _args[_i] = arguments[_i];
        }
        // Subclasses can override this to do any additional setup work that would be considered part of a
        // "constructor". Essentially, it is a hook into the parent constructor before the foundation is
        // initialized. Any additional arguments besides root and foundation will be passed in here.
    };
    MDCComponent.prototype.getDefaultFoundation = function () {
        // Subclasses must override this method to return a properly configured foundation class for the
        // component.
        throw new Error('Subclasses must override getDefaultFoundation to return a properly configured ' +
            'foundation class');
    };
    MDCComponent.prototype.initialSyncWithDOM = function () {
        // Subclasses should override this method if they need to perform work to synchronize with a host DOM
        // object. An example of this would be a form control wrapper that needs to synchronize its internal state
        // to some property or attribute of the host DOM. Please note: this is *not* the place to perform DOM
        // reads/writes that would cause layout / paint, as this is called synchronously from within the constructor.
    };
    MDCComponent.prototype.destroy = function () {
        // Subclasses may implement this method to release any resources / deregister any listeners they have
        // attached. An example of this might be deregistering a resize event from the window object.
        this.foundation.destroy();
    };
    MDCComponent.prototype.listen = function (evtType, handler, options) {
        this.root.addEventListener(evtType, handler, options);
    };
    MDCComponent.prototype.unlisten = function (evtType, handler, options) {
        this.root.removeEventListener(evtType, handler, options);
    };
    /**
     * Fires a cross-browser-compatible custom event from the component root of the given type, with the given data.
     */
    MDCComponent.prototype.emit = function (evtType, evtData, shouldBubble) {
        if (shouldBubble === void 0) { shouldBubble = false; }
        var evt;
        if (typeof CustomEvent === 'function') {
            evt = new CustomEvent(evtType, {
                bubbles: shouldBubble,
                detail: evtData,
            });
        }
        else {
            evt = document.createEvent('CustomEvent');
            evt.initCustomEvent(evtType, shouldBubble, false, evtData);
        }
        this.root.dispatchEvent(evt);
    };
    return MDCComponent;
}());

// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MDCComponent);
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/base/foundation.js":
/*!***************************************************!*\
  !*** ./node_modules/@material/base/foundation.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCFoundation": () => (/* binding */ MDCFoundation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var MDCFoundation = /** @class */ (function () {
    function MDCFoundation(adapter) {
        if (adapter === void 0) { adapter = {}; }
        this.adapter = adapter;
    }
    Object.defineProperty(MDCFoundation, "cssClasses", {
        get: function () {
            // Classes extending MDCFoundation should implement this method to return an object which exports every
            // CSS class the foundation class needs as a property. e.g. {ACTIVE: 'mdc-component--active'}
            return {};
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCFoundation, "strings", {
        get: function () {
            // Classes extending MDCFoundation should implement this method to return an object which exports all
            // semantic strings as constants. e.g. {ARIA_ROLE: 'tablist'}
            return {};
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCFoundation, "numbers", {
        get: function () {
            // Classes extending MDCFoundation should implement this method to return an object which exports all
            // of its semantic numbers as constants. e.g. {ANIMATION_DELAY_MS: 350}
            return {};
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCFoundation, "defaultAdapter", {
        get: function () {
            // Classes extending MDCFoundation may choose to implement this getter in order to provide a convenient
            // way of viewing the necessary methods of an adapter. In the future, this could also be used for adapter
            // validation.
            return {};
        },
        enumerable: true,
        configurable: true
    });
    MDCFoundation.prototype.init = function () {
        // Subclasses should override this method to perform initialization routines (registering events, etc.)
    };
    MDCFoundation.prototype.destroy = function () {
        // Subclasses should override this method to perform de-initialization routines (de-registering events, etc.)
    };
    return MDCFoundation;
}());

// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MDCFoundation);
//# sourceMappingURL=foundation.js.map

/***/ }),

/***/ "./node_modules/@material/checkbox/component.js":
/*!******************************************************!*\
  !*** ./node_modules/@material/checkbox/component.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCCheckbox": () => (/* binding */ MDCCheckbox)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_animation_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/animation/util */ "./node_modules/@material/animation/util.js");
/* harmony import */ var _material_base_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @material/base/component */ "./node_modules/@material/base/component.js");
/* harmony import */ var _material_dom_events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/dom/events */ "./node_modules/@material/dom/events.js");
/* harmony import */ var _material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/dom/ponyfill */ "./node_modules/@material/dom/ponyfill.js");
/* harmony import */ var _material_ripple_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material/ripple/component */ "./node_modules/@material/ripple/component.js");
/* harmony import */ var _material_ripple_foundation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @material/ripple/foundation */ "./node_modules/@material/ripple/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/checkbox/constants.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/checkbox/foundation.js");
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */









var CB_PROTO_PROPS = ['checked', 'indeterminate'];
var MDCCheckbox = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCCheckbox, _super);
    function MDCCheckbox() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.ripple_ = _this.createRipple_();
        return _this;
    }
    MDCCheckbox.attachTo = function (root) {
        return new MDCCheckbox(root);
    };
    Object.defineProperty(MDCCheckbox.prototype, "ripple", {
        get: function () {
            return this.ripple_;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCCheckbox.prototype, "checked", {
        get: function () {
            return this.nativeControl_.checked;
        },
        set: function (checked) {
            this.nativeControl_.checked = checked;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCCheckbox.prototype, "indeterminate", {
        get: function () {
            return this.nativeControl_.indeterminate;
        },
        set: function (indeterminate) {
            this.nativeControl_.indeterminate = indeterminate;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCCheckbox.prototype, "disabled", {
        get: function () {
            return this.nativeControl_.disabled;
        },
        set: function (disabled) {
            this.foundation.setDisabled(disabled);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCCheckbox.prototype, "value", {
        get: function () {
            return this.nativeControl_.value;
        },
        set: function (value) {
            this.nativeControl_.value = value;
        },
        enumerable: true,
        configurable: true
    });
    MDCCheckbox.prototype.initialize = function () {
        var DATA_INDETERMINATE_ATTR = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.DATA_INDETERMINATE_ATTR;
        this.nativeControl_.indeterminate =
            this.nativeControl_.getAttribute(DATA_INDETERMINATE_ATTR) === 'true';
        this.nativeControl_.removeAttribute(DATA_INDETERMINATE_ATTR);
    };
    MDCCheckbox.prototype.initialSyncWithDOM = function () {
        var _this = this;
        this.handleChange_ = function () { return _this.foundation.handleChange(); };
        this.handleAnimationEnd_ = function () { return _this.foundation.handleAnimationEnd(); };
        this.nativeControl_.addEventListener('change', this.handleChange_);
        this.listen((0,_material_animation_util__WEBPACK_IMPORTED_MODULE_2__.getCorrectEventName)(window, 'animationend'), this.handleAnimationEnd_);
        this.installPropertyChangeHooks_();
    };
    MDCCheckbox.prototype.destroy = function () {
        this.ripple_.destroy();
        this.nativeControl_.removeEventListener('change', this.handleChange_);
        this.unlisten((0,_material_animation_util__WEBPACK_IMPORTED_MODULE_2__.getCorrectEventName)(window, 'animationend'), this.handleAnimationEnd_);
        this.uninstallPropertyChangeHooks_();
        _super.prototype.destroy.call(this);
    };
    MDCCheckbox.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        var adapter = {
            addClass: function (className) { return _this.root.classList.add(className); },
            forceLayout: function () { return _this.root.offsetWidth; },
            hasNativeControl: function () { return !!_this.nativeControl_; },
            isAttachedToDOM: function () { return Boolean(_this.root.parentNode); },
            isChecked: function () { return _this.checked; },
            isIndeterminate: function () { return _this.indeterminate; },
            removeClass: function (className) {
                _this.root.classList.remove(className);
            },
            removeNativeControlAttr: function (attr) {
                _this.nativeControl_.removeAttribute(attr);
            },
            setNativeControlAttr: function (attr, value) {
                _this.nativeControl_.setAttribute(attr, value);
            },
            setNativeControlDisabled: function (disabled) {
                _this.nativeControl_.disabled = disabled;
            },
        };
        return new _foundation__WEBPACK_IMPORTED_MODULE_3__.MDCCheckboxFoundation(adapter);
    };
    MDCCheckbox.prototype.createRipple_ = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        var adapter = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, _material_ripple_component__WEBPACK_IMPORTED_MODULE_4__.MDCRipple.createAdapter(this)), { deregisterInteractionHandler: function (evtType, handler) { return _this.nativeControl_.removeEventListener(evtType, handler, (0,_material_dom_events__WEBPACK_IMPORTED_MODULE_5__.applyPassive)()); }, isSurfaceActive: function () { return (0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_6__.matches)(_this.nativeControl_, ':active'); }, isUnbounded: function () { return true; }, registerInteractionHandler: function (evtType, handler) { return _this.nativeControl_.addEventListener(evtType, handler, (0,_material_dom_events__WEBPACK_IMPORTED_MODULE_5__.applyPassive)()); } });
        return new _material_ripple_component__WEBPACK_IMPORTED_MODULE_4__.MDCRipple(this.root, new _material_ripple_foundation__WEBPACK_IMPORTED_MODULE_7__.MDCRippleFoundation(adapter));
    };
    MDCCheckbox.prototype.installPropertyChangeHooks_ = function () {
        var _this = this;
        var nativeCb = this.nativeControl_;
        var cbProto = Object.getPrototypeOf(nativeCb);
        CB_PROTO_PROPS.forEach(function (controlState) {
            var desc = Object.getOwnPropertyDescriptor(cbProto, controlState);
            // We have to check for this descriptor, since some browsers (Safari) don't support its return.
            // See: https://bugs.webkit.org/show_bug.cgi?id=49739
            if (!validDescriptor(desc)) {
                return;
            }
            // Type cast is needed for compatibility with Closure Compiler.
            var nativeGetter = desc.get;
            var nativeCbDesc = {
                configurable: desc.configurable,
                enumerable: desc.enumerable,
                get: nativeGetter,
                set: function (state) {
                    desc.set.call(nativeCb, state);
                    _this.foundation.handleChange();
                },
            };
            Object.defineProperty(nativeCb, controlState, nativeCbDesc);
        });
    };
    MDCCheckbox.prototype.uninstallPropertyChangeHooks_ = function () {
        var nativeCb = this.nativeControl_;
        var cbProto = Object.getPrototypeOf(nativeCb);
        CB_PROTO_PROPS.forEach(function (controlState) {
            var desc = Object.getOwnPropertyDescriptor(cbProto, controlState);
            if (!validDescriptor(desc)) {
                return;
            }
            Object.defineProperty(nativeCb, controlState, desc);
        });
    };
    Object.defineProperty(MDCCheckbox.prototype, "nativeControl_", {
        get: function () {
            var NATIVE_CONTROL_SELECTOR = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.NATIVE_CONTROL_SELECTOR;
            var el = this.root.querySelector(NATIVE_CONTROL_SELECTOR);
            if (!el) {
                throw new Error("Checkbox component requires a " + NATIVE_CONTROL_SELECTOR + " element");
            }
            return el;
        },
        enumerable: true,
        configurable: true
    });
    return MDCCheckbox;
}(_material_base_component__WEBPACK_IMPORTED_MODULE_8__.MDCComponent));

function validDescriptor(inputPropDesc) {
    return !!inputPropDesc && typeof inputPropDesc.set === 'function';
}
//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/checkbox/constants.js":
/*!******************************************************!*\
  !*** ./node_modules/@material/checkbox/constants.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cssClasses": () => (/* binding */ cssClasses),
/* harmony export */   "strings": () => (/* binding */ strings),
/* harmony export */   "numbers": () => (/* binding */ numbers)
/* harmony export */ });
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var cssClasses = {
    ANIM_CHECKED_INDETERMINATE: 'mdc-checkbox--anim-checked-indeterminate',
    ANIM_CHECKED_UNCHECKED: 'mdc-checkbox--anim-checked-unchecked',
    ANIM_INDETERMINATE_CHECKED: 'mdc-checkbox--anim-indeterminate-checked',
    ANIM_INDETERMINATE_UNCHECKED: 'mdc-checkbox--anim-indeterminate-unchecked',
    ANIM_UNCHECKED_CHECKED: 'mdc-checkbox--anim-unchecked-checked',
    ANIM_UNCHECKED_INDETERMINATE: 'mdc-checkbox--anim-unchecked-indeterminate',
    BACKGROUND: 'mdc-checkbox__background',
    CHECKED: 'mdc-checkbox--checked',
    CHECKMARK: 'mdc-checkbox__checkmark',
    CHECKMARK_PATH: 'mdc-checkbox__checkmark-path',
    DISABLED: 'mdc-checkbox--disabled',
    INDETERMINATE: 'mdc-checkbox--indeterminate',
    MIXEDMARK: 'mdc-checkbox__mixedmark',
    NATIVE_CONTROL: 'mdc-checkbox__native-control',
    ROOT: 'mdc-checkbox',
    SELECTED: 'mdc-checkbox--selected',
    UPGRADED: 'mdc-checkbox--upgraded',
};
var strings = {
    ARIA_CHECKED_ATTR: 'aria-checked',
    ARIA_CHECKED_INDETERMINATE_VALUE: 'mixed',
    DATA_INDETERMINATE_ATTR: 'data-indeterminate',
    NATIVE_CONTROL_SELECTOR: '.mdc-checkbox__native-control',
    TRANSITION_STATE_CHECKED: 'checked',
    TRANSITION_STATE_INDETERMINATE: 'indeterminate',
    TRANSITION_STATE_INIT: 'init',
    TRANSITION_STATE_UNCHECKED: 'unchecked',
};
var numbers = {
    ANIM_END_LATCH_MS: 250,
};
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@material/checkbox/foundation.js":
/*!*******************************************************!*\
  !*** ./node_modules/@material/checkbox/foundation.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCCheckboxFoundation": () => (/* binding */ MDCCheckboxFoundation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_foundation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/base/foundation */ "./node_modules/@material/base/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/checkbox/constants.js");
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



var MDCCheckboxFoundation = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCCheckboxFoundation, _super);
    function MDCCheckboxFoundation(adapter) {
        var _this = _super.call(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, MDCCheckboxFoundation.defaultAdapter), adapter)) || this;
        _this.currentCheckState_ = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.TRANSITION_STATE_INIT;
        _this.currentAnimationClass_ = '';
        _this.animEndLatchTimer_ = 0;
        _this.enableAnimationEndHandler_ = false;
        return _this;
    }
    Object.defineProperty(MDCCheckboxFoundation, "cssClasses", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCCheckboxFoundation, "strings", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.strings;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCCheckboxFoundation, "numbers", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.numbers;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCCheckboxFoundation, "defaultAdapter", {
        get: function () {
            return {
                addClass: function () { return undefined; },
                forceLayout: function () { return undefined; },
                hasNativeControl: function () { return false; },
                isAttachedToDOM: function () { return false; },
                isChecked: function () { return false; },
                isIndeterminate: function () { return false; },
                removeClass: function () { return undefined; },
                removeNativeControlAttr: function () { return undefined; },
                setNativeControlAttr: function () { return undefined; },
                setNativeControlDisabled: function () { return undefined; },
            };
        },
        enumerable: true,
        configurable: true
    });
    MDCCheckboxFoundation.prototype.init = function () {
        this.currentCheckState_ = this.determineCheckState_();
        this.updateAriaChecked_();
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.UPGRADED);
    };
    MDCCheckboxFoundation.prototype.destroy = function () {
        clearTimeout(this.animEndLatchTimer_);
    };
    MDCCheckboxFoundation.prototype.setDisabled = function (disabled) {
        this.adapter.setNativeControlDisabled(disabled);
        if (disabled) {
            this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.DISABLED);
        }
        else {
            this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.DISABLED);
        }
    };
    /**
     * Handles the animationend event for the checkbox
     */
    MDCCheckboxFoundation.prototype.handleAnimationEnd = function () {
        var _this = this;
        if (!this.enableAnimationEndHandler_) {
            return;
        }
        clearTimeout(this.animEndLatchTimer_);
        this.animEndLatchTimer_ = setTimeout(function () {
            _this.adapter.removeClass(_this.currentAnimationClass_);
            _this.enableAnimationEndHandler_ = false;
        }, _constants__WEBPACK_IMPORTED_MODULE_1__.numbers.ANIM_END_LATCH_MS);
    };
    /**
     * Handles the change event for the checkbox
     */
    MDCCheckboxFoundation.prototype.handleChange = function () {
        this.transitionCheckState_();
    };
    MDCCheckboxFoundation.prototype.transitionCheckState_ = function () {
        if (!this.adapter.hasNativeControl()) {
            return;
        }
        var oldState = this.currentCheckState_;
        var newState = this.determineCheckState_();
        if (oldState === newState) {
            return;
        }
        this.updateAriaChecked_();
        var TRANSITION_STATE_UNCHECKED = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.TRANSITION_STATE_UNCHECKED;
        var SELECTED = _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SELECTED;
        if (newState === TRANSITION_STATE_UNCHECKED) {
            this.adapter.removeClass(SELECTED);
        }
        else {
            this.adapter.addClass(SELECTED);
        }
        // Check to ensure that there isn't a previously existing animation class, in case for example
        // the user interacted with the checkbox before the animation was finished.
        if (this.currentAnimationClass_.length > 0) {
            clearTimeout(this.animEndLatchTimer_);
            this.adapter.forceLayout();
            this.adapter.removeClass(this.currentAnimationClass_);
        }
        this.currentAnimationClass_ = this.getTransitionAnimationClass_(oldState, newState);
        this.currentCheckState_ = newState;
        // Check for parentNode so that animations are only run when the element is attached
        // to the DOM.
        if (this.adapter.isAttachedToDOM() &&
            this.currentAnimationClass_.length > 0) {
            this.adapter.addClass(this.currentAnimationClass_);
            this.enableAnimationEndHandler_ = true;
        }
    };
    MDCCheckboxFoundation.prototype.determineCheckState_ = function () {
        var TRANSITION_STATE_INDETERMINATE = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.TRANSITION_STATE_INDETERMINATE, TRANSITION_STATE_CHECKED = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.TRANSITION_STATE_CHECKED, TRANSITION_STATE_UNCHECKED = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.TRANSITION_STATE_UNCHECKED;
        if (this.adapter.isIndeterminate()) {
            return TRANSITION_STATE_INDETERMINATE;
        }
        return this.adapter.isChecked() ? TRANSITION_STATE_CHECKED :
            TRANSITION_STATE_UNCHECKED;
    };
    MDCCheckboxFoundation.prototype.getTransitionAnimationClass_ = function (oldState, newState) {
        var TRANSITION_STATE_INIT = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.TRANSITION_STATE_INIT, TRANSITION_STATE_CHECKED = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.TRANSITION_STATE_CHECKED, TRANSITION_STATE_UNCHECKED = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.TRANSITION_STATE_UNCHECKED;
        var _a = MDCCheckboxFoundation.cssClasses, ANIM_UNCHECKED_CHECKED = _a.ANIM_UNCHECKED_CHECKED, ANIM_UNCHECKED_INDETERMINATE = _a.ANIM_UNCHECKED_INDETERMINATE, ANIM_CHECKED_UNCHECKED = _a.ANIM_CHECKED_UNCHECKED, ANIM_CHECKED_INDETERMINATE = _a.ANIM_CHECKED_INDETERMINATE, ANIM_INDETERMINATE_CHECKED = _a.ANIM_INDETERMINATE_CHECKED, ANIM_INDETERMINATE_UNCHECKED = _a.ANIM_INDETERMINATE_UNCHECKED;
        switch (oldState) {
            case TRANSITION_STATE_INIT:
                if (newState === TRANSITION_STATE_UNCHECKED) {
                    return '';
                }
                return newState === TRANSITION_STATE_CHECKED ? ANIM_INDETERMINATE_CHECKED : ANIM_INDETERMINATE_UNCHECKED;
            case TRANSITION_STATE_UNCHECKED:
                return newState === TRANSITION_STATE_CHECKED ? ANIM_UNCHECKED_CHECKED : ANIM_UNCHECKED_INDETERMINATE;
            case TRANSITION_STATE_CHECKED:
                return newState === TRANSITION_STATE_UNCHECKED ? ANIM_CHECKED_UNCHECKED : ANIM_CHECKED_INDETERMINATE;
            default: // TRANSITION_STATE_INDETERMINATE
                return newState === TRANSITION_STATE_CHECKED ? ANIM_INDETERMINATE_CHECKED : ANIM_INDETERMINATE_UNCHECKED;
        }
    };
    MDCCheckboxFoundation.prototype.updateAriaChecked_ = function () {
        // Ensure aria-checked is set to mixed if checkbox is in indeterminate state.
        if (this.adapter.isIndeterminate()) {
            this.adapter.setNativeControlAttr(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_CHECKED_ATTR, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_CHECKED_INDETERMINATE_VALUE);
        }
        else {
            // The on/off state does not need to keep track of aria-checked, since
            // the screenreader uses the checked property on the checkbox element.
            this.adapter.removeNativeControlAttr(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_CHECKED_ATTR);
        }
    };
    return MDCCheckboxFoundation;
}(_material_base_foundation__WEBPACK_IMPORTED_MODULE_2__.MDCFoundation));

// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MDCCheckboxFoundation);
//# sourceMappingURL=foundation.js.map

/***/ }),

/***/ "./node_modules/@material/checkbox/index.js":
/*!**************************************************!*\
  !*** ./node_modules/@material/checkbox/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCCheckbox": () => (/* reexport safe */ _component__WEBPACK_IMPORTED_MODULE_0__.MDCCheckbox),
/* harmony export */   "cssClasses": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses),
/* harmony export */   "numbers": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_1__.numbers),
/* harmony export */   "strings": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_1__.strings),
/* harmony export */   "MDCCheckboxFoundation": () => (/* reexport safe */ _foundation__WEBPACK_IMPORTED_MODULE_2__.MDCCheckboxFoundation)
/* harmony export */ });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./component */ "./node_modules/@material/checkbox/component.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/checkbox/constants.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/checkbox/foundation.js");
/**
 * @license
 * Copyright 2019 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@material/data-table/component.js":
/*!********************************************************!*\
  !*** ./node_modules/@material/data-table/component.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCDataTable": () => (/* binding */ MDCDataTable)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/base/component */ "./node_modules/@material/base/component.js");
/* harmony import */ var _material_checkbox_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material/checkbox/component */ "./node_modules/@material/checkbox/component.js");
/* harmony import */ var _material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/dom/ponyfill */ "./node_modules/@material/dom/ponyfill.js");
/* harmony import */ var _material_linear_progress_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/linear-progress/component */ "./node_modules/@material/linear-progress/component.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/data-table/constants.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/data-table/foundation.js");
/**
 * @license
 * Copyright 2019 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */







/**
 * Implementation of `MDCDataTableFoundation`
 */
var MDCDataTable = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCDataTable, _super);
    function MDCDataTable() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MDCDataTable.attachTo = function (root) {
        return new MDCDataTable(root);
    };
    MDCDataTable.prototype.initialize = function (checkboxFactory) {
        if (checkboxFactory === void 0) { checkboxFactory = function (el) { return new _material_checkbox_component__WEBPACK_IMPORTED_MODULE_1__.MDCCheckbox(el); }; }
        this.checkboxFactory = checkboxFactory;
    };
    MDCDataTable.prototype.initialSyncWithDOM = function () {
        var _this = this;
        this.headerRow =
            this.root.querySelector("." + _constants__WEBPACK_IMPORTED_MODULE_2__.cssClasses.HEADER_ROW);
        this.handleHeaderRowCheckboxChange = function () {
            _this.foundation.handleHeaderRowCheckboxChange();
        };
        this.headerRow.addEventListener('change', this.handleHeaderRowCheckboxChange);
        this.headerRowClickListener = function (event) {
            _this.handleHeaderRowClick(event);
        };
        this.headerRow.addEventListener('click', this.headerRowClickListener);
        this.content =
            this.root.querySelector("." + _constants__WEBPACK_IMPORTED_MODULE_2__.cssClasses.CONTENT);
        this.handleRowCheckboxChange = function (event) {
            _this.foundation.handleRowCheckboxChange(event);
        };
        this.content.addEventListener('change', this.handleRowCheckboxChange);
        this.layout();
    };
    /**
     * Re-initializes header row checkbox and row checkboxes when selectable rows are added or removed from table.
     */
    MDCDataTable.prototype.layout = function () {
        this.foundation.layout();
    };
    /**
     * @return Returns array of header row cell elements.
     */
    MDCDataTable.prototype.getHeaderCells = function () {
        return [].slice.call(this.root.querySelectorAll(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.HEADER_CELL));
    };
    /**
     * @return Returns array of row elements.
     */
    MDCDataTable.prototype.getRows = function () {
        return this.foundation.getRows();
    };
    /**
     * @return Returns array of selected row ids.
     */
    MDCDataTable.prototype.getSelectedRowIds = function () {
        return this.foundation.getSelectedRowIds();
    };
    /**
     * Sets selected row ids. Overwrites previously selected rows.
     * @param rowIds Array of row ids that needs to be selected.
     */
    MDCDataTable.prototype.setSelectedRowIds = function (rowIds) {
        this.foundation.setSelectedRowIds(rowIds);
    };
    /**
     * Shows progress indicator when data table is in loading state.
     */
    MDCDataTable.prototype.showProgress = function () {
        this.getLinearProgress().open();
        this.foundation.showProgress();
    };
    /**
     * Hides progress indicator after data table is finished loading.
     */
    MDCDataTable.prototype.hideProgress = function () {
        this.foundation.hideProgress();
        this.getLinearProgress().close();
    };
    MDCDataTable.prototype.destroy = function () {
        var e_1, _a;
        if (this.handleHeaderRowCheckboxChange) {
            this.headerRow.removeEventListener('change', this.handleHeaderRowCheckboxChange);
        }
        if (this.headerRowClickListener) {
            this.headerRow.removeEventListener('click', this.headerRowClickListener);
        }
        if (this.handleRowCheckboxChange) {
            this.content.removeEventListener('change', this.handleRowCheckboxChange);
        }
        if (this.headerRowCheckbox) {
            this.headerRowCheckbox.destroy();
        }
        if (this.rowCheckboxList) {
            try {
                for (var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__values)(this.rowCheckboxList), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var checkbox = _c.value;
                    checkbox.destroy();
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
    };
    MDCDataTable.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
        var adapter = {
            addClass: function (className) {
                _this.root.classList.add(className);
            },
            removeClass: function (className) {
                _this.root.classList.remove(className);
            },
            getHeaderCellElements: function () { return _this.getHeaderCells(); },
            getHeaderCellCount: function () { return _this.getHeaderCells().length; },
            getAttributeByHeaderCellIndex: function (index, attribute) {
                return _this.getHeaderCells()[index].getAttribute(attribute);
            },
            setAttributeByHeaderCellIndex: function (index, attribute, value) {
                _this.getHeaderCells()[index].setAttribute(attribute, value);
            },
            setClassNameByHeaderCellIndex: function (index, className) {
                _this.getHeaderCells()[index].classList.add(className);
            },
            removeClassNameByHeaderCellIndex: function (index, className) {
                _this.getHeaderCells()[index].classList.remove(className);
            },
            notifySortAction: function (data) {
                _this.emit(_constants__WEBPACK_IMPORTED_MODULE_2__.events.SORTED, data, /** shouldBubble */ true);
            },
            getTableContainerHeight: function () {
                var tableContainer = _this.root.querySelector("." + _constants__WEBPACK_IMPORTED_MODULE_2__.cssClasses.TABLE_CONTAINER);
                if (!tableContainer) {
                    throw new Error('MDCDataTable: Table container element not found.');
                }
                return tableContainer.getBoundingClientRect().height;
            },
            getTableHeaderHeight: function () {
                var tableHeader = _this.root.querySelector(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.HEADER_ROW);
                if (!tableHeader) {
                    throw new Error('MDCDataTable: Table header element not found.');
                }
                return tableHeader.getBoundingClientRect().height;
            },
            setProgressIndicatorStyles: function (styles) {
                var progressIndicator = _this.root.querySelector(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.PROGRESS_INDICATOR);
                if (!progressIndicator) {
                    throw new Error('MDCDataTable: Progress indicator element not found.');
                }
                progressIndicator.style.setProperty('height', styles.height);
                progressIndicator.style.setProperty('top', styles.top);
            },
            addClassAtRowIndex: function (rowIndex, className) {
                _this.getRows()[rowIndex].classList.add(className);
            },
            getRowCount: function () { return _this.getRows().length; },
            getRowElements: function () { return [].slice.call(_this.root.querySelectorAll(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.ROW)); },
            getRowIdAtIndex: function (rowIndex) {
                return _this.getRows()[rowIndex].getAttribute(_constants__WEBPACK_IMPORTED_MODULE_2__.dataAttributes.ROW_ID);
            },
            getRowIndexByChildElement: function (el) {
                return _this.getRows().indexOf((0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_3__.closest)(el, _constants__WEBPACK_IMPORTED_MODULE_2__.selectors.ROW));
            },
            getSelectedRowCount: function () {
                return _this.root.querySelectorAll(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.ROW_SELECTED).length;
            },
            isCheckboxAtRowIndexChecked: function (rowIndex) {
                return _this.rowCheckboxList[rowIndex].checked;
            },
            isHeaderRowCheckboxChecked: function () { return _this.headerRowCheckbox.checked; },
            isRowsSelectable: function () {
                return !!_this.root.querySelector(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.ROW_CHECKBOX) ||
                    !!_this.root.querySelector(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.HEADER_ROW_CHECKBOX);
            },
            notifyRowSelectionChanged: function (data) {
                _this.emit(_constants__WEBPACK_IMPORTED_MODULE_2__.events.ROW_SELECTION_CHANGED, {
                    row: _this.getRowByIndex(data.rowIndex),
                    rowId: _this.getRowIdByIndex(data.rowIndex),
                    rowIndex: data.rowIndex,
                    selected: data.selected,
                }, 
                /** shouldBubble */ true);
            },
            notifySelectedAll: function () {
                _this.emit(_constants__WEBPACK_IMPORTED_MODULE_2__.events.SELECTED_ALL, {}, /** shouldBubble */ true);
            },
            notifyUnselectedAll: function () {
                _this.emit(_constants__WEBPACK_IMPORTED_MODULE_2__.events.UNSELECTED_ALL, {}, /** shouldBubble */ true);
            },
            registerHeaderRowCheckbox: function () {
                if (_this.headerRowCheckbox) {
                    _this.headerRowCheckbox.destroy();
                }
                var checkboxEl = _this.root.querySelector(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.HEADER_ROW_CHECKBOX);
                _this.headerRowCheckbox = _this.checkboxFactory(checkboxEl);
            },
            registerRowCheckboxes: function () {
                if (_this.rowCheckboxList) {
                    _this.rowCheckboxList.forEach(function (checkbox) {
                        checkbox.destroy();
                    });
                }
                _this.rowCheckboxList = [];
                _this.getRows().forEach(function (rowEl) {
                    var checkbox = _this.checkboxFactory(rowEl.querySelector(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.ROW_CHECKBOX));
                    _this.rowCheckboxList.push(checkbox);
                });
            },
            removeClassAtRowIndex: function (rowIndex, className) {
                _this.getRows()[rowIndex].classList.remove(className);
            },
            setAttributeAtRowIndex: function (rowIndex, attr, value) {
                _this.getRows()[rowIndex].setAttribute(attr, value);
            },
            setHeaderRowCheckboxChecked: function (checked) {
                _this.headerRowCheckbox.checked = checked;
            },
            setHeaderRowCheckboxIndeterminate: function (indeterminate) {
                _this.headerRowCheckbox.indeterminate = indeterminate;
            },
            setRowCheckboxCheckedAtIndex: function (rowIndex, checked) {
                _this.rowCheckboxList[rowIndex].checked = checked;
            },
            setSortStatusLabelByHeaderCellIndex: function (columnIndex, sortValue) {
                var headerCell = _this.getHeaderCells()[columnIndex];
                var sortStatusLabel = headerCell.querySelector(_constants__WEBPACK_IMPORTED_MODULE_2__.selectors.SORT_STATUS_LABEL);
                if (!sortStatusLabel)
                    return;
                sortStatusLabel.textContent =
                    _this.getSortStatusMessageBySortValue(sortValue);
            },
        };
        return new _foundation__WEBPACK_IMPORTED_MODULE_4__.MDCDataTableFoundation(adapter);
    };
    MDCDataTable.prototype.getRowByIndex = function (index) {
        return this.getRows()[index];
    };
    MDCDataTable.prototype.getRowIdByIndex = function (index) {
        return this.getRowByIndex(index).getAttribute(_constants__WEBPACK_IMPORTED_MODULE_2__.dataAttributes.ROW_ID);
    };
    MDCDataTable.prototype.handleHeaderRowClick = function (event) {
        var headerCell = (0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_3__.closest)(event.target, _constants__WEBPACK_IMPORTED_MODULE_2__.selectors.HEADER_CELL_WITH_SORT);
        if (!headerCell) {
            return;
        }
        var columnId = headerCell.getAttribute(_constants__WEBPACK_IMPORTED_MODULE_2__.dataAttributes.COLUMN_ID);
        var columnIndex = this.getHeaderCells().indexOf(headerCell);
        if (columnIndex === -1) {
            return;
        }
        this.foundation.handleSortAction({ columnId: columnId, columnIndex: columnIndex, headerCell: headerCell });
    };
    MDCDataTable.prototype.getSortStatusMessageBySortValue = function (sortValue) {
        switch (sortValue) {
            case _constants__WEBPACK_IMPORTED_MODULE_2__.SortValue.ASCENDING:
                return _constants__WEBPACK_IMPORTED_MODULE_2__.messages.SORTED_IN_ASCENDING;
            case _constants__WEBPACK_IMPORTED_MODULE_2__.SortValue.DESCENDING:
                return _constants__WEBPACK_IMPORTED_MODULE_2__.messages.SORTED_IN_DESCENDING;
            default:
                return '';
        }
    };
    MDCDataTable.prototype.getLinearProgressElement = function () {
        var el = this.root.querySelector("." + _constants__WEBPACK_IMPORTED_MODULE_2__.cssClasses.LINEAR_PROGRESS);
        if (!el) {
            throw new Error('MDCDataTable: linear progress element is not found.');
        }
        return el;
    };
    MDCDataTable.prototype.getLinearProgress = function () {
        if (!this.linearProgress) {
            var el = this.getLinearProgressElement();
            this.linearProgress = new _material_linear_progress_component__WEBPACK_IMPORTED_MODULE_5__.MDCLinearProgress(el);
        }
        return this.linearProgress;
    };
    return MDCDataTable;
}(_material_base_component__WEBPACK_IMPORTED_MODULE_6__.MDCComponent));

//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/data-table/constants.js":
/*!********************************************************!*\
  !*** ./node_modules/@material/data-table/constants.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cssClasses": () => (/* binding */ cssClasses),
/* harmony export */   "attributes": () => (/* binding */ attributes),
/* harmony export */   "dataAttributes": () => (/* binding */ dataAttributes),
/* harmony export */   "selectors": () => (/* binding */ selectors),
/* harmony export */   "messages": () => (/* binding */ messages),
/* harmony export */   "strings": () => (/* binding */ strings),
/* harmony export */   "SortValue": () => (/* binding */ SortValue),
/* harmony export */   "events": () => (/* binding */ events)
/* harmony export */ });
/**
 * @license
 * Copyright 2019 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 * CSS class names used in component.
 */
var cssClasses = {
    CELL: 'mdc-data-table__cell',
    CELL_NUMERIC: 'mdc-data-table__cell--numeric',
    CONTENT: 'mdc-data-table__content',
    HEADER_CELL: 'mdc-data-table__header-cell',
    HEADER_CELL_LABEL: 'mdc-data-table__header-cell-label',
    HEADER_CELL_SORTED: 'mdc-data-table__header-cell--sorted',
    HEADER_CELL_SORTED_DESCENDING: 'mdc-data-table__header-cell--sorted-descending',
    HEADER_CELL_WITH_SORT: 'mdc-data-table__header-cell--with-sort',
    HEADER_CELL_WRAPPER: 'mdc-data-table__header-cell-wrapper',
    HEADER_ROW: 'mdc-data-table__header-row',
    HEADER_ROW_CHECKBOX: 'mdc-data-table__header-row-checkbox',
    IN_PROGRESS: 'mdc-data-table--in-progress',
    LINEAR_PROGRESS: 'mdc-data-table__linear-progress',
    PAGINATION_ROWS_PER_PAGE_LABEL: 'mdc-data-table__pagination-rows-per-page-label',
    PAGINATION_ROWS_PER_PAGE_SELECT: 'mdc-data-table__pagination-rows-per-page-select',
    PROGRESS_INDICATOR: 'mdc-data-table__progress-indicator',
    ROOT: 'mdc-data-table',
    ROW: 'mdc-data-table__row',
    ROW_CHECKBOX: 'mdc-data-table__row-checkbox',
    ROW_SELECTED: 'mdc-data-table__row--selected',
    SORT_ICON_BUTTON: 'mdc-data-table__sort-icon-button',
    SORT_STATUS_LABEL: 'mdc-data-table__sort-status-label',
    TABLE_CONTAINER: 'mdc-data-table__table-container',
};
/**
 * DOM attributes used in component.
 */
var attributes = {
    ARIA_SELECTED: 'aria-selected',
    ARIA_SORT: 'aria-sort',
};
/**
 * List of data attributes used in component.
 */
var dataAttributes = {
    COLUMN_ID: 'data-column-id',
    ROW_ID: 'data-row-id',
};
/**
 * CSS selectors used in component.
 */
var selectors = {
    CONTENT: "." + cssClasses.CONTENT,
    HEADER_CELL: "." + cssClasses.HEADER_CELL,
    HEADER_CELL_WITH_SORT: "." + cssClasses.HEADER_CELL_WITH_SORT,
    HEADER_ROW: "." + cssClasses.HEADER_ROW,
    HEADER_ROW_CHECKBOX: "." + cssClasses.HEADER_ROW_CHECKBOX,
    PROGRESS_INDICATOR: "." + cssClasses.PROGRESS_INDICATOR,
    ROW: "." + cssClasses.ROW,
    ROW_CHECKBOX: "." + cssClasses.ROW_CHECKBOX,
    ROW_SELECTED: "." + cssClasses.ROW_SELECTED,
    SORT_ICON_BUTTON: "." + cssClasses.SORT_ICON_BUTTON,
    SORT_STATUS_LABEL: "." + cssClasses.SORT_STATUS_LABEL,
};
/**
 * Messages used in component.
 */
var messages = {
    SORTED_IN_DESCENDING: 'Sorted in descending order',
    SORTED_IN_ASCENDING: 'Sorted in ascending order',
};
/**
 * Attributes and selectors used in component.
 * @deprecated Use `attributes`, `dataAttributes` and `selectors` instead.
 */
var strings = {
    ARIA_SELECTED: attributes.ARIA_SELECTED,
    ARIA_SORT: attributes.ARIA_SORT,
    DATA_ROW_ID_ATTR: dataAttributes.ROW_ID,
    HEADER_ROW_CHECKBOX_SELECTOR: selectors.HEADER_ROW_CHECKBOX,
    ROW_CHECKBOX_SELECTOR: selectors.ROW_CHECKBOX,
    ROW_SELECTED_SELECTOR: selectors.ROW_SELECTED,
    ROW_SELECTOR: selectors.ROW,
};
/**
 * Sort values defined by ARIA.
 * See https://www.w3.org/WAI/PF/aria/states_and_properties#aria-sort
 */
var SortValue;
(function (SortValue) {
    // Items are sorted in ascending order by this column.
    SortValue["ASCENDING"] = "ascending";
    // Items are sorted in descending order by this column.
    SortValue["DESCENDING"] = "descending";
    // There is no defined sort applied to the column.
    SortValue["NONE"] = "none";
    // A sort algorithm other than ascending or descending has been applied.
    SortValue["OTHER"] = "other";
})(SortValue || (SortValue = {}));
/**
 * Event names used in component.
 */
var events = {
    ROW_SELECTION_CHANGED: 'MDCDataTable:rowSelectionChanged',
    SELECTED_ALL: 'MDCDataTable:selectedAll',
    UNSELECTED_ALL: 'MDCDataTable:unselectedAll',
    SORTED: 'MDCDataTable:sorted',
};
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@material/data-table/foundation.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material/data-table/foundation.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCDataTableFoundation": () => (/* binding */ MDCDataTableFoundation)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_foundation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/base/foundation */ "./node_modules/@material/base/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/data-table/constants.js");
/**
 * @license
 * Copyright 2019 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



/**
 * The Foundation of data table component containing pure business logic, any
 * logic requiring DOM manipulation are delegated to adapter methods.
 */
var MDCDataTableFoundation = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCDataTableFoundation, _super);
    function MDCDataTableFoundation(adapter) {
        return _super.call(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, MDCDataTableFoundation.defaultAdapter), adapter)) || this;
    }
    Object.defineProperty(MDCDataTableFoundation, "defaultAdapter", {
        get: function () {
            return {
                addClass: function () { return undefined; },
                addClassAtRowIndex: function () { return undefined; },
                getAttributeByHeaderCellIndex: function () { return ''; },
                getHeaderCellCount: function () { return 0; },
                getHeaderCellElements: function () { return []; },
                getRowCount: function () { return 0; },
                getRowElements: function () { return []; },
                getRowIdAtIndex: function () { return ''; },
                getRowIndexByChildElement: function () { return 0; },
                getSelectedRowCount: function () { return 0; },
                getTableContainerHeight: function () { return 0; },
                getTableHeaderHeight: function () { return 0; },
                isCheckboxAtRowIndexChecked: function () { return false; },
                isHeaderRowCheckboxChecked: function () { return false; },
                isRowsSelectable: function () { return false; },
                notifyRowSelectionChanged: function () { return undefined; },
                notifySelectedAll: function () { return undefined; },
                notifySortAction: function () { return undefined; },
                notifyUnselectedAll: function () { return undefined; },
                registerHeaderRowCheckbox: function () { return undefined; },
                registerRowCheckboxes: function () { return undefined; },
                removeClass: function () { return undefined; },
                removeClassAtRowIndex: function () { return undefined; },
                removeClassNameByHeaderCellIndex: function () { return undefined; },
                setAttributeAtRowIndex: function () { return undefined; },
                setAttributeByHeaderCellIndex: function () { return undefined; },
                setClassNameByHeaderCellIndex: function () { return undefined; },
                setHeaderRowCheckboxChecked: function () { return undefined; },
                setHeaderRowCheckboxIndeterminate: function () { return undefined; },
                setProgressIndicatorStyles: function () { return undefined; },
                setRowCheckboxCheckedAtIndex: function () { return undefined; },
                setSortStatusLabelByHeaderCellIndex: function () { return undefined; },
            };
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Re-initializes header row checkbox and row checkboxes when selectable rows are added or removed from table.
     * Use this if registering checkbox is synchronous.
     */
    MDCDataTableFoundation.prototype.layout = function () {
        if (this.adapter.isRowsSelectable()) {
            this.adapter.registerHeaderRowCheckbox();
            this.adapter.registerRowCheckboxes();
            this.setHeaderRowCheckboxState();
        }
    };
    /**
     * Re-initializes header row checkbox and row checkboxes when selectable rows are added or removed from table.
     * Use this if registering checkbox is asynchronous.
     */
    MDCDataTableFoundation.prototype.layoutAsync = function () {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__awaiter)(this, void 0, void 0, function () {
            return (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__generator)(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.adapter.isRowsSelectable()) return [3 /*break*/, 3];
                        return [4 /*yield*/, this.adapter.registerHeaderRowCheckbox()];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this.adapter.registerRowCheckboxes()];
                    case 2:
                        _a.sent();
                        this.setHeaderRowCheckboxState();
                        _a.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * @return Returns array of row elements.
     */
    MDCDataTableFoundation.prototype.getRows = function () {
        return this.adapter.getRowElements();
    };
    /**
     * @return Array of header cell elements.
     */
    MDCDataTableFoundation.prototype.getHeaderCells = function () {
        return this.adapter.getHeaderCellElements();
    };
    /**
     * Sets selected row ids. Overwrites previously selected rows.
     * @param rowIds Array of row ids that needs to be selected.
     */
    MDCDataTableFoundation.prototype.setSelectedRowIds = function (rowIds) {
        for (var rowIndex = 0; rowIndex < this.adapter.getRowCount(); rowIndex++) {
            var rowId = this.adapter.getRowIdAtIndex(rowIndex);
            var isSelected = false;
            if (rowId && rowIds.indexOf(rowId) >= 0) {
                isSelected = true;
            }
            this.adapter.setRowCheckboxCheckedAtIndex(rowIndex, isSelected);
            this.selectRowAtIndex(rowIndex, isSelected);
        }
        this.setHeaderRowCheckboxState();
    };
    /**
     * @return Returns array of all row ids.
     */
    MDCDataTableFoundation.prototype.getRowIds = function () {
        var rowIds = [];
        for (var rowIndex = 0; rowIndex < this.adapter.getRowCount(); rowIndex++) {
            rowIds.push(this.adapter.getRowIdAtIndex(rowIndex));
        }
        return rowIds;
    };
    /**
     * @return Returns array of selected row ids.
     */
    MDCDataTableFoundation.prototype.getSelectedRowIds = function () {
        var selectedRowIds = [];
        for (var rowIndex = 0; rowIndex < this.adapter.getRowCount(); rowIndex++) {
            if (this.adapter.isCheckboxAtRowIndexChecked(rowIndex)) {
                selectedRowIds.push(this.adapter.getRowIdAtIndex(rowIndex));
            }
        }
        return selectedRowIds;
    };
    /**
     * Handles header row checkbox change event.
     */
    MDCDataTableFoundation.prototype.handleHeaderRowCheckboxChange = function () {
        var isHeaderChecked = this.adapter.isHeaderRowCheckboxChecked();
        for (var rowIndex = 0; rowIndex < this.adapter.getRowCount(); rowIndex++) {
            this.adapter.setRowCheckboxCheckedAtIndex(rowIndex, isHeaderChecked);
            this.selectRowAtIndex(rowIndex, isHeaderChecked);
        }
        if (isHeaderChecked) {
            this.adapter.notifySelectedAll();
        }
        else {
            this.adapter.notifyUnselectedAll();
        }
    };
    /**
     * Handles change event originated from row checkboxes.
     */
    MDCDataTableFoundation.prototype.handleRowCheckboxChange = function (event) {
        var rowIndex = this.adapter.getRowIndexByChildElement(event.target);
        if (rowIndex === -1) {
            return;
        }
        var selected = this.adapter.isCheckboxAtRowIndexChecked(rowIndex);
        this.selectRowAtIndex(rowIndex, selected);
        this.setHeaderRowCheckboxState();
        var rowId = this.adapter.getRowIdAtIndex(rowIndex);
        this.adapter.notifyRowSelectionChanged({ rowId: rowId, rowIndex: rowIndex, selected: selected });
    };
    /**
     * Handles sort action on sortable header cell.
     */
    MDCDataTableFoundation.prototype.handleSortAction = function (eventData) {
        var columnId = eventData.columnId, columnIndex = eventData.columnIndex, headerCell = eventData.headerCell;
        // Reset sort attributes / classes on other header cells.
        for (var index = 0; index < this.adapter.getHeaderCellCount(); index++) {
            if (index === columnIndex) {
                continue;
            }
            this.adapter.removeClassNameByHeaderCellIndex(index, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.HEADER_CELL_SORTED);
            this.adapter.removeClassNameByHeaderCellIndex(index, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.HEADER_CELL_SORTED_DESCENDING);
            this.adapter.setAttributeByHeaderCellIndex(index, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_SORT, _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.NONE);
            this.adapter.setSortStatusLabelByHeaderCellIndex(index, _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.NONE);
        }
        // Set appropriate sort attributes / classes on target header cell.
        this.adapter.setClassNameByHeaderCellIndex(columnIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.HEADER_CELL_SORTED);
        var currentSortValue = this.adapter.getAttributeByHeaderCellIndex(columnIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_SORT);
        var sortValue = _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.NONE;
        // Set to descending if sorted on ascending order.
        if (currentSortValue === _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.ASCENDING) {
            this.adapter.setClassNameByHeaderCellIndex(columnIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.HEADER_CELL_SORTED_DESCENDING);
            this.adapter.setAttributeByHeaderCellIndex(columnIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_SORT, _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.DESCENDING);
            sortValue = _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.DESCENDING;
            // Set to ascending if sorted on descending order.
        }
        else if (currentSortValue === _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.DESCENDING) {
            this.adapter.removeClassNameByHeaderCellIndex(columnIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.HEADER_CELL_SORTED_DESCENDING);
            this.adapter.setAttributeByHeaderCellIndex(columnIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_SORT, _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.ASCENDING);
            sortValue = _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.ASCENDING;
        }
        else {
            // Set to ascending by default when not sorted.
            this.adapter.setAttributeByHeaderCellIndex(columnIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_SORT, _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.ASCENDING);
            sortValue = _constants__WEBPACK_IMPORTED_MODULE_1__.SortValue.ASCENDING;
        }
        this.adapter.setSortStatusLabelByHeaderCellIndex(columnIndex, sortValue);
        this.adapter.notifySortAction({
            columnId: columnId,
            columnIndex: columnIndex,
            headerCell: headerCell,
            sortValue: sortValue,
        });
    };
    /**
     * Shows progress indicator blocking only the table body content when in
     * loading state.
     */
    MDCDataTableFoundation.prototype.showProgress = function () {
        var tableHeaderHeight = this.adapter.getTableHeaderHeight();
        // Calculate the height of table content (Not scroll content) excluding
        // header row height.
        var height = this.adapter.getTableContainerHeight() - tableHeaderHeight;
        var top = tableHeaderHeight;
        this.adapter.setProgressIndicatorStyles({
            height: height + "px",
            top: top + "px",
        });
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.IN_PROGRESS);
    };
    /**
     * Hides progress indicator when data table is finished loading.
     */
    MDCDataTableFoundation.prototype.hideProgress = function () {
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.IN_PROGRESS);
    };
    /**
     * Updates header row checkbox state based on number of rows selected.
     */
    MDCDataTableFoundation.prototype.setHeaderRowCheckboxState = function () {
        if (this.adapter.getSelectedRowCount() === 0) {
            this.adapter.setHeaderRowCheckboxChecked(false);
            this.adapter.setHeaderRowCheckboxIndeterminate(false);
        }
        else if (this.adapter.getSelectedRowCount() === this.adapter.getRowCount()) {
            this.adapter.setHeaderRowCheckboxChecked(true);
            this.adapter.setHeaderRowCheckboxIndeterminate(false);
        }
        else {
            this.adapter.setHeaderRowCheckboxIndeterminate(true);
            this.adapter.setHeaderRowCheckboxChecked(false);
        }
    };
    /**
     * Sets the attributes of row element based on selection state.
     */
    MDCDataTableFoundation.prototype.selectRowAtIndex = function (rowIndex, selected) {
        if (selected) {
            this.adapter.addClassAtRowIndex(rowIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.ROW_SELECTED);
            this.adapter.setAttributeAtRowIndex(rowIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_SELECTED, 'true');
        }
        else {
            this.adapter.removeClassAtRowIndex(rowIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.ROW_SELECTED);
            this.adapter.setAttributeAtRowIndex(rowIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_SELECTED, 'false');
        }
    };
    return MDCDataTableFoundation;
}(_material_base_foundation__WEBPACK_IMPORTED_MODULE_2__.MDCFoundation));

//# sourceMappingURL=foundation.js.map

/***/ }),

/***/ "./node_modules/@material/data-table/index.js":
/*!****************************************************!*\
  !*** ./node_modules/@material/data-table/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCDataTable": () => (/* reexport safe */ _component__WEBPACK_IMPORTED_MODULE_0__.MDCDataTable),
/* harmony export */   "MDCDataTableFoundation": () => (/* reexport safe */ _foundation__WEBPACK_IMPORTED_MODULE_1__.MDCDataTableFoundation),
/* harmony export */   "SortValue": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.SortValue),
/* harmony export */   "attributes": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.attributes),
/* harmony export */   "cssClasses": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.cssClasses),
/* harmony export */   "dataAttributes": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.dataAttributes),
/* harmony export */   "events": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.events),
/* harmony export */   "messages": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.messages),
/* harmony export */   "selectors": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.selectors),
/* harmony export */   "strings": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.strings)
/* harmony export */ });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./component */ "./node_modules/@material/data-table/component.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/data-table/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/data-table/constants.js");
/**
 * @license
 * Copyright 2019 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@material/dialog/component.js":
/*!****************************************************!*\
  !*** ./node_modules/@material/dialog/component.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCDialog": () => (/* binding */ MDCDialog)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @material/base/component */ "./node_modules/@material/base/component.js");
/* harmony import */ var _material_dom_focus_trap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/dom/focus-trap */ "./node_modules/@material/dom/focus-trap.js");
/* harmony import */ var _material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/dom/ponyfill */ "./node_modules/@material/dom/ponyfill.js");
/* harmony import */ var _material_ripple_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/ripple/component */ "./node_modules/@material/ripple/component.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/dialog/foundation.js");
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./util */ "./node_modules/@material/dialog/util.js");
/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */







var strings = _foundation__WEBPACK_IMPORTED_MODULE_0__.MDCDialogFoundation.strings;
var MDCDialog = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__extends)(MDCDialog, _super);
    function MDCDialog() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(MDCDialog.prototype, "isOpen", {
        get: function () {
            return this.foundation.isOpen();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MDCDialog.prototype, "escapeKeyAction", {
        get: function () {
            return this.foundation.getEscapeKeyAction();
        },
        set: function (action) {
            this.foundation.setEscapeKeyAction(action);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MDCDialog.prototype, "scrimClickAction", {
        get: function () {
            return this.foundation.getScrimClickAction();
        },
        set: function (action) {
            this.foundation.setScrimClickAction(action);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MDCDialog.prototype, "autoStackButtons", {
        get: function () {
            return this.foundation.getAutoStackButtons();
        },
        set: function (autoStack) {
            this.foundation.setAutoStackButtons(autoStack);
        },
        enumerable: false,
        configurable: true
    });
    MDCDialog.attachTo = function (root) {
        return new MDCDialog(root);
    };
    MDCDialog.prototype.initialize = function (focusTrapFactory) {
        var e_1, _a;
        if (focusTrapFactory === void 0) { focusTrapFactory = function (el, focusOptions) { return new _material_dom_focus_trap__WEBPACK_IMPORTED_MODULE_2__.FocusTrap(el, focusOptions); }; }
        var container = this.root.querySelector(strings.CONTAINER_SELECTOR);
        if (!container) {
            throw new Error("Dialog component requires a " + strings.CONTAINER_SELECTOR + " container element");
        }
        this.container = container;
        this.content =
            this.root.querySelector(strings.CONTENT_SELECTOR);
        this.buttons = [].slice.call(this.root.querySelectorAll(strings.BUTTON_SELECTOR));
        this.defaultButton = this.root.querySelector("[" + strings.BUTTON_DEFAULT_ATTRIBUTE + "]");
        this.focusTrapFactory = focusTrapFactory;
        this.buttonRipples = [];
        try {
            for (var _b = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__values)(this.buttons), _c = _b.next(); !_c.done; _c = _b.next()) {
                var buttonEl = _c.value;
                this.buttonRipples.push(new _material_ripple_component__WEBPACK_IMPORTED_MODULE_3__.MDCRipple(buttonEl));
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    MDCDialog.prototype.initialSyncWithDOM = function () {
        var _this = this;
        this.focusTrap = _util__WEBPACK_IMPORTED_MODULE_4__.createFocusTrapInstance(this.container, this.focusTrapFactory, this.getInitialFocusEl() || undefined);
        this.handleClick = this.foundation.handleClick.bind(this.foundation);
        this.handleKeydown = this.foundation.handleKeydown.bind(this.foundation);
        this.handleDocumentKeydown =
            this.foundation.handleDocumentKeydown.bind(this.foundation);
        // this.handleLayout = this.layout.bind(this);
        this.handleOpening = function () {
            document.addEventListener('keydown', _this.handleDocumentKeydown);
        };
        this.handleClosing = function () {
            document.removeEventListener('keydown', _this.handleDocumentKeydown);
        };
        this.listen('click', this.handleClick);
        this.listen('keydown', this.handleKeydown);
        this.listen(strings.OPENING_EVENT, this.handleOpening);
        this.listen(strings.CLOSING_EVENT, this.handleClosing);
    };
    MDCDialog.prototype.destroy = function () {
        this.unlisten('click', this.handleClick);
        this.unlisten('keydown', this.handleKeydown);
        this.unlisten(strings.OPENING_EVENT, this.handleOpening);
        this.unlisten(strings.CLOSING_EVENT, this.handleClosing);
        this.handleClosing();
        this.buttonRipples.forEach(function (ripple) {
            ripple.destroy();
        });
        _super.prototype.destroy.call(this);
    };
    MDCDialog.prototype.layout = function () {
        this.foundation.layout();
    };
    MDCDialog.prototype.open = function () {
        this.foundation.open();
    };
    MDCDialog.prototype.close = function (action) {
        if (action === void 0) { action = ''; }
        this.foundation.close(action);
    };
    MDCDialog.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        var adapter = {
            addBodyClass: function (className) { return document.body.classList.add(className); },
            addClass: function (className) { return _this.root.classList.add(className); },
            areButtonsStacked: function () { return _util__WEBPACK_IMPORTED_MODULE_4__.areTopsMisaligned(_this.buttons); },
            clickDefaultButton: function () {
                if (_this.defaultButton) {
                    _this.defaultButton.click();
                }
            },
            eventTargetMatches: function (target, selector) {
                return target ? (0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_5__.matches)(target, selector) : false;
            },
            getActionFromEvent: function (evt) {
                if (!evt.target) {
                    return '';
                }
                var element = (0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_5__.closest)(evt.target, "[" + strings.ACTION_ATTRIBUTE + "]");
                return element && element.getAttribute(strings.ACTION_ATTRIBUTE);
            },
            getInitialFocusEl: function () { return _this.getInitialFocusEl(); },
            hasClass: function (className) { return _this.root.classList.contains(className); },
            isContentScrollable: function () { return _util__WEBPACK_IMPORTED_MODULE_4__.isScrollable(_this.content); },
            notifyClosed: function (action) { return _this.emit(strings.CLOSED_EVENT, action ? { action: action } : {}); },
            notifyClosing: function (action) { return _this.emit(strings.CLOSING_EVENT, action ? { action: action } : {}); },
            notifyOpened: function () { return _this.emit(strings.OPENED_EVENT, {}); },
            notifyOpening: function () { return _this.emit(strings.OPENING_EVENT, {}); },
            releaseFocus: function () {
                _this.focusTrap.releaseFocus();
            },
            removeBodyClass: function (className) { return document.body.classList.remove(className); },
            removeClass: function (className) { return _this.root.classList.remove(className); },
            reverseButtons: function () {
                _this.buttons.reverse();
                _this.buttons.forEach(function (button) {
                    button.parentElement.appendChild(button);
                });
            },
            trapFocus: function () {
                _this.focusTrap.trapFocus();
            },
            registerContentEventHandler: function (evt, handler) {
                if (_this.content instanceof HTMLElement) {
                    _this.content.addEventListener(evt, handler);
                }
            },
            deregisterContentEventHandler: function (evt, handler) {
                if (_this.content instanceof HTMLElement) {
                    _this.content.removeEventListener(evt, handler);
                }
            },
            isScrollableContentAtTop: function () {
                return _util__WEBPACK_IMPORTED_MODULE_4__.isScrollAtTop(_this.content);
            },
            isScrollableContentAtBottom: function () {
                return _util__WEBPACK_IMPORTED_MODULE_4__.isScrollAtBottom(_this.content);
            },
            registerWindowEventHandler: function (evt, handler) {
                window.addEventListener(evt, handler);
            },
            deregisterWindowEventHandler: function (evt, handler) {
                window.removeEventListener(evt, handler);
            },
        };
        return new _foundation__WEBPACK_IMPORTED_MODULE_0__.MDCDialogFoundation(adapter);
    };
    MDCDialog.prototype.getInitialFocusEl = function () {
        return this.root.querySelector("[" + strings.INITIAL_FOCUS_ATTRIBUTE + "]");
    };
    return MDCDialog;
}(_material_base_component__WEBPACK_IMPORTED_MODULE_6__.MDCComponent));

//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/dialog/constants.js":
/*!****************************************************!*\
  !*** ./node_modules/@material/dialog/constants.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cssClasses": () => (/* binding */ cssClasses),
/* harmony export */   "strings": () => (/* binding */ strings),
/* harmony export */   "numbers": () => (/* binding */ numbers)
/* harmony export */ });
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var cssClasses = {
    CLOSING: 'mdc-dialog--closing',
    OPEN: 'mdc-dialog--open',
    OPENING: 'mdc-dialog--opening',
    SCROLLABLE: 'mdc-dialog--scrollable',
    SCROLL_LOCK: 'mdc-dialog-scroll-lock',
    STACKED: 'mdc-dialog--stacked',
    FULLSCREEN: 'mdc-dialog--fullscreen',
    // Class for showing a scroll divider on full-screen dialog header element.
    // Should only be displayed on scrollable content, when the dialog content is
    // scrolled "underneath" the header.
    SCROLL_DIVIDER_HEADER: 'mdc-dialog-scroll-divider-header',
    // Class for showing a scroll divider on a full-screen dialog footer element.
    // Should only be displayed on scrolalble content, when the dialog content is
    // obscured "underneath" the footer.
    SCROLL_DIVIDER_FOOTER: 'mdc-dialog-scroll-divider-footer',
    // The "surface scrim" is a scrim covering only the surface of a dialog. This
    // is used in situations where a confirmation dialog is shown over an already
    // opened full-screen dialog. On larger screen-sizes, the full-screen dialog
    // is sized as a modal and so in these situations we display a "surface scrim"
    // to prevent a "double scrim" (where the scrim from the secondary
    // confirmation dialog would overlap with the scrim from the full-screen
    // dialog).
    SURFACE_SCRIM_SHOWN: 'mdc-dialog__surface-scrim--shown',
    // "Showing" animating class for the surface-scrim.
    SURFACE_SCRIM_SHOWING: 'mdc-dialog__surface-scrim--showing',
    // "Hiding" animating class for the surface-scrim.
    SURFACE_SCRIM_HIDING: 'mdc-dialog__surface-scrim--hiding',
    // Class to hide a dialog's scrim (used in conjunction with a surface-scrim).
    // Note that we only hide the original scrim rather than removing it entirely
    // to prevent interactions with the content behind this scrim, and to capture
    // scrim clicks.
    SCRIM_HIDDEN: 'mdc-dialog__scrim--hidden',
};
var strings = {
    ACTION_ATTRIBUTE: 'data-mdc-dialog-action',
    BUTTON_DEFAULT_ATTRIBUTE: 'data-mdc-dialog-button-default',
    BUTTON_SELECTOR: '.mdc-dialog__button',
    CLOSED_EVENT: 'MDCDialog:closed',
    CLOSE_ACTION: 'close',
    CLOSING_EVENT: 'MDCDialog:closing',
    CONTAINER_SELECTOR: '.mdc-dialog__container',
    CONTENT_SELECTOR: '.mdc-dialog__content',
    DESTROY_ACTION: 'destroy',
    INITIAL_FOCUS_ATTRIBUTE: 'data-mdc-dialog-initial-focus',
    OPENED_EVENT: 'MDCDialog:opened',
    OPENING_EVENT: 'MDCDialog:opening',
    SCRIM_SELECTOR: '.mdc-dialog__scrim',
    SUPPRESS_DEFAULT_PRESS_SELECTOR: [
        'textarea',
        '.mdc-menu .mdc-list-item',
        '.mdc-menu .mdc-deprecated-list-item',
    ].join(', '),
    SURFACE_SELECTOR: '.mdc-dialog__surface',
};
var numbers = {
    DIALOG_ANIMATION_CLOSE_TIME_MS: 75,
    DIALOG_ANIMATION_OPEN_TIME_MS: 150,
};
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@material/dialog/foundation.js":
/*!*****************************************************!*\
  !*** ./node_modules/@material/dialog/foundation.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCDialogFoundation": () => (/* binding */ MDCDialogFoundation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_animation_animationframe__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/animation/animationframe */ "./node_modules/@material/animation/animationframe.js");
/* harmony import */ var _material_base_foundation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/base/foundation */ "./node_modules/@material/base/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/dialog/constants.js");
/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */




var AnimationKeys;
(function (AnimationKeys) {
    AnimationKeys["POLL_SCROLL_POS"] = "poll_scroll_position";
    AnimationKeys["POLL_LAYOUT_CHANGE"] = "poll_layout_change";
})(AnimationKeys || (AnimationKeys = {}));
var MDCDialogFoundation = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCDialogFoundation, _super);
    function MDCDialogFoundation(adapter) {
        var _this = _super.call(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, MDCDialogFoundation.defaultAdapter), adapter)) || this;
        _this.dialogOpen = false;
        _this.isFullscreen = false;
        _this.animationFrame = 0;
        _this.animationTimer = 0;
        _this.escapeKeyAction = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.CLOSE_ACTION;
        _this.scrimClickAction = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.CLOSE_ACTION;
        _this.autoStackButtons = true;
        _this.areButtonsStacked = false;
        _this.suppressDefaultPressSelector = _constants__WEBPACK_IMPORTED_MODULE_1__.strings.SUPPRESS_DEFAULT_PRESS_SELECTOR;
        _this.animFrame = new _material_animation_animationframe__WEBPACK_IMPORTED_MODULE_2__.AnimationFrame();
        _this.contentScrollHandler = function () {
            _this.handleScrollEvent();
        };
        _this.windowResizeHandler = function () {
            _this.layout();
        };
        _this.windowOrientationChangeHandler = function () {
            _this.layout();
        };
        return _this;
    }
    Object.defineProperty(MDCDialogFoundation, "cssClasses", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MDCDialogFoundation, "strings", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.strings;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MDCDialogFoundation, "numbers", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.numbers;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MDCDialogFoundation, "defaultAdapter", {
        get: function () {
            return {
                addBodyClass: function () { return undefined; },
                addClass: function () { return undefined; },
                areButtonsStacked: function () { return false; },
                clickDefaultButton: function () { return undefined; },
                eventTargetMatches: function () { return false; },
                getActionFromEvent: function () { return ''; },
                getInitialFocusEl: function () { return null; },
                hasClass: function () { return false; },
                isContentScrollable: function () { return false; },
                notifyClosed: function () { return undefined; },
                notifyClosing: function () { return undefined; },
                notifyOpened: function () { return undefined; },
                notifyOpening: function () { return undefined; },
                releaseFocus: function () { return undefined; },
                removeBodyClass: function () { return undefined; },
                removeClass: function () { return undefined; },
                reverseButtons: function () { return undefined; },
                trapFocus: function () { return undefined; },
                registerContentEventHandler: function () { return undefined; },
                deregisterContentEventHandler: function () { return undefined; },
                isScrollableContentAtTop: function () { return false; },
                isScrollableContentAtBottom: function () { return false; },
                registerWindowEventHandler: function () { return undefined; },
                deregisterWindowEventHandler: function () { return undefined; },
            };
        },
        enumerable: false,
        configurable: true
    });
    MDCDialogFoundation.prototype.init = function () {
        if (this.adapter.hasClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.STACKED)) {
            this.setAutoStackButtons(false);
        }
        this.isFullscreen = this.adapter.hasClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.FULLSCREEN);
    };
    MDCDialogFoundation.prototype.destroy = function () {
        if (this.dialogOpen) {
            this.close(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.DESTROY_ACTION);
        }
        if (this.animationTimer) {
            clearTimeout(this.animationTimer);
            this.handleAnimationTimerEnd();
        }
        if (this.isFullscreen) {
            this.adapter.deregisterContentEventHandler('scroll', this.contentScrollHandler);
        }
        this.animFrame.cancelAll();
        this.adapter.deregisterWindowEventHandler('resize', this.windowResizeHandler);
        this.adapter.deregisterWindowEventHandler('orientationchange', this.windowOrientationChangeHandler);
    };
    MDCDialogFoundation.prototype.open = function (dialogOptions) {
        var _this = this;
        this.dialogOpen = true;
        this.adapter.notifyOpening();
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.OPENING);
        if (this.isFullscreen) {
            // A scroll event listener is registered even if the dialog is not
            // scrollable on open, since the window resize event, or orientation
            // change may make the dialog scrollable after it is opened.
            this.adapter.registerContentEventHandler('scroll', this.contentScrollHandler);
        }
        if (dialogOptions && dialogOptions.isAboveFullscreenDialog) {
            this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCRIM_HIDDEN);
        }
        this.adapter.registerWindowEventHandler('resize', this.windowResizeHandler);
        this.adapter.registerWindowEventHandler('orientationchange', this.windowOrientationChangeHandler);
        // Wait a frame once display is no longer "none", to establish basis for
        // animation
        this.runNextAnimationFrame(function () {
            _this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.OPEN);
            _this.adapter.addBodyClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLL_LOCK);
            _this.layout();
            _this.animationTimer = setTimeout(function () {
                _this.handleAnimationTimerEnd();
                _this.adapter.trapFocus(_this.adapter.getInitialFocusEl());
                _this.adapter.notifyOpened();
            }, _constants__WEBPACK_IMPORTED_MODULE_1__.numbers.DIALOG_ANIMATION_OPEN_TIME_MS);
        });
    };
    MDCDialogFoundation.prototype.close = function (action) {
        var _this = this;
        if (action === void 0) { action = ''; }
        if (!this.dialogOpen) {
            // Avoid redundant close calls (and events), e.g. from keydown on elements
            // that inherently emit click
            return;
        }
        this.dialogOpen = false;
        this.adapter.notifyClosing(action);
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.CLOSING);
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.OPEN);
        this.adapter.removeBodyClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLL_LOCK);
        if (this.isFullscreen) {
            this.adapter.deregisterContentEventHandler('scroll', this.contentScrollHandler);
        }
        this.adapter.deregisterWindowEventHandler('resize', this.windowResizeHandler);
        this.adapter.deregisterWindowEventHandler('orientationchange', this.windowOrientationChangeHandler);
        cancelAnimationFrame(this.animationFrame);
        this.animationFrame = 0;
        clearTimeout(this.animationTimer);
        this.animationTimer = setTimeout(function () {
            _this.adapter.releaseFocus();
            _this.handleAnimationTimerEnd();
            _this.adapter.notifyClosed(action);
        }, _constants__WEBPACK_IMPORTED_MODULE_1__.numbers.DIALOG_ANIMATION_CLOSE_TIME_MS);
    };
    /**
     * Used only in instances of showing a secondary dialog over a full-screen
     * dialog. Shows the "surface scrim" displayed over the full-screen dialog.
     */
    MDCDialogFoundation.prototype.showSurfaceScrim = function () {
        var _this = this;
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SURFACE_SCRIM_SHOWING);
        this.runNextAnimationFrame(function () {
            _this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SURFACE_SCRIM_SHOWN);
        });
    };
    /**
     * Used only in instances of showing a secondary dialog over a full-screen
     * dialog. Hides the "surface scrim" displayed over the full-screen dialog.
     */
    MDCDialogFoundation.prototype.hideSurfaceScrim = function () {
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SURFACE_SCRIM_SHOWN);
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SURFACE_SCRIM_HIDING);
    };
    /**
     * Handles `transitionend` event triggered when surface scrim animation is
     * finished.
     */
    MDCDialogFoundation.prototype.handleSurfaceScrimTransitionEnd = function () {
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SURFACE_SCRIM_HIDING);
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SURFACE_SCRIM_SHOWING);
    };
    MDCDialogFoundation.prototype.isOpen = function () {
        return this.dialogOpen;
    };
    MDCDialogFoundation.prototype.getEscapeKeyAction = function () {
        return this.escapeKeyAction;
    };
    MDCDialogFoundation.prototype.setEscapeKeyAction = function (action) {
        this.escapeKeyAction = action;
    };
    MDCDialogFoundation.prototype.getScrimClickAction = function () {
        return this.scrimClickAction;
    };
    MDCDialogFoundation.prototype.setScrimClickAction = function (action) {
        this.scrimClickAction = action;
    };
    MDCDialogFoundation.prototype.getAutoStackButtons = function () {
        return this.autoStackButtons;
    };
    MDCDialogFoundation.prototype.setAutoStackButtons = function (autoStack) {
        this.autoStackButtons = autoStack;
    };
    MDCDialogFoundation.prototype.getSuppressDefaultPressSelector = function () {
        return this.suppressDefaultPressSelector;
    };
    MDCDialogFoundation.prototype.setSuppressDefaultPressSelector = function (selector) {
        this.suppressDefaultPressSelector = selector;
    };
    MDCDialogFoundation.prototype.layout = function () {
        var _this = this;
        this.animFrame.request(AnimationKeys.POLL_LAYOUT_CHANGE, function () {
            _this.layoutInternal();
        });
    };
    /** Handles click on the dialog root element. */
    MDCDialogFoundation.prototype.handleClick = function (evt) {
        var isScrim = this.adapter.eventTargetMatches(evt.target, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.SCRIM_SELECTOR);
        // Check for scrim click first since it doesn't require querying ancestors.
        if (isScrim && this.scrimClickAction !== '') {
            this.close(this.scrimClickAction);
        }
        else {
            var action = this.adapter.getActionFromEvent(evt);
            if (action) {
                this.close(action);
            }
        }
    };
    /** Handles keydown on the dialog root element. */
    MDCDialogFoundation.prototype.handleKeydown = function (evt) {
        var isEnter = evt.key === 'Enter' || evt.keyCode === 13;
        if (!isEnter) {
            return;
        }
        var action = this.adapter.getActionFromEvent(evt);
        if (action) {
            // Action button callback is handled in `handleClick`,
            // since space/enter keydowns on buttons trigger click events.
            return;
        }
        // `composedPath` is used here, when available, to account for use cases
        // where a target meant to suppress the default press behaviour
        // may exist in a shadow root.
        // For example, a textarea inside a web component:
        // <mwc-dialog>
        //   <horizontal-layout>
        //     #shadow-root (open)
        //       <mwc-textarea>
        //         #shadow-root (open)
        //           <textarea></textarea>
        //       </mwc-textarea>
        //   </horizontal-layout>
        // </mwc-dialog>
        var target = evt.composedPath ? evt.composedPath()[0] : evt.target;
        var isDefault = this.suppressDefaultPressSelector ?
            !this.adapter.eventTargetMatches(target, this.suppressDefaultPressSelector) :
            true;
        if (isEnter && isDefault) {
            this.adapter.clickDefaultButton();
        }
    };
    /** Handles keydown on the document. */
    MDCDialogFoundation.prototype.handleDocumentKeydown = function (evt) {
        var isEscape = evt.key === 'Escape' || evt.keyCode === 27;
        if (isEscape && this.escapeKeyAction !== '') {
            this.close(this.escapeKeyAction);
        }
    };
    /**
     * Handles scroll event on the dialog's content element -- showing a scroll
     * divider on the header or footer based on the scroll position. This handler
     * should only be registered on full-screen dialogs with scrollable content.
     */
    MDCDialogFoundation.prototype.handleScrollEvent = function () {
        var _this = this;
        // Since scroll events can fire at a high rate, we throttle these events by
        // using requestAnimationFrame.
        this.animFrame.request(AnimationKeys.POLL_SCROLL_POS, function () {
            _this.toggleScrollDividerHeader();
            _this.toggleScrollDividerFooter();
        });
    };
    MDCDialogFoundation.prototype.layoutInternal = function () {
        if (this.autoStackButtons) {
            this.detectStackedButtons();
        }
        this.toggleScrollableClasses();
    };
    MDCDialogFoundation.prototype.handleAnimationTimerEnd = function () {
        this.animationTimer = 0;
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.OPENING);
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.CLOSING);
    };
    /**
     * Runs the given logic on the next animation frame, using setTimeout to
     * factor in Firefox reflow behavior.
     */
    MDCDialogFoundation.prototype.runNextAnimationFrame = function (callback) {
        var _this = this;
        cancelAnimationFrame(this.animationFrame);
        this.animationFrame = requestAnimationFrame(function () {
            _this.animationFrame = 0;
            clearTimeout(_this.animationTimer);
            _this.animationTimer = setTimeout(callback, 0);
        });
    };
    MDCDialogFoundation.prototype.detectStackedButtons = function () {
        // Remove the class first to let us measure the buttons' natural positions.
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.STACKED);
        var areButtonsStacked = this.adapter.areButtonsStacked();
        if (areButtonsStacked) {
            this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.STACKED);
        }
        if (areButtonsStacked !== this.areButtonsStacked) {
            this.adapter.reverseButtons();
            this.areButtonsStacked = areButtonsStacked;
        }
    };
    MDCDialogFoundation.prototype.toggleScrollableClasses = function () {
        // Remove the class first to let us measure the natural height of the
        // content.
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLLABLE);
        if (this.adapter.isContentScrollable()) {
            this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLLABLE);
            if (this.isFullscreen) {
                // If dialog is full-screen and scrollable, check if a scroll divider
                // should be shown.
                this.toggleScrollDividerHeader();
                this.toggleScrollDividerFooter();
            }
        }
    };
    MDCDialogFoundation.prototype.toggleScrollDividerHeader = function () {
        if (!this.adapter.isScrollableContentAtTop()) {
            this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLL_DIVIDER_HEADER);
        }
        else if (this.adapter.hasClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLL_DIVIDER_HEADER)) {
            this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLL_DIVIDER_HEADER);
        }
    };
    MDCDialogFoundation.prototype.toggleScrollDividerFooter = function () {
        if (!this.adapter.isScrollableContentAtBottom()) {
            this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLL_DIVIDER_FOOTER);
        }
        else if (this.adapter.hasClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLL_DIVIDER_FOOTER)) {
            this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.SCROLL_DIVIDER_FOOTER);
        }
    };
    return MDCDialogFoundation;
}(_material_base_foundation__WEBPACK_IMPORTED_MODULE_3__.MDCFoundation));

// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MDCDialogFoundation);
//# sourceMappingURL=foundation.js.map

/***/ }),

/***/ "./node_modules/@material/dialog/index.js":
/*!************************************************!*\
  !*** ./node_modules/@material/dialog/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "util": () => (/* reexport module object */ _util__WEBPACK_IMPORTED_MODULE_0__),
/* harmony export */   "MDCDialog": () => (/* reexport safe */ _component__WEBPACK_IMPORTED_MODULE_1__.MDCDialog),
/* harmony export */   "cssClasses": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.cssClasses),
/* harmony export */   "numbers": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.numbers),
/* harmony export */   "strings": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_2__.strings),
/* harmony export */   "MDCDialogFoundation": () => (/* reexport safe */ _foundation__WEBPACK_IMPORTED_MODULE_3__.MDCDialogFoundation)
/* harmony export */ });
/* harmony import */ var _util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util */ "./node_modules/@material/dialog/util.js");
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./component */ "./node_modules/@material/dialog/component.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/dialog/constants.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/dialog/foundation.js");
/**
 * @license
 * Copyright 2019 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */







//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@material/dialog/util.js":
/*!***********************************************!*\
  !*** ./node_modules/@material/dialog/util.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createFocusTrapInstance": () => (/* binding */ createFocusTrapInstance),
/* harmony export */   "isScrollable": () => (/* binding */ isScrollable),
/* harmony export */   "isScrollAtTop": () => (/* binding */ isScrollAtTop),
/* harmony export */   "isScrollAtBottom": () => (/* binding */ isScrollAtBottom),
/* harmony export */   "areTopsMisaligned": () => (/* binding */ areTopsMisaligned)
/* harmony export */ });
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
function createFocusTrapInstance(surfaceEl, focusTrapFactory, initialFocusEl) {
    return focusTrapFactory(surfaceEl, { initialFocusEl: initialFocusEl });
}
function isScrollable(el) {
    return el ? el.scrollHeight > el.offsetHeight : false;
}
/**
 * For scrollable content, returns true if the content has not been scrolled
 * (that is, the scroll content is as the "top"). This is used in full-screen
 * dialogs, where the scroll divider is expected only to appear once the
 * content has been scrolled "underneath" the header bar.
 */
function isScrollAtTop(el) {
    return el ? el.scrollTop === 0 : false;
}
/**
 * For scrollable content, returns true if the content has been scrolled all the
 * way to the bottom. This is used in full-screen dialogs, where the footer
 * scroll divider is expected only to appear when the content is "cut-off" by
 * the footer bar.
 */
function isScrollAtBottom(el) {
    return el ? Math.ceil(el.scrollHeight - el.scrollTop) === el.clientHeight :
        false;
}
function areTopsMisaligned(els) {
    var tops = new Set();
    [].forEach.call(els, function (el) { return tops.add(el.offsetTop); });
    return tops.size > 1;
}
//# sourceMappingURL=util.js.map

/***/ }),

/***/ "./node_modules/@material/dom/events.js":
/*!**********************************************!*\
  !*** ./node_modules/@material/dom/events.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "applyPassive": () => (/* binding */ applyPassive)
/* harmony export */ });
/**
 * @license
 * Copyright 2019 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 * Determine whether the current browser supports passive event listeners, and
 * if so, use them.
 */
function applyPassive(globalObj) {
    if (globalObj === void 0) { globalObj = window; }
    return supportsPassiveOption(globalObj) ?
        { passive: true } :
        false;
}
function supportsPassiveOption(globalObj) {
    if (globalObj === void 0) { globalObj = window; }
    // See
    // https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener
    var passiveSupported = false;
    try {
        var options = {
            // This function will be called when the browser
            // attempts to access the passive property.
            get passive() {
                passiveSupported = true;
                return false;
            }
        };
        var handler = function () { };
        globalObj.document.addEventListener('test', handler, options);
        globalObj.document.removeEventListener('test', handler, options);
    }
    catch (err) {
        passiveSupported = false;
    }
    return passiveSupported;
}
//# sourceMappingURL=events.js.map

/***/ }),

/***/ "./node_modules/@material/dom/focus-trap.js":
/*!**************************************************!*\
  !*** ./node_modules/@material/dom/focus-trap.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FocusTrap": () => (/* binding */ FocusTrap)
/* harmony export */ });
/**
 * @license
 * Copyright 2020 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var FOCUS_SENTINEL_CLASS = 'mdc-dom-focus-sentinel';
/**
 * Utility to trap focus in a given root element, e.g. for modal components such
 * as dialogs. The root should have at least one focusable child element,
 * for setting initial focus when trapping focus.
 * Also tracks the previously focused element, and restores focus to that
 * element when releasing focus.
 */
var FocusTrap = /** @class */ (function () {
    function FocusTrap(root, options) {
        if (options === void 0) { options = {}; }
        this.root = root;
        this.options = options;
        // Previously focused element before trapping focus.
        this.elFocusedBeforeTrapFocus = null;
    }
    /**
     * Traps focus in `root`. Also focuses on either `initialFocusEl` if set;
     * otherwises sets initial focus to the first focusable child element.
     */
    FocusTrap.prototype.trapFocus = function () {
        var focusableEls = this.getFocusableElements(this.root);
        if (focusableEls.length === 0) {
            throw new Error('FocusTrap: Element must have at least one focusable child.');
        }
        this.elFocusedBeforeTrapFocus =
            document.activeElement instanceof HTMLElement ? document.activeElement :
                null;
        this.wrapTabFocus(this.root, focusableEls);
        if (!this.options.skipInitialFocus) {
            this.focusInitialElement(focusableEls, this.options.initialFocusEl);
        }
    };
    /**
     * Releases focus from `root`. Also restores focus to the previously focused
     * element.
     */
    FocusTrap.prototype.releaseFocus = function () {
        [].slice.call(this.root.querySelectorAll("." + FOCUS_SENTINEL_CLASS))
            .forEach(function (sentinelEl) {
            sentinelEl.parentElement.removeChild(sentinelEl);
        });
        if (this.elFocusedBeforeTrapFocus) {
            this.elFocusedBeforeTrapFocus.focus();
        }
    };
    /**
     * Wraps tab focus within `el` by adding two hidden sentinel divs which are
     * used to mark the beginning and the end of the tabbable region. When
     * focused, these sentinel elements redirect focus to the first/last
     * children elements of the tabbable region, ensuring that focus is trapped
     * within that region.
     */
    FocusTrap.prototype.wrapTabFocus = function (el, focusableEls) {
        var sentinelStart = this.createSentinel();
        var sentinelEnd = this.createSentinel();
        sentinelStart.addEventListener('focus', function () {
            if (focusableEls.length > 0) {
                focusableEls[focusableEls.length - 1].focus();
            }
        });
        sentinelEnd.addEventListener('focus', function () {
            if (focusableEls.length > 0) {
                focusableEls[0].focus();
            }
        });
        el.insertBefore(sentinelStart, el.children[0]);
        el.appendChild(sentinelEnd);
    };
    /**
     * Focuses on `initialFocusEl` if defined and a child of the root element.
     * Otherwise, focuses on the first focusable child element of the root.
     */
    FocusTrap.prototype.focusInitialElement = function (focusableEls, initialFocusEl) {
        var focusIndex = 0;
        if (initialFocusEl) {
            focusIndex = Math.max(focusableEls.indexOf(initialFocusEl), 0);
        }
        focusableEls[focusIndex].focus();
    };
    FocusTrap.prototype.getFocusableElements = function (root) {
        var focusableEls = [].slice.call(root.querySelectorAll('[autofocus], [tabindex], a, input, textarea, select, button'));
        return focusableEls.filter(function (el) {
            var isDisabledOrHidden = el.getAttribute('aria-disabled') === 'true' ||
                el.getAttribute('disabled') != null ||
                el.getAttribute('hidden') != null ||
                el.getAttribute('aria-hidden') === 'true';
            var isTabbableAndVisible = el.tabIndex >= 0 &&
                el.getBoundingClientRect().width > 0 &&
                !el.classList.contains(FOCUS_SENTINEL_CLASS) && !isDisabledOrHidden;
            var isProgrammaticallyHidden = false;
            if (isTabbableAndVisible) {
                var style = getComputedStyle(el);
                isProgrammaticallyHidden =
                    style.display === 'none' || style.visibility === 'hidden';
            }
            return isTabbableAndVisible && !isProgrammaticallyHidden;
        });
    };
    FocusTrap.prototype.createSentinel = function () {
        var sentinel = document.createElement('div');
        sentinel.setAttribute('tabindex', '0');
        // Don't announce in screen readers.
        sentinel.setAttribute('aria-hidden', 'true');
        sentinel.classList.add(FOCUS_SENTINEL_CLASS);
        return sentinel;
    };
    return FocusTrap;
}());

//# sourceMappingURL=focus-trap.js.map

/***/ }),

/***/ "./node_modules/@material/dom/keyboard.js":
/*!************************************************!*\
  !*** ./node_modules/@material/dom/keyboard.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "KEY": () => (/* binding */ KEY),
/* harmony export */   "normalizeKey": () => (/* binding */ normalizeKey),
/* harmony export */   "isNavigationEvent": () => (/* binding */ isNavigationEvent)
/* harmony export */ });
/**
 * @license
 * Copyright 2020 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 * KEY provides normalized string values for keys.
 */
var KEY = {
    UNKNOWN: 'Unknown',
    BACKSPACE: 'Backspace',
    ENTER: 'Enter',
    SPACEBAR: 'Spacebar',
    PAGE_UP: 'PageUp',
    PAGE_DOWN: 'PageDown',
    END: 'End',
    HOME: 'Home',
    ARROW_LEFT: 'ArrowLeft',
    ARROW_UP: 'ArrowUp',
    ARROW_RIGHT: 'ArrowRight',
    ARROW_DOWN: 'ArrowDown',
    DELETE: 'Delete',
    ESCAPE: 'Escape',
};
var normalizedKeys = new Set();
// IE11 has no support for new Map with iterable so we need to initialize this
// by hand.
normalizedKeys.add(KEY.BACKSPACE);
normalizedKeys.add(KEY.ENTER);
normalizedKeys.add(KEY.SPACEBAR);
normalizedKeys.add(KEY.PAGE_UP);
normalizedKeys.add(KEY.PAGE_DOWN);
normalizedKeys.add(KEY.END);
normalizedKeys.add(KEY.HOME);
normalizedKeys.add(KEY.ARROW_LEFT);
normalizedKeys.add(KEY.ARROW_UP);
normalizedKeys.add(KEY.ARROW_RIGHT);
normalizedKeys.add(KEY.ARROW_DOWN);
normalizedKeys.add(KEY.DELETE);
normalizedKeys.add(KEY.ESCAPE);
var KEY_CODE = {
    BACKSPACE: 8,
    ENTER: 13,
    SPACEBAR: 32,
    PAGE_UP: 33,
    PAGE_DOWN: 34,
    END: 35,
    HOME: 36,
    ARROW_LEFT: 37,
    ARROW_UP: 38,
    ARROW_RIGHT: 39,
    ARROW_DOWN: 40,
    DELETE: 46,
    ESCAPE: 27,
};
var mappedKeyCodes = new Map();
// IE11 has no support for new Map with iterable so we need to initialize this
// by hand.
mappedKeyCodes.set(KEY_CODE.BACKSPACE, KEY.BACKSPACE);
mappedKeyCodes.set(KEY_CODE.ENTER, KEY.ENTER);
mappedKeyCodes.set(KEY_CODE.SPACEBAR, KEY.SPACEBAR);
mappedKeyCodes.set(KEY_CODE.PAGE_UP, KEY.PAGE_UP);
mappedKeyCodes.set(KEY_CODE.PAGE_DOWN, KEY.PAGE_DOWN);
mappedKeyCodes.set(KEY_CODE.END, KEY.END);
mappedKeyCodes.set(KEY_CODE.HOME, KEY.HOME);
mappedKeyCodes.set(KEY_CODE.ARROW_LEFT, KEY.ARROW_LEFT);
mappedKeyCodes.set(KEY_CODE.ARROW_UP, KEY.ARROW_UP);
mappedKeyCodes.set(KEY_CODE.ARROW_RIGHT, KEY.ARROW_RIGHT);
mappedKeyCodes.set(KEY_CODE.ARROW_DOWN, KEY.ARROW_DOWN);
mappedKeyCodes.set(KEY_CODE.DELETE, KEY.DELETE);
mappedKeyCodes.set(KEY_CODE.ESCAPE, KEY.ESCAPE);
var navigationKeys = new Set();
// IE11 has no support for new Set with iterable so we need to initialize this
// by hand.
navigationKeys.add(KEY.PAGE_UP);
navigationKeys.add(KEY.PAGE_DOWN);
navigationKeys.add(KEY.END);
navigationKeys.add(KEY.HOME);
navigationKeys.add(KEY.ARROW_LEFT);
navigationKeys.add(KEY.ARROW_UP);
navigationKeys.add(KEY.ARROW_RIGHT);
navigationKeys.add(KEY.ARROW_DOWN);
/**
 * normalizeKey returns the normalized string for a navigational action.
 */
function normalizeKey(evt) {
    var key = evt.key;
    // If the event already has a normalized key, return it
    if (normalizedKeys.has(key)) {
        return key;
    }
    // tslint:disable-next-line:deprecation
    var mappedKey = mappedKeyCodes.get(evt.keyCode);
    if (mappedKey) {
        return mappedKey;
    }
    return KEY.UNKNOWN;
}
/**
 * isNavigationEvent returns whether the event is a navigation event
 */
function isNavigationEvent(evt) {
    return navigationKeys.has(normalizeKey(evt));
}
//# sourceMappingURL=keyboard.js.map

/***/ }),

/***/ "./node_modules/@material/dom/ponyfill.js":
/*!************************************************!*\
  !*** ./node_modules/@material/dom/ponyfill.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "closest": () => (/* binding */ closest),
/* harmony export */   "matches": () => (/* binding */ matches),
/* harmony export */   "estimateScrollWidth": () => (/* binding */ estimateScrollWidth)
/* harmony export */ });
/**
 * @license
 * Copyright 2018 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 * @fileoverview A "ponyfill" is a polyfill that doesn't modify the global prototype chain.
 * This makes ponyfills safer than traditional polyfills, especially for libraries like MDC.
 */
function closest(element, selector) {
    if (element.closest) {
        return element.closest(selector);
    }
    var el = element;
    while (el) {
        if (matches(el, selector)) {
            return el;
        }
        el = el.parentElement;
    }
    return null;
}
function matches(element, selector) {
    var nativeMatches = element.matches
        || element.webkitMatchesSelector
        || element.msMatchesSelector;
    return nativeMatches.call(element, selector);
}
/**
 * Used to compute the estimated scroll width of elements. When an element is
 * hidden due to display: none; being applied to a parent element, the width is
 * returned as 0. However, the element will have a true width once no longer
 * inside a display: none context. This method computes an estimated width when
 * the element is hidden or returns the true width when the element is visble.
 * @param {Element} element the element whose width to estimate
 */
function estimateScrollWidth(element) {
    // Check the offsetParent. If the element inherits display: none from any
    // parent, the offsetParent property will be null (see
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/offsetParent).
    // This check ensures we only clone the node when necessary.
    var htmlEl = element;
    if (htmlEl.offsetParent !== null) {
        return htmlEl.scrollWidth;
    }
    var clone = htmlEl.cloneNode(true);
    clone.style.setProperty('position', 'absolute');
    clone.style.setProperty('transform', 'translate(-9999px, -9999px)');
    document.documentElement.appendChild(clone);
    var scrollWidth = clone.scrollWidth;
    document.documentElement.removeChild(clone);
    return scrollWidth;
}
//# sourceMappingURL=ponyfill.js.map

/***/ }),

/***/ "./node_modules/@material/floating-label/component.js":
/*!************************************************************!*\
  !*** ./node_modules/@material/floating-label/component.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCFloatingLabel": () => (/* binding */ MDCFloatingLabel)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/base/component */ "./node_modules/@material/base/component.js");
/* harmony import */ var _material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @material/dom/ponyfill */ "./node_modules/@material/dom/ponyfill.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/floating-label/foundation.js");
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */




var MDCFloatingLabel = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCFloatingLabel, _super);
    function MDCFloatingLabel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MDCFloatingLabel.attachTo = function (root) {
        return new MDCFloatingLabel(root);
    };
    /**
     * Styles the label to produce the label shake for errors.
     * @param shouldShake If true, shakes the label by adding a CSS class; otherwise, stops shaking by removing the class.
     */
    MDCFloatingLabel.prototype.shake = function (shouldShake) {
        this.foundation.shake(shouldShake);
    };
    /**
     * Styles the label to float/dock.
     * @param shouldFloat If true, floats the label by adding a CSS class; otherwise, docks it by removing the class.
     */
    MDCFloatingLabel.prototype.float = function (shouldFloat) {
        this.foundation.float(shouldFloat);
    };
    /**
     * Styles the label as required.
     * @param isRequired If true, adds an asterisk to the label, indicating that it is required.
     */
    MDCFloatingLabel.prototype.setRequired = function (isRequired) {
        this.foundation.setRequired(isRequired);
    };
    MDCFloatingLabel.prototype.getWidth = function () {
        return this.foundation.getWidth();
    };
    MDCFloatingLabel.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
        var adapter = {
            addClass: function (className) { return _this.root.classList.add(className); },
            removeClass: function (className) { return _this.root.classList.remove(className); },
            getWidth: function () { return (0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_1__.estimateScrollWidth)(_this.root); },
            registerInteractionHandler: function (evtType, handler) {
                return _this.listen(evtType, handler);
            },
            deregisterInteractionHandler: function (evtType, handler) {
                return _this.unlisten(evtType, handler);
            },
        };
        // tslint:enable:object-literal-sort-keys
        return new _foundation__WEBPACK_IMPORTED_MODULE_2__.MDCFloatingLabelFoundation(adapter);
    };
    return MDCFloatingLabel;
}(_material_base_component__WEBPACK_IMPORTED_MODULE_3__.MDCComponent));

//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/floating-label/constants.js":
/*!************************************************************!*\
  !*** ./node_modules/@material/floating-label/constants.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cssClasses": () => (/* binding */ cssClasses)
/* harmony export */ });
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var cssClasses = {
    LABEL_FLOAT_ABOVE: 'mdc-floating-label--float-above',
    LABEL_REQUIRED: 'mdc-floating-label--required',
    LABEL_SHAKE: 'mdc-floating-label--shake',
    ROOT: 'mdc-floating-label',
};
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@material/floating-label/foundation.js":
/*!*************************************************************!*\
  !*** ./node_modules/@material/floating-label/foundation.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCFloatingLabelFoundation": () => (/* binding */ MDCFloatingLabelFoundation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_foundation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/base/foundation */ "./node_modules/@material/base/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/floating-label/constants.js");
/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



var MDCFloatingLabelFoundation = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCFloatingLabelFoundation, _super);
    function MDCFloatingLabelFoundation(adapter) {
        var _this = _super.call(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, MDCFloatingLabelFoundation.defaultAdapter), adapter)) || this;
        _this.shakeAnimationEndHandler_ = function () { return _this.handleShakeAnimationEnd_(); };
        return _this;
    }
    Object.defineProperty(MDCFloatingLabelFoundation, "cssClasses", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCFloatingLabelFoundation, "defaultAdapter", {
        /**
         * See {@link MDCFloatingLabelAdapter} for typing information on parameters and return types.
         */
        get: function () {
            // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
            return {
                addClass: function () { return undefined; },
                removeClass: function () { return undefined; },
                getWidth: function () { return 0; },
                registerInteractionHandler: function () { return undefined; },
                deregisterInteractionHandler: function () { return undefined; },
            };
            // tslint:enable:object-literal-sort-keys
        },
        enumerable: true,
        configurable: true
    });
    MDCFloatingLabelFoundation.prototype.init = function () {
        this.adapter.registerInteractionHandler('animationend', this.shakeAnimationEndHandler_);
    };
    MDCFloatingLabelFoundation.prototype.destroy = function () {
        this.adapter.deregisterInteractionHandler('animationend', this.shakeAnimationEndHandler_);
    };
    /**
     * Returns the width of the label element.
     */
    MDCFloatingLabelFoundation.prototype.getWidth = function () {
        return this.adapter.getWidth();
    };
    /**
     * Styles the label to produce a shake animation to indicate an error.
     * @param shouldShake If true, adds the shake CSS class; otherwise, removes shake class.
     */
    MDCFloatingLabelFoundation.prototype.shake = function (shouldShake) {
        var LABEL_SHAKE = MDCFloatingLabelFoundation.cssClasses.LABEL_SHAKE;
        if (shouldShake) {
            this.adapter.addClass(LABEL_SHAKE);
        }
        else {
            this.adapter.removeClass(LABEL_SHAKE);
        }
    };
    /**
     * Styles the label to float or dock.
     * @param shouldFloat If true, adds the float CSS class; otherwise, removes float and shake classes to dock the label.
     */
    MDCFloatingLabelFoundation.prototype.float = function (shouldFloat) {
        var _a = MDCFloatingLabelFoundation.cssClasses, LABEL_FLOAT_ABOVE = _a.LABEL_FLOAT_ABOVE, LABEL_SHAKE = _a.LABEL_SHAKE;
        if (shouldFloat) {
            this.adapter.addClass(LABEL_FLOAT_ABOVE);
        }
        else {
            this.adapter.removeClass(LABEL_FLOAT_ABOVE);
            this.adapter.removeClass(LABEL_SHAKE);
        }
    };
    /**
     * Styles the label as required.
     * @param isRequired If true, adds an asterisk to the label, indicating that it is required.
     */
    MDCFloatingLabelFoundation.prototype.setRequired = function (isRequired) {
        var LABEL_REQUIRED = MDCFloatingLabelFoundation.cssClasses.LABEL_REQUIRED;
        if (isRequired) {
            this.adapter.addClass(LABEL_REQUIRED);
        }
        else {
            this.adapter.removeClass(LABEL_REQUIRED);
        }
    };
    MDCFloatingLabelFoundation.prototype.handleShakeAnimationEnd_ = function () {
        var LABEL_SHAKE = MDCFloatingLabelFoundation.cssClasses.LABEL_SHAKE;
        this.adapter.removeClass(LABEL_SHAKE);
    };
    return MDCFloatingLabelFoundation;
}(_material_base_foundation__WEBPACK_IMPORTED_MODULE_2__.MDCFoundation));

// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MDCFloatingLabelFoundation);
//# sourceMappingURL=foundation.js.map

/***/ }),

/***/ "./node_modules/@material/form-field/component.js":
/*!********************************************************!*\
  !*** ./node_modules/@material/form-field/component.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCFormField": () => (/* binding */ MDCFormField)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/base/component */ "./node_modules/@material/base/component.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/form-field/foundation.js");
/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



var MDCFormField = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCFormField, _super);
    function MDCFormField() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MDCFormField.attachTo = function (root) {
        return new MDCFormField(root);
    };
    MDCFormField.prototype.labelEl = function () {
        var LABEL_SELECTOR = _foundation__WEBPACK_IMPORTED_MODULE_1__.MDCFormFieldFoundation.strings.LABEL_SELECTOR;
        return this.root.querySelector(LABEL_SELECTOR);
    };
    MDCFormField.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        var adapter = {
            activateInputRipple: function () {
                if (_this.input && _this.input.ripple) {
                    _this.input.ripple.activate();
                }
            },
            deactivateInputRipple: function () {
                if (_this.input && _this.input.ripple) {
                    _this.input.ripple.deactivate();
                }
            },
            deregisterInteractionHandler: function (evtType, handler) {
                var labelEl = _this.labelEl();
                if (labelEl) {
                    labelEl.removeEventListener(evtType, handler);
                }
            },
            registerInteractionHandler: function (evtType, handler) {
                var labelEl = _this.labelEl();
                if (labelEl) {
                    labelEl.addEventListener(evtType, handler);
                }
            },
        };
        return new _foundation__WEBPACK_IMPORTED_MODULE_1__.MDCFormFieldFoundation(adapter);
    };
    return MDCFormField;
}(_material_base_component__WEBPACK_IMPORTED_MODULE_2__.MDCComponent));

//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/form-field/constants.js":
/*!********************************************************!*\
  !*** ./node_modules/@material/form-field/constants.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cssClasses": () => (/* binding */ cssClasses),
/* harmony export */   "strings": () => (/* binding */ strings)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var cssClasses = {
    ROOT: 'mdc-form-field',
};
var strings = {
    LABEL_SELECTOR: '.mdc-form-field > label',
};
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@material/form-field/foundation.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material/form-field/foundation.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCFormFieldFoundation": () => (/* binding */ MDCFormFieldFoundation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_foundation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/base/foundation */ "./node_modules/@material/base/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/form-field/constants.js");
/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



var MDCFormFieldFoundation = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCFormFieldFoundation, _super);
    function MDCFormFieldFoundation(adapter) {
        var _this = _super.call(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, MDCFormFieldFoundation.defaultAdapter), adapter)) || this;
        _this.click = function () {
            _this.handleClick();
        };
        return _this;
    }
    Object.defineProperty(MDCFormFieldFoundation, "cssClasses", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCFormFieldFoundation, "strings", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.strings;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCFormFieldFoundation, "defaultAdapter", {
        get: function () {
            return {
                activateInputRipple: function () { return undefined; },
                deactivateInputRipple: function () { return undefined; },
                deregisterInteractionHandler: function () { return undefined; },
                registerInteractionHandler: function () { return undefined; },
            };
        },
        enumerable: true,
        configurable: true
    });
    MDCFormFieldFoundation.prototype.init = function () {
        this.adapter.registerInteractionHandler('click', this.click);
    };
    MDCFormFieldFoundation.prototype.destroy = function () {
        this.adapter.deregisterInteractionHandler('click', this.click);
    };
    MDCFormFieldFoundation.prototype.handleClick = function () {
        var _this = this;
        this.adapter.activateInputRipple();
        requestAnimationFrame(function () {
            _this.adapter.deactivateInputRipple();
        });
    };
    return MDCFormFieldFoundation;
}(_material_base_foundation__WEBPACK_IMPORTED_MODULE_2__.MDCFoundation));

// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MDCFormFieldFoundation);
//# sourceMappingURL=foundation.js.map

/***/ }),

/***/ "./node_modules/@material/form-field/index.js":
/*!****************************************************!*\
  !*** ./node_modules/@material/form-field/index.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCFormField": () => (/* reexport safe */ _component__WEBPACK_IMPORTED_MODULE_0__.MDCFormField),
/* harmony export */   "cssClasses": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses),
/* harmony export */   "strings": () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_1__.strings),
/* harmony export */   "MDCFormFieldFoundation": () => (/* reexport safe */ _foundation__WEBPACK_IMPORTED_MODULE_2__.MDCFormFieldFoundation)
/* harmony export */ });
/* harmony import */ var _component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./component */ "./node_modules/@material/form-field/component.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/form-field/constants.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/form-field/foundation.js");
/**
 * @license
 * Copyright 2019 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



//# sourceMappingURL=index.js.map

/***/ }),

/***/ "./node_modules/@material/line-ripple/component.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material/line-ripple/component.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCLineRipple": () => (/* binding */ MDCLineRipple)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/base/component */ "./node_modules/@material/base/component.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/line-ripple/foundation.js");
/**
 * @license
 * Copyright 2018 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



var MDCLineRipple = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCLineRipple, _super);
    function MDCLineRipple() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MDCLineRipple.attachTo = function (root) {
        return new MDCLineRipple(root);
    };
    /**
     * Activates the line ripple
     */
    MDCLineRipple.prototype.activate = function () {
        this.foundation.activate();
    };
    /**
     * Deactivates the line ripple
     */
    MDCLineRipple.prototype.deactivate = function () {
        this.foundation.deactivate();
    };
    /**
     * Sets the transform origin given a user's click location.
     * The `rippleCenter` is the x-coordinate of the middle of the ripple.
     */
    MDCLineRipple.prototype.setRippleCenter = function (xCoordinate) {
        this.foundation.setRippleCenter(xCoordinate);
    };
    MDCLineRipple.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take a Partial<MDCFooAdapter>.
        // To ensure we don't accidentally omit any methods, we need a separate, strongly typed adapter variable.
        // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
        var adapter = {
            addClass: function (className) { return _this.root.classList.add(className); },
            removeClass: function (className) { return _this.root.classList.remove(className); },
            hasClass: function (className) { return _this.root.classList.contains(className); },
            setStyle: function (propertyName, value) { return _this.root.style.setProperty(propertyName, value); },
            registerEventHandler: function (evtType, handler) { return _this.listen(evtType, handler); },
            deregisterEventHandler: function (evtType, handler) { return _this.unlisten(evtType, handler); },
        };
        // tslint:enable:object-literal-sort-keys
        return new _foundation__WEBPACK_IMPORTED_MODULE_1__.MDCLineRippleFoundation(adapter);
    };
    return MDCLineRipple;
}(_material_base_component__WEBPACK_IMPORTED_MODULE_2__.MDCComponent));

//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/line-ripple/constants.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material/line-ripple/constants.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cssClasses": () => (/* binding */ cssClasses)
/* harmony export */ });
/**
 * @license
 * Copyright 2018 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var cssClasses = {
    LINE_RIPPLE_ACTIVE: 'mdc-line-ripple--active',
    LINE_RIPPLE_DEACTIVATING: 'mdc-line-ripple--deactivating',
};

//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@material/line-ripple/foundation.js":
/*!**********************************************************!*\
  !*** ./node_modules/@material/line-ripple/foundation.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCLineRippleFoundation": () => (/* binding */ MDCLineRippleFoundation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_foundation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/base/foundation */ "./node_modules/@material/base/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/line-ripple/constants.js");
/**
 * @license
 * Copyright 2018 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



var MDCLineRippleFoundation = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCLineRippleFoundation, _super);
    function MDCLineRippleFoundation(adapter) {
        var _this = _super.call(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, MDCLineRippleFoundation.defaultAdapter), adapter)) || this;
        _this.transitionEndHandler_ = function (evt) { return _this.handleTransitionEnd(evt); };
        return _this;
    }
    Object.defineProperty(MDCLineRippleFoundation, "cssClasses", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCLineRippleFoundation, "defaultAdapter", {
        /**
         * See {@link MDCLineRippleAdapter} for typing information on parameters and return types.
         */
        get: function () {
            // tslint:disable:object-literal-sort-keys Methods should be in the same order as the adapter interface.
            return {
                addClass: function () { return undefined; },
                removeClass: function () { return undefined; },
                hasClass: function () { return false; },
                setStyle: function () { return undefined; },
                registerEventHandler: function () { return undefined; },
                deregisterEventHandler: function () { return undefined; },
            };
            // tslint:enable:object-literal-sort-keys
        },
        enumerable: true,
        configurable: true
    });
    MDCLineRippleFoundation.prototype.init = function () {
        this.adapter.registerEventHandler('transitionend', this.transitionEndHandler_);
    };
    MDCLineRippleFoundation.prototype.destroy = function () {
        this.adapter.deregisterEventHandler('transitionend', this.transitionEndHandler_);
    };
    MDCLineRippleFoundation.prototype.activate = function () {
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LINE_RIPPLE_DEACTIVATING);
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LINE_RIPPLE_ACTIVE);
    };
    MDCLineRippleFoundation.prototype.setRippleCenter = function (xCoordinate) {
        this.adapter.setStyle('transform-origin', xCoordinate + "px center");
    };
    MDCLineRippleFoundation.prototype.deactivate = function () {
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LINE_RIPPLE_DEACTIVATING);
    };
    MDCLineRippleFoundation.prototype.handleTransitionEnd = function (evt) {
        // Wait for the line ripple to be either transparent or opaque
        // before emitting the animation end event
        var isDeactivating = this.adapter.hasClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LINE_RIPPLE_DEACTIVATING);
        if (evt.propertyName === 'opacity') {
            if (isDeactivating) {
                this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LINE_RIPPLE_ACTIVE);
                this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LINE_RIPPLE_DEACTIVATING);
            }
        }
    };
    return MDCLineRippleFoundation;
}(_material_base_foundation__WEBPACK_IMPORTED_MODULE_2__.MDCFoundation));

// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MDCLineRippleFoundation);
//# sourceMappingURL=foundation.js.map

/***/ }),

/***/ "./node_modules/@material/linear-progress/component.js":
/*!*************************************************************!*\
  !*** ./node_modules/@material/linear-progress/component.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCLinearProgress": () => (/* binding */ MDCLinearProgress)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/base/component */ "./node_modules/@material/base/component.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/linear-progress/foundation.js");
/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */



var MDCLinearProgress = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCLinearProgress, _super);
    function MDCLinearProgress() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MDCLinearProgress.attachTo = function (root) {
        return new MDCLinearProgress(root);
    };
    Object.defineProperty(MDCLinearProgress.prototype, "determinate", {
        set: function (value) {
            this.foundation.setDeterminate(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCLinearProgress.prototype, "progress", {
        set: function (value) {
            this.foundation.setProgress(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCLinearProgress.prototype, "buffer", {
        set: function (value) {
            this.foundation.setBuffer(value);
        },
        enumerable: true,
        configurable: true
    });
    MDCLinearProgress.prototype.open = function () {
        this.foundation.open();
    };
    MDCLinearProgress.prototype.close = function () {
        this.foundation.close();
    };
    MDCLinearProgress.prototype.initialSyncWithDOM = function () {
        var _this = this;
        this.root.addEventListener('transitionend', function () {
            _this.foundation.handleTransitionEnd();
        });
    };
    MDCLinearProgress.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take
        // a Partial<MDCFooAdapter>. To ensure we don't accidentally omit any
        // methods, we need a separate, strongly typed adapter variable.
        var adapter = {
            addClass: function (className) {
                _this.root.classList.add(className);
            },
            forceLayout: function () {
                _this.root.getBoundingClientRect();
            },
            setBufferBarStyle: function (styleProperty, value) {
                var bufferBar = _this.root.querySelector(_foundation__WEBPACK_IMPORTED_MODULE_1__.MDCLinearProgressFoundation.strings.BUFFER_BAR_SELECTOR);
                if (bufferBar) {
                    bufferBar.style.setProperty(styleProperty, value);
                }
            },
            setPrimaryBarStyle: function (styleProperty, value) {
                var primaryBar = _this.root.querySelector(_foundation__WEBPACK_IMPORTED_MODULE_1__.MDCLinearProgressFoundation.strings.PRIMARY_BAR_SELECTOR);
                if (primaryBar) {
                    primaryBar.style.setProperty(styleProperty, value);
                }
            },
            hasClass: function (className) { return _this.root.classList.contains(className); },
            removeAttribute: function (attributeName) {
                _this.root.removeAttribute(attributeName);
            },
            removeClass: function (className) {
                _this.root.classList.remove(className);
            },
            setAttribute: function (attributeName, value) {
                _this.root.setAttribute(attributeName, value);
            },
            setStyle: function (name, value) {
                _this.root.style.setProperty(name, value);
            },
            attachResizeObserver: function (callback) {
                var RO = window.ResizeObserver;
                if (RO) {
                    var ro = new RO(callback);
                    ro.observe(_this.root);
                    return ro;
                }
                return null;
            },
            getWidth: function () { return _this.root.offsetWidth; },
        };
        return new _foundation__WEBPACK_IMPORTED_MODULE_1__.MDCLinearProgressFoundation(adapter);
    };
    return MDCLinearProgress;
}(_material_base_component__WEBPACK_IMPORTED_MODULE_2__.MDCComponent));

//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/linear-progress/constants.js":
/*!*************************************************************!*\
  !*** ./node_modules/@material/linear-progress/constants.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cssClasses": () => (/* binding */ cssClasses),
/* harmony export */   "strings": () => (/* binding */ strings),
/* harmony export */   "animationDimensionPercentages": () => (/* binding */ animationDimensionPercentages)
/* harmony export */ });
/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var cssClasses = {
    CLOSED_CLASS: 'mdc-linear-progress--closed',
    CLOSED_ANIMATION_OFF_CLASS: 'mdc-linear-progress--closed-animation-off',
    INDETERMINATE_CLASS: 'mdc-linear-progress--indeterminate',
    REVERSED_CLASS: 'mdc-linear-progress--reversed',
    ANIMATION_READY_CLASS: 'mdc-linear-progress--animation-ready',
};
var strings = {
    ARIA_VALUEMAX: 'aria-valuemax',
    ARIA_VALUEMIN: 'aria-valuemin',
    ARIA_VALUENOW: 'aria-valuenow',
    BUFFER_BAR_SELECTOR: '.mdc-linear-progress__buffer-bar',
    FLEX_BASIS: 'flex-basis',
    PRIMARY_BAR_SELECTOR: '.mdc-linear-progress__primary-bar',
};
// these are percentages pulled from keyframes.scss
var animationDimensionPercentages = {
    PRIMARY_HALF: .8367142,
    PRIMARY_FULL: 2.00611057,
    SECONDARY_QUARTER: .37651913,
    SECONDARY_HALF: .84386165,
    SECONDARY_FULL: 1.60277782,
};
//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@material/linear-progress/foundation.js":
/*!**************************************************************!*\
  !*** ./node_modules/@material/linear-progress/foundation.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCLinearProgressFoundation": () => (/* binding */ MDCLinearProgressFoundation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_animation_util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/animation/util */ "./node_modules/@material/animation/util.js");
/* harmony import */ var _material_base_foundation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/base/foundation */ "./node_modules/@material/base/foundation.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/linear-progress/constants.js");
/**
 * @license
 * Copyright 2017 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */




var MDCLinearProgressFoundation = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCLinearProgressFoundation, _super);
    function MDCLinearProgressFoundation(adapter) {
        var _this = _super.call(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, MDCLinearProgressFoundation.defaultAdapter), adapter)) || this;
        _this.observer = null;
        return _this;
    }
    Object.defineProperty(MDCLinearProgressFoundation, "cssClasses", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCLinearProgressFoundation, "strings", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.strings;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCLinearProgressFoundation, "defaultAdapter", {
        get: function () {
            return {
                addClass: function () { return undefined; },
                attachResizeObserver: function () { return null; },
                forceLayout: function () { return undefined; },
                getWidth: function () { return 0; },
                hasClass: function () { return false; },
                setBufferBarStyle: function () { return null; },
                setPrimaryBarStyle: function () { return null; },
                setStyle: function () { return undefined; },
                removeAttribute: function () { return undefined; },
                removeClass: function () { return undefined; },
                setAttribute: function () { return undefined; },
            };
        },
        enumerable: true,
        configurable: true
    });
    MDCLinearProgressFoundation.prototype.init = function () {
        var _this = this;
        this.isDeterminate = !this.adapter.hasClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.INDETERMINATE_CLASS);
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.ANIMATION_READY_CLASS);
        this.progress = 0;
        this.buffer = 1;
        this.observer = this.adapter.attachResizeObserver(function (entries) {
            var e_1, _a;
            if (_this.isDeterminate) {
                return;
            }
            try {
                for (var entries_1 = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__values)(entries), entries_1_1 = entries_1.next(); !entries_1_1.done; entries_1_1 = entries_1.next()) {
                    var entry = entries_1_1.value;
                    if (entry.contentRect) {
                        _this.calculateAndSetDimensions(entry.contentRect.width);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (entries_1_1 && !entries_1_1.done && (_a = entries_1.return)) _a.call(entries_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
        });
        if (!this.isDeterminate && this.observer) {
            this.calculateAndSetDimensions(this.adapter.getWidth());
        }
    };
    MDCLinearProgressFoundation.prototype.setDeterminate = function (isDeterminate) {
        this.isDeterminate = isDeterminate;
        if (this.isDeterminate) {
            this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.INDETERMINATE_CLASS);
            this.adapter.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_VALUENOW, this.progress.toString());
            this.adapter.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_VALUEMAX, '1');
            this.adapter.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_VALUEMIN, '0');
            this.setPrimaryBarProgress(this.progress);
            this.setBufferBarProgress(this.buffer);
            return;
        }
        if (this.observer) {
            this.calculateAndSetDimensions(this.adapter.getWidth());
        }
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.INDETERMINATE_CLASS);
        this.adapter.removeAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_VALUENOW);
        this.adapter.removeAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_VALUEMAX);
        this.adapter.removeAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_VALUEMIN);
        this.setPrimaryBarProgress(1);
        this.setBufferBarProgress(1);
    };
    MDCLinearProgressFoundation.prototype.getDeterminate = function () {
        return this.isDeterminate;
    };
    MDCLinearProgressFoundation.prototype.setProgress = function (value) {
        this.progress = value;
        if (this.isDeterminate) {
            this.setPrimaryBarProgress(value);
            this.adapter.setAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_VALUENOW, value.toString());
        }
    };
    MDCLinearProgressFoundation.prototype.getProgress = function () {
        return this.progress;
    };
    MDCLinearProgressFoundation.prototype.setBuffer = function (value) {
        this.buffer = value;
        if (this.isDeterminate) {
            this.setBufferBarProgress(value);
        }
    };
    MDCLinearProgressFoundation.prototype.open = function () {
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.CLOSED_CLASS);
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.CLOSED_ANIMATION_OFF_CLASS);
    };
    MDCLinearProgressFoundation.prototype.close = function () {
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.CLOSED_CLASS);
    };
    /**
     * Handles the transitionend event emitted after `close()` is called and the
     * opacity fades out. This is so that animations are removed only after the
     * progress indicator is completely hidden.
     */
    MDCLinearProgressFoundation.prototype.handleTransitionEnd = function () {
        if (this.adapter.hasClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.CLOSED_CLASS)) {
            this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.CLOSED_ANIMATION_OFF_CLASS);
        }
    };
    MDCLinearProgressFoundation.prototype.destroy = function () {
        _super.prototype.destroy.call(this);
        if (this.observer) {
            this.observer.disconnect();
        }
    };
    MDCLinearProgressFoundation.prototype.restartAnimation = function () {
        this.adapter.removeClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.ANIMATION_READY_CLASS);
        this.adapter.forceLayout();
        this.adapter.addClass(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.ANIMATION_READY_CLASS);
    };
    MDCLinearProgressFoundation.prototype.setPrimaryBarProgress = function (progressValue) {
        var value = "scaleX(" + progressValue + ")";
        // Accessing `window` without a `typeof` check will throw on Node
        // environments.
        var transformProp = typeof window !== 'undefined' ?
            (0,_material_animation_util__WEBPACK_IMPORTED_MODULE_2__.getCorrectPropertyName)(window, 'transform') :
            'transform';
        this.adapter.setPrimaryBarStyle(transformProp, value);
    };
    MDCLinearProgressFoundation.prototype.setBufferBarProgress = function (progressValue) {
        var value = progressValue * 100 + "%";
        this.adapter.setBufferBarStyle(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.FLEX_BASIS, value);
    };
    MDCLinearProgressFoundation.prototype.calculateAndSetDimensions = function (width) {
        var primaryHalf = width * _constants__WEBPACK_IMPORTED_MODULE_1__.animationDimensionPercentages.PRIMARY_HALF;
        var primaryFull = width * _constants__WEBPACK_IMPORTED_MODULE_1__.animationDimensionPercentages.PRIMARY_FULL;
        var secondaryQuarter = width * _constants__WEBPACK_IMPORTED_MODULE_1__.animationDimensionPercentages.SECONDARY_QUARTER;
        var secondaryHalf = width * _constants__WEBPACK_IMPORTED_MODULE_1__.animationDimensionPercentages.SECONDARY_HALF;
        var secondaryFull = width * _constants__WEBPACK_IMPORTED_MODULE_1__.animationDimensionPercentages.SECONDARY_FULL;
        this.adapter.setStyle('--mdc-linear-progress-primary-half', primaryHalf + "px");
        this.adapter.setStyle('--mdc-linear-progress-primary-half-neg', -primaryHalf + "px");
        this.adapter.setStyle('--mdc-linear-progress-primary-full', primaryFull + "px");
        this.adapter.setStyle('--mdc-linear-progress-primary-full-neg', -primaryFull + "px");
        this.adapter.setStyle('--mdc-linear-progress-secondary-quarter', secondaryQuarter + "px");
        this.adapter.setStyle('--mdc-linear-progress-secondary-quarter-neg', -secondaryQuarter + "px");
        this.adapter.setStyle('--mdc-linear-progress-secondary-half', secondaryHalf + "px");
        this.adapter.setStyle('--mdc-linear-progress-secondary-half-neg', -secondaryHalf + "px");
        this.adapter.setStyle('--mdc-linear-progress-secondary-full', secondaryFull + "px");
        this.adapter.setStyle('--mdc-linear-progress-secondary-full-neg', -secondaryFull + "px");
        // need to restart animation for custom props to apply to keyframes
        this.restartAnimation();
    };
    return MDCLinearProgressFoundation;
}(_material_base_foundation__WEBPACK_IMPORTED_MODULE_3__.MDCFoundation));

// tslint:disable-next-line:no-default-export Needed for backward compatibility with MDC Web v0.44.0 and earlier.
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MDCLinearProgressFoundation);
//# sourceMappingURL=foundation.js.map

/***/ }),

/***/ "./node_modules/@material/list/component.js":
/*!**************************************************!*\
  !*** ./node_modules/@material/list/component.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCList": () => (/* binding */ MDCList)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @material/base/component */ "./node_modules/@material/base/component.js");
/* harmony import */ var _material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @material/dom/ponyfill */ "./node_modules/@material/dom/ponyfill.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/list/constants.js");
/* harmony import */ var _foundation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./foundation */ "./node_modules/@material/list/foundation.js");
/**
 * @license
 * Copyright 2018 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */





var MDCList = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCList, _super);
    function MDCList() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(MDCList.prototype, "vertical", {
        set: function (value) {
            this.foundation.setVerticalOrientation(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCList.prototype, "listElements", {
        get: function () {
            return Array.from(this.root.querySelectorAll("." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS]));
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCList.prototype, "wrapFocus", {
        set: function (value) {
            this.foundation.setWrapFocus(value);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCList.prototype, "typeaheadInProgress", {
        /**
         * @return Whether typeahead is currently matching a user-specified prefix.
         */
        get: function () {
            return this.foundation.isTypeaheadInProgress();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCList.prototype, "hasTypeahead", {
        /**
         * Sets whether typeahead functionality is enabled on the list.
         * @param hasTypeahead Whether typeahead is enabled.
         */
        set: function (hasTypeahead) {
            this.foundation.setHasTypeahead(hasTypeahead);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCList.prototype, "singleSelection", {
        set: function (isSingleSelectionList) {
            this.foundation.setSingleSelection(isSingleSelectionList);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCList.prototype, "selectedIndex", {
        get: function () {
            return this.foundation.getSelectedIndex();
        },
        set: function (index) {
            this.foundation.setSelectedIndex(index);
        },
        enumerable: true,
        configurable: true
    });
    MDCList.attachTo = function (root) {
        return new MDCList(root);
    };
    MDCList.prototype.initialSyncWithDOM = function () {
        this.isEvolutionEnabled =
            _constants__WEBPACK_IMPORTED_MODULE_1__.evolutionAttribute in this.root.dataset;
        this.classNameMap = this.isEvolutionEnabled ?
            _constants__WEBPACK_IMPORTED_MODULE_1__.evolutionClassNameMap :
            Object.values(_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses)
                .reduce(function (obj, className) {
                obj[className] = className;
                return obj;
            }, {});
        this.handleClick = this.handleClickEvent.bind(this);
        this.handleKeydown = this.handleKeydownEvent.bind(this);
        this.focusInEventListener = this.handleFocusInEvent.bind(this);
        this.focusOutEventListener = this.handleFocusOutEvent.bind(this);
        this.listen('keydown', this.handleKeydown);
        this.listen('click', this.handleClick);
        this.listen('focusin', this.focusInEventListener);
        this.listen('focusout', this.focusOutEventListener);
        this.layout();
        this.initializeListType();
        this.ensureFocusable();
    };
    MDCList.prototype.destroy = function () {
        this.unlisten('keydown', this.handleKeydown);
        this.unlisten('click', this.handleClick);
        this.unlisten('focusin', this.focusInEventListener);
        this.unlisten('focusout', this.focusOutEventListener);
    };
    MDCList.prototype.layout = function () {
        var direction = this.root.getAttribute(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_ORIENTATION);
        this.vertical = direction !== _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_ORIENTATION_HORIZONTAL;
        var itemSelector = "." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS] + ":not([tabindex])";
        var childSelector = "." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS] + " " + _constants__WEBPACK_IMPORTED_MODULE_1__.strings.FOCUSABLE_CHILD_ELEMENTS;
        // List items need to have at least tabindex=-1 to be focusable.
        Array.prototype.forEach.call(this.root.querySelectorAll(itemSelector), function (el) {
            el.setAttribute('tabindex', '-1');
        });
        // Child button/a elements are not tabbable until the list item is focused.
        Array.prototype.forEach.call(this.root.querySelectorAll(childSelector), function (el) {
            el.setAttribute('tabindex', '-1');
        });
        if (this.isEvolutionEnabled) {
            this.foundation.setUseSelectedAttribute(true);
        }
        this.foundation.layout();
    };
    /**
     * Extracts the primary text from a list item.
     * @param item The list item element.
     * @return The primary text in the element.
     */
    MDCList.prototype.getPrimaryText = function (item) {
        var _a;
        var primaryText = item.querySelector("." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_PRIMARY_TEXT_CLASS]);
        if (this.isEvolutionEnabled || primaryText) {
            return (_a = primaryText === null || primaryText === void 0 ? void 0 : primaryText.textContent) !== null && _a !== void 0 ? _a : '';
        }
        var singleLineText = item.querySelector("." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_TEXT_CLASS]);
        return (singleLineText && singleLineText.textContent) || '';
    };
    /**
     * Initialize selectedIndex value based on pre-selected list items.
     */
    MDCList.prototype.initializeListType = function () {
        var _this = this;
        this.isInteractive =
            (0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_2__.matches)(this.root, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_INTERACTIVE_ROLES_SELECTOR);
        if (this.isEvolutionEnabled && this.isInteractive) {
            var selection = Array.from(this.root.querySelectorAll(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.SELECTED_ITEM_SELECTOR), function (listItem) { return _this.listElements.indexOf(listItem); });
            if ((0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_2__.matches)(this.root, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_MULTI_SELECTABLE_SELECTOR)) {
                this.selectedIndex = selection;
            }
            else if (selection.length > 0) {
                this.selectedIndex = selection[0];
            }
            return;
        }
        var checkboxListItems = this.root.querySelectorAll(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_ROLE_CHECKBOX_SELECTOR);
        var radioSelectedListItem = this.root.querySelector(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_CHECKED_RADIO_SELECTOR);
        if (checkboxListItems.length) {
            var preselectedItems = this.root.querySelectorAll(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ARIA_CHECKED_CHECKBOX_SELECTOR);
            this.selectedIndex = Array.from(preselectedItems, function (listItem) { return _this.listElements.indexOf(listItem); });
        }
        else if (radioSelectedListItem) {
            this.selectedIndex = this.listElements.indexOf(radioSelectedListItem);
        }
    };
    /**
     * Updates the list item at itemIndex to the desired isEnabled state.
     * @param itemIndex Index of the list item
     * @param isEnabled Sets the list item to enabled or disabled.
     */
    MDCList.prototype.setEnabled = function (itemIndex, isEnabled) {
        this.foundation.setEnabled(itemIndex, isEnabled);
    };
    /**
     * Given the next desired character from the user, adds it to the typeahead
     * buffer. Then, attempts to find the next option matching the buffer. Wraps
     * around if at the end of options.
     *
     * @param nextChar The next character to add to the prefix buffer.
     * @param startingIndex The index from which to start matching. Defaults to
     *     the currently focused index.
     * @return The index of the matched item.
     */
    MDCList.prototype.typeaheadMatchItem = function (nextChar, startingIndex) {
        return this.foundation.typeaheadMatchItem(nextChar, startingIndex, /** skipFocus */ true);
    };
    MDCList.prototype.getDefaultFoundation = function () {
        var _this = this;
        // DO NOT INLINE this variable. For backward compatibility, foundations take
        // a Partial<MDCFooAdapter>. To ensure we don't accidentally omit any
        // methods, we need a separate, strongly typed adapter variable.
        var adapter = {
            addClassForElementIndex: function (index, className) {
                var element = _this.listElements[index];
                if (element) {
                    element.classList.add(_this.classNameMap[className]);
                }
            },
            focusItemAtIndex: function (index) {
                var element = _this.listElements[index];
                if (element) {
                    element.focus();
                }
            },
            getAttributeForElementIndex: function (index, attr) {
                return _this.listElements[index].getAttribute(attr);
            },
            getFocusedElementIndex: function () {
                return _this.listElements.indexOf(document.activeElement);
            },
            getListItemCount: function () { return _this.listElements.length; },
            getPrimaryTextAtIndex: function (index) {
                return _this.getPrimaryText(_this.listElements[index]);
            },
            hasCheckboxAtIndex: function (index) {
                var listItem = _this.listElements[index];
                return !!listItem.querySelector(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.CHECKBOX_SELECTOR);
            },
            hasRadioAtIndex: function (index) {
                var listItem = _this.listElements[index];
                return !!listItem.querySelector(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.RADIO_SELECTOR);
            },
            isCheckboxCheckedAtIndex: function (index) {
                var listItem = _this.listElements[index];
                var toggleEl = listItem.querySelector(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.CHECKBOX_SELECTOR);
                return toggleEl.checked;
            },
            isFocusInsideList: function () {
                return _this.root !== document.activeElement &&
                    _this.root.contains(document.activeElement);
            },
            isRootFocused: function () { return document.activeElement === _this.root; },
            listItemAtIndexHasClass: function (index, className) {
                return _this.listElements[index].classList.contains(_this.classNameMap[className]);
            },
            notifyAction: function (index) {
                _this.emit(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.ACTION_EVENT, { index: index }, /** shouldBubble */ true);
            },
            removeClassForElementIndex: function (index, className) {
                var element = _this.listElements[index];
                if (element) {
                    element.classList.remove(_this.classNameMap[className]);
                }
            },
            setAttributeForElementIndex: function (index, attr, value) {
                var element = _this.listElements[index];
                if (element) {
                    element.setAttribute(attr, value);
                }
            },
            setCheckedCheckboxOrRadioAtIndex: function (index, isChecked) {
                var listItem = _this.listElements[index];
                var toggleEl = listItem.querySelector(_constants__WEBPACK_IMPORTED_MODULE_1__.strings.CHECKBOX_RADIO_SELECTOR);
                toggleEl.checked = isChecked;
                var event = document.createEvent('Event');
                event.initEvent('change', true, true);
                toggleEl.dispatchEvent(event);
            },
            setTabIndexForListItemChildren: function (listItemIndex, tabIndexValue) {
                var element = _this.listElements[listItemIndex];
                var selector = "." + _this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS] + " " + _constants__WEBPACK_IMPORTED_MODULE_1__.strings.CHILD_ELEMENTS_TO_TOGGLE_TABINDEX;
                Array.prototype.forEach.call(element.querySelectorAll(selector), function (el) {
                    el.setAttribute('tabindex', tabIndexValue);
                });
            },
        };
        return new _foundation__WEBPACK_IMPORTED_MODULE_3__.MDCListFoundation(adapter);
    };
    /**
     * Ensures that at least one item is focusable if the list is interactive and
     * doesn't specify a suitable tabindex.
     */
    MDCList.prototype.ensureFocusable = function () {
        if (this.isEvolutionEnabled && this.isInteractive) {
            if (!this.root.querySelector("." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS] + "[tabindex=\"0\"]")) {
                var index = this.initialFocusIndex();
                if (index !== -1) {
                    this.listElements[index].tabIndex = 0;
                }
            }
        }
    };
    MDCList.prototype.initialFocusIndex = function () {
        if (this.selectedIndex instanceof Array && this.selectedIndex.length > 0) {
            return this.selectedIndex[0];
        }
        if (typeof this.selectedIndex === 'number' &&
            this.selectedIndex !== _constants__WEBPACK_IMPORTED_MODULE_1__.numbers.UNSET_INDEX) {
            return this.selectedIndex;
        }
        var el = this.root.querySelector("." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS] + ":not(." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_DISABLED_CLASS] + ")");
        if (el === null) {
            return -1;
        }
        return this.getListItemIndex(el);
    };
    /**
     * Used to figure out which list item this event is targetting. Or returns -1
     * if there is no list item
     */
    MDCList.prototype.getListItemIndex = function (el) {
        var nearestParent = (0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_2__.closest)(el, "." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS] + ", ." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.ROOT]);
        // Get the index of the element if it is a list item.
        if (nearestParent &&
            (0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_2__.matches)(nearestParent, "." + this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS])) {
            return this.listElements.indexOf(nearestParent);
        }
        return -1;
    };
    /**
     * Used to figure out which element was clicked before sending the event to
     * the foundation.
     */
    MDCList.prototype.handleFocusInEvent = function (evt) {
        var index = this.getListItemIndex(evt.target);
        this.foundation.handleFocusIn(evt, index);
    };
    /**
     * Used to figure out which element was clicked before sending the event to
     * the foundation.
     */
    MDCList.prototype.handleFocusOutEvent = function (evt) {
        var index = this.getListItemIndex(evt.target);
        this.foundation.handleFocusOut(evt, index);
    };
    /**
     * Used to figure out which element was focused when keydown event occurred
     * before sending the event to the foundation.
     */
    MDCList.prototype.handleKeydownEvent = function (evt) {
        var index = this.getListItemIndex(evt.target);
        var target = evt.target;
        this.foundation.handleKeydown(evt, target.classList.contains(this.classNameMap[_constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_CLASS]), index);
    };
    /**
     * Used to figure out which element was clicked before sending the event to
     * the foundation.
     */
    MDCList.prototype.handleClickEvent = function (evt) {
        var index = this.getListItemIndex(evt.target);
        var target = evt.target;
        // Toggle the checkbox only if it's not the target of the event, or the
        // checkbox will have 2 change events.
        var toggleCheckbox = !(0,_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_2__.matches)(target, _constants__WEBPACK_IMPORTED_MODULE_1__.strings.CHECKBOX_RADIO_SELECTOR);
        this.foundation.handleClick(index, toggleCheckbox);
    };
    return MDCList;
}(_material_base_component__WEBPACK_IMPORTED_MODULE_4__.MDCComponent));

//# sourceMappingURL=component.js.map

/***/ }),

/***/ "./node_modules/@material/list/constants.js":
/*!**************************************************!*\
  !*** ./node_modules/@material/list/constants.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "strings": () => (/* binding */ strings),
/* harmony export */   "cssClasses": () => (/* binding */ cssClasses),
/* harmony export */   "numbers": () => (/* binding */ numbers),
/* harmony export */   "evolutionAttribute": () => (/* binding */ evolutionAttribute),
/* harmony export */   "evolutionClassNameMap": () => (/* binding */ evolutionClassNameMap)
/* harmony export */ });
/**
 * @license
 * Copyright 2018 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var _a;
var cssClasses = {
    LIST_ITEM_ACTIVATED_CLASS: 'mdc-list-item--activated',
    LIST_ITEM_CLASS: 'mdc-list-item',
    LIST_ITEM_DISABLED_CLASS: 'mdc-list-item--disabled',
    LIST_ITEM_SELECTED_CLASS: 'mdc-list-item--selected',
    LIST_ITEM_TEXT_CLASS: 'mdc-list-item__text',
    LIST_ITEM_PRIMARY_TEXT_CLASS: 'mdc-list-item__primary-text',
    ROOT: 'mdc-list',
};
var strings = {
    ACTION_EVENT: 'MDCList:action',
    ARIA_CHECKED: 'aria-checked',
    ARIA_CHECKED_CHECKBOX_SELECTOR: '[role="checkbox"][aria-checked="true"]',
    ARIA_CHECKED_RADIO_SELECTOR: '[role="radio"][aria-checked="true"]',
    ARIA_CURRENT: 'aria-current',
    ARIA_DISABLED: 'aria-disabled',
    ARIA_ORIENTATION: 'aria-orientation',
    ARIA_ORIENTATION_HORIZONTAL: 'horizontal',
    ARIA_ROLE_CHECKBOX_SELECTOR: '[role="checkbox"]',
    ARIA_SELECTED: 'aria-selected',
    ARIA_INTERACTIVE_ROLES_SELECTOR: '[role="listbox"], [role="menu"]',
    ARIA_MULTI_SELECTABLE_SELECTOR: '[aria-multiselectable="true"]',
    CHECKBOX_RADIO_SELECTOR: 'input[type="checkbox"], input[type="radio"]',
    CHECKBOX_SELECTOR: 'input[type="checkbox"]',
    CHILD_ELEMENTS_TO_TOGGLE_TABINDEX: 'button:not(:disabled), a',
    FOCUSABLE_CHILD_ELEMENTS: 'button:not(:disabled), a, input[type="radio"]:not(:disabled), input[type="checkbox"]:not(:disabled)',
    RADIO_SELECTOR: 'input[type="radio"]',
    SELECTED_ITEM_SELECTOR: '[aria-selected="true"], [aria-current="true"]',
};
var numbers = {
    UNSET_INDEX: -1,
    TYPEAHEAD_BUFFER_CLEAR_TIMEOUT_MS: 300
};
var evolutionClassNameMap = (_a = {},
    _a["" + cssClasses.LIST_ITEM_ACTIVATED_CLASS] = 'mdc-evolution-list-item--activated',
    _a["" + cssClasses.LIST_ITEM_CLASS] = 'mdc-evolution-list-item',
    _a["" + cssClasses.LIST_ITEM_DISABLED_CLASS] = 'mdc-evolution-list-item--disabled',
    _a["" + cssClasses.LIST_ITEM_SELECTED_CLASS] = 'mdc-evolution-list-item--selected',
    _a["" + cssClasses.LIST_ITEM_PRIMARY_TEXT_CLASS] = 'mdc-evolution-list-item__primary-text',
    _a["" + cssClasses.ROOT] = 'mdc-evolution-list',
    _a);
var evolutionAttribute = 'evolution';

//# sourceMappingURL=constants.js.map

/***/ }),

/***/ "./node_modules/@material/list/events.js":
/*!***********************************************!*\
  !*** ./node_modules/@material/list/events.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "preventDefaultEvent": () => (/* binding */ preventDefaultEvent)
/* harmony export */ });
/**
 * @license
 * Copyright 2020 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
var ELEMENTS_KEY_ALLOWED_IN = ['input', 'button', 'textarea', 'select'];
/**
 * Ensures that preventDefault is only called if the containing element
 * doesn't consume the event, and it will cause an unintended scroll.
 *
 * @param evt keyboard event to be prevented.
 */
var preventDefaultEvent = function (evt) {
    var target = evt.target;
    if (!target) {
        return;
    }
    var tagName = ("" + target.tagName).toLowerCase();
    if (ELEMENTS_KEY_ALLOWED_IN.indexOf(tagName) === -1) {
        evt.preventDefault();
    }
};
//# sourceMappingURL=events.js.map

/***/ }),

/***/ "./node_modules/@material/list/foundation.js":
/*!***************************************************!*\
  !*** ./node_modules/@material/list/foundation.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MDCListFoundation": () => (/* binding */ MDCListFoundation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _material_base_foundation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @material/base/foundation */ "./node_modules/@material/base/foundation.js");
/* harmony import */ var _material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @material/dom/keyboard */ "./node_modules/@material/dom/keyboard.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "./node_modules/@material/list/constants.js");
/* harmony import */ var _events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./events */ "./node_modules/@material/list/events.js");
/* harmony import */ var _typeahead__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./typeahead */ "./node_modules/@material/list/typeahead.js");
/**
 * @license
 * Copyright 2018 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// TODO(b/152410470): Remove trailing underscores from private properties
// tslint:disable:strip-private-property-underscore





function isNumberArray(selectedIndex) {
    return selectedIndex instanceof Array;
}
var MDCListFoundation = /** @class */ (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__extends)(MDCListFoundation, _super);
    function MDCListFoundation(adapter) {
        var _this = _super.call(this, (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_0__.__assign)({}, MDCListFoundation.defaultAdapter), adapter)) || this;
        _this.wrapFocus_ = false;
        _this.isVertical_ = true;
        _this.isSingleSelectionList_ = false;
        _this.selectedIndex_ = _constants__WEBPACK_IMPORTED_MODULE_1__.numbers.UNSET_INDEX;
        _this.focusedItemIndex = _constants__WEBPACK_IMPORTED_MODULE_1__.numbers.UNSET_INDEX;
        _this.useActivatedClass_ = false;
        _this.useSelectedAttr_ = false;
        _this.ariaCurrentAttrValue_ = null;
        _this.isCheckboxList_ = false;
        _this.isRadioList_ = false;
        _this.hasTypeahead = false;
        // Transiently holds current typeahead prefix from user.
        _this.typeaheadState = _typeahead__WEBPACK_IMPORTED_MODULE_2__.initState();
        _this.sortedIndexByFirstChar = new Map();
        return _this;
    }
    Object.defineProperty(MDCListFoundation, "strings", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.strings;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCListFoundation, "cssClasses", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCListFoundation, "numbers", {
        get: function () {
            return _constants__WEBPACK_IMPORTED_MODULE_1__.numbers;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MDCListFoundation, "defaultAdapter", {
        get: function () {
            return {
                addClassForElementIndex: function () { return undefined; },
                focusItemAtIndex: function () { return undefined; },
                getAttributeForElementIndex: function () { return null; },
                getFocusedElementIndex: function () { return 0; },
                getListItemCount: function () { return 0; },
                hasCheckboxAtIndex: function () { return false; },
                hasRadioAtIndex: function () { return false; },
                isCheckboxCheckedAtIndex: function () { return false; },
                isFocusInsideList: function () { return false; },
                isRootFocused: function () { return false; },
                listItemAtIndexHasClass: function () { return false; },
                notifyAction: function () { return undefined; },
                removeClassForElementIndex: function () { return undefined; },
                setAttributeForElementIndex: function () { return undefined; },
                setCheckedCheckboxOrRadioAtIndex: function () { return undefined; },
                setTabIndexForListItemChildren: function () { return undefined; },
                getPrimaryTextAtIndex: function () { return ''; },
            };
        },
        enumerable: true,
        configurable: true
    });
    MDCListFoundation.prototype.layout = function () {
        if (this.adapter.getListItemCount() === 0) {
            return;
        }
        // TODO(b/172274142): consider all items when determining the list's type.
        if (this.adapter.hasCheckboxAtIndex(0)) {
            this.isCheckboxList_ = true;
        }
        else if (this.adapter.hasRadioAtIndex(0)) {
            this.isRadioList_ = true;
        }
        else {
            this.maybeInitializeSingleSelection();
        }
        if (this.hasTypeahead) {
            this.sortedIndexByFirstChar = this.typeaheadInitSortedIndex();
        }
    };
    /**
     * Sets the private wrapFocus_ variable.
     */
    MDCListFoundation.prototype.setWrapFocus = function (value) {
        this.wrapFocus_ = value;
    };
    /**
     * Sets the isVertical_ private variable.
     */
    MDCListFoundation.prototype.setVerticalOrientation = function (value) {
        this.isVertical_ = value;
    };
    /**
     * Sets the isSingleSelectionList_ private variable.
     */
    MDCListFoundation.prototype.setSingleSelection = function (value) {
        this.isSingleSelectionList_ = value;
        if (value) {
            this.maybeInitializeSingleSelection();
        }
    };
    /**
     * Automatically determines whether the list is single selection list. If so,
     * initializes the internal state to match the selected item.
     */
    MDCListFoundation.prototype.maybeInitializeSingleSelection = function () {
        var listItemsCount = this.adapter.getListItemCount();
        for (var i = 0; i < listItemsCount; i++) {
            var hasSelectedClass = this.adapter.listItemAtIndexHasClass(i, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_SELECTED_CLASS);
            var hasActivatedClass = this.adapter.listItemAtIndexHasClass(i, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_ACTIVATED_CLASS);
            if (!(hasSelectedClass || hasActivatedClass)) {
                continue;
            }
            if (hasActivatedClass) {
                this.setUseActivatedClass(true);
            }
            this.isSingleSelectionList_ = true;
            this.selectedIndex_ = i;
            return;
        }
    };
    /**
     * Sets whether typeahead is enabled on the list.
     * @param hasTypeahead Whether typeahead is enabled.
     */
    MDCListFoundation.prototype.setHasTypeahead = function (hasTypeahead) {
        this.hasTypeahead = hasTypeahead;
        if (hasTypeahead) {
            this.sortedIndexByFirstChar = this.typeaheadInitSortedIndex();
        }
    };
    /**
     * @return Whether typeahead is currently matching a user-specified prefix.
     */
    MDCListFoundation.prototype.isTypeaheadInProgress = function () {
        return this.hasTypeahead &&
            _typeahead__WEBPACK_IMPORTED_MODULE_2__.isTypingInProgress(this.typeaheadState);
    };
    /**
     * Sets the useActivatedClass_ private variable.
     */
    MDCListFoundation.prototype.setUseActivatedClass = function (useActivated) {
        this.useActivatedClass_ = useActivated;
    };
    /**
     * Sets the useSelectedAttr_ private variable.
     */
    MDCListFoundation.prototype.setUseSelectedAttribute = function (useSelected) {
        this.useSelectedAttr_ = useSelected;
    };
    MDCListFoundation.prototype.getSelectedIndex = function () {
        return this.selectedIndex_;
    };
    MDCListFoundation.prototype.setSelectedIndex = function (index) {
        if (!this.isIndexValid_(index)) {
            return;
        }
        if (this.isCheckboxList_) {
            this.setCheckboxAtIndex_(index);
        }
        else if (this.isRadioList_) {
            this.setRadioAtIndex_(index);
        }
        else {
            this.setSingleSelectionAtIndex_(index);
        }
    };
    /**
     * Focus in handler for the list items.
     */
    MDCListFoundation.prototype.handleFocusIn = function (_, listItemIndex) {
        if (listItemIndex >= 0) {
            this.focusedItemIndex = listItemIndex;
            this.adapter.setAttributeForElementIndex(listItemIndex, 'tabindex', '0');
            this.adapter.setTabIndexForListItemChildren(listItemIndex, '0');
        }
    };
    /**
     * Focus out handler for the list items.
     */
    MDCListFoundation.prototype.handleFocusOut = function (_, listItemIndex) {
        var _this = this;
        if (listItemIndex >= 0) {
            this.adapter.setAttributeForElementIndex(listItemIndex, 'tabindex', '-1');
            this.adapter.setTabIndexForListItemChildren(listItemIndex, '-1');
        }
        /**
         * Between Focusout & Focusin some browsers do not have focus on any
         * element. Setting a delay to wait till the focus is moved to next element.
         */
        setTimeout(function () {
            if (!_this.adapter.isFocusInsideList()) {
                _this.setTabindexToFirstSelectedOrFocusedItem();
            }
        }, 0);
    };
    /**
     * Key handler for the list.
     */
    MDCListFoundation.prototype.handleKeydown = function (event, isRootListItem, listItemIndex) {
        var _this = this;
        var isArrowLeft = (0,_material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__.normalizeKey)(event) === 'ArrowLeft';
        var isArrowUp = (0,_material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__.normalizeKey)(event) === 'ArrowUp';
        var isArrowRight = (0,_material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__.normalizeKey)(event) === 'ArrowRight';
        var isArrowDown = (0,_material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__.normalizeKey)(event) === 'ArrowDown';
        var isHome = (0,_material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__.normalizeKey)(event) === 'Home';
        var isEnd = (0,_material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__.normalizeKey)(event) === 'End';
        var isEnter = (0,_material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__.normalizeKey)(event) === 'Enter';
        var isSpace = (0,_material_dom_keyboard__WEBPACK_IMPORTED_MODULE_3__.normalizeKey)(event) === 'Spacebar';
        // Have to check both upper and lower case, because having caps lock on affects the value.
        var isLetterA = event.key === 'A' || event.key === 'a';
        if (this.adapter.isRootFocused()) {
            if (isArrowUp || isEnd) {
                event.preventDefault();
                this.focusLastElement();
            }
            else if (isArrowDown || isHome) {
                event.preventDefault();
                this.focusFirstElement();
            }
            if (this.hasTypeahead) {
                var handleKeydownOpts = {
                    event: event,
                    focusItemAtIndex: function (index) {
                        _this.focusItemAtIndex(index);
                    },
                    focusedItemIndex: -1,
                    isTargetListItem: isRootListItem,
                    sortedIndexByFirstChar: this.sortedIndexByFirstChar,
                    isItemAtIndexDisabled: function (index) {
                        return _this.adapter.listItemAtIndexHasClass(index, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_DISABLED_CLASS);
                    },
                };
                _typeahead__WEBPACK_IMPORTED_MODULE_2__.handleKeydown(handleKeydownOpts, this.typeaheadState);
            }
            return;
        }
        var currentIndex = this.adapter.getFocusedElementIndex();
        if (currentIndex === -1) {
            currentIndex = listItemIndex;
            if (currentIndex < 0) {
                // If this event doesn't have a mdc-list-item ancestor from the
                // current list (not from a sublist), return early.
                return;
            }
        }
        if ((this.isVertical_ && isArrowDown) ||
            (!this.isVertical_ && isArrowRight)) {
            (0,_events__WEBPACK_IMPORTED_MODULE_4__.preventDefaultEvent)(event);
            this.focusNextElement(currentIndex);
        }
        else if ((this.isVertical_ && isArrowUp) || (!this.isVertical_ && isArrowLeft)) {
            (0,_events__WEBPACK_IMPORTED_MODULE_4__.preventDefaultEvent)(event);
            this.focusPrevElement(currentIndex);
        }
        else if (isHome) {
            (0,_events__WEBPACK_IMPORTED_MODULE_4__.preventDefaultEvent)(event);
            this.focusFirstElement();
        }
        else if (isEnd) {
            (0,_events__WEBPACK_IMPORTED_MODULE_4__.preventDefaultEvent)(event);
            this.focusLastElement();
        }
        else if (isLetterA && event.ctrlKey && this.isCheckboxList_) {
            event.preventDefault();
            this.toggleAll(this.selectedIndex_ === _constants__WEBPACK_IMPORTED_MODULE_1__.numbers.UNSET_INDEX ? [] : this.selectedIndex_);
        }
        else if (isEnter || isSpace) {
            if (isRootListItem) {
                // Return early if enter key is pressed on anchor element which triggers
                // synthetic MouseEvent event.
                var target = event.target;
                if (target && target.tagName === 'A' && isEnter) {
                    return;
                }
                (0,_events__WEBPACK_IMPORTED_MODULE_4__.preventDefaultEvent)(event);
                if (this.adapter.listItemAtIndexHasClass(currentIndex, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_DISABLED_CLASS)) {
                    return;
                }
                if (!this.isTypeaheadInProgress()) {
                    if (this.isSelectableList_()) {
                        this.setSelectedIndexOnAction_(currentIndex);
                    }
                    this.adapter.notifyAction(currentIndex);
                }
            }
        }
        if (this.hasTypeahead) {
            var handleKeydownOpts = {
                event: event,
                focusItemAtIndex: function (index) {
                    _this.focusItemAtIndex(index);
                },
                focusedItemIndex: this.focusedItemIndex,
                isTargetListItem: isRootListItem,
                sortedIndexByFirstChar: this.sortedIndexByFirstChar,
                isItemAtIndexDisabled: function (index) { return _this.adapter.listItemAtIndexHasClass(index, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_DISABLED_CLASS); },
            };
            _typeahead__WEBPACK_IMPORTED_MODULE_2__.handleKeydown(handleKeydownOpts, this.typeaheadState);
        }
    };
    /**
     * Click handler for the list.
     */
    MDCListFoundation.prototype.handleClick = function (index, toggleCheckbox) {
        if (index === _constants__WEBPACK_IMPORTED_MODULE_1__.numbers.UNSET_INDEX) {
            return;
        }
        if (this.adapter.listItemAtIndexHasClass(index, _constants__WEBPACK_IMPORTED_MODULE_1__.cssClasses.LIST_ITEM_DISABLED_CLASS)) {
            return;
        }
        if (this.isSelectableList_()) {
            this.setSelectedIndexOnAction_(index, toggleCheckbox);
        }
        this.adapter.notifyAction(index);
    };
    /**
     * Focuses the next element on the list.
     */
    MDCListFoundation.prototype.focusNextElement = function (index) {
        var count = this.adapter.getListItemCount();
        var nextIndex = index + 1;
        if (nextIndex >= count) {
            if (this.wrapFocus_) {
                nextIndex = 0;
            }
            else {
                // Return early because last item is already focused.
                return index;
            }
        }
        this.focusItemAtIndex(nextIndex);
        return nextIndex;
    };
    /**
     * Focuses the previous element on the list.
     */
    MDCListFoundation.prototype.focusPrevElement = function (index) {
        var prevIndex = index - 1;
        if (prevIndex < 0) {
            if (this.wrapFocus_) {
                prevIndex = this.adapter.getListItemCount() - 1;
            }
            else {
                // Return early because first item is a